#
# Copyright 2013 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

from __future__ import absolute_import
from __future__ import division

import libvirt

UP = 'Up'
DOWN = 'Down'
MIGRATION_SOURCE = 'Migration Source'
MIGRATION_DESTINATION = 'Migration Destination'
PAUSED = 'Paused'
POWERING_DOWN = 'Powering down'
POWERING_UP = 'Powering up'
REBOOT_IN_PROGRESS = 'RebootInProgress'
RESTORING_STATE = 'Restoring state'
SAVING_STATE = 'Saving State'
WAIT_FOR_LAUNCH = 'WaitForLaunch'

PAUSED_STATES = (POWERING_DOWN, REBOOT_IN_PROGRESS, UP)

LIBVIRT_DOWN_STATES = (
    libvirt.VIR_DOMAIN_SHUTOFF,
    libvirt.VIR_DOMAIN_CRASHED,
)
