# Copyright 2013 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

from __future__ import absolute_import
from ..utils import getHostUUID
from . import expose, ExtraArgsError
import sys


@expose("vdsm-id")
def getUUID(*args):
    """
    vdsm-id
    Printing host uuid
    """
    if len(args) > 1:
        raise ExtraArgsError()
    hostUUID = getHostUUID(False)
    if hostUUID is None:
        raise EnvironmentError('Cannot retrieve host UUID')
    sys.stdout.write(hostUUID + '\n')
    return 0
