# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%global _ovirtwebuidir %{_datarootdir}/ovirt-web-ui
%global _ovirt_engine_conf %{_datarootdir}/ovirt-engine/services/ovirt-engine/ovirt-engine.conf
%global _ovirt_engine_ear_application_xml %{_datarootdir}/ovirt-engine/engine.ear/META-INF/application.xml
%global product oVirt

%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

## %global source_basename ovirt-web-ui-0.1.2
%global source_basename ovirt-web-ui

Name:           ovirt-web-ui
Version:        0.1.2
Release:        4%{?release_suffix}%{?checkout}%{?dist}
Summary:        User Portal for %{product}
License:        ASL 2.0
URL:            https://github.com/oVirt/ovirt-web-ui
Source0:        https://github.com/oVirt/ovirt-web-ui/archive/%{source_basename}-0.1.2.tar.gz

ExclusiveArch:  x86_64

# Keep ovirt-engine-{nodejs|nodejs-modules|yarn} at particular version unless tested on higher
# Please keep in sync with the automation/*.req files
BuildRequires: ovirt-engine-nodejs = 6.9.4
BuildRequires: ovirt-engine-yarn = 0.19.1

# contains ovirt-ui-components-0.2.1
BuildRequires: ovirt-engine-nodejs-modules = 1.0.7 

%description
This package provides new User Portal for %{product}, so far as technical preview.

%prep
# Use the ovirt-engine nodejs installation
# export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"

%setup -q -n"%{source_basename}-%{version}"
rpm -qa | grep ovirt-engine-nodejs
source /usr/share/ovirt-engine-nodejs-modules/setup-env.sh

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:%{_datadir}/ovirt-engine-yarn/bin:${PATH}"
%configure
export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

%files
%doc README.md 
%license LICENSE
%{_ovirtwebuidir}
%{_datarootdir}/ovirt-engine/ovirt-web-ui.war
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-web-ui.conf

%changelog
* Mon Feb 20 2017 Marek Libra <mlibra@redhat.com> - 0.1.2
- Minor UI fixes, npm replaced by yarn
* Fri Dec 16 2016 Marek Libra <mlibra@redhat.com> - 0.1.1
- Minor UI fixes, authorizedRedirect.jsp
* Mon Nov 14 2016 Marek Libra <mlibra@redhat.com> - 0.1.0
- First version, Technical Preview
