# Used for rpm-packaging of pre-bundled application with already resolved JS dependencies
%define use_vdsm %( test -z @VDSM@ && echo 1 || echo 0)

%global _userportaldir %{_datarootdir}/ovirt-web-ui
%global _ovirt_engine_conf %{_datarootdir}/ovirt-engine/services/ovirt-engine/ovirt-engine.conf
%global _ovirt_engine_ear_application_xml %{_datarootdir}/ovirt-engine/engine.ear/META-INF/application.xml
%global product oVirt

%global use_rhev %( test -z @RHEV@ && echo 1 || echo 0)
%define debug_package %{nil}

## %global source_basename ovirt-web-ui-0.1.1
%global source_basename ovirt-web-ui

Name:           ovirt-web-ui
Version:        0.1.1
Release:        2%{?release_suffix}%{?checkout}%{?dist}
Summary:        User Portal for %{product}
License:        ASL 2.0
URL:            https://github.com/mareklibra/userportal
Source0:        https://github.com/mareklibra/userportal/archive/%{source_basename}-0.1.1.tar.gz

ExclusiveArch:  x86_64

BuildRequires: ovirt-engine-nodejs = 6.9.1
# Keep ovirt-engine-nodejs-modules at particular version unless tested on higher
BuildRequires: ovirt-engine-nodejs-modules = 0.0.17

%description
This package provides new User Portal for %{product}, so far as technical preview.

%prep
# Use the ovirt-engine nodejs installation
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%setup -q -n"%{source_basename}-%{version}"
# Copy the Node.js dependencies to the local "node_modules" directory
ln -s "%{_sharedstatedir}/ovirt-engine-nodejs-modules/node_modules"

%build
export PATH="%{_datadir}/ovirt-engine-nodejs/bin:${PATH}"
%configure
export PATH="./node_modules/.bin:${PATH}"
make

%install
make install DESTDIR=%{buildroot}

%files
%doc README.md 
%license LICENSE
%{_userportaldir}
%{_datarootdir}/ovirt-engine/ovirt-web-ui.war
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-ovirt-web-ui.conf

%changelog
* Fri Dec 16 2016 Marek Libra <mlibra@redhat.com> - 0.1.1
- Minor UI fixes, authorizedRedirect.jsp
* Mon Nov 14 2016 Marek Libra <mlibra@redhat.com> - 0.1.0
- First version, Technical Preview
