%global logdir /var/log/ovirt-imageio
%global user ovirtimg
%global group ovirtimg

%global srcname ovirt_imageio

Name:      ovirt-imageio
Version:   2.0.5
Release:   0%{?dist}
Summary:   oVirt imageio

Group:     Development/Libraries
License:   GPLv2+
Url:       https://gerrit.ovirt.org/ovirt-imageio
Source0:   http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{version}.tar.gz

%description
Image data transfer on oVirt virtualization hosts.

%prep
%setup -q

%build
%py3_build

%install
%py3_install
install -D -m 0755 --directory %{buildroot}%{logdir}
# Create a dummy log file to make rpm happy during build
touch %{buildroot}%{logdir}/daemon.log
install -D -m 0755 --directory %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/logger.conf %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/daemon.conf.sample %{buildroot}%{_sysconfdir}/%{name}
install -D -m 0644 data/ovirt-imageio.service %{buildroot}%{_unitdir}/ovirt-imageio.service

%clean
rm -rf $RPM_BUILD_ROOT


%package common
Summary:   oVirt imageio library

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: gcc
BuildRequires: python3-devel

# NOTE: keep in sync with automation/check.packages
Requires:  python3
Requires:  python3-six
Requires:  qemu-img

%description common
Common library for image data transfer on oVirt virtualization hosts.

%files common
%license COPYING
%{python3_sitearch}/%{srcname}
%{python3_sitearch}/%{srcname}-*.egg-info


%package daemon
Summary:   oVirt imageio daemon

# NOTE: keep in sync with automation/build-artifacts.packages
BuildRequires: systemd

# NOTE: keep in sync with automation/check.packages
Requires:  ovirt-imageio-common
Requires:  python3-systemd


%description daemon
Daemon to manage image data transfer on oVirt virtualization hosts.

%files daemon
%{_bindir}/ovirt-imageio
%{_unitdir}/ovirt-imageio.service
%dir %{_sysconfdir}/%{name}
%config %{_sysconfdir}/%{name}/logger.conf
%{_sysconfdir}/%{name}/daemon.conf.sample
# The log directory should belong to the daemon so it can create log files.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-ATTR-DIRECTIVE
%dir %attr(755, %{user}, %{group}) %{logdir}
# The log files belongs to the package, so they will be removed with the package.
# http://rpm.org/max-rpm-snapshot/s1-rpm-inside-files-list-directives.html#S3-RPM-INSIDE-FLIST-GHOST-DIRECTIVE
%ghost %attr(644, %{user}, %{group}) %{logdir}/daemon.log*

# For more information about the systemd macros, see:
# https://fedoraproject.org/wiki/Packaging:Scriptlets#New_Packages
# For info on ordering of the scriplets, see:
# https://docs.fedoraproject.org/en-US/packaging-guidelines/Scriptlets/#ordering

%pre daemon
# Create a user and group if needed
if ! /usr/bin/getent passwd %{user} >/dev/null; then
    /usr/sbin/useradd --system \
        --user-group \
        --shell /sbin/nologin \
        --home-dir /run/ovirt-imageio \
        --comment "oVirt imageio" \
        %{user}
fi

%post daemon
# After installation, synchronize service state with preset files.
%systemd_post ovirt-imageio.service

%preun daemon
# Before uninstalling, stop and disable the service.
%systemd_preun ovirt-imageio.service

%postun daemon
# After upgrading, restart the service.
%systemd_postun_with_restart ovirt-imageio.service

%posttrans daemon
# At the end of the transaction, stop stale ovirt-imageio-daemon service.
# Needed only when upgrading from ovirt-imagei-daemon < 2.
if systemctl is-active ovirt-imageio-daemon.service >/dev/null; then
    echo "Stopping ovirt-imageio-daemon.service";
    systemctl stop ovirt-imageio-daemon.service
fi

%changelog

* Fri Apr 17 2020 Nir Soffer <nsoffer@redhat.com> 2.0.4-0
- Support starting as root
