/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.servers;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.ovirt.engine.api.resource.openstack.OpenstackImagesResource;
import org.ovirt.engine.api.v3.V3Server;
import org.ovirt.engine.api.v3.types.V3OpenStackImages;

@Produces({"application/xml", "application/json"})
public class V3OpenstackImagesServer extends V3Server<OpenstackImagesResource> {
    public V3OpenstackImagesServer(OpenstackImagesResource delegate) {
        super(delegate);
    }

    @GET
    public V3OpenStackImages list() {
        return adaptList(getDelegate()::list);
    }

    @Path("{id}")
    public V3OpenstackImageServer getImageResource(@PathParam("id") String id) {
        return new V3OpenstackImageServer(getDelegate().getImageResource(id));
    }
}
