/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3OutAdapters.adaptOut;

import org.ovirt.engine.api.model.OpenStackImages;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3OpenStackImages;

public class V3OpenStackImagesOutAdapter implements V3Adapter<OpenStackImages, V3OpenStackImages> {
    @Override
    public V3OpenStackImages adapt(OpenStackImages from) {
        V3OpenStackImages to = new V3OpenStackImages();
        if (from.isSetActions()) {
            to.setActions(adaptOut(from.getActions()));
        }
        if (from.isSetActive()) {
            to.setActive(from.getActive());
        }
        if (from.isSetSize()) {
            to.setSize(from.getSize());
        }
        if (from.isSetTotal()) {
            to.setTotal(from.getTotal());
        }
        to.getOpenStackImages().addAll(adaptOut(from.getOpenStackImages()));
        return to;
    }
}
