/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3InAdapters.adaptIn;

import org.ovirt.engine.api.model.Disk;
import org.ovirt.engine.api.model.DiskFormat;
import org.ovirt.engine.api.model.DiskInterface;
import org.ovirt.engine.api.model.DiskStatus;
import org.ovirt.engine.api.model.DiskStorageType;
import org.ovirt.engine.api.model.ScsiGenericIO;
import org.ovirt.engine.api.model.Statistics;
import org.ovirt.engine.api.model.StorageDomains;
import org.ovirt.engine.api.model.Vms;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3Disk;

public class V3DiskInAdapter implements V3Adapter<V3Disk, Disk> {
    @Override
    public Disk adapt(V3Disk from) {
        Disk to = new Disk();
        if (from.isSetLinks()) {
            to.getLinks().addAll(adaptIn(from.getLinks()));
        }
        if (from.isSetActions()) {
            to.setActions(adaptIn(from.getActions()));
        }
        if (from.isSetActive()) {
            to.setActive(from.isActive());
        }
        if (from.isSetActualSize()) {
            to.setActualSize(from.getActualSize());
        }
        if (from.isSetAlias()) {
            to.setAlias(from.getAlias());
        }
        if (from.isSetComment()) {
            to.setComment(from.getComment());
        }
        if (from.isSetDescription()) {
            to.setDescription(from.getDescription());
        }
        if (from.isSetDiskProfile()) {
            to.setDiskProfile(adaptIn(from.getDiskProfile()));
        }
        if (from.isSetFormat()) {
            to.setFormat(DiskFormat.fromValue(from.getFormat()));
        }
        if (from.isSetId()) {
            to.setId(from.getId());
        }
        if (from.isSetHref()) {
            to.setHref(from.getHref());
        }
        if (from.isSetImageId()) {
            to.setImageId(from.getImageId());
        }
        if (from.isSetInstanceType()) {
            to.setInstanceType(adaptIn(from.getInstanceType()));
        }
        if (from.isSetLogicalName()) {
            to.setLogicalName(from.getLogicalName());
        }
        if (from.isSetLunStorage()) {
            to.setLunStorage(adaptIn(from.getLunStorage()));
        }
        if (from.isSetName()) {
            to.setName(from.getName());
        }
        if (from.isSetOpenstackVolumeType()) {
            to.setOpenstackVolumeType(adaptIn(from.getOpenstackVolumeType()));
        }
        if (from.isSetPropagateErrors()) {
            to.setPropagateErrors(from.isPropagateErrors());
        }
        if (from.isSetProvisionedSize()) {
            to.setProvisionedSize(from.getProvisionedSize());
        }
        if (from.isSetQuota()) {
            to.setQuota(adaptIn(from.getQuota()));
        }
        if (from.isSetReadOnly()) {
            to.setReadOnly(from.isReadOnly());
        }
        if (from.isSetSgio()) {
            to.setSgio(ScsiGenericIO.fromValue(from.getSgio()));
        }
        if (from.isSetShareable()) {
            to.setShareable(from.isShareable());
        }
        if (from.isSetSnapshot()) {
            to.setSnapshot(adaptIn(from.getSnapshot()));
        }
        if (from.isSetSparse()) {
            to.setSparse(from.isSparse());
        }
        if (from.isSetStatistics()) {
            to.setStatistics(new Statistics());
            to.getStatistics().getStatistics().addAll(adaptIn(from.getStatistics().getStatistics()));
        }
        if (from.isSetStatus() && from.getStatus().isSetState()) {
            to.setStatus(DiskStatus.fromValue(from.getStatus().getState()));
        }
        if (from.isSetStorageDomain()) {
            to.setStorageDomain(adaptIn(from.getStorageDomain()));
        }
        if (from.isSetStorageDomains()) {
            to.setStorageDomains(new StorageDomains());
            to.getStorageDomains().getStorageDomains().addAll(adaptIn(from.getStorageDomains().getStorageDomains()));
        }
        if (from.isSetStorageType()) {
            to.setStorageType(DiskStorageType.fromValue(from.getStorageType()));
        }
        if (from.isSetTemplate()) {
            to.setTemplate(adaptIn(from.getTemplate()));
        }
        if (from.isSetUsesScsiReservation()) {
            to.setUsesScsiReservation(from.isUsesScsiReservation());
        }
        if (from.isSetVm()) {
            to.setVm(adaptIn(from.getVm()));
        }
        if (from.isSetVms()) {
            to.setVms(new Vms());
            to.getVms().getVms().addAll(adaptIn(from.getVms().getVMs()));
        }
        if (from.isSetWipeAfterDelete()) {
            to.setWipeAfterDelete(from.isWipeAfterDelete());
        }

        if (from.isSetBootable()) {
            to.setBootable(from.isBootable());
        }

        if (from.isSetInterface()) {
            to.setInterface(DiskInterface.fromValue(from.getInterface()));
        }

        // In V3 "size" used to be a synonym of "provisioned_size":
        if (from.isSetSize() && !to.isSetProvisionedSize()) {
            to.setProvisionedSize(from.getSize());
        }

        return to;
    }
}
