/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3InAdapters.adaptIn;

import org.ovirt.engine.api.model.AuthorizedKeys;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3AuthorizedKeys;

public class V3AuthorizedKeysInAdapter implements V3Adapter<V3AuthorizedKeys, AuthorizedKeys> {
    @Override
    public AuthorizedKeys adapt(V3AuthorizedKeys from) {
        AuthorizedKeys to = new AuthorizedKeys();
        if (from.isSetActions()) {
            to.setActions(adaptIn(from.getActions()));
        }
        if (from.isSetActive()) {
            to.setActive(from.getActive());
        }
        if (from.isSetSize()) {
            to.setSize(from.getSize());
        }
        if (from.isSetTotal()) {
            to.setTotal(from.getTotal());
        }
        to.getAuthorizedKeys().addAll(adaptIn(from.getAuthorizedKeys()));
        return to;
    }
}
