

#
# CUSTOMIZATION-BEGIN
#
# ovirt_build_extra_flags
# ovirt_build_ut
%if 0%{?ovirt_build_quick}
%global _ovirt_build_ut 0
%global ovirt_build_gwt 0
%endif
%if 0%{?ovirt_build_minimal}
%global _ovirt_build_ut 0
%global ovirt_build_all_user_agents 0
%global ovirt_build_locales 0
%global _ovirt_build_extra_flags -D gwt.userAgent=gecko1_8
%endif
%if 0%{?ovirt_build_draft}
%global _ovirt_build_ut 0
%global ovirt_build_all_user_agents 0
%global ovirt_build_locales 0
%global _ovirt_build_extra_flags -D gwt.userAgent=gecko1_8 -P gwtdraft
%endif
%if 0%{!?ovirt_build_ut:1}
%if 0%{?_ovirt_build_ut:1}
%global ovirt_build_ut %{_ovirt_build_ut}
%else
%global ovirt_build_ut 1
%endif
%endif
%if 0%{!?ovirt_build_gwt:1}
%global ovirt_build_gwt 1
%endif
%if 0%{!?ovirt_build_locales:1}
%global ovirt_build_locales 1
%endif
%if 0%{!?ovirt_build_all_user_agents:1}
%global ovirt_build_all_user_agents 1
%endif
#
# CUSTOMIZATION-END
#

#
# Automatic byte compiling outside of /usr/lib(64)?/pythonX.Y/ should be used
# on Fedora 28+ and EL8 [1], but it would require too much work to support
# on EL7, so it's turned off
#
# [1] https://fedoraproject.org/wiki/Changes/No_more_automagic_Python_bytecompilation#How_we_are_changing_it
#
%if 0%{?fedora} || 0%{?rhel} >= 8
%global use_python_bytecompile 1
%global _python_bytecompile_extra 0
%else
%global use_python_bytecompile 0
%global _python_bytecompile_extra 1
%endif


# Do not repack .jar files, as it takes a long time and doesn't have a
# real benefit:
%global __jar_repack 0

#
# rpm does not support override
# nor modify of variables
#
%if %{?_ovirt_build_extra_flags:1}%{?ovirt_build_extra_flags:1}0
%global EXTRA_BUILD_FLAGS %{?_ovirt_build_extra_flags:%{_ovirt_build_extra_flags}}%{?ovirt_build_extra_flags: %{ovirt_build_extra_flags}}
%endif

#
# Supported distributions:
# Fedora >= 28
# EL >= 7
#

%global ovirt_install_poms 1
%global ovirt_provides_jboss 1
%if 0%{?fedora}
%global ovirt_rh_postgresql 0
%global postgresql_systemd_service postgresql.service
%else
%global ovirt_rh_postgresql 1
#The postgresql SCL service we can upgrade from
%global old_scl_pg_base rh-postgresql95
%global scl_pg_base rh-postgresql10
%global postgresql_systemd_service %{scl_pg_base}-postgresql.service
%endif

%global ovirt_product_name oVirt Engine
%global ovirt_product_name_short oVirt Engine
%global ovirt_product_group Virtualization/Management
%global ovirt_user_description oVirt Manager

%if 0%{?fedora}
%global policycoreutils_python_utils policycoreutils-python-utils
%else
%global policycoreutils_python_utils policycoreutils-python
%endif

%global engine_cache %{_localstatedir}/cache/%{engine_name}
%global engine_data %{_datadir}/%{engine_name}
%global engine_doc %{_docdir}/%{engine_name}
%global engine_ear %{engine_data}/engine.ear
%global engine_etc %{_sysconfdir}/%{engine_name}
%global engine_java %{_javadir}/%{engine_name}
%global engine_jboss_modules %{engine_data}/modules
%global engine_log %{_localstatedir}/log/%{engine_name}
%global engine_name ovirt-engine
%global engine_pki %{_sysconfdir}/pki/%{engine_name}
%global engine_restapi_war %{engine_data}/restapi.war
%global engine_apidoc_war %{engine_data}/apidoc.war
%global engine_run %{_localstatedir}/run/%{engine_name}
%global engine_state %{_localstatedir}/lib/%{engine_name}
%global engine_tmp %{_localstatedir}/tmp/%{engine_name}
%global engine_backup_default_dir  %{_localstatedir}/lib/%{engine_name}-backup
%global engine_backup_log_default_dir  %{_localstatedir}/log/%{engine_name}-backup
%global engine_rpm_state_dir  %{_localstatedir}/lib/rpm-state/%{name}
%global engine_setup_rpm_state_flag_file %{engine_rpm_state_dir}/need-engine-setup

%global engine_gid 108
%global engine_group ovirt
%global engine_uid 108
%global engine_user ovirt
%global vdsm_description Node Virtualization Manager
%global vdsm_gid 36
%global vdsm_group kvm
%global vdsm_uid 36
%global vdsm_user vdsm

%global openstack_java_version 3.2.5

# Macro to create an user:
#
# %1 user name
# %2 user id
# %3 primary group name
# %4 primary group id
# %5 description
# %6 home directory
#
%global _ovirt_create_user() \
getent group %3 >/dev/null || groupadd -r -g %4 %3; \
getent passwd %1 >/dev/null || useradd -r -u %2 -g %3 -c %5 -s /sbin/nologin -d %6 %1

%global ovirt_create_user_engine \
%_ovirt_create_user %{engine_user} %{engine_uid} %{engine_group} %{engine_gid} "%%{ovirt_user_description}" %{engine_state}

%global ovirt_create_user_vdsm \
%_ovirt_create_user %{vdsm_user} %{vdsm_uid} %{vdsm_group} %{vdsm_gid} "%%{vdsm_description}" /var/lib/vdsm

%if %{ovirt_provides_jboss}
%global wildfly_overlay_modules "/usr/share/ovirt-engine-wildfly-overlay/modules"
%else
%global wildfly_overlay_modules ""
%endif

# l,r are macro flags used to constract the correct python2 name
# only one flag should be provided in normal usage
# If you pass -l, then macro expands to: {l value}{all arguments}
# If you pass -r, then macro expands to: {all arguments}{r value}
%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%define required_python_lib(l:r:) python%{python3_pkgversion}-%{*}, python2-%{*}
%else
%global with_python3 0
%define required_python_lib(l:r:) %{-l*}%{*}%{-r*}
%endif

%global required_python_lib_ovirt_engine_lib %{required_python_lib -l python2- %{name}-lib >= %{version}-%{release}}
%global required_python_lib_jinja2 %{required_python_lib -l python- jinja2}
%global required_python_lib_ovirt_setup_lib %{required_python_lib ovirt-setup-lib >= 1.1.1}
%global required_python_lib_libxml2 %{required_python_lib -r -python libxml2}
%global required_python_lib_otopi %{required_python_lib -l python2- otopi >= 1.7.8}
%global required_python_lib_otopi_devtools %{required_python_lib -l python2- otopi-devtools >= 1.7.8}
%global required_python_lib_paramiko %{required_python_lib -l python- paramiko}
%global required_python_lib_libselinux %{required_python_lib -r -python libselinux}
%global required_python_lib_psycopg2 %{required_python_lib -l python- psycopg2}
%global required_python_lib_pwquality %{required_python_lib -l python- pwquality}
%global required_python_lib_dnf %{required_python_lib dnf}
%global required_python_lib_dateutil %{required_python_lib -l python- dateutil}
%global required_python_lib_netaddr %{required_python_lib -l python- netaddr}
%global required_python_lib_six %{required_python_lib -l python- six}
%global required_python_lib_numpy %{required_python_lib numpy}
%global required_python_lib_websockify %{required_python_lib -l python- websockify >= 0.6.0}
%if 0%{?fedora} || 0%{?rhel} >= 8
%global required_python_lib_m2crypto python3-m2crypto >= 0.28, m2crypto
%global required_package_manager %{required_python_lib_dnf}
%global required_package_manager_versionlock (yum-plugin-versionlock if yum), %{required_python_lib dnf-plugins-extras-versionlock}
%else
%global required_python_lib_m2crypto m2crypto
%global required_package_manager yum
%global required_package_manager_versionlock yum-plugin-versionlock
%endif

%if 0%{?rhel} >= 8
%global with_python2 0
%else
%global with_python2 1
%endif

%global make_common_opts \\\
	-j1 \\\
	BUILD_GWT=%{ovirt_build_gwt} \\\
	BUILD_ALL_USER_AGENTS=%{ovirt_build_all_user_agents} \\\
	BUILD_LOCALES=%{ovirt_build_locales} \\\
	BUILD_UT=%{ovirt_build_ut} \\\
	BUILD_VALIDATION=0 \\\
	PACKAGE_NAME=%{name} \\\
	RPM_VERSION=%{version} \\\
	RPM_RELEASE=%{release} \\\
	DISPLAY_VERSION=%{version}-%{release} \\\
	ENGINE_NAME=%{engine_name} \\\
	LOCALSTATE_DIR=%{_localstatedir} \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	BIN_DIR=%{_bindir} \\\
	PID_DIR=%{_localstatedir}/run \\\
	DATAROOT_DIR=%{_datadir} \\\
	MAN_DIR=%{_mandir} \\\
	DOC_DIR=%{_docdir} \\\
	PYTHON=%{__python2} \\\
	PYTHON_DIR=%{python2_sitelib} \\\
	%{?with_python3: PYTHON3=%{__python3}} \\\
	%{?with_python3: PYTHON3_DIR=%{python3_sitelib}} \\\
	JAVA_DIR=%{_javadir} \\\
	MAVENPOM_DIR=%{_mavenpomdir} \\\
	PKG_SYSCONF_DIR=%{engine_etc} \\\
	PKG_DOC_DIR=%{engine_doc} \\\
	PKG_EAR_DIR=%{engine_ear} \\\
	PKG_PKI_DIR=%{engine_pki} \\\
	PKG_JBOSS_MODULES=%{engine_jboss_modules} \\\
	PKG_CACHE_DIR=%{engine_cache} \\\
	PKG_LOG_DIR=%{engine_log} \\\
	PKG_BACKUP_DEFAULT_DIR=%{engine_backup_default_dir} \\\
	PKG_BACKUP_LOG_DEFAULT_DIR=%{engine_backup_log_default_dir} \\\
	PKG_TMP_DIR=%{engine_tmp} \\\
	PKG_STATE_DIR=%{engine_state} \\\
	PKG_USER=%{engine_user} \\\
	PKG_GROUP=%{engine_group} \\\
	POSTGRESQL_SYSTEMD_SERVICE=%{postgresql_systemd_service} \\\
	WILDFLY_OVERLAY_MODULES=%{wildfly_overlay_modules} \\\
	%{?EXTRA_BUILD_FLAGS:EXTRA_BUILD_FLAGS="%{EXTRA_BUILD_FLAGS}"}

Name:		ovirt-engine
Version:	4.3.4.1
Release:	1%{?release_suffix}%{?dist}
Summary:	Management server for Open Virtualization
Group:		%{ovirt_product_group}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-master-snapshot/src/ovirt-engine/ovirt-engine-4.3.4.1.tar.gz

BuildArch:	noarch

BuildRequires:	assertj-core >= 2.2.0
BuildRequires:	archaius-core
BuildRequires:	hystrix-core
BuildRequires:	hystrix-metrics-event-stream
BuildRequires:	rxjava
BuildRequires:	java-1.8.0-openjdk-devel >= 1:1.8.0
BuildRequires:	jpackage-utils
BuildRequires:	make
BuildRequires:	maven
BuildRequires:	python
BuildRequires:	python2-devel
%if 0%{?with_python3}
BuildRequires:	python3-devel
%endif
BuildRequires:	systemd
BuildRequires:	unzip

# TODO Replace add_maven_depmap and then remove. See also:
# https://lists.fedoraproject.org/archives/list/devel@lists.fedoraproject.org/message/R3KZ7VI5DPCMCELFIVJQ4AXB2WQED35C/
%if 0%{?fedora} >= 27
BuildRequires:	javapackages-local
%endif

Requires(pre):	shadow-utils

# There is no way how to prevent WildFly not being upgraded, so we need to
# fix engine to work with current and new WildFly version and only afterwards
# bump the requirement (otherwise we would need to pass wildfly,
# wildfly-overlay and ovirt-engine through the change queue at once)
%if %{ovirt_provides_jboss}
Requires:	ovirt-engine-wildfly-overlay >= 15.0.1
%endif

Requires:	%{name}-backend = %{version}-%{release}
Requires:	%{name}-dbscripts = %{version}-%{release}
Requires:	%{name}-restapi = %{version}-%{release}
Requires:	%{name}-tools = %{version}-%{release}
Requires:	%{name}-webadmin-portal = %{version}-%{release}
Requires:	%{name}-websocket-proxy >= %{version}-%{release}
Requires:	%{name}-vmconsole-proxy-helper >= %{version}-%{release}
Requires:	%{name}-ui-extensions >= 1.0.4
Requires:	ansible >= 2.7.2
Requires:	apache-commons-compress
Requires:	apache-commons-configuration
Requires:	apache-commons-jxpath
Requires:	archaius-core
Requires:	hystrix-core
Requires:	hystrix-metrics-event-stream
Requires:	jakarta-commons-httpclient
Requires:	java-1.8.0-openjdk-headless >= 1:1.8.0
Requires:	jpackage-utils
Requires:	objectweb-asm
Requires:	ovirt-iso-uploader >= 4.1.0
Requires:	rxjava
Requires:	slf4j >= 1.7.0
Requires:	ws-commons-util
Requires:	xmlrpc-client
Requires:	ovirt-ansible-roles >= 1.1.6
Requires:	ovirt-imageio-proxy
Requires:	ovirt-web-ui
Requires:	ovirt-cockpit-sso
Requires:	ovirt-engine-api-explorer

# Metrics stuff
Requires:	collectd
Requires:	collectd-postgresql
Requires:	collectd-disk
Requires:	collectd-write_http
%if 0%{?rhel}
# collectd-write_syslog is available only on EL7
Requires:	collectd-write_syslog
%endif


# Requirements for ovirt-engine-metrics
Requires:	rsyslog
Requires:	rsyslog-elasticsearch
Requires:	rsyslog-mmjsonparse
Requires:	rsyslog-mmnormalize
Requires:	libfastjson
Requires:	liblognorm
Requires:	libestr

%if 0%{?fedora}
# On Fedora we need newer JDBC drivers to be able to connect to PostgreSQL 10.
# Unfortunately this package is not available on EL7, so we are going to
# bundle it within engine until available.
Requires:	postgresql-jdbc >= 42.2.2
%endif

%if 0%{?rhel}
Requires:	%{required_package_manager_versionlock}
%endif

%if %{ovirt_rh_postgresql}
Requires:	%{scl_pg_base}-postgresql-server
Requires:	%{scl_pg_base}-postgresql-contrib
%else
Requires:	postgresql-server >= 10.0
Requires:	postgresql-contrib >= 10.0
%endif

Requires:	openstack-java-cinder-client >= %{openstack_java_version}
Requires:	openstack-java-cinder-model >= %{openstack_java_version}
Requires:	openstack-java-client >= %{openstack_java_version}
Requires:	openstack-java-glance-client >= %{openstack_java_version}
Requires:	openstack-java-glance-model >= %{openstack_java_version}
Requires:	openstack-java-keystone-client >= %{openstack_java_version}
Requires:	openstack-java-keystone-model >= %{openstack_java_version}
Requires:	openstack-java-quantum-client >= %{openstack_java_version}
Requires:	openstack-java-quantum-model >= %{openstack_java_version}
Requires:	openstack-java-resteasy-connector >= %{openstack_java_version}

%if 0%{?fedora}
Requires:	%{required_package_manager_versionlock}

%if 0%{?fedora} >= 29
Requires:	apache-sshd
%endif

Requires:	quartz
# On Fedora slf4j package is split and we need also jdk14 and jcl-over-slf4j
# parts
Requires:	slf4j-jdk14 >= 1.7.0
Requires:	jcl-over-slf4j >= 1.7.0
Requires:	snmp4j >= 2.4.1
%endif

Requires:	nimbus-jose-jwt >= 5.12
Requires:	json-smart >= 2.2

# We can't require exactly the same version and release of the
# setup package because it needs to be updated independently as part
# of the update process implemented in the engine-upgrade script:
Requires:	%{name}-setup >= %{version}-%{release}

# We can drop these conflicts when
# we drop Requires: mod_ssl
Conflicts:	freeipa-server
Conflicts:	ipa-server

# Userportal is retired
Obsoletes:	%{name}-userportal

# OVS/OVN stuff
Requires:	pyOpenSSL
Requires:	ovirt-provider-ovn >= 1.2.1

# JavaScript and CSS libraries are currently bundled
Provides:	 bundled(js-jquery) = 3.2.1

%description
%{ovirt_product_name} is a feature-rich server virtualization management
system that provides advanced capabilities for managing the Open
virtualization infrastructure for Servers and Desktops.

%package extensions-api-impl
Summary:	%{ovirt_product_name_short} extensions api
Group:		%{ovirt_product_group}
Provides:	ovirt-engine-extensions-api = 0

%description extensions-api-impl
%{ovirt_product_name_short} extensions api

%package extensions-api-impl-javadoc
Summary:	%{ovirt_product_name_short} extensions api documentation
Group:		%{ovirt_product_group}
Provides:	ovirt-engine-extensions-api-javadoc = 0

%description extensions-api-impl-javadoc
%{ovirt_product_name_short} extensions api documentation

%if 0%{with_python2}
%package -n python2-%{name}-lib
Summary:	%{ovirt_product_name_short} library
Group:		%{ovirt_product_group}
Requires:	m2crypto
Requires:	python-dateutil
Requires:	python-daemon
Conflicts:	python-daemon = 2.1.0
Provides:	%{name}-lib = %{version}-%{release}
Obsoletes:	%{name}-lib < %{version}-%{release}

%{?python_provide:%python_provide python2-%{name}-lib}

%description -n python2-%{name}-lib
%{ovirt_product_name_short} library for python2
%endif

%if 0%{with_python3}
%package -n python%{python3_pkgversion}-%{name}-lib
Summary:	%{ovirt_product_name_short} library
Group:		%{ovirt_product_group}
Requires:	python3-m2crypto >= 0.28
Requires:	python3-dateutil
Requires:	python3-daemon >= 2.1.2

%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}-lib}

%description -n python%{python3_pkgversion}-%{name}-lib
%{ovirt_product_name_short} library for python3
%endif

%package backend
Summary:	Engine core of %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
License:	ASL 2.0 and LGPLv3 and GPLv3
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-extensions-api-impl >= %{version}-%{release}
Requires:	aopalliance >= 1.0
Requires:	curl
Requires:	ebay-cors-filter
Requires:	httpd
Requires:	java-headless
Requires:	logrotate
Requires:	mailcap
Requires:	mod_ssl
%if 0%{?fedora} || 0%{?rhel} >= 8
Requires:	novnc
%else
Requires:	novnc >= 0.5.0, novnc < 0.6.0
%endif
Requires:	%{required_python_lib_ovirt_engine_lib}
Requires:	openssh
Requires:	vdsm-jsonrpc-java >= 1.4.17
Requires:	openssl
Requires:	ovirt-engine-extension-aaa-jdbc
Requires:	ovirt-host-deploy-java >= 1.7.3
Requires:	%{required_python_lib_jinja2}
Requires(pre):	shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%pre backend
%ovirt_create_user_engine

%post backend
%systemd_post ovirt-engine.service

%preun backend
%systemd_preun ovirt-engine.service

%postun backend
%systemd_postun ovirt-engine.service

%description backend
The backend engine of %{ovirt_product_name_short}

%package restapi
Summary:	RESTful API for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}

%description restapi
The RESTful API for %{ovirt_product_name_short}

%package setup-base
Summary:	%{ovirt_product_name_short} suite base setup components.
Group:		%{ovirt_product_group}
Requires:	%{required_python_lib_ovirt_engine_lib}
Requires:	%{required_python_lib_ovirt_setup_lib}
Requires:	bind-utils
Requires:	iproute
Requires:	%{required_python_lib_libxml2}
Requires:	logrotate
Requires:	%{required_python_lib_otopi}
Requires:	%{required_python_lib_paramiko}
Requires(pre):	shadow-utils
Conflicts:	%{name}-dwh < 4.2.0
Conflicts:	%{name}-dwh-setup < 4.3.0

%description setup-base
%{ovirt_product_name_short} suite base setup components.

%pre setup-base
%ovirt_create_user_engine

%package setup
Summary:	Setup and upgrade scripts for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}

%description setup
Setup and upgrade scripts for %{ovirt_product_name_short}

%post setup
# If this is an update, tell the users they need to run engine-setup
if [ $1 -gt 1 -a -e "%{_sysconfdir}/ovirt-engine-setup.conf.d/20-setup-ovirt-post.conf" ]; then
  touch %{engine_setup_rpm_state_flag_file}
  echo "Updating ovirt-engine-setup. To update the engine, you need to run: engine-setup"
fi

%posttrans setup
if [ -e %{engine_setup_rpm_state_flag_file} -a -e "%{_sysconfdir}/ovirt-engine-setup.conf.d/20-setup-ovirt-post.conf" ]; then
  echo "Updated ovirt-engine-setup. To update the engine, you need to run: engine-setup"
fi
rm -f %{engine_setup_rpm_state_flag_file}

%package setup-plugin-ovirt-engine
Summary:	Setup and upgrade specific plugins for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} >= 3.6.0
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	%{name}-setup-plugin-vmconsole-proxy-helper = %{version}-%{release}
Requires:	%{name}-setup-plugin-cinderlib = %{version}-%{release}
Requires:	%{name}-dwh-setup >= 4.2
Requires:	ovirt-engine-extension-aaa-jdbc
Requires:	ovirt-imageio-proxy-setup
Requires:	openssh
%if %{ovirt_rh_postgresql}
Requires:       %{scl_pg_base}-postgresql-server
Requires:       %{scl_pg_base}-postgresql-contrib
%else
Requires:       postgresql-server >= 10.0
Requires:       postgresql-contrib >= 10.0
%endif
Conflicts:	%{name} < 4.2.6
# See rhbz# 1676461
Requires:	ovirt-vmconsole >= 1.0.7

# OVS/OVN stuff, for firewalld service files
Requires:	openvswitch-ovn-central >= 0:2.7
Conflicts:	openvswitch-ovn-central = 1:2.6.1
Requires:	ovirt-provider-ovn >= 1.2.1

%description setup-plugin-ovirt-engine
Setup and upgrade specific plugins for %{ovirt_product_name_short}

%pre setup-plugin-ovirt-engine
%ovirt_create_user_vdsm

%package setup-plugin-ovirt-engine-common
Summary:	Setup and upgrade common plugins for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-base = %{version}-%{release}
Requires:	%{required_python_lib_libselinux}
Requires:	nfs-utils
Requires:	%{policycoreutils_python_utils}
Requires:	%{required_python_lib_psycopg2}
Requires(pre):	shadow-utils
Requires:	java-1.8.0-openjdk-headless >= 1:1.8.0
Requires:	%{required_python_lib_pwquality}
Requires:	%{required_python_lib_m2crypto}
Requires:	%{required_package_manager}

# We can drop these conflicts when
# we drop Requires: mod_ssl
# conflict here so we can avoid upgrade
# of setup at this environment, this
# will produce early error.
Conflicts:	ipa-server
Conflicts:	freeipa-server

%description setup-plugin-ovirt-engine-common
Setup and upgrade common plugins for %{ovirt_product_name_short}

%package dbscripts
Summary:	Database scripts for %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}

%description dbscripts
Database scripts for %{ovirt_product_name_short}


%package webadmin-portal
Summary:	Web Admin Portal of %{ovirt_product_name_short}
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}
# Bundled JavaScript and CSS libraries use MIT license.
License:	ASL 2.0 and GPLv2+ with exceptions and MIT

%description webadmin-portal
The web administration interface to %{ovirt_product_name_short}

%package tools
Summary:	%{ovirt_product_name_short} Tools
Group:		%{ovirt_product_group}
Requires:	%{name} = %{version}-%{release}
Requires:	%{required_python_lib_ovirt_engine_lib}
Requires:	%{name}-tools-backup = %{version}-%{release}
Requires:	ovirt-engine-metrics >= 1.1.2
Requires:	java-headless
Requires:	logrotate
Requires:	%{required_python_lib_dateutil}
Requires:	%{required_python_lib_netaddr}
Requires:	%{required_python_lib_psycopg2}
Requires:	%{required_python_lib_six}
Requires(pre):		shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%description tools
%{ovirt_product_name_short} Tools

%pre tools
%ovirt_create_user_engine

%post tools
%systemd_post ovirt-engine-notifier.service
%systemd_post ovirt-fence-kdump-listener.service

%postun tools
%systemd_postun ovirt-engine-notifier.service
%systemd_postun ovirt-fence-kdump-listener.service

%preun tools
%systemd_preun ovirt-engine-notifier.service
%systemd_preun ovirt-fence-kdump-listener.service

%package tools-backup
Summary:	%{ovirt_product_name_short} Tools (engine-backup)
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-plugin-ovirt-engine-common >= %{version}-%{release}
Requires:	tar
Requires:	bzip2
Requires:	xz
Requires:	%{required_python_lib_otopi}
%if %{ovirt_rh_postgresql}
Requires:	%{scl_pg_base}-postgresql
%else
Requires:	postgresql >= 10.0
%endif

%description tools-backup
%{ovirt_product_name_short} Tools (engine-backup)

%package websocket-proxy
Summary:	%{ovirt_product_name_short} Websocket Proxy
Group:		%{ovirt_product_group}
Requires:	%{required_python_lib_ovirt_engine_lib}
Requires:	%{required_python_lib_numpy}
Requires:	%{required_python_lib_dateutil}
Requires:	%{required_python_lib_websockify}
Requires:	%{name}-setup-plugin-websocket-proxy >= %{version}-%{release}
Requires(pre):		shadow-utils
Requires(post):		systemd
Requires(preun):	systemd
Requires(postun):	systemd

%description websocket-proxy
%{ovirt_product_name_short} Websocket Proxy

%pre websocket-proxy
%ovirt_create_user_engine

%post websocket-proxy
%systemd_post ovirt-websocket-proxy.service

%postun websocket-proxy
%systemd_postun ovirt-websocket-proxy.service

%preun websocket-proxy
%systemd_preun ovirt-websocket-proxy.service

%package setup-plugin-websocket-proxy
Summary:	Setup and upgrade specific plugins for websocket-proxy
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	%{required_python_lib_six}

%description setup-plugin-websocket-proxy
Setup and upgrade specific plugins for websocket-proxy

%package vmconsole-proxy-helper
Summary:	%{ovirt_product_name_short} VMconsole Proxy Helper
Group:		%{ovirt_product_group}
Requires:	%{required_python_lib_ovirt_engine_lib}
Requires:	%{name}-setup-plugin-vmconsole-proxy-helper >= %{version}-%{release}
Requires:	ovirt-vmconsole-proxy

%description vmconsole-proxy-helper
%{ovirt_product_name_short} VMconsole Proxy helper, to integrate
with ovirt-vmconsole-proxy package

%package setup-plugin-vmconsole-proxy-helper
Summary:	Setup and upgrade specific plugins for vmconsole-proxy-helper
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	openssh

%description setup-plugin-vmconsole-proxy-helper
Setup and upgrade specific plugins for vmconsole-proxy-helper

%package health-check-bundler
Summary:	%{ovirt_product_name_short} health check bundler.
Group:		%{ovirt_product_group}
Requires:	%{name}-setup-base = %{version}-%{release}
Requires:	makeself >= 2.2
Requires:	%{required_python_lib_otopi_devtools}

%description health-check-bundler
A utility for creating a bundle script that runs a health check.

%package setup-plugin-cinderlib
Summary:	Setup and upgrade specific plugins for cinderlib integration database
Requires:	%{name}-setup-plugin-ovirt-engine = %{version}-%{release}
Requires:	%{name}-setup-plugin-ovirt-engine-common = %{version}-%{release}
Requires:	openssh

%description setup-plugin-cinderlib
Setup and upgrade specific plugins for cinderlib integration database

%prep
%setup -c -q

%build

# Set the location of the JDK that will be used for compilation:
export JAVA_HOME="${JAVA_HOME:=/usr/lib/jvm/java-1.8.0}"

make %{make_common_opts}

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install DESTDIR="%{buildroot}"

# Remove files that relies on unavailable dependencies on python3
# FIXME: port these files to python3! they rely on python2-only modules right now.
%if 0%{?with_python3}
rm -f "%{buildroot}%{python3_sitelib}"/ovirt_engine/{service,ticket}.py
%endif

# Compile python files
%if 0%{?with_python2}

%if 0%{?use_python_bytecompile}
%py_byte_compile %{__python2} %{buildroot}%{engine_data}/
%py_byte_compile %{__python2} %{buildroot}%{_libexecdir}/
%endif

%{__python2} -m compileall -f -q -d "%{python2_sitelib}" "%{buildroot}%{python2_sitelib}"
%{__python2} -O -m compileall -f -q -d "%{python2_sitelib}" "%{buildroot}%{python2_sitelib}"
%endif

%if 0%{?with_python3}

%if 0%{?use_python_bytecompile}
%py_byte_compile %{__python3} %{buildroot}%{_libexecdir}/
%py_byte_compile %{__python3} %{buildroot}%{engine_data}/
%endif

%{__python3} -m compileall -f -q -d "%{python3_sitelib}" "%{buildroot}%{python3_sitelib}"
%{__python3} -O -m compileall -f -q -d "%{python3_sitelib}" "%{buildroot}%{python3_sitelib}"
%endif

#
# /var creation
#
install -dm 700 "%{buildroot}/%{engine_state}/.ssh"
install -dm 755 "%{buildroot}/%{engine_state}"/{content,setup/answers}
# see also relevant %%dir line to set permissions
install -dm 700 "%{buildroot}/%{engine_log}"
install -dm 700 "%{buildroot}/%{engine_log}"/{ova,host-deploy,setup,notifier,dump,ansible,db-manual,brick-setup,cinderlib}
install -dm 755 "%{buildroot}/%{engine_cache}"
install -dm 755 "%{buildroot}/%{engine_run}/notifier"

#
# Create oVirt SSH configuration as empty file. It will be used internally by internal Ansible execution.
#
touch "%{buildroot}/%{engine_state}/.ssh/config"

#
# Force TLS/SSL for selected applications.
#
for war in \
	"%{buildroot}%{engine_ear}"/{webadmin,enginesso,welcome}.war \
	"%{buildroot}%{engine_restapi_war}" \
	; do
	sed -i \
		-e 's#<transport-guarantee>NONE</transport-guarantee>#<transport-guarantee>CONFIDENTIAL</transport-guarantee>#' \
		-e 's#<secure>false</secure>#<secure>true</secure>#' \
		"${war}/WEB-INF/web.xml"
done

#
# Move jars to destribution location
#
install -dm 755 "%{buildroot}%{engine_java}"
while read lib_path; do
	java_path="%{engine_java}/$(basename "${lib_path}")"
	if ! [ -e "%{buildroot}/${java_path}" ] && [ -f "%{buildroot}/${lib_path}" ]; then
		cp "%{buildroot}/${lib_path}" "%{buildroot}/${java_path}"
	fi
	rm -f "%{buildroot}/${lib_path}"
	ln -s "${java_path}" "%{buildroot}${lib_path}"
done << __EOF__
%{engine_data}/logutils/logutils.jar
%{engine_ear}/bll.jar
%{engine_ear}/lib/vdsbroker.jar
%{engine_ear}/lib/scheduler.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/interface-common-jaxrs/main/interface-common-jaxrs.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/ovirt-engine-extensions-api/main/ovirt-engine-extensions-api.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-definition/main/restapi-definition.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-jaxrs/main/restapi-jaxrs.jar
%{engine_jboss_modules}/common/org/ovirt/engine/api/restapi-types/main/restapi-types.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/aaa/main/aaa.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/branding/main/branding.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/common/main/common.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/compat/main/compat.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/dal/main/dal.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/extensions-tool/main/extensions-tool.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/sso-client-registration-tool/main/sso-client-registration-tool.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/extensions-manager/main/extensions-manager.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/searchbackend/main/searchbackend.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/tools/main/tools.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/utils/main/utils.jar
%{engine_jboss_modules}/common/org/ovirt/engine/core/uutils/main/uutils.jar
%{engine_jboss_modules}/common/org/ovirt/engine/extensions/builtin/main/builtin.jar
%{engine_ear}/docs.war/WEB-INF/lib/branding.jar
%{engine_ear}/enginesso.war/WEB-INF/lib/branding.jar
%{engine_ear}/webadmin.war/WEB-INF/lib/branding.jar
%{engine_ear}/welcome.war/WEB-INF/lib/branding.jar
__EOF__

# Needed for compatibility if package is different than the directory structure
%if "%{name}" != "%{engine_name}"
ln -s "%{engine_name}" "%{buildroot}%{engine_java}/../%{name}"
%endif

#
# Register poms
#
while read package pom; do
	pomdir="$(dirname "%{_mavenpomdir}/${pom}")"
	pom="$(basename "${pom}")"
	jpppom="JPP.${pom}"
	mv "%{buildroot}${pomdir}/${pom}" "%{buildroot}${pomdir}/${jpppom}"
	artifact_id="$(echo "${pom}" | sed -e 's/^%{name}-//' -e 's/\.pom//')"
	if [ -f "%{buildroot}%{engine_java}/${artifact_id}.jar" ]; then
		%add_maven_depmap -f "${package}" "${jpppom}" "%{name}/${artifact_id}.jar"
	else
		%add_maven_depmap -f "${package}" "${jpppom}"
	fi
done << __EOF__
backend %{name}-aaa.pom
backend %{name}-backend.pom
backend %{name}-bll.pom
backend %{name}-builtin.pom
backend %{name}-dal.pom
backend %{name}-manager-modules.pom
backend %{name}-manager.pom
backend %{name}-scheduler.pom
backend %{name}-searchbackend.pom
backend %{name}-vdsbroker.pom
base %{name}-branding.pom
base %{name}-common.pom
base %{name}-compat.pom
base %{name}-extensions-manager.pom
base %{name}-logutils.pom
base %{name}-root.pom
base %{name}-utils.pom
base %{name}-uutils.pom
extensions-api %{name}-ovirt-engine-extensions-api-root.pom
extensions-api %{name}-ovirt-engine-extensions-api.pom
restapi %{name}-interface-common-jaxrs.pom
restapi %{name}-restapi-definition.pom
restapi %{name}-restapi-jaxrs.pom
restapi %{name}-restapi-parent.pom
restapi %{name}-restapi-types.pom
tools %{name}-extensions-tool.pom
tools %{name}-sso-client-registration-tool.pom
tools %{name}-tools.pom
__EOF__

%if "%{name}" != "%{engine_name}"
sed -i 's#%{_javadir}/%{name}#%{engine_java}#' .mfiles*
%endif

%if !%{ovirt_install_poms}
rm -fr "%{buildroot}%{_mavenpomdir}"
%endif

#
# Link dependencies to system provided
#
while read dst src; do
	[ -z "${dst}" ] && continue
	[ -z "${src}" ] && src="$(basename "${dst}")"

	dst="%{engine_jboss_modules}/${dst}"
	src="%{_javadir}/${src}"
	rm -f "%{buildroot}${dst}"
	ln -s "${src}" "%{buildroot}${dst}"
done << __EOF__
common/com/woorea/openstack/sdk/main/cinder-client.jar openstack-java-sdk/cinder-client.jar
common/com/woorea/openstack/sdk/main/cinder-model.jar openstack-java-sdk/cinder-model.jar
common/com/woorea/openstack/sdk/main/glance-client.jar openstack-java-sdk/glance-client.jar
common/com/woorea/openstack/sdk/main/glance-model.jar openstack-java-sdk/glance-model.jar
common/com/woorea/openstack/sdk/main/keystone-client.jar openstack-java-sdk/keystone-client.jar
common/com/woorea/openstack/sdk/main/keystone-model.jar openstack-java-sdk/keystone-model.jar
common/com/woorea/openstack/sdk/main/openstack-client.jar openstack-java-sdk/openstack-client.jar
common/com/woorea/openstack/sdk/main/quantum-client.jar openstack-java-sdk/quantum-client.jar
common/com/woorea/openstack/sdk/main/quantum-model.jar openstack-java-sdk/quantum-model.jar
common/com/woorea/openstack/sdk/main/resteasy-connector.jar openstack-java-sdk/resteasy-connector.jar
common/com/netflix/config/main/archaius-core.jar archaius/archaius-core.jar
common/com/netflix/hystrix/main/hystrix-core.jar hystrix/hystrix-core.jar
common/com/netflix/hystrix/contrib/main/hystrix-metrics-event-stream.jar hystrix/hystrix-metrics-event-stream.jar
common/com/nimbusds/main/nimbus-jose-jwt.jar nimbus-jose-jwt/nimbus-jose-jwt.jar
common/io/reactivex/rxjava/main/rxjava.jar
common/net/minidev/main/json-smart.jar json-smart.jar
common/org/aopalliance/main/aopalliance.jar
common/org/apache/commons/compress/main/commons-compress.jar
common/org/apache/commons/configuration/main/commons-configuration.jar
common/org/apache/commons/httpclient/main/commons-httpclient.jar
common/org/apache/commons/jxpath/main/commons-jxpath.jar
common/org/apache/ws/commons/main/ws-commons-util.jar
common/org/apache/xmlrpc/main/xmlrpc-client.jar
common/org/apache/xmlrpc/main/xmlrpc-common.jar
common/org/ebaysf/web/cors-filter/main/cors-filter.jar ebay-cors-filter/cors-filter.jar
common/org/ovirt/otopi/main/otopi.jar otopi/otopi.jar
common/org/ovirt/ovirt-host-deploy/main/ovirt-host-deploy.jar ovirt-host-deploy/ovirt-host-deploy.jar
common/org/ovirt/vdsm-jsonrpc-java/main/vdsm-jsonrpc-java-client.jar vdsm-jsonrpc-java/vdsm-jsonrpc-java-client.jar
tools/org/slf4j/main/slf4j-api.jar slf4j/slf4j-api.jar
tools/org/slf4j/main/slf4j-jdk14.jar slf4j/slf4j-jdk14.jar
tools/org/slf4j/jcl-over-slf4j/main/jcl-over-slf4j.jar slf4j/jcl-over-slf4j.jar

%if 0%{?fedora}
# On Fedora we need newer JDBC drivers to be able to connect to PostgreSQL 10.
# Unfortunately this package is not available on EL7, so we are going to
# bundle it within engine until available.
common/org/postgresql/main/postgresql.jar postgresql-jdbc.jar
%endif

%if 0%{?fedora}

%if 0%{?fedora} >= 29
common/org/apache/sshd/main/sshd-core.jar apache-sshd/sshd-core.jar
%endif

common/org/quartz/main/quartz.jar
common/org/snmp4j/main/snmp4j.jar snmp4j.jar
%endif
__EOF__


#
# Register services
#
install -dm 755 "%{buildroot}%{_unitdir}"
for service in ovirt-engine ovirt-engine-notifier ovirt-fence-kdump-listener ovirt-websocket-proxy; do
	cp "%{buildroot}%{engine_data}/services/${service}/${service}.systemd" "%{buildroot}%{_unitdir}/${service}.service"
done

#
# Package customization
#
install -d "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d"
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging.conf" << __EOF__
[environment:default]
OVESETUP_APACHE/configureRootRedirectionDefault=bool:True
__EOF__

%if %{ovirt_rh_postgresql}
install -d "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.env.d"
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.env.d/10-setup-scl-postgres.env" << __EOF__
RHPOSTGRESQLSCLROOT="/opt/rh/%{scl_pg_base}/root"
RHPOSTGRESQLSCLDATA="/var/opt/rh/%{scl_pg_base}/lib/pgsql/data"
if [ -e \${RHPOSTGRESQLSCLROOT}/usr/bin/postgresql-setup ]
then
  export sclenv=%{scl_pg_base}
  export POSTGRESQLENV="COMMAND/pg_dump=str:\${RHPOSTGRESQLSCLROOT}/usr/bin/pg_dump \
         COMMAND/psql=str:\${RHPOSTGRESQLSCLROOT}/usr/bin/psql \
         COMMAND/pg_restore=str:\${RHPOSTGRESQLSCLROOT}/usr/bin/pg_restore \
         COMMAND/postgresql-setup=str:\${RHPOSTGRESQLSCLROOT}/usr/bin/postgresql-setup \
         OVESETUP_PROVISIONING/postgresService=str:%{scl_pg_base}-postgresql \
         OVESETUP_PROVISIONING/oldPostgresService=str:%{old_scl_pg_base}-postgresql \
         OVESETUP_PROVISIONING/postgresConf=str:\${RHPOSTGRESQLSCLDATA}/postgresql.conf \
         OVESETUP_PROVISIONING/postgresPgHba=str:\${RHPOSTGRESQLSCLDATA}/pg_hba.conf \
         OVESETUP_PROVISIONING/postgresPgVersion=str:\${RHPOSTGRESQLSCLDATA}/PG_VERSION"
fi
__EOF__
cat > "%{buildroot}%{engine_etc}/engine.conf.d/10-scl-postgres.conf" << __EOF__
sclenv=%{scl_pg_base}
__EOF__
%endif

%if %{ovirt_provides_jboss}
cat > "%{buildroot}%{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-jboss.conf" << __EOF__
[environment:default]
OVESETUP_CONFIG/jbossHome=str:/usr/share/ovirt-engine-wildfly
OVESETUP_RPMDISTRO/jbossPackages=str:ovirt-engine-wildfly,ovirt-engine-wildfly-overlay
__EOF__
%endif

mkdir -p %{buildroot}/%{engine_data}/playbooks/install-skydive.inventory.sample
ln -s %{engine_data}/../ovirt-engine-metrics/bin/ovirt-engine-hosts-ansible-inventory \
    %{buildroot}/%{engine_data}/playbooks/install-skydive.inventory.sample/00_ovirt-engine-hosts-ansible-inventory

mkdir -p %{buildroot}/%{engine_rpm_state_dir}

%preun
if [ "$1" -eq 0 ]; then
	#
	# backup pki dir into the backup dir with current date
	#
	if [ -d "%{engine_pki}" ]; then
		dest="%{engine_pki}/../%{engine_name}-backups/%{engine_name}-$(date +"%%Y%%m%%d%%H%%M%%S")"
		mkdir -p "${dest}"
		cp -pR "%{engine_pki}" "${dest}"
	fi
fi

%postun
if [ "$1" -eq 0 ]; then
	rm -rf "%{engine_cache}"
	rm -rf "%{engine_pki}"

	if [ -f "%{_sysconfdir}/yum/pluginconf.d/versionlock.list" ]; then
		sed -i '/%{name}/d' "%{_sysconfdir}/yum/pluginconf.d/versionlock.list"
	fi

	if [ -f "%{_sysconfdir}/dnf/plugins/versionlock.list" ]; then
		sed -i '/%{name}/d' "%{_sysconfdir}/dnf/plugins/versionlock.list"
	fi
fi

%pre
%ovirt_create_user_engine

%files -f .mfiles-base
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_cache}
# see also relevant install command to set permissions
%dir %attr(700, %{engine_user}, %{engine_group}) %{engine_log}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/dump
%dir %{engine_data}
%dir %{engine_data}/bin
%dir %{engine_data}/brands
%dir %{engine_data}/conf
%dir %{engine_data}/cinderlib
%dir %{engine_data}/engine.ear
%dir %{engine_data}/extensions.d
%dir %{engine_data}/services
%dir %{engine_data}/playbooks
%dir %{engine_etc}
%dir %{engine_etc}/ansible
%dir %{engine_etc}/branding
%dir %{engine_etc}/extensions.d
%dir %{engine_java}
%license LICENSE
%{engine_data}/brands/ovirt.brand/
%{engine_etc}/branding/00-ovirt.brand
%{engine_etc}/engine.conf.d/
%{engine_etc}/cinderlib/
%config %{engine_data}/cinderlib/logger.conf
%config %attr(0700,%{engine_user},%{engine_group}) %{engine_etc}/cinderlib/ssh_known_hosts

%if 0%{?use_python_bytecompile}
%{engine_data}/cinderlib/cinderlib-client.*
%{engine_data}/cinderlib/config.*
%if 0%{with_python3}
%{engine_data}/cinderlib/__pycache__/cinderlib-client.*
%{engine_data}/cinderlib/__pycache__/config.*
%endif
%else
%{engine_data}/cinderlib/cinderlib-client.py*
%{engine_data}/cinderlib/config.py*
%endif

#
# ATTENTION:
# Needed for compatibility if package is different
# than the directory structure
#
%if "%{name}" != "%{engine_name}"
%{_javadir}/%{name}
%endif

%files extensions-api-impl -f .mfiles-extensions-api
%license LICENSE

%files extensions-api-impl-javadoc
%{engine_doc}/ovirt-engine-extensions-api/
%license LICENSE

%if 0%{with_python2}
%files -n python2-%{name}-lib
%license LICENSE
%{engine_data}/bin/java-home
%{python2_sitelib}/ovirt_engine/
%endif

%if 0%{with_python3}
%files -n python%{python3_pkgversion}-%{name}-lib
%license LICENSE
%{engine_data}/bin/java-home
%{python3_sitelib}/ovirt_engine/
%endif

%files backend -f .mfiles-backend
%license LICENSE
%license backend/manager/modules/services/src/main/webapp/gpl-3.0.txt
%license backend/manager/modules/services/src/main/webapp/lgpl-3.0.txt
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/cinderlib
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/brick-setup
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/host-deploy
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/ansible
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/db-manual
%attr(-, %{engine_user}, %{engine_group}) %{engine_log}/ova
%attr(-, %{engine_user}, %{engine_group}) %{engine_state}/content
%attr(700, %{engine_user}, %{engine_group}) %{engine_state}/.ssh/
%attr(600, %{engine_user}, %{engine_group}) %{engine_state}/.ssh/config
%config %{_sysconfdir}/logrotate.d/ovirt-engine
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_state}
%dir %{engine_data}/bin
%dir %{engine_data}/gwt-symbols
%dir %{engine_data}/ui-plugins
%dir %{engine_ear}
%{engine_data}/conf/osinfo-defaults.properties
%{engine_data}/conf/sysprep/
%{engine_data}/files/
%{engine_data}/icons/
%{engine_data}/logutils/
%{engine_doc}/AuditLogMessages.properties
%{engine_doc}/mibs/
%{engine_ear}/META-INF
%{engine_ear}/bll.jar
%{engine_ear}/docs.war/
%{engine_ear}/enginesso.war/
%{engine_ear}/lib
%{engine_ear}/root.war/
%{engine_ear}/services.war/
%{engine_ear}/welcome.war/
%{engine_etc}/osinfo.conf.d/
%{engine_jboss_modules}/

%{engine_data}/services/ovirt-engine
%{_unitdir}/ovirt-engine.service

#
# PKI
#
# Most directories are owned by the engine user because
# it needs to create files inside
#
%config(noreplace) %{engine_pki}/cacert.template.in
%config(noreplace) %{engine_pki}/cert.template.in
%config(noreplace) %{engine_pki}/openssl.conf
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/certs
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/private
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_pki}/requests
%dir %{engine_pki}/keys
%{engine_data}/bin/pki-common.sh
%{engine_data}/bin/pki-create-ca.sh
%{engine_data}/bin/pki-enroll-openssh-cert.sh
%{engine_data}/bin/pki-enroll-pkcs12.sh
%{engine_data}/bin/pki-enroll-request.sh
%{engine_data}/bin/pki-pkcs12-extract.sh

#
# engine-host-update.py tool
#
%if 0%{?use_python_bytecompile}
%{engine_data}/bin/engine-host-update.*
%if 0%{with_python3}
%{engine_data}/bin/__pycache__/engine-host-update.*
%endif
%else
%{engine_data}/bin/engine-host-update.py
%endif

%files setup-base
%license LICENSE
%config %{_sysconfdir}/logrotate.d/ovirt-engine-setup
%dir %{engine_data}/firewalld
%dir %{engine_data}/setup
%dir %{engine_data}/setup/bin/
%dir %{engine_data}/setup/ovirt_engine_setup
%dir %{engine_data}/setup/plugins
%dir %{engine_data}/setup/plugins/ovirt-engine-common
%dir %{engine_data}/setup/plugins/ovirt-engine-remove
%dir %{engine_data}/setup/plugins/ovirt-engine-setup
%dir %{engine_log}/setup
%{_bindir}/engine-cleanup
%{_bindir}/engine-setup
%{_mandir}/man8/engine-cleanup.*
%{_mandir}/man8/engine-setup.*
%{_mandir}/man8/engine-upgrade-check.*
%{engine_data}/conf/iptables.default.in
%{engine_data}/setup/bin/ovirt-engine-remove
%{engine_data}/setup/bin/ovirt-engine-rename
%{engine_data}/setup/bin/ovirt-engine-setup
%{engine_data}/setup/bin/ovirt-engine-setup.env
%{engine_data}/setup/ovirt_engine_setup/*.py*

%if 0%{?use_python_bytecompile}
%if 0%{with_python3}
%{engine_data}/setup/ovirt_engine_setup/__pycache__/
%endif
%endif

%{engine_data}/setup/plugins/*/base/
%{engine_state}/backups/
%{engine_state}/setup/

%files setup
%license LICENSE
%dir %{engine_rpm_state_dir}


%files setup-plugin-ovirt-engine
%license LICENSE
%config %{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging.conf
%{_bindir}/engine-upgrade-check
%{engine_data}/conf/ovirt-engine-proxy.conf.v2.in
%{engine_data}/conf/ovirt-engine-root-redirect.conf.in
%{engine_data}/firewalld/ovirt-engine/
%{engine_data}/setup/bin/ovirt-engine-upgrade-check
%{engine_data}/setup/dbutils/
%{engine_data}/setup/plugins/*/ovirt-engine/

%files setup-plugin-ovirt-engine-common
%license LICENSE
%{engine_data}/setup/bin/ovirt-engine-provisiondb
%{engine_data}/setup/ovirt_engine_setup/engine_common/
%{engine_data}/setup/ovirt_engine_setup/provisiondb/
%{engine_data}/setup/plugins/*/ovirt-engine-common/
%{engine_data}/firewalld/ovirt-common/
%{engine_data}/setup/ovirt_engine_setup/engine/


%if %{ovirt_provides_jboss}
%config %{_sysconfdir}/ovirt-engine-setup.conf.d/10-packaging-jboss.conf
%config %{engine_etc}/engine.conf.d/20-setup-jboss-overlay.conf
%endif

%if %{ovirt_rh_postgresql}
%config %{_sysconfdir}/ovirt-engine-setup.env.d/10-setup-scl-postgres.env
%config %{engine_etc}/engine.conf.d/10-scl-postgres.conf
%endif

%files setup-plugin-websocket-proxy
%license LICENSE
%{engine_data}/firewalld/websocket-proxy/
%{engine_data}/setup/ovirt_engine_setup/websocket_proxy/
%{engine_data}/setup/plugins/*/websocket_proxy/

%files setup-plugin-vmconsole-proxy-helper
%license LICENSE
%{engine_data}/conf/ovirt-vmconsole-proxy.conf
%{engine_data}/firewalld/vmconsole-proxy/
%{engine_data}/setup/ovirt_engine_setup/vmconsole_proxy_helper/
%{engine_data}/setup/plugins/*/vmconsole_proxy_helper/

%files setup-plugin-cinderlib
%license LICENSE
%{engine_data}/setup/ovirt_engine_setup/cinderlib/
%{engine_data}/setup/plugins/*/cinderlib

%files dbscripts
%license LICENSE
%{engine_data}/dbscripts/

%files restapi -f .mfiles-restapi
%license LICENSE
%{engine_restapi_war}/
%{engine_apidoc_war}/

%files webadmin-portal
%license LICENSE
%license frontend/webadmin/modules/gwt-extension/src/main/java/org/ovirt/engine/ui/uioverrides/java/util/LICENSE
%config %{engine_etc}/usbfilter.txt
%{engine_ear}/webadmin.war
%{engine_data}/gwt-symbols/webadmin/

%files websocket-proxy
%license LICENSE
%{engine_data}/services/ovirt-websocket-proxy
%{engine_etc}/ovirt-websocket-proxy.conf.d/

%{_unitdir}/ovirt-websocket-proxy.service

%files vmconsole-proxy-helper
%license LICENSE
%{_libexecdir}/ovirt-vmconsole-proxy-helper/
%{engine_data}/conf/ovirt-vmconsole-proxy-helper.conf
%{engine_etc}/ovirt-vmconsole-proxy-helper.conf.d/

%files tools -f .mfiles-tools
%license LICENSE
%config %{_sysconfdir}/logrotate.d/ovirt-engine-notifier
%config(noreplace) %{engine_etc}/engine-config/engine-config.conf
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_log}/notifier
%dir %attr(-, %{engine_user}, %{engine_group}) %{engine_run}/notifier
%dir %{engine_etc}/engine-config
%dir %{engine_etc}/notifier
%{_bindir}/engine-config
%{_bindir}/ovirt-engine-extensions-tool
%{_bindir}/ovirt-register-sso-client-tool
%{_bindir}/engine-vacuum
%{_mandir}/man8/engine-config.*
%{engine_data}/bin/engine-config.sh
%{engine_data}/bin/engine-prolog.sh
%{engine_data}/bin/engine-vacuum.sh
%{engine_data}/bin/generate-pgpass.sh
%{engine_data}/bin/ovirt-engine-extensions-tool.sh
%{engine_data}/bin/ovirt-register-sso-client-tool.sh
%{engine_data}/bin/vdsm_to_network_name_map
%{engine_data}/bin/ovirt-engine-crypto-tool.sh
%{engine_data}/bin/ovirt-engine-role.sh
%{engine_data}/conf/extensions-tool-logging.properties
%{engine_data}/conf/ovirt-register-sso-client-tool-logging.properties
%{engine_data}/conf/jaas.conf
%{engine_data}/conf/notifier-logging.properties
%{engine_data}/conf/tools-logging.properties
%{engine_data}/playbooks/ansible.cfg
%{engine_data}/playbooks/create-brick.yml
%{engine_data}/playbooks/install-skydive.inventory.sample/00_ovirt-engine-hosts-ansible-inventory
%{engine_data}/playbooks/install-skydive.inventory.sample/01_hosts
%{engine_data}/playbooks/install-skydive.yml
%{engine_data}/playbooks/ovirt-host-deploy.yml
%{engine_data}/playbooks/ovirt-host-enroll-certificate.yml
%{engine_data}/playbooks/ovirt-host-remove.yml
%{engine_data}/playbooks/ovirt-host-upgrade.yml
%{engine_data}/playbooks/ovirt-ova-export.yml
%{engine_data}/playbooks/ovirt-ova-import.yml
%{engine_data}/playbooks/ovirt-ova-query.yml
%{engine_data}/playbooks/ovirt-image-measure.yml
%{engine_data}/playbooks/ovirt-provider-ovn-driver.yml
%{engine_data}/playbooks/ovirt-vnc-sasl.yml
%{engine_data}/playbooks/roles/
%{engine_data}/services/ovirt-engine-notifier
%{engine_data}/services/ovirt-fence-kdump-listener/
%{engine_etc}/ansible/ovirt-host-deploy-post-tasks.yml.example
%{engine_etc}/engine-config/engine-config.*properties
%{engine_etc}/notifier/notifier.conf.d/
%{engine_etc}/ovirt-fence-kdump-listener.conf.d/


%{_unitdir}/ovirt-engine-notifier.service
%{_unitdir}/ovirt-fence-kdump-listener.service

%files tools-backup
%license LICENSE
%{_bindir}/engine-backup
%{_mandir}/man8/engine-backup.*
%{engine_data}/bin/engine-backup.sh

%if 0%{?use_python_bytecompile}
%{engine_data}/bin/engine-migrate-he.*
%if 0%{with_python3}
%{engine_data}/bin/__pycache__/engine-migrate-he.*
%endif
%else
%{engine_data}/bin/engine-migrate-he.py
%endif

%{engine_backup_default_dir}
%{engine_backup_log_default_dir}

%files health-check-bundler
%{engine_data}/setup/bin/bundle-ovirt-engine-health
%{engine_data}/setup/bin/ovirt-engine-health

%changelog
* Tue May 21 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.4.1
- Bump version to 4.3.4.1

* Mon May 13 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.4
- Bump version to 4.3.4

* Tue Apr 30 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3.7
- Bump version to 4.3.3.7

* Tue Apr 23 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3.6
- Bump version to 4.3.3.6

* Mon Apr 15 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3.5
- Bump version to 4.3.3.5

* Wed Apr 11 2019 Simone Tiraboschi <stirabos@redhat.com> - 4.3.3.4
- Bump version to 4.3.3.4

* Mon Apr 08 2019 Simone Tiraboschi <stirabos@redhat.com> - 4.3.3.3
- Bump version to 4.3.3.3

* Wed Apr 03 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3.2
- Bump version to 4.3.3.2

* Tue Mar 26 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3.1
- Bump version to 4.3.3.1

* Tue Mar 26 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.3
- Bump version to 4.3.3

* Mon Mar 11 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.2.1
- Bump version to 4.3.2.1

* Mon Mar 04 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.2
- Bump version to 4.3.2

* Tue Feb 19 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.1.1
- Bump version to 4.3.1.1

* Mon Feb 18 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.1
- Bump version to 4.3.1

* Wed Jan 30 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0.4
- Bump version to 4.3.0.4

* Wed Jan 30 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0.3
- Bump version to 4.3.0.3

* Mon Jan 28 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0.2
- Bump version to 4.3.0.2

* Wed Jan 23 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0.1
- Bump version to 4.3.0.1

* Mon Jan 21 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.3.0
- Bump version to 4.3.0

* Mon Jan 07 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.8.2
- Bump version to 4.2.8.2

* Mon Dec 10 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.8.1
- Bump version to 4.2.8.1

* Mon Nov 26 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.8
- Bump version to 4.2.8

* Tue Oct 16 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.7.3
- Bump version to 4.2.7.3

* Mon Oct 01 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.7.2
- Bump version to 4.2.7.2

* Fri Sep 21 2018 Martin Perina <mperina@redhat.com> - 4.2.7.1
- Bump version to 4.2.7.1

* Mon Sep 17 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.7
- Bump version to 4.2.7

* Fri Aug 24 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.6.4
- Bump version to 4.2.6.4

* Tue Aug 14 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.6.3
- Bump version to 4.2.6.3

* Sun Aug 12 2018 - Yedidyah Bar David <didi@redhat.com> - 4.2.6.2
- Bump version to 4.2.6.2

* Fri Aug 10 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.6.1
- Bump version to 4.2.6.1

* Wed Aug 01 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.6
- Bump version to 4.2.6

* Wed Jul 18 2018 Lev Veyde <lveyde@redhat.com> - 4.2.5.2
- Bump version to 4.2.5.2

* Thu Jul 05 2018 Lev Veyde <lveyde@redhat.com> - 4.2.5.1
- Bump version to 4.2.5.1

* Wed Jun 27 2018 Lev Veyde <lveyde@redhat.com> - 4.2.5
- Bump version to 4.2.5

* Mon Jun 18 2018 Lev Veyde <lveyde@redhat.com> - 4.2.4.5
- Bump version to 4.2.4.5

* Thu Jun 14 2018 Martin Perina <mperina@redhat.com> - 4.2.4.4
- Bump version to 4.2.4.4

* Tue Jun 12 2018 Lev Veyde <lveyde@redhat.com> - 4.2.4.3
- Bump version to 4.2.4.3

* Tue Jun 05 2018 Lev Veyde <lveyde@redhat.com> - 4.2.4.2
- Bump version to 4.2.4.2

* Tue May 29 2018 Lev Veyde <lveyde@redhat.com> - 4.2.4.1
- Bump version to 4.2.4.1

* Wed May 23 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.4
- Bump version to 4.2.4

* Wed Apr 25 2018 Lev Veyde <lveyde@redhat.com> - 4.2.3.3
- Bump version to 4.2.3.3

* Tue Apr 17 2018 Lev Veyde <lveyde@redhat.com> - 4.2.3.2
- Bump version to 4.2.3.2

* Mon Apr 16 2018 Lev Veyde <lveyde@redhat.com> - 4.2.3.1
- Bump version to 4.2.3.1

* Mon Apr 09 2018 Lev Veyde <lveyde@redhat.com> - 4.2.3
- Bump version to 4.2.3

* Thu Mar 29 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.6
- Bump version to 4.2.2.6

* Tue Mar 20 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.5
- Bump version to 4.2.2.5

* Thu Mar 15 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.4
- Bump version to 4.2.2.4

* Mon Mar 12 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.3
- Bump version to 4.2.2.3

* Wed Feb 28 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.2
- Bump version to 4.2.2.2

* Mon Feb 19 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2.1
- Bump version to 4.2.2.1

* Tue Feb 13 2018 Lev Veyde <lveyde@redhat.com> - 4.2.2
- Bump version to 4.2.2

* Mon Jan 29 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.1.4
- Bump version to 4.2.1.4

* Mon Jan 22 2018 Lev Veyde <lveyde@redhat.com> - 4.2.1.3
- Bump version to 4.2.1.3

* Tue Jan 16 2018 Lev Veyde <lveyde@redhat.com> - 4.2.1.2
- Bump version to 4.2.1.2

* Tue Jan 09 2018 Lev Veyde <lveyde@redhat.com> - 4.2.1.1
- Bump version to 4.2.1.1

* Thu Jan 04 2018 Lev Veyde <lveyde@redhat.com> - 4.2.1
- Bump version to 4.2.1

* Mon Dec 11 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0.2
- Bump version to 4.2.0.2

* Mon Dec 11 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0.1
- Bump version to 4.2.0.1

* Mon Nov 27 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0
- Bump version to 4.2.0

* Wed May 25 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0
- Add dependency for ovirt-engine-dashboard.
- Bump version to 4.1.0

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0
- Bump version to 4.0.0
- Dropped Fedora < 22 and EL < 7 support

* Thu Jul 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.0
- Update dependencies and removed legacy provides / requires

* Thu Jan 17 2013 Juan Hernandez <juan.hernandez@redhat.com> - 3.3.0-1
- Bump version to 3.3.0

* Fri Nov 02 2012 Juan Hernandez <juan.hernandez@redhat.com> - 3.2.0-1
- Bump version to 3.2.0

* Mon May 07 2012 Keith Robertson <kroberts@redhat.com> - 3.1.0-3
- Removed image uploader, iso uploader, and log collector from this
  git repo.  The are now in their own respective ovirt.org git
  repos. BZ#803240.

* Wed Apr 04 2012 Stephen Gordon <sgordon@redhat.com> - 3.1.0-2
- The ovirt-engine spec file did not previously contain a BuildRequires
  statement for the maven package. As a result in mock environments the
  build failed with an error when attempting to call the 'mvn' binary -
  BZ#807761.

* Wed Jan 04 2012 Ronen Angluste <ranglust@redhat.com> - 3.1.0-1
- Adjust code for Jboss AS 7.1

* Sun Dec 11 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Moved all hard coded paths to macros

* Wed Oct 26 2011 Ronen Angluster <ranglust@redhat.com> - 3.1.0-1
- Initial build
- Cloned from RHEVM spec file
