package org.ovirt.engine.core.dao;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.Test;
import org.ovirt.engine.core.common.businessentities.VmIcon;
import org.ovirt.engine.core.compat.Guid;

public class VmIconDaoTest extends BaseGenericDaoTestCase<Guid, VmIcon, VmIconDao> {

    private static final Guid EXISTING_ID = new Guid("32a41e14-8ec0-4638-8c34-a8e2841efc7e");
    private static final Guid NEW_ID = new Guid("566184b8-d5cd-4747-896b-b8d088add90a");
    private static final String NEW_DATAURL = /* elephant */ "data:image/jpeg;base64,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";
    private static final String UPDATED_DATAURL = /* frog */ "data:image/jpeg;base64,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";
    private static final String OTHER_SMALL_DATAURL = "data:image/jpeg;base64,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";
    private static final Guid OTHER_SMALL_ICON_ID = new Guid("38fc5e1a-f96b-339b-9894-def6f366daf5");
    private static final Guid UNUSED_ICON_ID = new Guid("e4c72730-0264-4201-8373-97efd65811e6");
    private static final Guid NON_EXISTING_ICON_ID = Guid.Empty;

    @Override
    protected VmIcon generateNewEntity() {
        return new VmIcon(NEW_ID, NEW_DATAURL);
    }

    @Override
    protected void updateExistingEntity() {
        existingEntity.setDataUrl(UPDATED_DATAURL);
    }

    @Override
    protected Guid getExistingEntityId() {
        return EXISTING_ID;
    }

    @Override
    protected VmIconDao prepareDao() {
        return getDbFacade().getVmIconDao();
    }

    @Override
    protected Guid generateNonExistingId() {
        return Guid.newGuid();
    }

    @Override
    protected int getEntitiesTotalCount() {
        return 6;
    }

    @Test
    public void testGetVmIconByDataUrlWithValidUrl() {
        final List<VmIcon> result = prepareDao().getByDataUrl(OTHER_SMALL_DATAURL);
        assertEquals(1, result.size());
        assertEquals(new VmIcon(OTHER_SMALL_ICON_ID, OTHER_SMALL_DATAURL), result.get(0));
    }

    @Test
    public void testGetVmIconByDataUrlWithInvalidUrl() {
        final List<VmIcon> result = prepareDao().getByDataUrl(OTHER_SMALL_DATAURL + "garbage");
        assertTrue(result.isEmpty());
    }

    @Test
    public void testRemoveIfUnusedWithUsed() {
        prepareDao().removeIfUnused(OTHER_SMALL_ICON_ID);
        final VmIcon survivor = prepareDao().get(OTHER_SMALL_ICON_ID);
        assertEquals(OTHER_SMALL_ICON_ID, survivor.getId());
    }

    @Test
    public void testRemoveIfUnusedWithUnused() {
        prepareDao().removeIfUnused(UNUSED_ICON_ID);
        final VmIcon nothing = prepareDao().get(UNUSED_ICON_ID);
        assertNull(nothing);
    }

    @Test
    public void testDeleteAllUnusedIcons() {
        reinitializeDatabase();
        prepareDao().removeAllUnusedIcons();
        final VmIcon unusedIcon = prepareDao().get(UNUSED_ICON_ID);
        assertNull(unusedIcon);
        final VmIcon usedIcon = prepareDao().get(OTHER_SMALL_ICON_ID);
        assertNotNull(usedIcon);
        reinitializeDatabase();
    }

    @Test
    public void testExistsExisting() {
        assertTrue(prepareDao().exists(UNUSED_ICON_ID));
    }

    @Test
    public void testExistsNonExisting() {
        assertFalse(prepareDao().exists(NON_EXISTING_ICON_ID));
    }
}
