package org.ovirt.engine.core.common.errors;

// This enum was moved from VdcBLL
public enum VdcBllMessages {
    Unassigned,
    VAR__TYPE__HOST,
    VAR__ENTITIES__HOSTS,
    VAR__TYPE__VM,
    VAR__ENTITIES__VMS,
    VAR__TYPE__QUOTA,
    VAR__TYPE__VM__CLUSTER,
    VAR__TYPE__VM_TEMPLATE,
    VAR__ENTITIES__VM_TEMPLATES,
    VAR__TYPE__SNAPSHOT,
    VAR__TYPE__DESKTOP_POOL,
    VAR__TYPE__VM_FROM_VM_POOL,
    VAR__TYPE__COMPUTER_ACCOUNT,
    VAR__TYPE__CLUSTER,
    VAR__TYPE__ROLE,
    VAR__TYPE__INTERFACE,
    VAR__TYPE__NETWORK,
    VAR__TYPE__NETWORKS,
    VAR__TYPE__VNIC_PROFILE,
    VAR__TYPE__LABEL,
    VAR__TYPE__PROVIDER,
    VAR__TYPE__PROVIDER_CERTIFICATE,
    VAR__TYPE__VM_DISK,
    VAR__TYPE__BOOKMARK,
    VAR__TYPE__VM_TICKET,
    VAR__TYPE__PERMISSION,
    VAR__TYPE__HOST_CAPABILITIES,
    VAR__TYPE__NETWORK_QOS,
    VAR__TYPE__QOS,
    VAR__TYPE__SPM,
    VAR__TYPE__CLUSTER_POLICY,
    VAR__TYPE__POLICY_UNIT,
    VAR__TYPE__SUBNET,
    VAR__TYPE__AFFINITY_GROUP,
    VAR__TYPE__ISCSI_BOND,
    VAR__TYPE__DISK__SNAPSHOT,
    VAR__TYPE__DISK_PROFILE,
    VAR__TYPE__CPU_PROFILE,

    // Gluster types
    VAR__TYPE__GLUSTER_VOLUME,
    VAR__TYPE__GLUSTER_VOLUME_OPTION,
    VAR__TYPE__GLUSTER_BRICK,
    VAR__TYPE__GLUSTER_SERVER,
    VAR__TYPE__GLUSTER_HOOK,
    VAR__TYPE__GLUSTER_SERVICE,

    // External Event
    VAR__TYPE__EXTERNAL_EVENT,

    // External Tasks
    VAR__TYPE__EXTERNAL_JOB,
    VAR__TYPE__EXTERNAL_STEP,

    VAR__ACTION__RUN,
    VAR__ACTION__REMOVE,
    VAR__ACTION__ADD,
    VAR__ACTION__UPDATE,
    VAR__ACTION__CREATE,
    VAR__ACTION__PAUSE,
    VAR__ACTION__HIBERNATE,
    VAR__ACTION__MIGRATE,
    VAR__ACTION__CANCEL_MIGRATE,
    VAR__ACTION__ATTACH_DESKTOP_TO,
    VAR__ACTION__REVERT_TO,
    VAR__ACTION__PREVIEW,
    VAR__ACTION__STOP,
    VAR__ACTION__START,
    VAR__ACTION__RESTART,
    VAR__ACTION__SHUTDOWN,
    VAR__ACTION__EXPORT,
    VAR__ACTION__EXTEND,
    VAR__ACTION__IMPORT,
    VAR__ACTION__ATTACH_ACTION_TO,
    VAR__ACTION__DETACH_ACTION_TO,
    VAR__ACTION__MOVE,
    VAR__ACTION__COPY,
    VAR__ACTION__CHANGE_CD,
    VAR__ACTION__EJECT_CD,
    VAR__ACTION__ALLOCATE_AND_RUN,
    VAR__ACTION__SET,
    VAR__ACTION__SETUP,
    VAR__ACTION__RESET,
    VAR__ACTION__HOT_PLUG,
    VAR__ACTION__HOT_UNPLUG,
    VAR__ACTION__LOGON,
    VAR__ACTION__LOGOFF,
    VAR__ACTION__REBALANCE_START,
    VAR__ACTION__REBALANCE_STOP,
    VAR__ACTION__REMOVE_BRICKS_START,
    VAR__ACTION__ASSIGN,
    VAR__ACTION__START_PROFILE,
    VAR__ACTION__STOP_PROFILE,
    VAR__ACTION__ENABLE,
    VAR__ACTION__DISABLE,
    VAR__ACTION__REFRESH,
    VAR__ACTION__SCAN_ALIGNMENT,
    VAR__ACTION__END,
    VAR__ACTION__CLEAR,
    VAR__ACTION__FORCE_SELECT,
    VAR__ACTION__EXTEND_IMAGE_SIZE,
    VAR__ACTION__REMOVE_BRICKS_STOP,
    VAR__ACTION__REMOVE_BRICKS_COMMIT,
    VAR__ACTION__HOT_SET_CPUS,
    VAR__ACTION__UPDATE_SLA_POLICY,
    VAR__ACTION__UPDATE_VM_VERSION,

    // Host statuses replacements
    VAR__HOST_STATUS__UP,
    VAR__HOST_STATUS__UP_MAINTENANCE_OR_NON_OPERATIONAL,

    VAR__VM_STATUS__UP,
    VAR__VM_STATUS__UNASSIGNED,
    VAR__VM_STATUS__DOWN,
    VAR__VM_STATUS__POWERING_UP,
    VAR__VM_STATUS__PAUSED,
    VAR__VM_STATUS__MIGRATING,
    VAR__VM_STATUS__UNKNOWN,
    VAR__VM_STATUS__NOT_RESPONDING,
    VAR__VM_STATUS__WAIT_FOR_LAUNCH,
    VAR__VM_STATUS__REBOOT_IN_PROGRESS,
    VAR__VM_STATUS__SAVING_STATE,
    VAR__VM_STATUS__RESTORING_STATE,
    VAR__VM_STATUS__SUSPENDED,
    VAR__VM_STATUS__IMAGE_LOCKED,
    VAR__VM_STATUS__POWERING_DOWN,
    VAR__VM_STATUS__IMAGE_ILLEGAL,
    VAR__VM_STATUS__PREPARING_FOR_HIBERNATE,

    POWER_MANAGEMENT_ACTION_ON_ENTITY_ALREADY_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_LIST_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_ALREADY_USED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DELETE_VMS_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DISK_SNAPSHOT_IS_ATTACHED_TO_ANOTHER_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DISK_SNAPSHOT_IS_PLUGGED_TO_ANOTHER_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_PLUGGED_DISK_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SHAREABLE_DISKS_NOT_SUPPORTED_ON_GLUSTER_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISKS_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_DISK_INTERFACE_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INTERFACE_DOES_NOT_SUPPORT_READ_ONLY_ATTR(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISKS_ILLEGAL(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_MOVE_DISKS_MIXED_PLUGGED_STATUS(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_IMPORT_DISKS_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_DURING_EXPORT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IMAGE_IS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_NO_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_CDROM_DISK_FORMAT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_IMAGE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_TYPE_NOT_ALLOWED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CORRUPTED_VM_SNAPSHOT_ID(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_HAS_NO_CONFIGURATION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_REPOSITORY_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_IS_RUNNING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_CLONED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_UPDATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_RUNNING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NOT_DOWN_OR_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HOST_CANNOT_LIVE_MERGE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_SAVING_RESTORING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_DURING_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_USE_LATEST_WITH_CLONE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_NOT_SET_FOR_LATEST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_ALREADY_IN_LATEST_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_GUID_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_RUNNING_STATELESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_HAS_STATELESS_SNAPSHOT_LEFTOVER(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_VM_IN_USE_BY_OTHER_USER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_RUN_ACTION_ON_NON_MANAGED_VM(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CLUSTER_DIFFERENT_ARCHITECTURES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DELETE_PROTECTION_ENABLED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_PCI_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_IDE_SLOTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_VIRTIO_SCSI_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXCEEDED_MAX_SPAPR_VSCSI_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_BOOT_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VMS_BOOT_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_ALREADY_ATTACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NOT_SHAREABLE_DISK_ALREADY_ATTACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_ALREADY_DETACHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ILLEGAL_DISK_OPERATION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_ARCHITECTURE_TYPE_INCOMPATIBLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_VOLUME_TYPE_UNSUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_SPM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SPM_CHANGED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_SPACE_LOW_ON_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DEDICATED_VDS_NOT_IN_SAME_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DEDICATED_VDS_DOES_NOT_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_MAX_SIZE_EXCEEDED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_CONFIGURATION_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_OVF_CONFIGURATION_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_IS_ALREADY_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_HAS_NO_VALID_TYPE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_ISCSI_MISSING_CONNECTION_PARAMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_LUN_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_HOSTED_ENGINE_STORAGE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNSUPPORTED_DISK_STORAGE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_UNAVAILABLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_TYPE_UNSUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MIGRATION_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIGRATION_TO_SAME_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DESTINATION_HOST_NOT_IN_DESTINATION_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CLUSTER_UNDEFINED_ARCHITECTURE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_VM_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_CLUSTER_DIFFERENT_ARCHITECTURES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_MEMORY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_VERSION(ErrorType.INCOMPATIBLE_VERSION),
    ACTION_TYPE_FAILED_VDS_VM_SWAP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_CPUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_CPU_LEVEL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_VM_NETWORKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MISSING_DISPLAY_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_VDS_AVAILABLE_IN_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_IMAGE_TEMPLATE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CPU_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_CAN_NOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_VERSION_CANNOT_BE_BASE_TEMPLATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_CANNOT_BE_CREATED_WITH_EMPTY_DISK_ALIAS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INSTANCE_TYPE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_TYPE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_DISABLED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_EXISTS_IN_CURRENT_DC(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_GUID_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ROLE_IS_READ_ONLY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_NOT_MATCH(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_OF_VM_NOT_MATCH(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MISSED_STORAGES_FOR_SOME_DISKS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_IS_WRONG(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_ALREADY_CONTAINS_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DELETE_PROTECTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_VMS_IN_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NAME_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_STORAGE_DOMAIN_EXTERNAL_LUN_DISK_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROBLEM_WITH_CANDIDATE_INFO(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_NAME_ALREADY_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_FOUND_ON_DESTINATION_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_NOT_FOUND_ON_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_FOUND_ON_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMPORTED_TEMPLATE_IS_MISSING(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SPECIFY_DOMAIN_IS_NOT_EXPORT_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DETECTED_ACTIVE_VMS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_WITH_SAME_HOST_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_WITH_INVALID_SSH_PORT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_WITH_INVALID_SSH_USERNAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_WITH_SAME_UUID_EXIST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ILLEGAL_NUM_OF_MONITORS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_SINGLE_DEVICE_DISPLAY_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_OS_TYPE_IS_NOT_SUPPORTED_BY_ARCHITECTURE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_WATCHDOG_MODEL_IS_NOT_SUPPORTED_BY_OS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_VM_DISPLAY_TYPE_IS_NOT_SUPPORTED_BY_OS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_OS_TYPE_DOES_NOT_SUPPORT_VIRTIO_SCSI(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SUSPEND_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_SINGLE_DEVICE_OS_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_SINGLE_DEVICE_INCOMPATIBLE_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ILLEGAL_DOMAIN_NAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MAX_NUM_CPU(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_NUM_SOCKETS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIN_NUM_SOCKETS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MAX_CPU_PER_SOCKET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIN_CPU_PER_SOCKET(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PRESTARTED_VMS_CANNOT_EXCEED_VMS_COUNT(ErrorType.CONFLICT),
    TEMPLATE_IMAGE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_DECREASE_COMPATIBILITY_VERSION(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_DECREASING_COMPATIBILITY_VERSION_CAUSES_STORAGE_FORMAT_DOWNGRADING(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_DOMAINS_ARE_NOT_SUPPORTED_IN_DOWNGRADED_VERSION(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_CANNOT_DECREASE_COMPATIBILITY_VERSION_UNDER_DC(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_GIVEN_VERSION_NOT_SUPPORTED(ErrorType.INCOMPATIBLE_VERSION),
    ACTION_TYPE_FAILED_DATA_CENTER_VERSION_DOESNT_SUPPORT_LIVE_SNAPSHOT(ErrorType.INCOMPATIBLE_VERSION),
    CANNOT_MAINTENANCE_VDS_RUN_VMS_NO_OTHER_RUNNING_VDS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NAME_LENGTH_IS_TOO_LONG(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_MAY_NOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_TEMPLATE_IS_INCOMPATIBLE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_VDS_HOSTNAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NAME_MAY_NOT_CONTAIN_SPECIAL_CHARS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOSTNAME_CANNOT_CHANGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_SNAPSHOT_NOT_IN_PREVIEW(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SHAREABLE_DISK_NOT_SUPPORTED(ErrorType.CONFLICT),
    FAILED_TO_RUN_LDAP_QUERY(ErrorType.INTERNAL_ERROR),
    ACTION_TYPE_FAILED_INVALID_TIMEZONE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_SERIAL_NUMBER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QEMU_UNSUPPORTED_OPERATION(ErrorType.NOT_SUPPORTED),

    VDS_CANNOT_REMOVE_DEFAULT_VDS_GROUP(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_VDS_DETECTED_RUNNING_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DETECTED_PINNED_VMS(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_VDS_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIGRATE_BETWEEN_TWO_CLUSTERS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VDS_INTERMITENT_CONNECTIVITY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MOM_UPDATE_VDS_VERSION(ErrorType.INCOMPATIBLE_VERSION),
    VDS_CANNOT_REMOVE_VDS_GROUP_VDS_DETECTED(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_OPERATIONAL(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_RESPONDING_WITH_VMS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_NOT_RESPONDING_AND_IS_SPM(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_SPM_WITH_RUNNING_TASKS(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_SPM_CONTENDING(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_IS_IN_MAINTENANCE(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VDS_HAS_AFFINITY_VMS(ErrorType.CONFLICT),
    VDS_NO_UUID(ErrorType.CONFLICT),
    VDS_ALREADY_UP(ErrorType.CONFLICT),
    VDS_NON_RESPONSIVE(ErrorType.CONFLICT),
    VDS_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VDS_STATUS_NOT_VALID_FOR_STOP(ErrorType.CONFLICT),
    VDS_STATUS_NOT_VALID_FOR_START(ErrorType.CONFLICT),
    VDS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    CANNOT_FORCE_SELECT_SPM_VDS_NOT_UP(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_ALREADY_SPM(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_MARKED_AS_NEVER_SPM(ErrorType.CONSTRAINT_VIOLATION),
    CANNOT_FORCE_SELECT_SPM_STORAGE_POOL_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    CANNOT_FORCE_SELECT_SPM_VDS_NOT_IN_POOL(ErrorType.CONFLICT),
    VDS_NO_VDS_PROXY_FOUND(ErrorType.CONFLICT),
    VDS_FAILED_FENCE_VIA_PROXY_CONNECTION(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_AT_SYSTEM_STARTUP_INTERVAL(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_AT_QUIET_TIME(ErrorType.CONFLICT),
    VDS_FENCE_DISABLED_BY_CLUSTER_POLICY(ErrorType.CONFLICT),
    VDS_STATUS_NOT_VALID_FOR_UPDATE(ErrorType.CONFLICT),
    VDS_EMPTY_NAME_OR_ID(ErrorType.BAD_PARAMETERS),
    VDS_TRY_CREATE_WITH_EXISTING_PARAMS(ErrorType.BAD_PARAMETERS),
    VDS_EMPTY_NAME(ErrorType.BAD_PARAMETERS),
    VDS_TRY_CREATE_SECURE_CERTIFICATE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VDS_CANNOT_INSTALL_EMPTY_PASSWORD(ErrorType.BAD_PARAMETERS),
    VDS_PORT_CHANGE_REQUIRE_INSTALL(ErrorType.BAD_PARAMETERS),
    VDS_INVALID_SERVER_ID(ErrorType.BAD_PARAMETERS),
    VDS_ADD_STORAGE_SERVER_STATUS_MUST_BE_UP(ErrorType.CONFLICT),
    VDS_CANNOT_CLEAR_VMS_WRONG_STATUS(ErrorType.CONFLICT),
    VDS_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VDS_CLUSTER_ON_DIFFERENT_STORAGE_POOL(ErrorType.BAD_PARAMETERS),
    VDS_FENCE_DISABLED(ErrorType.CONFLICT),
    VDS_CANNOT_INSTALL_STATUS_ILLEGAL(ErrorType.CONFLICT),
    VDS_CANNOT_UPGRADE_BETWEEN_MAJOR_VERSION(ErrorType.CONSTRAINT_VIOLATION),
    VDS_CANNOT_INSTALL_MISSING_IMAGE_FILE(ErrorType.BAD_PARAMETERS),
    VDS_CANNOT_CONNECT_TO_SERVER(ErrorType.CONFLICT),
    VDS_CANNOT_AUTHENTICATE_TO_SERVER(ErrorType.CONFLICT),
    VDS_SECURITY_CONNECTION_ERROR(ErrorType.CONFLICT),
    VAR__ACTION__MANUAL_FENCE,
    VAR__ACTION__MAINTENANCE,
    ACTION_TYPE_FAILED_PM_ENABLED_WITHOUT_AGENT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PM_ENABLED_WITHOUT_AGENT_CREDENTIALS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AGENT_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_VM_ARCHITECTURE_NOT_SUPPORTED_BY_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_TEMPLATE_ARCHITECTURE_NOT_SUPPORTED_BY_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_VM_WITH_NOT_SUPPORTED_ARCHITECTURE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_CANNOT_IMPORT_TEMPLATE_WITH_NOT_SUPPORTED_ARCHITECTURE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_MIN_MEMORY_CANNOT_EXCEED_MEMORY_SIZE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MEMORY_EXCEEDS_SUPPORTED_LIMIT(ErrorType.NOT_SUPPORTED),
    VDS_CANNOT_CHECK_VERSION_HOST_NON_RESPONSIVE(ErrorType.CONFLICT),
    STORAGE_DOMAIN_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    // VDS_CANNOT_RUN_VM_FAILED_TO_RUN, // EINAV: not in use
    // internal const string VDS_CANNOT_REMOVE_VDS_DETECTED_RUNNING_VM =
    /**
     * "Cannot delete the server, there are desktop(s) running on the server.";
     */
    VM_CANNOT_CANCEL_MIGRATION_WHEN_VM_IS_NOT_MIGRATING(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_VDS_GROUP_VMS_DETECTED(ErrorType.CONFLICT),
    VM_TEMPLATE_IS_LOCKED(ErrorType.CONFLICT),
    VM_TEMPLATE_IMAGE_IS_LOCKED(ErrorType.CONFLICT),
    VM_TEMPLATE_IMAGE_IS_ILLEGAL(ErrorType.CONFLICT),
    VM_TEMPLATE_IMAGE_LAST_DOMAIN(ErrorType.CONFLICT),
    VM_CANNOT_UPDATE_ILLEGAL_FIELD(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_UPDATE_DEVICE_VM_NOT_DOWN(ErrorType.BAD_PARAMETERS),
    MAC_POOL_NOT_ENOUGH_MAC_ADDRESSES(ErrorType.CONFLICT),
    VM_CANNOT_MOVE_TO_CLUSTER_IN_OTHER_STORAGE_POOL(ErrorType.CONFLICT),
    VM_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_REMOVE_VM_WHEN_STATUS_IS_NOT_DOWN(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_WITH_DETACH_DISKS_SNAPSHOTS_EXIST(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_WITH_DETACH_DISKS_BASED_ON_TEMPLATE(ErrorType.CONFLICT),
    VM_CANNOT_EXPORT_RAW_FORMAT(ErrorType.CONFLICT),
    VM_PINNING_FORMAT_INVALID(ErrorType.BAD_PARAMETERS),
    VM_PINNING_VCPU_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_PINNING_PCPU_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_PINNING_DUPLICATE_DEFINITION(ErrorType.BAD_PARAMETERS),
    VM_PINNING_PINNED_TO_NO_CPU(ErrorType.BAD_PARAMETERS),
    VM_NUMA_PINNED_VDS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VM_NUMA_PINNED_VDS_NODE_EMPTY(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_PINNED_INDEX_ERROR(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_MEMRORY_ERROR(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_PREFERRED_NOT_PINNED_TO_SINGLE_NODE(ErrorType.BAD_PARAMETERS),
    VM_NUMA_NODE_MORE_NODES_THAN_CPUS(ErrorType.BAD_PARAMETERS),
    CANNOT_PREVIEW_ACTIVE_SNAPSHOT(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_SUSPENDE_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    VM_CANNOT_REMOVE_HAS_RUNNING_TASKS(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_NETWORK_WITHOUT_NETWORK(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_CD_WITHOUT_ACTIVE_STORAGE_DOMAIN_ISO(ErrorType.CONFLICT),
    VM_CANNOT_WITHOUT_ACTIVE_STORAGE_DOMAIN_ISO(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_DISK_WITHOUT_DISK(ErrorType.CONFLICT),
    VM_CANNOT_RUN_STATELESS_WHILE_IN_PREVIEW(ErrorType.CONFLICT),
    VM_CANNOT_RUN_STATELESS_HA(ErrorType.CONFLICT),
    VM_CANNOT_IMPORT_VM_EXISTS(ErrorType.CONFLICT),
    VM_CANNOT_IMPORT_VM_NAME_EXISTS(ErrorType.CONFLICT),
    VM_CANNOT_SUSPEND_STATELESS_VM(ErrorType.CONFLICT),
    VM_CANNOT_SUSPEND_VM_FROM_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_SUITABLE_DOMAIN_FOUND(ErrorType.CONFLICT),
    VM_CANNOT_SUSPEND_VM_WITHOUT_IMAGE_DISKS(ErrorType.CONFLICT),
    // internal const string VMT_CANNOT_REMOVE_DETECTED_DERIVED_VM =
    // "Cannot delete the template, there are desktop(s) created from template";
    VMT_CANNOT_REMOVE_DETECTED_DERIVED_VM(ErrorType.CONFLICT),
    VMT_CANNOT_REMOVE_BASE_WITH_VERSIONS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DETECTED_DERIVED_DISKS(ErrorType.CONFLICT),
    VMT_CANNOT_CREATE_TEMPLATE_FROM_DOWN_VM(ErrorType.CONFLICT),
    VMT_CANNOT_REMOVE_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VMT_CANNOT_EDIT_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VMT_CANNOT_EXPORT_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VMT_CANNOT_UPDATE_ILLEGAL_FIELD(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_UPDATE_VERSION_NAME(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_REMOVE_VDS_GROUP_VMTS_DETECTED(ErrorType.CONFLICT),
    VMT_CANNOT_CREATE_DUPLICATE_NAME(ErrorType.CONFLICT),
    VMT_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_IMPORT_TEMPLATE_EXISTS(ErrorType.CONFLICT),
    VMT_CANNOT_IMPORT_TEMPLATE_VERSION_MISSING_BASE(ErrorType.BAD_PARAMETERS),
    VMT_CANNOT_REMOVE_DOMAINS_LIST_MISMATCH(ErrorType.CONFLICT),
    VM_CANNOT_IMPORT_TEMPLATE_NAME_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_INTERFACE_MAC_INVALID(ErrorType.BAD_PARAMETERS),
    USER_CANNOT_REMOVE_HIMSELF(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_KERBEROS_ERROR(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_SERVER_IS_NOT_AVAILABLE(ErrorType.NO_AUTHENTICATION),
    USER_FAILED_TO_AUTHENTICATE_TIMED_OUT(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED_CHANGE_URL_PROVIDED(ErrorType.NO_AUTHENTICATION),
    USER_PASSWORD_EXPIRED_CHANGE_MSG_PROVIDED(ErrorType.NO_AUTHENTICATION),
    USER_ACCOUNT_DISABLED(ErrorType.NO_AUTHENTICATION),
    USER_ACCOUNT_EXPIRED(ErrorType.NO_AUTHENTICATION),
    USER_PERMISSION_DENIED(ErrorType.NO_AUTHENTICATION),
    USER_MUST_EXIST_IN_DB(ErrorType.NO_AUTHENTICATION),
    USER_MUST_EXIST_IN_DIRECTORY(ErrorType.NO_AUTHENTICATION),
    USER_IS_ALREADY_LOGGED_IN(ErrorType.CONFLICT),
    USER_IS_NOT_LOGGED_IN(ErrorType.NO_AUTHENTICATION),
    USER_DOES_NOT_HAVE_A_VALID_EMAIL(ErrorType.CONFLICT),
    USER_CANNOT_RUN_QUERY_NOT_PUBLIC(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_LOGIN_DOMAIN_NOT_SUPPORTED(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_LOGIN_SESSION_MISSING(ErrorType.NO_AUTHENTICATION),
    USER_CANNOT_REMOVE_ADMIN_USER(ErrorType.NO_PERMISSION),
    USB_NATIVE_SUPPORT_ONLY_AVAILABLE_ON_CLUSTER_LEVEL(ErrorType.CONFLICT),
    USB_LEGACY_NOT_SUPPORTED_ON_LINUX_VMS(ErrorType.CONFLICT),
    VM_POOL_CANNOT_REMOVE_VM_POOL_WITH_VMS(ErrorType.CONFLICT),
    VM_POOL_CANNOT_REMOVE_RUNNING_VM_FROM_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_RUNNING_VM_TO_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_USER_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_WITH_USERS_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_DETACH_VM_NOT_ATTACHED_TO_POOL(ErrorType.CONFLICT),
    VM_POOL_CANNOT_ADD_VM_DIFFERENT_CLUSTER(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CREATE_DUPLICATE_NAME(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CREATE_WITH_NO_VMS(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_NO_AVAILABLE_POOL_VMS(ErrorType.CONFLICT),
    VM_POOL_CANNOT_CREATE_FROM_BLANK_TEMPLATE(ErrorType.CONFLICT),
    VM_POOL_CANNOT_UPDATE_POOL_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_DECREASE_VMS_FROM_POOL(ErrorType.BAD_PARAMETERS),
    VM_POOL_CANNOT_ATTACH_TO_MORE_VMS_FROM_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_FROM_POOL_CANNOT_BE_STATELESS(ErrorType.CONFLICT),
    DIRECTORY_COMPUTER_WITH_THE_SAME_NAME_ALREADY_EXITS(ErrorType.CONFLICT),
    USER_NOT_AUTHORIZED_TO_PERFORM_ACTION(ErrorType.NO_PERMISSION),
    ERROR_CANNOT_REMOVE_LAST_SUPER_USER_ROLE(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ROLE_ATTACHED_TO_PERMISSION(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_ROLE_INVALID_ROLE_ID(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_UPDATE_ROLE_NAME(ErrorType.CONFLICT),
    ERROR_CANNOT_UPDATE_ROLE_ID(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_UPDATE_ROLE_TYPE(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_ATTACH_ACTION_GROUP_TO_ROLE_ATTACHED(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_ACTION_GROUP_TO_ROLE_NOT_ATTACHED(ErrorType.BAD_PARAMETERS),
    VDS_APPROVE_VDS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VDS_APPROVE_VDS_IN_WRONG_STATUS(ErrorType.CONFLICT),
    VDS_SHUTDOWN_VDS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    VDS_SHUTDOWN_NO_RESPONSE(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_UPDATE_CPU_ILLEGAL(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_UPDATE_CPU_ARCHITECTURE_ILLEGAL(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_DO_ACTION_NAME_IN_USE(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_CHANGE_STORAGE_POOL(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_UPDATE_CPU_WITH_LOWER_HOSTS(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_UPDATE_COMPATIBILITY_VERSION_WITH_LOWER_HOSTS(ErrorType.INCOMPATIBLE_VERSION),
    VDS_GROUP_CANNOT_UPDATE_VDS_UP(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_ADD_COMPATIBILITY_VERSION_WITH_LOWER_STORAGE_POOL(ErrorType.INCOMPATIBLE_VERSION),
    VDS_GROUP_CANNOT_REMOVE_HAS_VM_POOLS(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_SET_TRUSTED_ATTESTATION_SERVER_NOT_CONFIGURED(ErrorType.ATTESTATION_SERVER_ERROR),
    NETWORK_HOST_IS_BUSY(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NAME_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_ALREADY_LABELED(ErrorType.BAD_PARAMETERS),
    NETWORK_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_NOT_EXISTS_IN_CLUSTER(ErrorType.BAD_PARAMETERS),
    NETWORK_OLD_NETWORK_NOT_SPECIFIED(ErrorType.BAD_PARAMETERS),
    NETWORK_ALREADY_ATTACHED_TO_CLUSTER(ErrorType.CONFLICT),
    NETWORK_CAN_NOT_REMOVE_DEFAULT_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    ACTION_TYPE_FAILED_NETWORK_LABEL_RENAMING_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    NETWORK_VLAN_IN_USE(ErrorType.CONFLICT),
    NETWORK_ADDR_MANDATORY_IN_STATIC_IP(ErrorType.BAD_PARAMETERS),
    NETWORK_MAC_ADDRESS_IN_USE(ErrorType.CONFLICT),
    HOST_NETWORK_INTERFACE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_NAME_ALREADY_IN_USE(ErrorType.CONFLICT),
    NETWORK_INTERFACE_IN_USE_BY_VLAN(ErrorType.CONFLICT),
    NETWORK_ALREADY_ATTACHED_TO_INTERFACE(ErrorType.CONFLICT),
    NETWORK_INTERFACE_ALREADY_HAVE_NETWORK(ErrorType.CONFLICT),
    NETWORK_CLUSTER_NETWORK_IN_USE(ErrorType.CONFLICT),
    NETWORK_INTERFACE_CONNECT_TO_VLAN(ErrorType.CONFLICT),
    NETWORK_INTERFACE_TEMPLATE_CANNOT_BE_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_VM_CANNOT_BE_SET(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_NOT_ATTACH_TO_NETWORK(ErrorType.CONFLICT),
    NETWORK_CANNOT_REMOVE_MANAGEMENT_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    NETWORK_CANNOT_REMOVE_ISCSI_BOND_NETWORK(ErrorType.CONSTRAINT_VIOLATION),
    NETWORK_BOND_NAME_EXISTS(ErrorType.CONFLICT),
    NETWORK_BOND_PARAMETERS_INVALID(ErrorType.BAD_PARAMETERS),
    NETWORK_DEFAULT_UPDATE_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    NETWORK_CHECK_CONNECTIVITY(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_ALREADY_IN_BOND(ErrorType.CONFLICT),
    NETWORK_BOND_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_BOND_NOT_ATTACH_TO_NETWORK(ErrorType.BAD_PARAMETERS),
    NETWORK_BOND_HAVE_ATTACHED_VLANS(ErrorType.CONFLICT),
    NETWORK_INTERFACE_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACE_IN_USE_BY_VM(ErrorType.CONFLICT),
    NETWORK_CANNOT_ADD_INTERFACE_WHEN_VM_STATUS_NOT_UP_DOWN_LOCKED(ErrorType.CONFLICT),
    NETWORK_CLUSTER_HAVE_NOT_EXISTING_DATA_CENTER_NETWORK(ErrorType.CONFLICT),
    NETWORK_NOT_EXISTS_IN_CURRENT_CLUSTER(ErrorType.CONFLICT),
    NETWORKS_NOT_IN_SYNC(ErrorType.CONFLICT),
    NETWORK_INTERFACES_ALREADY_SPECIFIED(ErrorType.CONFLICT),
    NETWORKS_ALREADY_ATTACHED_TO_IFACES(ErrorType.CONFLICT),
    NETWORK_INTERFACES_DONT_EXIST(ErrorType.BAD_PARAMETERS),
    NETWORKS_DONT_EXIST_IN_CLUSTER(ErrorType.CONFLICT),
    NETWORKS_DONT_EXIST_IN_DATA_CENTER(ErrorType.CONFLICT),
    NETWORK_BONDS_INVALID_SLAVE_COUNT(ErrorType.BAD_PARAMETERS),
    NETWORK_INTERFACES_NOT_EXCLUSIVELY_USED_BY_NETWORK(ErrorType.CONFLICT),
    NETWORK_CANNOT_DETACH_NETWORK_USED_BY_VMS(ErrorType.CONFLICT),
    NON_VM_NETWORK_CANNOT_SUPPORT_STP(ErrorType.CONFLICT),
    NETWORK_MTU_DIFFERENCES(ErrorType.CONFLICT),
    NETWORK_MTU_OVERRIDE_NOT_SUPPORTED(ErrorType.CONFLICT),
    EXTERNAL_NETWORK_CANNOT_BE_PROVISIONED(ErrorType.NOT_SUPPORTED),
    NETWORK_LABEL_FORMAT_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_LABELED_NETWORK_FROM_NIC(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISPLAY_NETWORK_HAS_NO_BOOT_PROTOCOL(ErrorType.BAD_PARAMETERS),
    IMPROPER_INTERFACE_IS_LABELED(ErrorType.BAD_PARAMETERS),
    IMPROPER_BOND_IS_LABELED(ErrorType.BAD_PARAMETERS),
    INTERFACE_ALREADY_LABELED(ErrorType.CONFLICT),
    INTERFACE_NOT_LABELED(ErrorType.CONFLICT),
    LABELED_NETWORK_ATTACHED_TO_WRONG_INTERFACE(ErrorType.CONFLICT),
    OTHER_INTERFACE_ALREADY_LABELED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VNIC_PROFILE_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VNIC_PROFILE_NAME_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VNIC_PROFILE_IN_USE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_FIND_VNIC_PROFILE_FOR_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_VNIC_PROFILE_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_ADD_VNIC_PROFILE_TO_NON_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLOUD_INIT_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_MIGRATION_NETWORK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PROVIDER_DOESNT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MANAGEMENT_NETWORK_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_ADDRESS_CANNOT_BE_CHANGED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_DETAILS_CANNOT_BE_EDITED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_MUST_BE_VM_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_DISPLAY(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_REQUIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_WITH_VLAN_MUST_BE_LABELED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ISCSI_BOND_NETWORK_CANNOT_BE_REQUIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_PROVIDER_NETWORKS_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_PROVIDER_TYPE_MISMATCH(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MISSING_NETWORK_MAPPINGS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_MISSING_MESSAGING_BROKER_PROPERTIES(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_PORT_MIRRORED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_BE_REWIRED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORK_CANNOT_HAVE_MTU(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_EXTERNAL_NETWORKS_CANNOT_BE_PROVISIONED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_IN_STORAGE_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUNS_ALREADY_PART_OF_STORAGE_DOMAINS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_LUNS_ALREADY_USED_BY_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_FOR_DOMAIN_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_FOR_DOMAIN_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_DOMAINS_STATUS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_RUNNING_VMS_AND_DOMAINS_STATUS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_NOT_SAME_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_ACTION_FOR_RUNNING_VMS(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_STORAGE_DOMAINS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_BELONGS_TO_SEVERAL_STORAGE_DOMAINS_AND_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_UNSUPPORTED_CHANGE_STORAGE_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTIONS_CANNOT_BE_ADDED_TO_ISCSI_BOND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_STATUS_ILLEGAL2(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TAG_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    STORAGE_POOL_REINITIALIZE_WITH_MORE_THAN_ONE_DATA_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIXED_STORAGE_TYPES_NOT_ALLOWED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_VDS_IN_POOL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_TYPE_ILLEGAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_FORMAT_ILLEGAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_DOMAIN_FORMAT_ILLEGAL_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MASTER_STORAGE_DOMAIN_NOT_ACTIVE(ErrorType.CONFLICT),
    STORAGE_DOMAIN_NOT_ATTACHED_TO_STORAGE_POOL(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_MORE_THAN_ONE_ISO_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_MORE_THAN_ONE_EXPORT_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_LAST_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DESTROY_LAST_STORAGE_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_DESTROY_LAST_STORAGE_DOMAIN_HOST_NOT_ACTIVE(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_WITH_NON_DATA_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_WITH_LOCKED_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_DOMAIN_WITH_TASKS(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_STORAGE_DOMAIN_WITH_ISO_ATTACHED(ErrorType.CONFLICT),
    ERROR_CANNOT_DEACTIVATE_MASTER_DOMAIN_WITH_TASKS_ON_POOL(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITHOUT_DATA_AND_ISO_DOMAINS(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITHOUT_DATA_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_DOMAIN_WITH_ATTACHED_DATA_DOMAIN(ErrorType.CONFLICT),
    ERROR_CANNOT_ADD_STORAGE_POOL_WITH_DIFFERENT_STORAGE_FORMAT(ErrorType.CONFLICT),
    ERROR_CANNOT_CREATE_STORAGE_DOMAIN_WITHOUT_VG_LV(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_POOL_WITH_NETWORKS(ErrorType.CONFLICT),
    ERROR_CANNOT_REMOVE_POOL_WITH_ACTIVE_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_ATTACH_STORAGE_DOMAIN_STORAGE_TYPE_NOT_MATCH(ErrorType.CONFLICT),
    ERROR_CANNOT_CHANGE_STORAGE_POOL_TYPE_WITH_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_EXTEND_CONNECTION_FAILED(ErrorType.CONFLICT),
    ERROR_CANNOT_CHANGE_STORAGE_DOMAIN_FIELDS(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_STORAGE_POOL_WITH_NONMASTER_DOMAINS(ErrorType.CONFLICT),
    ERROR_CANNOT_FORCE_REMOVE_STORAGE_POOL_WITH_VDS_NOT_IN_MAINTENANCE(ErrorType.CONFLICT),
    ERROR_CANNOT_UPDATE_STORAGE_POOL_COMPATIBILITY_VERSION_BIGGER_THAN_CLUSTERS(ErrorType.INCOMPATIBLE_VERSION),
    ERROR_CANNOT_ADD_EXISTING_STORAGE_DOMAIN_CONNECTION_DATA_ILLEGAL(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_MANAGE_STORAGE_DOMAIN(ErrorType.NOT_SUPPORTED),
    ERROR_CANNOT_FIND_ISO_IMAGE_PATH(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_FIND_FLOPPY_IMAGE_PATH(ErrorType.BAD_PARAMETERS),
    VAR__TYPE__STORAGE__POOL,
    VAR__TYPE__STORAGE__DOMAIN,
    VAR__TYPE__STORAGE__CONNECTION,
    VAR__ACTION__ATTACH,
    VAR__ACTION__DETACH,
    VAR__ACTION__ACTIVATE,
    VAR__ACTION__DEACTIVATE,
    VAR__ACTION__RECONSTRUCT_MASTER,
    VAR__ACTION__RECOVER_POOL,
    VAR__ACTION__DESTROY_DOMAIN,
    VAR__TYPE__USER_FROM_VM,
    VAR__TYPE__USER,
    EN_UNKNOWN_NOTIFICATION_METHOD(ErrorType.BAD_PARAMETERS),
    EN_UNSUPPORTED_NOTIFICATION_EVENT(ErrorType.BAD_PARAMETERS),
    EN_ALREADY_SUBSCRIBED(ErrorType.CONFLICT),
    EN_NOT_SUBSCRIBED(ErrorType.CONFLICT),
    EN_UNKNOWN_TAG_NAME(ErrorType.BAD_PARAMETERS),
    TAGS_CANNOT_EDIT_READONLY_TAG(ErrorType.CONFLICT),
    TAGS_SPECIFY_TAG_IS_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    TAGS_SPECIFY_TAG_IS_IN_USE(ErrorType.CONFLICT),
    TAGS_SPECIFIED_TAG_CANNOT_BE_THE_PARENT_OF_ITSELF(ErrorType.CONFLICT),
    AUDIT_LOG_CANNOT_REMOVE_AUDIT_LOG_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    TAGS_CANNOT_REMOVE_TAG_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    NETWORK_CANNOT_CONTAIN_BOND_NAME(ErrorType.BAD_PARAMETERS),
    VMPAYLOAD_INVALID_PAYLOAD_TYPE(ErrorType.CONFLICT),
    VMPAYLOAD_SIZE_EXCEEDED(ErrorType.CONSTRAINT_VIOLATION),
    VMPAYLOAD_FLOPPY_EXCEEDED(ErrorType.CONFLICT),
    VMPAYLOAD_FLOPPY_WITH_SYSPREP(ErrorType.CONFLICT),
    VMPAYLOAD_CDROM_WITH_CLOUD_INIT(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_BOOKMARK_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_BOOKMARK_INVALID_ID(ErrorType.BAD_PARAMETERS),
    VDS_FENCE_OPERATION_FAILED(ErrorType.CONFLICT),
    ACTION_NOT_SUPPORTED_FOR_CLUSTER_POOL_LEVEL(ErrorType.INCOMPATIBLE_VERSION),
    CAN_DO_ACTION_GENERAL_FAILURE(ErrorType.INTERNAL_ERROR),
    CAN_DO_ACTION_DATABASE_CONNECTION_FAILURE(ErrorType.INTERNAL_ERROR),
    /** @deprecated as it is too general error message */
    @Deprecated
    ACTION_TYPE_FAILED_OBJECT_LOCKED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_IS_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_USED_FOR_CREATE_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SNAPSHOT_IS_BEING_TAKEN_FOR_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_USED_FOR_CREATE_VM(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_REMOVED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_DISK_IS_BEING_USED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_UNSUPPORTED_OVF(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DOMAIN_OVF_ON_UPDATE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_MIGRATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DESTINATION_AND_SOURCE_STORAGE_SUB_TYPES_DIFFERENT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_EXPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_VALID_DOMAINS_STATUS_FOR_TEMPLATE_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_MIGRATED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_IMPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_TEMPLATE_IS_BEING_REMOVED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_BEING_REMOVED_FROM_EXPORT_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_USED_BY_GET_ALIGNMENT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISK_IS_BEING_EXPORTED(ErrorType.CONFLICT),
    VM_OR_TEMPLATE_ILLEGAL_PRIORITY_VALUE(ErrorType.BAD_PARAMETERS),

    USER_FAILED_TO_AUTHENTICATION_WRONG_AUTHENTICATION_METHOD(ErrorType.NO_AUTHENTICATION),
    ACTION_TYPE_FAILED_VM_IS_PINNED_TO_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NON_MIGRTABLE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_IS_NON_MIGRTABLE_AND_IS_NOT_FORCED_BY_USER_TO_MIGRATE(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_IT_INCLUDES_NON_MIGRATABLE_VM(ErrorType.CONFLICT),
    VDS_CANNOT_MAINTENANCE_VM_HAS_PLUGGED_DISK_SNAPSHOT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_DISK_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_OVF_DISK_NOT_IN_APPLICABLE_STATUS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DISKS_SNAPSHOTS_DONT_BELONG_TO_SAME_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_HIGHLY_AVAILABLE_AND_PINNED_TO_HOST(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_PINNED_TO_CPU_AND_MIGRATABLE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_VM_CANNOT_BE_PINNED_TO_CPU_WITH_UNDEFINED_HOST(ErrorType.BAD_PARAMETERS),
    VM_PINNED_TO_HOST_CANNOT_RUN_ON_THE_DEFAULT_VDS(ErrorType.CONFLICT),
    HOST_NAME_NOT_AVAILABLE(ErrorType.BAD_PARAMETERS),
    VM_HOSTCPU_MUST_BE_PINNED_TO_HOST(ErrorType.CONFLICT),
    MIGRATION_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    MIGRATION_ON_ERROR_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    VM_MIGRATION_IS_NOT_SUPPORTED(ErrorType.CONFLICT),

    ACTION_TYPE_FAILED_STORAGE_POOL_IS_NOT_LOCAL(ErrorType.BAD_PARAMETERS),
    RHEVH_LOCALFS_WRONG_PATH_LOCATION(ErrorType.BAD_PARAMETERS),

    VDS_CANNOT_ADD_MORE_THEN_ONE_HOST_TO_LOCAL_STORAGE(ErrorType.CONSTRAINT_VIOLATION),
    VDS_CANNOT_REMOVE_HOST_WITH_LOCAL_STORAGE(ErrorType.CONFLICT),
    VDS_CANNOT_ADD_LOCAL_STORAGE_TO_NON_LOCAL_HOST(ErrorType.CONFLICT),
    VDS_CANNOT_REMOVE_LOCAL_STORAGE_ON_NON_LOCAL_HOST(ErrorType.CONFLICT),

    VDS_GROUP_CANNOT_ADD_MORE_THEN_ONE_HOST_TO_LOCAL_STORAGE(ErrorType.CONSTRAINT_VIOLATION),
    VDS_GROUP_SELECTION_ALGORITHM_MUST_BE_SET_TO_NONE_ON_LOCAL_STORAGE(ErrorType.BAD_PARAMETERS),
    VDS_GROUP_CANNOT_DETACH_DATA_DOMAIN_FROM_LOCAL_STORAGE(ErrorType.CONFLICT),
    DATA_CENTER_POSIX_STORAGE_NOT_SUPPORTED_IN_CURRENT_VERSION(ErrorType.INCOMPATIBLE_VERSION),
    DATA_CENTER_GLUSTER_STORAGE_NOT_SUPPORTED_IN_CURRENT_VERSION(ErrorType.INCOMPATIBLE_VERSION),

    VDS_GROUP_CPU_UTILIZATION_MUST_BE_IN_VALID_RANGE(ErrorType.CONSTRAINT_VIOLATION),
    VDS_GROUP_CPU_LOW_UTILIZATION_PERCENTAGE_MUST_BE_LOWER_THAN_HIGH_PERCENTAGE(ErrorType.BAD_PARAMETERS),
    VDS_GROUP_CPU_HIGH_UTILIZATION_PERCENTAGE_MUST_BE_DEFINED_WHEN_USING_EVENLY_DISTRIBUTED(ErrorType.BAD_PARAMETERS),
    VDS_GROUP_BOTH_LOW_AND_HIGH_CPU_UTILIZATION_PERCENTAGE_MUST_BE_DEFINED_WHEN_USING_POWER_SAVING(ErrorType.BAD_PARAMETERS),
    VDS_GROUP_AT_LEAST_ONE_SERVICE_MUST_BE_ENABLED(ErrorType.BAD_PARAMETERS),
    VDS_GROUP_ENABLING_BOTH_VIRT_AND_GLUSTER_SERVICES_NOT_ALLOWED(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_DISABLE_VIRT_WHEN_CLUSTER_CONTAINS_VMS(ErrorType.CONFLICT),
    VDS_GROUP_CANNOT_DISABLE_GLUSTER_WHEN_CLUSTER_CONTAINS_VOLUMES(ErrorType.CONFLICT),
    VDS_CANNOT_UPDATE_CLUSTER(ErrorType.BAD_PARAMETERS),
    VM_CANNOT_UPDATE_CLUSTER(ErrorType.BAD_PARAMETERS),
    VM_STATUS_NOT_VALID_FOR_UPDATE(ErrorType.CONFLICT),
    PERMISSION_ADD_FAILED_PERMISSION_NOT_SENT(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_INVALID_ROLE_ID(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_INVALID_OBJECT_ID(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_USER_ID_MISMATCH(ErrorType.BAD_PARAMETERS),
    PERMISSION_ADD_FAILED_ONLY_SYSTEM_SUPER_USER_CAN_GIVE_ADMIN_ROLES(ErrorType.NO_PERMISSION),
    PERMISSION_ADD_FAILED_VM_IN_POOL(ErrorType.CONFLICT),
    PERMISSION_REMOVE_FAILED_ONLY_SYSTEM_SUPER_USER_CAN_REMOVE_ADMIN_ROLES(ErrorType.NO_PERMISSION),
    CANNOT_ADD_ACTION_GROUPS_TO_ROLE_TYPE(ErrorType.CONFLICT),
    ROLE_TYPE_CANNOT_BE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_SYNTAX(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_KEYS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_INVALID_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CUSTOM_PROPERTIES_DUPLICATE_KEYS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CUSTOM_PROPERTIES_NOT_SUPPORTED_IN_VERSION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_DEVICE_TYPE_FOR_CUSTOM_PROPERTIES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_CUSTOM_PROPERTIES_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NETWORK_CUSTOM_PROPERTIES_BAD_INPUT(ErrorType.BAD_PARAMETERS),

    NETWORK_ILEGAL_NETWORK_NAME(ErrorType.BAD_PARAMETERS),
    NETWORK_ATTACH_ILLEGAL_GATEWAY(ErrorType.BAD_PARAMETERS),
    MISSING_DIRECTORY_ELEMENT_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_NOT_MATCH_VALID_STATUS(ErrorType.CONFLICT),
    CANNOT_REMOVE_STORAGE_DOMAIN_INVALID_HOST_ID(ErrorType.BAD_PARAMETERS),
    ERROR_CANNOT_REMOVE_ACTIVE_STORAGE_POOL(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE_WRONG_USERNAME_OR_PASSWORD(ErrorType.NO_AUTHENTICATION),
    VDS_GROUP_CANNOT_UPDATE_CPU_WITH_SUSPENDED_VMS(ErrorType.CONFLICT),
    VDS_GROUP_CPU_IS_NOT_UPDATABLE(ErrorType.CONFLICT),
    CPU_TYPE_UNSUPPORTED_IN_THIS_CLUSTER_VERSION(ErrorType.CONFLICT),
    USER_FAILED_TO_AUTHENTICATE_ACCOUNT_IS_LOCKED_OR_DISABLED(ErrorType.NO_AUTHENTICATION),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_BUILTIN_GROUP_EVERYONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_DATA_DOMAIN_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    VM_CANNOT_RUN_ONCE_WITH_ILLEGAL_SYSPREP_PARAM(ErrorType.BAD_PARAMETERS),
    MOVE_VM_CLUSTER_MISSING_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_STORAGE_POOL_WITH_DEFAULT_VDS_GROUP_CANNOT_BE_LOCALFS(ErrorType.CONFLICT),
    DEFAULT_CLUSTER_CANNOT_BE_ON_LOCALFS(ErrorType.CONFLICT),
    HOT_PLUG_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_CPU_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_UNPLUG_CPU_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    UNLINKING_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_PLUG_DISK_SNAPSHOT_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    NULL_NETWORK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_NETWORK_QOS_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_HOST_NETWORK_LABELS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    HOT_VM_INTERFACE_UPDATE_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    PLUGGED_UNLINKED_VM_INTERFACE_WITH_EXTERNAL_NETWORK_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_VM_INTERFACE_TYPE_IS_NOT_SUPPORTED_BY_OS(ErrorType.INCOMPATIBLE_VERSION),
    CANNOT_PERFORM_HOT_UPDATE(ErrorType.CONFLICT),
    CANNOT_PERFORM_HOT_UPDATE_WITH_PORT_MIRRORING(ErrorType.CONFLICT),
    PORT_MIRRORING_REQUIRES_NETWORK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GUEST_OS_VERSION_IS_NOT_SUPPORTED(ErrorType.CONFLICT),
    HOT_PLUG_DISK_IS_NOT_VIRTIO(ErrorType.CONFLICT),
    HOT_PLUG_DISK_IS_NOT_UNPLUGGED(ErrorType.CONFLICT),
    HOT_UNPLUG_DISK_IS_NOT_PLUGGED(ErrorType.CONFLICT),
    CANNOT_ADD_FLOATING_DISK_WITH_PLUG_VM_SET(ErrorType.CONFLICT),
    ACTIVATE_DEACTIVATE_NIC_VM_STATUS_ILLEGAL(ErrorType.CONFLICT),
    ACTIVATE_DEACTIVATE_NETWORK_NOT_IN_VDS(ErrorType.CONFLICT),
    SHAREABLE_DISK_IS_NOT_SUPPORTED_FOR_DISK(ErrorType.CONFLICT),
    SHAREABLE_DISK_IS_NOT_SUPPORTED_BY_VOLUME_FORMAT(ErrorType.CONFLICT),
    ERROR_CANNOT_DETACH_DISK_WITH_SNAPSHOT(ErrorType.CONFLICT),
    DISK_IS_ALREADY_SHARED_BETWEEN_VMS(ErrorType.CONFLICT),
    VM_CANNOT_RUN_FROM_DISK_WITHOUT_PLUGGED_DISK(ErrorType.CONFLICT),
    SCSI_GENERIC_IO_IS_NOT_SUPPORTED_FOR_IMAGE_DISK(ErrorType.NOT_SUPPORTED),
    SCSI_PASSTHROUGH_IS_NOT_SUPPORTED_FOR_READ_ONLY_DISK(ErrorType.NOT_SUPPORTED),
    VIRTIO_SCSI_INTERFACE_IS_NOT_AVAILABLE_FOR_CLUSTER_LEVEL(ErrorType.INCOMPATIBLE_VERSION),
    CANNOT_PERFORM_ACTION_VIRTIO_SCSI_IS_DISABLED(ErrorType.CONFLICT),
    CANNOT_DISABLE_VIRTIO_SCSI_PLUGGED_DISKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QUOTA_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_QUOTA_SET_FOR_DOMAIN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_IS_NO_LONGER_AVAILABLE_IN_SYSTEM(ErrorType.DATA_CORRUPTION),
    ACTION_TYPE_FAILED_QUOTA_LIMIT_IS_SPECIFIC_AND_GENERAL(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_IN_USE_BY_VM_OR_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_STORAGE_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_QUOTA_VDS_GROUP_LIMIT_EXCEEDED(ErrorType.CONFLICT),
    USER_NOT_AUTHORIZED_TO_CONSUME_QUOTA(ErrorType.NO_PERMISSION),
    ACTION_TYPE_FAILED_NOT_A_VM_NETWORK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NETWORK_NOT_IN_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INTERFACE_NETWORK_NOT_CONFIGURED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_IS_NOT_VM_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_IS_NOT_TEMPLATE_DISK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISKS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SNAPSHOTS_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_SNAPSHOTS_ACTIVE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_DISKS_SPECIFIED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SOURCE_AND_TARGET_SAME(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REQUESTED_DISK_SIZE_IS_TOO_SMALL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_RESIZE_READ_ONLY_DISK(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CANNOT_RESIZE_DISK_SNAPSHOT(ErrorType.CONFLICT),
    NON_VM_NETWORK_NOT_SUPPORTED_FOR_POOL_LEVEL(ErrorType.NOT_SUPPORTED),
    VM_SLA_POLICY_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    VALIDATION_STORAGE_CONNECTION_INVALID(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_INVALID_PORT(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_VFSTYPE(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_MOUNT_OPTIONS_CONTAINS_MANAGED_PROPERTY(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_IQN(ErrorType.BAD_PARAMETERS),
    VALIDATION_STORAGE_CONNECTION_EMPTY_CONNECTION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ACTION_IS_SUPPORTED_ONLY_FOR_ISCSI_DOMAINS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ID_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STORAGE_CONNECTION_ID_NOT_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BASE_TEMPLATE_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_HA_MAINT_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VDS_HA_NOT_CONFIGURED(ErrorType.BAD_PARAMETERS),
    // Cluster Policy messages
    ACTION_TYPE_FAILED_CLUSTER_POLICY_PARAMETERS_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_DUPLICATE_POLICY_UNIT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_NAME_INUSE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_LOCKED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_INUSE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_UNKNOWN_POLICY_UNIT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FILTER_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FUNCTION_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_BALANCE_NOT_IMPLEMENTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_ONLY_ONE_FILTER_CAN_BE_FIRST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_ONLY_ONE_FILTER_CAN_BE_LAST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_POLICY_FUNCTION_FACTOR_NEGATIVE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_POLICY_UNIT_ATTACHED_TO_CLUSTER_POLICY(ErrorType.CONFLICT),
    // Gluster Messages
    ACTION_TYPE_FAILED_CLUSTER_IS_NOT_VALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTER_DOES_NOT_SUPPORT_GLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_NAME_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BRICKS_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_BRICK_ID_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_ONE_OR_MORE_BRICKS_ARE_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_BRICK_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_ADD_BRICK_FORCE_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_REPLICA_COUNT_MIN_2(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_REPLICA_COUNT_MIN_4(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_STRIPED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_STRIPED_REPLICATE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STRIPE_COUNT_MIN_4(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_STRIPE_COUNT_MIN_8(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_STRIPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_COUNT_FOR_DISTRIBUTED_STRIPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_BRICK_SERVER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_ALREADY_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_ALREADY_STOPPED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_IS_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_SHOULD_BE_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_NOT_DISTRIBUTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_DISTRIBUTED_AND_HAS_SINGLE_BRICK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REBALANCE_NOT_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_CANNOT_STOP_REBALANCE_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_CANNOT_STOP_REMOVE_BRICK_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_IS_DOWN(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NOT_A_GLUSTER_VOLUME_BRICK(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_NOT_STARTED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_NOT_FINISHED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_REMOVE_BRICKS_PARAMS_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_VOLUME_INVALID_TASK_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CAN_NOT_REMOVE_ALL_BRICKS_FROM_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT_WITH_DATA_MIGRATION(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_REPLICA_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_STRIPE_COUNT_MORE_THAN_ONE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_REPLICA_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_INCREASE_REPLICA_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_CAN_NOT_REDUCE_STRIPE_COUNT(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_BRICK_ALREADY_EXISTS_IN_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_DUPLICATE_BRICKS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_UP_SERVER_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_ID_IS_REQUIRED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_DOES_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    VDS_CANNOT_REMOVE_HOST_HAVING_GLUSTER_VOLUME(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NO_GLUSTER_HOST_TO_PEER_PROBE(ErrorType.CONFLICT),
    MIGRATE_PAUSED_EIO_VM_IS_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_FAILED_SERVER_NAME_REQUIRED(ErrorType.BAD_PARAMETERS),
    SERVER_ALREADY_EXISTS_IN_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    SERVER_ALREADY_PART_OF_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    CLUSTER_ALL_SERVERS_NOT_UP(ErrorType.CONFLICT),
    SSH_AUTHENTICATION_FAILED(ErrorType.NO_AUTHENTICATION),
    GLUSTER_NOT_SUPPORTED(ErrorType.INCOMPATIBLE_VERSION),
    GLUSTER_VOLUME_ID_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_SERVER_PART_OF_ANOTHER_CLUSTER(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_HOOK_NO_CONFLICT_SERVERS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SERVER_STATUS_NOT_UP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_SERVICE_ALREADY_RUNNING(ErrorType.CONFLICT),
    ACTION_TYEPE_FAILED_SERVICE_ALREADY_STOPPED(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_INVALID_ACTION_TYPE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CLUSTERID_AND_SERVERID_BOTH_NULL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NO_SERVERS_FOR_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VOLUME_OPERATION_IN_PROGRESS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_GLUSTER_OPERATION_INPROGRESS(ErrorType.CONFLICT),
    GLUSTER_TASKS_NOT_SUPPORTED_FOR_CLUSTER_LEVEL(ErrorType.INCOMPATIBLE_VERSION),
    // OpenStack Glance
    ACTION_TYPE_FAILED_IMAGE_DOWNLOAD_ERROR(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMAGE_UNRECOGNIZED(ErrorType.BAD_PARAMETERS),

    VM_INTERFACE_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_REMOVE_ACTIVE_DEVICE(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_IMPORT_CLONE_NOT_COLLAPSED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_IMPORT_UNREGISTERED_NOT_COLLAPSED(ErrorType.BAD_PARAMETERS),

    /* VDSM Error that propagates up to the client. See VdcBLLErrors */
    ERROR_GET_STORAGE_DOMAIN_LIST(ErrorType.INTERNAL_ERROR), // VdcBllErrors.GetStorageDomainListError

    ERROR_GET_IMAGE_LIST(ErrorType.INTERNAL_ERROR),

    USER_CANNOT_FORCE_RECONNECT_TO_VM(ErrorType.CONFLICT),
    // Engine maintenance mode
    ENGINE_IS_RUNNING_IN_MAINTENANCE_MODE(ErrorType.CONFLICT),
    // Engine prepare mode
    ENGINE_IS_RUNNING_IN_PREPARE_MODE(ErrorType.CONFLICT),

    // External Events
    ACTION_TYPE_FAILED_EXTERNAL_EVENT_ILLEGAL_ORIGIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_EXTERNAL_EVENT_NOT_FOUND(ErrorType.BAD_PARAMETERS),

    // External Tasks
    ACTION_TYPE_EMPTY_DESCRIPTION(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NOT_EXTERNAL(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_PARENT(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_JOB(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NO_STEP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_NON_MONITORED(ErrorType.NOT_SUPPORTED),

    //Internal Job
    ACTION_TYPE_EMPTY_ACTION_TYPE(ErrorType.BAD_PARAMETERS),

    //watchdog
    WATCHDOG_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    WATCHDOG_ALREADY_EXISTS(ErrorType.CONFLICT),
    WATCHDOG_ACTION_REQUIRED(ErrorType.BAD_PARAMETERS),
    WATCHDOG_MODEL_REQUIRED(ErrorType.BAD_PARAMETERS),

    //rng device
    ACTION_TYPE_FAILED_RNG_NOT_FOUND(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RNG_ALREADY_EXISTS(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_RNG_SOURCE_NOT_SUPPORTED(ErrorType.CONFLICT),
    ACTION_TYPE_RNG_MUST_BE_SPECIFIED(ErrorType.BAD_PARAMETERS),

    // QoS
    ACTION_TYPE_FAILED_QOS_OUT_OF_RANGE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_STORAGE_POOL_NOT_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_STORAGE_POOL_NOT_CONSISTENT(ErrorType.BAD_PARAMETERS),
    QOS_NAME_NOT_NULL(ErrorType.BAD_PARAMETERS),
    QOS_NAME_TOO_LONG(ErrorType.BAD_PARAMETERS),
    QOS_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NEGATIVE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NAME_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_QOS_NOT_FOUND(ErrorType.BAD_PARAMETERS),

    // network QoS
    ACTION_TYPE_FAILED_NETWORK_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NEGATIVE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_OUT_OF_RANGE_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NAME_EXIST(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_MISSING_DATA(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_INVALID_DC_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_NETWORK_QOS_PEAK_LOWER_THAN_AVERAGE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_MISSING_VALUES(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_HOST_NETWORK_QOS_PEAK_LOWER_THAN_AVERAGE(ErrorType.BAD_PARAMETERS),

    // Alignment scan
    ERROR_CANNOT_RUN_ALIGNMENT_SCAN_VM_IS_RUNNING(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_ALIGNMENT_SCAN_STORAGE_TYPE(ErrorType.NOT_SUPPORTED),

    //exteral scheduler
    EXTERNAL_SCHEDULER_FAIL(ErrorType.INTERNAL_ERROR),

    // scheduling
    VAR__FILTERTYPE__INTERNAL,
    VAR__FILTERTYPE__EXTERNAL,
    VAR__DETAIL__NETWORK_MISSING,
    VAR__DETAIL__AFFINITY_FAILED_POSITIVE,
    VAR__DETAIL__AFFINITY_FAILED_NEGATIVE,
    VAR__DETAIL__LOW_CPU_LEVEL,
    VAR__DETAIL__SWAP_VALUE_ILLEGAL,
    VAR__DETAIL__NOT_ENOUGH_MEMORY,
    VAR__DETAIL__NOT_MEMORY_PINNED_NUMA,
    VAR__DETAIL__NOT_ENOUGH_CORES,
    VAR__DETAIL__NUMA_PINNING_FAILED,
    VAR__DETAIL__NOT_HE_HOST,
    SCHEDULING_NO_HOSTS,
    SCHEDULING_HOST_FILTERED_REASON,
    SCHEDULING_HOST_FILTERED_REASON_WITH_DETAIL,
    SCHEDULING_ALL_HOSTS_FILTERED_OUT(ErrorType.CONFLICT),

    // memory QOS features
    QOS_BALLOON_NOT_SUPPORTED(ErrorType.BAD_PARAMETERS),

    // CPU QoS features
    QOS_CPU_SHARES_OUT_OF_RANGE(ErrorType.BAD_PARAMETERS),

    // profiles
    ACTION_TYPE_FAILED_PROFILE_MISSING(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_NOT_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_NAME_IN_USE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_PROFILE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_PROFILE_IN_USE(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DISK_PROFILE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_STORAGE_DOMAIN_NOT_PROVIDED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_DISK_PROFILE_NOT_MATCH_STORAGE_DOMAIN(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_CLUSTER_NOT_PROVIDED(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_EMPTY(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CPU_PROFILE_NOT_FOUND(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CPU_PROFILE_NOT_MATCH_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_CANNOT_REMOVE_LAST_CPU_PROFILE_IN_CLUSTER(ErrorType.NOT_SUPPORTED),
    ACTION_TYPE_CANNOT_REMOVE_LAST_DISK_PROFILE_IN_STORAGE_DOMAIN(ErrorType.NOT_SUPPORTED),
    USER_NOT_AUTHORIZED_TO_ATTACH_DISK_PROFILE(ErrorType.NO_PERMISSION),

    // Affinity Groups
    AFFINITY_GROUP_NAME_TOO_LONG(ErrorType.BAD_PARAMETERS),
    AFFINITY_GROUP_NAME_INVALID(ErrorType.BAD_PARAMETERS),
    AFFINITY_GROUP_DESCRIPTION_INVALID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AFFINITY_GROUP_INVALID_CLUSTER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_CLUSTER_FOR_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_VM_FOR_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_VM_NOT_IN_AFFINITY_GROUP_CLUSTER(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_DUPLICTE_VM_IN_AFFINITY_GROUP(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_INVALID_AFFINITY_GROUP_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_CANNOT_CHANGE_CLUSTER_ID(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_AFFINITY_GROUP_NAME_EXISTS(ErrorType.BAD_PARAMETERS),
    ACTION_TYPE_FAILED_POSITIVE_AFFINITY_GROUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_NEGATIVE_AFFINITY_GROUP(ErrorType.CONFLICT),
    ACTION_TYPE_FAILED_MIX_POSITIVE_NEGATIVE_AFFINITY_GROUP(ErrorType.CONFLICT),

    // Iscsi bonds
    ISCSI_BOND_WITH_SAME_NAME_EXIST_IN_DATA_CENTER(ErrorType.CONFLICT),
    ISCSI_BOND_NOT_SUPPORTED(ErrorType.NOT_SUPPORTED),
    ISCSI_BOND_NOT_EXIST(ErrorType.BAD_PARAMETERS),

    // Kdump detection
    KDUMP_DETECTION_NOT_ENABLED_FOR_VDS(ErrorType.BAD_PARAMETERS),
    KDUMP_DETECTION_NOT_CONFIGURED_ON_VDS(ErrorType.BAD_PARAMETERS),

    CPU_TYPE_UNSUPPORTED_FOR_THE_GUEST_OS(ErrorType.BAD_PARAMETERS),

    //balloon on ppc
    BALLOON_REQUESTED_ON_NOT_SUPPORTED_ARCH(ErrorType.NOT_SUPPORTED);

    private ErrorType messageType;

    VdcBllMessages() {
        this.messageType = null;
    }

    VdcBllMessages(ErrorType messageType) {
        this.messageType = messageType;
    }

    public ErrorType getErrorType() {
        return messageType;
    }

    public static ErrorType getErrorType(String error) {
        try {
            return valueOf(error).getErrorType();
        } catch (Exception e) {
            return null;
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    public static VdcBllMessages forValue(int value) {
        return values()[value];
    }
}
