// ============================================================================
//
// Copyright (c) 2006-2015, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.validateinstallation_4_1;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

@SuppressWarnings("unused")
/**
 * Job: ValidateInstallation Purpose: <br>
 * Description:  <br>
 * @author test@talend.com
 * @version 6.1.1.20151214_1327
 * @status 
 */
public class ValidateInstallation implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (dwhUuid != null) {

				this.setProperty("dwhUuid", dwhUuid.toString());

			}

			if (endTime != null) {

				String pattern_endTime = "yyyy-MM-dd HH:mm:ss";
				String value_endTime = "";
				String[] parts_endTime = value_endTime.split(";");
				if (parts_endTime.length > 1) {
					pattern_endTime = parts_endTime[0];
					this.setProperty(
							"endTime",
							pattern_endTime
									+ ";"
									+ FormatterUtils.format_Date(endTime,
											pattern_endTime));
				} else {
					this.setProperty("endTime", FormatterUtils.format_Date(
							endTime, pattern_endTime));
				}

			}

			if (etlVersion != null) {

				this.setProperty("etlVersion", etlVersion.toString());

			}

			if (hoursToKeepDaily != null) {

				this.setProperty("hoursToKeepDaily",
						hoursToKeepDaily.toString());

			}

			if (hoursToKeepHourly != null) {

				this.setProperty("hoursToKeepHourly",
						hoursToKeepHourly.toString());

			}

			if (hoursToKeepSamples != null) {

				this.setProperty("hoursToKeepSamples",
						hoursToKeepSamples.toString());

			}

			if (lastErrorSent != null) {

				String pattern_lastErrorSent = "yyyy-MM-dd HH:mm:ss";
				String value_lastErrorSent = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_lastErrorSent = value_lastErrorSent.split(";");
				if (parts_lastErrorSent.length > 1) {
					pattern_lastErrorSent = parts_lastErrorSent[0];
					this.setProperty(
							"lastErrorSent",
							pattern_lastErrorSent
									+ ";"
									+ FormatterUtils.format_Date(lastErrorSent,
											pattern_lastErrorSent));
				} else {
					this.setProperty("lastErrorSent", FormatterUtils
							.format_Date(lastErrorSent, pattern_lastErrorSent));
				}

			}

			if (lastSampling != null) {

				String pattern_lastSampling = "yyyy-MM-dd HH:mm:ss";
				String value_lastSampling = "yyyy-MM-dd HH:mm:ss;2000-01-01 00:00:00";
				String[] parts_lastSampling = value_lastSampling.split(";");
				if (parts_lastSampling.length > 1) {
					pattern_lastSampling = parts_lastSampling[0];
					this.setProperty(
							"lastSampling",
							pattern_lastSampling
									+ ";"
									+ FormatterUtils.format_Date(lastSampling,
											pattern_lastSampling));
				} else {
					this.setProperty("lastSampling", FormatterUtils
							.format_Date(lastSampling, pattern_lastSampling));
				}

			}

			if (lastStatisticsUpdate != null) {

				String pattern_lastStatisticsUpdate = "yyyy-MM-dd HH:mm:ss";
				String value_lastStatisticsUpdate = "yyyy-MM-dd HH:mm:ss;2013-03-05 18:14:53";
				String[] parts_lastStatisticsUpdate = value_lastStatisticsUpdate
						.split(";");
				if (parts_lastStatisticsUpdate.length > 1) {
					pattern_lastStatisticsUpdate = parts_lastStatisticsUpdate[0];
					this.setProperty(
							"lastStatisticsUpdate",
							pattern_lastStatisticsUpdate
									+ ";"
									+ FormatterUtils.format_Date(
											lastStatisticsUpdate,
											pattern_lastStatisticsUpdate));
				} else {
					this.setProperty("lastStatisticsUpdate", FormatterUtils
							.format_Date(lastStatisticsUpdate,
									pattern_lastStatisticsUpdate));
				}

			}

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runDeleteTime != null) {

				this.setProperty("runDeleteTime", runDeleteTime.toString());

			}

			if (runInterleave != null) {

				this.setProperty("runInterleave", runInterleave.toString());

			}

			if (runTime != null) {

				String pattern_runTime = "yyyy-MM-dd HH:mm:ss";
				String value_runTime = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_runTime = value_runTime.split(";");
				if (parts_runTime.length > 1) {
					pattern_runTime = parts_runTime[0];
					this.setProperty(
							"runTime",
							pattern_runTime
									+ ";"
									+ FormatterUtils.format_Date(runTime,
											pattern_runTime));
				} else {
					this.setProperty("runTime", FormatterUtils.format_Date(
							runTime, pattern_runTime));
				}

			}

			if (timeBetweenErrorEvents != null) {

				this.setProperty("timeBetweenErrorEvents",
						timeBetweenErrorEvents.toString());

			}

			if (timesFailed != null) {

				this.setProperty("timesFailed", timesFailed.toString());

			}

			if (dwhUuidEngine != null) {

				this.setProperty("dwhUuidEngine", dwhUuidEngine.toString());

			}

			if (dwhHostname != null) {

				this.setProperty("dwhHostname", dwhHostname.toString());

			}

		}

		public String dwhUuid;

		public String getDwhUuid() {
			return this.dwhUuid;
		}

		public java.util.Date endTime;

		public java.util.Date getEndTime() {
			return this.endTime;
		}

		public String etlVersion;

		public String getEtlVersion() {
			return this.etlVersion;
		}

		public Integer hoursToKeepDaily;

		public Integer getHoursToKeepDaily() {
			return this.hoursToKeepDaily;
		}

		public Integer hoursToKeepHourly;

		public Integer getHoursToKeepHourly() {
			return this.hoursToKeepHourly;
		}

		public Integer hoursToKeepSamples;

		public Integer getHoursToKeepSamples() {
			return this.hoursToKeepSamples;
		}

		public java.util.Date lastErrorSent;

		public java.util.Date getLastErrorSent() {
			return this.lastErrorSent;
		}

		public java.util.Date lastSampling;

		public java.util.Date getLastSampling() {
			return this.lastSampling;
		}

		public java.util.Date lastStatisticsUpdate;

		public java.util.Date getLastStatisticsUpdate() {
			return this.lastStatisticsUpdate;
		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public Integer runDeleteTime;

		public Integer getRunDeleteTime() {
			return this.runDeleteTime;
		}

		public Integer runInterleave;

		public Integer getRunInterleave() {
			return this.runInterleave;
		}

		public java.util.Date runTime;

		public java.util.Date getRunTime() {
			return this.runTime;
		}

		public Long timeBetweenErrorEvents;

		public Long getTimeBetweenErrorEvents() {
			return this.timeBetweenErrorEvents;
		}

		public Integer timesFailed;

		public Integer getTimesFailed() {
			return this.timesFailed;
		}

		public String dwhUuidEngine;

		public String getDwhUuidEngine() {
			return this.dwhUuidEngine;
		}

		public String dwhHostname;

		public String getDwhHostname() {
			return this.dwhHostname;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "4.1";
	private final String jobName = "ValidateInstallation";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = new java.util.HashMap<String, Object>();
	private final static java.util.Map<String, Object> junitGlobalMap = new java.util.HashMap<String, Object>();

	private final java.util.Map<String, Long> start_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Long> end_Hash = new java.util.HashMap<String, Long>();
	private final java.util.Map<String, Boolean> ok_Hash = new java.util.HashMap<String, Boolean>();
	public final java.util.List<String[]> globalBuffer = new java.util.ArrayList<String[]>();

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private Exception exception;

	public Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					ValidateInstallation.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(ValidateInstallation.this, new Object[] {
									e, currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGSProcess(globalMap);
					}
				} catch (TalendException e) {
					// do nothing

				} catch (Exception e) {
					this.e.printStackTrace();
				}
			}
		}
	}

	public void tJDBCConnection_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_1_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tContextLoad_2_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tJDBCInput_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tDie_1_error(Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		tDie_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		status = "failure";

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCInput_2_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tDie_1_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "engine-events";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(true);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCInput_1Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public static class dwhUuidEngineStruct implements
			routines.system.IPersistableRow<dwhUuidEngineStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(dwhUuidEngineStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row10Struct implements
			routines.system.IPersistableRow<row10Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row10Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row10Struct row10 = new row10Struct();
				dwhUuidEngineStruct dwhUuidEngine = new dwhUuidEngineStruct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());

				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				dwhUuidEngineStruct dwhUuidEngine_tmp = new dwhUuidEngineStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tJDBCInput_1 begin ] start
				 */

				ok_Hash.put("tJDBCInput_1", false);
				start_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				currentComponent = "tJDBCInput_1";

				int tos_count_tJDBCInput_1 = 0;

				int nb_line_tJDBCInput_1 = 0;
				java.sql.Connection conn_tJDBCInput_1 = null;
				conn_tJDBCInput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
						.createStatement();

				String dbquery_tJDBCInput_1 = "SELECT 'dwhUuidEngine', var_value FROM dwh_history_timekeeping WHERE var_name = 'dwhUuid'";

				globalMap.put("tJDBCInput_1_QUERY", dbquery_tJDBCInput_1);

				java.sql.ResultSet rs_tJDBCInput_1 = null;
				try {
					rs_tJDBCInput_1 = stmt_tJDBCInput_1
							.executeQuery(dbquery_tJDBCInput_1);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
							.getMetaData();
					int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
							.getColumnCount();

					String tmpContent_tJDBCInput_1 = null;

					while (rs_tJDBCInput_1.next()) {
						nb_line_tJDBCInput_1++;

						if (colQtyInRs_tJDBCInput_1 < 1) {
							row10.key = null;
						} else {

							row10.key = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_1, 1, false);
						}
						if (colQtyInRs_tJDBCInput_1 < 2) {
							row10.value = null;
						} else {

							row10.value = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_1, 2, false);
						}

						/**
						 * [tJDBCInput_1 begin ] stop
						 */

						/**
						 * [tJDBCInput_1 main ] start
						 */

						currentComponent = "tJDBCInput_1";

						tos_count_tJDBCInput_1++;

						/**
						 * [tJDBCInput_1 main ] stop
						 */

						/**
						 * [tMap_1 main ] start
						 */

						currentComponent = "tMap_1";

						boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_1 = false;
						boolean mainRowRejected_tMap_1 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
							// ###############################
							// # Output tables

							dwhUuidEngine = null;

							// # Output table : 'dwhUuidEngine'
							dwhUuidEngine_tmp.key = row10.key;
							dwhUuidEngine_tmp.value = row10.value;
							dwhUuidEngine = dwhUuidEngine_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_1 = false;

						tos_count_tMap_1++;

						/**
						 * [tMap_1 main ] stop
						 */
						// Start of branch "dwhUuidEngine"
						if (dwhUuidEngine != null) {

							/**
							 * [tContextLoad_1 main ] start
							 */

							currentComponent = "tContextLoad_1";

							// ////////////////////////
							String tmp_key_tContextLoad_1 = null;
							String key_tContextLoad_1 = null;
							if (dwhUuidEngine.key != null) {
								tmp_key_tContextLoad_1 = dwhUuidEngine.key
										.trim();
								if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
										.startsWith("!"))) {
									tmp_key_tContextLoad_1 = null;
								} else {
									dwhUuidEngine.key = tmp_key_tContextLoad_1;
								}
							}
							if (dwhUuidEngine.key != null) {
								key_tContextLoad_1 = dwhUuidEngine.key;
							}
							String value_tContextLoad_1 = null;
							if (dwhUuidEngine.value != null) {
								value_tContextLoad_1 = dwhUuidEngine.value;
							}

							if (tmp_key_tContextLoad_1 != null) {
								try {
									if (key_tContextLoad_1 != null
											&& "dwhUuid"
													.equals(key_tContextLoad_1)) {
										context.dwhUuid = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "endTime"
													.equals(key_tContextLoad_1)) {
										String context_endTime_value = context
												.getProperty("endTime");
										if (context_endTime_value == null)
											context_endTime_value = "";
										int context_endTime_pos = context_endTime_value
												.indexOf(";");
										String context_endTime_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_endTime_pos > -1) {
											context_endTime_pattern = context_endTime_value
													.substring(0,
															context_endTime_pos);
										}
										context.endTime = (java.util.Date) (new java.text.SimpleDateFormat(
												context_endTime_pattern)
												.parse(value_tContextLoad_1));

									}

									if (key_tContextLoad_1 != null
											&& "etlVersion"
													.equals(key_tContextLoad_1)) {
										context.etlVersion = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "hoursToKeepDaily"
													.equals(key_tContextLoad_1)) {

										context.hoursToKeepDaily = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "hoursToKeepHourly"
													.equals(key_tContextLoad_1)) {

										context.hoursToKeepHourly = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "hoursToKeepSamples"
													.equals(key_tContextLoad_1)) {

										context.hoursToKeepSamples = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "lastErrorSent"
													.equals(key_tContextLoad_1)) {
										String context_lastErrorSent_value = context
												.getProperty("lastErrorSent");
										if (context_lastErrorSent_value == null)
											context_lastErrorSent_value = "";
										int context_lastErrorSent_pos = context_lastErrorSent_value
												.indexOf(";");
										String context_lastErrorSent_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastErrorSent_pos > -1) {
											context_lastErrorSent_pattern = context_lastErrorSent_value
													.substring(0,
															context_lastErrorSent_pos);
										}
										context.lastErrorSent = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastErrorSent_pattern)
												.parse(value_tContextLoad_1));

									}

									if (key_tContextLoad_1 != null
											&& "lastSampling"
													.equals(key_tContextLoad_1)) {
										String context_lastSampling_value = context
												.getProperty("lastSampling");
										if (context_lastSampling_value == null)
											context_lastSampling_value = "";
										int context_lastSampling_pos = context_lastSampling_value
												.indexOf(";");
										String context_lastSampling_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastSampling_pos > -1) {
											context_lastSampling_pattern = context_lastSampling_value
													.substring(0,
															context_lastSampling_pos);
										}
										context.lastSampling = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastSampling_pattern)
												.parse(value_tContextLoad_1));

									}

									if (key_tContextLoad_1 != null
											&& "lastStatisticsUpdate"
													.equals(key_tContextLoad_1)) {
										String context_lastStatisticsUpdate_value = context
												.getProperty("lastStatisticsUpdate");
										if (context_lastStatisticsUpdate_value == null)
											context_lastStatisticsUpdate_value = "";
										int context_lastStatisticsUpdate_pos = context_lastStatisticsUpdate_value
												.indexOf(";");
										String context_lastStatisticsUpdate_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastStatisticsUpdate_pos > -1) {
											context_lastStatisticsUpdate_pattern = context_lastStatisticsUpdate_value
													.substring(0,
															context_lastStatisticsUpdate_pos);
										}
										context.lastStatisticsUpdate = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastStatisticsUpdate_pattern)
												.parse(value_tContextLoad_1));

									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineDbDriverClass"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineDbDriverClass = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineDbJdbcConnection"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineDbPassword"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineDbPassword = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineDbUser"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineDbUser = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineHistoryDbDriverClass"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineHistoryDbJdbcConnection"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineHistoryDbPassword"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "ovirtEngineHistoryDbUser"
													.equals(key_tContextLoad_1)) {
										context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "runDeleteTime"
													.equals(key_tContextLoad_1)) {

										context.runDeleteTime = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "runInterleave"
													.equals(key_tContextLoad_1)) {

										context.runInterleave = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "runTime"
													.equals(key_tContextLoad_1)) {
										String context_runTime_value = context
												.getProperty("runTime");
										if (context_runTime_value == null)
											context_runTime_value = "";
										int context_runTime_pos = context_runTime_value
												.indexOf(";");
										String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_runTime_pos > -1) {
											context_runTime_pattern = context_runTime_value
													.substring(0,
															context_runTime_pos);
										}
										context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
												context_runTime_pattern)
												.parse(value_tContextLoad_1));

									}

									if (key_tContextLoad_1 != null
											&& "timeBetweenErrorEvents"
													.equals(key_tContextLoad_1)) {

										context.timeBetweenErrorEvents = Long
												.parseLong(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "timesFailed"
													.equals(key_tContextLoad_1)) {

										context.timesFailed = Integer
												.parseInt(value_tContextLoad_1);

									}

									if (key_tContextLoad_1 != null
											&& "dwhUuidEngine"
													.equals(key_tContextLoad_1)) {
										context.dwhUuidEngine = value_tContextLoad_1;
									}

									if (key_tContextLoad_1 != null
											&& "dwhHostname"
													.equals(key_tContextLoad_1)) {
										context.dwhHostname = value_tContextLoad_1;
									}

									if (context.getProperty(key_tContextLoad_1) != null) {
										assignList_tContextLoad_1
												.add(key_tContextLoad_1);
									} else {
										newPropertyList_tContextLoad_1
												.add(key_tContextLoad_1);
									}
									if (value_tContextLoad_1 == null) {
										context.setProperty(key_tContextLoad_1,
												"");
									} else {
										context.setProperty(key_tContextLoad_1,
												value_tContextLoad_1);
									}
								} catch (java.lang.Exception e) {
									System.err
											.println("Setting a value for the key \""
													+ key_tContextLoad_1
													+ "\" has failed. Error message: "
													+ e.getMessage());
								}
								nb_line_tContextLoad_1++;
							}
							// ////////////////////////

							tos_count_tContextLoad_1++;

							/**
							 * [tContextLoad_1 main ] stop
							 */

						} // End of branch "dwhUuidEngine"

						/**
						 * [tJDBCInput_1 end ] start
						 */

						currentComponent = "tJDBCInput_1";

					}
				} finally {
					if (rs_tJDBCInput_1 != null) {
						rs_tJDBCInput_1.close();
					}
					stmt_tJDBCInput_1.close();

				}
				globalMap.put("tJDBCInput_1_NB_LINE", nb_line_tJDBCInput_1);

				ok_Hash.put("tJDBCInput_1", true);
				end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

				if (!(context.dwhUuid).equals(context.dwhUuidEngine)
						|| Relational.ISNULL(context.dwhUuidEngine)
				/*
				 * We also do not allow context.dwhUuid to be null, but in this
				 * case they will be unequal
				 */) {

					tJDBCInput_2Process(globalMap);
				}

				/**
				 * [tJDBCInput_1 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				List<String> parametersToEncrypt_tContextLoad_1 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_1.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_1
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_1));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tMap_1 finally ] start
				 */

				currentComponent = "tMap_1";

				/**
				 * [tMap_1 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_1_SUBPROCESS_STATE", 1);
	}

	public static class dwhHostnameStruct implements
			routines.system.IPersistableRow<dwhHostnameStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(dwhHostnameStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row11Struct implements
			routines.system.IPersistableRow<row11Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row11Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tJDBCInput_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row11Struct row11 = new row11Struct();
				dwhHostnameStruct dwhHostname = new dwhHostnameStruct();

				/**
				 * [tContextLoad_2 begin ] start
				 */

				ok_Hash.put("tContextLoad_2", false);
				start_Hash.put("tContextLoad_2", System.currentTimeMillis());

				currentComponent = "tContextLoad_2";

				int tos_count_tContextLoad_2 = 0;

				java.util.List<String> assignList_tContextLoad_2 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_2 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_2 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_2 = 0;

				/**
				 * [tContextLoad_2 begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());

				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				dwhHostnameStruct dwhHostname_tmp = new dwhHostnameStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tJDBCInput_2 begin ] start
				 */

				ok_Hash.put("tJDBCInput_2", false);
				start_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				currentComponent = "tJDBCInput_2";

				int tos_count_tJDBCInput_2 = 0;

				int nb_line_tJDBCInput_2 = 0;
				java.sql.Connection conn_tJDBCInput_2 = null;
				conn_tJDBCInput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");

				java.sql.Statement stmt_tJDBCInput_2 = conn_tJDBCInput_2
						.createStatement();

				String dbquery_tJDBCInput_2 = "SELECT 'dwhHostname', var_value FROM dwh_history_timekeeping WHERE var_name = 'dwhHostname'";

				globalMap.put("tJDBCInput_2_QUERY", dbquery_tJDBCInput_2);

				java.sql.ResultSet rs_tJDBCInput_2 = null;
				try {
					rs_tJDBCInput_2 = stmt_tJDBCInput_2
							.executeQuery(dbquery_tJDBCInput_2);
					java.sql.ResultSetMetaData rsmd_tJDBCInput_2 = rs_tJDBCInput_2
							.getMetaData();
					int colQtyInRs_tJDBCInput_2 = rsmd_tJDBCInput_2
							.getColumnCount();

					String tmpContent_tJDBCInput_2 = null;

					while (rs_tJDBCInput_2.next()) {
						nb_line_tJDBCInput_2++;

						if (colQtyInRs_tJDBCInput_2 < 1) {
							row11.key = null;
						} else {

							row11.key = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_2, 1, false);
						}
						if (colQtyInRs_tJDBCInput_2 < 2) {
							row11.value = null;
						} else {

							row11.value = routines.system.JDBCUtil.getString(
									rs_tJDBCInput_2, 2, false);
						}

						/**
						 * [tJDBCInput_2 begin ] stop
						 */

						/**
						 * [tJDBCInput_2 main ] start
						 */

						currentComponent = "tJDBCInput_2";

						tos_count_tJDBCInput_2++;

						/**
						 * [tJDBCInput_2 main ] stop
						 */

						/**
						 * [tMap_2 main ] start
						 */

						currentComponent = "tMap_2";

						boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

						// ###############################
						// # Input tables (lookups)
						boolean rejectedInnerJoin_tMap_2 = false;
						boolean mainRowRejected_tMap_2 = false;

						// ###############################
						{ // start of Var scope

							// ###############################
							// # Vars tables

							Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
							// ###############################
							// # Output tables

							dwhHostname = null;

							// # Output table : 'dwhHostname'
							dwhHostname_tmp.key = row11.key;
							dwhHostname_tmp.value = row11.value;
							dwhHostname = dwhHostname_tmp;
							// ###############################

						} // end of Var scope

						rejectedInnerJoin_tMap_2 = false;

						tos_count_tMap_2++;

						/**
						 * [tMap_2 main ] stop
						 */
						// Start of branch "dwhHostname"
						if (dwhHostname != null) {

							/**
							 * [tContextLoad_2 main ] start
							 */

							currentComponent = "tContextLoad_2";

							// ////////////////////////
							String tmp_key_tContextLoad_2 = null;
							String key_tContextLoad_2 = null;
							if (dwhHostname.key != null) {
								tmp_key_tContextLoad_2 = dwhHostname.key.trim();
								if ((tmp_key_tContextLoad_2.startsWith("#") || tmp_key_tContextLoad_2
										.startsWith("!"))) {
									tmp_key_tContextLoad_2 = null;
								} else {
									dwhHostname.key = tmp_key_tContextLoad_2;
								}
							}
							if (dwhHostname.key != null) {
								key_tContextLoad_2 = dwhHostname.key;
							}
							String value_tContextLoad_2 = null;
							if (dwhHostname.value != null) {
								value_tContextLoad_2 = dwhHostname.value;
							}

							if (tmp_key_tContextLoad_2 != null) {
								try {
									if (key_tContextLoad_2 != null
											&& "dwhUuid"
													.equals(key_tContextLoad_2)) {
										context.dwhUuid = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "endTime"
													.equals(key_tContextLoad_2)) {
										String context_endTime_value = context
												.getProperty("endTime");
										if (context_endTime_value == null)
											context_endTime_value = "";
										int context_endTime_pos = context_endTime_value
												.indexOf(";");
										String context_endTime_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_endTime_pos > -1) {
											context_endTime_pattern = context_endTime_value
													.substring(0,
															context_endTime_pos);
										}
										context.endTime = (java.util.Date) (new java.text.SimpleDateFormat(
												context_endTime_pattern)
												.parse(value_tContextLoad_2));

									}

									if (key_tContextLoad_2 != null
											&& "etlVersion"
													.equals(key_tContextLoad_2)) {
										context.etlVersion = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "hoursToKeepDaily"
													.equals(key_tContextLoad_2)) {

										context.hoursToKeepDaily = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "hoursToKeepHourly"
													.equals(key_tContextLoad_2)) {

										context.hoursToKeepHourly = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "hoursToKeepSamples"
													.equals(key_tContextLoad_2)) {

										context.hoursToKeepSamples = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "lastErrorSent"
													.equals(key_tContextLoad_2)) {
										String context_lastErrorSent_value = context
												.getProperty("lastErrorSent");
										if (context_lastErrorSent_value == null)
											context_lastErrorSent_value = "";
										int context_lastErrorSent_pos = context_lastErrorSent_value
												.indexOf(";");
										String context_lastErrorSent_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastErrorSent_pos > -1) {
											context_lastErrorSent_pattern = context_lastErrorSent_value
													.substring(0,
															context_lastErrorSent_pos);
										}
										context.lastErrorSent = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastErrorSent_pattern)
												.parse(value_tContextLoad_2));

									}

									if (key_tContextLoad_2 != null
											&& "lastSampling"
													.equals(key_tContextLoad_2)) {
										String context_lastSampling_value = context
												.getProperty("lastSampling");
										if (context_lastSampling_value == null)
											context_lastSampling_value = "";
										int context_lastSampling_pos = context_lastSampling_value
												.indexOf(";");
										String context_lastSampling_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastSampling_pos > -1) {
											context_lastSampling_pattern = context_lastSampling_value
													.substring(0,
															context_lastSampling_pos);
										}
										context.lastSampling = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastSampling_pattern)
												.parse(value_tContextLoad_2));

									}

									if (key_tContextLoad_2 != null
											&& "lastStatisticsUpdate"
													.equals(key_tContextLoad_2)) {
										String context_lastStatisticsUpdate_value = context
												.getProperty("lastStatisticsUpdate");
										if (context_lastStatisticsUpdate_value == null)
											context_lastStatisticsUpdate_value = "";
										int context_lastStatisticsUpdate_pos = context_lastStatisticsUpdate_value
												.indexOf(";");
										String context_lastStatisticsUpdate_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_lastStatisticsUpdate_pos > -1) {
											context_lastStatisticsUpdate_pattern = context_lastStatisticsUpdate_value
													.substring(0,
															context_lastStatisticsUpdate_pos);
										}
										context.lastStatisticsUpdate = (java.util.Date) (new java.text.SimpleDateFormat(
												context_lastStatisticsUpdate_pattern)
												.parse(value_tContextLoad_2));

									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineDbDriverClass"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineDbDriverClass = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineDbJdbcConnection"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineDbJdbcConnection = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineDbPassword"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineDbPassword = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineDbUser"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineDbUser = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineHistoryDbDriverClass"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineHistoryDbJdbcConnection"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineHistoryDbPassword"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineHistoryDbPassword = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "ovirtEngineHistoryDbUser"
													.equals(key_tContextLoad_2)) {
										context.ovirtEngineHistoryDbUser = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "runDeleteTime"
													.equals(key_tContextLoad_2)) {

										context.runDeleteTime = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "runInterleave"
													.equals(key_tContextLoad_2)) {

										context.runInterleave = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "runTime"
													.equals(key_tContextLoad_2)) {
										String context_runTime_value = context
												.getProperty("runTime");
										if (context_runTime_value == null)
											context_runTime_value = "";
										int context_runTime_pos = context_runTime_value
												.indexOf(";");
										String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
										if (context_runTime_pos > -1) {
											context_runTime_pattern = context_runTime_value
													.substring(0,
															context_runTime_pos);
										}
										context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
												context_runTime_pattern)
												.parse(value_tContextLoad_2));

									}

									if (key_tContextLoad_2 != null
											&& "timeBetweenErrorEvents"
													.equals(key_tContextLoad_2)) {

										context.timeBetweenErrorEvents = Long
												.parseLong(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "timesFailed"
													.equals(key_tContextLoad_2)) {

										context.timesFailed = Integer
												.parseInt(value_tContextLoad_2);

									}

									if (key_tContextLoad_2 != null
											&& "dwhUuidEngine"
													.equals(key_tContextLoad_2)) {
										context.dwhUuidEngine = value_tContextLoad_2;
									}

									if (key_tContextLoad_2 != null
											&& "dwhHostname"
													.equals(key_tContextLoad_2)) {
										context.dwhHostname = value_tContextLoad_2;
									}

									if (context.getProperty(key_tContextLoad_2) != null) {
										assignList_tContextLoad_2
												.add(key_tContextLoad_2);
									} else {
										newPropertyList_tContextLoad_2
												.add(key_tContextLoad_2);
									}
									if (value_tContextLoad_2 == null) {
										context.setProperty(key_tContextLoad_2,
												"");
									} else {
										context.setProperty(key_tContextLoad_2,
												value_tContextLoad_2);
									}
								} catch (java.lang.Exception e) {
									System.err
											.println("Setting a value for the key \""
													+ key_tContextLoad_2
													+ "\" has failed. Error message: "
													+ e.getMessage());
								}
								nb_line_tContextLoad_2++;
							}
							// ////////////////////////

							tos_count_tContextLoad_2++;

							/**
							 * [tContextLoad_2 main ] stop
							 */

						} // End of branch "dwhHostname"

						/**
						 * [tJDBCInput_2 end ] start
						 */

						currentComponent = "tJDBCInput_2";

					}
				} finally {
					if (rs_tJDBCInput_2 != null) {
						rs_tJDBCInput_2.close();
					}
					stmt_tJDBCInput_2.close();

				}
				globalMap.put("tJDBCInput_2_NB_LINE", nb_line_tJDBCInput_2);

				ok_Hash.put("tJDBCInput_2", true);
				end_Hash.put("tJDBCInput_2", System.currentTimeMillis());

				/**
				 * [tJDBCInput_2 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tContextLoad_2 end ] start
				 */

				currentComponent = "tContextLoad_2";

				java.util.Enumeration<?> enu_tContextLoad_2 = context
						.propertyNames();
				while (enu_tContextLoad_2.hasMoreElements()) {
					String key_tContextLoad_2 = (String) enu_tContextLoad_2
							.nextElement();
					if (!assignList_tContextLoad_2.contains(key_tContextLoad_2)
							&& !newPropertyList_tContextLoad_2
									.contains(key_tContextLoad_2)) {
						noAssignList_tContextLoad_2.add(key_tContextLoad_2);
					}
				}

				String newPropertyStr_tContextLoad_2 = newPropertyList_tContextLoad_2
						.toString();
				String newProperty_tContextLoad_2 = newPropertyStr_tContextLoad_2
						.substring(1,
								newPropertyStr_tContextLoad_2.length() - 1);

				String noAssignStr_tContextLoad_2 = noAssignList_tContextLoad_2
						.toString();
				String noAssign_tContextLoad_2 = noAssignStr_tContextLoad_2
						.substring(1, noAssignStr_tContextLoad_2.length() - 1);

				globalMap.put("tContextLoad_2_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_2);
				globalMap.put("tContextLoad_2_KEY_NOT_LOADED",
						noAssign_tContextLoad_2);

				globalMap.put("tContextLoad_2_NB_LINE", nb_line_tContextLoad_2);

				List<String> parametersToEncrypt_tContextLoad_2 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_2.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_2
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_2", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_2));

				ok_Hash.put("tContextLoad_2", true);
				end_Hash.put("tContextLoad_2", System.currentTimeMillis());

				/**
				 * [tContextLoad_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCInput_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tDie_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCInput_2 finally ] start
				 */

				currentComponent = "tJDBCInput_2";

				/**
				 * [tJDBCInput_2 finally ] stop
				 */

				/**
				 * [tMap_2 finally ] start
				 */

				currentComponent = "tMap_2";

				/**
				 * [tMap_2 finally ] stop
				 */

				/**
				 * [tContextLoad_2 finally ] start
				 */

				currentComponent = "tContextLoad_2";

				/**
				 * [tContextLoad_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCInput_2_SUBPROCESS_STATE", 1);
	}

	public void tDie_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tDie_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tDie_1 begin ] start
				 */

				ok_Hash.put("tDie_1", false);
				start_Hash.put("tDie_1", System.currentTimeMillis());

				currentComponent = "tDie_1";

				int tos_count_tDie_1 = 0;

				/**
				 * [tDie_1 begin ] stop
				 */

				/**
				 * [tDie_1 main ] start
				 */

				currentComponent = "tDie_1";

				talendLogs_LOGS
						.addMessage(
								"tDie",
								"tDie_1",
								5,
								TalendDate.getDate("YYYY-MM-DD hh:mm:ss")
										+ "| This installation is invalid. There might be a more recent DWH instance on host - "
										+ context.dwhHostname + ".", 5);
				talendLogs_LOGSProcess(globalMap);

				globalMap.put("tDie_1_DIE_PRIORITY", 5);
				System.err
						.println(TalendDate.getDate("YYYY-MM-DD hh:mm:ss")
								+ "| This installation is invalid. There might be a more recent DWH instance on host - "
								+ context.dwhHostname + ".");

				globalMap
						.put("tDie_1_DIE_MESSAGE",
								TalendDate.getDate("YYYY-MM-DD hh:mm:ss")
										+ "| This installation is invalid. There might be a more recent DWH instance on host - "
										+ context.dwhHostname + ".");
				globalMap
						.put("tDie_1_DIE_MESSAGES",
								TalendDate.getDate("YYYY-MM-DD hh:mm:ss")
										+ "| This installation is invalid. There might be a more recent DWH instance on host - "
										+ context.dwhHostname + ".");
				currentComponent = "tDie_1";
				status = "failure";
				errorCode = new Integer(5);
				globalMap.put("tDie_1_DIE_CODE", errorCode);

				if (true) {
					throw new TDieException();
				}

				tos_count_tDie_1++;

				/**
				 * [tDie_1 main ] stop
				 */

				/**
				 * [tDie_1 end ] start
				 */

				currentComponent = "tDie_1";

				ok_Hash.put("tDie_1", true);
				end_Hash.put("tDie_1", System.currentTimeMillis());

				/**
				 * [tDie_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tDie_1 finally ] start
				 */

				currentComponent = "tDie_1";

				/**
				 * [tDie_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tDie_1_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation = new byte[2 * length];
					}
				}
				dis.readFully(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_ValidateInstallation,
						0, length, utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_ValidateInstallation) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}
					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final ValidateInstallation ValidateInstallationClass = new ValidateInstallation();

		int exitCode = ValidateInstallationClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = ValidateInstallation.class
					.getClassLoader().getResourceAsStream(
							"ovirt_engine_dwh/validateinstallation_4_1/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.dwhUuid = (String) context.getProperty("dwhUuid");
			try {
				String context_endTime_value = context.getProperty("endTime");
				if (context_endTime_value == null) {
					context_endTime_value = "";
				}
				int context_endTime_pos = context_endTime_value.indexOf(";");
				String context_endTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_endTime_pos > -1) {
					context_endTime_pattern = context_endTime_value.substring(
							0, context_endTime_pos);
					context_endTime_value = context_endTime_value
							.substring(context_endTime_pos + 1);
				}

				context.endTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_endTime_pattern).parse(context_endTime_value));

			} catch (ParseException e) {
				context.endTime = null;
			}
			context.etlVersion = (String) context.getProperty("etlVersion");
			try {
				context.hoursToKeepDaily = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepDaily"));
			} catch (NumberFormatException e) {
				context.hoursToKeepDaily = null;
			}
			try {
				context.hoursToKeepHourly = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepHourly"));
			} catch (NumberFormatException e) {
				context.hoursToKeepHourly = null;
			}
			try {
				context.hoursToKeepSamples = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepSamples"));
			} catch (NumberFormatException e) {
				context.hoursToKeepSamples = null;
			}
			try {
				String context_lastErrorSent_value = context
						.getProperty("lastErrorSent");
				if (context_lastErrorSent_value == null) {
					context_lastErrorSent_value = "";
				}
				int context_lastErrorSent_pos = context_lastErrorSent_value
						.indexOf(";");
				String context_lastErrorSent_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastErrorSent_pos > -1) {
					context_lastErrorSent_pattern = context_lastErrorSent_value
							.substring(0, context_lastErrorSent_pos);
					context_lastErrorSent_value = context_lastErrorSent_value
							.substring(context_lastErrorSent_pos + 1);
				}

				context.lastErrorSent = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastErrorSent_pattern)
						.parse(context_lastErrorSent_value));

			} catch (ParseException e) {
				context.lastErrorSent = null;
			}
			try {
				String context_lastSampling_value = context
						.getProperty("lastSampling");
				if (context_lastSampling_value == null) {
					context_lastSampling_value = "";
				}
				int context_lastSampling_pos = context_lastSampling_value
						.indexOf(";");
				String context_lastSampling_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastSampling_pos > -1) {
					context_lastSampling_pattern = context_lastSampling_value
							.substring(0, context_lastSampling_pos);
					context_lastSampling_value = context_lastSampling_value
							.substring(context_lastSampling_pos + 1);
				}

				context.lastSampling = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastSampling_pattern)
						.parse(context_lastSampling_value));

			} catch (ParseException e) {
				context.lastSampling = null;
			}
			try {
				String context_lastStatisticsUpdate_value = context
						.getProperty("lastStatisticsUpdate");
				if (context_lastStatisticsUpdate_value == null) {
					context_lastStatisticsUpdate_value = "";
				}
				int context_lastStatisticsUpdate_pos = context_lastStatisticsUpdate_value
						.indexOf(";");
				String context_lastStatisticsUpdate_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastStatisticsUpdate_pos > -1) {
					context_lastStatisticsUpdate_pattern = context_lastStatisticsUpdate_value
							.substring(0, context_lastStatisticsUpdate_pos);
					context_lastStatisticsUpdate_value = context_lastStatisticsUpdate_value
							.substring(context_lastStatisticsUpdate_pos + 1);
				}

				context.lastStatisticsUpdate = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastStatisticsUpdate_pattern)
						.parse(context_lastStatisticsUpdate_value));

			} catch (ParseException e) {
				context.lastStatisticsUpdate = null;
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			String pwd_ovirtEngineDbPassword_value = context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbPassword = null;
			if (pwd_ovirtEngineDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineDbPassword")) {// no
																			// need
																			// to
																			// decrypt
																			// if
																			// it
																			// come
																			// from
																			// program
																			// argument
																			// or
																			// parent
																			// job
																			// runtime
					context.ovirtEngineDbPassword = pwd_ovirtEngineDbPassword_value;
				} else if (!pwd_ovirtEngineDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineDbPassword_value);
						context.put("ovirtEngineDbPassword",
								context.ovirtEngineDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				context.runDeleteTime = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runDeleteTime"));
			} catch (NumberFormatException e) {
				context.runDeleteTime = null;
			}
			try {
				context.runInterleave = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runInterleave"));
			} catch (NumberFormatException e) {
				context.runInterleave = null;
			}
			try {
				String context_runTime_value = context.getProperty("runTime");
				if (context_runTime_value == null) {
					context_runTime_value = "";
				}
				int context_runTime_pos = context_runTime_value.indexOf(";");
				String context_runTime_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_runTime_pos > -1) {
					context_runTime_pattern = context_runTime_value.substring(
							0, context_runTime_pos);
					context_runTime_value = context_runTime_value
							.substring(context_runTime_pos + 1);
				}

				context.runTime = (java.util.Date) (new java.text.SimpleDateFormat(
						context_runTime_pattern).parse(context_runTime_value));

			} catch (ParseException e) {
				context.runTime = null;
			}
			try {
				context.timeBetweenErrorEvents = routines.system.ParserUtils
						.parseTo_Long(context
								.getProperty("timeBetweenErrorEvents"));
			} catch (NumberFormatException e) {
				context.timeBetweenErrorEvents = null;
			}
			try {
				context.timesFailed = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("timesFailed"));
			} catch (NumberFormatException e) {
				context.timesFailed = null;
			}
			context.dwhUuidEngine = (String) context
					.getProperty("dwhUuidEngine");
			context.dwhHostname = (String) context.getProperty("dwhHostname");
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("dwhUuid")) {
				context.dwhUuid = (String) parentContextMap.get("dwhUuid");
			}
			if (parentContextMap.containsKey("endTime")) {
				context.endTime = (java.util.Date) parentContextMap
						.get("endTime");
			}
			if (parentContextMap.containsKey("etlVersion")) {
				context.etlVersion = (String) parentContextMap
						.get("etlVersion");
			}
			if (parentContextMap.containsKey("hoursToKeepDaily")) {
				context.hoursToKeepDaily = (Integer) parentContextMap
						.get("hoursToKeepDaily");
			}
			if (parentContextMap.containsKey("hoursToKeepHourly")) {
				context.hoursToKeepHourly = (Integer) parentContextMap
						.get("hoursToKeepHourly");
			}
			if (parentContextMap.containsKey("hoursToKeepSamples")) {
				context.hoursToKeepSamples = (Integer) parentContextMap
						.get("hoursToKeepSamples");
			}
			if (parentContextMap.containsKey("lastErrorSent")) {
				context.lastErrorSent = (java.util.Date) parentContextMap
						.get("lastErrorSent");
			}
			if (parentContextMap.containsKey("lastSampling")) {
				context.lastSampling = (java.util.Date) parentContextMap
						.get("lastSampling");
			}
			if (parentContextMap.containsKey("lastStatisticsUpdate")) {
				context.lastStatisticsUpdate = (java.util.Date) parentContextMap
						.get("lastStatisticsUpdate");
			}
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runDeleteTime")) {
				context.runDeleteTime = (Integer) parentContextMap
						.get("runDeleteTime");
			}
			if (parentContextMap.containsKey("runInterleave")) {
				context.runInterleave = (Integer) parentContextMap
						.get("runInterleave");
			}
			if (parentContextMap.containsKey("runTime")) {
				context.runTime = (java.util.Date) parentContextMap
						.get("runTime");
			}
			if (parentContextMap.containsKey("timeBetweenErrorEvents")) {
				context.timeBetweenErrorEvents = (Long) parentContextMap
						.get("timeBetweenErrorEvents");
			}
			if (parentContextMap.containsKey("timesFailed")) {
				context.timesFailed = (Integer) parentContextMap
						.get("timesFailed");
			}
			if (parentContextMap.containsKey("dwhUuidEngine")) {
				context.dwhUuidEngine = (String) parentContextMap
						.get("dwhUuidEngine");
			}
			if (parentContextMap.containsKey("dwhHostname")) {
				context.dwhHostname = (String) parentContextMap
						.get("dwhHostname");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineDbPassword");
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		this.globalResumeTicket = false;// to run others jobs

		try {
			errorCode = null;
			tJDBCConnection_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tJDBCConnection_1) {
			globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", -1);

			e_tJDBCConnection_1.printStackTrace();

		}

		this.globalResumeTicket = true;// to run tPostJob

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out
					.println((endUsedMemory - startUsedMemory)
							+ " bytes memory increase when running : ValidateInstallation");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();

	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));

		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 115680 characters generated by Talend Open Studio for Data Integration on the
 * March 9, 2016 2:38:17 PM IST
 ************************************************************************************************/
