import React from 'react'
import App from '../components/App'
import Dashboard from '../components/Dashboard'
import HostedEngine from '../components/HostedEngine'
import CreateGlusterVolume from '../components/gdeploy/CreateGlusterVolume'
import ExpandCluster from '../components/gdeploy/ExpandCluster'
import GlusterManagement from '../components/GlusterManagement'

const defaultRoute = [
  { path: '/',
    name: "Home",
    exact: true,
    component: Dashboard
  }
];

export const sidebarRoutes = [
  { path: "/dashboard",
    name: "Dashboard",
    icon: "fa-dashboard",
    component: Dashboard
  },
  { path: "/he",
    name: "Hosted Engine",
    icon: "fa-cubes",
    component: HostedEngine
  }
];

const nonSidebarRoutes = [
  { path: "/create_gluster_volume",
    name: "Create Gluster Volume",
    icon: "fa-cubes",
    component: CreateGlusterVolume
  },
  { path: "/expand_cluster",
    name: "Expand Cluster",
    icon: "fa-cubes",
    component: ExpandCluster
  },
  { path: "/gluster-management",
    name: "Gluster Management",
    icon: "fa-cubes",
    component: GlusterManagement
  }
];

function getAllRoutes() {
  return defaultRoute
    .concat(sidebarRoutes)
    .concat(nonSidebarRoutes);
}

const routes = [
  { component: App,
    routes: getAllRoutes()
  }
];

export default routes;
