.TH xvkbd 1 2019-09-01


.SH NAME
\fPxvkbd\fP - virtual keyboard for X window system

.SH DESCRIPTION
.PP
\fIxvkbd\fP is a virtual (graphical) keyboard program for X Window System
which provides a facility to enter characters onto other clients (software)
by clicking on a keyboard displayed on the screen.
This may be used for systems without a hardware keyboard
such as kiosk terminals or handheld devices.
This program also has a facility to send characters
specified as the command line option to another client.
.PP
The standard keyboard layout is based on the traditional US layout,
but some other keyboard layout (see "Screenshot")
are also supported.
The default window size may be too large for systems with small screen,
but it can be configured to use smaller space (220x90 pixels, for example).
For details,
see also "Screenshot"
and "How to Customize \fIxvkbd\fP" below,
and resouce files in the distribution.
.PP
\fIxvkbd\fP version 2.1 and later support word completion
and \fIxvkbd\fP version 4.0 and later will now learns the used words for word completion
,
which may make it easier to enter long words with \fIxvkbd\fP.
.PP
\fIIMPORTANT NOTE:\fP
When invoking \fIxvkbd\fP from display managers such as XDM, GDM, etc.,
always use \fIxvkbd\fP with \fB-secure\fP option
or you will have serious security risk.

.SH "Environment"
\fIxvkbd\fP will work on X11R5 or X11R6.
It is tested on \fIredhat Linux\fP and \fISolaris\fP,
and it will work also on most UNIX-like systems.
.PP
This program uses \fIXaw\fP (use of \fIXaw3d\fP is recommended) 
and no special library is required.

.SH "Operation"

.SH "    Input Keys"
When \fIxvkbd\fP is started, the image of a keyboard 
will be displayed on the screen.
Clicking any key on the \fIxvkbd\fP window will send the character
to the focused window
as if the key had been actually typed with the hardware keyboard.
.PP
If you want to input upper-case alphabets
or other characters on the upper position on the keyboard,
you should click the key after selecting \fIShift\fP by clicking it,
or click the key with mouse button 3 (maybe right button) or mouse button 4.
In the similar manner, if you want to input \fIControl\fPed characters,
you should click the key after clicking \fIControl\fP,
or click the key with mouse button 2 (maybe middle button).
\fIAlt\fP and \fIMeta\fP can be used in the similar manner with \fIControl\fP,
but there are no shortcuts with mouse buttons.

.SH "    ``Quick Modifiers''"
\fIxvkbd\fP 2.5 and later support another way to input characters
with modifiers such as \fIShift\fP, \fIControl\fP, \fIAltGr\fP, etc.,
which may be useful especially for machines with touch panels such as PDAs
- we would call it \fI"Quick Modifiers"\fP.
.PP
\fIQuick Modifiers\fP can be enabled/disabled by the
``\fIEnable "Quick Modifiers?\fP'' entry on the
property panel.
If \fIQuick Modifiers\fP is enabled,
it will be activated by pressing a key on the \fIxvkbd\fP window,
move the pointer outside of the key,
and then release the mouse button or equivalent.
.PP
The direction of the pointer motion will select the modifier:
.sp
.in +4
.nf
  up        - Shift
  right     - AltGr
  right-up  - Shift AltGr
  left      - Control
  left-up   - Shift Control
  down      - Meta
  left-down - Alt
.fi
.sp
.in -4

.SH "    Setting Input Focus"
If you are using a window manager and clients
where you can set input focus by clicking mouse button on the window 
(and you don't have to keep pointer in the window after that),
you can simply set input focus in the normal way
and then click keys on the \fIxvkbd\fP window 
- the character will be sent to the selected position.
.PP
If you are using a window manager or clients
where you must keep the pointer in the input field to input from the keyboard,
or if the input focus is switched to the \fIxvkbd\fP window
when you clicked on the key on the \fIxvkbd\fP window,
you must make \fIxvkbd\fP to set input focus explicitly
by clicking the \fIFocus\fP button on the \fIxvkbd\fP window
and then click on the input field.
This input focus can be cleared by clicking \fIFocus\fP button
with mouse button 3, or simply clicking \fIFocus\fP button twice.

.SH "    Word Completion"
Choosing ``\fIWord Completion...\fP'' in the main menu
will popup the \fIWord Completion\fP panel.
.PP
When you entered characters by clicked keys on the \fIxvkbd\fP window as usual
while the \fIWord Completion\fP panel open,
words started with the characters will be listed in the panel,
and you can enter the remaining characters of the selected word
by clicking one of the words in the list.
.PP
  When ``\fIIntegrate Completion Panel?\fP'' on the property panel is set on,
  completion panel will be displayed on the main window when required.
  .PP
The dictionary (list of words) file is \fB/usr/share/xvkbd/words.english\fP by default,
but it can be changed with \fIStatic Dictionary\fP on the property panel.
.PP
  In addition, \fIxvkbd\fP records the used words and those scores in \fB$HOME/.xvkbd.words\fP.
  
.SH "    Main Menu"
Pressing the ``xvkbd'' logo on the main keyboard
(placed near left-bottom corner in the default configuration)
will popup the main menu.
.PP
The menu contains following items:
.TP 4
\fIAbout...\fP
Show short description of this program.
.TP 4
\fIManual...\fP
Launch manual page reader.
.TP 4
\fIKeypad...\fP
Open the Keypad panel.
.TP 4
\fISun Function Keys...\fP
Open the Sun Function Keys panel.
.TP 4
\fIDead Keys...\fP
Open the Dead Keys panel
which can be used to enter Latin characters with accent symbol in double stroke.
.TP 4
\fIWord Completion...\fP
Open the Word Completion panel.
.PP
.TP 4
\fIChange Keyboard Layout...\fP
Open a popup window to change the keyboard layout.
In the default configuration,
Default (US),
Belgian,
Danish,
French,
German,
Icelandic,
Italian,
Japanese (JIS-X-6002),
Japanese (JIS-X-6004),
Korean,
Norwegian,
Portuguese,
Russian,
Spanish,
Swedish,
Swiss/German,
United Kingdom
and Latin-1
are available.
.TP 4
\fIEdit Function Keys...\fP
Open a popup window to edit string assigned to function keys.
See also "Assigning Text to Function Keys".
.TP 4
\fIShow Keypad?\fP
Toggle show/hide of the keypad on the main window.
.TP 4
\fIShow Function Keys?\fP
Toggle show/hide of the function keys on the main window.
.TP 4
\fIProperty...\fP
Popup the Property panel.
.TP 4
\fIConnect to Remote Display...\fP
Open a panel to specify the name of a remote display
(in the meaning of the X Window System) to connect,
so that following key events will be sent to windows on the remote display.
.TP 4
\fIRevert to Local Display\fP
Disconnect from the remote display
so that following key events will be sent to windows on the local display.

.SH "    Property Panel"
.TP 4
\fIEnable "Quick Modifiers"?\fP
Toggle enable/disable of the
\fIQuick Modifiers\fP feature.
.TP 4
\fILock Shift?\fP
Toggle locking/momentary of \fIShift\fP keys.
.TP 4
\fILock AltGr?\fP
Toggle locking/momentary of \fIAltGr\fP key.
.TP 4
\fILock Control, Alt and Meta?\fP
Toggle locking/momentary of \fIControl\fP, \fIAlt\fP and \fIMeta\fP keys.
.TP 4
\fIAlways on Top?\fP
If this entry is set ON,
\fIxvkbd\fP attempts to keep the \fIxvkbd\fP window always on the top of the display
(i.e. not to be hidden by other windows).
This feature is experimental,
and care should be taken as this feature can cause problem in some situations.
.TP 4
\fIBehave as Toolbar Window?\fP
\fIxvkbd\fP attempts to be a toolbar window when it is used with
some kind of window managers such as Matchbox window manager.
.TP 4
\fIUse XTEST Extension?\fP
XTEST extension will be used if this entry is checked.
If this entry is set inactive,
the X server does not support XTEST extension.
.TP 4
\fIJump Pointer?\fP
If this entry is set ON,
\fIxvkbd\fP will temporary jump the pointer to the focused window,
if XTEST extension is to be used to simulate keyboard events.
.TP 4
\fIKey-Click Sound\fP
Set on/off and duration of key-click sound.
.TP 4
\fIAutomatic Click\fP
Set on/off of the automatic click feature
and the delay before automatic click is activated.
If this feature is set,
\fIxvkbd\fP will work as if left mouse button is clicked
when mouse pointer is moved on a button and stays long enough.
You may want to set \fIJump Pointer?\fP to OFF to avoid auto-repeating.
.TP 4
\fICompletion:\fP
.TP 4
  \fIStatic Dictionary\fP
  Set the filename to be used for word completion.
    This setting take precedence over the `\fBxvkbd.dictFile\fP' resource
    and the \fB-dict\fP option.
    Default: \fB/usr/share/xvkbd/words.english\fP
.TP 4
  \fIDynamic Dictionary Weight\fP
      This parameter controls "learning" of recently used words.
    When this value is set 0, \fIxvkbd\fP will not learn used words.
    With higher value setting, \fIxvkbd\fP will quickly
    learn the used words and effectively ignores frequency information
    in the Static Dictionary.
    Default: 1.
.TP 4
  \fIInsert Blank after Completion?"\fP
      If this button is set on,
    \fIxvkbd\fP will insert blank (' ') automatically after word completion
    if the next character is not blank nor punctuations.
.TP 4
  \fIIntegrate Completion Panel?"\fP
      If this button is set on,
    word completion panel will be inegrated at top of the main window
    and will be activated when required.

.SH "    Options"
\fIxvkbd\fP accept following command line options, in addition to
general options such as `\fB-display\fP'.
.PP
.TP 4
.B "-version"
Display version information and exit.
.TP 4
.B "-xsendevent"
Make \fIxvkbd\fP to use \fIXSendEvent()\fP to simulate keyboard events,
as it was in \fIxvkbd\fP version 1.0.
\fIxvkbd\fP version 1.1 and later will try to use XTEST extension instead
in the default configuration.
Because it is not unusual applications to ignore keyboard events
generated with \fB-xsendevent\fP,
you shouldn't use \fB-xsendevent\fP option unless it is really required.
.sp 0.5
If XTEST extension is not supported by the X server,
\fIxvkbd\fP will automatically switch to this mode.
.sp 0.5
Resource `\fBxvkbd.xtest: false\fP' has the same function.
.TP 4
.B "-no-sync"
Normally, \fIxvkbd\fP attempts to synchronize with the destinating client step by step.
This can cause problem when the client (or the X server) responded too slow.
In such situation, maybe this \fB-no-sync\fP can solve the problem.
.sp 0.5
Resource `\fBxvkbd.noSync: true\fP' has the same function.
.TP 4
.B "-no-jump-pointer"
Make \fIxvkbd\fP not to jump the pointer when sending events.
In the default, \fIxvkbd\fP will temporary jump the pointer to the focused window,
if input focus is set explicitly via \fIFocus\fP button,
and XTEST extension is to be used to simulate keyboard events.
.sp 0.5
Resource `\fBxvkbd.jumpPointer: false\fP' has the same function.
.TP 4
.B "-no-back-pointer"
Make \fIxvkbd\fP not to jump the pointer back to the original position
after events has been sent.
Maybe this can be useful when using \fIxvkbd\fP to move the pointer position.
.sp 0.5
Resource `\fBxvkbd.jumpPointerBack: false\fP' has the same function.
.TP 4
.B "-modal"
Make labels on keys in the \fIxvkbd\fP window
to be set independently for each of four shift states,
not shifted, \fIShift\fP, \fIAltGr\fP and \fIShift\fP-\fIAltGr\fP.
This is useful when you want to make the \fIxvkbd\fP window very small.
.sp 0.5
See also "Customizing Keyboard Layout"
and resouce files in the distribution.
.sp 0.5
Resource `\fBxvkbd.modalKeytop: true\fP' has the same function.
.TP 4
.B "-geometry "[\fIwidth\fPx\fIheight\fP][\fB+\fIxoff\fP+\fIyoff\fP]
Set window geometry (size and position).
.sp 0.5
You can use form like \fB-geometry 400x130\fP to specify the window size,
\fB-geometry +100+100\fP to specify the window position from left/top edge of the screen,
and \fB-geometry 400x130+100+100\fP to specify both the size and the position.
You can specify position from right/bottom edge of the screen
by using \fB-\fP instead of \fB+\fP,
but please note that you must take account of size of the window border.
(If you specify `\fB-geometry -0-0\fP',
the window will not fit in the screen.)
.sp 0.5
This can be set by \fBxvkbd.windowGeometry\fP resource
(note that it is not \fBxvkbd.geometry\fP), too.
.TP 4
.B "-no-resize"
Disable resize of the \fIxvkbd\fP window.
.sp 0.5
Resource `\fBxvkbd.resizable: false\fP' has the same function.
.TP 4
.B "-no-repeat"
Do not auto-repeat even if key is depressed long time.
.sp 0.5
If auto-repeat is enabled (this is the default),
time before start auto-repeat can be set as
`\fBxvkbd*Repeater.initialDelay: 600\fP',
and period of repeat can be set as
`\fBxvkbd*Repeater.minimumDelay: 100\fP' 
(unit of there parameters are milli-seconds).
.sp 0.5
Resource `\fBxvkbd.autoRepeat: false\fP' has the same function.
.TP 4
.B "-no-functionkey"
Do not display function keys.
.sp 0.5
Resource `\fBxvkbd.functionkey: false\fP' has the same function.
.TP 4
.B "-no-keypad"
Do not display keypad.
.sp 0.5
Resource `\fBxvkbd.keypad: false\fP' has the same function.
.TP 4
.B "-compact"
Do not display function keys nor keypad.
.sp 0.5
Resource `\fBxvkbd.compact: true\fP' has the same function.
.TP 4
.B "-keypad"
Display only keypad.
This option will be ignored
if `\fB-no-keypad\fP' or `\fB-compact\fP' is specified.
.sp 0.5
Resource `\fBxvkbd.keypadOnly: true\fP' has the same function.
.TP 4
.BI "-text " string
Send the string to the focused window
(see also `\fB-window\fP' option).
.sp 0.5
If this option is specified,
\fIxvkbd\fP will not open its window
and terminate soon after sending the string.
.sp 0.5
The string can contain:
.IP "    - " 6
\fB\\r\fP - Return
.IP "    - " 6
\fB\\t\fP - Tab
.IP "    - " 6
\fB\\b\fP - Backspace
.IP "    - " 6
\fB\\e\fP - Escape
.IP "    - " 6
\fB\\d\fP - Delete
.IP "    - " 6
\fB\\S\fP - Shift (modify the next character;
please note that modify with ``\fB\\S\fP'' will be ignored in many cases.
For example, ``\fBa\\Cb\\ScD\\CE\fP'' will be interpreted as \fBa\fP,
Control-\fBb\fP, \fBc\fP, Shift-\fBD\fP, and Control-Shift-\fBE\fP.)
.IP "    - " 6
\fB\\C\fP - Control (modify the next character)
.IP "    - " 6
\fB\\A\fP - Alt (modify the next character)
.IP "    - " 6
\fB\\M\fP - Meta (modify the next character)
.IP "    - " 6
\fB\\W\fP - Super (modify the next character)
  .IP "    - " 6
\fB\\[\fP\fIkeysym\fP\fB]\fP - the keysym \fIkeysym\fP
(e.g., \fB\\[Left]\fP), which will be processed in the similar matter
with other general characters
.IP "    - " 6
\fB\\{\fP\fIkeysym\fP\fB}\fP - the keysym \fIkeysym\fP
(e.g., \fB\\{Left}\fP), which will be processed in more primitive matter
and can also be used for modofier keys such as \fIControl_L\fP, \fIMeta_L\fP, etc.;
also, \fB\\{+\fP\fIkeysym\fP\fB}\fP and \fB\\{+\fP\fIkeysym\fP\fB}\fP
will simulate press and release of the key, respectively
.IP "    - " 6
\fB\\D\fP\fIdigit\fP - delay \fIdigit\fP * 100 ms
.IP "    - " 6
\fB\\x\fP\fIvalue\fP - move mouse pointer (use "+" or "-" for relative motion)
.IP "    - " 6
\fB\\y\fP\fIvalue\fP - move mouse pointer (use "+" or "-" for relative motion)
.IP "    - " 6
\fB\\m\fP\fIdigit\fP - simulate click of the specified mouse button
.TP 4
.BI "-file " filename
Send the contents of the specified file to the focused window
(see also `\fB-window\fP' option).
If ``\fB-\fP'' was specified as the \fIfilename\fP,
string to be sent will be read from the standard input (stdin).
.sp 0.5
If this option is specified,
\fIxvkbd\fP will not open its window
and terminate soon after sending the string.
.TP 4
.B "-utf16"
When used with \fB-file\fP option,
make \fIxvkbd\fP to accept UTF16 characters in the file.
.TP 4
.BI "-delay " value
Put \fIvalue\fP ms of delay for evey characters
when sending characters with \fB-text\fP or \fB-file\fP.
Maybe this is useful when problem arises when characters are entered too fast.
.sp 0.5
Resource `\fBxvkbd.textDelay: \fP\fIvalue\fP' has the same function.
.TP 4
.BI "-window " window
Specify the ID 
(hexadecimal value leaded with `\fB0x\fP', or decimal value),
the name (instance name or class name) of the window,
or the title of the window to set input focus.
It is possible to use wildcard characters `\fB*\fP' and `\fB?\fP'
to match the window name or the window title.
.sp 0.5
If this is not specified, \fIxvkbd\fP will use input focus
under control of the window manager,
unless focus is specified explicitly via \fIFocus\fP button.
Even if this option is specified,
you can set input focus to other windows using \fIFocus\fP button,
or clear the input focus.
.sp 0.5
If there are two or more windows which have the name specified with this option,
the window which was found first will be selected.
.TP 4
.BI "-widget " widget-name
Specify the name of the widget to set the input focus.
To use this feature, the client must support \fIEditres\fP protocol.
In general, this option will be used with `\fB-window\fP' option.
.sp 0.5
If you want to set input focus to the widget \fBfoo.bar.zot\fP,
you can write \fBzot\fP, \fBbar.zot\fP or \fBfoo.bar.zot\fP
as \fIwidget-name\fP.
To avoid confusion, the \fIwidget-name\fP should match
with a single widget of the client.
.sp 0.5
For example,
.sp
.in +4
\fBxvkbd -window xarchie -widget searchText -text "\\Ca\\Ckabc\\r\fP"
.sp
.in -4
will enter the string ``\fBabc\fP'' to the ``Search Term'' field
of a \fBxarchie\fP window.
.TP 4
.BI "-remote-display " display
Specify the display (in the meaning of the X Window System) to connect;
  see also \fIConnect to Remote Display...\fP.
.TP 4
.B "-true-keypad"
If this option is specified,
\fIxvkbd\fP will attempt to use \fIkeysym\fPs such as 
\fIXK_KP_1\fP instead of \fIXK_1\fP.
.sp 0.5
Resource `\fBxvkbd.keypadKeysym: true\fP' has the same function.
.TP 4
.BI "-dict " filename
Specify the default dictionary (list of words) file to be used for
word completion.
The `\fICompletion Dictionary\fP' filename
set on the Property panel takes precedence over this.
.sp 0.5
Resource `\fBxvkbd.dictFile: \fP\fIfilename\fP' has the same function.
.sp 0.5
See also ``Making your own completion dictionary''.
.TP 4
.B "-minimizable"
Make \fIxvkbd\fP window can be minimized (iconified)
even if no window manager is in use.
When this feature is enabled,
small triangle will be displayed at left ot the \fIxvkbd\fP main menu,
and \fIxvkbd\fP window will be minimized when the triangle is clicked.
.sp 0.5
Resource `\fBxvkbd.minimizable: true\fP' has the same function.
.TP 4
.B "-secure"
Disable invocation of external commands,
including user assigned command and the online manual reader.
Connection to another displays would also be disabled.
This option may be useful when \fIxvkbd\fP is to be run with some kind of privileges.
.sp 0.5
Resource `\fBxvkbd.secure: true\fP' has the same function.
.TP 4
.B "-nonexitable"
Disable termination of the \fIxvkbd\fP program.
This option may be useful when \fIxvkbd\fP is to be run automatically
for systems with no keyboards and users should not terminate the \fIxvkbd\fP.
.sp 0.5
Resource `\fBxvkbd.nonexitable: true\fP' has the same function.
.TP 4
.B "-xdm"
Same as \fB-secure -nonexitable\fP.
When \fIxvkbd\fP is to be run for login screen,
it would be suggested to use this option.
.TP 4
.BI "-modifiers " modifiers
Normally, \fIxvkbd\fP will activate modifiers (control, shift, etc.)
only while sending characters.
If modifiers were specified with this option,
the specified modifiers will be activated
while corresponding key on the \fIxvkbd\fP window is in active.
For example, you can specify \fB-modifiers shift,control,meta,alt\fP
to apply this for those four modifiers.
Maybe this can be useful when attempting to decorate
the mouse operations with the modifiers.
Please note that the modifiers will also be applied
when attempting to click on the \fIxvkbd\fP window
and which can prevent the correct operation in some situations.
.sp 0.5
Resource `\fBxvkbd.positiveModifiers: \fP\fImodifiers...\fP' has the same function.
.TP 4
.B "-debug"
Make \fIxvkbd\fP to output debug information.
It also disables keyboard width adjustment,
to help adjusting key size when making keyboard layout file.
It also make \fIxvkbd\fP to accept signals SIGINT and SIGQUIT, which otherwise be ignored.
.TP 4
.B "-version"
Output version information and exit.

.SH "Screenshot"
.TP 4
Default (US)
http://t-sato.in.coocan.jp/xvkbd/xvkbd-normal.gif
.TP 4
Belgian
http://t-sato.in.coocan.jp/xvkbd/xvkbd-belgian.gif
.TP 4
Danish
http://t-sato.in.coocan.jp/xvkbd/xvkbd-danish.gif
.TP 4
French
http://t-sato.in.coocan.jp/xvkbd/xvkbd-french.gif
.sp 0.5
http://t-sato.in.coocan.jp/xvkbd/xvkbd-french2.gif
.TP 4
German
http://t-sato.in.coocan.jp/xvkbd/xvkbd-german.gif
.TP 4
Icelandic
http://t-sato.in.coocan.jp/xvkbd/xvkbd-icelandic.gif
.TP 4
Italian
http://t-sato.in.coocan.jp/xvkbd/xvkbd-italian.gif
.TP 4
Japanese (JIS-X-6002)
http://t-sato.in.coocan.jp/xvkbd/xvkbd-jisx6002.gif
.TP 4
Japanese (JIS-X-6004)
http://t-sato.in.coocan.jp/xvkbd/xvkbd-jisx6004.gif
.TP 4
Norwegian
http://t-sato.in.coocan.jp/xvkbd/xvkbd-norwegian.gif
.TP 4
Portuguese
http://t-sato.in.coocan.jp/xvkbd/xvkbd-portuguese.gif
.TP 4
Spanish
http://t-sato.in.coocan.jp/xvkbd/xvkbd-spanish.gif
.TP 4
Swedish
http://t-sato.in.coocan.jp/xvkbd/xvkbd-swedish.gif
.TP 4
Swiss/German
http://t-sato.in.coocan.jp/xvkbd/xvkbd-swissgerman.gif
.TP 4
United Kingdom
http://t-sato.in.coocan.jp/xvkbd/xvkbd-uk.gif
.TP 4
Latin-1
http://t-sato.in.coocan.jp/xvkbd/xvkbd-latin1.gif
.TP 4
Small Keyboard (maybe suitable for PDAs)
http://t-sato.in.coocan.jp/xvkbd/xvkbd-small.gif
.TP 4
Hebrew
http://t-sato.in.coocan.jp/xvkbd/xvkbd-hebrew.gif
.TP 4
Greek
http://t-sato.in.coocan.jp/xvkbd/xvkbd-greek.gif
.TP 4
Turkish
http://t-sato.in.coocan.jp/xvkbd/xvkbd-turkish.gif
.TP 4
Slovene
http://t-sato.in.coocan.jp/xvkbd/xvkbd-slovene.gif
.TP 4
Korean
http://t-sato.in.coocan.jp/xvkbd/xvkbd-korean.gif
.TP 4
Russian (Cyrillic)
http://t-sato.in.coocan.jp/xvkbd/xvkbd-russian.gif

.SH "Download"
.TP 4
\fILatest Official Release\fP
    
\fIhttp://t-sato.in.coocan.jp/xvkbd/xvkbd-4.0.tar.gz\fP
.br
- source of version 4.0 (2019-08-31)
.TP 4
previous release
http://t-sato.in.coocan.jp/xvkbd/xvkbd-3.9.tar.gz
.br
- source of version 3.9 (2018-02-25)
.sp 0.5
http://t-sato.in.coocan.jp/xvkbd/xvkbd-3.8.tar.gz
.br
- source of version 3.8 (2017-06-06)
.sp 0.5
http://t-sato.in.coocan.jp/xvkbd/xvkbd-3.7.tar.gz
.br
- source of version 3.7 (2015-09-12)
.PP
\fIxvkbd\fP is distributed under the terms of the
GNU General Public License.

.SH "Install"

.SH "    xmkmf"
.IP "  o " 4
\fIuntar\fP the source in a directory,
and move to the directory
.IP "  o " 4
If you wish to use genuine \fIXaw\fP instead of \fIXaw3d\fP,
edit \fBImakefile\fP and remove (or comment-out) `\fB#define XAW3D\fP'.
.sp 0.5
When you are installing \fIxvkbd\fP (for example) in very old systems,
you may also want to remove `\fB#define XTEST\fP' and `\fB#define I18N\fP'
to disable XTEST and internationalization facility respectively.
.IP "  o " 4
Run: \fBxmkmf; make install install.man\fP

.SH "    configure"
Alternatively, maybe you can:
.IP "  o " 4
\fIuntar\fP the source in a directory,
and move to the directory
.IP "  o " 4
Run: \fB./configure; make; make install\fP

.SH "Customization"

.SH "    How to Customize \fIxvkbd\fP"
Some degree of customization of \fIxvkbd\fP is possible
by setting resources.
Some resources are already described above,
and resources to customizing keyboard layout are described below.
.PP
To set resources, you can:
.IP "  o " 4
put them in your \fB$HOME/.Xdefaults\fP file, or
.IP "  o " 4
load them via \fIxrdb\fP(1), or
.IP "  o " 4
set the filename to the \fB$XENVIRONMENT\fP environment variable, or
.IP "  o " 4
put them in application default directory as `\fBXVkbd-\fP\fIsuffix\fP'
and set resource ``\fBxvkbd.customization: -\fP\fIsuffix\fP'', or
.IP "  o " 4
put them in application default directory as \fBXVkbd\fP.
.PP
Here, \fIapplication default directory\fP can be either of:
.IP "  o " 4
directories specified with \fB$XUSERFILESEACHPATH\fP,
\fB$XAPPLRESDIR\fP or else \fB$HOME\fP environment variable
.IP "  o " 4
system's application default directory specified with
\fB$XFILESEACHPATH\fP environment variable,
or else the directory specified when compiling the X
(e.g., \fB/usr/lib/X11/app-defaults\fP)
.PP
When the application default file is to be stored
in the system's application default directory,
the file must contain ``\fB#include "XVkbd-common"\fP''
near top of the file.
.PP
\fIxvkbd\fP is distributed with some application default files,
and they will be installed in the system's application default directory.

.SH "    Making Window Small"
Size (and position) of \fIxvkbd\fP window can be set
by `\fBxvkbd.windowGeometry\fP' resource.
When making window small, you may need to choose the smaller font, too.
.sp
.in +4
.nf
  xvkbd.windowGeometry: 220x90
  xvkbd.compact: true
  xvkbd*Font: 6x12
.fi
.sp
.in -4
.PP
You may also want to set:
.sp
.in +4
.nf
  xvkbd.modalKeytop: true
.fi
.sp
.in -4
to display only the labels for the current shift state,
instead of trying to always display all of them in the small keytop.
.PP
See also \fBXVkbd-small.ad\fP in the \fIxvkbd\fP distribution.

.SH "    Removing Unwanted Keys"
Keys on \fIxvkbd\fP window can be removed by setting their width to 1.
The resource name of the keys that start with a capital letter
(and of the \fBspace\fP key) is the same as the key itself,
the others are of the form \fI<row>,<col>\fP (counting from zero).
.PP
To remove \fICompose\fP key and make \fIShift\fP key larger,
you can write:
.sp
.in +4
.nf
  xvkbd*Multi_key.width: 1
  xvkbd*Shift_R.width: 75
.fi
.sp
.in -4
.PP
To remove right \fIAlt\fP and \fIMeta\fP key,
you can write:
.sp
.in +4
.nf
  xvkbd*Alt_R.width: 1
  xvkbd*Meta_R.width: 1
.fi
.sp
.in -4

.SH "    Customizing Keyboard Layout"
Layout of keys on the \fIxvkbd\fP window can be customized
with following resources:
.TP 4
.B "xvkbd.NormalKeys"
list of keys available when neighter of \fIShift\fP and \fIAltGr\fP are selected
.TP 4
.B "xvkbd.ShiftKeys"
list of keys available when \fIShift\fP is selected
.TP 4
.B "xvkbd.AltgrKeys"
list of keys available when \fIAltGr\fP is selected
.TP 4
.B "xvkbd.ShiftAltgrKeys"
list of keys available when both \fIAltGr\fP and \fIShift\fP are selected
.TP 4
.B "xvkbd.KeyLabels"
list of labels displayed on the keys
.TP 4
.B "xvkbd.NormalKeyLabels"
list of labels displayed on the keys
  when neither of \fIShift\fP and \fIAltGr\fP are selected.
.TP 4
.B "xvkbd.ShiftKeyLabels"
list of labels displayed on the keys
  when \fIShift\fP is selected
.TP 4
.B "xvkbd.AltgrKeyLabels"
list of labels displayed on the keys
  when \fIAltGr\fP is selected
.TP 4
.B "xvkbd.ShiftAltgrKeyLabels"
list of labels displayed on the keys
  when both \fIAltGr\fP and \fIShift\fP are selected
.PP
Four resources to set labels on the keys
(\fBxvkbd.NormalKeyLabels\fP, \fBxvkbd.ShiftKeyLabels\fP,
\fBxvkbd.AltgrKeyLabels\fP and \fBxvkbd.ShiftAltgrKeyLabels\fP)
will be used instead of \fBxvkbd.KeyLabels\fP
when \fBxvkbd.modalKeytop\fP resoruce is set \fBtrue\fP.
.PP
In all of those resources, each keys are separated by spaces,
and rows of keys are terminated with `\fB \\n\\\fP'
(note that `\fB\\n\fP' must have space before it).
Please refer \fBXVkbd-german.ad\fP and \fBXVkbd-latin1.ad\fP
in the \fIxvkbd\fP distribution for more about these resources.
.PP
\fBXVkbd-german\fP and \fBXVkbd-latin1\fP will be installed
in the system's application default directory,
and setting the resource ``\fBxvkbd.customization: -german\fP''
will make \fIxvkbd\fP to use the German layout.
For another method to activate those settings, please refer
"How to Customize \fIxvkbd\fP" above.

.SH "    Assigning Text to Function Keys"
Text can be assigned to each function keys
(and, actually, to most other keys).
If text is assigned to the function key,
clicking on the key will send the assigned text
instead of the function key itself.
When pointer is on a key where text is assigned,
the text will be displayed near the key.
.PP
The setting will be read from a text file
which contains text for each function keys as:
.sp
.in +4
.nf
  F1 text for F1
  F2 text for F2
  s:F1 text for Shift-F1
  c:F1 text for Control-F1
  m:F1 text for Meta-F1
  a:F1 text for Alt-F1
  ...
.fi
.sp
.in -4
.PP
`\fBs:\fP', `\fBc:\fP', `\fBm:\fP' and `\fBa:\fP'
before the keys name indicates four modifiers
(\fIShift\fP, \fIControl\fP, \fIMeta\fP and \fIAlt\fP) respectively.
.PP
If the first character of the assigned string is `\fB!\fP',
the string will be used as command to be executed when the key is clicked.
To assign string starting with `\fB!\fP' or `\fB\\\fP',
put `\fB\\\fP' before the string.
.PP
The file is \fB$HOME/.xvkbd\fP in default,
and it can be changed by setting the filename
with \fBxvkbd.keyFile\fP resource.
.PP
For \fBF1\fP to \fBF12\fP with or without \fIShift\fP modifier,
it is possible to edit the assigned string on a panel popped up via
"\fIEdit Function Keys...\fP" in the main menu.

.SH "Miscellaneous Informations"

.SH "    Notes"
.IP "  o " 4
On \fIXFree86\fP, resolution switch with
\fICtrl + Alt + Keypad-Plus\fP and \fICtrl + Alt + Keypad-Minus\fP 
may be simulated.
However, \fICtrl + Alt + Backspace\fP will not be simulated.
.IP "  o " 4
\fIShift\fP is used to decide key to be sent
and it will not used to set modifier bit when sending the event.
You can use \fBxev\fP command to check what is actually sent.
.IP "  o " 4
If \fIAlt\fP or \fIMeta\fP is not defined as modifier,
the key can't be used as modifier.
You can use `\fBxmodmap -pm\fP' to check how modifiers are defined.
.IP "  o " 4
\fINum Lock\fP (and maybe other modifiers) on the physical keyboard
may not work correctly when \fIxvkbd\fP is in use.

.SH "    Additional Informations"
.TP 4
ChangeLog
http://t-sato.in.coocan.jp/xvkbd/ChangeLog
.TP 4
FAQ - Possible Problems and Solutions
http://t-sato.in.coocan.jp/xvkbd/faq.html
.TP 4
Hints to use \fBxvkbd -text\fP
http://t-sato.in.coocan.jp/xvkbd/xvkbd-text.html
.TP 4
Note about how to send key events
http://t-sato.in.coocan.jp/xvkbd/events.html

.SH "Author"
\fIxvkbd\fP was written by Tom Sato,
and it is distributed under the terms of the
GNU General Public License
Version 2 or any later version.
.PP
Please send any feedback (such as bug reports, requests or comments) to
Tom Sato <VEF00200@nifty.com>.
.PP
The latest version of this software
and more information about it may be available at
http://t-sato.in.coocan.jp/xvkbd/.
