/*
 *  Copyright (c) 2006-2007 Jan Behrens, FlexiGuided GmbH, Berlin
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 *
 *
 *  *** A ADDITIONAL DIFFERENT LICENCE FOR UTF8PROC ***
 *
 *  Copyright (c) 2004, 2018 Oracle and/or its affiliates. All rights reserved.
 *      
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  Enhancement by Oracle:
 *  1. Support UTF16.
 *  2. Support Uppercase and Lowercase mapping.
 *  3. Support WordBounding and SentenceBounding.
 *  4. Support diacritic chars differentiating.
 *
 *  For upon enhancement, there are some modifications:
 *  1. Extend the "int lastbounding" as "struct bound_attr_t last_bound_attr"
 *  2. Rename the "utf8proc_data.c" as "utf8_proc_data.h"
 *  3. Extend the data tables in utf8proc_data.h
 *  4. Optimize the sequences arithmetic:
 *       positive number : sequences with single element
 *       zero            : no sequences mapping
 *       negative number : (-x) is the offset to sequences table
 *
 */

#ifndef true
  #define true   1
#endif

#ifndef false
  #define false  0
#endif

const int32_t utf8proc_sequences[] = {
  0, -1, 32, 776, -1, 32, 772, 
  -1, 32, 769, -1, 32, 807, -1, 49, 
  8260, 52, -1, 49, 8260, 50, -1, 51, 
  8260, 52, -1, 65, 768, -1, 65, 769, 
  -1, 65, 770, -1, 65, 771, -1, 65, 
  776, -1, 65, 778, -1, 67, 807, -1, 
  69, 768, -1, 69, 769, -1, 69, 770, 
  -1, 69, 776, -1, 73, 768, -1, 73, 
  769, -1, 73, 770, -1, 73, 776, -1, 
  78, 771, -1, 79, 768, -1, 79, 769, 
  -1, 79, 770, -1, 79, 771, -1, 79, 
  776, -1, 85, 768, -1, 85, 769, -1, 
  85, 770, -1, 85, 776, -1, 89, 769, 
  -1, 83, 83, -1, 223, -1, 83, 115, 
  -1, 115, 115, -1, 97, 768, -1, 97, 
  769, -1, 97, 770, -1, 97, 771, -1, 
  97, 776, -1, 97, 778, -1, 99, 807, 
  -1, 101, 768, -1, 101, 769, -1, 101, 
  770, -1, 101, 776, -1, 105, 768, -1, 
  105, 769, -1, 105, 770, -1, 105, 776, 
  -1, 110, 771, -1, 111, 768, -1, 111, 
  769, -1, 111, 770, -1, 111, 771, -1, 
  111, 776, -1, 117, 768, -1, 117, 769, 
  -1, 117, 770, -1, 117, 776, -1, 121, 
  769, -1, 121, 776, -1, 65, 772, -1, 
  97, 772, -1, 65, 774, -1, 97, 774, 
  -1, 65, 808, -1, 97, 808, -1, 67, 
  769, -1, 99, 769, -1, 67, 770, -1, 
  99, 770, -1, 67, 775, -1, 99, 775, 
  -1, 67, 780, -1, 99, 780, -1, 68, 
  780, -1, 100, 780, -1, 69, 772, -1, 
  101, 772, -1, 69, 774, -1, 101, 774, 
  -1, 69, 775, -1, 101, 775, -1, 69, 
  808, -1, 101, 808, -1, 69, 780, -1, 
  101, 780, -1, 71, 770, -1, 103, 770, 
  -1, 71, 774, -1, 103, 774, -1, 71, 
  775, -1, 103, 775, -1, 71, 807, -1, 
  103, 807, -1, 72, 770, -1, 104, 770, 
  -1, 73, 771, -1, 105, 771, -1, 73, 
  772, -1, 105, 772, -1, 73, 774, -1, 
  105, 774, -1, 73, 808, -1, 105, 808, 
  -1, 73, 775, -1, 304, -1, 105, 775, 
  -1, 73, 74, -1, 105, 106, -1, 74, 
  770, -1, 106, 770, -1, 75, 807, -1, 
  107, 807, -1, 76, 769, -1, 108, 769, 
  -1, 76, 807, -1, 108, 807, -1, 76, 
  780, -1, 108, 780, -1, 76, 183, -1, 
  108, 183, -1, 78, 769, -1, 110, 769, 
  -1, 78, 807, -1, 110, 807, -1, 78, 
  780, -1, 110, 780, -1, 700, 110, -1, 
  700, 78, -1, 329, -1, 79, 772, -1, 
  111, 772, -1, 79, 774, -1, 111, 774, 
  -1, 79, 779, -1, 111, 779, -1, 82, 
  769, -1, 114, 769, -1, 82, 807, -1, 
  114, 807, -1, 82, 780, -1, 114, 780, 
  -1, 83, 769, -1, 115, 769, -1, 83, 
  770, -1, 115, 770, -1, 83, 807, -1, 
  115, 807, -1, 83, 780, -1, 115, 780, 
  -1, 84, 807, -1, 116, 807, -1, 84, 
  780, -1, 116, 780, -1, 85, 771, -1, 
  117, 771, -1, 85, 772, -1, 117, 772, 
  -1, 85, 774, -1, 117, 774, -1, 85, 
  778, -1, 117, 778, -1, 85, 779, -1, 
  117, 779, -1, 85, 808, -1, 117, 808, 
  -1, 87, 770, -1, 119, 770, -1, 89, 
  770, -1, 121, 770, -1, 89, 776, -1, 
  90, 769, -1, 122, 769, -1, 90, 775, 
  -1, 122, 775, -1, 90, 780, -1, 122, 
  780, -1, 79, 795, -1, 111, 795, -1, 
  85, 795, -1, 117, 795, -1, 68, 381, 
  -1, 68, 382, -1, 100, 382, -1, 76, 
  74, -1, 76, 106, -1, 108, 106, -1, 
  78, 74, -1, 78, 106, -1, 110, 106, 
  -1, 65, 780, -1, 97, 780, -1, 73, 
  780, -1, 105, 780, -1, 79, 780, -1, 
  111, 780, -1, 85, 780, -1, 117, 780, 
  -1, 220, 772, -1, 252, 772, -1, 220, 
  769, -1, 252, 769, -1, 220, 780, -1, 
  252, 780, -1, 220, 768, -1, 252, 768, 
  -1, 196, 772, -1, 228, 772, -1, 550, 
  772, -1, 551, 772, -1, 198, 772, -1, 
  230, 772, -1, 71, 780, -1, 103, 780, 
  -1, 75, 780, -1, 107, 780, -1, 79, 
  808, -1, 111, 808, -1, 490, 772, -1, 
  491, 772, -1, 439, 780, -1, 658, 780, 
  -1, 106, 780, -1, 74, 780, -1, 496, 
  -1, 68, 90, -1, 68, 122, -1, 100, 
  122, -1, 71, 769, -1, 103, 769, -1, 
  78, 768, -1, 110, 768, -1, 197, 769, 
  -1, 229, 769, -1, 198, 769, -1, 230, 
  769, -1, 216, 769, -1, 248, 769, -1, 
  65, 783, -1, 97, 783, -1, 65, 785, 
  -1, 97, 785, -1, 69, 783, -1, 101, 
  783, -1, 69, 785, -1, 101, 785, -1, 
  73, 783, -1, 105, 783, -1, 73, 785, 
  -1, 105, 785, -1, 79, 783, -1, 111, 
  783, -1, 79, 785, -1, 111, 785, -1, 
  82, 783, -1, 114, 783, -1, 82, 785, 
  -1, 114, 785, -1, 85, 783, -1, 117, 
  783, -1, 85, 785, -1, 117, 785, -1, 
  83, 806, -1, 115, 806, -1, 84, 806, 
  -1, 116, 806, -1, 72, 780, -1, 104, 
  780, -1, 65, 775, -1, 97, 775, -1, 
  69, 807, -1, 101, 807, -1, 214, 772, 
  -1, 246, 772, -1, 213, 772, -1, 245, 
  772, -1, 79, 775, -1, 111, 775, -1, 
  558, 772, -1, 559, 772, -1, 89, 772, 
  -1, 121, 772, -1, 32, 774, -1, 32, 
  775, -1, 32, 778, -1, 32, 808, -1, 
  32, 771, -1, 32, 779, -1, 776, 769, 
  -1, 32, 837, -1, 168, 769, -1, 913, 
  769, -1, 917, 769, -1, 919, 769, -1, 
  921, 769, -1, 927, 769, -1, 933, 769, 
  -1, 937, 769, -1, 970, 769, -1, 921, 
  776, 769, -1, 912, -1, 953, 776, 769, 
  -1, 921, 776, -1, 933, 776, -1, 945, 
  769, -1, 949, 769, -1, 951, 769, -1, 
  953, 769, -1, 971, 769, -1, 933, 776, 
  769, -1, 944, -1, 965, 776, 769, -1, 
  953, 776, -1, 965, 776, -1, 959, 769, 
  -1, 965, 769, -1, 969, 769, -1, 978, 
  769, -1, 978, 776, -1, 1045, 768, -1, 
  1045, 776, -1, 1043, 769, -1, 1030, 776, 
  -1, 1050, 769, -1, 1048, 768, -1, 1059, 
  774, -1, 1048, 774, -1, 1080, 774, -1, 
  1077, 768, -1, 1077, 776, -1, 1075, 769, 
  -1, 1110, 776, -1, 1082, 769, -1, 1080, 
  768, -1, 1091, 774, -1, 1140, 783, -1, 
  1141, 783, -1, 1046, 774, -1, 1078, 774, 
  -1, 1040, 774, -1, 1072, 774, -1, 1040, 
  776, -1, 1072, 776, -1, 1045, 774, -1, 
  1077, 774, -1, 1240, 776, -1, 1241, 776, 
  -1, 1046, 776, -1, 1078, 776, -1, 1047, 
  776, -1, 1079, 776, -1, 1048, 772, -1, 
  1080, 772, -1, 1048, 776, -1, 1080, 776, 
  -1, 1054, 776, -1, 1086, 776, -1, 1256, 
  776, -1, 1257, 776, -1, 1069, 776, -1, 
  1101, 776, -1, 1059, 772, -1, 1091, 772, 
  -1, 1059, 776, -1, 1091, 776, -1, 1059, 
  779, -1, 1091, 779, -1, 1063, 776, -1, 
  1095, 776, -1, 1067, 776, -1, 1099, 776, 
  -1, 1381, 1410, -1, 1333, 1362, -1, 1415, 
  -1, 1333, 1410, -1, 1575, 1619, -1, 1575, 
  1620, -1, 1608, 1620, -1, 1575, 1621, -1, 
  1610, 1620, -1, 1575, 1652, -1, 1608, 1652, 
  -1, 1735, 1652, -1, 1610, 1652, -1, 1749, 
  1620, -1, 1729, 1620, -1, 1746, 1620, -1, 
  2344, 2364, -1, 2352, 2364, -1, 2355, 2364, 
  -1, 2325, 2364, -1, 2326, 2364, -1, 2327, 
  2364, -1, 2332, 2364, -1, 2337, 2364, -1, 
  2338, 2364, -1, 2347, 2364, -1, 2351, 2364, 
  -1, 2503, 2494, -1, 2503, 2519, -1, 2465, 
  2492, -1, 2466, 2492, -1, 2479, 2492, -1, 
  2610, 2620, -1, 2616, 2620, -1, 2582, 2620, 
  -1, 2583, 2620, -1, 2588, 2620, -1, 2603, 
  2620, -1, 2887, 2902, -1, 2887, 2878, -1, 
  2887, 2903, -1, 2849, 2876, -1, 2850, 2876, 
  -1, 2962, 3031, -1, 3014, 3006, -1, 3015, 
  3006, -1, 3014, 3031, -1, 3142, 3158, -1, 
  3263, 3285, -1, 3270, 3285, -1, 3270, 3286, 
  -1, 3270, 3266, -1, 3274, 3285, -1, 3398, 
  3390, -1, 3399, 3390, -1, 3398, 3415, -1, 
  3545, 3530, -1, 3545, 3535, -1, 3548, 3530, 
  -1, 3545, 3551, -1, 3661, 3634, -1, 3789, 
  3762, -1, 3755, 3737, -1, 3755, 3745, -1, 
  3906, 4023, -1, 3916, 4023, -1, 3921, 4023, 
  -1, 3926, 4023, -1, 3931, 4023, -1, 3904, 
  4021, -1, 3953, 3954, -1, 3953, 3956, -1, 
  4018, 3968, -1, 4018, 3969, -1, 4019, 3968, 
  -1, 4019, 3969, -1, 3953, 3968, -1, 3986, 
  4023, -1, 3996, 4023, -1, 4001, 4023, -1, 
  4006, 4023, -1, 4011, 4023, -1, 3984, 4021, 
  -1, 4133, 4142, -1, 6917, 6965, -1, 6919, 
  6965, -1, 6921, 6965, -1, 6923, 6965, -1, 
  6925, 6965, -1, 6929, 6965, -1, 6970, 6965, 
  -1, 6972, 6965, -1, 6974, 6965, -1, 6975, 
  6965, -1, 6978, 6965, -1, 65, 805, -1, 
  97, 805, -1, 66, 775, -1, 98, 775, 
  -1, 66, 803, -1, 98, 803, -1, 66, 
  817, -1, 98, 817, -1, 199, 769, -1, 
  231, 769, -1, 68, 775, -1, 100, 775, 
  -1, 68, 803, -1, 100, 803, -1, 68, 
  817, -1, 100, 817, -1, 68, 807, -1, 
  100, 807, -1, 68, 813, -1, 100, 813, 
  -1, 274, 768, -1, 275, 768, -1, 274, 
  769, -1, 275, 769, -1, 69, 813, -1, 
  101, 813, -1, 69, 816, -1, 101, 816, 
  -1, 552, 774, -1, 553, 774, -1, 70, 
  775, -1, 102, 775, -1, 71, 772, -1, 
  103, 772, -1, 72, 775, -1, 104, 775, 
  -1, 72, 803, -1, 104, 803, -1, 72, 
  776, -1, 104, 776, -1, 72, 807, -1, 
  104, 807, -1, 72, 814, -1, 104, 814, 
  -1, 73, 816, -1, 105, 816, -1, 207, 
  769, -1, 239, 769, -1, 75, 769, -1, 
  107, 769, -1, 75, 803, -1, 107, 803, 
  -1, 75, 817, -1, 107, 817, -1, 76, 
  803, -1, 108, 803, -1, 7734, 772, -1, 
  7735, 772, -1, 76, 817, -1, 108, 817, 
  -1, 76, 813, -1, 108, 813, -1, 77, 
  769, -1, 109, 769, -1, 77, 775, -1, 
  109, 775, -1, 77, 803, -1, 109, 803, 
  -1, 78, 775, -1, 110, 775, -1, 78, 
  803, -1, 110, 803, -1, 78, 817, -1, 
  110, 817, -1, 78, 813, -1, 110, 813, 
  -1, 213, 769, -1, 245, 769, -1, 213, 
  776, -1, 245, 776, -1, 332, 768, -1, 
  333, 768, -1, 332, 769, -1, 333, 769, 
  -1, 80, 769, -1, 112, 769, -1, 80, 
  775, -1, 112, 775, -1, 82, 775, -1, 
  114, 775, -1, 82, 803, -1, 114, 803, 
  -1, 7770, 772, -1, 7771, 772, -1, 82, 
  817, -1, 114, 817, -1, 83, 775, -1, 
  115, 775, -1, 83, 803, -1, 115, 803, 
  -1, 346, 775, -1, 347, 775, -1, 352, 
  775, -1, 353, 775, -1, 7778, 775, -1, 
  7779, 775, -1, 84, 775, -1, 116, 775, 
  -1, 84, 803, -1, 116, 803, -1, 84, 
  817, -1, 116, 817, -1, 84, 813, -1, 
  116, 813, -1, 85, 804, -1, 117, 804, 
  -1, 85, 816, -1, 117, 816, -1, 85, 
  813, -1, 117, 813, -1, 360, 769, -1, 
  361, 769, -1, 362, 776, -1, 363, 776, 
  -1, 86, 771, -1, 118, 771, -1, 86, 
  803, -1, 118, 803, -1, 87, 768, -1, 
  119, 768, -1, 87, 769, -1, 119, 769, 
  -1, 87, 776, -1, 119, 776, -1, 87, 
  775, -1, 119, 775, -1, 87, 803, -1, 
  119, 803, -1, 88, 775, -1, 120, 775, 
  -1, 88, 776, -1, 120, 776, -1, 89, 
  775, -1, 121, 775, -1, 90, 770, -1, 
  122, 770, -1, 90, 803, -1, 122, 803, 
  -1, 90, 817, -1, 122, 817, -1, 104, 
  817, -1, 72, 817, -1, 7830, -1, 116, 
  776, -1, 84, 776, -1, 7831, -1, 119, 
  778, -1, 87, 778, -1, 7832, -1, 121, 
  778, -1, 89, 778, -1, 7833, -1, 97, 
  702, -1, 65, 702, -1, 7834, -1, 383, 
  775, -1, 65, 803, -1, 97, 803, -1, 
  65, 777, -1, 97, 777, -1, 194, 769, 
  -1, 226, 769, -1, 194, 768, -1, 226, 
  768, -1, 194, 777, -1, 226, 777, -1, 
  194, 771, -1, 226, 771, -1, 7840, 770, 
  -1, 7841, 770, -1, 258, 769, -1, 259, 
  769, -1, 258, 768, -1, 259, 768, -1, 
  258, 777, -1, 259, 777, -1, 258, 771, 
  -1, 259, 771, -1, 7840, 774, -1, 7841, 
  774, -1, 69, 803, -1, 101, 803, -1, 
  69, 777, -1, 101, 777, -1, 69, 771, 
  -1, 101, 771, -1, 202, 769, -1, 234, 
  769, -1, 202, 768, -1, 234, 768, -1, 
  202, 777, -1, 234, 777, -1, 202, 771, 
  -1, 234, 771, -1, 7864, 770, -1, 7865, 
  770, -1, 73, 777, -1, 105, 777, -1, 
  73, 803, -1, 105, 803, -1, 79, 803, 
  -1, 111, 803, -1, 79, 777, -1, 111, 
  777, -1, 212, 769, -1, 244, 769, -1, 
  212, 768, -1, 244, 768, -1, 212, 777, 
  -1, 244, 777, -1, 212, 771, -1, 244, 
  771, -1, 7884, 770, -1, 7885, 770, -1, 
  416, 769, -1, 417, 769, -1, 416, 768, 
  -1, 417, 768, -1, 416, 777, -1, 417, 
  777, -1, 416, 771, -1, 417, 771, -1, 
  416, 803, -1, 417, 803, -1, 85, 803, 
  -1, 117, 803, -1, 85, 777, -1, 117, 
  777, -1, 431, 769, -1, 432, 769, -1, 
  431, 768, -1, 432, 768, -1, 431, 777, 
  -1, 432, 777, -1, 431, 771, -1, 432, 
  771, -1, 431, 803, -1, 432, 803, -1, 
  89, 768, -1, 121, 768, -1, 89, 803, 
  -1, 121, 803, -1, 89, 777, -1, 121, 
  777, -1, 89, 771, -1, 121, 771, -1, 
  945, 787, -1, 945, 788, -1, 7936, 768, 
  -1, 7937, 768, -1, 7936, 769, -1, 7937, 
  769, -1, 7936, 834, -1, 7937, 834, -1, 
  913, 787, -1, 913, 788, -1, 7944, 768, 
  -1, 7945, 768, -1, 7944, 769, -1, 7945, 
  769, -1, 7944, 834, -1, 7945, 834, -1, 
  949, 787, -1, 949, 788, -1, 7952, 768, 
  -1, 7953, 768, -1, 7952, 769, -1, 7953, 
  769, -1, 917, 787, -1, 917, 788, -1, 
  7960, 768, -1, 7961, 768, -1, 7960, 769, 
  -1, 7961, 769, -1, 951, 787, -1, 951, 
  788, -1, 7968, 768, -1, 7969, 768, -1, 
  7968, 769, -1, 7969, 769, -1, 7968, 834, 
  -1, 7969, 834, -1, 919, 787, -1, 919, 
  788, -1, 7976, 768, -1, 7977, 768, -1, 
  7976, 769, -1, 7977, 769, -1, 7976, 834, 
  -1, 7977, 834, -1, 953, 787, -1, 953, 
  788, -1, 7984, 768, -1, 7985, 768, -1, 
  7984, 769, -1, 7985, 769, -1, 7984, 834, 
  -1, 7985, 834, -1, 921, 787, -1, 921, 
  788, -1, 7992, 768, -1, 7993, 768, -1, 
  7992, 769, -1, 7993, 769, -1, 7992, 834, 
  -1, 7993, 834, -1, 959, 787, -1, 959, 
  788, -1, 8000, 768, -1, 8001, 768, -1, 
  8000, 769, -1, 8001, 769, -1, 927, 787, 
  -1, 927, 788, -1, 8008, 768, -1, 8009, 
  768, -1, 8008, 769, -1, 8009, 769, -1, 
  965, 787, -1, 933, 787, -1, 8016, -1, 
  965, 788, -1, 8016, 768, -1, 933, 787, 
  768, -1, 8018, -1, 965, 787, 768, -1, 
  8017, 768, -1, 8016, 769, -1, 933, 787, 
  769, -1, 8020, -1, 965, 787, 769, -1, 
  8017, 769, -1, 8016, 834, -1, 933, 787, 
  834, -1, 8022, -1, 965, 787, 834, -1, 
  8017, 834, -1, 933, 788, -1, 8025, 768, 
  -1, 8025, 769, -1, 8025, 834, -1, 969, 
  787, -1, 969, 788, -1, 8032, 768, -1, 
  8033, 768, -1, 8032, 769, -1, 8033, 769, 
  -1, 8032, 834, -1, 8033, 834, -1, 937, 
  787, -1, 937, 788, -1, 8040, 768, -1, 
  8041, 768, -1, 8040, 769, -1, 8041, 769, 
  -1, 8040, 834, -1, 8041, 834, -1, 945, 
  768, -1, 949, 768, -1, 951, 768, -1, 
  953, 768, -1, 959, 768, -1, 965, 768, 
  -1, 969, 768, -1, 7936, 837, -1, 7944, 
  921, -1, 8064, -1, 8072, -1, 7936, 953, 
  -1, 7937, 837, -1, 7945, 921, -1, 8065, 
  -1, 8073, -1, 7937, 953, -1, 7938, 837, 
  -1, 7946, 921, -1, 8066, -1, 8074, -1, 
  7938, 953, -1, 7939, 837, -1, 7947, 921, 
  -1, 8067, -1, 8075, -1, 7939, 953, -1, 
  7940, 837, -1, 7948, 921, -1, 8068, -1, 
  8076, -1, 7940, 953, -1, 7941, 837, -1, 
  7949, 921, -1, 8069, -1, 8077, -1, 7941, 
  953, -1, 7942, 837, -1, 7950, 921, -1, 
  8070, -1, 8078, -1, 7942, 953, -1, 7943, 
  837, -1, 7951, 921, -1, 8071, -1, 8079, 
  -1, 7943, 953, -1, 7944, 837, -1, 7945, 
  837, -1, 7946, 837, -1, 7947, 837, -1, 
  7948, 837, -1, 7949, 837, -1, 7950, 837, 
  -1, 7951, 837, -1, 7968, 837, -1, 7976, 
  921, -1, 8080, -1, 8088, -1, 7968, 953, 
  -1, 7969, 837, -1, 7977, 921, -1, 8081, 
  -1, 8089, -1, 7969, 953, -1, 7970, 837, 
  -1, 7978, 921, -1, 8082, -1, 8090, -1, 
  7970, 953, -1, 7971, 837, -1, 7979, 921, 
  -1, 8083, -1, 8091, -1, 7971, 953, -1, 
  7972, 837, -1, 7980, 921, -1, 8084, -1, 
  8092, -1, 7972, 953, -1, 7973, 837, -1, 
  7981, 921, -1, 8085, -1, 8093, -1, 7973, 
  953, -1, 7974, 837, -1, 7982, 921, -1, 
  8086, -1, 8094, -1, 7974, 953, -1, 7975, 
  837, -1, 7983, 921, -1, 8087, -1, 8095, 
  -1, 7975, 953, -1, 7976, 837, -1, 7977, 
  837, -1, 7978, 837, -1, 7979, 837, -1, 
  7980, 837, -1, 7981, 837, -1, 7982, 837, 
  -1, 7983, 837, -1, 8032, 837, -1, 8040, 
  921, -1, 8096, -1, 8104, -1, 8032, 953, 
  -1, 8033, 837, -1, 8041, 921, -1, 8097, 
  -1, 8105, -1, 8033, 953, -1, 8034, 837, 
  -1, 8042, 921, -1, 8098, -1, 8106, -1, 
  8034, 953, -1, 8035, 837, -1, 8043, 921, 
  -1, 8099, -1, 8107, -1, 8035, 953, -1, 
  8036, 837, -1, 8044, 921, -1, 8100, -1, 
  8108, -1, 8036, 953, -1, 8037, 837, -1, 
  8045, 921, -1, 8101, -1, 8109, -1, 8037, 
  953, -1, 8038, 837, -1, 8046, 921, -1, 
  8102, -1, 8110, -1, 8038, 953, -1, 8039, 
  837, -1, 8047, 921, -1, 8103, -1, 8111, 
  -1, 8039, 953, -1, 8040, 837, -1, 8041, 
  837, -1, 8042, 837, -1, 8043, 837, -1, 
  8044, 837, -1, 8045, 837, -1, 8046, 837, 
  -1, 8047, 837, -1, 945, 774, -1, 945, 
  772, -1, 8048, 837, -1, 8122, 921, -1, 
  8114, -1, 8122, 837, -1, 8048, 953, -1, 
  945, 837, -1, 913, 921, -1, 8115, -1, 
  8124, -1, 945, 953, -1, 940, 837, -1, 
  902, 921, -1, 8116, -1, 902, 837, -1, 
  940, 953, -1, 945, 834, -1, 913, 834, 
  -1, 8118, -1, 8118, 837, -1, 913, 834, 
  921, -1, 8119, -1, 913, 834, 837, -1, 
  945, 834, 953, -1, 913, 774, -1, 913, 
  772, -1, 913, 768, -1, 913, 837, -1, 
  32, 787, -1, 32, 834, -1, 168, 834, 
  -1, 8052, 837, -1, 8138, 921, -1, 8130, 
  -1, 8138, 837, -1, 8052, 953, -1, 951, 
  837, -1, 919, 921, -1, 8131, -1, 8140, 
  -1, 951, 953, -1, 942, 837, -1, 905, 
  921, -1, 8132, -1, 905, 837, -1, 942, 
  953, -1, 951, 834, -1, 919, 834, -1, 
  8134, -1, 8134, 837, -1, 919, 834, 921, 
  -1, 8135, -1, 919, 834, 837, -1, 951, 
  834, 953, -1, 917, 768, -1, 919, 768, 
  -1, 919, 837, -1, 8127, 768, -1, 8127, 
  769, -1, 8127, 834, -1, 953, 774, -1, 
  953, 772, -1, 970, 768, -1, 921, 776, 
  768, -1, 8146, -1, 953, 776, 768, -1, 
  8147, -1, 953, 834, -1, 921, 834, -1, 
  8150, -1, 970, 834, -1, 921, 776, 834, 
  -1, 8151, -1, 953, 776, 834, -1, 921, 
  774, -1, 921, 772, -1, 921, 768, -1, 
  8190, 768, -1, 8190, 769, -1, 8190, 834, 
  -1, 965, 774, -1, 965, 772, -1, 971, 
  768, -1, 933, 776, 768, -1, 8162, -1, 
  965, 776, 768, -1, 8163, -1, 961, 787, 
  -1, 929, 787, -1, 8164, -1, 961, 788, 
  -1, 965, 834, -1, 933, 834, -1, 8166, 
  -1, 971, 834, -1, 933, 776, 834, -1, 
  8167, -1, 965, 776, 834, -1, 933, 774, 
  -1, 933, 772, -1, 933, 768, -1, 929, 
  788, -1, 168, 768, -1, 8060, 837, -1, 
  8186, 921, -1, 8178, -1, 8186, 837, -1, 
  8060, 953, -1, 969, 837, -1, 937, 921, 
  -1, 8179, -1, 8188, -1, 969, 953, -1, 
  974, 837, -1, 911, 921, -1, 8180, -1, 
  911, 837, -1, 974, 953, -1, 969, 834, 
  -1, 937, 834, -1, 8182, -1, 8182, 837, 
  -1, 937, 834, 921, -1, 8183, -1, 937, 
  834, 837, -1, 969, 834, 953, -1, 927, 
  768, -1, 937, 768, -1, 937, 837, -1, 
  32, 788, -1, 32, 819, -1, 46, 46, 
  -1, 46, 46, 46, -1, 8242, 8242, -1, 
  8242, 8242, 8242, -1, 8245, 8245, -1, 8245, 
  8245, 8245, -1, 33, 33, -1, 32, 773, 
  -1, 63, 63, -1, 63, 33, -1, 33, 
  63, -1, 8242, 8242, 8242, 8242, -1, 82, 
  115, -1, 97, 47, 99, -1, 97, 47, 
  115, -1, 176, 67, -1, 99, 47, 111, 
  -1, 99, 47, 117, -1, 176, 70, -1, 
  78, 111, -1, 83, 77, -1, 84, 69, 
  76, -1, 84, 77, -1, 70, 65, 88, 
  -1, 49, 8260, 51, -1, 50, 8260, 51, 
  -1, 49, 8260, 53, -1, 50, 8260, 53, 
  -1, 51, 8260, 53, -1, 52, 8260, 53, 
  -1, 49, 8260, 54, -1, 53, 8260, 54, 
  -1, 49, 8260, 56, -1, 51, 8260, 56, 
  -1, 53, 8260, 56, -1, 55, 8260, 56, 
  -1, 49, 8260, -1, 73, 73, -1, 73, 
  73, 73, -1, 73, 86, -1, 86, 73, 
  -1, 86, 73, 73, -1, 86, 73, 73, 
  73, -1, 73, 88, -1, 88, 73, -1, 
  88, 73, 73, -1, 105, 105, -1, 105, 
  105, 105, -1, 105, 118, -1, 118, 105, 
  -1, 118, 105, 105, -1, 118, 105, 105, 
  105, -1, 105, 120, -1, 120, 105, -1, 
  120, 105, 105, -1, 8592, 824, -1, 8594, 
  824, -1, 8596, 824, -1, 8656, 824, -1, 
  8660, 824, -1, 8658, 824, -1, 8707, 824, 
  -1, 8712, 824, -1, 8715, 824, -1, 8739, 
  824, -1, 8741, 824, -1, 8747, 8747, -1, 
  8747, 8747, 8747, -1, 8750, 8750, -1, 8750, 
  8750, 8750, -1, 8764, 824, -1, 8771, 824, 
  -1, 8773, 824, -1, 8776, 824, -1, 61, 
  824, -1, 8801, 824, -1, 8781, 824, -1, 
  60, 824, -1, 62, 824, -1, 8804, 824, 
  -1, 8805, 824, -1, 8818, 824, -1, 8819, 
  824, -1, 8822, 824, -1, 8823, 824, -1, 
  8826, 824, -1, 8827, 824, -1, 8834, 824, 
  -1, 8835, 824, -1, 8838, 824, -1, 8839, 
  824, -1, 8866, 824, -1, 8872, 824, -1, 
  8873, 824, -1, 8875, 824, -1, 8828, 824, 
  -1, 8829, 824, -1, 8849, 824, -1, 8850, 
  824, -1, 8882, 824, -1, 8883, 824, -1, 
  8884, 824, -1, 8885, 824, -1, 49, 48, 
  -1, 49, 49, -1, 49, 50, -1, 49, 
  51, -1, 49, 52, -1, 49, 53, -1, 
  49, 54, -1, 49, 55, -1, 49, 56, 
  -1, 49, 57, -1, 50, 48, -1, 40, 
  49, 41, -1, 40, 50, 41, -1, 40, 
  51, 41, -1, 40, 52, 41, -1, 40, 
  53, 41, -1, 40, 54, 41, -1, 40, 
  55, 41, -1, 40, 56, 41, -1, 40, 
  57, 41, -1, 40, 49, 48, 41, -1, 
  40, 49, 49, 41, -1, 40, 49, 50, 
  41, -1, 40, 49, 51, 41, -1, 40, 
  49, 52, 41, -1, 40, 49, 53, 41, 
  -1, 40, 49, 54, 41, -1, 40, 49, 
  55, 41, -1, 40, 49, 56, 41, -1, 
  40, 49, 57, 41, -1, 40, 50, 48, 
  41, -1, 49, 46, -1, 50, 46, -1, 
  51, 46, -1, 52, 46, -1, 53, 46, 
  -1, 54, 46, -1, 55, 46, -1, 56, 
  46, -1, 57, 46, -1, 49, 48, 46, 
  -1, 49, 49, 46, -1, 49, 50, 46, 
  -1, 49, 51, 46, -1, 49, 52, 46, 
  -1, 49, 53, 46, -1, 49, 54, 46, 
  -1, 49, 55, 46, -1, 49, 56, 46, 
  -1, 49, 57, 46, -1, 50, 48, 46, 
  -1, 40, 97, 41, -1, 40, 98, 41, 
  -1, 40, 99, 41, -1, 40, 100, 41, 
  -1, 40, 101, 41, -1, 40, 102, 41, 
  -1, 40, 103, 41, -1, 40, 104, 41, 
  -1, 40, 105, 41, -1, 40, 106, 41, 
  -1, 40, 107, 41, -1, 40, 108, 41, 
  -1, 40, 109, 41, -1, 40, 110, 41, 
  -1, 40, 111, 41, -1, 40, 112, 41, 
  -1, 40, 113, 41, -1, 40, 114, 41, 
  -1, 40, 115, 41, -1, 40, 116, 41, 
  -1, 40, 117, 41, -1, 40, 118, 41, 
  -1, 40, 119, 41, -1, 40, 120, 41, 
  -1, 40, 121, 41, -1, 40, 122, 41, 
  -1, 8747, 8747, 8747, 8747, -1, 58, 58, 
  61, -1, 61, 61, -1, 61, 61, 61, 
  -1, 10973, 824, -1, 12363, 12441, -1, 12365, 
  12441, -1, 12367, 12441, -1, 12369, 12441, -1, 
  12371, 12441, -1, 12373, 12441, -1, 12375, 12441, 
  -1, 12377, 12441, -1, 12379, 12441, -1, 12381, 
  12441, -1, 12383, 12441, -1, 12385, 12441, -1, 
  12388, 12441, -1, 12390, 12441, -1, 12392, 12441, 
  -1, 12399, 12441, -1, 12399, 12442, -1, 12402, 
  12441, -1, 12402, 12442, -1, 12405, 12441, -1, 
  12405, 12442, -1, 12408, 12441, -1, 12408, 12442, 
  -1, 12411, 12441, -1, 12411, 12442, -1, 12358, 
  12441, -1, 32, 12441, -1, 32, 12442, -1, 
  12445, 12441, -1, 12424, 12426, -1, 12459, 12441, 
  -1, 12461, 12441, -1, 12463, 12441, -1, 12465, 
  12441, -1, 12467, 12441, -1, 12469, 12441, -1, 
  12471, 12441, -1, 12473, 12441, -1, 12475, 12441, 
  -1, 12477, 12441, -1, 12479, 12441, -1, 12481, 
  12441, -1, 12484, 12441, -1, 12486, 12441, -1, 
  12488, 12441, -1, 12495, 12441, -1, 12495, 12442, 
  -1, 12498, 12441, -1, 12498, 12442, -1, 12501, 
  12441, -1, 12501, 12442, -1, 12504, 12441, -1, 
  12504, 12442, -1, 12507, 12441, -1, 12507, 12442, 
  -1, 12454, 12441, -1, 12527, 12441, -1, 12528, 
  12441, -1, 12529, 12441, -1, 12530, 12441, -1, 
  12541, 12441, -1, 12467, 12488, -1, 40, 4352, 
  41, -1, 40, 4354, 41, -1, 40, 4355, 
  41, -1, 40, 4357, 41, -1, 40, 4358, 
  41, -1, 40, 4359, 41, -1, 40, 4361, 
  41, -1, 40, 4363, 41, -1, 40, 4364, 
  41, -1, 40, 4366, 41, -1, 40, 4367, 
  41, -1, 40, 4368, 41, -1, 40, 4369, 
  41, -1, 40, 4370, 41, -1, 40, 4352, 
  4449, 41, -1, 40, 4354, 4449, 41, -1, 
  40, 4355, 4449, 41, -1, 40, 4357, 4449, 
  41, -1, 40, 4358, 4449, 41, -1, 40, 
  4359, 4449, 41, -1, 40, 4361, 4449, 41, 
  -1, 40, 4363, 4449, 41, -1, 40, 4364, 
  4449, 41, -1, 40, 4366, 4449, 41, -1, 
  40, 4367, 4449, 41, -1, 40, 4368, 4449, 
  41, -1, 40, 4369, 4449, 41, -1, 40, 
  4370, 4449, 41, -1, 40, 4364, 4462, 41, 
  -1, 40, 4363, 4457, 4364, 4453, 4523, 41, 
  -1, 40, 4363, 4457, 4370, 4462, 41, -1, 
  40, 19968, 41, -1, 40, 20108, 41, -1, 
  40, 19977, 41, -1, 40, 22235, 41, -1, 
  40, 20116, 41, -1, 40, 20845, 41, -1, 
  40, 19971, 41, -1, 40, 20843, 41, -1, 
  40, 20061, 41, -1, 40, 21313, 41, -1, 
  40, 26376, 41, -1, 40, 28779, 41, -1, 
  40, 27700, 41, -1, 40, 26408, 41, -1, 
  40, 37329, 41, -1, 40, 22303, 41, -1, 
  40, 26085, 41, -1, 40, 26666, 41, -1, 
  40, 26377, 41, -1, 40, 31038, 41, -1, 
  40, 21517, 41, -1, 40, 29305, 41, -1, 
  40, 36001, 41, -1, 40, 31069, 41, -1, 
  40, 21172, 41, -1, 40, 20195, 41, -1, 
  40, 21628, 41, -1, 40, 23398, 41, -1, 
  40, 30435, 41, -1, 40, 20225, 41, -1, 
  40, 36039, 41, -1, 40, 21332, 41, -1, 
  40, 31085, 41, -1, 40, 20241, 41, -1, 
  40, 33258, 41, -1, 40, 33267, 41, -1, 
  80, 84, 69, -1, 50, 49, -1, 50, 
  50, -1, 50, 51, -1, 50, 52, -1, 
  50, 53, -1, 50, 54, -1, 50, 55, 
  -1, 50, 56, -1, 50, 57, -1, 51, 
  48, -1, 51, 49, -1, 51, 50, -1, 
  51, 51, -1, 51, 52, -1, 51, 53, 
  -1, 4352, 4449, -1, 4354, 4449, -1, 4355, 
  4449, -1, 4357, 4449, -1, 4358, 4449, -1, 
  4359, 4449, -1, 4361, 4449, -1, 4363, 4449, 
  -1, 4364, 4449, -1, 4366, 4449, -1, 4367, 
  4449, -1, 4368, 4449, -1, 4369, 4449, -1, 
  4370, 4449, -1, 4366, 4449, 4535, 4352, 4457, 
  -1, 4364, 4462, 4363, 4468, -1, 4363, 4462, 
  -1, 51, 54, -1, 51, 55, -1, 51, 
  56, -1, 51, 57, -1, 52, 48, -1, 
  52, 49, -1, 52, 50, -1, 52, 51, 
  -1, 52, 52, -1, 52, 53, -1, 52, 
  54, -1, 52, 55, -1, 52, 56, -1, 
  52, 57, -1, 53, 48, -1, 49, 26376, 
  -1, 50, 26376, -1, 51, 26376, -1, 52, 
  26376, -1, 53, 26376, -1, 54, 26376, -1, 
  55, 26376, -1, 56, 26376, -1, 57, 26376, 
  -1, 49, 48, 26376, -1, 49, 49, 26376, 
  -1, 49, 50, 26376, -1, 72, 103, -1, 
  101, 114, 103, -1, 101, 86, -1, 76, 
  84, 68, -1, 12450, 12497, 12540, 12488, -1, 
  12450, 12523, 12501, 12449, -1, 12450, 12531, 12506, 
  12450, -1, 12450, 12540, 12523, -1, 12452, 12491, 
  12531, 12464, -1, 12452, 12531, 12481, -1, 12454, 
  12457, 12531, -1, 12456, 12473, 12463, 12540, 12489, 
  -1, 12456, 12540, 12459, 12540, -1, 12458, 12531, 
  12473, -1, 12458, 12540, 12512, -1, 12459, 12452, 
  12522, -1, 12459, 12521, 12483, 12488, -1, 12459, 
  12525, 12522, 12540, -1, 12460, 12525, 12531, -1, 
  12460, 12531, 12510, -1, 12462, 12460, -1, 12462, 
  12491, 12540, -1, 12461, 12517, 12522, 12540, -1, 
  12462, 12523, 12480, 12540, -1, 12461, 12525, -1, 
  12461, 12525, 12464, 12521, 12512, -1, 12461, 12525, 
  12513, 12540, 12488, 12523, -1, 12461, 12525, 12527, 
  12483, 12488, -1, 12464, 12521, 12512, -1, 12464, 
  12521, 12512, 12488, 12531, -1, 12463, 12523, 12476, 
  12452, 12525, -1, 12463, 12525, 12540, 12493, -1, 
  12465, 12540, 12473, -1, 12467, 12523, 12490, -1, 
  12467, 12540, 12509, -1, 12469, 12452, 12463, 12523, 
  -1, 12469, 12531, 12481, 12540, 12512, -1, 12471, 
  12522, 12531, 12464, -1, 12475, 12531, 12481, -1, 
  12475, 12531, 12488, -1, 12480, 12540, 12473, -1, 
  12487, 12471, -1, 12489, 12523, -1, 12488, 12531, 
  -1, 12490, 12494, -1, 12494, 12483, 12488, -1, 
  12495, 12452, 12484, -1, 12497, 12540, 12475, 12531, 
  12488, -1, 12497, 12540, 12484, -1, 12496, 12540, 
  12524, 12523, -1, 12500, 12450, 12473, 12488, 12523, 
  -1, 12500, 12463, 12523, -1, 12500, 12467, -1, 
  12499, 12523, -1, 12501, 12449, 12521, 12483, 12489, 
  -1, 12501, 12451, 12540, 12488, -1, 12502, 12483, 
  12471, 12455, 12523, -1, 12501, 12521, 12531, -1, 
  12504, 12463, 12479, 12540, 12523, -1, 12506, 12477, 
  -1, 12506, 12491, 12498, -1, 12504, 12523, 12484, 
  -1, 12506, 12531, 12473, -1, 12506, 12540, 12472, 
  -1, 12505, 12540, 12479, -1, 12509, 12452, 12531, 
  12488, -1, 12508, 12523, 12488, -1, 12507, 12531, 
  -1, 12509, 12531, 12489, -1, 12507, 12540, 12523, 
  -1, 12507, 12540, 12531, -1, 12510, 12452, 12463, 
  12525, -1, 12510, 12452, 12523, -1, 12510, 12483, 
  12495, -1, 12510, 12523, 12463, -1, 12510, 12531, 
  12471, 12519, 12531, -1, 12511, 12463, 12525, 12531, 
  -1, 12511, 12522, -1, 12511, 12522, 12496, 12540, 
  12523, -1, 12513, 12460, -1, 12513, 12460, 12488, 
  12531, -1, 12513, 12540, 12488, 12523, -1, 12516, 
  12540, 12489, -1, 12516, 12540, 12523, -1, 12518, 
  12450, 12531, -1, 12522, 12483, 12488, 12523, -1, 
  12522, 12521, -1, 12523, 12500, 12540, -1, 12523, 
  12540, 12502, 12523, -1, 12524, 12512, -1, 12524, 
  12531, 12488, 12466, 12531, -1, 12527, 12483, 12488, 
  -1, 48, 28857, -1, 49, 28857, -1, 50, 
  28857, -1, 51, 28857, -1, 52, 28857, -1, 
  53, 28857, -1, 54, 28857, -1, 55, 28857, 
  -1, 56, 28857, -1, 57, 28857, -1, 49, 
  48, 28857, -1, 49, 49, 28857, -1, 49, 
  50, 28857, -1, 49, 51, 28857, -1, 49, 
  52, 28857, -1, 49, 53, 28857, -1, 49, 
  54, 28857, -1, 49, 55, 28857, -1, 49, 
  56, 28857, -1, 49, 57, 28857, -1, 50, 
  48, 28857, -1, 50, 49, 28857, -1, 50, 
  50, 28857, -1, 50, 51, 28857, -1, 50, 
  52, 28857, -1, 104, 80, 97, -1, 100, 
  97, -1, 65, 85, -1, 98, 97, 114, 
  -1, 111, 86, -1, 112, 99, -1, 100, 
  109, -1, 100, 109, 178, -1, 100, 109, 
  179, -1, 73, 85, -1, 24179, 25104, -1, 
  26157, 21644, -1, 22823, 27491, -1, 26126, 27835, 
  -1, 26666, 24335, 20250, 31038, -1, 112, 65, 
  -1, 110, 65, -1, 956, 65, -1, 109, 
  65, -1, 107, 65, -1, 75, 66, -1, 
  77, 66, -1, 71, 66, -1, 99, 97, 
  108, -1, 107, 99, 97, 108, -1, 112, 
  70, -1, 110, 70, -1, 956, 70, -1, 
  956, 103, -1, 109, 103, -1, 107, 103, 
  -1, 72, 122, -1, 107, 72, 122, -1, 
  77, 72, 122, -1, 71, 72, 122, -1, 
  84, 72, 122, -1, 956, 8467, -1, 109, 
  8467, -1, 100, 8467, -1, 107, 8467, -1, 
  102, 109, -1, 110, 109, -1, 956, 109, 
  -1, 109, 109, -1, 99, 109, -1, 107, 
  109, -1, 109, 109, 178, -1, 99, 109, 
  178, -1, 109, 178, -1, 107, 109, 178, 
  -1, 109, 109, 179, -1, 99, 109, 179, 
  -1, 109, 179, -1, 107, 109, 179, -1, 
  109, 8725, 115, -1, 109, 8725, 115, 178, 
  -1, 80, 97, -1, 107, 80, 97, -1, 
  77, 80, 97, -1, 71, 80, 97, -1, 
  114, 97, 100, -1, 114, 97, 100, 8725, 
  115, -1, 114, 97, 100, 8725, 115, 178, 
  -1, 112, 115, -1, 110, 115, -1, 956, 
  115, -1, 109, 115, -1, 112, 86, -1, 
  110, 86, -1, 956, 86, -1, 109, 86, 
  -1, 107, 86, -1, 77, 86, -1, 112, 
  87, -1, 110, 87, -1, 956, 87, -1, 
  109, 87, -1, 107, 87, -1, 77, 87, 
  -1, 107, 937, -1, 77, 937, -1, 97, 
  46, 109, 46, -1, 66, 113, -1, 99, 
  99, -1, 99, 100, -1, 67, 8725, 107, 
  103, -1, 67, 111, 46, -1, 100, 66, 
  -1, 71, 121, -1, 104, 97, -1, 72, 
  80, -1, 105, 110, -1, 75, 75, -1, 
  75, 77, -1, 107, 116, -1, 108, 109, 
  -1, 108, 110, -1, 108, 111, 103, -1, 
  108, 120, -1, 109, 98, -1, 109, 105, 
  108, -1, 109, 111, 108, -1, 80, 72, 
  -1, 112, 46, 109, 46, -1, 80, 80, 
  77, -1, 80, 82, -1, 115, 114, -1, 
  83, 118, -1, 87, 98, -1, 86, 8725, 
  109, -1, 65, 8725, 109, -1, 49, 26085, 
  -1, 50, 26085, -1, 51, 26085, -1, 52, 
  26085, -1, 53, 26085, -1, 54, 26085, -1, 
  55, 26085, -1, 56, 26085, -1, 57, 26085, 
  -1, 49, 48, 26085, -1, 49, 49, 26085, 
  -1, 49, 50, 26085, -1, 49, 51, 26085, 
  -1, 49, 52, 26085, -1, 49, 53, 26085, 
  -1, 49, 54, 26085, -1, 49, 55, 26085, 
  -1, 49, 56, 26085, -1, 49, 57, 26085, 
  -1, 50, 48, 26085, -1, 50, 49, 26085, 
  -1, 50, 50, 26085, -1, 50, 51, 26085, 
  -1, 50, 52, 26085, -1, 50, 53, 26085, 
  -1, 50, 54, 26085, -1, 50, 55, 26085, 
  -1, 50, 56, 26085, -1, 50, 57, 26085, 
  -1, 51, 48, 26085, -1, 51, 49, 26085, 
  -1, 103, 97, 108, -1, 102, 102, -1, 
  70, 70, -1, 64256, -1, 70, 102, -1, 
  102, 105, -1, 70, 73, -1, 64257, -1, 
  70, 105, -1, 102, 108, -1, 70, 76, 
  -1, 64258, -1, 70, 108, -1, 102, 102, 
  105, -1, 70, 70, 73, -1, 64259, -1, 
  70, 102, 105, -1, 102, 102, 108, -1, 
  70, 70, 76, -1, 64260, -1, 70, 102, 
  108, -1, 383, 116, -1, 83, 84, -1, 
  64261, -1, 83, 116, -1, 115, 116, -1, 
  64262, -1, 1396, 1398, -1, 1348, 1350, -1, 
  64275, -1, 1348, 1398, -1, 1396, 1381, -1, 
  1348, 1333, -1, 64276, -1, 1348, 1381, -1, 
  1396, 1387, -1, 1348, 1339, -1, 64277, -1, 
  1348, 1387, -1, 1406, 1398, -1, 1358, 1350, 
  -1, 64278, -1, 1358, 1398, -1, 1396, 1389, 
  -1, 1348, 1341, -1, 64279, -1, 1348, 1389, 
  -1, 1497, 1460, -1, 1522, 1463, -1, 1513, 
  1473, -1, 1513, 1474, -1, 64329, 1473, -1, 
  64329, 1474, -1, 1488, 1463, -1, 1488, 1464, 
  -1, 1488, 1468, -1, 1489, 1468, -1, 1490, 
  1468, -1, 1491, 1468, -1, 1492, 1468, -1, 
  1493, 1468, -1, 1494, 1468, -1, 1496, 1468, 
  -1, 1497, 1468, -1, 1498, 1468, -1, 1499, 
  1468, -1, 1500, 1468, -1, 1502, 1468, -1, 
  1504, 1468, -1, 1505, 1468, -1, 1507, 1468, 
  -1, 1508, 1468, -1, 1510, 1468, -1, 1511, 
  1468, -1, 1512, 1468, -1, 1513, 1468, -1, 
  1514, 1468, -1, 1493, 1465, -1, 1489, 1471, 
  -1, 1499, 1471, -1, 1508, 1471, -1, 1488, 
  1500, -1, 1574, 1575, -1, 1574, 1749, -1, 
  1574, 1608, -1, 1574, 1735, -1, 1574, 1734, 
  -1, 1574, 1736, -1, 1574, 1744, -1, 1574, 
  1609, -1, 1574, 1580, -1, 1574, 1581, -1, 
  1574, 1605, -1, 1574, 1610, -1, 1576, 1580, 
  -1, 1576, 1581, -1, 1576, 1582, -1, 1576, 
  1605, -1, 1576, 1609, -1, 1576, 1610, -1, 
  1578, 1580, -1, 1578, 1581, -1, 1578, 1582, 
  -1, 1578, 1605, -1, 1578, 1609, -1, 1578, 
  1610, -1, 1579, 1580, -1, 1579, 1605, -1, 
  1579, 1609, -1, 1579, 1610, -1, 1580, 1581, 
  -1, 1580, 1605, -1, 1581, 1580, -1, 1581, 
  1605, -1, 1582, 1580, -1, 1582, 1581, -1, 
  1582, 1605, -1, 1587, 1580, -1, 1587, 1581, 
  -1, 1587, 1582, -1, 1587, 1605, -1, 1589, 
  1581, -1, 1589, 1605, -1, 1590, 1580, -1, 
  1590, 1581, -1, 1590, 1582, -1, 1590, 1605, 
  -1, 1591, 1581, -1, 1591, 1605, -1, 1592, 
  1605, -1, 1593, 1580, -1, 1593, 1605, -1, 
  1594, 1580, -1, 1594, 1605, -1, 1601, 1580, 
  -1, 1601, 1581, -1, 1601, 1582, -1, 1601, 
  1605, -1, 1601, 1609, -1, 1601, 1610, -1, 
  1602, 1581, -1, 1602, 1605, -1, 1602, 1609, 
  -1, 1602, 1610, -1, 1603, 1575, -1, 1603, 
  1580, -1, 1603, 1581, -1, 1603, 1582, -1, 
  1603, 1604, -1, 1603, 1605, -1, 1603, 1609, 
  -1, 1603, 1610, -1, 1604, 1580, -1, 1604, 
  1581, -1, 1604, 1582, -1, 1604, 1605, -1, 
  1604, 1609, -1, 1604, 1610, -1, 1605, 1580, 
  -1, 1605, 1581, -1, 1605, 1582, -1, 1605, 
  1605, -1, 1605, 1609, -1, 1605, 1610, -1, 
  1606, 1580, -1, 1606, 1581, -1, 1606, 1582, 
  -1, 1606, 1605, -1, 1606, 1609, -1, 1606, 
  1610, -1, 1607, 1580, -1, 1607, 1605, -1, 
  1607, 1609, -1, 1607, 1610, -1, 1610, 1580, 
  -1, 1610, 1581, -1, 1610, 1582, -1, 1610, 
  1605, -1, 1610, 1609, -1, 1610, 1610, -1, 
  1584, 1648, -1, 1585, 1648, -1, 1609, 1648, 
  -1, 32, 1612, 1617, -1, 32, 1613, 1617, 
  -1, 32, 1614, 1617, -1, 32, 1615, 1617, 
  -1, 32, 1616, 1617, -1, 32, 1617, 1648, 
  -1, 1574, 1585, -1, 1574, 1586, -1, 1574, 
  1606, -1, 1576, 1585, -1, 1576, 1586, -1, 
  1576, 1606, -1, 1578, 1585, -1, 1578, 1586, 
  -1, 1578, 1606, -1, 1579, 1585, -1, 1579, 
  1586, -1, 1579, 1606, -1, 1605, 1575, -1, 
  1606, 1585, -1, 1606, 1586, -1, 1606, 1606, 
  -1, 1610, 1585, -1, 1610, 1586, -1, 1610, 
  1606, -1, 1574, 1582, -1, 1574, 1607, -1, 
  1576, 1607, -1, 1578, 1607, -1, 1589, 1582, 
  -1, 1604, 1607, -1, 1606, 1607, -1, 1607, 
  1648, -1, 1610, 1607, -1, 1579, 1607, -1, 
  1587, 1607, -1, 1588, 1605, -1, 1588, 1607, 
  -1, 1600, 1614, 1617, -1, 1600, 1615, 1617, 
  -1, 1600, 1616, 1617, -1, 1591, 1609, -1, 
  1591, 1610, -1, 1593, 1609, -1, 1593, 1610, 
  -1, 1594, 1609, -1, 1594, 1610, -1, 1587, 
  1609, -1, 1587, 1610, -1, 1588, 1609, -1, 
  1588, 1610, -1, 1581, 1609, -1, 1581, 1610, 
  -1, 1580, 1609, -1, 1580, 1610, -1, 1582, 
  1609, -1, 1582, 1610, -1, 1589, 1609, -1, 
  1589, 1610, -1, 1590, 1609, -1, 1590, 1610, 
  -1, 1588, 1580, -1, 1588, 1581, -1, 1588, 
  1582, -1, 1588, 1585, -1, 1587, 1585, -1, 
  1589, 1585, -1, 1590, 1585, -1, 1575, 1611, 
  -1, 1578, 1580, 1605, -1, 1578, 1581, 1580, 
  -1, 1578, 1581, 1605, -1, 1578, 1582, 1605, 
  -1, 1578, 1605, 1580, -1, 1578, 1605, 1581, 
  -1, 1578, 1605, 1582, -1, 1580, 1605, 1581, 
  -1, 1581, 1605, 1610, -1, 1581, 1605, 1609, 
  -1, 1587, 1581, 1580, -1, 1587, 1580, 1581, 
  -1, 1587, 1580, 1609, -1, 1587, 1605, 1581, 
  -1, 1587, 1605, 1580, -1, 1587, 1605, 1605, 
  -1, 1589, 1581, 1581, -1, 1589, 1605, 1605, 
  -1, 1588, 1581, 1605, -1, 1588, 1580, 1610, 
  -1, 1588, 1605, 1582, -1, 1588, 1605, 1605, 
  -1, 1590, 1581, 1609, -1, 1590, 1582, 1605, 
  -1, 1591, 1605, 1581, -1, 1591, 1605, 1605, 
  -1, 1591, 1605, 1610, -1, 1593, 1580, 1605, 
  -1, 1593, 1605, 1605, -1, 1593, 1605, 1609, 
  -1, 1594, 1605, 1605, -1, 1594, 1605, 1610, 
  -1, 1594, 1605, 1609, -1, 1601, 1582, 1605, 
  -1, 1602, 1605, 1581, -1, 1602, 1605, 1605, 
  -1, 1604, 1581, 1605, -1, 1604, 1581, 1610, 
  -1, 1604, 1581, 1609, -1, 1604, 1580, 1580, 
  -1, 1604, 1582, 1605, -1, 1604, 1605, 1581, 
  -1, 1605, 1581, 1580, -1, 1605, 1581, 1605, 
  -1, 1605, 1581, 1610, -1, 1605, 1580, 1581, 
  -1, 1605, 1580, 1605, -1, 1605, 1582, 1580, 
  -1, 1605, 1582, 1605, -1, 1605, 1580, 1582, 
  -1, 1607, 1605, 1580, -1, 1607, 1605, 1605, 
  -1, 1606, 1581, 1605, -1, 1606, 1581, 1609, 
  -1, 1606, 1580, 1605, -1, 1606, 1580, 1609, 
  -1, 1606, 1605, 1610, -1, 1606, 1605, 1609, 
  -1, 1610, 1605, 1605, -1, 1576, 1582, 1610, 
  -1, 1578, 1580, 1610, -1, 1578, 1580, 1609, 
  -1, 1578, 1582, 1610, -1, 1578, 1582, 1609, 
  -1, 1578, 1605, 1610, -1, 1578, 1605, 1609, 
  -1, 1580, 1605, 1610, -1, 1580, 1581, 1609, 
  -1, 1580, 1605, 1609, -1, 1587, 1582, 1609, 
  -1, 1589, 1581, 1610, -1, 1588, 1581, 1610, 
  -1, 1590, 1581, 1610, -1, 1604, 1580, 1610, 
  -1, 1604, 1605, 1610, -1, 1610, 1581, 1610, 
  -1, 1610, 1580, 1610, -1, 1610, 1605, 1610, 
  -1, 1605, 1605, 1610, -1, 1602, 1605, 1610, 
  -1, 1606, 1581, 1610, -1, 1593, 1605, 1610, 
  -1, 1603, 1605, 1610, -1, 1606, 1580, 1581, 
  -1, 1605, 1582, 1610, -1, 1604, 1580, 1605, 
  -1, 1603, 1605, 1605, -1, 1580, 1581, 1610, 
  -1, 1581, 1580, 1610, -1, 1605, 1580, 1610, 
  -1, 1601, 1605, 1610, -1, 1576, 1581, 1610, 
  -1, 1587, 1582, 1610, -1, 1606, 1580, 1610, 
  -1, 1589, 1604, 1746, -1, 1602, 1604, 1746, 
  -1, 1575, 1604, 1604, 1607, -1, 1575, 1603, 
  1576, 1585, -1, 1605, 1581, 1605, 1583, -1, 
  1589, 1604, 1593, 1605, -1, 1585, 1587, 1608, 
  1604, -1, 1593, 1604, 1610, 1607, -1, 1608, 
  1587, 1604, 1605, -1, 1589, 1604, 1609, -1, 
  1589, 1604, 1609, 32, 1575, 1604, 1604, 1607, 
  32, 1593, 1604, 1610, 1607, 32, 1608, 1587, 
  1604, 1605, -1, 1580, 1604, 32, 1580, 1604, 
  1575, 1604, 1607, -1, 1585, 1740, 1575, 1604, 
  -1, 32, 1611, -1, 1600, 1611, -1, 32, 
  1612, -1, 32, 1613, -1, 32, 1614, -1, 
  1600, 1614, -1, 32, 1615, -1, 1600, 1615, 
  -1, 32, 1616, -1, 1600, 1616, -1, 32, 
  1617, -1, 1600, 1617, -1, 32, 1618, -1, 
  1600, 1618, -1, 1604, 1570, -1, 1604, 1571, 
  -1, 1604, 1573, -1, 1604, 1575, -1, 119127, 
  119141, -1, 119128, 119141, -1, 119135, 119150, -1, 
  119135, 119151, -1, 119135, 119152, -1, 119135, 119153, 
  -1, 119135, 119154, -1, 119225, 119141, -1, 119226, 
  119141, -1, 119227, 119150, -1, 119228, 119150, -1, 
  119227, 119151, -1, 119228, 119151, -1, };

const uint16_t utf8proc_stage1table[] = {
  0, 256, 512, 768, 1024, 1280, 1536, 
  1792, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 
  3840, 4096, 4352, 4608, 4864, 5120, 5376, 5632, 
  5888, 6144, 6400, 6656, 6912, 7168, 7424, 7680, 
  7936, 8192, 8448, 8704, 8960, 9216, 9472, 9728, 
  9984, 10240, 10496, 10752, 11008, 11264, 11520, 11776, 
  12032, 12288, 12544, 12800, 13056, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13568, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13824, 14080, 5376, 5376, 5376, 14336, 5376, 14592, 
  14848, 15104, 15360, 15616, 2048, 5376, 5376, 5376, 
  5376, 5376, 5376, 5376, 5376, 5376, 5376, 5376, 
  5376, 5376, 5376, 5376, 5376, 5376, 5376, 5376, 
  5376, 5376, 5376, 5376, 5376, 5376, 5376, 5376, 
  5376, 5376, 5376, 5376, 5376, 5376, 5376, 5376, 
  5376, 5376, 5376, 5376, 5376, 5376, 5376, 5376, 
  15872, 16128, 16128, 16128, 16128, 16128, 16128, 16128, 
  16128, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16640, 16896, 17152, 17408, 17664, 17920, 
  18176, 18432, 18688, 18944, 19200, 19456, 2048, 2048, 
  2048, 19712, 19968, 20224, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 5376, 5376, 5376, 20480, 20736, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 20992, 21248, 21504, 21760, 22016, 22272, 22528, 
  22784, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 23040, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 13312, 
  13312, 13312, 13312, 13312, 13312, 13312, 13312, 23296, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 23552, 23808, 24064, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 24320, 24576, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 2048, 2048, 2048, 2048, 2048, 2048, 2048, 
  2048, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  24832, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 
  24832, };

const uint16_t utf8proc_stage2table[] = {
  1, 2, 2, 2, 2, 2, 2, 
  2, 2, 3, 4, 5, 6, 7, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 8, 8, 8, 
  9, 10, 11, 12, 13, 14, 13, 15, 
  16, 17, 18, 15, 19, 20, 21, 22, 
  23, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 25, 26, 27, 28, 29, 
  11, 15, 30, 31, 32, 33, 34, 35, 
  36, 37, 38, 39, 40, 41, 42, 43, 
  44, 45, 46, 47, 48, 49, 50, 51, 
  52, 53, 54, 55, 17, 15, 18, 56, 
  57, 56, 58, 59, 60, 61, 62, 63, 
  64, 65, 66, 67, 68, 69, 70, 71, 
  72, 73, 74, 75, 76, 77, 78, 79, 
  80, 81, 82, 83, 17, 84, 18, 84, 
  2, 2, 2, 2, 2, 2, 85, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 
  2, 86, 15, 14, 14, 14, 14, 87, 
  87, 88, 87, 89, 90, 84, 91, 87, 
  92, 93, 94, 95, 96, 97, 98, 87, 
  99, 100, 101, 102, 103, 104, 105, 106, 
  15, 107, 108, 109, 110, 111, 112, 113, 
  114, 115, 116, 117, 118, 119, 120, 121, 
  122, 123, 124, 125, 126, 127, 128, 129, 
  84, 130, 131, 132, 133, 134, 135, 136, 
  137, 138, 139, 140, 141, 142, 143, 144, 
  145, 146, 147, 148, 149, 150, 151, 152, 
  153, 154, 155, 156, 157, 158, 159, 160, 
  84, 161, 162, 163, 164, 165, 166, 167, 
  168, 169, 170, 171, 172, 173, 174, 175, 
  176, 177, 178, 179, 180, 181, 182, 183, 
  184, 185, 186, 187, 188, 189, 190, 191, 
  192, 193, 194, 195, 196, 197, 198, 199, 
  200, 201, 202, 203, 204, 205, 206, 207, 
  208, 209, 210, 211, 212, 213, 214, 215, 
  216, 217, 218, 219, 220, 221, 222, 223, 
  224, 225, 226, 227, 228, 229, 230, 231, 
  232, 233, 234, 235, 236, 237, 238, 239, 
  240, 241, 242, 243, 244, 245, 246, 247, 
  248, 249, 250, 251, 252, 253, 254, 255, 
  256, 257, 258, 259, 260, 261, 262, 263, 
  264, 265, 266, 267, 268, 269, 270, 271, 
  272, 273, 274, 275, 276, 277, 278, 279, 
  280, 281, 282, 283, 284, 285, 286, 287, 
  288, 289, 290, 291, 292, 293, 294, 295, 
  296, 297, 298, 299, 300, 301, 302, 303, 
  304, 305, 306, 307, 308, 309, 225, 310, 
  311, 312, 313, 314, 315, 316, 317, 318, 
  319, 320, 321, 322, 225, 323, 324, 325, 
  326, 327, 328, 329, 330, 331, 332, 333, 
  334, 335, 336, 225, 225, 337, 338, 339, 
  340, 341, 342, 343, 344, 345, 346, 347, 
  348, 349, 350, 225, 351, 352, 353, 225, 
  354, 351, 351, 351, 351, 355, 356, 357, 
  358, 359, 360, 361, 362, 363, 364, 365, 
  366, 367, 368, 369, 370, 371, 372, 373, 
  374, 375, 376, 377, 378, 379, 380, 381, 
  382, 383, 384, 385, 386, 387, 388, 389, 
  390, 391, 392, 393, 394, 395, 396, 397, 
  398, 399, 400, 401, 402, 403, 404, 405, 
  406, 407, 408, 409, 410, 411, 412, 413, 
  414, 415, 416, 417, 418, 419, 420, 421, 
  422, 423, 424, 425, 426, 427, 428, 429, 
  430, 431, 432, 433, 434, 435, 436, 437, 
  438, 439, 440, 441, 442, 443, 444, 445, 
  446, 447, 225, 448, 449, 450, 451, 452, 
  453, 454, 455, 456, 457, 458, 459, 460, 
  461, 462, 463, 464, 465, 225, 225, 225, 
  225, 225, 225, 466, 467, 468, 469, 470, 
  225, 225, 471, 472, 473, 474, 475, 476, 
  477, 478, 479, 480, 481, 482, 483, 484, 
  485, 486, 487, 225, 488, 489, 225, 490, 
  491, 225, 492, 225, 493, 225, 225, 225, 
  225, 494, 225, 225, 495, 225, 225, 225, 
  225, 496, 497, 225, 498, 225, 225, 225, 
  499, 225, 500, 501, 225, 225, 502, 225, 
  225, 225, 225, 225, 225, 225, 503, 225, 
  225, 504, 225, 225, 505, 225, 225, 225, 
  225, 506, 507, 508, 509, 510, 225, 225, 
  225, 225, 225, 511, 225, 351, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 512, 513, 514, 515, 516, 517, 518, 
  519, 520, 521, 521, 522, 522, 522, 522, 
  522, 523, 523, 56, 56, 56, 56, 521, 
  521, 521, 521, 521, 521, 521, 521, 521, 
  521, 522, 522, 56, 56, 56, 56, 56, 
  56, 524, 525, 526, 527, 528, 529, 56, 
  56, 530, 531, 532, 533, 534, 56, 56, 
  56, 56, 56, 56, 56, 521, 56, 522, 
  56, 56, 56, 56, 56, 56, 56, 56, 
  56, 56, 56, 56, 56, 56, 56, 56, 
  56, 535, 536, 537, 538, 539, 540, 541, 
  542, 543, 544, 545, 546, 547, 540, 540, 
  548, 540, 549, 540, 550, 551, 552, 553, 
  553, 553, 553, 552, 554, 553, 553, 553, 
  553, 553, 555, 555, 556, 557, 558, 559, 
  560, 561, 553, 553, 553, 553, 562, 563, 
  553, 564, 565, 553, 553, 566, 566, 566, 
  566, 567, 553, 553, 553, 553, 540, 540, 
  540, 568, 569, 570, 571, 572, 573, 540, 
  553, 553, 553, 540, 540, 540, 553, 553, 
  574, 540, 540, 540, 553, 553, 553, 553, 
  540, 575, 576, 576, 577, 578, 579, 579, 
  580, 579, 579, 580, 577, 577, 577, 577, 
  577, 577, 577, 577, 577, 577, 577, 577, 
  577, 581, 582, 583, 584, 585, 56, 586, 
  587, 0, 0, 588, 589, 590, 591, 592, 
  0, 0, 0, 0, 0, 97, 593, 594, 
  595, 596, 597, 598, 0, 599, 0, 600, 
  601, 602, 603, 604, 605, 606, 607, 608, 
  609, 610, 611, 612, 613, 614, 615, 616, 
  617, 618, 619, 0, 620, 621, 622, 623, 
  624, 625, 626, 627, 628, 629, 630, 631, 
  632, 633, 634, 635, 636, 637, 638, 639, 
  640, 641, 642, 643, 644, 645, 646, 647, 
  648, 649, 650, 651, 652, 653, 654, 655, 
  656, 657, 658, 659, 660, 661, 662, 663, 
  664, 665, 666, 667, 668, 669, 670, 671, 
  672, 673, 674, 675, 676, 677, 678, 679, 
  680, 681, 682, 683, 684, 685, 686, 687, 
  688, 689, 690, 691, 692, 693, 694, 695, 
  696, 697, 698, 699, 225, 700, 701, 84, 
  702, 703, 704, 705, 706, 225, 707, 708, 
  709, 710, 711, 712, 713, 714, 715, 716, 
  717, 718, 719, 720, 721, 722, 723, 724, 
  725, 726, 727, 728, 729, 730, 731, 732, 
  733, 734, 735, 736, 737, 738, 739, 740, 
  741, 742, 743, 744, 745, 746, 747, 748, 
  749, 750, 751, 752, 753, 754, 755, 756, 
  757, 758, 759, 760, 761, 762, 763, 764, 
  765, 766, 767, 768, 769, 770, 771, 772, 
  773, 774, 775, 776, 777, 778, 779, 780, 
  781, 782, 783, 784, 785, 786, 787, 788, 
  789, 790, 791, 792, 793, 794, 795, 796, 
  797, 798, 799, 800, 801, 802, 803, 804, 
  805, 806, 807, 808, 809, 810, 811, 812, 
  813, 814, 815, 816, 817, 818, 819, 820, 
  821, 822, 823, 824, 825, 826, 827, 828, 
  829, 830, 831, 832, 833, 834, 835, 836, 
  837, 838, 839, 840, 540, 540, 540, 540, 
  841, 842, 842, 843, 844, 845, 846, 847, 
  848, 849, 850, 851, 852, 853, 854, 855, 
  856, 857, 858, 859, 860, 861, 862, 863, 
  864, 865, 866, 867, 868, 869, 870, 871, 
  872, 873, 874, 875, 876, 877, 878, 879, 
  880, 881, 882, 883, 884, 885, 886, 887, 
  888, 889, 890, 891, 892, 893, 894, 895, 
  896, 897, 898, 899, 900, 901, 902, 903, 
  904, 905, 906, 907, 908, 909, 910, 911, 
  912, 913, 914, 915, 916, 917, 918, 919, 
  920, 921, 922, 923, 924, 925, 926, 927, 
  928, 929, 930, 931, 932, 933, 934, 935, 
  936, 937, 938, 939, 940, 941, 942, 943, 
  944, 945, 946, 947, 948, 949, 950, 951, 
  952, 953, 954, 955, 956, 957, 958, 959, 
  960, 961, 962, 963, 964, 965, 966, 967, 
  968, 969, 970, 971, 972, 973, 974, 975, 
  976, 977, 978, 979, 980, 981, 982, 983, 
  984, 985, 986, 987, 988, 989, 990, 991, 
  992, 993, 994, 995, 996, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 997, 998, 999, 1000, 1001, 1002, 
  1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 
  1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 
  1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 
  1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 
  0, 0, 522, 1035, 1035, 1036, 1037, 1036, 
  1035, 0, 1038, 1039, 1040, 1041, 1042, 1043, 
  1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 
  1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 
  1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 
  1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 
  1076, 0, 1077, 1078, 0, 0, 0, 0, 
  0, 0, 553, 540, 540, 540, 540, 553, 
  540, 540, 540, 1079, 553, 540, 540, 540, 
  540, 540, 540, 576, 553, 553, 553, 553, 
  553, 540, 540, 553, 540, 540, 1079, 1080, 
  540, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 
  1088, 1089, 1090, 1090, 1091, 1092, 1093, 1094, 
  1095, 1096, 1097, 1098, 1096, 540, 576, 1096, 
  1099, 0, 0, 0, 0, 0, 0, 0, 
  0, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 0, 0, 0, 0, 
  0, 1100, 1100, 1100, 1101, 1102, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1103, 1103, 1103, 1103, 0, 0, 84, 
  84, 1104, 13, 13, 1105, 20, 1106, 87, 
  87, 577, 577, 577, 577, 577, 577, 1107, 
  1107, 1108, 1109, 1110, 1111, 0, 0, 1111, 
  1112, 0, 1113, 1114, 1115, 1116, 1117, 1118, 
  1119, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1120, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1121, 1113, 1122, 1123, 1124, 1125, 1126, 
  1127, 1128, 1129, 1130, 1131, 1132, 1133, 576, 
  540, 540, 577, 577, 577, 576, 577, 577, 
  0, 1134, 1134, 1134, 1134, 1134, 1134, 1134, 
  1134, 1134, 1134, 13, 1135, 1136, 1111, 1113, 
  1113, 1137, 1113, 1113, 1113, 1113, 1138, 1139, 
  1140, 1141, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1142, 1143, 1144, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1145, 1146, 1112, 1147, 577, 
  577, 577, 577, 577, 577, 577, 1103, 842, 
  540, 540, 577, 577, 576, 577, 1148, 1148, 
  577, 577, 87, 553, 540, 540, 576, 1113, 
  1113, 24, 24, 24, 24, 24, 24, 24, 
  24, 24, 24, 1113, 1113, 1113, 1149, 1149, 
  1113, 1112, 1112, 1112, 1111, 1111, 1111, 1111, 
  1111, 1111, 1111, 1111, 1111, 1111, 1111, 0, 
  91, 1113, 1150, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 540, 553, 540, 540, 553, 540, 540, 
  553, 553, 553, 540, 553, 553, 540, 553, 
  540, 540, 540, 553, 540, 553, 540, 553, 
  540, 553, 540, 540, 0, 0, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1113, 
  1113, 1113, 1113, 1113, 1113, 1113, 1113, 1151, 
  1151, 1151, 1151, 1151, 1151, 1151, 1151, 1151, 
  1151, 1151, 1113, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1152, 1152, 1152, 1152, 1152, 1152, 1152, 
  1152, 1152, 1152, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 540, 540, 540, 540, 
  540, 540, 540, 553, 540, 1153, 1153, 87, 
  15, 1154, 11, 1155, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1156, 1156, 1157, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 1158, 1159, 351, 351, 351, 351, 351, 
  351, 1160, 1161, 351, 1162, 1163, 351, 351, 
  351, 351, 351, 0, 0, 1164, 351, 1157, 
  1157, 1157, 1156, 1156, 1156, 1156, 1156, 1156, 
  1156, 1156, 1157, 1157, 1157, 1157, 1165, 0, 
  0, 351, 540, 553, 540, 540, 0, 0, 
  0, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 
  1173, 351, 351, 1156, 1156, 1036, 1036, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1035, 522, 351, 0, 0, 0, 0, 
  0, 0, 0, 0, 351, 351, 351, 351, 
  351, 0, 1156, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  351, 351, 0, 0, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 0, 0, 0, 351, 
  351, 351, 351, 0, 0, 1175, 351, 1176, 
  1157, 1157, 1156, 1156, 1156, 1156, 0, 0, 
  1177, 1157, 0, 0, 1178, 1179, 1165, 351, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1180, 0, 0, 0, 0, 1181, 1182, 0, 
  1183, 351, 351, 1156, 1156, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 351, 351, 14, 14, 1184, 1184, 1184, 
  1184, 1184, 1184, 840, 0, 0, 0, 0, 
  0, 0, 1156, 1156, 1157, 0, 351, 351, 
  351, 351, 351, 351, 0, 0, 0, 0, 
  351, 351, 0, 0, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 1185, 0, 351, 1186, 
  0, 351, 351, 0, 0, 1175, 0, 1157, 
  1157, 1157, 1156, 1156, 0, 0, 0, 0, 
  1156, 1156, 0, 0, 1156, 1156, 1165, 0, 
  0, 0, 1187, 0, 0, 0, 0, 0, 
  0, 0, 1188, 1189, 1190, 351, 0, 1191, 
  0, 0, 0, 0, 0, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1156, 1156, 351, 351, 351, 1187, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1156, 1156, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  351, 351, 351, 0, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 0, 351, 351, 
  351, 351, 351, 0, 0, 1175, 351, 1157, 
  1157, 1157, 1156, 1156, 1156, 1156, 1156, 0, 
  1156, 1156, 1157, 0, 1157, 1157, 1165, 0, 
  0, 351, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 1156, 1156, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 0, 14, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1156, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  351, 351, 0, 0, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 0, 351, 351, 
  351, 351, 351, 0, 0, 1175, 351, 1192, 
  1156, 1157, 1156, 1156, 1156, 1187, 0, 0, 
  1193, 1194, 0, 0, 1195, 1196, 1165, 0, 
  0, 0, 0, 0, 0, 0, 0, 1197, 
  1198, 0, 0, 0, 0, 1199, 1200, 0, 
  351, 351, 351, 1187, 1187, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 840, 351, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 1156, 351, 0, 351, 351, 
  351, 351, 351, 351, 0, 0, 0, 351, 
  351, 351, 0, 1201, 351, 1202, 351, 0, 
  0, 0, 351, 351, 0, 351, 0, 351, 
  351, 0, 0, 0, 351, 351, 0, 0, 
  0, 351, 351, 351, 0, 0, 0, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 0, 0, 0, 0, 1203, 
  1157, 1156, 1157, 1157, 0, 0, 0, 1204, 
  1205, 1157, 0, 1206, 1207, 1208, 1165, 0, 
  0, 351, 0, 0, 0, 0, 0, 0, 
  1209, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1184, 1184, 1184, 87, 87, 87, 87, 
  87, 87, 14, 87, 0, 0, 0, 0, 
  0, 0, 1157, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 351, 351, 
  351, 351, 351, 0, 0, 0, 351, 1156, 
  1156, 1156, 1157, 1157, 1157, 1157, 0, 1210, 
  1156, 1211, 0, 1156, 1156, 1156, 1165, 0, 
  0, 0, 0, 0, 0, 0, 1212, 1213, 
  0, 351, 351, 0, 0, 0, 0, 0, 
  0, 351, 351, 1187, 1187, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 0, 0, 0, 0, 0, 0, 0, 
  0, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  840, 0, 0, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 351, 351, 
  351, 351, 351, 0, 0, 1175, 351, 1157, 
  1215, 1216, 1157, 1217, 1157, 1157, 0, 1218, 
  1219, 1220, 0, 1221, 1222, 1156, 1165, 0, 
  0, 0, 0, 0, 0, 0, 1223, 1224, 
  0, 0, 0, 0, 0, 0, 0, 351, 
  0, 351, 351, 1156, 1156, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 0, 87, 87, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 0, 0, 0, 351, 1225, 
  1157, 1157, 1156, 1156, 1156, 1187, 0, 1226, 
  1227, 1157, 0, 1228, 1229, 1230, 1165, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1231, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 1187, 1187, 0, 0, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1184, 1184, 1184, 1184, 1184, 1184, 0, 
  0, 0, 840, 351, 351, 351, 351, 351, 
  351, 0, 0, 1157, 1157, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 0, 0, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 0, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 0, 0, 1232, 0, 0, 0, 0, 
  1233, 1157, 1157, 1156, 1156, 1156, 0, 1156, 
  0, 1157, 1234, 1235, 1157, 1236, 1237, 1238, 
  1239, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 1157, 1157, 1035, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1156, 1240, 1241, 1156, 1156, 1156, 
  1156, 1242, 1242, 1243, 0, 0, 0, 0, 
  14, 1240, 1240, 1240, 1240, 1240, 1240, 1244, 
  1151, 1245, 1245, 1245, 1245, 1151, 1156, 1151, 
  1035, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 1035, 1035, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 1240, 1240, 0, 1240, 0, 0, 
  1240, 1240, 0, 1240, 0, 0, 1240, 0, 
  0, 0, 0, 0, 0, 1240, 1240, 1240, 
  1240, 0, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 0, 1240, 1240, 1240, 0, 1240, 0, 
  1240, 0, 0, 1240, 1240, 0, 1240, 1240, 
  1240, 1240, 1156, 1240, 1246, 1156, 1156, 1156, 
  1156, 1247, 1247, 0, 1156, 1156, 1240, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 0, 1244, 
  0, 1248, 1248, 1248, 1248, 1151, 1156, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 1249, 1250, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 840, 840, 840, 1035, 1035, 1035, 
  1035, 1035, 1035, 1035, 1035, 1251, 1035, 1035, 
  1035, 1035, 1035, 1035, 840, 840, 840, 840, 
  840, 553, 553, 840, 840, 840, 840, 840, 
  840, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 840, 553, 840, 
  553, 840, 1252, 17, 18, 17, 18, 1253, 
  1253, 351, 351, 351, 1254, 351, 351, 351, 
  351, 0, 351, 351, 351, 351, 1255, 351, 
  351, 351, 351, 1256, 351, 351, 351, 351, 
  1257, 351, 351, 351, 351, 1258, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 1259, 351, 351, 351, 0, 0, 
  0, 0, 1260, 1261, 1262, 1263, 1264, 1265, 
  1266, 1267, 1268, 1261, 1261, 1261, 1261, 1156, 
  1157, 1261, 1269, 540, 540, 1165, 1035, 540, 
  540, 351, 351, 351, 351, 0, 0, 0, 
  0, 1156, 1156, 1156, 1270, 1156, 1156, 1156, 
  1156, 0, 1156, 1156, 1156, 1156, 1271, 1156, 
  1156, 1156, 1156, 1272, 1156, 1156, 1156, 1156, 
  1273, 1156, 1156, 1156, 1156, 1274, 1156, 1156, 
  1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
  1156, 1156, 1275, 1156, 1156, 1156, 0, 840, 
  840, 840, 840, 840, 840, 840, 840, 553, 
  840, 840, 840, 840, 840, 840, 0, 840, 
  840, 1035, 1035, 1035, 1035, 1035, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1276, 1277, 
  1240, 1240, 1240, 1240, 1157, 1157, 1156, 1278, 
  1156, 1156, 1157, 1156, 1187, 1187, 1187, 1156, 
  1175, 1157, 1165, 1279, 1157, 1157, 1187, 1187, 
  1240, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 1036, 1036, 1035, 1035, 1035, 
  1035, 1240, 1240, 1240, 1240, 1240, 1240, 1157, 
  1157, 1156, 1156, 1240, 1240, 1240, 1240, 1187, 
  1187, 1187, 1240, 1157, 1157, 1157, 1240, 1240, 
  1157, 1157, 1157, 1157, 1157, 1157, 1157, 1240, 
  1240, 1240, 1187, 1187, 1187, 1187, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1187, 1157, 1157, 1187, 1187, 
  1253, 1253, 1253, 1253, 1253, 1253, 1280, 1240, 
  1253, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 840, 
  840, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 
  1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 
  1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 
  1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 
  1312, 1313, 1314, 1315, 1316, 1317, 1318, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 1035, 1319, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 0, 0, 0, 0, 0, 
  1320, 1320, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 0, 0, 0, 0, 
  577, 840, 1035, 1036, 1035, 1035, 1035, 1035, 
  1036, 1036, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 1035, 1036, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 10, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 17, 18, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 1035, 1035, 1035, 1321, 
  1321, 1321, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 351, 
  351, 351, 351, 1156, 1156, 1243, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 1156, 1156, 1243, 1035, 1035, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 1156, 1156, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 351, 
  351, 351, 0, 1156, 1156, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1322, 1322, 1157, 
  1156, 1156, 1156, 1156, 1156, 1156, 1156, 1157, 
  1157, 1157, 1157, 1157, 1157, 1157, 1157, 1156, 
  1157, 1157, 1151, 1151, 1151, 1151, 1151, 1151, 
  1151, 1151, 1151, 1165, 1151, 1035, 1035, 1035, 
  1244, 1035, 1035, 1035, 14, 1240, 540, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 0, 
  0, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 0, 0, 0, 0, 0, 
  0, 15, 15, 1323, 11, 15, 15, 1078, 
  15, 1323, 11, 15, 574, 574, 574, 10, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 1324, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 1325, 351, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  0, 1156, 1156, 1156, 1157, 1157, 1157, 1157, 
  1156, 1156, 1157, 1157, 1157, 0, 0, 0, 
  0, 1157, 1157, 1156, 1157, 1157, 1157, 1157, 
  1157, 1157, 1079, 540, 553, 0, 0, 0, 
  0, 87, 0, 0, 0, 11, 11, 1174, 
  1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 0, 0, 0, 0, 0, 
  0, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  1157, 1157, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1157, 1157, 0, 0, 0, 0, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 15, 
  15, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  577, 576, 1157, 1157, 1157, 0, 0, 1035, 
  1035, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1156, 1156, 1156, 1156, 1157, 1326, 1327, 
  1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 
  351, 351, 1336, 1337, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 1175, 1338, 1156, 
  1156, 1156, 1156, 1339, 1340, 1341, 1342, 1343, 
  1344, 1345, 1346, 1347, 1348, 1349, 351, 351, 
  351, 351, 351, 351, 351, 0, 0, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 1036, 1036, 1035, 1035, 1036, 
  1036, 1035, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 540, 553, 540, 540, 
  540, 540, 540, 540, 540, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 0, 0, 
  0, 1187, 1187, 1157, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 1157, 1187, 1187, 1187, 1187, 1157, 
  1157, 1187, 1187, 1349, 0, 0, 0, 351, 
  351, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 1157, 1157, 1157, 
  1157, 1157, 1157, 1157, 1157, 1187, 1187, 1187, 
  1187, 1187, 1187, 1187, 1187, 1157, 1157, 1350, 
  1351, 0, 0, 0, 1036, 1036, 1035, 1035, 
  1035, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 351, 351, 
  351, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 522, 522, 522, 522, 522, 522, 1036, 
  1036, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 1352, 1353, 1354, 
  523, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 
  1362, 1363, 1364, 1365, 523, 1366, 1367, 1368, 
  1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 
  1377, 1378, 1379, 1380, 1381, 1382, 1383, 523, 
  1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 
  1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 
  1400, 1401, 1402, 1403, 1404, 1405, 1406, 1407, 
  1408, 1409, 1410, 1411, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 1412, 1413, 225, 225, 225, 1414, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 225, 225, 225, 225, 
  225, 225, 225, 225, 1415, 1416, 1417, 1418, 
  1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 
  1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 
  1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 
  1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 
  1451, 577, 577, 576, 577, 540, 540, 540, 
  540, 540, 540, 553, 841, 841, 1452, 1453, 
  1280, 1454, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 540, 
  553, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 
  1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 
  1470, 1471, 1472, 1473, 1474, 1475, 1476, 1477, 
  1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 
  1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 
  1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 
  1502, 1503, 1504, 1505, 1506, 1507, 1508, 1509, 
  1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 
  1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 
  1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 
  1534, 1535, 1536, 1537, 1538, 1539, 1540, 1541, 
  1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 
  1550, 1551, 1552, 1553, 1554, 1555, 1556, 1557, 
  1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, 
  1566, 1567, 1568, 1569, 1570, 1571, 1572, 1573, 
  1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 
  1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 
  1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 
  1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 
  1606, 1607, 1608, 1609, 1610, 225, 225, 1611, 
  225, 1612, 1613, 1614, 1615, 1616, 1617, 1618, 
  1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626, 
  1627, 1628, 1629, 1630, 1631, 1632, 1633, 1634, 
  1635, 1636, 1637, 1638, 1639, 1640, 1641, 1642, 
  1643, 1644, 1645, 1646, 1647, 1648, 1649, 1650, 
  1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 
  1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666, 
  1667, 1668, 1669, 1670, 1671, 1672, 1673, 1674, 
  1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 
  1683, 1684, 1685, 1686, 1687, 1688, 1689, 1690, 
  1691, 1692, 1693, 1694, 1695, 1696, 1697, 1698, 
  1699, 1700, 1701, 1702, 1703, 1704, 1705, 1706, 
  1707, 1708, 1709, 1710, 1711, 1712, 1713, 1714, 
  1715, 1716, 1717, 1718, 1719, 1720, 1721, 1722, 
  1723, 1724, 1725, 1726, 1727, 1728, 1729, 0, 
  0, 1730, 1731, 1732, 1733, 1734, 1735, 0, 
  0, 1736, 1737, 1738, 1739, 1740, 1741, 1742, 
  1743, 1744, 1745, 1746, 1747, 1748, 1749, 1750, 
  1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758, 
  1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 
  1767, 1768, 1769, 1770, 1771, 1772, 1773, 0, 
  0, 1774, 1775, 1776, 1777, 1778, 1779, 0, 
  0, 1780, 1781, 1782, 1783, 1784, 1785, 1786, 
  1787, 0, 1788, 0, 1789, 0, 1790, 0, 
  1791, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 
  1799, 1800, 1801, 1802, 1803, 1804, 1805, 1806, 
  1807, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 
  1815, 1816, 1817, 1818, 1819, 1820, 1821, 0, 
  0, 1822, 1823, 1824, 1825, 1826, 1827, 1828, 
  1829, 1830, 1831, 1832, 1833, 1834, 1835, 1836, 
  1837, 1838, 1839, 1840, 1841, 1842, 1843, 1844, 
  1845, 1846, 1847, 1848, 1849, 1850, 1851, 1852, 
  1853, 1854, 1855, 1856, 1857, 1858, 1859, 1860, 
  1861, 1862, 1863, 1864, 1865, 1866, 1867, 1868, 
  1869, 1870, 1871, 1872, 1873, 1874, 0, 1875, 
  1876, 1877, 1878, 1879, 1880, 1881, 1882, 1883, 
  1884, 1885, 1886, 1887, 1888, 1889, 0, 1890, 
  1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898, 
  1899, 1900, 1901, 1902, 1903, 0, 0, 1904, 
  1905, 1906, 1907, 1908, 1909, 0, 1910, 1911, 
  1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 
  1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927, 
  1928, 0, 0, 1929, 1930, 1931, 0, 1932, 
  1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 
  0, 1941, 1942, 1943, 1943, 1943, 1943, 1943, 
  1944, 1943, 1943, 1943, 91, 1945, 1945, 1322, 
  1946, 1078, 1947, 1078, 1948, 1948, 1078, 15, 
  1949, 1950, 1951, 1952, 1953, 1953, 1954, 1952, 
  1953, 15, 15, 15, 15, 1955, 1956, 1957, 
  1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 
  86, 13, 13, 13, 1966, 1967, 15, 1968, 
  1969, 15, 90, 103, 15, 1970, 11, 1971, 
  57, 57, 15, 15, 15, 1972, 17, 18, 
  1973, 1974, 1975, 15, 15, 15, 15, 15, 
  15, 15, 15, 84, 15, 57, 15, 15, 
  1976, 15, 15, 15, 15, 15, 15, 15, 
  1943, 91, 91, 91, 91, 91, 0, 0, 
  0, 0, 0, 91, 91, 91, 91, 91, 
  91, 1977, 1978, 0, 0, 1979, 1980, 1981, 
  1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 
  1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 
  1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 
  0, 2006, 2007, 2008, 2009, 2010, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 14, 14, 14, 14, 14, 14, 14, 
  14, 2011, 14, 14, 14, 14, 14, 14, 
  14, 14, 14, 14, 14, 14, 14, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 577, 577, 2012, 2012, 577, 577, 577, 
  577, 2012, 2012, 2012, 577, 577, 842, 842, 
  842, 842, 577, 842, 842, 842, 2012, 2012, 
  577, 576, 577, 2012, 2012, 576, 576, 576, 
  576, 1107, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2013, 2014, 2015, 2016, 87, 2017, 2018, 
  2019, 87, 2020, 2021, 2022, 2022, 2022, 2023, 
  2024, 2025, 2025, 2026, 2027, 87, 2028, 2029, 
  87, 87, 2030, 2031, 2032, 2032, 2032, 87, 
  87, 2033, 2034, 2035, 87, 2036, 87, 2037, 
  87, 2036, 87, 2038, 2039, 2040, 2015, 93, 
  2041, 2042, 2043, 2044, 2045, 2046, 2047, 2048, 
  2049, 2050, 2051, 87, 2052, 2053, 2054, 2055, 
  2056, 2057, 84, 84, 84, 84, 2058, 2059, 
  2041, 2051, 2060, 87, 84, 87, 87, 2061, 
  840, 0, 0, 0, 2062, 2063, 2064, 2065, 
  2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 
  2074, 2075, 2076, 2077, 2078, 2079, 2080, 2081, 
  2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 
  2090, 2091, 2092, 2093, 2094, 2095, 2096, 2097, 
  2098, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 
  2106, 1321, 1321, 1321, 2107, 2108, 1321, 1321, 
  1321, 1321, 0, 0, 0, 0, 0, 0, 
  0, 2109, 84, 2110, 84, 2111, 87, 87, 
  87, 87, 87, 2112, 2113, 87, 87, 87, 
  87, 84, 87, 87, 84, 87, 87, 84, 
  87, 87, 87, 87, 87, 87, 87, 2114, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 2115, 2116, 
  2117, 2118, 87, 2119, 87, 2120, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 2121, 2121, 2122, 2123, 84, 84, 
  84, 2124, 2125, 2121, 2126, 2127, 2121, 84, 
  84, 84, 2121, 19, 94, 84, 2121, 2121, 
  84, 84, 84, 2121, 2121, 2121, 2121, 84, 
  2121, 2121, 2121, 2121, 2128, 2129, 2130, 2131, 
  84, 84, 84, 84, 2121, 2132, 2133, 2121, 
  2134, 2135, 2121, 2121, 2121, 84, 84, 84, 
  84, 84, 2121, 84, 2121, 2136, 2121, 2121, 
  2121, 2121, 2137, 2121, 2138, 2139, 2140, 2121, 
  2141, 2142, 2143, 2121, 2121, 2121, 2144, 84, 
  84, 84, 84, 2121, 2121, 2121, 2121, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  2121, 2145, 2146, 2147, 84, 2148, 2149, 2121, 
  2121, 2121, 2121, 2121, 2121, 84, 2150, 2151, 
  2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 
  2160, 2161, 2162, 2163, 2164, 2165, 2166, 2121, 
  2121, 2167, 2168, 2169, 2170, 2171, 2172, 2173, 
  2174, 2175, 2176, 2121, 2121, 2121, 84, 84, 
  2121, 2121, 2177, 2178, 84, 84, 84, 84, 
  84, 2121, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 2179, 2121, 84, 84, 2121, 
  2121, 2180, 2181, 2121, 2182, 2183, 2184, 2185, 
  2186, 2121, 2121, 2187, 2188, 2189, 2190, 2121, 
  2121, 2121, 84, 84, 84, 84, 84, 2121, 
  2121, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 2121, 2121, 2121, 2121, 2121, 84, 
  84, 2121, 2121, 84, 84, 84, 84, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2191, 2192, 2193, 2194, 2121, 2121, 2121, 
  2121, 2121, 2121, 2195, 2196, 2197, 2198, 84, 
  84, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 87, 87, 87, 87, 87, 87, 87, 
  87, 2121, 2121, 2121, 2121, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 2121, 2121, 87, 87, 87, 87, 87, 
  87, 87, 2199, 2200, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 87, 84, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 840, 87, 
  87, 87, 87, 87, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 84, 84, 84, 
  84, 84, 84, 87, 87, 87, 87, 87, 
  87, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2201, 2202, 2203, 2204, 2205, 2206, 2207, 
  2208, 2209, 2210, 2211, 2212, 2213, 2214, 2215, 
  2216, 2217, 2218, 2219, 2220, 2221, 2222, 2223, 
  2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 
  2232, 2233, 2234, 2235, 2236, 2237, 2238, 2239, 
  2240, 2241, 2242, 2243, 2244, 2245, 2246, 2247, 
  2248, 2249, 2250, 2251, 2252, 2253, 2254, 2255, 
  2256, 2257, 2258, 2259, 2260, 2261, 2262, 2263, 
  2264, 2265, 2266, 2267, 2268, 2269, 2270, 2271, 
  2272, 2273, 2274, 2275, 2276, 2277, 2278, 2279, 
  2280, 2281, 2282, 2283, 2284, 2285, 2286, 2287, 
  2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295, 
  2296, 2297, 2298, 2299, 2300, 2301, 2302, 2303, 
  2304, 2305, 2306, 2307, 2308, 2309, 2310, 2311, 
  2312, 2313, 2314, 2315, 2316, 2317, 2318, 2319, 
  2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 
  2328, 2329, 2330, 2331, 2332, 2333, 2334, 2335, 
  2336, 2337, 2338, 2339, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  84, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 84, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 84, 84, 84, 84, 84, 84, 84, 
  84, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  84, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 840, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 0, 0, 
  0, 87, 87, 87, 87, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 87, 87, 87, 87, 0, 87, 
  87, 87, 87, 0, 0, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 0, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 87, 0, 
  87, 87, 87, 87, 0, 0, 0, 87, 
  0, 87, 87, 87, 2340, 2340, 2340, 2340, 
  0, 0, 87, 87, 87, 87, 87, 87, 
  87, 17, 18, 17, 18, 17, 18, 17, 
  18, 17, 18, 17, 18, 17, 18, 1214, 
  1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
  1214, 1214, 1214, 1214, 1214, 87, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 0, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  0, 2121, 84, 84, 2121, 2121, 17, 18, 
  84, 2121, 2121, 84, 0, 2121, 0, 0, 
  0, 84, 84, 84, 2121, 2121, 2121, 2121, 
  84, 84, 84, 84, 84, 2121, 2121, 2121, 
  84, 84, 84, 2121, 2121, 2121, 2121, 17, 
  18, 17, 18, 17, 18, 17, 18, 17, 
  18, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 17, 18, 17, 18, 
  17, 18, 17, 18, 17, 18, 17, 18, 
  17, 18, 17, 18, 17, 18, 17, 18, 
  17, 18, 84, 84, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 84, 84, 84, 84, 84, 84, 84, 
  84, 2121, 84, 84, 84, 84, 84, 84, 
  84, 2121, 2121, 2121, 2121, 2121, 2121, 84, 
  84, 84, 2121, 84, 84, 84, 84, 2121, 
  2121, 2121, 2121, 2121, 84, 2121, 2121, 84, 
  84, 17, 18, 17, 18, 2121, 84, 84, 
  84, 84, 2121, 84, 2121, 2121, 2121, 84, 
  84, 2121, 2121, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 2121, 2121, 2121, 
  2121, 2121, 2121, 84, 84, 17, 18, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 2121, 2121, 2341, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 84, 2121, 
  2121, 2121, 2121, 84, 84, 2121, 84, 2121, 
  84, 84, 2121, 84, 2121, 2121, 2121, 2121, 
  84, 84, 84, 84, 84, 2121, 2121, 84, 
  84, 84, 84, 84, 84, 2121, 2121, 2121, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  2121, 2121, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 2121, 2121, 84, 
  84, 84, 84, 2121, 2121, 2121, 2121, 84, 
  2121, 2121, 84, 84, 2121, 2342, 2343, 2344, 
  84, 84, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 84, 84, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 84, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  2121, 2121, 2121, 2121, 2121, 2121, 2121, 2121, 
  84, 84, 84, 84, 84, 2345, 2346, 2121, 
  84, 84, 84, 2121, 2121, 2121, 2121, 2121, 
  84, 84, 84, 84, 84, 2121, 2121, 2121, 
  84, 84, 84, 84, 2121, 84, 84, 84, 
  2121, 2121, 2121, 2121, 2121, 84, 2121, 84, 
  84, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 84, 84, 
  84, 84, 84, 84, 84, 84, 87, 87, 
  84, 84, 84, 84, 84, 84, 0, 0, 
  0, 87, 87, 87, 87, 87, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2347, 2348, 2349, 2350, 2351, 2352, 2353, 
  2354, 2355, 2356, 2357, 2358, 2359, 2360, 2361, 
  2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 
  2370, 2371, 2372, 2373, 2374, 2375, 2376, 2377, 
  2378, 2379, 2380, 2381, 2382, 2383, 2384, 2385, 
  2386, 2387, 2388, 2389, 2390, 2391, 2392, 2393, 
  0, 2394, 2395, 2396, 2397, 2398, 2399, 2400, 
  2401, 2402, 2403, 2404, 2405, 2406, 2407, 2408, 
  2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 
  2417, 2418, 2419, 2420, 2421, 2422, 2423, 2424, 
  2425, 2426, 2427, 2428, 2429, 2430, 2431, 2432, 
  2433, 2434, 2435, 2436, 2437, 2438, 2439, 2440, 
  0, 2441, 2442, 2443, 2444, 2445, 2446, 2447, 
  2448, 2449, 2450, 2451, 2452, 2453, 2454, 2455, 
  2456, 0, 225, 2457, 2458, 225, 2459, 2460, 
  225, 225, 225, 225, 225, 2461, 2462, 0, 
  0, 2463, 2464, 2465, 2466, 2467, 2468, 2469, 
  2470, 2471, 2472, 2473, 2474, 2475, 2476, 2477, 
  2478, 2479, 2480, 2481, 2482, 2483, 2484, 2485, 
  2486, 2487, 2488, 2489, 2490, 2491, 2492, 2493, 
  2494, 2495, 2496, 2497, 2498, 2499, 2500, 2501, 
  2502, 2503, 2504, 2505, 2506, 2507, 2508, 2509, 
  2510, 2511, 2512, 2513, 2514, 2515, 2516, 2517, 
  2518, 2519, 2520, 2521, 2522, 2523, 2524, 2525, 
  2526, 2527, 2528, 2529, 2530, 2531, 2532, 2533, 
  2534, 2535, 2536, 2537, 2538, 2539, 2540, 2541, 
  2542, 2543, 2544, 2545, 2546, 2547, 2548, 2549, 
  2550, 2551, 2552, 2553, 2554, 2555, 2556, 2557, 
  2558, 2559, 2560, 2561, 2562, 225, 87, 87, 
  87, 87, 87, 87, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 15, 15, 15, 15, 1214, 15, 
  15, 2563, 2564, 2565, 2566, 2567, 2568, 2569, 
  2570, 2571, 2572, 2573, 2574, 2575, 2576, 2577, 
  2578, 2579, 2580, 2581, 2582, 2583, 2584, 2585, 
  2586, 2587, 2588, 2589, 2590, 2591, 2592, 2593, 
  2594, 2595, 2596, 2597, 2598, 2599, 2600, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  2601, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  0, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 1107, 1107, 1107, 1107, 1107, 1107, 1107, 
  1107, 12, 12, 90, 103, 90, 103, 12, 
  12, 12, 90, 103, 12, 90, 103, 15, 
  15, 15, 15, 15, 15, 15, 15, 15, 
  1078, 15, 15, 1078, 15, 90, 103, 15, 
  15, 90, 103, 17, 18, 17, 18, 17, 
  18, 17, 18, 15, 15, 15, 15, 11, 
  521, 15, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 0, 87, 87, 87, 87, 
  2602, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 2603, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2604, 2605, 2606, 2607, 2608, 2609, 2610, 
  2611, 2612, 2613, 2614, 2615, 2616, 2617, 2618, 
  2619, 2620, 2621, 2622, 2623, 2624, 2625, 2626, 
  2627, 2628, 2629, 2630, 2631, 2632, 2633, 2634, 
  2635, 2636, 2637, 2638, 2639, 2640, 2641, 2642, 
  2643, 2644, 2645, 2646, 2647, 2648, 2649, 2650, 
  2651, 2652, 2653, 2654, 2655, 2656, 2657, 2658, 
  2659, 2660, 2661, 2662, 2663, 2664, 2665, 2666, 
  2667, 2668, 2669, 2670, 2671, 2672, 2673, 2674, 
  2675, 2676, 2677, 2678, 2679, 2680, 2681, 2682, 
  2683, 2684, 2685, 2686, 2687, 2688, 2689, 2690, 
  2691, 2692, 2693, 2694, 2695, 2696, 2697, 2698, 
  2699, 2700, 2701, 2702, 2703, 2704, 2705, 2706, 
  2707, 2708, 2709, 2710, 2711, 2712, 2713, 2714, 
  2715, 2716, 2717, 2718, 2719, 2720, 2721, 2722, 
  2723, 2724, 2725, 2726, 2727, 2728, 2729, 2730, 
  2731, 2732, 2733, 2734, 2735, 2736, 2737, 2738, 
  2739, 2740, 2741, 2742, 2743, 2744, 2745, 2746, 
  2747, 2748, 2749, 2750, 2751, 2752, 2753, 2754, 
  2755, 2756, 2757, 2758, 2759, 2760, 2761, 2762, 
  2763, 2764, 2765, 2766, 2767, 2768, 2769, 2770, 
  2771, 2772, 2773, 2774, 2775, 2776, 2777, 2778, 
  2779, 2780, 2781, 2782, 2783, 2784, 2785, 2786, 
  2787, 2788, 2789, 2790, 2791, 2792, 2793, 2794, 
  2795, 2796, 2797, 2798, 2799, 2800, 2801, 2802, 
  2803, 2804, 2805, 2806, 2807, 2808, 2809, 2810, 
  2811, 2812, 2813, 2814, 2815, 2816, 2817, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 0, 0, 
  0, 2818, 1323, 11, 15, 87, 1324, 1240, 
  2819, 17, 18, 17, 18, 17, 18, 17, 
  18, 17, 18, 87, 87, 17, 18, 17, 
  18, 17, 18, 17, 18, 1078, 1952, 2820, 
  2820, 87, 2819, 2819, 2819, 2819, 2819, 2819, 
  2819, 2819, 2819, 2821, 1080, 552, 1079, 2822, 
  2822, 1078, 2823, 2823, 2823, 2823, 2823, 2824, 
  87, 2825, 2826, 2827, 1324, 351, 15, 87, 
  87, 0, 1240, 1240, 1240, 1240, 1240, 2828, 
  1240, 1240, 1240, 1240, 2829, 2830, 2831, 2832, 
  2833, 2834, 2835, 2836, 2837, 2838, 2839, 2840, 
  2841, 2842, 2843, 2844, 2845, 2846, 2847, 2848, 
  2849, 2850, 2851, 2852, 1240, 2853, 2854, 2855, 
  2856, 2857, 2858, 1240, 1240, 1240, 1240, 1240, 
  2859, 2860, 2861, 2862, 2863, 2864, 2865, 2866, 
  2867, 2868, 2869, 2870, 2871, 2872, 2873, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 2874, 1240, 1240, 
  0, 0, 2875, 2876, 2877, 2878, 2879, 2880, 
  2881, 2882, 2883, 2883, 2883, 2883, 2883, 2884, 
  2883, 2883, 2883, 2883, 2885, 2886, 2887, 2888, 
  2889, 2890, 2891, 2892, 2893, 2894, 2895, 2896, 
  2897, 2898, 2899, 2900, 2901, 2902, 2903, 2904, 
  2905, 2906, 2907, 2908, 2883, 2909, 2910, 2911, 
  2912, 2913, 2914, 2883, 2883, 2883, 2883, 2883, 
  2915, 2916, 2917, 2918, 2919, 2920, 2921, 2922, 
  2923, 2924, 2925, 2926, 2927, 2928, 2929, 2883, 
  2883, 2883, 2883, 2883, 2883, 2883, 2883, 2883, 
  2883, 2883, 2883, 2883, 2883, 2883, 2883, 2883, 
  2930, 2931, 2932, 2933, 2883, 2934, 2883, 2883, 
  2935, 2936, 2937, 2938, 15, 2939, 2940, 2941, 
  2942, 0, 0, 0, 0, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  0, 0, 2943, 2944, 2945, 2946, 2947, 2948, 
  2949, 2950, 2951, 2952, 2953, 2954, 2955, 2956, 
  2957, 2958, 2959, 2960, 2961, 2962, 2963, 2964, 
  2965, 2966, 2967, 2968, 2969, 2970, 2971, 2972, 
  2973, 2974, 2975, 2976, 2977, 2978, 2979, 2980, 
  2981, 2982, 2983, 2984, 2985, 2986, 2987, 2988, 
  2989, 2990, 2991, 2992, 2993, 2994, 2995, 2996, 
  2997, 2998, 2999, 3000, 3001, 3002, 3003, 3004, 
  3005, 3006, 3007, 3008, 3009, 3010, 3011, 3012, 
  3013, 3014, 3015, 3016, 3017, 3018, 3019, 3020, 
  3021, 3022, 3023, 3024, 3025, 3026, 3027, 3028, 
  3029, 3030, 3031, 3032, 3033, 3034, 3035, 3036, 
  0, 840, 840, 3037, 3038, 3039, 3040, 3041, 
  3042, 3043, 3044, 3045, 3046, 3047, 3048, 3049, 
  3050, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 2883, 2883, 2883, 2883, 2883, 2883, 2883, 
  2883, 2883, 2883, 2883, 2883, 2883, 2883, 2883, 
  2883, 3051, 3052, 3053, 3054, 3055, 3056, 3057, 
  3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065, 
  3066, 3067, 3068, 3069, 3070, 3071, 3072, 3073, 
  3074, 3075, 3076, 3077, 3078, 3079, 3080, 3081, 
  0, 3082, 3083, 3084, 3085, 3086, 3087, 3088, 
  3089, 3090, 3091, 3092, 3093, 3094, 3095, 3096, 
  3097, 3098, 3099, 3100, 3101, 3102, 3103, 3104, 
  3105, 3106, 3107, 3108, 3109, 3110, 3111, 3112, 
  3113, 3114, 3115, 3116, 3117, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3118, 3119, 3120, 3121, 3122, 3123, 3124, 
  3125, 3126, 3127, 3128, 3129, 3130, 3131, 3132, 
  3133, 3134, 3135, 3136, 3137, 3138, 3139, 3140, 
  3141, 3142, 3143, 3144, 3145, 3146, 3147, 3148, 
  3149, 3150, 3151, 3152, 3153, 3154, 3155, 3156, 
  3157, 3158, 3159, 3160, 3161, 3162, 3163, 3164, 
  840, 3165, 3166, 3167, 3168, 3169, 3170, 3171, 
  3172, 3173, 3174, 3175, 3176, 3177, 3178, 3179, 
  3180, 3181, 3182, 3183, 3184, 3185, 3186, 3187, 
  3188, 3189, 3190, 3191, 3192, 3193, 3194, 3195, 
  3196, 3197, 3198, 3199, 3200, 3201, 3202, 3203, 
  3204, 3205, 3206, 3207, 3208, 3209, 3210, 3211, 
  3212, 3213, 3214, 3215, 3216, 3217, 3218, 3219, 
  3220, 3221, 3222, 3223, 3224, 3225, 3226, 3227, 
  3228, 3229, 3230, 3231, 3232, 3233, 3234, 3235, 
  3236, 3237, 3238, 3239, 3240, 3241, 3242, 3243, 
  3244, 3245, 3246, 3247, 3248, 3249, 3250, 3251, 
  3252, 3253, 3254, 3255, 3256, 3257, 3258, 3259, 
  3260, 3261, 3262, 3263, 3264, 3265, 3266, 3267, 
  3268, 3269, 3270, 3271, 3272, 3273, 3274, 3275, 
  3276, 3277, 3278, 3279, 3280, 3281, 3282, 3283, 
  3284, 3285, 3286, 3287, 3288, 3289, 3290, 3291, 
  0, 3292, 3293, 3294, 3295, 3296, 3297, 3298, 
  3299, 3300, 3301, 3302, 3303, 3304, 3305, 3306, 
  3307, 3308, 3309, 3310, 3311, 3312, 3313, 3314, 
  3315, 3316, 3317, 3318, 3319, 3320, 3321, 3322, 
  3323, 3324, 3325, 3326, 3327, 3328, 3329, 3330, 
  3331, 3332, 3333, 3334, 3335, 3336, 3337, 3338, 
  3339, 3340, 3341, 3342, 3343, 3344, 3345, 3346, 
  3347, 3348, 3349, 3350, 3351, 3352, 3353, 3354, 
  3355, 3356, 3357, 3358, 3359, 3360, 3361, 3362, 
  3363, 3364, 3365, 3366, 3367, 3368, 3369, 3370, 
  3371, 3372, 3373, 3374, 3375, 3376, 3377, 3378, 
  3379, 3380, 3381, 3382, 3383, 3384, 3385, 3386, 
  3387, 3388, 3389, 3390, 3391, 3392, 3393, 3394, 
  3395, 3396, 3397, 3398, 3399, 3400, 3401, 3402, 
  3403, 3404, 3405, 3406, 3407, 3408, 3409, 3410, 
  3411, 3412, 3413, 3414, 3415, 3416, 3417, 3418, 
  3419, 3420, 3421, 3422, 3423, 3424, 3425, 3426, 
  3427, 3428, 3429, 3430, 3431, 3432, 3433, 3434, 
  3435, 3436, 3437, 3438, 3439, 3440, 3441, 3442, 
  3443, 3444, 3445, 3446, 3447, 3448, 3449, 3450, 
  3451, 3452, 3453, 3454, 3455, 3456, 3457, 3458, 
  3459, 3460, 3461, 3462, 3463, 3464, 3465, 3466, 
  3467, 3468, 3469, 3470, 3471, 3472, 3473, 3474, 
  3475, 3476, 3477, 3478, 3479, 3480, 3481, 3482, 
  3483, 3484, 3485, 3486, 3487, 3488, 3489, 3490, 
  3491, 3492, 3493, 3494, 3495, 3496, 3497, 3498, 
  3499, 3500, 3501, 3502, 3503, 3504, 3505, 3506, 
  3507, 3508, 3509, 3510, 3511, 3512, 3513, 3514, 
  3515, 3516, 3517, 3518, 3519, 3520, 3521, 3522, 
  3523, 3524, 3525, 3526, 3527, 3528, 3529, 3530, 
  3531, 3532, 3533, 3534, 3535, 3536, 3537, 3538, 
  3539, 3540, 3541, 3542, 3543, 3544, 3545, 3546, 
  3547, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 1324, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 1324, 15, 11, 
  11, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 351, 351, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3548, 3549, 3550, 3551, 3552, 3553, 3554, 
  3555, 3556, 3557, 3558, 3559, 3560, 3561, 3562, 
  3563, 3564, 3565, 3566, 3567, 3568, 3569, 3570, 
  3571, 3572, 3573, 3574, 3575, 3576, 3577, 3578, 
  3579, 0, 0, 3580, 3581, 3582, 3583, 3584, 
  3585, 3586, 3587, 3588, 3589, 3590, 3591, 351, 
  841, 3592, 3592, 3592, 15, 0, 0, 0, 
  0, 0, 0, 0, 0, 841, 841, 15, 
  521, 3593, 3594, 3595, 3596, 3597, 3598, 3599, 
  3600, 3601, 3602, 3603, 3604, 3605, 3606, 3607, 
  3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615, 
  3616, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3617, 3617, 3617, 3617, 3617, 3617, 3617, 
  3617, 3617, 3617, 3617, 3617, 3617, 3617, 3617, 
  3617, 3617, 3617, 3617, 3617, 3617, 3617, 3617, 
  521, 521, 521, 521, 521, 521, 521, 521, 
  521, 56, 56, 3618, 3619, 3620, 3621, 3622, 
  3623, 3624, 3625, 3626, 3627, 3628, 3629, 3630, 
  3631, 225, 225, 3632, 3633, 3634, 3635, 3636, 
  3637, 3638, 3639, 3640, 3641, 3642, 3643, 3644, 
  3645, 3646, 3647, 3648, 3649, 3650, 3651, 3652, 
  3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660, 
  3661, 3662, 3663, 3664, 3665, 3666, 3667, 3668, 
  3669, 3670, 3671, 3672, 3673, 3674, 3675, 3676, 
  3677, 3678, 3679, 3680, 3681, 3682, 3683, 3684, 
  3685, 3686, 3687, 3688, 3689, 3690, 3691, 3692, 
  3693, 3694, 225, 225, 225, 225, 225, 225, 
  225, 225, 3695, 3696, 3697, 3698, 3699, 3700, 
  3701, 3702, 3703, 3704, 3705, 3706, 3707, 3708, 
  3709, 521, 3710, 3710, 3711, 3712, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 351, 351, 351, 351, 
  351, 351, 351, 1187, 351, 351, 351, 1243, 
  351, 351, 351, 351, 1156, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 1157, 1157, 1156, 1156, 
  1157, 87, 87, 87, 87, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 15, 15, 11, 
  11, 0, 0, 0, 0, 0, 0, 0, 
  0, 1157, 1157, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 1157, 1157, 1157, 
  1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 
  1157, 1157, 1157, 1157, 1157, 1279, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 1036, 
  1036, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 1187, 
  1187, 1187, 1187, 1187, 1280, 1280, 1280, 3713, 
  1036, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  1187, 1187, 1187, 1187, 1187, 1187, 1187, 1187, 
  1187, 1187, 1187, 1157, 1349, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  1035, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 1187, 1187, 1187, 1187, 1187, 1187, 
  1157, 1157, 1187, 1187, 1157, 1157, 1187, 1187, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 1187, 351, 351, 351, 
  351, 351, 351, 351, 351, 1187, 1157, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 1035, 1036, 1036, 
  1036, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3714, 3714, 3714, 3714, 3714, 3714, 3714, 
  3714, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3716, 3717, 3718, 3719, 3720, 3721, 3722, 
  3723, 3723, 3724, 3725, 3726, 3727, 3728, 3729, 
  3730, 3731, 3732, 3733, 3734, 3735, 3736, 3737, 
  3738, 3739, 3740, 3741, 3742, 3743, 3744, 3745, 
  3746, 3747, 3748, 3749, 3750, 3751, 3752, 3753, 
  3754, 3755, 3756, 3757, 3758, 3759, 3760, 3761, 
  3762, 3763, 3764, 3765, 3766, 3767, 3768, 3769, 
  3770, 3771, 3772, 3773, 3774, 3775, 3776, 3777, 
  3778, 3779, 3780, 3781, 3782, 3783, 3784, 3785, 
  3786, 3787, 3788, 3789, 3790, 3791, 3792, 3793, 
  3794, 3795, 3796, 3797, 3798, 3799, 3800, 3801, 
  3802, 3803, 3804, 3805, 3806, 3735, 3807, 3808, 
  3809, 3810, 3811, 3812, 3813, 3814, 3815, 3816, 
  3817, 3818, 3819, 3820, 3821, 3822, 3823, 3824, 
  3825, 3826, 3827, 3828, 3829, 3830, 3831, 3832, 
  3833, 3834, 3835, 3836, 3837, 3838, 3839, 3840, 
  3841, 3842, 3843, 3844, 3845, 3846, 3847, 3848, 
  3849, 3850, 3851, 3852, 3853, 3854, 3855, 3856, 
  3857, 3858, 3859, 3860, 3861, 3862, 3863, 3864, 
  3865, 3866, 3867, 3868, 3869, 3870, 3871, 3872, 
  3873, 3874, 3825, 3875, 3876, 3877, 3878, 3879, 
  3880, 3881, 3882, 3809, 3883, 3884, 3885, 3886, 
  3887, 3888, 3889, 3890, 3891, 3892, 3893, 3894, 
  3895, 3896, 3897, 3898, 3899, 3900, 3901, 3902, 
  3735, 3903, 3904, 3905, 3906, 3907, 3908, 3909, 
  3910, 3911, 3912, 3913, 3914, 3915, 3916, 3917, 
  3918, 3919, 3920, 3921, 3922, 3923, 3924, 3925, 
  3926, 3927, 3928, 3929, 3811, 3930, 3931, 3932, 
  3933, 3934, 3935, 3936, 3937, 3938, 3939, 3940, 
  3941, 3942, 3943, 3944, 3945, 3946, 3947, 3948, 
  3949, 3950, 3951, 3952, 3953, 3954, 3955, 3956, 
  3957, 3958, 3959, 3960, 3961, 3962, 3963, 3964, 
  3965, 3966, 3967, 3968, 3969, 3970, 3971, 3972, 
  3973, 3974, 3975, 3976, 3977, 3978, 3979, 1240, 
  1240, 3980, 1240, 3981, 1240, 1240, 3982, 3983, 
  3984, 3985, 3986, 3987, 3988, 3989, 3990, 3991, 
  1240, 3992, 1240, 3993, 1240, 1240, 3994, 3995, 
  1240, 1240, 1240, 3996, 3997, 3998, 3999, 0, 
  0, 4000, 4001, 4002, 4003, 4004, 4005, 4006, 
  4007, 4008, 4009, 4010, 4011, 4012, 4013, 4014, 
  4015, 4016, 4017, 4018, 4019, 4020, 4021, 4022, 
  4023, 4024, 4025, 4026, 4027, 4028, 4029, 4030, 
  4031, 4032, 4033, 4034, 4035, 4036, 4037, 4038, 
  3864, 4039, 4040, 4041, 4042, 4043, 4044, 4044, 
  4045, 4046, 4047, 4048, 4049, 4050, 4051, 4052, 
  3994, 4053, 4054, 4055, 0, 0, 0, 0, 
  0, 4056, 4057, 4058, 4059, 4060, 4061, 4062, 
  4063, 4006, 4064, 4065, 4066, 3980, 4067, 4068, 
  4069, 4070, 4071, 4072, 4073, 4074, 4075, 4076, 
  4077, 4078, 4015, 4079, 4016, 4080, 4081, 4082, 
  4083, 4084, 3981, 3756, 4085, 4086, 4087, 3826, 
  3913, 4088, 4089, 4023, 4090, 4024, 4091, 4092, 
  4093, 3983, 4094, 4095, 4096, 4097, 4098, 3984, 
  4099, 4100, 4101, 4102, 4103, 4104, 4038, 4105, 
  4106, 3864, 4107, 4042, 4108, 4109, 4110, 4111, 
  4112, 4047, 4113, 3993, 4114, 4048, 3807, 4115, 
  4049, 4116, 4051, 4117, 4118, 4119, 4120, 4121, 
  4053, 3989, 4122, 4054, 4123, 4055, 4124, 3723, 
  4125, 4126, 4127, 4128, 4129, 4130, 4131, 4132, 
  4133, 4134, 4135, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4136, 4137, 4138, 4139, 4140, 4141, 4142, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 4143, 4144, 4145, 4146, 
  4147, 0, 0, 0, 0, 0, 4148, 4149, 
  4150, 4151, 4152, 4153, 4154, 4155, 4156, 4157, 
  4158, 4159, 4160, 4161, 4162, 4163, 4164, 4165, 
  4166, 4167, 4168, 4169, 4170, 4171, 4172, 4173, 
  0, 4174, 4175, 4176, 4177, 4178, 0, 4179, 
  0, 4180, 4181, 0, 4182, 4183, 0, 4184, 
  4185, 4186, 4187, 4188, 4189, 4190, 4191, 4192, 
  4193, 4194, 4195, 4196, 4197, 4198, 4199, 4200, 
  4201, 4202, 4203, 4204, 4205, 4206, 4207, 4208, 
  4209, 4210, 4211, 4212, 4213, 4214, 4215, 4216, 
  4217, 4218, 4219, 4220, 4221, 4222, 4223, 4224, 
  4225, 4226, 4227, 4228, 4229, 4230, 4231, 4232, 
  4233, 4234, 4235, 4236, 4237, 4238, 4239, 4240, 
  4241, 4242, 4243, 4244, 4245, 4246, 4247, 4248, 
  4249, 4250, 4251, 4252, 4253, 4254, 4255, 4256, 
  4257, 4258, 4259, 4260, 4261, 4262, 4263, 4264, 
  4265, 4266, 4267, 4268, 4269, 4270, 4271, 4272, 
  4273, 4274, 4275, 4276, 4277, 4278, 4279, 4280, 
  4281, 4282, 4283, 4284, 4285, 4286, 4287, 4288, 
  4289, 4290, 4291, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 4292, 4293, 4294, 4295, 
  4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303, 
  4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311, 
  4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319, 
  4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327, 
  4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335, 
  4336, 4337, 4338, 4339, 4330, 4340, 4341, 4342, 
  4343, 4344, 4345, 4346, 4347, 4348, 4349, 4350, 
  4351, 4352, 4353, 4354, 4355, 4356, 4357, 4358, 
  4359, 4360, 4361, 4362, 4363, 4364, 4365, 4366, 
  4367, 4368, 4369, 4370, 4371, 4372, 4373, 4374, 
  4375, 4376, 4377, 4378, 4379, 4380, 4381, 4382, 
  4383, 4384, 4385, 4386, 4387, 4388, 4389, 4390, 
  4391, 4392, 4393, 4394, 4395, 4396, 4397, 4398, 
  4399, 4400, 4401, 4402, 4403, 4404, 4405, 4406, 
  4407, 4408, 4409, 4410, 4411, 4412, 4413, 4414, 
  4415, 4416, 4417, 4418, 4419, 4420, 4421, 4422, 
  4423, 4424, 4425, 4426, 4427, 4428, 4429, 4430, 
  4431, 4432, 4433, 4434, 4435, 4436, 4437, 4438, 
  4439, 4331, 4440, 4441, 4442, 4443, 4444, 4445, 
  4446, 4447, 4448, 4449, 4450, 4451, 4452, 4453, 
  4454, 4455, 4456, 4457, 4458, 4459, 4460, 4461, 
  4462, 4463, 4464, 4465, 4466, 4467, 4468, 4469, 
  4470, 4471, 4472, 4473, 4474, 4475, 4476, 4477, 
  4478, 4479, 4480, 4481, 4482, 4483, 4484, 4485, 
  4486, 4487, 4488, 4489, 4490, 4491, 4492, 4493, 
  4494, 4495, 4496, 4497, 4498, 4499, 4500, 4501, 
  4502, 4503, 4504, 4505, 4506, 4507, 4508, 4509, 
  4510, 4511, 4512, 4513, 4514, 4515, 4516, 4517, 
  4518, 4519, 4520, 4521, 4522, 4523, 4524, 4525, 
  4526, 4527, 4528, 4529, 4530, 4531, 4532, 4533, 
  4534, 4535, 4536, 4537, 4538, 4539, 4540, 4541, 
  4542, 4543, 4544, 4545, 4546, 4547, 4548, 4549, 
  4550, 4551, 4552, 4553, 4554, 4555, 4556, 4557, 
  4558, 4559, 4560, 4561, 4562, 4563, 4564, 4565, 
  4566, 4567, 4568, 4569, 4570, 4571, 4572, 4573, 
  4574, 4575, 4576, 4577, 4578, 4579, 4580, 4581, 
  4582, 4583, 4584, 4585, 4586, 4587, 4588, 4589, 
  4590, 4591, 4592, 4593, 4594, 4595, 4596, 4597, 
  4598, 4599, 4600, 4601, 4602, 4603, 4604, 4605, 
  4606, 4607, 4608, 4609, 4610, 4611, 4612, 4613, 
  4614, 4615, 4616, 4617, 4618, 4619, 4620, 4621, 
  4622, 4623, 4624, 4625, 4626, 4627, 4628, 4629, 
  4630, 4631, 4632, 4633, 4634, 4635, 4636, 4637, 
  4638, 4639, 4640, 4641, 4642, 4643, 4644, 4645, 
  4646, 4647, 4648, 4649, 4650, 4651, 4652, 1952, 
  2820, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4653, 4654, 4655, 4656, 4657, 4658, 4659, 
  4660, 4661, 4662, 4663, 4664, 4665, 4666, 4667, 
  4668, 4669, 4670, 4671, 4672, 4673, 4674, 4675, 
  4676, 4677, 4678, 4679, 4680, 4681, 4682, 4683, 
  4684, 4685, 4686, 4687, 4688, 4689, 4690, 4691, 
  4692, 4693, 4694, 4695, 4696, 4697, 4698, 4699, 
  4700, 4701, 4702, 4703, 4704, 4705, 4706, 4707, 
  4708, 4709, 4710, 4711, 4712, 4713, 4714, 4715, 
  4716, 0, 0, 4717, 4718, 4719, 4720, 4721, 
  4722, 4723, 4724, 4725, 4726, 4727, 4728, 4729, 
  4730, 4731, 4732, 4733, 4734, 4735, 4736, 4737, 
  4738, 4739, 4740, 4741, 4742, 4743, 4744, 4745, 
  4746, 4747, 4748, 4749, 4750, 4751, 4752, 4753, 
  4754, 4755, 4756, 4757, 4758, 4759, 4760, 4761, 
  4762, 4763, 4764, 4765, 4766, 4767, 4768, 4769, 
  4770, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4771, 4772, 4773, 4774, 4775, 4776, 4777, 
  4778, 4779, 4780, 4781, 4782, 4783, 87, 0, 
  0, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 4784, 4785, 4786, 4787, 4788, 4789, 4790, 
  4791, 4792, 4793, 0, 0, 0, 0, 0, 
  0, 540, 540, 540, 540, 841, 841, 841, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 4794, 4795, 4796, 4797, 4797, 4798, 4799, 
  4800, 4801, 4802, 4803, 4804, 4805, 4806, 4807, 
  4808, 4809, 4810, 4811, 4812, 4813, 15, 15, 
  4814, 4815, 4816, 4816, 4816, 4816, 4817, 4817, 
  4817, 4818, 4819, 4820, 0, 4821, 4822, 4823, 
  4824, 4825, 4826, 4827, 4828, 4829, 4830, 4831, 
  4832, 4833, 4834, 4835, 4836, 4837, 4838, 4839, 
  0, 4840, 4841, 4842, 4843, 0, 0, 0, 
  0, 4844, 4845, 4846, 1113, 4847, 0, 4848, 
  4849, 4850, 4851, 4852, 4853, 4854, 4855, 4856, 
  4857, 4858, 4859, 4860, 4861, 4862, 4863, 4864, 
  4865, 4866, 4867, 4868, 4869, 4870, 4871, 4872, 
  4873, 4874, 4875, 4876, 4877, 4878, 4879, 4880, 
  4881, 4882, 4883, 4884, 4885, 4886, 4887, 4888, 
  4889, 4890, 4891, 4892, 4893, 4894, 4895, 4896, 
  4897, 4898, 4899, 4900, 4901, 4902, 4903, 4904, 
  4905, 4906, 4907, 4908, 4909, 4910, 4911, 4912, 
  4913, 4914, 4915, 4916, 4917, 4918, 4919, 4920, 
  4921, 4922, 4923, 4924, 4925, 4926, 4927, 4928, 
  4929, 4930, 4931, 4932, 4933, 4934, 4935, 4936, 
  4937, 4938, 4939, 4940, 4941, 4942, 4943, 4944, 
  4945, 4946, 4947, 4948, 4949, 4950, 4951, 4952, 
  4953, 4954, 4955, 4956, 4957, 4958, 4959, 4960, 
  4961, 4962, 4963, 4964, 4965, 4966, 4967, 4968, 
  4969, 4970, 4971, 4972, 4973, 4974, 4975, 4976, 
  4977, 4978, 4979, 4980, 4981, 4982, 0, 0, 
  91, 0, 4983, 4984, 4985, 4986, 4987, 4988, 
  4989, 4990, 4991, 4992, 4993, 4994, 4995, 4996, 
  4997, 4998, 4999, 5000, 5001, 5002, 5003, 5004, 
  5005, 5006, 5007, 5008, 5009, 5010, 5011, 5012, 
  5013, 5014, 5015, 5016, 5017, 5018, 5019, 5020, 
  5021, 5022, 5023, 5024, 5025, 5026, 5027, 5028, 
  5029, 5030, 5031, 5032, 5033, 5034, 5035, 5036, 
  5037, 5038, 5039, 5040, 5041, 5042, 5043, 5044, 
  5045, 5046, 5047, 5048, 5049, 5050, 5051, 5052, 
  5053, 5054, 5055, 5056, 5057, 5058, 5059, 5060, 
  5061, 5062, 5063, 5064, 5065, 5066, 5067, 5068, 
  5069, 5070, 5071, 5072, 5073, 5074, 5075, 5076, 
  5077, 5078, 5079, 5080, 5081, 5082, 5083, 5084, 
  5085, 5086, 5087, 5088, 5089, 5090, 5091, 5092, 
  5093, 5094, 5095, 5096, 5097, 5098, 5099, 5100, 
  5101, 5102, 5103, 5104, 5105, 5106, 5107, 5108, 
  5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116, 
  5117, 5118, 5119, 5120, 5121, 5122, 5123, 5124, 
  5125, 5126, 5127, 5128, 5129, 5130, 5131, 5132, 
  5133, 5134, 5135, 5136, 5137, 5138, 5139, 5140, 
  5141, 5142, 5143, 5144, 5145, 5146, 5147, 5148, 
  5149, 5150, 5151, 5152, 5153, 5154, 5155, 5156, 
  5157, 5158, 5159, 5160, 5161, 5162, 5163, 5164, 
  5165, 5166, 5167, 5168, 5169, 5170, 5171, 5172, 
  0, 0, 0, 5173, 5174, 5175, 5176, 5177, 
  5178, 0, 0, 5179, 5180, 5181, 5182, 5183, 
  5184, 0, 0, 5185, 5186, 5187, 5188, 5189, 
  5190, 0, 0, 5191, 5192, 5193, 0, 0, 
  0, 5194, 5195, 5196, 5197, 5198, 5199, 5200, 
  0, 5201, 5202, 5203, 5204, 5205, 5206, 5207, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 5208, 5208, 5208, 87, 87, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 0, 351, 351, 0, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 0, 0, 0, 0, 
  0, 1035, 15, 840, 0, 0, 0, 0, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 0, 0, 0, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 5209, 5209, 
  5209, 5209, 5209, 5209, 5209, 5209, 1214, 1214, 
  1214, 1214, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 1214, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 5210, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 1184, 1184, 1184, 1184, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 1321, 351, 351, 351, 351, 351, 
  351, 351, 351, 1321, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  1035, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 1035, 1321, 1321, 1321, 1321, 1321, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5211, 5212, 5213, 5214, 5215, 5216, 5217, 
  5218, 5219, 5220, 5221, 5222, 5223, 5224, 5225, 
  5226, 5227, 5228, 5229, 5230, 5231, 5232, 5233, 
  5234, 5235, 5236, 5237, 5238, 5239, 5240, 5241, 
  5242, 5243, 5244, 5245, 5246, 5247, 5248, 5249, 
  5250, 5251, 5252, 5253, 5254, 5255, 5256, 5257, 
  5258, 5259, 5260, 5261, 5262, 5263, 5264, 5265, 
  5266, 5267, 5268, 5269, 5270, 5271, 5272, 5273, 
  5274, 5275, 5276, 5277, 5278, 5279, 5280, 5281, 
  5282, 5283, 5284, 5285, 5286, 5287, 5288, 5289, 
  5290, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 0, 
  0, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 
  1174, 1174, 1174, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1100, 1100, 1100, 1100, 1100, 1100, 0, 
  0, 1100, 0, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 0, 
  1100, 1100, 0, 0, 0, 1100, 0, 0, 
  1100, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 5291, 
  5291, 5291, 5291, 0, 0, 0, 0, 0, 
  15, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 0, 0, 0, 0, 0, 
  1096, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1100, 1156, 1156, 1156, 0, 1156, 1156, 
  0, 0, 0, 0, 0, 1156, 576, 1156, 
  577, 1100, 1100, 1100, 1100, 0, 1100, 1100, 
  1100, 0, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 
  1100, 1100, 1100, 1100, 1100, 0, 0, 0, 
  0, 577, 2012, 576, 0, 0, 0, 0, 
  1243, 5291, 5291, 5291, 5291, 5291, 5291, 5291, 
  5291, 0, 0, 0, 0, 0, 0, 0, 
  0, 1096, 1096, 1096, 1096, 1096, 1096, 1096, 
  1096, 1096, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  351, 351, 351, 351, 351, 351, 351, 351, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 1321, 1321, 1321, 1321, 
  1321, 1321, 1321, 1321, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1035, 1035, 1035, 1035, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  0, 0, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  5292, 5293, 840, 840, 840, 840, 840, 5294, 
  5295, 5296, 5297, 5298, 5299, 5300, 5301, 5302, 
  566, 566, 566, 840, 840, 840, 5303, 5304, 
  5305, 5306, 5307, 5308, 91, 91, 91, 91, 
  91, 91, 91, 91, 553, 553, 553, 553, 
  553, 553, 553, 553, 840, 840, 540, 540, 
  540, 540, 540, 553, 553, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 540, 540, 540, 540, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 5309, 5310, 5311, 5312, 5313, 5314, 
  5315, 5316, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 840, 
  840, 840, 840, 840, 840, 840, 840, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 577, 577, 577, 87, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 1184, 1184, 1184, 1184, 1184, 
  1184, 1184, 1184, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 2040, 2015, 
  2058, 2042, 2043, 5318, 2022, 2025, 5319, 5320, 
  2026, 2045, 2028, 5321, 2030, 2031, 2032, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 2036, 5329, 
  5330, 5331, 2059, 2041, 5332, 2021, 0, 2051, 
  2060, 5333, 2027, 5334, 5335, 2046, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 0, 2015, 
  2058, 0, 0, 5318, 0, 0, 5319, 5320, 
  0, 0, 2028, 5321, 2030, 2031, 0, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 2036, 5329, 
  5330, 5331, 2059, 0, 5332, 0, 2023, 2051, 
  2060, 5333, 2027, 5334, 5335, 0, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 2040, 0, 
  2058, 2042, 2043, 5318, 0, 0, 5319, 5320, 
  2026, 2045, 2028, 5321, 2030, 2031, 0, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 0, 5329, 
  5330, 5331, 2059, 2041, 5332, 2021, 2023, 2051, 
  2060, 5333, 2027, 5334, 5335, 2046, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 0, 2058, 2042, 2043, 5318, 
  0, 2025, 5319, 5320, 2026, 2045, 0, 5321, 
  0, 0, 0, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 0, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 2040, 2015, 
  2058, 2042, 2043, 5318, 2022, 2025, 5319, 5320, 
  2026, 2045, 2028, 5321, 2030, 2031, 2032, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 2036, 5329, 
  5330, 5331, 2059, 2041, 5332, 2021, 2023, 2051, 
  2060, 5333, 2027, 5334, 5335, 2046, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 2040, 2015, 
  2058, 2042, 2043, 5318, 2022, 2025, 5319, 5320, 
  2026, 2045, 2028, 5321, 2030, 2031, 2032, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 2036, 5329, 
  5330, 5331, 2059, 2041, 5332, 2021, 2023, 2051, 
  2060, 5333, 2027, 5334, 5335, 2046, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5317, 2040, 2015, 
  2058, 2042, 2043, 5318, 2022, 2025, 5319, 5320, 
  2026, 2045, 2028, 5321, 2030, 2031, 2032, 5322, 
  5323, 5324, 5325, 5326, 5327, 5328, 2036, 5329, 
  5330, 5331, 2059, 2041, 5332, 2021, 2023, 2051, 
  2060, 5333, 2027, 5334, 5335, 2046, 5336, 5337, 
  5338, 5339, 5340, 5341, 5342, 5343, 5344, 5345, 
  5346, 5317, 2040, 2015, 2058, 2042, 2043, 5318, 
  2022, 2025, 5319, 5320, 2026, 2045, 2028, 5321, 
  2030, 2031, 2032, 5322, 5323, 5324, 5325, 5326, 
  5327, 5328, 2036, 5329, 5330, 5331, 2059, 2041, 
  5332, 2021, 2023, 2051, 2060, 5333, 2027, 5334, 
  5335, 2046, 5336, 5337, 5338, 5339, 5340, 5341, 
  5342, 5343, 5344, 5345, 5346, 5347, 5348, 0, 
  0, 5349, 5350, 2055, 5351, 5352, 5353, 5354, 
  5355, 5356, 5357, 5358, 5359, 5360, 5361, 5362, 
  2056, 5363, 5364, 5365, 5366, 5367, 5368, 5369, 
  5370, 5371, 5372, 5373, 5374, 2054, 5375, 5376, 
  5377, 5378, 5379, 5380, 5381, 5382, 5383, 5384, 
  5385, 5386, 2053, 5387, 5388, 5389, 5390, 5391, 
  5392, 5393, 5394, 5395, 5396, 5397, 5398, 5399, 
  5400, 5401, 5402, 5349, 5350, 2055, 5351, 5352, 
  5353, 5354, 5355, 5356, 5357, 5358, 5359, 5360, 
  5361, 5362, 2056, 5363, 5364, 5365, 5366, 5367, 
  5368, 5369, 5370, 5371, 5372, 5373, 5374, 2054, 
  5375, 5376, 5377, 5378, 5379, 5380, 5381, 5382, 
  5383, 5384, 5385, 5386, 2053, 5387, 5388, 5389, 
  5390, 5391, 5392, 5393, 5394, 5395, 5396, 5397, 
  5398, 5399, 5400, 5401, 5402, 5349, 5350, 2055, 
  5351, 5352, 5353, 5354, 5355, 5356, 5357, 5358, 
  5359, 5360, 5361, 5362, 2056, 5363, 5364, 5365, 
  5366, 5367, 5368, 5369, 5370, 5371, 5372, 5373, 
  5374, 2054, 5375, 5376, 5377, 5378, 5379, 5380, 
  5381, 5382, 5383, 5384, 5385, 5386, 2053, 5387, 
  5388, 5389, 5390, 5391, 5392, 5393, 5394, 5395, 
  5396, 5397, 5398, 5399, 5400, 5401, 5402, 5349, 
  5350, 2055, 5351, 5352, 5353, 5354, 5355, 5356, 
  5357, 5358, 5359, 5360, 5361, 5362, 2056, 5363, 
  5364, 5365, 5366, 5367, 5368, 5369, 5370, 5371, 
  5372, 5373, 5374, 2054, 5375, 5376, 5377, 5378, 
  5379, 5380, 5381, 5382, 5383, 5384, 5385, 5386, 
  2053, 5387, 5388, 5389, 5390, 5391, 5392, 5393, 
  5394, 5395, 5396, 5397, 5398, 5399, 5400, 5401, 
  5402, 5349, 5350, 2055, 5351, 5352, 5353, 5354, 
  5355, 5356, 5357, 5358, 5359, 5360, 5361, 5362, 
  2056, 5363, 5364, 5365, 5366, 5367, 5368, 5369, 
  5370, 5371, 5372, 5373, 5374, 2054, 5375, 5376, 
  5377, 5378, 5379, 5380, 5381, 5382, 5383, 5384, 
  5385, 5386, 2053, 5387, 5388, 5389, 5390, 5391, 
  5392, 5393, 5394, 5395, 5396, 5397, 5398, 5399, 
  5400, 5401, 5402, 5403, 5404, 0, 0, 5405, 
  5406, 5407, 5408, 5409, 5410, 5411, 5412, 5413, 
  5414, 5405, 5406, 5407, 5408, 5409, 5410, 5411, 
  5412, 5413, 5414, 5405, 5406, 5407, 5408, 5409, 
  5410, 5411, 5412, 5413, 5414, 5405, 5406, 5407, 
  5408, 5409, 5410, 5411, 5412, 5413, 5414, 5405, 
  5406, 5407, 5408, 5409, 5410, 5411, 5412, 5413, 
  5414, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 0, 0, 
  0, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 87, 87, 87, 
  87, 87, 87, 87, 87, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 5415, 5416, 5417, 5418, 5419, 4000, 5420, 
  5421, 5422, 5423, 4001, 5424, 5425, 5426, 4002, 
  5427, 5428, 5429, 5430, 5431, 5432, 5433, 5434, 
  5435, 5436, 5437, 5438, 4057, 5439, 5440, 5441, 
  5442, 5443, 5444, 5445, 5446, 5447, 4062, 4003, 
  4004, 4063, 5448, 5449, 3813, 5450, 4005, 5451, 
  5452, 5453, 5454, 5454, 5454, 5455, 5456, 5457, 
  5458, 5459, 5460, 5461, 5462, 5463, 5464, 5465, 
  5466, 5467, 5468, 5469, 5470, 5471, 5472, 5472, 
  4065, 5473, 5474, 5475, 5476, 4007, 5477, 5478, 
  5479, 3966, 5480, 5481, 5482, 5483, 5484, 5485, 
  5486, 5487, 5488, 5489, 5490, 5491, 5492, 5493, 
  5494, 5495, 5496, 5497, 5498, 5499, 5500, 5501, 
  5502, 5503, 5504, 5505, 5505, 5506, 5507, 5508, 
  3809, 5509, 5510, 5511, 5512, 5513, 5514, 5515, 
  5516, 4012, 5517, 5518, 5519, 5520, 5521, 5522, 
  5523, 5524, 5525, 5526, 5527, 5528, 5529, 5530, 
  5531, 5532, 5533, 5534, 5535, 5536, 5537, 3755, 
  5538, 5539, 5540, 5540, 5541, 5542, 5542, 5543, 
  5544, 5545, 5546, 5547, 5548, 5549, 5550, 5551, 
  5552, 5553, 5554, 5555, 4013, 5556, 5557, 5558, 
  5559, 4077, 5559, 5560, 4015, 5561, 5562, 5563, 
  5564, 4016, 3728, 5565, 5566, 5567, 5568, 5569, 
  5570, 5571, 5572, 5573, 5574, 5575, 5576, 5577, 
  5578, 5579, 5580, 5581, 5582, 5583, 5584, 5585, 
  5586, 4017, 5587, 5588, 5589, 5590, 5591, 5592, 
  4019, 5593, 5594, 5595, 5596, 5597, 5598, 5599, 
  5600, 3756, 4085, 5601, 5602, 5603, 5604, 5605, 
  5606, 5607, 5608, 4020, 5609, 5610, 5611, 5612, 
  4128, 5613, 5614, 5615, 5616, 5617, 5618, 5619, 
  5620, 5621, 5622, 5623, 5624, 5625, 3826, 5626, 
  5627, 5628, 5629, 5630, 5631, 5632, 5633, 5634, 
  5635, 5636, 4021, 3913, 5637, 5638, 5639, 5640, 
  5641, 5642, 5643, 5644, 4089, 5645, 5646, 5647, 
  5648, 5649, 5650, 5651, 5652, 4090, 5653, 5654, 
  5655, 5656, 5657, 5658, 5659, 5660, 5661, 5662, 
  5663, 5664, 4092, 5665, 5666, 5667, 5668, 5669, 
  5670, 5671, 5672, 5673, 5674, 5675, 5675, 5676, 
  5677, 4094, 5678, 5679, 5680, 5681, 5682, 5683, 
  5684, 3812, 5685, 5686, 5687, 5688, 5689, 5690, 
  5691, 4100, 5692, 5693, 5694, 5695, 5696, 5697, 
  5697, 4101, 4130, 5698, 5699, 5700, 5701, 5702, 
  3774, 4103, 5703, 5704, 4032, 5705, 5706, 3988, 
  5707, 5708, 4036, 5709, 5710, 5711, 5712, 5712, 
  5713, 5714, 5715, 5716, 5717, 5718, 5719, 5720, 
  5721, 5722, 5723, 5724, 5725, 5726, 5727, 5728, 
  5729, 5730, 5731, 5732, 5733, 5734, 5735, 5736, 
  5737, 5738, 5739, 4042, 5740, 5741, 5742, 5743, 
  5744, 5745, 5746, 5747, 5748, 5749, 5750, 5751, 
  5752, 5753, 5754, 5755, 5541, 5756, 5757, 5758, 
  5759, 5760, 5761, 5762, 5763, 5764, 5765, 5766, 
  5767, 3830, 5768, 5769, 5770, 5771, 5772, 5773, 
  4045, 5774, 5775, 5776, 5777, 5778, 5779, 5780, 
  5781, 5782, 5783, 5784, 5785, 5786, 5787, 5788, 
  5789, 5790, 5791, 5792, 5793, 3769, 5794, 5795, 
  5796, 5797, 5798, 5799, 4110, 5800, 5801, 5802, 
  5803, 5804, 5805, 5806, 5807, 5808, 5809, 5810, 
  5811, 5812, 5813, 5814, 5815, 5816, 5817, 5818, 
  5819, 4115, 4116, 5820, 5821, 5822, 5823, 5824, 
  5825, 5826, 5827, 5828, 5829, 5830, 5831, 5832, 
  4117, 5833, 5834, 5835, 5836, 5837, 5838, 5839, 
  5840, 5841, 5842, 5843, 5844, 5845, 5846, 5847, 
  5848, 5849, 5850, 5851, 5852, 5853, 5854, 5855, 
  5856, 5857, 5858, 5859, 5860, 5861, 5862, 4123, 
  4123, 5863, 5864, 5865, 5866, 5867, 5868, 5869, 
  5870, 5871, 5872, 4124, 5873, 5874, 5875, 5876, 
  5877, 5878, 5879, 5880, 5881, 5882, 5883, 5884, 
  5885, 5886, 5887, 5888, 5889, 5890, 5891, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 91, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 91, 91, 91, 91, 91, 91, 91, 
  91, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 574, 574, 574, 574, 574, 574, 574, 
  574, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 3715, 
  3715, 3715, 3715, 3715, 3715, 3715, 3715, 0, 
  0, };

const utf8proc_property_t utf8proc_properties[] = {
  {0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_BN, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, true, true, false, false, true, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_BN, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_S, 0, 0, 0, 0, 0, -1, -1, 0, 0, 4,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, 0, 0, 0, 0, -1, -1, 0, 2, 2,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_S, 0, 0, 0, 0, 0, -1, -1, 0, 3, 4,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_WS, 0, 0, 0, 0, 0, -1, -1, 0, 3, 4,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, 0, 0, 0, 0, -1, -1, 0, 1, 1,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_S, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, 0, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 8, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, 0, 0, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ES, 0, 0, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, 0, 0, 0, 0, 0, -1, -1, 0, 8, 9,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, 0, 0, 0, 0, 0, -1, -1, 0, 9, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, 0, 0, 0, 0, 0, -1, -1, 0, 6, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17580, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17400, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17640, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 97, 0, 0, -1, 97, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 98, 0, 8640, -1, 98, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 99, 0, 60, -1, 99, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 100, 0, 960, -1, 100, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 101, 0, 120, -1, 101, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 102, 0, 9120, -1, 102, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 103, 0, 1080, -1, 103, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 104, 0, 1200, -1, 104, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 105, 0, 180, -1, 105, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 106, 0, 1320, -1, 106, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 107, 0, 1440, -1, 107, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 108, 0, 1560, -1, 108, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 109, 0, 9480, -1, 109, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 110, 0, 240, -1, 110, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 111, 0, 300, -1, 111, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 112, 0, 9720, -1, 112, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 113, 0, -1, -1, 113, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 114, 0, 1680, -1, 114, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 115, 0, 1800, -1, 115, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 116, 0, 1920, -1, 116, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 117, 0, 360, -1, 117, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 118, 0, 10560, -1, 118, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 119, 0, 2040, -1, 119, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 120, 0, 10680, -1, 120, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 121, 0, 420, -1, 121, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 122, 0, 2160, -1, 122, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_PC, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 10, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 65, 0, 65, 480, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66, 0, 66, 8700, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 67, 0, 67, 540, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 68, 0, 68, 1020, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 69, 0, 69, 600, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 70, 0, 70, 9180, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 71, 0, 71, 1140, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 72, 0, 72, 1260, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 73, 0, 73, 660, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 74, 0, 74, 1380, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 75, 0, 75, 1500, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 76, 0, 76, 1620, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 77, 0, 77, 9540, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 78, 0, 78, 720, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 79, 0, 79, 780, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 80, 0, 80, 9780, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 81, 0, 81, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 82, 0, 82, 1740, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 83, 0, 83, 1860, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 84, 0, 84, 1980, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 85, 0, 85, 840, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 86, 0, 86, 10620, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 87, 0, 87, 2100, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 88, 0, 88, 10740, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 89, 0, 89, 900, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 90, 0, 90, 2220, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CC, 0, UTF8PROC_BIDI_CLASS_B, 0, 0, 0, 0, 0, -1, -1, 0, 3, 3,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_NOBREAK, 32, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -2, 0, 0, 0, 3600, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 97, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PI, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_BN, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -5, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ET, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ET, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 50, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 51, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -8, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 956, 924, 0, 924, -1, -1, 956, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 6, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -11, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 49, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 111, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PF, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -14, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -18, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -22, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -26, 0, 224, 0, -1, -1, 224, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -29, 0, 225, 0, -1, -1, 225, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -32, 0, 226, 0, 10860, -1, 226, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -35, 0, 227, 0, -1, -1, 227, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -38, 0, 228, 0, 2400, -1, 228, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -41, 0, 229, 0, 3000, -1, 229, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 230, 0, 2640, -1, 230, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -44, 0, 231, 0, 8760, -1, 231, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -47, 0, 232, 0, -1, -1, 232, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -50, 0, 233, 0, -1, -1, 233, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -53, 0, 234, 0, 11220, -1, 234, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -56, 0, 235, 0, -1, -1, 235, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -59, 0, 236, 0, -1, -1, 236, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -62, 0, 237, 0, -1, -1, 237, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -65, 0, 238, 0, -1, -1, 238, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -68, 0, 239, 0, 9240, -1, 239, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 240, 0, -1, -1, 240, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -71, 0, 241, 0, -1, -1, 241, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -74, 0, 242, 0, -1, -1, 242, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -77, 0, 243, 0, -1, -1, 243, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -80, 0, 244, 0, 11460, -1, 244, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -83, 0, 245, 0, 3360, -1, 245, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -86, 0, 246, 0, 3240, -1, 246, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 248, 0, 3120, -1, 248, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -89, 0, 249, 0, -1, -1, 249, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -92, 0, 250, 0, -1, -1, 250, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -95, 0, 251, 0, -1, -1, 251, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -98, 0, 252, 0, 2280, -1, 252, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -101, 0, 253, 0, -1, -1, 253, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 254, 0, -1, -1, 254, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, -104, -107, -109, -1, -1, -112, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -115, 192, 0, 192, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -118, 193, 0, 193, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -121, 194, 0, 194, 10920, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -124, 195, 0, 195, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -127, 196, 0, 196, 2460, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -130, 197, 0, 197, 3060, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 198, 0, 198, 2700, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -133, 199, 0, 199, 8820, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -136, 200, 0, 200, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -139, 201, 0, 201, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -142, 202, 0, 202, 11280, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -145, 203, 0, 203, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -148, 204, 0, 204, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -151, 205, 0, 205, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -154, 206, 0, 206, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -157, 207, 0, 207, 9300, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 208, 0, 208, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -160, 209, 0, 209, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -163, 210, 0, 210, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -166, 211, 0, 211, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -169, 212, 0, 212, 11520, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -172, 213, 0, 213, 3420, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -175, 214, 0, 214, 3300, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 216, 0, 216, 3180, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -178, 217, 0, 217, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -181, 218, 0, 218, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -184, 219, 0, 219, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -187, 220, 0, 220, 2340, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -190, 221, 0, 221, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 222, 0, 222, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -193, 376, 0, 376, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -196, 0, 257, 0, -1, -1, 257, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -199, 256, 0, 256, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -202, 0, 259, 0, 11100, -1, 259, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -205, 258, 0, 258, 11160, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -208, 0, 261, 0, -1, -1, 261, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -211, 260, 0, 260, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -214, 0, 263, 0, -1, -1, 263, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -217, 262, 0, 262, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -220, 0, 265, 0, -1, -1, 265, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -223, 264, 0, 264, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -226, 0, 267, 0, -1, -1, 267, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -229, 266, 0, 266, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -232, 0, 269, 0, -1, -1, 269, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -235, 268, 0, 268, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -238, 0, 271, 0, -1, -1, 271, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -241, 270, 0, 270, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 273, 0, -1, -1, 273, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 272, 0, 272, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -244, 0, 275, 0, 8880, -1, 275, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -247, 274, 0, 274, 8940, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -250, 0, 277, 0, -1, -1, 277, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -253, 276, 0, 276, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -256, 0, 279, 0, -1, -1, 279, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -259, 278, 0, 278, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -262, 0, 281, 0, -1, -1, 281, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -265, 280, 0, 280, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -268, 0, 283, 0, -1, -1, 283, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -271, 282, 0, 282, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -274, 0, 285, 0, -1, -1, 285, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -277, 284, 0, 284, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -280, 0, 287, 0, -1, -1, 287, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -283, 286, 0, 286, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -286, 0, 289, 0, -1, -1, 289, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -289, 288, 0, 288, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -292, 0, 291, 0, -1, -1, 291, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -295, 290, 0, 290, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -298, 0, 293, 0, -1, -1, 293, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -301, 292, 0, 292, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 295, 0, -1, -1, 295, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 294, 0, 294, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -304, 0, 297, 0, -1, -1, 297, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -307, 296, 0, 296, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -310, 0, 299, 0, -1, -1, 299, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -313, 298, 0, 298, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -316, 0, 301, 0, -1, -1, 301, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -319, 300, 0, 300, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -322, 0, 303, 0, -1, -1, 303, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -325, 302, 0, 302, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -328, -331, -333, -331, -1, -1, -333, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 73, 0, 73, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -336, 0, 307, 0, -1, -1, 307, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -339, 306, 0, 306, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -342, 0, 309, 0, -1, -1, 309, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -345, 308, 0, 308, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -348, 0, 311, 0, -1, -1, 311, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -351, 310, 0, 310, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -354, 0, 314, 0, -1, -1, 314, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -357, 313, 0, 313, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -360, 0, 316, 0, -1, -1, 316, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -363, 315, 0, 315, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -366, 0, 318, 0, -1, -1, 318, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -369, 317, 0, 317, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -372, 0, 320, 0, -1, -1, 320, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -375, 319, 0, 319, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 322, 0, -1, -1, 322, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 321, 0, 321, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -378, 0, 324, 0, -1, -1, 324, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -381, 323, 0, 323, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -384, 0, 326, 0, -1, -1, 326, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -387, 325, 0, 325, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -390, 0, 328, 0, -1, -1, 328, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -393, 327, 0, 327, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -396, -399, -402, -399, -1, -1, -396, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 331, 0, -1, -1, 331, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 330, 0, 330, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -404, 0, 333, 0, 9600, -1, 333, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -407, 332, 0, 332, 9660, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -410, 0, 335, 0, -1, -1, 335, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -413, 334, 0, 334, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -416, 0, 337, 0, -1, -1, 337, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -419, 336, 0, 336, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 339, 0, -1, -1, 339, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 338, 0, 338, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -422, 0, 341, 0, -1, -1, 341, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -425, 340, 0, 340, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -428, 0, 343, 0, -1, -1, 343, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -431, 342, 0, 342, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -434, 0, 345, 0, -1, -1, 345, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -437, 344, 0, 344, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -440, 0, 347, 0, 9960, -1, 347, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -443, 346, 0, 346, 10020, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -446, 0, 349, 0, -1, -1, 349, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -449, 348, 0, 348, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -452, 0, 351, 0, -1, -1, 351, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -455, 350, 0, 350, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -458, 0, 353, 0, 10080, -1, 353, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -461, 352, 0, 352, 10140, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -464, 0, 355, 0, -1, -1, 355, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -467, 354, 0, 354, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -470, 0, 357, 0, -1, -1, 357, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -473, 356, 0, 356, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 359, 0, -1, -1, 359, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 358, 0, 358, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -476, 0, 361, 0, 10320, -1, 361, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -479, 360, 0, 360, 10380, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -482, 0, 363, 0, 10440, -1, 363, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -485, 362, 0, 362, 10500, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -488, 0, 365, 0, -1, -1, 365, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -491, 364, 0, 364, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -494, 0, 367, 0, -1, -1, 367, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -497, 366, 0, 366, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -500, 0, 369, 0, -1, -1, 369, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -503, 368, 0, 368, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -506, 0, 371, 0, -1, -1, 371, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -509, 370, 0, 370, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -512, 0, 373, 0, -1, -1, 373, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -515, 372, 0, 372, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -518, 0, 375, 0, -1, -1, 375, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -521, 374, 0, 374, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -524, 0, 255, 0, -1, -1, 255, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -527, 0, 378, 0, -1, -1, 378, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -530, 377, 0, 377, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -533, 0, 380, 0, -1, -1, 380, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -536, 379, 0, 379, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -539, 0, 382, 0, -1, -1, 382, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -542, 381, 0, 381, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 115, 83, 0, 83, 10800, -1, 115, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 579, 0, 579, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 595, 0, -1, -1, 595, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 387, 0, -1, -1, 387, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 386, 0, 386, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 389, 0, -1, -1, 389, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 388, 0, 388, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 596, 0, -1, -1, 596, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 392, 0, -1, -1, 392, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 391, 0, 391, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 598, 0, -1, -1, 598, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 599, 0, -1, -1, 599, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 396, 0, -1, -1, 396, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 395, 0, 395, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 477, 0, -1, -1, 477, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 601, 0, -1, -1, 601, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 603, 0, -1, -1, 603, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 402, 0, -1, -1, 402, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 401, 0, 401, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 608, 0, -1, -1, 608, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 611, 0, -1, -1, 611, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 502, 0, 502, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 617, 0, -1, -1, 617, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 616, 0, -1, -1, 616, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 409, 0, -1, -1, 409, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 408, 0, 408, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 573, 0, 573, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 623, 0, -1, -1, 623, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 626, 0, -1, -1, 626, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 544, 0, 544, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 629, 0, -1, -1, 629, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -545, 0, 417, 0, 11700, -1, 417, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -548, 416, 0, 416, 11760, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 419, 0, -1, -1, 419, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 418, 0, 418, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 421, 0, -1, -1, 421, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 420, 0, 420, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 640, 0, -1, -1, 640, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 424, 0, -1, -1, 424, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 423, 0, 423, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 643, 0, -1, -1, 643, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 429, 0, -1, -1, 429, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 428, 0, 428, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 648, 0, -1, -1, 648, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -551, 0, 432, 0, 11820, -1, 432, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -554, 431, 0, 431, 11880, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 650, 0, -1, -1, 650, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 651, 0, -1, -1, 651, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 436, 0, -1, -1, 436, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 435, 0, 435, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 438, 0, -1, -1, 438, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 437, 0, 437, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 658, 0, 2880, -1, 658, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 441, 0, -1, -1, 441, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 440, 0, 440, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 445, 0, -1, -1, 445, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 444, 0, 444, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 503, 0, 503, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -557, 0, 454, 453, -1, -1, 454, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -560, 452, 454, 453, -1, -1, 454, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -563, 452, 0, 453, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -566, 0, 457, 456, -1, -1, 457, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -569, 455, 457, 456, -1, -1, 457, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -572, 455, 0, 456, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -575, 0, 460, 459, -1, -1, 460, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -578, 458, 460, 459, -1, -1, 460, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -581, 458, 0, 459, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -584, 0, 462, 0, -1, -1, 462, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -587, 461, 0, 461, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -590, 0, 464, 0, -1, -1, 464, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -593, 463, 0, 463, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -596, 0, 466, 0, -1, -1, 466, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -599, 465, 0, 465, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -602, 0, 468, 0, -1, -1, 468, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -605, 467, 0, 467, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -608, 0, 470, 0, -1, -1, 470, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -611, 469, 0, 469, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -614, 0, 472, 0, -1, -1, 472, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -617, 471, 0, 471, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -620, 0, 474, 0, -1, -1, 474, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -623, 473, 0, 473, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -626, 0, 476, 0, -1, -1, 476, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -629, 475, 0, 475, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 398, 0, 398, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -632, 0, 479, 0, -1, -1, 479, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -635, 478, 0, 478, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -638, 0, 481, 0, -1, -1, 481, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -641, 480, 0, 480, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -644, 0, 483, 0, -1, -1, 483, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -647, 482, 0, 482, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 485, 0, -1, -1, 485, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 484, 0, 484, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -650, 0, 487, 0, -1, -1, 487, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -653, 486, 0, 486, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -656, 0, 489, 0, -1, -1, 489, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -659, 488, 0, 488, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -662, 0, 491, 0, 2760, -1, 491, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -665, 490, 0, 490, 2820, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -668, 0, 493, 0, -1, -1, 493, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -671, 492, 0, 492, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -674, 0, 495, 0, -1, -1, 495, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -677, 494, 0, 494, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -680, -683, -686, -683, -1, -1, -680, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -688, 0, 499, 498, -1, -1, 499, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -691, 497, 499, 498, -1, -1, 499, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -694, 497, 0, 498, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -697, 0, 501, 0, -1, -1, 501, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -700, 500, 0, 500, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 405, 0, -1, -1, 405, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 447, 0, -1, -1, 447, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -703, 0, 505, 0, -1, -1, 505, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -706, 504, 0, 504, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -709, 0, 507, 0, -1, -1, 507, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -712, 506, 0, 506, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -715, 0, 509, 0, -1, -1, 509, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -718, 508, 0, 508, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -721, 0, 511, 0, -1, -1, 511, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -724, 510, 0, 510, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -727, 0, 513, 0, -1, -1, 513, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -730, 512, 0, 512, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -733, 0, 515, 0, -1, -1, 515, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -736, 514, 0, 514, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -739, 0, 517, 0, -1, -1, 517, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -742, 516, 0, 516, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -745, 0, 519, 0, -1, -1, 519, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -748, 518, 0, 518, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -751, 0, 521, 0, -1, -1, 521, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -754, 520, 0, 520, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -757, 0, 523, 0, -1, -1, 523, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -760, 522, 0, 522, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -763, 0, 525, 0, -1, -1, 525, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -766, 524, 0, 524, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -769, 0, 527, 0, -1, -1, 527, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -772, 526, 0, 526, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -775, 0, 529, 0, -1, -1, 529, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -778, 528, 0, 528, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -781, 0, 531, 0, -1, -1, 531, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -784, 530, 0, 530, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -787, 0, 533, 0, -1, -1, 533, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -790, 532, 0, 532, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -793, 0, 535, 0, -1, -1, 535, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -796, 534, 0, 534, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -799, 0, 537, 0, -1, -1, 537, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -802, 536, 0, 536, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -805, 0, 539, 0, -1, -1, 539, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -808, 538, 0, 538, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 541, 0, -1, -1, 541, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 540, 0, 540, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -811, 0, 543, 0, -1, -1, 543, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -814, 542, 0, 542, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 414, 0, -1, -1, 414, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 547, 0, -1, -1, 547, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 546, 0, 546, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 549, 0, -1, -1, 549, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 548, 0, 548, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -817, 0, 551, 0, 2520, -1, 551, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -820, 550, 0, 550, 2580, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -823, 0, 553, 0, 9000, -1, 553, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -826, 552, 0, 552, 9060, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -829, 0, 555, 0, -1, -1, 555, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -832, 554, 0, 554, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -835, 0, 557, 0, -1, -1, 557, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -838, 556, 0, 556, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -841, 0, 559, 0, 3480, -1, 559, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -844, 558, 0, 558, 3540, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -847, 0, 561, 0, -1, -1, 561, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -850, 560, 0, 560, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -853, 0, 563, 0, -1, -1, 563, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -856, 562, 0, 562, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11365, 0, -1, -1, 11365, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 572, 0, -1, -1, 572, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 571, 0, 571, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 410, 0, -1, -1, 410, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11366, 0, -1, -1, 11366, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 578, 0, -1, -1, 578, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 577, 0, 577, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 384, 0, -1, -1, 384, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 649, 0, -1, -1, 649, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 652, 0, -1, -1, 652, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 583, 0, -1, -1, 583, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 582, 0, 582, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 585, 0, -1, -1, 585, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 584, 0, 584, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 587, 0, -1, -1, 587, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 586, 0, 586, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 589, 0, -1, -1, 589, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 588, 0, 588, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 591, 0, -1, -1, 591, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 590, 0, 590, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11375, 0, 11375, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11373, 0, 11373, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 385, 0, 385, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 390, 0, 390, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 393, 0, 393, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 394, 0, 394, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 399, 0, 399, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 400, 0, 400, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 403, 0, 403, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 404, 0, 404, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 407, 0, 407, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 406, 0, 406, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11362, 0, 11362, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 412, 0, 412, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11374, 0, 11374, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 413, 0, 413, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 415, 0, 415, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11364, 0, 11364, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 422, 0, 422, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 425, 0, 425, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 430, 0, 430, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 580, 0, 580, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 433, 0, 433, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 434, 0, 434, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 581, 0, 581, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 439, 0, 439, 2940, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 104, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 614, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 106, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 114, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 633, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 635, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 641, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 119, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 121, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -859, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -862, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -865, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -868, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -871, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -874, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 611, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 108, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 115, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 120, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 661, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 0, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 2, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 3, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 7, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 8, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 10, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 4, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 46, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 5, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 12, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 11, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 14, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 15, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 47, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 48, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 232, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 216, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 13, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 40, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 45, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 39, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 16, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 6, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 9, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 42, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 44, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 43, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 41, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 1, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 1, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 51, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 768, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 769, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 49, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 787, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, -877, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 240, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 921, 0, 921, -1, 50, 953, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, true, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 232, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 233, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 234, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 233, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 881, 0, -1, -1, 881, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 880, 0, 880, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 883, 0, -1, -1, 883, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 882, 0, 882, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 697, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 887, 0, -1, -1, 887, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 886, 0, 886, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -880, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1021, 0, 1021, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1022, 0, 1022, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1023, 0, 1023, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 59, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -883, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -886, 0, 940, 0, -1, -1, 940, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 183, 0, 0, 0, -1, -1, 0, 6, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -889, 0, 941, 0, -1, -1, 941, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -892, 0, 942, 0, -1, -1, 942, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -895, 0, 943, 0, -1, -1, 943, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -898, 0, 972, 0, -1, -1, 972, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -901, 0, 973, 0, -1, -1, 973, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -904, 0, 974, 0, -1, -1, 974, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -907, -910, -914, -910, -1, -1, -916, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 945, 0, 3660, -1, 945, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 946, 0, -1, -1, 946, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 947, 0, -1, -1, 947, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 948, 0, -1, -1, 948, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 949, 0, 3720, -1, 949, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 950, 0, -1, -1, 950, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 951, 0, 3780, -1, 951, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 952, 0, -1, -1, 952, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 953, 0, 3840, -1, 953, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 954, 0, -1, -1, 954, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 955, 0, -1, -1, 955, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 956, 0, -1, -1, 956, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 957, 0, -1, -1, 957, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 958, 0, -1, -1, 958, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 959, 0, 3900, -1, 959, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 960, 0, -1, -1, 960, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 961, 0, 16260, -1, 961, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 963, 0, -1, -1, 963, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 964, 0, -1, -1, 964, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 965, 0, 3960, -1, 965, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 966, 0, -1, -1, 966, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 967, 0, -1, -1, 967, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 968, 0, -1, -1, 968, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 969, 0, 4020, -1, 969, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -920, 0, 970, 0, -1, -1, 970, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -923, 0, 971, 0, -1, -1, 971, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -926, 902, 0, 902, 15780, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -929, 904, 0, 904, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -932, 905, 0, 905, 15960, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -935, 906, 0, 906, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -938, -941, -945, -941, -1, -1, -947, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 913, 0, 913, 4140, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 914, 0, 914, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 915, 0, 915, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 916, 0, 916, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 917, 0, 917, 4200, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 918, 0, 918, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 919, 0, 919, 4260, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 920, 0, 920, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 921, 0, 921, 4320, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 922, 0, 922, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 923, 0, 923, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 924, 0, 924, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 925, 0, 925, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 926, 0, 926, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 927, 0, 927, 4500, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 928, 0, 928, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 929, 0, 929, 16200, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 931, 0, 931, -1, -1, 963, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 931, 0, 931, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 932, 0, 932, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 933, 0, 933, 4440, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 934, 0, 934, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 935, 0, 935, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 936, 0, 936, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 937, 0, 937, 4560, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -951, 938, 0, 938, 4080, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -954, 939, 0, 939, 4380, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -957, 908, 0, 908, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -960, 910, 0, 910, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -963, 911, 0, 911, 16380, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 983, 0, -1, -1, 983, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 946, 914, 0, 914, -1, -1, 946, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 952, 920, 0, 920, -1, -1, 952, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 933, 0, 0, 0, 4620, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -966, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -969, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 966, 934, 0, 934, -1, -1, 966, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 960, 928, 0, 928, -1, -1, 960, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 975, 0, 975, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 985, 0, -1, -1, 985, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 984, 0, 984, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 987, 0, -1, -1, 987, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 986, 0, 986, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 989, 0, -1, -1, 989, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 988, 0, 988, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 991, 0, -1, -1, 991, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 990, 0, 990, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 993, 0, -1, -1, 993, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 992, 0, 992, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 995, 0, -1, -1, 995, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 994, 0, 994, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 997, 0, -1, -1, 997, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 996, 0, 996, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 999, 0, -1, -1, 999, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 998, 0, 998, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1001, 0, -1, -1, 1001, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1000, 0, 1000, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1003, 0, -1, -1, 1003, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1002, 0, 1002, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1005, 0, -1, -1, 1005, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1004, 0, 1004, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1007, 0, -1, -1, 1007, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1006, 0, 1006, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 954, 922, 0, 922, -1, -1, 954, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 961, 929, 0, 929, -1, -1, 961, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 962, 1017, 0, 1017, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 920, 0, 952, 0, -1, -1, 952, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 949, 917, 0, 917, -1, -1, 949, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1016, 0, -1, -1, 1016, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1015, 0, 1015, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 931, 0, 1010, 0, -1, -1, 1010, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1019, 0, -1, -1, 1019, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1018, 0, 1018, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 891, 0, -1, -1, 891, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 892, 0, -1, -1, 892, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 893, 0, -1, -1, 893, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -972, 0, 1104, 0, -1, -1, 1104, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -975, 0, 1105, 0, -1, -1, 1105, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1106, 0, -1, -1, 1106, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -978, 0, 1107, 0, -1, -1, 1107, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1108, 0, -1, -1, 1108, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1109, 0, -1, -1, 1109, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1110, 0, 4800, -1, 1110, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -981, 0, 1111, 0, -1, -1, 1111, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1112, 0, -1, -1, 1112, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1113, 0, -1, -1, 1113, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1114, 0, -1, -1, 1114, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1115, 0, -1, -1, 1115, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -984, 0, 1116, 0, -1, -1, 1116, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -987, 0, 1117, 0, -1, -1, 1117, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -990, 0, 1118, 0, -1, -1, 1118, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1119, 0, -1, -1, 1119, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1072, 0, 5640, -1, 1072, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1073, 0, -1, -1, 1073, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1074, 0, -1, -1, 1074, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1075, 0, 4740, -1, 1075, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1076, 0, -1, -1, 1076, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1077, 0, 4680, -1, 1077, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1078, 0, 5520, -1, 1078, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1079, 0, 5880, -1, 1079, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1080, 0, 4920, -1, 1080, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -993, 0, 1081, 0, -1, -1, 1081, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1082, 0, 4860, -1, 1082, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1083, 0, -1, -1, 1083, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1084, 0, -1, -1, 1084, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1085, 0, -1, -1, 1085, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1086, 0, 6000, -1, 1086, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1087, 0, -1, -1, 1087, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1088, 0, -1, -1, 1088, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1089, 0, -1, -1, 1089, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1090, 0, -1, -1, 1090, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1091, 0, 4980, -1, 1091, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1092, 0, -1, -1, 1092, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1093, 0, -1, -1, 1093, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1094, 0, -1, -1, 1094, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1095, 0, 6360, -1, 1095, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1096, 0, -1, -1, 1096, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1097, 0, -1, -1, 1097, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1098, 0, -1, -1, 1098, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1099, 0, 6480, -1, 1099, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1100, 0, -1, -1, 1100, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1101, 0, 6240, -1, 1101, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1102, 0, -1, -1, 1102, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1103, 0, -1, -1, 1103, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1040, 0, 1040, 5700, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1041, 0, 1041, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1042, 0, 1042, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1043, 0, 1043, 5160, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1044, 0, 1044, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1045, 0, 1045, 5100, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1046, 0, 1046, 5580, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1047, 0, 1047, 5940, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1048, 0, 1048, 5040, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -996, 1049, 0, 1049, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1050, 0, 1050, 5280, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1051, 0, 1051, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1052, 0, 1052, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1053, 0, 1053, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1054, 0, 1054, 6060, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1055, 0, 1055, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1056, 0, 1056, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1057, 0, 1057, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1058, 0, 1058, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1059, 0, 1059, 5340, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1060, 0, 1060, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1061, 0, 1061, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1062, 0, 1062, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1063, 0, 1063, 6420, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1064, 0, 1064, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1065, 0, 1065, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1066, 0, 1066, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1067, 0, 1067, 6540, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1068, 0, 1068, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1069, 0, 1069, 6300, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1070, 0, 1070, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1071, 0, 1071, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -999, 1024, 0, 1024, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1002, 1025, 0, 1025, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1026, 0, 1026, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1005, 1027, 0, 1027, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1028, 0, 1028, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1029, 0, 1029, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1030, 0, 1030, 5220, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1008, 1031, 0, 1031, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1032, 0, 1032, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1033, 0, 1033, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1034, 0, 1034, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1035, 0, 1035, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1011, 1036, 0, 1036, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1014, 1037, 0, 1037, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1017, 1038, 0, 1038, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1039, 0, 1039, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1121, 0, -1, -1, 1121, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1120, 0, 1120, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1123, 0, -1, -1, 1123, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1122, 0, 1122, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1125, 0, -1, -1, 1125, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1124, 0, 1124, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1127, 0, -1, -1, 1127, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1126, 0, 1126, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1129, 0, -1, -1, 1129, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1128, 0, 1128, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1131, 0, -1, -1, 1131, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1130, 0, 1130, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1133, 0, -1, -1, 1133, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1132, 0, 1132, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1135, 0, -1, -1, 1135, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1134, 0, 1134, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1137, 0, -1, -1, 1137, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1136, 0, 1136, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1139, 0, -1, -1, 1139, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1138, 0, 1138, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1141, 0, 5400, -1, 1141, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1140, 0, 1140, 5460, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1020, 0, 1143, 0, -1, -1, 1143, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1023, 1142, 0, 1142, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1145, 0, -1, -1, 1145, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1144, 0, 1144, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1147, 0, -1, -1, 1147, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1146, 0, 1146, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1149, 0, -1, -1, 1149, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1148, 0, 1148, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1151, 0, -1, -1, 1151, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1150, 0, 1150, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1153, 0, -1, -1, 1153, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1152, 0, 1152, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_ME, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1163, 0, -1, -1, 1163, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1162, 0, 1162, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1165, 0, -1, -1, 1165, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1164, 0, 1164, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1167, 0, -1, -1, 1167, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1166, 0, 1166, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1169, 0, -1, -1, 1169, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1168, 0, 1168, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1171, 0, -1, -1, 1171, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1170, 0, 1170, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1173, 0, -1, -1, 1173, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1172, 0, 1172, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1175, 0, -1, -1, 1175, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1174, 0, 1174, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1177, 0, -1, -1, 1177, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1176, 0, 1176, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1179, 0, -1, -1, 1179, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1178, 0, 1178, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1181, 0, -1, -1, 1181, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1180, 0, 1180, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1183, 0, -1, -1, 1183, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1182, 0, 1182, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1185, 0, -1, -1, 1185, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1184, 0, 1184, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1187, 0, -1, -1, 1187, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1186, 0, 1186, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1189, 0, -1, -1, 1189, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1188, 0, 1188, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1191, 0, -1, -1, 1191, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1190, 0, 1190, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1193, 0, -1, -1, 1193, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1192, 0, 1192, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1195, 0, -1, -1, 1195, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1194, 0, 1194, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1197, 0, -1, -1, 1197, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1196, 0, 1196, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1199, 0, -1, -1, 1199, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1198, 0, 1198, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1201, 0, -1, -1, 1201, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1200, 0, 1200, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1203, 0, -1, -1, 1203, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1202, 0, 1202, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1205, 0, -1, -1, 1205, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1204, 0, 1204, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1207, 0, -1, -1, 1207, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1206, 0, 1206, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1209, 0, -1, -1, 1209, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1208, 0, 1208, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1211, 0, -1, -1, 1211, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1210, 0, 1210, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1213, 0, -1, -1, 1213, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1212, 0, 1212, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1215, 0, -1, -1, 1215, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1214, 0, 1214, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1231, 0, -1, -1, 1231, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1026, 0, 1218, 0, -1, -1, 1218, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1029, 1217, 0, 1217, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1220, 0, -1, -1, 1220, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1219, 0, 1219, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1222, 0, -1, -1, 1222, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1221, 0, 1221, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1224, 0, -1, -1, 1224, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1223, 0, 1223, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1226, 0, -1, -1, 1226, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1225, 0, 1225, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1228, 0, -1, -1, 1228, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1227, 0, 1227, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1230, 0, -1, -1, 1230, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1229, 0, 1229, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1216, 0, 1216, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1032, 0, 1233, 0, -1, -1, 1233, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1035, 1232, 0, 1232, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1038, 0, 1235, 0, -1, -1, 1235, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1041, 1234, 0, 1234, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1237, 0, -1, -1, 1237, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1236, 0, 1236, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1044, 0, 1239, 0, -1, -1, 1239, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1047, 1238, 0, 1238, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1241, 0, 5760, -1, 1241, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1240, 0, 1240, 5820, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1050, 0, 1243, 0, -1, -1, 1243, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1053, 1242, 0, 1242, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1056, 0, 1245, 0, -1, -1, 1245, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1059, 1244, 0, 1244, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1062, 0, 1247, 0, -1, -1, 1247, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1065, 1246, 0, 1246, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1249, 0, -1, -1, 1249, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1248, 0, 1248, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1068, 0, 1251, 0, -1, -1, 1251, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1071, 1250, 0, 1250, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1074, 0, 1253, 0, -1, -1, 1253, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1077, 1252, 0, 1252, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1080, 0, 1255, 0, -1, -1, 1255, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1083, 1254, 0, 1254, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1257, 0, 6120, -1, 1257, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1256, 0, 1256, 6180, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1086, 0, 1259, 0, -1, -1, 1259, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1089, 1258, 0, 1258, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1092, 0, 1261, 0, -1, -1, 1261, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1095, 1260, 0, 1260, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1098, 0, 1263, 0, -1, -1, 1263, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1101, 1262, 0, 1262, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1104, 0, 1265, 0, -1, -1, 1265, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1107, 1264, 0, 1264, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1110, 0, 1267, 0, -1, -1, 1267, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1113, 1266, 0, 1266, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1116, 0, 1269, 0, -1, -1, 1269, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1119, 1268, 0, 1268, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1271, 0, -1, -1, 1271, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1270, 0, 1270, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1122, 0, 1273, 0, -1, -1, 1273, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1125, 1272, 0, 1272, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1275, 0, -1, -1, 1275, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1274, 0, 1274, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1277, 0, -1, -1, 1277, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1276, 0, 1276, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1279, 0, -1, -1, 1279, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1278, 0, 1278, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1281, 0, -1, -1, 1281, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1280, 0, 1280, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1283, 0, -1, -1, 1283, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1282, 0, 1282, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1285, 0, -1, -1, 1285, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1284, 0, 1284, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1287, 0, -1, -1, 1287, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1286, 0, 1286, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1289, 0, -1, -1, 1289, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1288, 0, 1288, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1291, 0, -1, -1, 1291, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1290, 0, 1290, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1293, 0, -1, -1, 1293, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1292, 0, 1292, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1295, 0, -1, -1, 1295, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1294, 0, 1294, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1297, 0, -1, -1, 1297, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1296, 0, 1296, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1299, 0, -1, -1, 1299, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1298, 0, 1298, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1301, 0, -1, -1, 1301, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1300, 0, 1300, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1303, 0, -1, -1, 1303, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1302, 0, 1302, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1305, 0, -1, -1, 1305, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1304, 0, 1304, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1307, 0, -1, -1, 1307, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1306, 0, 1306, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1309, 0, -1, -1, 1309, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1308, 0, 1308, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1311, 0, -1, -1, 1311, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1310, 0, 1310, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1313, 0, -1, -1, 1313, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1312, 0, 1312, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1315, 0, -1, -1, 1315, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1314, 0, 1314, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1377, 0, -1, -1, 1377, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1378, 0, -1, -1, 1378, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1379, 0, -1, -1, 1379, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1380, 0, -1, -1, 1380, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1381, 0, -1, -1, 1381, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1382, 0, -1, -1, 1382, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1383, 0, -1, -1, 1383, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1384, 0, -1, -1, 1384, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1385, 0, -1, -1, 1385, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1386, 0, -1, -1, 1386, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1387, 0, -1, -1, 1387, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1388, 0, -1, -1, 1388, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1389, 0, -1, -1, 1389, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1390, 0, -1, -1, 1390, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1391, 0, -1, -1, 1391, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1392, 0, -1, -1, 1392, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1393, 0, -1, -1, 1393, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1394, 0, -1, -1, 1394, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1395, 0, -1, -1, 1395, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1396, 0, -1, -1, 1396, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1397, 0, -1, -1, 1397, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1398, 0, -1, -1, 1398, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1399, 0, -1, -1, 1399, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1400, 0, -1, -1, 1400, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1401, 0, -1, -1, 1401, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1402, 0, -1, -1, 1402, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1403, 0, -1, -1, 1403, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1404, 0, -1, -1, 1404, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1405, 0, -1, -1, 1405, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1406, 0, -1, -1, 1406, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1407, 0, -1, -1, 1407, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1408, 0, -1, -1, 1408, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1409, 0, -1, -1, 1409, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1410, 0, -1, -1, 1410, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1411, 0, -1, -1, 1411, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1412, 0, -1, -1, 1412, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1413, 0, -1, -1, 1413, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 1414, 0, -1, -1, 1414, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1329, 0, 1329, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1330, 0, 1330, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1331, 0, 1331, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1332, 0, 1332, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1333, 0, 1333, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1334, 0, 1334, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1335, 0, 1335, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1336, 0, 1336, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1337, 0, 1337, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1338, 0, 1338, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1339, 0, 1339, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1340, 0, 1340, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1341, 0, 1341, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1342, 0, 1342, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1343, 0, 1343, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1344, 0, 1344, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1345, 0, 1345, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1346, 0, 1346, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1347, 0, 1347, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1348, 0, 1348, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1349, 0, 1349, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1350, 0, 1350, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1351, 0, 1351, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1352, 0, 1352, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1353, 0, 1353, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1354, 0, 1354, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1355, 0, 1355, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1356, 0, 1356, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1357, 0, 1357, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1358, 0, 1358, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1359, 0, 1359, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1360, 0, 1360, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1361, 0, 1361, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1362, 0, 1362, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1363, 0, 1363, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1364, 0, 1364, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1365, 0, 1365, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 1366, 0, 1366, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1128, -1131, -1134, -1136, -1, -1, -1128, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 7, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 222, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 228, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 10, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 11, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 12, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 13, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 14, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 15, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 16, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 17, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 18, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 19, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 20, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 21, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 22, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 23, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 24, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 25, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 18, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 6, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_AN, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 30, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 31, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 32, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1139, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1142, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1145, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1148, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1151, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6600, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6660, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6720, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 27, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 28, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 29, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 30, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 31, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 32, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 33, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 34, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 17, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 230, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 18, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 19, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_AN, 0, 0, 0, 0, 0, -1, -1, 0, 9, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AN, 0, 0, 0, 0, 0, -1, -1, 0, 9, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_AN, 0, 0, 0, 0, 0, -1, -1, 0, 7, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 35, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, -1154, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, -1157, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, -1160, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_COMPAT, -1163, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1166, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6840, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1169, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6900, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, -1172, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, 6780, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_AL, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 36, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 9, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 6960, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1175, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7020, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1178, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7080, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1181, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 7, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 20, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1184, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1187, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1190, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1193, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1196, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1199, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1202, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1205, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 9, 8,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 7, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 21, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7140, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1208, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1211, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 22, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1214, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1217, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1220, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1223, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1226, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1229, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1232, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1235, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1238, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 24, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7200, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1241, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1244, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1247, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 23, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 25, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1250, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1253, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7260, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1256, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 27, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7320, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7380, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1259, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1262, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1265, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 26, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, 7440, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1268, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 84, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 91, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 28, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7500, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1271, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 31, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7560, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1274, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1277, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1280, 0, 0, 0, 7620, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1283, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 29, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 30, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 32, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7680, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7740, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1286, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1289, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1292, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 33, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 34, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 35, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7800, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1295, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1298, 0, 0, 0, 7860, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1301, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1304, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 36, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1307, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 103, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 107, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1310, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 118, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 122, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1313, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1316, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NOBREAK, 3851, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 216, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1319, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1322, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1325, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1328, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1331, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1334, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 129, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 130, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1337, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 132, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1340, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1343, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, UTF8PROC_DECOMP_TYPE_COMPAT, -1346, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1349, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, UTF8PROC_DECOMP_TYPE_COMPAT, -1352, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1355, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1358, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1361, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1364, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1367, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1370, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, -1373, 0, 0, 0, -1, -1, 0, 12, 14,true, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7920, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1376, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 37, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MN, 9, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11520, 0, -1, -1, 11520, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11521, 0, -1, -1, 11521, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11522, 0, -1, -1, 11522, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11523, 0, -1, -1, 11523, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11524, 0, -1, -1, 11524, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11525, 0, -1, -1, 11525, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11526, 0, -1, -1, 11526, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11527, 0, -1, -1, 11527, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11528, 0, -1, -1, 11528, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11529, 0, -1, -1, 11529, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11530, 0, -1, -1, 11530, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11531, 0, -1, -1, 11531, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11532, 0, -1, -1, 11532, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11533, 0, -1, -1, 11533, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11534, 0, -1, -1, 11534, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11535, 0, -1, -1, 11535, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11536, 0, -1, -1, 11536, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11537, 0, -1, -1, 11537, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11538, 0, -1, -1, 11538, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11539, 0, -1, -1, 11539, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11540, 0, -1, -1, 11540, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11541, 0, -1, -1, 11541, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11542, 0, -1, -1, 11542, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11543, 0, -1, -1, 11543, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11544, 0, -1, -1, 11544, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11545, 0, -1, -1, 11545, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11546, 0, -1, -1, 11546, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11547, 0, -1, -1, 11547, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11548, 0, -1, -1, 11548, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11549, 0, -1, -1, 11549, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11550, 0, -1, -1, 11550, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11551, 0, -1, -1, 11551, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11552, 0, -1, -1, 11552, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11553, 0, -1, -1, 11553, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11554, 0, -1, -1, 11554, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11555, 0, -1, -1, 11555, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11556, 0, -1, -1, 11556, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11557, 0, -1, -1, 11557, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 4316, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, true, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 228, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 7980, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1379, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8040, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1382, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8100, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1385, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8160, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1388, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8220, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1391, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8280, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -1394, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 38, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, 8340, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1397, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, 8400, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1400, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8460, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 8520, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1403, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1406, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, 8580, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 0, UTF8PROC_BIDI_CLASS_L, 0, -1409, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 9, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 7, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 65, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 198, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 66, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 68, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 69, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 398, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 71, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 72, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 73, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 74, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 75, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 76, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 77, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 78, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 79, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 546, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 80, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 82, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 84, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 85, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 87, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 97, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 592, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 593, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7426, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 98, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 100, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 101, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 601, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 603, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 604, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 103, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 107, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 109, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 331, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 111, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 596, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7446, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7447, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 112, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 116, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 117, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7453, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 623, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 118, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7461, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 946, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 947, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 948, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 966, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 967, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 105, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 114, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 117, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 118, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 946, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 947, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 961, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 966, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 967, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 1085, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42877, 0, 42877, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11363, 0, 11363, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 594, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 99, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 597, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 240, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 604, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 102, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 607, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 609, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 613, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 616, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 617, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 618, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7547, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 669, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 621, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7557, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 671, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 625, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 624, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 626, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 627, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 628, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 629, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 632, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 642, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 643, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 427, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 649, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 650, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 7452, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 651, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 652, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 122, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 656, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 657, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 658, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 952, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 234, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 214, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MN, 202, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1412, 0, 7681, 0, -1, -1, 7681, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1415, 7680, 0, 7680, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1418, 0, 7683, 0, -1, -1, 7683, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1421, 7682, 0, 7682, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1424, 0, 7685, 0, -1, -1, 7685, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1427, 7684, 0, 7684, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1430, 0, 7687, 0, -1, -1, 7687, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1433, 7686, 0, 7686, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1436, 0, 7689, 0, -1, -1, 7689, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1439, 7688, 0, 7688, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1442, 0, 7691, 0, -1, -1, 7691, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1445, 7690, 0, 7690, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1448, 0, 7693, 0, -1, -1, 7693, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1451, 7692, 0, 7692, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1454, 0, 7695, 0, -1, -1, 7695, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1457, 7694, 0, 7694, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1460, 0, 7697, 0, -1, -1, 7697, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1463, 7696, 0, 7696, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1466, 0, 7699, 0, -1, -1, 7699, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1469, 7698, 0, 7698, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1472, 0, 7701, 0, -1, -1, 7701, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1475, 7700, 0, 7700, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1478, 0, 7703, 0, -1, -1, 7703, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1481, 7702, 0, 7702, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1484, 0, 7705, 0, -1, -1, 7705, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1487, 7704, 0, 7704, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1490, 0, 7707, 0, -1, -1, 7707, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1493, 7706, 0, 7706, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1496, 0, 7709, 0, -1, -1, 7709, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1499, 7708, 0, 7708, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1502, 0, 7711, 0, -1, -1, 7711, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1505, 7710, 0, 7710, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1508, 0, 7713, 0, -1, -1, 7713, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1511, 7712, 0, 7712, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1514, 0, 7715, 0, -1, -1, 7715, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1517, 7714, 0, 7714, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1520, 0, 7717, 0, -1, -1, 7717, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1523, 7716, 0, 7716, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1526, 0, 7719, 0, -1, -1, 7719, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1529, 7718, 0, 7718, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1532, 0, 7721, 0, -1, -1, 7721, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1535, 7720, 0, 7720, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1538, 0, 7723, 0, -1, -1, 7723, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1541, 7722, 0, 7722, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1544, 0, 7725, 0, -1, -1, 7725, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1547, 7724, 0, 7724, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1550, 0, 7727, 0, -1, -1, 7727, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1553, 7726, 0, 7726, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1556, 0, 7729, 0, -1, -1, 7729, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1559, 7728, 0, 7728, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1562, 0, 7731, 0, -1, -1, 7731, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1565, 7730, 0, 7730, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1568, 0, 7733, 0, -1, -1, 7733, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1571, 7732, 0, 7732, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1574, 0, 7735, 0, 9360, -1, 7735, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1577, 7734, 0, 7734, 9420, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1580, 0, 7737, 0, -1, -1, 7737, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1583, 7736, 0, 7736, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1586, 0, 7739, 0, -1, -1, 7739, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1589, 7738, 0, 7738, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1592, 0, 7741, 0, -1, -1, 7741, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1595, 7740, 0, 7740, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1598, 0, 7743, 0, -1, -1, 7743, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1601, 7742, 0, 7742, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1604, 0, 7745, 0, -1, -1, 7745, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1607, 7744, 0, 7744, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1610, 0, 7747, 0, -1, -1, 7747, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1613, 7746, 0, 7746, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1616, 0, 7749, 0, -1, -1, 7749, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1619, 7748, 0, 7748, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1622, 0, 7751, 0, -1, -1, 7751, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1625, 7750, 0, 7750, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1628, 0, 7753, 0, -1, -1, 7753, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1631, 7752, 0, 7752, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1634, 0, 7755, 0, -1, -1, 7755, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1637, 7754, 0, 7754, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1640, 0, 7757, 0, -1, -1, 7757, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1643, 7756, 0, 7756, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1646, 0, 7759, 0, -1, -1, 7759, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1649, 7758, 0, 7758, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1652, 0, 7761, 0, -1, -1, 7761, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1655, 7760, 0, 7760, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1658, 0, 7763, 0, -1, -1, 7763, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1661, 7762, 0, 7762, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1664, 0, 7765, 0, -1, -1, 7765, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1667, 7764, 0, 7764, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1670, 0, 7767, 0, -1, -1, 7767, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1673, 7766, 0, 7766, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1676, 0, 7769, 0, -1, -1, 7769, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1679, 7768, 0, 7768, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1682, 0, 7771, 0, 9840, -1, 7771, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1685, 7770, 0, 7770, 9900, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1688, 0, 7773, 0, -1, -1, 7773, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1691, 7772, 0, 7772, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1694, 0, 7775, 0, -1, -1, 7775, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1697, 7774, 0, 7774, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1700, 0, 7777, 0, -1, -1, 7777, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1703, 7776, 0, 7776, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1706, 0, 7779, 0, 10200, -1, 7779, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1709, 7778, 0, 7778, 10260, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1712, 0, 7781, 0, -1, -1, 7781, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1715, 7780, 0, 7780, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1718, 0, 7783, 0, -1, -1, 7783, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1721, 7782, 0, 7782, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1724, 0, 7785, 0, -1, -1, 7785, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1727, 7784, 0, 7784, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1730, 0, 7787, 0, -1, -1, 7787, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1733, 7786, 0, 7786, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1736, 0, 7789, 0, -1, -1, 7789, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1739, 7788, 0, 7788, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1742, 0, 7791, 0, -1, -1, 7791, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1745, 7790, 0, 7790, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1748, 0, 7793, 0, -1, -1, 7793, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1751, 7792, 0, 7792, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1754, 0, 7795, 0, -1, -1, 7795, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1757, 7794, 0, 7794, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1760, 0, 7797, 0, -1, -1, 7797, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1763, 7796, 0, 7796, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1766, 0, 7799, 0, -1, -1, 7799, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1769, 7798, 0, 7798, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1772, 0, 7801, 0, -1, -1, 7801, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1775, 7800, 0, 7800, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1778, 0, 7803, 0, -1, -1, 7803, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1781, 7802, 0, 7802, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1784, 0, 7805, 0, -1, -1, 7805, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1787, 7804, 0, 7804, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1790, 0, 7807, 0, -1, -1, 7807, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1793, 7806, 0, 7806, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1796, 0, 7809, 0, -1, -1, 7809, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1799, 7808, 0, 7808, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1802, 0, 7811, 0, -1, -1, 7811, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1805, 7810, 0, 7810, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1808, 0, 7813, 0, -1, -1, 7813, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1811, 7812, 0, 7812, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1814, 0, 7815, 0, -1, -1, 7815, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1817, 7814, 0, 7814, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1820, 0, 7817, 0, -1, -1, 7817, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1823, 7816, 0, 7816, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1826, 0, 7819, 0, -1, -1, 7819, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1829, 7818, 0, 7818, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1832, 0, 7821, 0, -1, -1, 7821, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1835, 7820, 0, 7820, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1838, 0, 7823, 0, -1, -1, 7823, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1841, 7822, 0, 7822, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1844, 0, 7825, 0, -1, -1, 7825, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1847, 7824, 0, 7824, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1850, 0, 7827, 0, -1, -1, 7827, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1853, 7826, 0, 7826, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1856, 0, 7829, 0, -1, -1, 7829, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1859, 7828, 0, 7828, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1862, -1865, -1868, -1865, -1, -1, -1862, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1870, -1873, -1876, -1873, -1, -1, -1870, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1878, -1881, -1884, -1881, -1, -1, -1878, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1886, -1889, -1892, -1889, -1, -1, -1886, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -1894, -1897, -1900, -1897, -1, -1, -1894, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1902, 7776, 0, 7776, -1, -1, 7777, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 223, 0, -1, -1, -112, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1905, 0, 7841, 0, 10980, -1, 7841, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1908, 7840, 0, 7840, 11040, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1911, 0, 7843, 0, -1, -1, 7843, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1914, 7842, 0, 7842, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1917, 0, 7845, 0, -1, -1, 7845, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1920, 7844, 0, 7844, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1923, 0, 7847, 0, -1, -1, 7847, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1926, 7846, 0, 7846, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1929, 0, 7849, 0, -1, -1, 7849, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1932, 7848, 0, 7848, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1935, 0, 7851, 0, -1, -1, 7851, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1938, 7850, 0, 7850, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1941, 0, 7853, 0, -1, -1, 7853, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1944, 7852, 0, 7852, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1947, 0, 7855, 0, -1, -1, 7855, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1950, 7854, 0, 7854, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1953, 0, 7857, 0, -1, -1, 7857, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1956, 7856, 0, 7856, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1959, 0, 7859, 0, -1, -1, 7859, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1962, 7858, 0, 7858, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1965, 0, 7861, 0, -1, -1, 7861, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1968, 7860, 0, 7860, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1971, 0, 7863, 0, -1, -1, 7863, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1974, 7862, 0, 7862, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1977, 0, 7865, 0, 11340, -1, 7865, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1980, 7864, 0, 7864, 11400, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1983, 0, 7867, 0, -1, -1, 7867, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1986, 7866, 0, 7866, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1989, 0, 7869, 0, -1, -1, 7869, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1992, 7868, 0, 7868, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -1995, 0, 7871, 0, -1, -1, 7871, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -1998, 7870, 0, 7870, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2001, 0, 7873, 0, -1, -1, 7873, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2004, 7872, 0, 7872, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2007, 0, 7875, 0, -1, -1, 7875, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2010, 7874, 0, 7874, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2013, 0, 7877, 0, -1, -1, 7877, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2016, 7876, 0, 7876, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2019, 0, 7879, 0, -1, -1, 7879, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2022, 7878, 0, 7878, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2025, 0, 7881, 0, -1, -1, 7881, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2028, 7880, 0, 7880, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2031, 0, 7883, 0, -1, -1, 7883, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2034, 7882, 0, 7882, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2037, 0, 7885, 0, 11580, -1, 7885, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2040, 7884, 0, 7884, 11640, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2043, 0, 7887, 0, -1, -1, 7887, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2046, 7886, 0, 7886, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2049, 0, 7889, 0, -1, -1, 7889, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2052, 7888, 0, 7888, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2055, 0, 7891, 0, -1, -1, 7891, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2058, 7890, 0, 7890, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2061, 0, 7893, 0, -1, -1, 7893, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2064, 7892, 0, 7892, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2067, 0, 7895, 0, -1, -1, 7895, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2070, 7894, 0, 7894, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2073, 0, 7897, 0, -1, -1, 7897, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2076, 7896, 0, 7896, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2079, 0, 7899, 0, -1, -1, 7899, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2082, 7898, 0, 7898, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2085, 0, 7901, 0, -1, -1, 7901, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2088, 7900, 0, 7900, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2091, 0, 7903, 0, -1, -1, 7903, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2094, 7902, 0, 7902, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2097, 0, 7905, 0, -1, -1, 7905, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2100, 7904, 0, 7904, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2103, 0, 7907, 0, -1, -1, 7907, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2106, 7906, 0, 7906, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2109, 0, 7909, 0, -1, -1, 7909, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2112, 7908, 0, 7908, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2115, 0, 7911, 0, -1, -1, 7911, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2118, 7910, 0, 7910, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2121, 0, 7913, 0, -1, -1, 7913, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2124, 7912, 0, 7912, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2127, 0, 7915, 0, -1, -1, 7915, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2130, 7914, 0, 7914, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2133, 0, 7917, 0, -1, -1, 7917, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2136, 7916, 0, 7916, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2139, 0, 7919, 0, -1, -1, 7919, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2142, 7918, 0, 7918, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2145, 0, 7921, 0, -1, -1, 7921, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2148, 7920, 0, 7920, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2151, 0, 7923, 0, -1, -1, 7923, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2154, 7922, 0, 7922, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2157, 0, 7925, 0, -1, -1, 7925, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2160, 7924, 0, 7924, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2163, 0, 7927, 0, -1, -1, 7927, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2166, 7926, 0, 7926, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2169, 0, 7929, 0, -1, -1, 7929, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2172, 7928, 0, 7928, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 7931, 0, -1, -1, 7931, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 7930, 0, 7930, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 7933, 0, -1, -1, 7933, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 7932, 0, 7932, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 7935, 0, -1, -1, 7935, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 7934, 0, 7934, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2175, 7944, 0, 7944, 11940, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2178, 7945, 0, 7945, 12000, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2181, 7946, 0, 7946, 13560, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2184, 7947, 0, 7947, 13620, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2187, 7948, 0, 7948, 13680, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2190, 7949, 0, 7949, 13740, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2193, 7950, 0, 7950, 13800, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2196, 7951, 0, 7951, 13860, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2199, 0, 7936, 0, 12060, -1, 7936, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2202, 0, 7937, 0, 12120, -1, 7937, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2205, 0, 7938, 0, 13920, -1, 7938, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2208, 0, 7939, 0, 13980, -1, 7939, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2211, 0, 7940, 0, 14040, -1, 7940, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2214, 0, 7941, 0, 14100, -1, 7941, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2217, 0, 7942, 0, 14160, -1, 7942, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2220, 0, 7943, 0, 14220, -1, 7943, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2223, 7960, 0, 7960, 12180, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2226, 7961, 0, 7961, 12240, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2229, 7962, 0, 7962, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2232, 7963, 0, 7963, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2235, 7964, 0, 7964, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2238, 7965, 0, 7965, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2241, 0, 7952, 0, 12300, -1, 7952, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2244, 0, 7953, 0, 12360, -1, 7953, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2247, 0, 7954, 0, -1, -1, 7954, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2250, 0, 7955, 0, -1, -1, 7955, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2253, 0, 7956, 0, -1, -1, 7956, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2256, 0, 7957, 0, -1, -1, 7957, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2259, 7976, 0, 7976, 12420, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2262, 7977, 0, 7977, 12480, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2265, 7978, 0, 7978, 14280, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2268, 7979, 0, 7979, 14340, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2271, 7980, 0, 7980, 14400, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2274, 7981, 0, 7981, 14460, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2277, 7982, 0, 7982, 14520, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2280, 7983, 0, 7983, 14580, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2283, 0, 7968, 0, 12540, -1, 7968, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2286, 0, 7969, 0, 12600, -1, 7969, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2289, 0, 7970, 0, 14640, -1, 7970, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2292, 0, 7971, 0, 14700, -1, 7971, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2295, 0, 7972, 0, 14760, -1, 7972, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2298, 0, 7973, 0, 14820, -1, 7973, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2301, 0, 7974, 0, 14880, -1, 7974, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2304, 0, 7975, 0, 14940, -1, 7975, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2307, 7992, 0, 7992, 12660, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2310, 7993, 0, 7993, 12720, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2313, 7994, 0, 7994, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2316, 7995, 0, 7995, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2319, 7996, 0, 7996, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2322, 7997, 0, 7997, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2325, 7998, 0, 7998, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2328, 7999, 0, 7999, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2331, 0, 7984, 0, 12780, -1, 7984, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2334, 0, 7985, 0, 12840, -1, 7985, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2337, 0, 7986, 0, -1, -1, 7986, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2340, 0, 7987, 0, -1, -1, 7987, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2343, 0, 7988, 0, -1, -1, 7988, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2346, 0, 7989, 0, -1, -1, 7989, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2349, 0, 7990, 0, -1, -1, 7990, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2352, 0, 7991, 0, -1, -1, 7991, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2355, 8008, 0, 8008, 12900, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2358, 8009, 0, 8009, 12960, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2361, 8010, 0, 8010, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2364, 8011, 0, 8011, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2367, 8012, 0, 8012, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2370, 8013, 0, 8013, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2373, 0, 8000, 0, 13020, -1, 8000, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2376, 0, 8001, 0, 13080, -1, 8001, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2379, 0, 8002, 0, -1, -1, 8002, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2382, 0, 8003, 0, -1, -1, 8003, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2385, 0, 8004, 0, -1, -1, 8004, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2388, 0, 8005, 0, -1, -1, 8005, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2391, -2394, -2397, -2394, 13140, -1, -2391, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2399, 8025, 0, 8025, 13200, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2402, -2405, -2409, -2405, -1, -1, -2411, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2415, 8027, 0, 8027, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2418, -2421, -2425, -2421, -1, -1, -2427, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2431, 8029, 0, 8029, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2434, -2437, -2441, -2437, -1, -1, -2443, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2447, 8031, 0, 8031, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2450, 0, 8017, 0, 13260, -1, 8017, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2453, 0, 8019, 0, -1, -1, 8019, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2456, 0, 8021, 0, -1, -1, 8021, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2459, 0, 8023, 0, -1, -1, 8023, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2462, 8040, 0, 8040, 13320, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2465, 8041, 0, 8041, 13380, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2468, 8042, 0, 8042, 15000, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2471, 8043, 0, 8043, 15060, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2474, 8044, 0, 8044, 15120, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2477, 8045, 0, 8045, 15180, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2480, 8046, 0, 8046, 15240, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2483, 8047, 0, 8047, 15300, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2486, 0, 8032, 0, 13440, -1, 8032, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2489, 0, 8033, 0, 13500, -1, 8033, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2492, 0, 8034, 0, 15360, -1, 8034, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2495, 0, 8035, 0, 15420, -1, 8035, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2498, 0, 8036, 0, 15480, -1, 8036, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2501, 0, 8037, 0, 15540, -1, 8037, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2504, 0, 8038, 0, 15600, -1, 8038, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2507, 0, 8039, 0, 15660, -1, 8039, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2510, 8122, 0, 8122, 15720, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 940, 8123, 0, 8123, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2513, 8136, 0, 8136, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 941, 8137, 0, 8137, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2516, 8138, 0, 8138, 15900, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 942, 8139, 0, 8139, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2519, 8154, 0, 8154, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 943, 8155, 0, 8155, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2522, 8184, 0, 8184, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 972, 8185, 0, 8185, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2525, 8170, 0, 8170, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 973, 8171, 0, 8171, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2528, 8186, 0, 8186, 16320, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 974, 8187, 0, 8187, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2531, -2534, -2537, -2539, -1, -1, -2541, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2544, -2547, -2550, -2552, -1, -1, -2554, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2557, -2560, -2563, -2565, -1, -1, -2567, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2570, -2573, -2576, -2578, -1, -1, -2580, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2583, -2586, -2589, -2591, -1, -1, -2593, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2596, -2599, -2602, -2604, -1, -1, -2606, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2609, -2612, -2615, -2617, -1, -1, -2619, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2622, -2625, -2628, -2630, -1, -1, -2632, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2635, -2534, -2537, -2539, -1, -1, -2541, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2638, -2547, -2550, -2552, -1, -1, -2554, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2641, -2560, -2563, -2565, -1, -1, -2567, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2644, -2573, -2576, -2578, -1, -1, -2580, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2647, -2586, -2589, -2591, -1, -1, -2593, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2650, -2599, -2602, -2604, -1, -1, -2606, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2653, -2612, -2615, -2617, -1, -1, -2619, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2656, -2625, -2628, -2630, -1, -1, -2632, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2659, -2662, -2665, -2667, -1, -1, -2669, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2672, -2675, -2678, -2680, -1, -1, -2682, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2685, -2688, -2691, -2693, -1, -1, -2695, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2698, -2701, -2704, -2706, -1, -1, -2708, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2711, -2714, -2717, -2719, -1, -1, -2721, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2724, -2727, -2730, -2732, -1, -1, -2734, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2737, -2740, -2743, -2745, -1, -1, -2747, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2750, -2753, -2756, -2758, -1, -1, -2760, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2763, -2662, -2665, -2667, -1, -1, -2669, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2766, -2675, -2678, -2680, -1, -1, -2682, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2769, -2688, -2691, -2693, -1, -1, -2695, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2772, -2701, -2704, -2706, -1, -1, -2708, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2775, -2714, -2717, -2719, -1, -1, -2721, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2778, -2727, -2730, -2732, -1, -1, -2734, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2781, -2740, -2743, -2745, -1, -1, -2747, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2784, -2753, -2756, -2758, -1, -1, -2760, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2787, -2790, -2793, -2795, -1, -1, -2797, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2800, -2803, -2806, -2808, -1, -1, -2810, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2813, -2816, -2819, -2821, -1, -1, -2823, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2826, -2829, -2832, -2834, -1, -1, -2836, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2839, -2842, -2845, -2847, -1, -1, -2849, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2852, -2855, -2858, -2860, -1, -1, -2862, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2865, -2868, -2871, -2873, -1, -1, -2875, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2878, -2881, -2884, -2886, -1, -1, -2888, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2891, -2790, -2793, -2795, -1, -1, -2797, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2894, -2803, -2806, -2808, -1, -1, -2810, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2897, -2816, -2819, -2821, -1, -1, -2823, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2900, -2829, -2832, -2834, -1, -1, -2836, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2903, -2842, -2845, -2847, -1, -1, -2849, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2906, -2855, -2858, -2860, -1, -1, -2862, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2909, -2868, -2871, -2873, -1, -1, -2875, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2912, -2881, -2884, -2886, -1, -1, -2888, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2915, 8120, 0, 8120, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2918, 8121, 0, 8121, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2921, -2924, -2927, -2929, -1, -1, -2932, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2935, -2938, -2941, -2943, -1, -1, -2945, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2948, -2951, -2954, -2956, -1, -1, -2959, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2962, -2965, -2968, -2965, 15840, -1, -2962, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -2970, -2973, -2977, -2979, -1, -1, -2983, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2987, 0, 8112, 0, -1, -1, 8112, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2990, 0, 8113, 0, -1, -1, 8113, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -2993, 0, 8048, 0, -1, -1, 8048, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 902, 0, 8049, 0, -1, -1, 8049, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -2996, -2938, -2941, -2943, -1, -1, -2945, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -2999, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 953, 921, 0, 921, -1, -1, 953, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -2999, 0, 0, 0, 16080, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3002, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3005, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3008, -3011, -3014, -3016, -1, -1, -3019, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3022, -3025, -3028, -3030, -1, -1, -3032, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3035, -3038, -3041, -3043, -1, -1, -3046, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3049, -3052, -3055, -3052, 16020, -1, -3049, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3057, -3060, -3064, -3066, -1, -1, -3070, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3074, 0, 8050, 0, -1, -1, 8050, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 904, 0, 8051, 0, -1, -1, 8051, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3077, 0, 8052, 0, -1, -1, 8052, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 905, 0, 8053, 0, -1, -1, 8053, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -3080, -3025, -3028, -3030, -1, -1, -3032, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3083, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3086, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3089, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3092, 8152, 0, 8152, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3095, 8153, 0, 8153, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3098, -3101, -3105, -3101, -1, -1, -3107, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 912, -910, -3111, -910, -1, -1, -916, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3113, -3116, -3119, -3116, -1, -1, -3113, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3121, -3124, -3128, -3124, -1, -1, -3130, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3134, 0, 8144, 0, -1, -1, 8144, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3137, 0, 8145, 0, -1, -1, 8145, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3140, 0, 8054, 0, -1, -1, 8054, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 906, 0, 8055, 0, -1, -1, 8055, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3143, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3146, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3149, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3152, 8168, 0, 8168, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3155, 8169, 0, 8169, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3158, -3161, -3165, -3161, -1, -1, -3167, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 944, -941, -3171, -941, -1, -1, -947, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3173, -3176, -3179, -3176, -1, -1, -3173, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3181, 8172, 0, 8172, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3184, -3187, -3190, -3187, -1, -1, -3184, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3192, -3195, -3199, -3195, -1, -1, -3201, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3205, 0, 8160, 0, -1, -1, 8160, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3208, 0, 8161, 0, -1, -1, 8161, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3211, 0, 8058, 0, -1, -1, 8058, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 910, 0, 8059, 0, -1, -1, 8059, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3214, 0, 8165, 0, -1, -1, 8165, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3217, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, 901, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, 96, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3220, -3223, -3226, -3228, -1, -1, -3231, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3234, -3237, -3240, -3242, -1, -1, -3244, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3247, -3250, -3253, -3255, -1, -1, -3258, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3261, -3264, -3267, -3264, 16440, -1, -3261, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, -3269, -3272, -3276, -3278, -1, -1, -3282, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3286, 0, 8056, 0, -1, -1, 8056, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 908, 0, 8057, 0, -1, -1, 8057, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, -3289, 0, 8060, 0, -1, -1, 8060, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 911, 0, 8061, 0, -1, -1, 8061, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LT, 0, UTF8PROC_BIDI_CLASS_L, 0, -3292, -3237, -3240, -3242, -1, -1, -3244, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, 180, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3295, 0, 0, 0, 16140, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, 8194, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, 0, 8195, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_COMPAT, 32, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_NOBREAK, 32, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_BN, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, true, true, true, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NOBREAK, 8208, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3298, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PI, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 8, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PF, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 8, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PI, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PF, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 46, 0, 0, 0, -1, -1, 0, 8, 9,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3301, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3304, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 6, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ZL, 0, UTF8PROC_BIDI_CLASS_WS, 0, 0, 0, 0, 0, -1, -1, 0, 3, 3,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_ZP, 0, UTF8PROC_BIDI_CLASS_B, 0, 0, 0, 0, 0, -1, -1, 0, 3, 3,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_LRE, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_RLE, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_PDF, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_LRO, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_RLO, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, true, true, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, -3308, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, -3311, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3315, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3318, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3322, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3325, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_CS, 0, 0, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3328, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3331, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3334, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3337, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 48, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 105, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 52, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 53, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 54, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 55, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 56, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUPER, 57, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUPER, 43, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUPER, 8722, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, 61, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, 40, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, 41, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 110, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 48, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 49, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 50, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 51, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 52, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 53, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 54, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 55, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 56, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_SUB, 57, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUB, 43, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SUB, 8722, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, 61, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, 40, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUB, 41, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 97, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 101, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 111, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 120, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 601, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_COMPAT, -3342, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 1, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3345, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3349, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 67, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3353, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3356, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3360, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 400, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3364, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 103, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 72, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 104, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 295, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 73, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 76, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 108, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 78, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3367, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 80, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 81, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 82, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, -3370, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3373, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SUPER, -3377, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 90, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 937, 0, 969, 0, -1, -1, 969, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 75, 0, 107, 0, -1, -1, 107, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 197, 0, 229, 0, -1, -1, 229, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 66, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 101, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 69, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 70, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 8526, 0, -1, -1, 8526, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 77, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 111, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 1488, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 1489, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 1490, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 1491, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 105, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3380, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 960, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 947, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 915, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 928, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FONT, 8721, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 68, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 100, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 106, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 8498, 0, 8498, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3384, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3388, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3392, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3396, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3400, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3404, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3408, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3412, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3416, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3420, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3424, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3428, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_FRACTION, -3432, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 73, 0, 8560, 0, -1, -1, 8560, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3435, 0, 8561, 0, -1, -1, 8561, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3438, 0, 8562, 0, -1, -1, 8562, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3442, 0, 8563, 0, -1, -1, 8563, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 86, 0, 8564, 0, -1, -1, 8564, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3445, 0, 8565, 0, -1, -1, 8565, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3448, 0, 8566, 0, -1, -1, 8566, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3452, 0, 8567, 0, -1, -1, 8567, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3457, 0, 8568, 0, -1, -1, 8568, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 88, 0, 8569, 0, -1, -1, 8569, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3460, 0, 8570, 0, -1, -1, 8570, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3463, 0, 8571, 0, -1, -1, 8571, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 76, 0, 8572, 0, -1, -1, 8572, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 67, 0, 8573, 0, -1, -1, 8573, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 68, 0, 8574, 0, -1, -1, 8574, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 77, 0, 8575, 0, -1, -1, 8575, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 105, 8544, 0, 8544, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3467, 8545, 0, 8545, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3470, 8546, 0, 8546, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3474, 8547, 0, 8547, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 118, 8548, 0, 8548, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3477, 8549, 0, 8549, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3480, 8550, 0, 8550, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3484, 8551, 0, 8551, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3489, 8552, 0, 8552, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 120, 8553, 0, 8553, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3492, 8554, 0, 8554, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3495, 8555, 0, 8555, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 108, 8556, 0, 8556, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 99, 8557, 0, 8557, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 100, 8558, 0, 8558, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 109, 8559, 0, 8559, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 8580, 0, -1, -1, 8580, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 8579, 0, 8579, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16500, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16560, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16620, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3499, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3502, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3505, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3508, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3511, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3514, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16680, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16800, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16740, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16860, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3517, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16920, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3520, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 16980, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3523, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17040, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3526, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17100, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3529, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3532, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3535, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3539, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3542, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17160, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3546, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17220, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3549, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17280, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3552, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17340, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3555, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17520, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3558, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17460, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3561, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17700, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17760, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3564, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3567, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3570, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3573, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3576, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17820, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17880, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3579, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3582, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 17940, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18000, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3585, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3588, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18060, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18120, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18660, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18720, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3591, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3594, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18180, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18240, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3597, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3600, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18300, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18360, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3603, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3606, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18780, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18840, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18420, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18480, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18540, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18600, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3609, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3612, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3615, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3618, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18900, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 18960, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 19020, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 19080, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3621, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3624, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3627, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3630, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3633, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3636, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3639, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3642, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, 0, 12296, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, 12297, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 49, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 50, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 51, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 52, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 53, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 54, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 55, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 56, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 57, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3645, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3648, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3651, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3654, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3657, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3660, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3663, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3666, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3669, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3672, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -3675, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3678, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3682, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3686, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3690, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3694, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3698, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3702, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3706, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3710, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3714, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3719, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3724, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3729, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3734, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3739, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3744, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3749, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3754, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3759, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3764, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3769, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3772, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3775, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3778, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3781, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3784, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3787, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3790, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3793, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3796, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3800, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3804, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3808, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3812, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3816, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3820, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3824, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3828, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3832, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_COMPAT, -3836, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3840, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3844, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3848, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3852, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3856, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3860, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3864, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3868, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3872, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3876, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3880, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3884, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3888, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3892, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3896, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3900, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3904, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3908, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3912, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3916, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3920, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3924, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3928, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3932, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3936, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -3940, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 65, 0, 9424, 0, -1, -1, 9424, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 66, 0, 9425, 0, -1, -1, 9425, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 67, 0, 9426, 0, -1, -1, 9426, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 68, 0, 9427, 0, -1, -1, 9427, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 69, 0, 9428, 0, -1, -1, 9428, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 70, 0, 9429, 0, -1, -1, 9429, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 71, 0, 9430, 0, -1, -1, 9430, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 72, 0, 9431, 0, -1, -1, 9431, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 73, 0, 9432, 0, -1, -1, 9432, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 74, 0, 9433, 0, -1, -1, 9433, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 75, 0, 9434, 0, -1, -1, 9434, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 76, 0, 9435, 0, -1, -1, 9435, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 77, 0, 9436, 0, -1, -1, 9436, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 78, 0, 9437, 0, -1, -1, 9437, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 79, 0, 9438, 0, -1, -1, 9438, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 80, 0, 9439, 0, -1, -1, 9439, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 81, 0, 9440, 0, -1, -1, 9440, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 82, 0, 9441, 0, -1, -1, 9441, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 83, 0, 9442, 0, -1, -1, 9442, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 84, 0, 9443, 0, -1, -1, 9443, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 85, 0, 9444, 0, -1, -1, 9444, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 86, 0, 9445, 0, -1, -1, 9445, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 87, 0, 9446, 0, -1, -1, 9446, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 88, 0, 9447, 0, -1, -1, 9447, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 89, 0, 9448, 0, -1, -1, 9448, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 90, 0, 9449, 0, -1, -1, 9449, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 97, 9398, 0, 9398, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 98, 9399, 0, 9399, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 99, 9400, 0, 9400, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 100, 9401, 0, 9401, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 101, 9402, 0, 9402, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 102, 9403, 0, 9403, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 103, 9404, 0, 9404, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 104, 9405, 0, 9405, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 105, 9406, 0, 9406, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 106, 9407, 0, 9407, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 107, 9408, 0, 9408, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 108, 9409, 0, 9409, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 109, 9410, 0, 9410, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 110, 9411, 0, 9411, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 111, 9412, 0, 9412, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 112, 9413, 0, 9413, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 113, 9414, 0, 9414, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 114, 9415, 0, 9415, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 115, 9416, 0, 9416, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 116, 9417, 0, 9417, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 117, 9418, 0, 9418, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 118, 9419, 0, 9419, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 119, 9420, 0, 9420, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 120, 9421, 0, 9421, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 121, 9422, 0, 9422, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 122, 9423, 0, 9423, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, 48, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3944, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3949, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3953, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -3956, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, -3960, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, 19140, -1, 0, 0, 0,false, false, false, false, false, true, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11312, 0, -1, -1, 11312, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11313, 0, -1, -1, 11313, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11314, 0, -1, -1, 11314, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11315, 0, -1, -1, 11315, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11316, 0, -1, -1, 11316, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11317, 0, -1, -1, 11317, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11318, 0, -1, -1, 11318, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11319, 0, -1, -1, 11319, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11320, 0, -1, -1, 11320, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11321, 0, -1, -1, 11321, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11322, 0, -1, -1, 11322, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11323, 0, -1, -1, 11323, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11324, 0, -1, -1, 11324, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11325, 0, -1, -1, 11325, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11326, 0, -1, -1, 11326, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11327, 0, -1, -1, 11327, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11328, 0, -1, -1, 11328, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11329, 0, -1, -1, 11329, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11330, 0, -1, -1, 11330, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11331, 0, -1, -1, 11331, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11332, 0, -1, -1, 11332, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11333, 0, -1, -1, 11333, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11334, 0, -1, -1, 11334, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11335, 0, -1, -1, 11335, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11336, 0, -1, -1, 11336, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11337, 0, -1, -1, 11337, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11338, 0, -1, -1, 11338, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11339, 0, -1, -1, 11339, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11340, 0, -1, -1, 11340, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11341, 0, -1, -1, 11341, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11342, 0, -1, -1, 11342, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11343, 0, -1, -1, 11343, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11344, 0, -1, -1, 11344, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11345, 0, -1, -1, 11345, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11346, 0, -1, -1, 11346, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11347, 0, -1, -1, 11347, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11348, 0, -1, -1, 11348, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11349, 0, -1, -1, 11349, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11350, 0, -1, -1, 11350, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11351, 0, -1, -1, 11351, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11352, 0, -1, -1, 11352, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11353, 0, -1, -1, 11353, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11354, 0, -1, -1, 11354, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11355, 0, -1, -1, 11355, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11356, 0, -1, -1, 11356, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11357, 0, -1, -1, 11357, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11358, 0, -1, -1, 11358, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11264, 0, 11264, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11265, 0, 11265, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11266, 0, 11266, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11267, 0, 11267, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11268, 0, 11268, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11269, 0, 11269, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11270, 0, 11270, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11271, 0, 11271, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11272, 0, 11272, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11273, 0, 11273, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11274, 0, 11274, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11275, 0, 11275, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11276, 0, 11276, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11277, 0, 11277, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11278, 0, 11278, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11279, 0, 11279, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11280, 0, 11280, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11281, 0, 11281, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11282, 0, 11282, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11283, 0, 11283, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11284, 0, 11284, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11285, 0, 11285, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11286, 0, 11286, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11287, 0, 11287, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11288, 0, 11288, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11289, 0, 11289, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11290, 0, 11290, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11291, 0, 11291, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11292, 0, 11292, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11293, 0, 11293, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11294, 0, 11294, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11295, 0, 11295, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11296, 0, 11296, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11297, 0, 11297, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11298, 0, 11298, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11299, 0, 11299, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11300, 0, 11300, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11301, 0, 11301, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11302, 0, 11302, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11303, 0, 11303, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11304, 0, 11304, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11305, 0, 11305, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11306, 0, 11306, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11307, 0, 11307, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11308, 0, 11308, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11309, 0, 11309, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11310, 0, 11310, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11361, 0, -1, -1, 11361, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11360, 0, 11360, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 619, 0, -1, -1, 619, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 7549, 0, -1, -1, 7549, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 637, 0, -1, -1, 637, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 570, 0, 570, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 574, 0, 574, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11368, 0, -1, -1, 11368, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11367, 0, 11367, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11370, 0, -1, -1, 11370, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11369, 0, 11369, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11372, 0, -1, -1, 11372, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11371, 0, 11371, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 593, 0, -1, -1, 593, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 625, 0, -1, -1, 625, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 592, 0, -1, -1, 592, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11379, 0, -1, -1, 11379, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11378, 0, 11378, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11382, 0, -1, -1, 11382, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11381, 0, 11381, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUB, 106, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 86, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11393, 0, -1, -1, 11393, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11392, 0, 11392, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11395, 0, -1, -1, 11395, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11394, 0, 11394, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11397, 0, -1, -1, 11397, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11396, 0, 11396, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11399, 0, -1, -1, 11399, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11398, 0, 11398, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11401, 0, -1, -1, 11401, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11400, 0, 11400, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11403, 0, -1, -1, 11403, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11402, 0, 11402, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11405, 0, -1, -1, 11405, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11404, 0, 11404, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11407, 0, -1, -1, 11407, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11406, 0, 11406, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11409, 0, -1, -1, 11409, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11408, 0, 11408, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11411, 0, -1, -1, 11411, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11410, 0, 11410, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11413, 0, -1, -1, 11413, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11412, 0, 11412, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11415, 0, -1, -1, 11415, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11414, 0, 11414, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11417, 0, -1, -1, 11417, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11416, 0, 11416, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11419, 0, -1, -1, 11419, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11418, 0, 11418, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11421, 0, -1, -1, 11421, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11420, 0, 11420, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11423, 0, -1, -1, 11423, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11422, 0, 11422, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11425, 0, -1, -1, 11425, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11424, 0, 11424, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11427, 0, -1, -1, 11427, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11426, 0, 11426, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11429, 0, -1, -1, 11429, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11428, 0, 11428, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11431, 0, -1, -1, 11431, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11430, 0, 11430, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11433, 0, -1, -1, 11433, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11432, 0, 11432, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11435, 0, -1, -1, 11435, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11434, 0, 11434, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11437, 0, -1, -1, 11437, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11436, 0, 11436, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11439, 0, -1, -1, 11439, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11438, 0, 11438, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11441, 0, -1, -1, 11441, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11440, 0, 11440, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11443, 0, -1, -1, 11443, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11442, 0, 11442, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11445, 0, -1, -1, 11445, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11444, 0, 11444, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11447, 0, -1, -1, 11447, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11446, 0, 11446, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11449, 0, -1, -1, 11449, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11448, 0, 11448, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11451, 0, -1, -1, 11451, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11450, 0, 11450, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11453, 0, -1, -1, 11453, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11452, 0, 11452, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11455, 0, -1, -1, 11455, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11454, 0, 11454, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11457, 0, -1, -1, 11457, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11456, 0, 11456, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11459, 0, -1, -1, 11459, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11458, 0, 11458, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11461, 0, -1, -1, 11461, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11460, 0, 11460, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11463, 0, -1, -1, 11463, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11462, 0, 11462, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11465, 0, -1, -1, 11465, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11464, 0, 11464, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11467, 0, -1, -1, 11467, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11466, 0, 11466, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11469, 0, -1, -1, 11469, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11468, 0, 11468, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11471, 0, -1, -1, 11471, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11470, 0, 11470, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11473, 0, -1, -1, 11473, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11472, 0, 11472, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11475, 0, -1, -1, 11475, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11474, 0, 11474, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11477, 0, -1, -1, 11477, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11476, 0, 11476, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11479, 0, -1, -1, 11479, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11478, 0, 11478, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11481, 0, -1, -1, 11481, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11480, 0, 11480, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11483, 0, -1, -1, 11483, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11482, 0, 11482, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11485, 0, -1, -1, 11485, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11484, 0, 11484, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11487, 0, -1, -1, 11487, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11486, 0, 11486, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11489, 0, -1, -1, 11489, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11488, 0, 11488, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 11491, 0, -1, -1, 11491, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 11490, 0, 11490, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4256, 0, 4256, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4257, 0, 4257, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4258, 0, 4258, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4259, 0, 4259, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4260, 0, 4260, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4261, 0, 4261, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4262, 0, 4262, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4263, 0, 4263, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4264, 0, 4264, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4265, 0, 4265, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4266, 0, 4266, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4267, 0, 4267, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4268, 0, 4268, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4269, 0, 4269, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4270, 0, 4270, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4271, 0, 4271, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4272, 0, 4272, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4273, 0, 4273, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4274, 0, 4274, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4275, 0, 4275, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4276, 0, 4276, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4277, 0, 4277, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4278, 0, 4278, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4279, 0, 4279, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4280, 0, 4280, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4281, 0, 4281, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4282, 0, 4282, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4283, 0, 4283, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4284, 0, 4284, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4285, 0, 4285, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4286, 0, 4286, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4287, 0, 4287, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4288, 0, 4288, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4289, 0, 4289, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4290, 0, 4290, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4291, 0, 4291, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4292, 0, 4292, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 4293, 0, 4293, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 11617, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27597, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40863, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 19968, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20008, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20022, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20031, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20057, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20101, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20108, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20128, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20154, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20799, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20837, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20843, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20866, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20886, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20907, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20960, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20981, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 20992, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21147, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21241, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21269, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21274, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21304, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21313, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21340, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21353, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21378, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21430, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21448, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 21475, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22231, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22303, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22763, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22786, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22794, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22805, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22823, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 22899, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23376, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23424, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23544, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23567, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23586, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23608, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23662, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 23665, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24027, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24037, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24049, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24062, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24178, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24186, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24191, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24308, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24318, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24331, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24339, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24400, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24417, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24435, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 24515, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25096, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25142, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25163, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25903, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25908, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 25991, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26007, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26020, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26041, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26080, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26085, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26352, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26376, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 26408, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27424, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27490, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27513, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27571, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27595, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27604, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27611, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27663, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27668, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 27700, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 28779, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29226, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29238, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29243, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29247, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29255, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29273, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29275, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29356, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29572, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29577, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29916, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29926, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29976, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29983, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 29992, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30000, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30091, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30098, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30326, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30333, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30382, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30399, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30446, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30683, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30690, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 30707, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31034, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31160, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31166, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31348, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31435, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31481, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31859, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 31992, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32566, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32593, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32650, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32701, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32769, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32780, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32786, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32819, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32895, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 32905, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33251, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33258, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33267, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33276, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33292, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33307, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33311, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33390, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33394, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 33400, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 34381, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 34411, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 34880, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 34892, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 34915, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35198, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35211, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35282, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35328, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35895, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35910, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35925, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35960, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 35997, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36196, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36208, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36275, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36523, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36554, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36763, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36784, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 36789, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 37009, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 37193, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 37318, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 37324, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 37329, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38263, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38272, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38428, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38582, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38585, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38632, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38737, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38750, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38754, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38761, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38859, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38893, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38899, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 38913, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39080, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39131, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39135, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39318, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39321, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39340, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39592, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39640, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39647, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39717, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39727, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39730, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39740, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 39770, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40165, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40565, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40575, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40613, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40635, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40643, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40653, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40657, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40697, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40701, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40718, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40723, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40736, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40763, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40778, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40786, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40845, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40860, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 40864, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ZS, 0, UTF8PROC_BIDI_CLASS_WS, UTF8PROC_DECOMP_TYPE_WIDE, 32, 0, 0, 0, -1, -1, 0, 0, 4,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 218, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 224, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 12306, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 21313, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 21316, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 21317, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20400, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19200, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3963, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19260, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3966, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19320, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3969, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19380, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3972, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19440, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3975, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19500, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3978, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19560, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3981, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19620, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3984, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19680, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3987, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19740, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3990, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19800, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3993, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19860, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3996, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19920, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -3999, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 19980, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4002, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20040, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4005, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20100, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4008, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4011, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20160, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4014, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4017, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20220, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4020, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4023, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20280, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4026, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4029, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20340, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4032, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4035, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4038, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 8, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 52, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MN, 8, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, 53, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -4041, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -4044, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20460, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, -4047, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_VERTICAL, -4050, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21720, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20520, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4053, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20580, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4056, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20640, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4059, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20700, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4062, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20760, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4065, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20820, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4068, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20880, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4071, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 20940, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4074, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21000, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4077, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21060, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4080, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21120, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4083, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21180, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4086, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21240, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4089, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21300, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4092, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21360, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4095, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21420, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4098, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4101, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21480, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4104, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4107, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21540, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4110, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4113, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21600, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4116, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4119, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21660, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4122, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4125, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21780, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21840, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21900, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 21960, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4128, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4131, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4134, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4137, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, -4140, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 22020, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, 0, -4143, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_VERTICAL, -4146, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4352, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4353, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4522, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4354, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4524, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4525, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4355, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4356, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4357, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4528, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4529, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4530, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4531, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4532, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4533, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4378, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4358, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4359, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4360, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4385, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4361, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4362, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4363, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4364, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4365, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4366, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4367, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4368, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4369, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4370, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4449, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4450, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4451, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4452, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4453, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4454, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4455, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4456, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4457, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4458, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4459, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4460, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4461, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4462, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4463, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4464, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4465, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4466, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4467, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4468, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4469, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4448, 0, 0, 0, -1, -1, 0, 5, 7,false, true, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4372, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4373, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4551, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4552, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4556, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4558, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4563, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4567, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4569, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4380, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4573, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4575, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4381, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4382, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4384, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4386, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4387, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4391, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4393, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4395, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4396, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4397, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4398, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4399, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4402, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4406, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4416, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4423, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4428, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4439, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4440, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4441, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4484, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4485, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4488, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4497, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4498, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4500, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4510, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, 4513, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19968, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 20108, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19977, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 22235, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19978, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 20013, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19979, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 30002, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 20057, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19993, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 19969, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 22825, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 22320, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 20154, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4149, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4153, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4157, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4161, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4165, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4169, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4173, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4177, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4181, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4185, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4189, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4193, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4197, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4201, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4205, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4210, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4215, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4220, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4225, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4230, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4235, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4240, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4245, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4250, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4255, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4260, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4265, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4270, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4275, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -4280, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, -4288, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4295, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4299, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4303, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4307, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4311, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4315, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4319, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4323, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4327, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4331, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4335, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4339, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4343, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4347, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4351, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4355, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4359, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4363, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4367, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4371, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4375, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4379, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4383, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4387, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4391, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4395, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4399, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4403, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4407, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4411, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4415, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4419, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4423, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4427, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4431, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4435, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -4439, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4443, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4446, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4449, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4452, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4455, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4458, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4461, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4464, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4467, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4470, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4473, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4476, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4479, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4482, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4485, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4352, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4354, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4355, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4357, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4358, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4359, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4361, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4363, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4364, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4366, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4367, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4368, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4369, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 4370, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4488, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4491, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4494, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4497, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4500, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4503, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4506, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4509, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4512, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4515, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4518, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4521, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4524, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, -4527, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4530, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4536, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4541, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 19968, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20108, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 19977, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 22235, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20116, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20845, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 19971, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20843, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20061, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21313, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 26376, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 28779, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 27700, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 26408, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 37329, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 22303, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 26085, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 26666, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 26377, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 31038, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21517, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 29305, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 36001, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 31069, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21172, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 31192, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 30007, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 22899, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 36969, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20778, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21360, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 27880, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 38917, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20241, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20889, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 27491, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 19978, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20013, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 19979, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 24038, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21491, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21307, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 23447, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 23398, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 30435, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 20225, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 36039, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 21332, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 22812, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4544, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4547, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4550, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4553, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4556, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4559, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4562, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4565, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4568, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4571, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4574, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4577, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4580, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4583, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_CIRCLE, -4586, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4589, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4592, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4595, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4598, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4601, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4604, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4607, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4610, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4613, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4616, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4620, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -4624, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -4628, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -4631, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -4635, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -4638, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12450, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12452, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12454, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12456, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12458, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12459, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12461, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12463, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12465, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12467, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12469, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12471, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12473, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12475, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12477, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12479, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12481, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12484, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12486, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12488, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12490, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12491, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12492, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12493, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12494, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12495, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12498, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12501, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12504, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12507, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12510, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12511, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12512, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12513, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12514, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12516, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12518, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12520, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12521, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12522, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12523, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12524, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12525, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12527, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12528, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12529, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_CIRCLE, 12530, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4642, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4647, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4652, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4657, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4661, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4666, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4670, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4674, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4680, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4685, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4689, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4693, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4697, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4702, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4707, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4711, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4715, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4718, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4722, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4727, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4732, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4735, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4741, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4748, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4754, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4758, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4764, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4770, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4775, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4779, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4783, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4787, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4792, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4798, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4803, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4807, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4811, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4815, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4818, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4821, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4824, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4827, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4831, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4835, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4841, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4845, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4850, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4856, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4860, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4863, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4866, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4872, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4877, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4883, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4887, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4893, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4896, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4900, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4904, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4908, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4912, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4916, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4921, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4925, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4928, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4932, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4936, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4940, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4945, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4949, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4953, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4957, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4963, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4968, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4971, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4977, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4980, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4985, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4990, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4994, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -4998, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5002, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5007, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5010, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5014, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5019, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5022, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5028, 0, 0, 0, -1, -1, 0, 4, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5032, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5035, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5038, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5041, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5044, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5047, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5050, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5053, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5056, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5059, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5062, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5066, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5070, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5074, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5078, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5082, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5086, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5090, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5094, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5098, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5102, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5106, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5110, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5114, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5118, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5122, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5126, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5129, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5132, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5136, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5139, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5142, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5145, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5149, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5153, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5156, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5159, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5162, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5165, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5168, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5173, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5176, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5179, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5182, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5185, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5188, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5191, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5194, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5197, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5201, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5206, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5209, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5212, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5215, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5218, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5221, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5224, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5227, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5231, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5235, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5239, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5243, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5246, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5249, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5252, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5255, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5258, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5261, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5264, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5267, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5270, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5273, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5277, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5281, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5284, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5288, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5292, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5296, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5299, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5303, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5307, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5312, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5315, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5319, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5323, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5327, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5331, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5337, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5344, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5347, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5350, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5353, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5356, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5359, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5362, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5365, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5368, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5371, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5374, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5377, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5380, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5383, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5386, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5389, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5392, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5395, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5398, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5403, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5406, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5409, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5412, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5417, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5421, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5424, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5427, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5430, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5433, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5436, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5439, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5442, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5445, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5448, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5451, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5455, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5458, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5461, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5465, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5469, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5472, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5477, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5481, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5484, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5487, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SQUARE, -5490, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5493, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5497, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5501, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5504, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5507, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5510, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5513, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5516, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5519, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5522, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5525, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5528, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5532, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5536, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5540, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5544, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5548, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5552, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5556, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5560, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5564, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5568, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5572, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5576, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5580, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5584, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5588, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5592, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5596, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5600, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5604, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5608, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5612, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SQUARE, -5616, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42561, 0, -1, -1, 42561, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42560, 0, 42560, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42563, 0, -1, -1, 42563, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42562, 0, 42562, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42565, 0, -1, -1, 42565, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42564, 0, 42564, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42567, 0, -1, -1, 42567, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42566, 0, 42566, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42569, 0, -1, -1, 42569, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42568, 0, 42568, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42571, 0, -1, -1, 42571, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42570, 0, 42570, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42573, 0, -1, -1, 42573, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42572, 0, 42572, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42575, 0, -1, -1, 42575, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42574, 0, 42574, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42577, 0, -1, -1, 42577, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42576, 0, 42576, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42579, 0, -1, -1, 42579, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42578, 0, 42578, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42581, 0, -1, -1, 42581, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42580, 0, 42580, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42583, 0, -1, -1, 42583, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42582, 0, 42582, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42585, 0, -1, -1, 42585, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42584, 0, 42584, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42587, 0, -1, -1, 42587, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42586, 0, 42586, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42589, 0, -1, -1, 42589, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42588, 0, 42588, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42591, 0, -1, -1, 42591, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42590, 0, 42590, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42595, 0, -1, -1, 42595, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42594, 0, 42594, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42597, 0, -1, -1, 42597, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42596, 0, 42596, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42599, 0, -1, -1, 42599, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42598, 0, 42598, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42601, 0, -1, -1, 42601, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42600, 0, 42600, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42603, 0, -1, -1, 42603, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42602, 0, 42602, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42605, 0, -1, -1, 42605, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42604, 0, 42604, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ME, 0, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42625, 0, -1, -1, 42625, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42624, 0, 42624, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42627, 0, -1, -1, 42627, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42626, 0, 42626, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42629, 0, -1, -1, 42629, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42628, 0, 42628, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42631, 0, -1, -1, 42631, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42630, 0, 42630, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42633, 0, -1, -1, 42633, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42632, 0, 42632, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42635, 0, -1, -1, 42635, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42634, 0, 42634, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42637, 0, -1, -1, 42637, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42636, 0, 42636, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42639, 0, -1, -1, 42639, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42638, 0, 42638, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42641, 0, -1, -1, 42641, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42640, 0, 42640, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42643, 0, -1, -1, 42643, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42642, 0, 42642, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42645, 0, -1, -1, 42645, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42644, 0, 42644, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42647, 0, -1, -1, 42647, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42646, 0, 42646, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42787, 0, -1, -1, 42787, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42786, 0, 42786, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42789, 0, -1, -1, 42789, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42788, 0, 42788, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42791, 0, -1, -1, 42791, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42790, 0, 42790, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42793, 0, -1, -1, 42793, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42792, 0, 42792, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42795, 0, -1, -1, 42795, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42794, 0, 42794, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42797, 0, -1, -1, 42797, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42796, 0, 42796, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42799, 0, -1, -1, 42799, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42798, 0, 42798, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42803, 0, -1, -1, 42803, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42802, 0, 42802, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42805, 0, -1, -1, 42805, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42804, 0, 42804, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42807, 0, -1, -1, 42807, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42806, 0, 42806, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42809, 0, -1, -1, 42809, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42808, 0, 42808, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42811, 0, -1, -1, 42811, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42810, 0, 42810, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42813, 0, -1, -1, 42813, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42812, 0, 42812, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42815, 0, -1, -1, 42815, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42814, 0, 42814, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42817, 0, -1, -1, 42817, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42816, 0, 42816, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42819, 0, -1, -1, 42819, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42818, 0, 42818, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42821, 0, -1, -1, 42821, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42820, 0, 42820, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42823, 0, -1, -1, 42823, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42822, 0, 42822, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42825, 0, -1, -1, 42825, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42824, 0, 42824, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42827, 0, -1, -1, 42827, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42826, 0, 42826, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42829, 0, -1, -1, 42829, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42828, 0, 42828, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42831, 0, -1, -1, 42831, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42830, 0, 42830, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42833, 0, -1, -1, 42833, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42832, 0, 42832, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42835, 0, -1, -1, 42835, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42834, 0, 42834, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42837, 0, -1, -1, 42837, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42836, 0, 42836, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42839, 0, -1, -1, 42839, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42838, 0, 42838, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42841, 0, -1, -1, 42841, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42840, 0, 42840, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42843, 0, -1, -1, 42843, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42842, 0, 42842, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42845, 0, -1, -1, 42845, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42844, 0, 42844, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42847, 0, -1, -1, 42847, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42846, 0, 42846, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42849, 0, -1, -1, 42849, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42848, 0, 42848, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42851, 0, -1, -1, 42851, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42850, 0, 42850, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42853, 0, -1, -1, 42853, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42852, 0, 42852, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42855, 0, -1, -1, 42855, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42854, 0, 42854, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42857, 0, -1, -1, 42857, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42856, 0, 42856, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42859, 0, -1, -1, 42859, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42858, 0, 42858, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42861, 0, -1, -1, 42861, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42860, 0, 42860, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42863, 0, -1, -1, 42863, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42862, 0, 42862, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_SUPER, 42863, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42874, 0, -1, -1, 42874, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42873, 0, 42873, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42876, 0, -1, -1, 42876, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42875, 0, 42875, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 7545, 0, -1, -1, 7545, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42879, 0, -1, -1, 42879, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42878, 0, 42878, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42881, 0, -1, -1, 42881, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42880, 0, 42880, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42883, 0, -1, -1, 42883, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42882, 0, 42882, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42885, 0, -1, -1, 42885, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42884, 0, 42884, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42887, 0, -1, -1, 42887, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42886, 0, 42886, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 42892, 0, -1, -1, 42892, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 42891, 0, 42891, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_CS, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, true, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35912, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26356, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36554, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36040, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28369, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20018, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21477, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40860, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22865, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37329, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21895, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22856, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25078, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30313, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32645, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34367, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34746, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35064, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37007, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27138, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27931, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28889, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29662, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33853, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37226, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39409, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20098, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21365, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27396, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29211, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34349, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40478, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23888, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28651, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34253, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35172, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25289, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33240, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34847, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24266, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26391, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28010, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29436, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37070, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20358, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20919, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21214, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25796, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27347, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29200, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30439, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32769, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34310, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34396, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36335, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38706, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39791, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40442, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30860, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31103, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32160, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33737, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37636, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40575, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35542, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22751, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24324, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31840, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32894, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29282, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30922, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36034, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38647, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22744, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23650, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27155, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28122, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28431, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32047, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32311, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38475, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21202, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32907, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20956, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20940, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31260, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32190, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33777, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38517, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35712, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25295, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35582, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20025, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23527, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24594, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29575, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30064, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21271, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30971, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20415, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24489, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 19981, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27852, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25976, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32034, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21443, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22622, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30465, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33865, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35498, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27578, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36784, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27784, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25342, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33509, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25504, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30053, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20142, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20841, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20937, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26753, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31975, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33391, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35538, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37327, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21237, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21570, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22899, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24300, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26053, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28670, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31018, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38317, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39530, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40599, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40654, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21147, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26310, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27511, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36706, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24180, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24976, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25088, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25754, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28451, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29001, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29833, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31178, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32244, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32879, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36646, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34030, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36899, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37706, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21015, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21155, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21693, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28872, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35010, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24265, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24565, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25467, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27566, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31806, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29557, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20196, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22265, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23994, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24604, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29618, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29801, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32666, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32838, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37428, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38646, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38728, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38936, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20363, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31150, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37300, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38584, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24801, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20102, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20698, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23534, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23615, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26009, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29134, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30274, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34044, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36988, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40845, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26248, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38446, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21129, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26491, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26611, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27969, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28316, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29705, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30041, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30827, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32016, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39006, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20845, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25134, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38520, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20523, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23833, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28138, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36650, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24459, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24900, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26647, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38534, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21033, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21519, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23653, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26131, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26446, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26792, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27877, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29702, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30178, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32633, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35023, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35041, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37324, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38626, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21311, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28346, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21533, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29136, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29848, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34298, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38563, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40023, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40607, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26519, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28107, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33256, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31435, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31520, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31890, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29376, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28825, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35672, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20160, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33590, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21050, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20999, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24230, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25299, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31958, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23429, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27934, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26292, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36667, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34892, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38477, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35211, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24275, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20800, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21952, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22618, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26228, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20958, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29482, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30410, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31036, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31070, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31077, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31119, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38742, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31934, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32701, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34322, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35576, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36920, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37117, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39151, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39164, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39208, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40372, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20398, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20711, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20813, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21193, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21220, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21329, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21917, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22022, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22120, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22592, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22696, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23652, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23662, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24724, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24936, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24974, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25074, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25935, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26082, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26257, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26757, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28023, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28186, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28450, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29038, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29227, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29730, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30865, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31038, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31049, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31048, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31056, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31062, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31069, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31117, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31118, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31296, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31361, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31680, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32265, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32321, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32626, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32773, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33261, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33401, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33879, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35088, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35222, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35585, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35641, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36051, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36104, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36790, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38627, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38911, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38971, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20006, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20917, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20840, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20352, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20805, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 20864, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21191, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21242, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21845, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21913, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 21986, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22707, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22852, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 22868, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23138, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 23336, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24274, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24281, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24425, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24493, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24792, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24910, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24840, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 24928, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25140, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25540, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25628, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25682, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 25942, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26395, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 26454, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 27513, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28379, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28363, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 28702, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30631, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29237, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29359, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29809, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 29958, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30011, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30237, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30239, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30427, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30452, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30538, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30528, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 30924, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31409, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 31867, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32091, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 32574, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33618, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 33775, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 34681, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35137, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35206, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35519, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35531, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35565, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 35722, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36664, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 36978, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37273, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 37494, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38524, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38875, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 38923, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 39698, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 141386, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 141380, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 144341, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 15261, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 16408, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 16441, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 152137, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 154832, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 163539, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40771, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, 0, 40846, 0, 0, 0, -1, -1, 0, 0, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5620, -5623, -5626, -5628, -1, -1, -5620, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5631, -5634, -5637, -5639, -1, -1, -5631, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5642, -5645, -5648, -5650, -1, -1, -5642, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5653, -5657, -5661, -5663, -1, -1, -5653, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5667, -5671, -5675, -5677, -1, -1, -5667, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5681, -5684, -5687, -5689, -1, -1, -5692, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5692, -5684, -5695, -5689, -1, -1, -5692, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5697, -5700, -5703, -5705, -1, -1, -5697, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5708, -5711, -5714, -5716, -1, -1, -5708, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5719, -5722, -5725, -5727, -1, -1, -5719, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5730, -5733, -5736, -5738, -1, -1, -5730, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_COMPAT, -5741, -5744, -5747, -5749, -1, -1, -5741, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5752, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 26, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5755, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1506, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1488, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1491, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1492, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1499, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1500, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1501, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1512, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_FONT, 1514, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_FONT, 43, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5758, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5761, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5764, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5767, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5770, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5773, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5776, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5779, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5782, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5785, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5788, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5791, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5794, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5797, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5800, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5803, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5806, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5809, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5812, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5815, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5818, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5821, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5824, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5827, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5830, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5833, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5836, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5839, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5842, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5845, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5848, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, 0, -5851, 0, 0, 0, -1, -1, 0, 5, 7,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_R, UTF8PROC_DECOMP_TYPE_COMPAT, -5854, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1649, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1649, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1659, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1659, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1659, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1659, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1662, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1662, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1662, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1662, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1664, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1664, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1664, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1664, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1658, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1658, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1658, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1658, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1663, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1663, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1663, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1663, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1657, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1657, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1657, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1657, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1700, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1700, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1700, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1700, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1702, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1702, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1702, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1702, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1668, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1668, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1668, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1668, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1667, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1667, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1667, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1667, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1670, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1670, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1670, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1670, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1671, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1671, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1671, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1671, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1677, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1677, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1676, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1676, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1678, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1678, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1672, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1672, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1688, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1688, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1681, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1681, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1705, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1705, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1705, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1705, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1711, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1711, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1711, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1711, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1715, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1715, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1715, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1715, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1713, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1713, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1713, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1713, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1722, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1722, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1723, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1723, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1723, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1723, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1728, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1728, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1729, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1729, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1729, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1729, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1726, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1726, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1726, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1726, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1746, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1746, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1747, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1747, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1709, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1709, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1709, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1709, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1735, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1735, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1734, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1734, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1736, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1736, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1655, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1739, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1739, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1733, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1733, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1737, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1737, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1744, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1744, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1744, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1744, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1609, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1609, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5857, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5857, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5860, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5860, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5863, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5863, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5866, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5866, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5869, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5869, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5872, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5872, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5875, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5875, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5875, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5878, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5878, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5878, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1740, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1740, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1740, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1740, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5881, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5884, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5887, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5890, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5893, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5896, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5899, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5902, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5905, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5908, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5911, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5914, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5917, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5920, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5923, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5926, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5929, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5932, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5935, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5938, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5941, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5944, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5947, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5950, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5953, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5956, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5959, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5962, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5965, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5968, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5971, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5974, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5977, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5980, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5983, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5986, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5989, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5992, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5995, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -5998, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6001, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6004, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6007, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6010, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6013, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6016, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6019, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6022, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6025, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6028, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6031, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6034, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6037, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6040, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6043, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6046, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6049, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6052, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6055, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6058, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6061, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6064, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6067, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6070, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6073, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6076, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6079, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6082, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6085, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6088, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6091, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6094, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6097, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6100, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6103, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6106, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6109, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6112, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6115, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6118, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6121, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6124, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6127, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6130, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6133, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6136, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6139, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6142, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6145, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6148, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6151, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6154, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6157, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6160, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6164, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6168, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6172, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6176, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6180, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6184, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6187, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5887, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6190, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5890, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6193, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6196, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5902, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6199, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5905, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5908, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6202, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6205, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5920, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6208, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5923, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5926, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6211, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6214, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5932, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6217, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5935, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -5938, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6025, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6028, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6037, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6040, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6043, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6055, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6058, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6061, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6064, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6076, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6079, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6082, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6220, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6094, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6223, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6226, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6112, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6229, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6115, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6118, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6157, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6232, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6235, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6142, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6238, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6145, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6148, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5881, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5884, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6241, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5887, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6244, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5893, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5896, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5899, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5902, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6247, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5911, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5914, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5917, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5920, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6250, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5932, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5941, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5944, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5947, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5950, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5953, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5959, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5962, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5965, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5968, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5971, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5974, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6253, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5977, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5980, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5983, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5986, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5989, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5992, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5998, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6001, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6004, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6007, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6010, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6013, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6016, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6019, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6022, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6031, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6034, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6046, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6049, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6052, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6055, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6058, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6067, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6070, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6073, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6076, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6256, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6085, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6088, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6091, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6094, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6103, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6106, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6109, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6112, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6259, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6121, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6124, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6262, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6133, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6136, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6139, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6142, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6265, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5887, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6244, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5902, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6247, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5920, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6250, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5932, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6268, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5971, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6271, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6274, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6277, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6055, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6058, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6076, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6112, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6259, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6142, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6265, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6280, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6284, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6288, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6292, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6295, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6298, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6301, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6304, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6307, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6310, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6313, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6316, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6319, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6322, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6325, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6328, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6331, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6334, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6337, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6340, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6343, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6346, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6349, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6352, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6355, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6358, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6274, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6361, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6364, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6367, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6370, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6292, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6295, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6298, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6301, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6304, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6307, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6310, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6313, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6316, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6319, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6322, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6325, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6328, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6331, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6334, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6337, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6340, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6343, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6346, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6349, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6352, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6355, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6358, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6274, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6361, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6364, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6367, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6370, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6352, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6355, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6358, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6274, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6271, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6277, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -5995, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5962, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5965, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5968, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6352, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6355, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6358, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5995, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -5998, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6373, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6373, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6376, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6380, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6380, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6384, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6388, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6392, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6396, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6400, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6404, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6404, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6408, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6412, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6416, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6420, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6424, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6428, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6428, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6432, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6436, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6436, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6440, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6440, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6444, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6448, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6448, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6452, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6456, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6456, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6460, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6460, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6464, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6468, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6468, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6472, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6472, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6476, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6480, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6484, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6488, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6488, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6492, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6496, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6500, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6504, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6508, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6508, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6512, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6516, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6520, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6524, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6528, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6532, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6532, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6536, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6536, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6540, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6540, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6544, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6548, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6552, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6556, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6560, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6564, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6568, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6572, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6576, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6580, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6584, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6588, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6596, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6600, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6608, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6608, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6612, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6616, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6620, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6624, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6628, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6632, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6636, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6640, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6644, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6648, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6652, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6656, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6660, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6664, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6668, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6672, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6676, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6680, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6684, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6688, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6692, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6696, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6512, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6520, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6700, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6704, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6708, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6712, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6716, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6720, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6716, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6708, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6724, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6728, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6732, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6736, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6740, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6720, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6484, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, -6444, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6744, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6748, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6752, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6756, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6760, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6765, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6770, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6775, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6780, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6785, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6790, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6795, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6799, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6818, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6827, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 44, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12289, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12290, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 58, 0, 0, 0, -1, -1, 0, 6, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 59, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 33, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 63, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12310, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12311, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 8230, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 8229, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 8212, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 8211, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PC, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 95, 0, 0, 0, -1, -1, 0, 10, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 40, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 41, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 123, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 125, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12308, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12309, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12304, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12305, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12298, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12299, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12296, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12297, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12300, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12301, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12302, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 12303, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 91, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_VERTICAL, 93, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 8254, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PC, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_COMPAT, 95, 0, 0, 0, -1, -1, 0, 10, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_SMALL, 44, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 12289, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_SMALL, 46, 0, 0, 0, -1, -1, 0, 8, 9,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 59, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_SMALL, 58, 0, 0, 0, -1, -1, 0, 6, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 63, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 33, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 8212, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 40, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 41, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 123, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 125, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 12308, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 12309, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_SMALL, 35, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 38, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 42, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SMALL, 43, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_SMALL, 45, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 60, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 62, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 61, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 92, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_SMALL, 36, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_SMALL, 37, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_SMALL, 64, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6832, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6835, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6838, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6841, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6844, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6847, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6850, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6853, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6856, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6859, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6862, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6865, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6868, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, -6871, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1569, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1570, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1570, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1571, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1571, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1572, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1572, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1573, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1573, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1574, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1574, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1574, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1574, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1575, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1575, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1576, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1576, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1576, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1576, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1577, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1577, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1578, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1578, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1578, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1578, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1579, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1579, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1579, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1579, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1580, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1580, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1580, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1580, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1581, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1581, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1581, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1581, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1582, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1582, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1582, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1582, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1583, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1583, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1584, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1584, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1585, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1585, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1586, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1586, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1587, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1587, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1587, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1587, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1588, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1588, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1588, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1588, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1589, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1589, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1589, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1589, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1590, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1590, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1590, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1590, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1591, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1591, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1591, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1591, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1592, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1601, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1601, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1601, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1601, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1602, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1602, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1602, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1602, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1603, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1603, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1603, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1603, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1605, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1605, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1605, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1605, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1606, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1606, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1606, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1606, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1607, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1607, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1607, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1607, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1608, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1608, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1609, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1609, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, 1610, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, 1610, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_INITIAL, 1610, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_MEDIAL, 1610, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6874, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6874, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6877, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6877, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6880, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6880, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_ISOLATED, -6883, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_AL, UTF8PROC_DECOMP_TYPE_FINAL, -6883, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 33, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 34, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 35, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 36, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 37, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 38, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 39, 0, 0, 0, -1, -1, 0, 8, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 40, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 41, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 42, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_WIDE, 43, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_WIDE, 44, 0, 0, 0, -1, -1, 0, 7, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PD, 0, UTF8PROC_BIDI_CLASS_ES, UTF8PROC_DECOMP_TYPE_WIDE, 45, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_WIDE, 46, 0, 0, 0, -1, -1, 0, 8, 9,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_WIDE, 47, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 48, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 49, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 50, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 51, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 52, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 53, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 54, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 55, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 56, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_ND, 0, UTF8PROC_BIDI_CLASS_EN, UTF8PROC_DECOMP_TYPE_WIDE, 57, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_CS, UTF8PROC_DECOMP_TYPE_WIDE, 58, 0, 0, 0, -1, -1, 0, 6, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 59, 0, 0, 0, -1, -1, 0, 7, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 60, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 61, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 62, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 63, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 64, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 65, 0, 65345, 0, -1, -1, 65345, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 66, 0, 65346, 0, -1, -1, 65346, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 67, 0, 65347, 0, -1, -1, 65347, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 68, 0, 65348, 0, -1, -1, 65348, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 69, 0, 65349, 0, -1, -1, 65349, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 70, 0, 65350, 0, -1, -1, 65350, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 71, 0, 65351, 0, -1, -1, 65351, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 72, 0, 65352, 0, -1, -1, 65352, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 73, 0, 65353, 0, -1, -1, 65353, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 74, 0, 65354, 0, -1, -1, 65354, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 75, 0, 65355, 0, -1, -1, 65355, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 76, 0, 65356, 0, -1, -1, 65356, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 77, 0, 65357, 0, -1, -1, 65357, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 78, 0, 65358, 0, -1, -1, 65358, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 79, 0, 65359, 0, -1, -1, 65359, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 80, 0, 65360, 0, -1, -1, 65360, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 81, 0, 65361, 0, -1, -1, 65361, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 82, 0, 65362, 0, -1, -1, 65362, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 83, 0, 65363, 0, -1, -1, 65363, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 84, 0, 65364, 0, -1, -1, 65364, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 85, 0, 65365, 0, -1, -1, 65365, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 86, 0, 65366, 0, -1, -1, 65366, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 87, 0, 65367, 0, -1, -1, 65367, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 88, 0, 65368, 0, -1, -1, 65368, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 89, 0, 65369, 0, -1, -1, 65369, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 90, 0, 65370, 0, -1, -1, 65370, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 91, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 92, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 93, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 94, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_PC, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 95, 0, 0, 0, -1, -1, 0, 10, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 96, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 97, 65313, 0, 65313, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 98, 65314, 0, 65314, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 99, 65315, 0, 65315, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 100, 65316, 0, 65316, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 101, 65317, 0, 65317, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 102, 65318, 0, 65318, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 103, 65319, 0, 65319, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 104, 65320, 0, 65320, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 105, 65321, 0, 65321, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 106, 65322, 0, 65322, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 107, 65323, 0, 65323, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 108, 65324, 0, 65324, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 109, 65325, 0, 65325, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 110, 65326, 0, 65326, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 111, 65327, 0, 65327, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 112, 65328, 0, 65328, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 113, 65329, 0, 65329, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 114, 65330, 0, 65330, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 115, 65331, 0, 65331, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 116, 65332, 0, 65332, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 117, 65333, 0, 65333, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 118, 65334, 0, 65334, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 119, 65335, 0, 65335, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 120, 65336, 0, 65336, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 121, 65337, 0, 65337, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_WIDE, 122, 65338, 0, 65338, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 123, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 124, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 125, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 126, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 10629, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 10630, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 12290, 0, 0, 0, -1, -1, 0, 0, 10,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PS, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 12300, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PE, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 12301, 0, 0, 0, -1, -1, 0, 0, 11,false, false, false, false, true, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 12289, 0, 0, 0, -1, -1, 0, 0, 12,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_PO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 12539, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12530, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12449, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12451, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12453, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12455, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12457, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12515, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12517, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12519, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12483, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12540, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12450, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12452, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12454, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12456, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12458, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12459, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12461, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12463, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12465, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12467, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12469, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12471, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12473, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12475, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12477, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12479, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12481, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12484, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12486, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12488, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12490, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12491, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12492, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12493, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12494, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12495, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12498, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12501, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12504, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12507, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12510, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12511, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12512, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12513, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12514, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12516, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12518, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12520, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12521, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12522, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12523, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12524, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12525, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12527, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12531, 0, 0, 0, -1, -1, 0, 4, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12441, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12442, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12644, 0, 0, 0, -1, -1, 0, 5, 7,false, true, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12593, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12594, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12595, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12596, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12597, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12598, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12599, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12600, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12601, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12602, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12603, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12604, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12605, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12606, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12607, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12608, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12609, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12610, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12611, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12612, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12613, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12614, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12615, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12616, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12617, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12618, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12619, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12620, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12621, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12622, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12623, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12624, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12625, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12626, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12627, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12628, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12629, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12630, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12631, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12632, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12633, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12634, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12635, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12636, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12637, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12638, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12639, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12640, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12641, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12642, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LO, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_NARROW, 12643, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 162, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 163, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 172, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SK, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 175, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_WIDE, 166, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 165, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SC, 0, UTF8PROC_BIDI_CLASS_ET, UTF8PROC_DECOMP_TYPE_WIDE, 8361, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 9474, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 8592, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 8593, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 8594, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 8595, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 9632, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_ON, UTF8PROC_DECOMP_TYPE_NARROW, 9675, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_CF, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 11, 13,false, false, true, false, false, false, false},
  {UTF8PROC_CATEGORY_NL, 0, UTF8PROC_BIDI_CLASS_ON, 0, 0, 0, 0, 0, -1, -1, 0, 5, 7,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MN, 220, UTF8PROC_BIDI_CLASS_NSM, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66600, 0, -1, -1, 66600, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66601, 0, -1, -1, 66601, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66602, 0, -1, -1, 66602, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66603, 0, -1, -1, 66603, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66604, 0, -1, -1, 66604, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66605, 0, -1, -1, 66605, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66606, 0, -1, -1, 66606, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66607, 0, -1, -1, 66607, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66608, 0, -1, -1, 66608, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66609, 0, -1, -1, 66609, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66610, 0, -1, -1, 66610, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66611, 0, -1, -1, 66611, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66612, 0, -1, -1, 66612, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66613, 0, -1, -1, 66613, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66614, 0, -1, -1, 66614, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66615, 0, -1, -1, 66615, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66616, 0, -1, -1, 66616, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66617, 0, -1, -1, 66617, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66618, 0, -1, -1, 66618, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66619, 0, -1, -1, 66619, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66620, 0, -1, -1, 66620, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66621, 0, -1, -1, 66621, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66622, 0, -1, -1, 66622, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66623, 0, -1, -1, 66623, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66624, 0, -1, -1, 66624, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66625, 0, -1, -1, 66625, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66626, 0, -1, -1, 66626, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66627, 0, -1, -1, 66627, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66628, 0, -1, -1, 66628, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66629, 0, -1, -1, 66629, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66630, 0, -1, -1, 66630, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66631, 0, -1, -1, 66631, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66632, 0, -1, -1, 66632, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66633, 0, -1, -1, 66633, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66634, 0, -1, -1, 66634, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66635, 0, -1, -1, 66635, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66636, 0, -1, -1, 66636, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66637, 0, -1, -1, 66637, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66638, 0, -1, -1, 66638, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 66639, 0, -1, -1, 66639, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66560, 0, 66560, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66561, 0, 66561, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66562, 0, 66562, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66563, 0, 66563, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66564, 0, 66564, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66565, 0, 66565, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66566, 0, 66566, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66567, 0, 66567, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66568, 0, 66568, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66569, 0, 66569, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66570, 0, 66570, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66571, 0, 66571, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66572, 0, 66572, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66573, 0, 66573, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66574, 0, 66574, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66575, 0, 66575, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66576, 0, 66576, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66577, 0, 66577, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66578, 0, 66578, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66579, 0, 66579, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66580, 0, 66580, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66581, 0, 66581, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66582, 0, 66582, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66583, 0, 66583, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66584, 0, 66584, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66585, 0, 66585, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66586, 0, 66586, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66587, 0, 66587, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66588, 0, 66588, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66589, 0, 66589, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66590, 0, 66590, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66591, 0, 66591, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66592, 0, 66592, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66593, 0, 66593, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66594, 0, 66594, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66595, 0, 66595, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66596, 0, 66596, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66597, 0, 66597, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66598, 0, 66598, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 66599, 0, 66599, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_NO, 0, UTF8PROC_BIDI_CLASS_R, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 22080, -1, 0, 0, 0,false, false, false, false, false, true, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 22140, -1, 0, 0, 0,false, false, false, false, false, true, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6886, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6889, 0, 0, 0, 22200, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6892, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6895, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6898, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6901, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6904, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 54, 0, 12, 14,false, false, false, true, false, false, false},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_MC, 226, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, -1, 0, 12, 14,false, false, false, false, false, false, true},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 55, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 56, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 57, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 58, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_MC, 216, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, -1, 59, 0, 12, 14,false, false, false, true, false, false, true},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 22260, -1, 0, 0, 0,false, false, false, false, false, true, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, 0, 0, 0, 0, 22320, -1, 0, 0, 0,false, false, false, false, false, true, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6907, 0, 0, 0, 22380, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6910, 0, 0, 0, 22440, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6913, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6916, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6919, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SO, 0, UTF8PROC_BIDI_CLASS_L, 0, -6922, 0, 0, 0, -1, -1, 0, 0, 0,true, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 65, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 71, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 74, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 75, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 79, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 83, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 84, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 85, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 86, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 87, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 88, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 89, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 97, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 98, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 99, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 102, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 107, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 109, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 110, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 112, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 113, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 114, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 115, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 116, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 117, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 118, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 119, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 120, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 121, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 122, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 305, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LL, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 567, 0, 0, 0, -1, -1, 0, 5, 5,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 913, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 914, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 916, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 917, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 918, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 919, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 920, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 921, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 922, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 923, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 924, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 925, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 926, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 927, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 929, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 1012, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 931, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 932, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 933, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 934, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 935, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 936, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_LU, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 937, 0, 0, 0, -1, -1, 0, 5, 6,false, false, false, false, false, false, false},
  {UTF8PROC_CATEGORY_SM, 0, UTF8PROC_BIDI_CLASS_L, UTF8PROC_DECOMP_TYPE_FONT, 8711, 0, 0, 0, -1, -1, 0, 0, 0,false, false, false, 