dnl
dnl Copyright 2002 Alexandre Julliard
dnl
dnl This library is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU Lesser General Public
dnl License as published by the Free Software Foundation; either
dnl version 2.1 of the License, or (at your option) any later version.
dnl
dnl This library is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl Lesser General Public License for more details.
dnl
dnl You should have received a copy of the GNU Lesser General Public
dnl License along with this library; if not, write to the Free Software
dnl Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
dnl
dnl As a special exception to the GNU Lesser General Public License,
dnl if you distribute this file as part of a program that contains a
dnl configuration script generated by Autoconf, you may include it
dnl under the same distribution terms that you use for the rest of
dnl that program.

dnl VKD3D_PATH_SONAME_TOOLS
AC_DEFUN([VKD3D_PATH_SONAME_TOOLS],
[AC_PATH_PROG(LDD,ldd,true,/sbin:/usr/sbin:$PATH)
AC_CHECK_TOOL(OTOOL,otool,otool)
AC_CHECK_TOOL(READELF,[readelf],true)])

dnl VKD3D_CHECK_SONAME(library, function, [action-if-found, [action-if-not-found, [other_libraries, [pattern]]]])
AC_DEFUN([VKD3D_CHECK_SONAME],
[AC_REQUIRE([VKD3D_PATH_SONAME_TOOLS])dnl
AS_VAR_PUSHDEF([ac_Lib],[ac_cv_lib_soname_$1])dnl
m4_pushdef([ac_lib_pattern],m4_default([$6],[lib$1]))dnl
AC_MSG_CHECKING([for -l$1])
AC_CACHE_VAL(ac_Lib,
[ac_check_soname_save_LIBS=$LIBS
  LIBS="-l$1 $5 $LIBS"
  AC_LINK_IFELSE([AC_LANG_CALL([], [$2])],
  [AS_CASE(["$host_os"],
           [darwin*|macosx*], [AS_VAR_SET(ac_Lib,[`$OTOOL -L conftest$ac_exeext | grep "]ac_lib_pattern[\\.[[0-9A-Za-z.]]*dylib" | sed -e "s/^.*\/\(]ac_lib_pattern[\.[[0-9A-Za-z.]]*dylib\).*$/\1/"';2,$d'`])],
           [AS_VAR_SET(ac_Lib,[`$READELF -d conftest$ac_exeext | grep "NEEDED.*]ac_lib_pattern[" | sed -e "s/^.*\\m4_dquote(\\(]ac_lib_pattern[[[^	 ]]*\\)\\).*$/\1/"';2,$d'`])
            AS_VAR_IF([ac_Lib],[],
                     [AS_VAR_SET(ac_Lib,[`$LDD conftest$ac_exeext | grep "]ac_lib_pattern[" | sed -e "s/^.*\(]ac_lib_pattern[[[^	 ]]*\).*$/\1/"';2,$d'`])])])])
  LIBS=$ac_check_soname_save_LIBS])dnl
AS_VAR_IF([ac_Lib],[],
      [AC_MSG_RESULT([not found])
       $4],
      [AC_MSG_RESULT(AS_VAR_GET(ac_Lib))
       AC_DEFINE_UNQUOTED(AS_TR_CPP(SONAME_LIB$1),["]AS_VAR_GET(ac_Lib)["],
                          [Define to the soname of the lib$1 library.])
       $3])dnl
m4_popdef([ac_lib_pattern])dnl
AS_VAR_POPDEF([ac_Lib])])
