/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.NeighbourSelector;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.sphgeom.EllipticalCone;
import java.util.EnumSet;

public class NestedEllipticalConeComputerApprox {
    private static final EnumSet<CompassPoint.Cardinal> ALL_CARDINALS = EnumSet.allOf(CompassPoint.Cardinal.class);
    private static final double SQRT3 = Math.sqrt(3.0);
    private final int startDepth;
    private final HealpixNested startHpx;
    private final HealpixNested deepHpx;
    private final VerticesAndPathComputer[] hcc;
    private final double aRad;
    private final double bRad;
    private final double paRad;
    private final double sinasinb;
    private EllipticalCone ellipse;
    private final NeighbourSelector neigSelector;
    private final FlatHashList neigList;
    private final int deltaDepthMax;

    public NestedEllipticalConeComputerApprox(double aRad, double bRad, double posAngRad, HealpixNested deepHpx) {
        this.deepHpx = deepHpx;
        this.aRad = aRad;
        this.bRad = bRad;
        this.paRad = posAngRad;
        this.ellipse = new EllipticalCone(0.0, 0.0, aRad, bRad, posAngRad);
        this.sinasinb = this.ellipse.getSinA() * this.ellipse.getSinB();
        int optimalStartingDepth = Math.min(this.deepHpx.depth, Healpix.getBestStartingDepth(aRad));
        if (optimalStartingDepth == -1) {
            this.startDepth = 0;
            this.startHpx = null;
            this.neigSelector = null;
            this.deltaDepthMax = this.deepHpx.depth;
        } else {
            this.startDepth = optimalStartingDepth;
            this.startHpx = Healpix.getNested(this.startDepth);
            this.neigSelector = this.startHpx.newNeighbourSelector();
            this.deltaDepthMax = this.deepHpx.depth - this.startDepth;
        }
        this.neigList = new FlatHashList(-1, 9);
        this.hcc = new VerticesAndPathComputer[this.deltaDepthMax + 1];
        for (int i = 0; i <= this.deltaDepthMax; ++i) {
            this.hcc[i] = Healpix.getNested(this.startDepth + i).newVerticesAndPathComputer();
        }
    }

    public HealpixNestedBMOC overlapping(double ellipseCenterLonRad, double ellipseCenterLatRad, Mode mode) {
        this.ellipse = new EllipticalCone(ellipseCenterLonRad, ellipseCenterLatRad, this.aRad, this.bRad, this.paRad);
        long[] mocElems = new long[this.nMocCellInAreaUpperBound()];
        int mocSize = 0;
        if (this.startHpx == null) {
            for (int h = 0; h < 12; ++h) {
                mocSize = this.buildMocRecursively(mocElems, mocSize, 0, h, mode);
            }
        } else {
            long centerHash = this.startHpx.hash(ellipseCenterLonRad, ellipseCenterLatRad);
            this.neigSelector.neighbours(centerHash, this.neigList);
            this.neigList.put(centerHash);
            this.neigList.sortByHashAsc();
            for (int i = 0; i < this.neigList.size(); ++i) {
                mocSize = this.buildMocRecursively(mocElems, mocSize, 0, this.neigList.get(i), mode);
            }
        }
        return HealpixNestedBMOC.createPacking(this.deepHpx.depth, mocElems, mocSize);
    }

    private final int buildMocRecursively(long[] moc, int mocLength, int deltaDepth, long hash, Mode mode) {
        double rCircumCircle;
        double cellCenterLat;
        int depth = this.startDepth + deltaDepth;
        assert (this.hcc[deltaDepth].depth() == depth) : this.hcc[deltaDepth].depth() + " != " + depth;
        VerticesAndPathComputer vpc = this.hcc[deltaDepth];
        double[] center = vpc.center(hash);
        double cellCenterLon = center[0];
        if (this.ellipse.containsCone(cellCenterLon, cellCenterLat = center[1], rCircumCircle = Healpix.getLargestCenterToCellVertexDistance(cellCenterLon, cellCenterLat, depth))) {
            moc[mocLength++] = HealpixNestedBMOC.buildValue(depth, hash, true, this.deepHpx.depth);
        } else if (this.ellipse.overlapCone(cellCenterLon, cellCenterLat, rCircumCircle)) {
            if (depth == this.deepHpx.depth) {
                if (mode.isOk(this.ellipse, vpc, hash, cellCenterLon, cellCenterLat)) {
                    moc[mocLength++] = HealpixNestedBMOC.buildValue(depth, hash, false, this.deepHpx.depth);
                }
            } else {
                mocLength = this.buildMocRecursively(moc, mocLength, ++deltaDepth, hash <<= 2, mode);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, mode);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, mode);
                mocLength = this.buildMocRecursively(moc, mocLength, deltaDepth, ++hash, mode);
            }
        }
        return mocLength;
    }

    private int nMocCellInAreaUpperBound() {
        double oneOverR2 = 3 * (this.deepHpx.nside * this.deepHpx.nside);
        double r = 1.0 / (SQRT3 * (double)this.deepHpx.nside);
        return (int)((double)this.deepHpx.nHash * (1.0 + ((this.ellipse.getA() + r) * (this.ellipse.getB() + r) - this.ellipse.getA() * this.ellipse.getB())));
    }

    public static enum Mode {
        OVERLAPPING_CELLS{

            @Override
            public boolean isOk(EllipticalCone ellipse, VerticesAndPathComputer vpc, long hash, double cellCenterLon, double cellCenterLat) {
                return true;
            }
        }
        ,
        OVERLAPPING_CENTERS{

            @Override
            public boolean isOk(EllipticalCone ellipse, VerticesAndPathComputer vpc, long hash, double cellCenterLon, double cellCenterLat) {
                return ellipse.contains(cellCenterLon, cellCenterLat);
            }
        }
        ,
        FULLY_IN{

            @Override
            public boolean isOk(EllipticalCone ellipse, VerticesAndPathComputer vpc, long hash, double cellCenterLon, double cellCenterLat) {
                for (double[] vertex : vpc.vertices(hash, ALL_CARDINALS).values()) {
                    if (ellipse.contains(vertex[0], vertex[1])) continue;
                    return false;
                }
                return true;
            }
        };


        public abstract boolean isOk(EllipticalCone var1, VerticesAndPathComputer var2, long var3, double var5, double var7);
    }
}

