
//The besselI_ref data have been computed using Maple V Release 4 with
//the code:
//a:=array(1..100):for i from 1 to 100 do  a[i]:=-20+i*0.4: od:
//x:=array(1..100):for i from 1 to 100 do  x[i]:=-20+i*0.41: od:
//
//writeto(foo);interface(prettyprint=0);
//for i from 1 to 100 do  for j from 1 to 100 do
//     print(evalf(BesselI(a[i],x[j]),30));
// od;od;
//writeto(terminal);

//these data gives a discretization of besseli on for alpha in [-19.6 20]
//and x in [-19.59 21] (singularity at zero is excluded)

alpha=-20+(1:100)*0.4;
x=-20+(1:100)*0.41;
besselI_ref=[793.128361081245143984721169211+2440.99809976653814305745716181*%i
444.999938630246914972367992709+1369.56898516630901384401704435*%i
248.080743824571646485602408025+763.514021159075566933147221244*%i
137.368863193897285033628728290+422.777888772337273698938881389*%i
75.5230878945943252088963711516+232.436164289832624115187225635*%i
41.2086884787256711706121724363+126.827302119557535772424406507*%i
22.3060617958100639145532298350+68.6509991681785025163971300509*%i
11.9721867954640045504593815779+36.8466022043865195531540947396*%i
6.36813127386630681985675397945+19.5990927841492075122233056366*%i
3.35489662830754689306021051775+10.3253101218669022950094024862*%i
1.74923296681963022744158436194+5.38358550466500222874779421394*%i
.901531991566872837801053253155+2.77463016868218391652083785261*%i
.457894829091231346473581839400+1.40925537725175901291766580023*%i
.226830082519489828827139881385+.698111210706338071587076813963*%i
.104893200211191602048772488138+.322828075451612207021660608103*%i
.350326997992997314915103098157e-1+.107819563435107587580992549496*%i
-.176735646229690720868764981495e-1-.543936388833148775576672766804e-1*%i
-.826049788287577762434178124131e-1-.254231983429978153714083322557*%i
-.200600096275514581722462683325-.617383613862922093798876307772*%i
-.452492808568406308346460714493-1.39262966762117753786504817292*%i
-1.02219586431384405578919761501-3.14599538336734695500200327691*%i
-2.35108101121294167814680330767-7.23588332277541795110703672890*%i
-5.53327017185386438106253692291-17.0296545146575236003849506684*%i
-13.3619970086473230820761916022-41.1239982172988483297254824332*%i
-33.1912621313771077493402676851-102.152201039807737282945937544*%i
-85.0390876653101799894111783960-261.723400123928296416736454792*%i
-225.417563850510609773051556731-693.763925252868027806259798540*%i
-620.372818608562279062961120625-1909.31121074258182083454744523*%i
-1779.76949045582306581083082906-5477.56726074267593442403688981*%i
-5347.45637365896722256299416080-16457.7784469730837978846632433*%i
-16918.6880454737860589583434477-52070.3676681584363657107850576*%i
-56728.3944705549894971440424901-174592.045752410766581882547587*%i
-203116.007868516268246938848389-625126.793553691750895730934165*%i
-783692.420543535299971679690334-2411957.26091586394776999680155*%i
-3294491.98013113242227119770718-10139403.7306054882864495124249*%i
-15294791.6977419933571005498259-47072528.6126652773153448398746*%i
-79748838.2166698535244859628123-245441686.488297502405010889961*%i
-477088872.289644147094329193453-1468328568.01534473529780629870*%i
-3366315038.47042741417735834537-10360452374.8459142785826172008*%i
-29058356236.7987601900570244929-89432424607.3693936225481024028*%i
-322561241042.179040317004586191-992741421286.333110020041814342*%i
-4941095219028.80525143110072069-15207127411220.3068006672376729*%i
-115956994099316.136898516187152-356878931759793.275258729768752*%i
-4914409423951760.79071996988525-15124996979035254.6409320014367*%i
-498390286143211616.630064827904-1533887578751026210.26408451848*%i
-208528127256811688393.056423291-641783584296275568309.850540953*%i
-1311728623362554154294707.01369-4037085589364491407436908.38944*%i
-.138211704653255325295486511024e32-.425371888056252279635021554179e32*%i
-.281124879809572008784867117560e43
-7092975849124798651667206331.09
-56241400438568386419498.8900437
-37904131992746318104.2073795779
-185757176061073669.467094091142
-2813868835128804.82110805440954
-88317916579714.3226219787447671
-4611133640285.54842915383738519
-350383930826.571373916056002588
-35506111163.1459946395432405674
-4517510304.51366408002215553412
-691043037.234469341331652901817
-123064100.681624999703191926469
-24894323.6158618988530719948577
-5611490.59470144271642823548345
-1388152.49249187308224619618517
-372237.608482697431836290828372
-107111.752201461387282218081084
-32797.8681769924709211776747803
-10611.8643456292127129629219684
-3606.53433044686276405633634078
-1280.95446496374041568167516715
-473.395347658515296615262474983
-181.349536423766368777347620525
-71.7756730068903665132027069013
-29.2648576130401755035954058174
-12.2601459159520517295390649763
-5.26420722564897396121096623704
-2.30902379402993070425922879314
-1.02640386811727213041058891097
-.448194018438013545266365477991
-.163374057668419829197820991588
.167812907345519662495152298984e-1
.200069436067477941051878402591
.483373630606023632988928144221
1.00367006994724262762942490948
1.99936176396721661172525920835
3.90888084504894590862398122022
7.54424066675576866340677648822
14.4020378625143912989387686347
27.2201575230020314001079639886
50.9688586635066243276775640214
94.6041824471105020756482548634
174.150996008335566572069913836
318.092195966329337255654872295
576.736867156699413794251456731
1038.41975209948807747260248621
1857.37453455681852980696730705
3301.46825066568425857213942195
5833.58514995877211203860977042
10249.7948658276211087246898349
17912.9850935857314014795943289
-2961.33535454467598304985279117+2151.53607476254055859985079998*%i
-1671.67030845611898765651774852+1214.53957189721010013924017281*%i
-937.811627501189949239154802608+681.360030637536369854883060758*%i
-522.675415623688160209328361959+379.745917793487095865678692426*%i
-289.293275762439322948727987485+210.183867907394661383465482550*%i
-158.949975045538966412146469033+115.483916695974908458894408435*%i
-86.6584637707961857521490540977+62.9610593410952395052756334683*%i
-46.8583958028496198224124733046+34.0446173448781549027581646480*%i
-25.1171348473610993280110392180+18.2486666482532773285699963513*%i
-13.3388414256484235063483843904+9.69123557005323766037760557252*%i
-7.01387879489735635460726633281+5.09588123076791939029730634466*%i
-3.64877881293625321888112790622+2.65099298288310520336797989870*%i
-1.87555568804436720989131714445+1.36267097100658856886894366134*%i
-.949635095227255291696070729802+.689950282769021679518084659694*%i
-.468605330673852649099154894739+.340461701584568986883746912442*%i
-.215364820957924007381339574369+.156471701462192036185782172729*%i
-.702628582023758032289423079627e-1+.510489546232363228494986044070e-1*%i
.401709586153200759645227074985e-1-.291859098247733794458646144409e-1*%i
.178603439443747080019361259683-.129762994403912389969280853414*%i
.434003777510343129621769669340-.315322201676240888272266710606*%i
.985517534689861442129865642368-.716020401047182875186212337193*%i
2.24632272522325400964688695240-1.63204899149959461236930142481*%i
5.22125008983628838495632388052-3.79346023961787459530651262054*%i
12.4372282846228311976875926041-9.03617527928964986657494603533*%i
30.4497137455346080140281811300-22.1230120017203002589405309125*%i
76.8327009071834652784692646296-55.8222247505848595658232192754*%i
200.411478072485098649757412394-145.607461920074273881412567697*%i
542.254032957020918816248377138-393.970615925696255702679123113*%i
1527.91677476535903282126745575-1110.09651611982154602088530122*%i
4503.98434014862651392847504627-3272.33616858814034927992739377*%i
13963.9378176850146092448672427-10145.3946829705326992097004664*%i
45819.7730876483252448393997155-33290.0137717320143736308976507*%i
160309.254639430888187385494819-116471.491128387245607057709020*%i
603379.780051148376320177867871-438381.070745679960787243401268*%i
2469640.57972863835580840646871-1794298.91006066992637754272293*%i
11138771.7425724582361260195623-8092791.38072327271437699954679*%i
56281300.8514233404132592147062-40890758.6000233837739668311664*%i
325306063.126815577624604487369-236348689.479628103042686743518*%i
2209845563.60827243663050262082-1605546782.28538578773535255100*%i
18286408153.4869514547947553865-13285853207.9722530725286358106*%i
193558575016.527979576919072949-140628536409.623525499299902862*%i
2808229358835.84984522251525525-2040298057587.47208073739371919*%i
61866332742380.0901322348725440-44948521789069.6617721446572554*%i
2431403671939650.33006534923614-1766518170412550.69189280059382*%i
224578829398331387.604326888626-163166070447548346.810737471322*%i
83125452048758409692.2594846289-60394176073093340302.5163952316*%i
437601420402207566252715.845561-317936042237756593248446.070805*%i
.331562637881866599856762868478e31-.240894357118817394287581583034e31*%i
-.155093598917464039693081192235e42
-776932065188794281484916119.712
-7826456501562336020054.15771693
-6119158210552901225.09184051992
-33402584161338834.2720895791702
-550660144300965.260492099503685
-18528305129266.3630830436659607
-1026149284095.07498731686979750
-82064837819.7990646701039219228
-8699530818.60792701658391674096
-1152329825.31723263533099870737
-182792424.448494576188750719463
-33646289.6520953694536036139841
-7015446.23688829450934145023718
-1626111.44906853837428860655506
-412791.711939549048521629312281
-113383.850174003530234644769992
-33366.5878782414669754647508441
-10433.8951700762267983451017031
-3443.22257443956490350230609399
-1192.16612256728855146025184782
-430.924409241327157527749574667
-161.919735733384778121527552007
-63.0119724497478999082897988296
-25.3142633016174277994378946420
-10.4683564590506090477295697450
-4.44404863467677302373779033479
-1.93016290442558700192857420448
-.851064771156119871186358834928
-.369818653652347080794233426453
-.135754741899531404417730358957
.979438342775621619785863508565e-2
.155707072013865458946644859013
.380317410449208717398574143710
.793450021509836094414950938703
1.58610740718565483876188160034
3.10995469305135378557150110871
6.01713711453830054806618762451
11.5108822955115715587868594563
21.7941811653644152745148978700
40.8686129961511270332252533131
75.9474845105644207857335179295
139.940002502784137749795480653
255.792102701944193405906738416
464.028693776795406991682117062
835.788427509435744203913684045
1495.23721750363731531650361226
2657.92486325987755613073302806
4696.12902697219619950330824250
8249.69838300123666033171297487
14413.3131623872074844178875833
25051.6278481811481517325604420
-4198.78556633095043403262918822-3050.59627991450962330539663855*%i
-2384.55389153309941274497910631-1732.47981251947916433515270014*%i
-1346.10092201225636051359106395-977.999566829131876598314132777*%i
-755.072565158869769341716708087-548.592330318017821704921842102*%i
-420.710134267326541091509783868-305.663804508058231990995034324*%i
-232.750770461529229670652353030-169.103333166314923593334600830*%i
-127.799954771188696211680781758-92.8521022184302178856327333266*%i
-69.6153329843161963276413462505-50.5785000143600734879327024127*%i
-37.6011764878155940585429278488-27.3188538214332785218020456838*%i
-20.1275928962598199663997901427-14.6235522255113530720802347606*%i
-10.6716981658715730174295468236-7.75344256354250573959795039224*%i
-5.60121712301192328072841064887-4.06952244845999720039467466367*%i
-2.90902839098507661504203761452-2.11353284122566494343706908787*%i
-1.49527170137583669365247785837-1.08637848197247745049522912096*%i
-.762955812214342422262781552311-.554319844562591740381009041669*%i
-.392083856861119468909054190470-.284865596553969800669288616041*%i
-.215100425422827854109990471042-.156279606861729946870645803874*%i
-.150241615569667870212479616561-.109156923187596082702370409038*%i
-.169618423077515605370475100962-.123234997899021032897202922982*%i
-.292458479112654611541281609008-.212483522751111114795745405975*%i
-.606751373015555343298747314146-.440830676421445287321833912851*%i
-1.34299825726072708092191091643-.975745348937002668906051195443*%i
-3.07049125563383267744010284504-2.23084247908655958906082231726*%i
-7.20946275102817444166381352535-5.23798129269249356524729551261*%i
-17.3955189326043097907428359239-12.6385843012594522511515743986*%i
-43.2302625401571837588541815967-31.4086242322612543102273130466*%i
-110.968563115359554117970554381-80.6233803749557758826684805080*%i
-295.205615015257715570772244389-214.479433814562662860091714077*%i
-817.026844624960656062934185746-593.604749142062114644070391947*%i
-2363.06366107151154754218149680-1716.86624615249930318321703580*%i
-7179.68745235487157781022650565-5216.34827192227743445477955807*%i
-23056.2364522965136800462053155-16751.3363183408623074870160581*%i
-78828.2303159482512403713139211-57272.0617319378703214238821147*%i
-289447.147800572208225476164475-210295.662486969065142807015987*%i
-1153548.97119407193968009630945-838102.385709324250078445173129*%i
-5054874.79973161742525003268680-3672581.51574760165268724135861*%i
-24751660.8781302298169564550638-17983134.2667281279141234648138*%i
-138230926.487856786311487638285-100430646.779010671052830077814*%i
-904081472.856701159665601957445-656853638.812117719900168382198*%i
-7172012208.18459564291083506640-5210771880.61974674814719558042*%i
-72390748640.7479997165141649792-52594957521.6496940683299500692*%i
-994777267239.021437536094022312-722747990542.103102894740477565*%i
-20573467902812.3984918642598531-14947499379946.4703239234718244*%i
-749805302526688.386761500852857-544765440009564.588656604071576*%i
-63078583885023389.2060973199007-45829273798823111.6235810984045*%i
-20654922734322032879.2209098841-15006679779149730818.1266611958*%i
-90999295207767931749652.0364862-66114857986957835208900.3925105*%i
-495807857802657027723725386120.-360225494412864931391117379390.*%i
.139634053457759140110747737713e41
138879804724426422829898845.957
1777347663756962247248.26642633
1612091664330645548.30962213822
9801675753368890.88379317302730
175849143722395.130066326231055
6342910790619.61166724410257087
372620605953.437911616245110470
31362399926.9816092484648475959
3477858521.20788339509806723143
479579230.833157773593709291485
78885697.7730649010026477753747
15007543.6565385654485558835808
3225189.53092265701165948093094
768677.973175314472869727631887
200227.052730479111478354454405
56331.9791066988013330372685402
16952.4788205255440212155531188
5413.36170542070446063843834942
1821.92460983628435993362161297
642.609046485677165570945921948
236.375650624145587122856796900
90.2985302569054590268069464021
35.6950939546546099943770523208
14.5554386303844675731915481370
6.10640423551578483687046868259
2.63099741860545628042097703417
1.16550240059505626105724250796
.537888251283537071238754824543
.274723346281501781163418870380
.186254647678194658173725284904
.207343401614341363973554212779
.340701816174352917209196806649
.647273151176444162853562486786
1.26772468171101800431174363953
2.47840339954605777244390072232
4.80040826683674827238119734011
9.19995671838342123108906041249
17.4493595886159349717479484278
32.7707144901400746458442055259
60.9749534218193085756927748798
112.463910704380109926404789592
205.727521130921395242734754230
373.417336307418332767155719550
672.836854254431813642750144080
1203.96767686990811084432403386
2140.29481203750403247264848063
3781.27741587586349525718671316
6641.27705078185012819491835034
11599.6555148867128186913535544
20153.1307267435859466888619677
34838.4870305335631245655630770
2260.60577505715238366622611172-6957.42917793670197925866667628*%i
1291.52161576840964274582865270-3974.89481475641751980738156007*%i
733.584913208481989844730656798-2257.74221050188212102014649533*%i
414.122245800671279665496462264-1274.53721827876971363183919859*%i
232.264644692332965203989237071-714.837073237452766409822455142*%i
129.374671859056764969730574106-398.174297708069541345532609964*%i
71.5400841683532752679061979328-220.177739293072854862733057877*%i
39.2547354405486794217303078065-120.813653021546638856302778892*%i
21.3633921898351056321713532356-65.7497604408738905205019247354*%i
11.5255298538953126127050498552-35.4719334885555072729114065227*%i
6.16063956096946165192793556954-18.9604989552662929309604708694*%i
3.26076365498442643997622205745-10.0355986195649771712158950714*%i
1.70814572554454632654842281159-5.25713197860472893983948637661*%i
.885531748746148498554604807499-2.72538648476203407821055768144*%i
.455093810850129885283790225103-1.40063472952379346108978523484*%i
.233984599832298411980253584431-.720130550856404380692528164288*%i
.125039604621761348303116320089-.384832332639297629781431491804*%i
.790294790729788189870473292635e-1-.243227726694443117857035692960*%i
.755116105876771256094487932511e-1-.232400840771282451248734838074*%i
.116166142887509559535513859026-.357522625542036326117074980921*%i
.230179390882322106408455396460-.708419321915550372678149239511*%i
.498990256970834352867262308072-1.53573409908998611735718432802*%i
1.12400593360985509395209509172-3.45933455755835186798627456775*%i
2.60233046793005579402473188358-8.00914963943790645387845900649*%i
6.18905219282708322438185816834-19.0479440445823159828869863591*%i
15.1494677249090264459249895141-46.6252674139203512812400666652*%i
38.2716465779134816649474111672-117.788016613433946615306952416*%i
100.109994801042702580964794088-308.106882905869333387599589719*%i
272.166388058056174245856417158-837.642011898730973270116129820*%i
772.405478313786989704426383424-2377.21962463031942657652553490*%i
2299.97757783483641560560664478-7078.60312717449103774839586922*%i
7228.90500212733853196855603060-22248.2819168511499759455828097*%i
24153.5404351091881946853107572-74336.9537616323554495897137738*%i
86526.6326334183706331688326837-266301.592783082762113024094002*%i
335788.130257202006744952061242-1033449.60047145020421259250965*%i
1429665.01785294900209453317301-4400056.48912138588956136779920*%i
6784498.97593880870968812356534-20880540.8062292372154672785008*%i
36611075.8083924049041625147886-112677305.293764486616558655160*%i
230550940.717176510015378151594-709562834.725521954823911485992*%i
1753416864.80194165714208956341-5396462218.60638287550137896457*%i
16877240644.1376587221283616221-51942805683.4075416597016435013*%i
219675316787.374023543611864895-676091106000.259608449318409329*%i
4265160128025.81909771734720432-13126813109441.3595729285347371*%i
144153546432121.732421357082995-443658996679569.543357933546248*%i
11045596346103532.2195985887342-33994850032685973.5528802582641*%i
3199734723431571640.94596389080-9847770881633360582.97915877618*%i
11797850334151491138836.1744001-36310049747475606556072.5637598*%i
46224201926359600995523102179.2-142263465287821578994500962573.*%i
.205197882868290392084329645030e40
40520772585914100724801357.6144
658807621943924697433.808219864
693204224095026744.163493431816
4694468191648547.19533925847967
91654350934730.6525430543045639
3543938767657.33071156410680303
220828182403.358518357300029820
19560393033.0260265755534287498
2268961778.10114692087548450439
325705085.052599252033552648326
55551885.7398033590980931962012
10922470.3028344370557267135208
2419195.55438665476430598785244
592829.807755696508582089295672
158445.706698194849034571278082
45656.0265756803396294330764222
14049.6744029556917102476289523
4581.10957816664035287216513412
1572.35046427826945602774576621
564.911462372534731775204445390
211.444820689603450071323500086
82.1150456798983440991461762196
32.9702515250360180669954965424
13.6450238132662819198877683397
5.80637172853831694809845048282
2.53736089822536381474085754328
1.14257638720078508913533203184
.542290935981946916417382445322
.297098746151506611338688598654
.233722348366166860987467060327
.301993604810403125230086472183
.527549870930350128683200852486
1.01264244281653469439153291624
1.97416459834345001715599557087
3.82847770205909925265012740893
7.35158135167398786896826636777
13.9695882918354120758636947365
26.2775569577683256441999285071
48.9578692022923820703231833176
90.3941915534975818882790162163
165.489707390249893340743598408
300.559026996441250863829029985
541.772448921367410138620979099
969.656026874526964953692576446
1723.86773369999367130615237428
3045.33546543533542031600132915
5347.60814201301714102211039062
9337.16994785023514207219538136
16215.5180617581310907336295554
28017.3003907817464441155674843
48174.1156785556651554114370475
10250.1904440162205299419041874
5890.80017855371388391427792432
3366.45695743226231564723309434
1912.44915628913913883760502583
1079.63265624679495810527149171
605.440159228294949651932078192
337.134210691495713555864218636
186.330662624450060300181507300
102.167806796041956686266265768
55.5486644968294300532738760016
29.9313287886105668326685960864
15.9739979698860637094420554254
8.43832083835647052776689509355
4.40907228575611547262704962088
2.27694540555625175854822718529
1.16119627973675995140056682396
.584256613617081006256650766136
.289736555705926688483495312196
.141453978221951020421479681466
.679043148552668378426298796435e-1
.320072323787846437879999331489e-1
.147909786846292854100695919880e-1
.668950546856595923346096534481e-2
.295527518232993204744552090889e-2
.127250713146160834543114459895e-2
.532730007787106502443488049678e-3
.216230597425211052170941428932e-3
.848189632546470140744669530732e-4
.320351725697221111610711935946e-4
.116000003835424639971765102864e-4
.400695785735180778474068259273e-5
.131263866597976058928147651085e-5
.404969362365623466089924360017e-6
.116686148157616058975050466631e-6
.310844265857065989894817098037e-7
.756136710486742572154360010490e-8
.165376770226978505581928342004e-8
.318898698709146369906491345603e-9
.528598925111382463683545534167e-10
.728300075408178162129132019332e-11
.796725382116146304971045776081e-12
.648600093514446145126692874711e-13
.356966513104921460134840506433e-14
.114196589301805234215161608373e-15
.163986329546763741289334396739e-17
.640958108699032191594506491419e-20
.207957798257386711790592383785e-23
.738590644894258642186279689572e-30
.894397371506044641080355315535e-40
.228038207543690877232297756357e-26
.110304930915879627127801968190e-21
.902403754228933205883198325840e-19
.119408364338345381915965091360e-16
.560657164243404647794223724617e-15
.134871798004628760587303731237e-13
.203373283272752074541439720789e-12
.217327647656837717155332752671e-11
.178337160417713812870741364643e-10
.118774451602617213859222683054e-9
.668112568927192054864719670804e-9
.326941498422933147001950079675e-8
.142361029553494686403145394576e-7
.561393114263992343202616773952e-7
.203322580589536704243851935214e-6
.684017298785212903681518892459e-6
.215746700221017827317221137932e-5
.642928056478861127725194693265e-5
.182191060997951791676580534256e-4
.493642999463624064612410727135e-4
.128483533697613768808342170528e-3
.322533224390738440783852339949e-3
.783617912009660436744735333322e-3
.184821911303767370901641012016e-2
.424302280485880169127559875048e-2
.950355961834429849412350117474e-2
.208106525443521226497050027278e-1
.446347452017322456129478692619e-1
.939208296401627411469312057490e-1
.194174158708099996131122745467
.394944513428869507126553785698
.791250304949817394626389524071
1.56312360348817363062436977864
3.04788953175146371268402932431
5.87107833008446494624729323201
11.1815329878441502243948174364
21.0703268528268928680813475275
39.3117241151995713869366790153
72.6647725540744466078602461752
133.145048807898397910528287048
241.965809389001166989691375621
436.336682725108919914930504272
781.129438274233410660509794402
1388.79490920112305605378479456
2453.20659085592610084502976581
4306.91272781131491323459826852
7517.57983187508245799751750599
13049.8082595662991653279844189
22535.6057055756779643571586994
38724.8628054800104380919297164
66233.0735153786837641972864036
4411.53011793630541923535491171+13577.2936177253712670941877363*%i
2550.16520421593089305113250391+7848.60146609253863182838002140*%i
1466.18254539622032904978322954+4512.44588245965592861109783799*%i
838.135305297340317613714609325+2579.51523103897924947372875680*%i
476.213971728868534764547223180+1465.63590096278023597915553262*%i
268.841592724866461292521763985+827.409344037295882320891098347*%i
150.740279357356351241902830861+463.930876167334328921366682122*%i
83.9111066236206097943704583972+258.251831441674513047262873844*%i
46.3522409987967629077313223887+142.657529033176621961814197761*%i
25.3963024957034833720673316797+78.1617820961494124328412701898*%i
13.7939039049511010625351263466+42.4532709616454451242578643497*%i
7.42278081978760085209103969900+22.8449703291205305744090328231*%i
3.95478330651354701454586585532+12.1715714755522577450379943977*%i
2.08453113346845272859088411618+6.41552715220512784555094411389*%i
1.08570139821789654734925638478+3.34144531958337420675895574762*%i
.557359106823366303973393452400+1.71537494736497792058378371843*%i
.279828263799098625779482727384+.861222840730819771366966682900*%i
.133202289848141169724661383093+.409954494579670462639553975623*%i
.511976683905483331723660154591e-1+.157570221147348456996490876949*%i
-.574367800142883525494320985407e-2-.176772232278331878542424445132e-1*%i
-.682687413681602811439538211375e-1-.210109581412462082467999445995*%i
-.175007672555452453728329391998-.538618232703273426517183942824*%i
-.399192720378812039477942970458-1.22858886367007410004633653989*%i
-.906631989985066391681114887240-2.79032634985347805065291753642*%i
-2.09892826661303058405004650007-6.45983697186671529868321853495*%i
-4.98724949804483861208444126566-15.3491756759181459282335458416*%i
-12.2068495741217171429090937023-37.5688199750491620074305273416*%i
-30.8787584814461130888331521777-95.0350466267574296971616611572*%i
-81.0227134367135543345538423392-249.362271281441503775473002822*%i
-221.440832750849632148805202750-681.524805415668595034468743216*%i
-633.470382045882569304981946428-1949.62136611073100206624729805*%i
-1907.64989790820680315832607481-5871.14268548614095079306045004*%i
-6088.70828416803598691982908042-18739.1172488465489426250693007*%i
-20765.4924497427006594323736393-63909.6142539101329133191470806*%i
-76425.2272197671264887974320152-235212.663639155347280840248861*%i
-307236.147525253767398073491901-945575.633263620991914666594741*%i
-1369645.17802402946477340898059-4215334.41617602465189874479393*%i
-6901747.01973343909672993413254-21241393.1803819742852855164332*%i
-40297790.6507261143972432201643-124023846.870274604303979132446*%i
-281726470.787932498562755508282-867064921.130504791693573531426*%i
-2466296834.75645514486441880557-7590481166.11737831586757830316*%i
-28803580960.5310492459713950152-88648306933.9209826112043308961*%i
-492931628285.054747266454080387-1517087557325.90448389713100803*%i
-14328796427427.2512026987990022-44099500872228.4366203531931080*%i
-910883936565252.931678837982222-2803412495844266.78329862672533*%i
-206526750788339665.738136006427-635623980887569276.603787108075*%i
-533371238838505218057.532057180-1641547880976037635743.84069033*%i
-1080655255136896898728972979.09-3325914888096750776952723027.84*%i
-.173897365143658595910904131252e38
-1353652290250827167758474.15340
-35519884924486837323.5690015984
-50295162233272480.3450198469268
-422528098233033.736585498610588
-9768869273362.06441924751747303
-434019423432.983367933206470709
-30423808613.0930056202694170636
-2984339117.83841544651383913259
-378735748.519939666693391922915
-58907510.4496047978044636192558
-10800697.2614549665185026186947
-2267904.00908749251958179425957
-533468.318030857521251097384642
-138174.588019483645439631254279
-38872.2628084322178094104915727
-11747.3977871430975545204405825
-3779.20099706046109023862076402
-1284.55584044204959877820556307
-458.423760645216314637661024234
-170.855796590311589531807777636
-66.2013717807194646142897117808
-26.5630305437751401479014900698
-10.9992618355655511606653284020
-4.68475484371560568740614813662
-2.04328552122845379605231630147
-.902510470563739088267310897920
-.385938328075924186668893412249
-.123206749158667594841316676365
.587483591122446815732799115160e-1
.265871955662089789729009260255
.603710669712119051317994460014
1.23003516529432439852611551934
2.42203686690690216210792254541
4.68584960989194329480586109416
8.94801694911695645455636294264
16.8943497502287443368344646631
31.5681643516224213348055152094
58.4203845362834081207573352794
107.141325131163675050336501231
194.836677437014349505924482019
351.502505143866048315464057990
629.412440180724793682173429661
1119.13071132036647594020514070
1976.69690820160637961177424562
3469.56813876659038415822645757
6053.93000397705230860843341610
10504.2702902683702386461314089
18129.7170335224424589934077567
31133.9346291632434004991484092
53211.7894020197620508617632978
90535.3345249031871897675549088
-15988.1093528689612090955497898+11616.0413872595695595151926994*%i
-9295.72241535928033632299163015+6753.73766329123087099747030878*%i
-5376.42695425192909475886480218+3906.20283097835932480991364824*%i
-3092.42153611180610660731311024+2246.77576050489301833609419578*%i
-1768.30773818918025738813411280+1284.75077439540886246296873567*%i
-1004.89403683485037741772404255+730.098253899504433979333939521*%i
-567.313469072812996653976692503+412.177361991652673434896527152*%i
-318.046311649135560149838070238+231.074171288343808872184485850*%i
-176.983043507604304071595622185+128.585707844097604205534471734*%i
-97.7103469062582908069449301220+70.9907224535536916444078534814*%i
-53.4924832822771466665142511200+38.8645640331901428348574878325*%i
-29.0230910557005614380001389480+21.0865099461384641976672887597*%i
-15.5963968813057825691151573811+11.3314456179188297128443550607*%i
-8.29529404347631384448600171792+6.02688390489509309353068012696*%i
-4.36315120048544291055854379968+3.17001490327031887516735356573*%i
-2.26670001046594506063900144577+1.64685395583370570238113464225*%i
-1.16007744093145059821810725757+.842845596616325835127234526287*%i
-.580233287549118406421742960693+.421564159568797975620286941040*%i
-.274695505407418372692162082190+.199577966930416025709896346545*%i
-.104013834869389738825267833594+.755704745335385769636545619504e-1*%i
.151965661830300354427271635691e-1-.110409516116194197077987254501e-1*%i
.148284823796153513964464740279-.107735230745686868732226087348*%i
.379456342981618770178809420592-.275691170697534580974998764863*%i
.871603083297759155173627627499-.633256707556421078010687989813*%i
1.99956836324412885946222437081-1.45277145355093112054697821521*%i
4.68561616415581195207689135312-3.40429941316854565516055343735*%i
11.2918404797602669865955131536-8.20400232799829147875785363934*%i
28.0941135272492421902922743226-20.4115682641572706439730783434*%i
72.4289823313785838704158031303-52.6227359238954135600752204529*%i
194.283390802581991459748301556-141.155145903161400091916959010*%i
544.816564838330573321582287742-395.832404316837305478810208829*%i
1606.14152320907827419679641433-1166.93012260670474332271267780*%i
5010.91777360797954612606275782-3640.64486686413609883060094691*%i
16676.4847830096322919258777655-12116.1754124907504257854635678*%i
59776.8082732503368206106376140-43430.3933989390711388460234646*%i
233530.568230303443883562982547-169669.889408573081055656157970*%i
1009126.21439369605390191092785-733173.110882075728755007557914*%i
4914303.52253254876532203717181-3570450.50464644796268033896420*%i
27631396.6171553292437785410481-20075384.7505468098418441453659*%i
185223157.930455827245690047371-134572501.407929585134278116451*%i
1546474211.18466959799407734534-1123579282.88920619635780365841*%i
17109225676.8593952500973814922-12430580075.4796567321703770145*%i
274907273853.130114867489124769-199731825712.315200895716396283*%i
7411310468212.74347323564880174-5384632243407.88147461609544709*%i
429149706167155.043891822186757-311795512411442.638763950654915*%i
86085195440783185.4592926187139-62544555519382182.7735342940878*%i
186068317198016412833.986377991-135186545558750212183.156188271*%i
271100494989125119207044968.046-196966038972903635436829063.708*%i
-.100325908450220689319678935995e37
-155052641394530388049802.643049
-5168671650256226628.21948808280
-8489840674095813.58283183288609
-79435983803744.8853428517293280
-1998479551000.93025181031897167
-95172114558.8238361275589143568
-7075516280.00457513162305652374
-730333496.952492518408507024014
-96938946.4492207666132388931331
-15693433.0100269976666607082885
-2983091.46057095100199851719092
-647256.395990165261667280753882
-156886.786912618601205914789281
-41772.7519734726646616815971771
-12055.6392994541130888103189950
-3730.67390006989592231910673630
-1226.99309069214641979661774294
-425.764397398364905591866986288
-154.917236769471004989314256876
-58.7996700149749495858809986430
-23.1773823414095500326944738709
-9.45119078855576073880184261409
-3.97251490457958152569321798010
-1.71324850005262734884397406817
-.749994642201933798972974570911
-.319273123548527696309404673562
-.103462562038210606186883474084
.432730385013142309442881286955e-1
.208251898246466811826238731387
.476862498146799332591155795418
.975940537225236907224363495769
1.92829150083601807614882058958
3.74117864415084635364004428167
7.16090924472763828118628538295
13.5463882013226554086584036518
25.3519863856938331199454449069
46.9748674466383807085454831492
86.2323727571172156168365245340
156.922024087141013252339949993
283.231518913817127499311557427
507.293817543386486416873687602
902.063387776133716852180734094
1593.15464302769548794059823688
2795.71085846391509290390422517
4876.37964227527009242785836347
8457.06708522365847132058854224
14587.9651540286826419241484024
25035.0520670092119462592458300
42756.1504595146515454722017546
72686.6289751881427180737574393
123032.120322165597266491244200
-21996.7840188080638864987976566-15981.5990690127325320743982463*%i
-12862.3843759209040151167327206-9345.06926065822970617120757202*%i
-7483.27792095672413523850968318-5436.91965845859953087311541144*%i
-4330.56153766641359983041145670-3146.33712725893900378109422091*%i
-2491.96955924576254999072553680-1810.52186328682126082008122879*%i
-1425.41430159196474593555323991-1035.62411013362197442349553864*%i
-810.179864644400836744122841075-588.630126997784086782553633246*%i
-457.396752049695303038833973150-332.318192535626858896256034269*%i
-256.384219273292346697776502630-186.274038811498590997777441543*%i
-142.618497475677250716859747260-103.618403696304729739467112525*%i
-78.6917893913812942799752043967-57.1729315976796046619224213761*%i
-43.0443184454017876525013064060-31.2735279395900004564014187082*%i
-23.3280703931733603853387504091-16.9488352369431863201582885819*%i
-12.5182165832063572109607563314-9.09501672248137784443976623932*%i
-6.64690656637306123516872372662-4.82926030014811700855844176152*%i
-3.49020701034634599820130630830-2.53578382455906697862988546369*%i
-1.81205275030419656810228620255-1.31653338608507795162890669370*%i
-.931913210957455265939721487359-.677074580170622729751178503884*%i
-.479574193630106694224802545807-.348431047006150157062272524598*%i
-.257672352823346401957696029578-.187209922617363384379951034036*%i
-.166551050620666391412236857918-.121006421359887790239431557288*%i
-.166565633675328784928858869034-.121017016569288245989620975712*%i
-.266739803175413538648111380804-.193797810918717341463427198483*%i
-.541330169262018159814301115735-.393299389661196577482577728798*%i
-1.19556463816043267924672105639-.868628554602895313959558933053*%i
-2.74707591941562507916101994852-1.99586748311487928826401915182*%i
-6.51146967816270077679254194050-4.73085964100258226363483904229*%i
-15.9321894446343515134643693447-11.5754131957649684339106735887*%i
-40.3595191828084402705667142225-29.3229070961585011110494823453*%i
-106.261697204011018807576439794-77.2036421167423541780814741711*%i
-292.128329750880634945299303944-212.243655199188493382030655947*%i
-843.148288470540734952722386662-612.583088988779940866977542007*%i
-2571.45547237514834420901572279-1868.27175955265972174930918461*%i
-8351.60262738664006308159002954-6067.79448579770349358707804275*%i
-29158.4084716564754910018327857-21184.8238036102269515124744568*%i
-110708.475635824393009819987826-80434.4157600717573669648589343*%i
-463743.249206497653061507881941-336929.192623908873525163914879*%i
-2182663.82329974151852163369813-1585798.09196604051631813970106*%i
-11818754.7764190997975754093392-8586827.97313496655019761169487*%i
-75968496.5692074288771941605778-55194343.5461585507745745258339*%i
-604967197.127854181908200325772-439534396.761588676653258499577*%i
-6340521250.45587056161111366490-4606658338.17792016121519439953*%i
-95656188696.8617143333141063013-69498289155.1757375109389780470*%i
-2391782519050.71525038142949345-1737731717830.13689139167967898*%i
-126155886527361.493503536114998-91657616720346.6679726293428960*%i
-22389400471585549.5063888458145-16266851619150184.3278369839299*%i
-40502640453445299412.3044491224-29426890785938344178.6686249912*%i
-42437035179318075214049331.6759-30832310820234187785447775.4213*%i
.945542022657508101645629891941e35
29013282989346060661009.3192258
1228647452738787204.36180337086
2341026870935706.74920757767815
24395089788392.2022658095992080
667829978129.317489870432473296
34088341854.1335433100699351931
2687699320.46309774602755239954
291912253.682874705966646480540
40522497.3259508611669441192465
6827739.18758994619566867384743
1345447.71605124965100850107449
301637.610372424941483938025532
75334.1428138106259506334058714
20618.3770598518001532234225496
6103.85869994659667639119538052
1934.02797472584832751039908490
650.247977674315556942253377932
230.326796983389779591329715300
85.4387614828463782840298305072
33.0225169581724856875969507821
13.2417672123148160918329602025
5.48942933297219744451733878811
2.34730378068348433967285113709
1.03724425944893322540116770631
.482673123021147874568533737334
.256633121616393584250914888630
.192725126085541259033211954691
.239951529755335745753906221217
.413796930411911049393293050140
.792323832261678361379646600100
1.54374876886448969871278271306
2.99077599138949089243116672795
5.73228569819066197303972334690
10.8628238230666930965701253654
20.3618319515978196159644446633
37.7772745281427159115479580102
69.4174063854248628026868445851
126.414749914876524998720335524
228.279050777263675088146160887
408.978995837493282790960408037
727.297709354110490947765087369
1284.37822257421457489518907899
2253.31297333694847008874937877
3928.82675421374426035455391999
6810.35421435381716396555220276
11740.4177317246751878749661779
20134.2688471351824385898008330
34359.6582158763989173006924647
58362.8118167942535033269354599
98697.0069795906796330167607436
166207.672106256258487950040916
11488.0705276557831800634832350-35356.6455368744305450620384134*%i
6755.44445374433604325967139704-20791.1201815908156737293033134*%i
3953.22907853458414926549850628-12166.7880536883865684885757301*%i
2301.54354628140550862054504092-7083.42268248223264075207241191*%i
1332.67472717604122713152805148-4101.55106823922436603301653349*%i
767.229350635358393044272587966-2361.28914168810257061777414432*%i
439.004928687266321496257248017-1351.11824175959568670115132993*%i
249.569423876831229350631966890-768.095707248036081011832997469*%i
140.900365408327298782623283022-433.646734999186478632166448622*%i
78.9655170539736917804873214419-243.030871841546547173349244350*%i
43.9093119733820621153571157788-135.138966589170211111401596758*%i
24.2125398838130133649370478524-74.5185353936105340191348238586*%i
13.2324273199386336103521987915-40.7252237194431924249391515624*%i
7.16283288593533734459747154208-22.0449328525806974273114759711*%i
3.83788290480240695384028218828-11.8117890337167081575415278273*%i
2.03416616727669310941908338108-6.26051972490636104886905989359*%i
1.06614068169862032535487168358-3.28124362437664575304456459753*%i
.553069700744116448331493848432-1.70217351289061118955468851322*%i
.285768486741661144905454908157-.879504967088295177356929078024*%i
.151178960784937520253957481052-.465280998775065430933809825944*%i
.904800528630196489436005083090e-1-.278468969139262226790222680865*%i
.771063161099770610076211716404e-1-.237308839703907426368734203004*%i
.107923964490403718889511203827-.332155808778802162105643021961*%i
.206430256778290269230672645400-.635327002861404225512393015658*%i
.444310824461696140372166034151-1.36744810983452608210557979965*%i
1.00335134746627068190859751058-3.08799792409954867811280413225*%i
2.34033542504356528682100077237-7.20281180912463013742834919539*%i
5.63232337401756371952972697154-17.3345089242612332441178834734*%i
14.0208953428775763029039631692-43.1518787732314964098300889362*%i
36.2371607752165586522908237896-111.526513151856845899293746196*%i
97.6725037894068058843384785105-300.605056947344880092636404190*%i
276.017949503032353095323178132-849.495899150353089520728201645*%i
822.982868160776436592934619658-2532.88082471569365594183217687*%i
2608.67993527533483753145603595-8028.69129055630362650697978144*%i
8871.86247870632877801159831281-27304.7850947973052243245999632*%i
32739.3906123794803816739857735-100761.483504870364770189835700*%i
132951.519017637123737447230064-409182.701323024394451502852675*%i
604817.681393608428854632251924-1861437.42101761623510924125007*%i
3154136.86231692306294140004800-9707435.09515040300460378262053*%i
19441812.0657388824690097042714-59835744.9275797640323019485278*%i
147675581.021804786020221459547-454498704.553598876012859252241*%i
1466316192.85129961119132728017-4512857207.03193880445915357062*%i
20771400745.9271659828984602556-63927798119.8098172035078222504*%i
481714148987.177869372756089367-1482563705962.22459633552274806*%i
23145132866129.1486086730462380-71233394387819.5688764700848420*%i
3634289496391563.86370139621679-11185192952373258.6091659883619*%i
5502550281625858337.92802445097-16935108414238958459.8043058784*%i
4146038413782172031394311.26894-12760194170593592104326574.9186*%i
.145612360736088451588140537642e35
8870786415840344612617.19467004
477219401971362670.507713311490
1054745628566884.54673471705144
12240839136989.6940052003316387
364621355396.226794045016529155
19947831245.2161992815647990340
1667930472.86393297758111522610
190606070.563919405843503622962
27670922.1859765345385672667540
4852208.13515754300512821994894
991157.223925123794199521853663
229583.202345955261978028946388
59075.9950501753788162390667652
16618.6673214260659543158295885
5046.19664015861480121933100314
1636.99561749614868310603466127
562.584632747745489263251192776
203.401043588597485899461436840
76.9138116214408356602348400931
30.2690238837186289501660694845
12.3461299646313924759379358999
5.20200280528951371273640031112
2.26086057169087700766314707858
1.01873745527533177962765595860
.491282165116207846179396193711
.285412309937805433158920897028
.251978386223204981907680041982
.356991537882876554334622051358
.642719488025329033224820871681
1.23521367626710669418257179335
2.39002902464200568733951280033
4.58781974848634757211566561112
8.71045426525645505860653968423
16.3548620534744544320990380669
30.3847730159087813084161858423
55.8923888139183045345546314348
101.862914518993138740575764609
184.037729253134300185529987603
329.811051881111570560248057570
586.559472998594154969853975629
1035.73991753588858742705856175
1816.63848158963416821282266577
3166.19964281340583406673569577
5485.54553816558235798923206935
9450.63426985788485321373851658
16195.6632879286475215086217109
27615.9743772170733765789422644
46866.6667007504847374643175494
79180.7891175991571896374171808
133207.946040799292055587337942
223198.141812129332111568294282
50512.6747055968132988389936236
29868.8836166476327167150907693
17579.7020253361881833051070219
10295.7968202069352882548513147
5998.42607346122747677372598094
3475.41398342232030160351648265
2001.79547175502658197396816362
1145.82095985178525438982777445
651.514956632264236673730875712
367.836257770978388464491592349
206.111792160707296811787106485
114.563646427489731737353328343
63.1311729476954662537035043803
34.4690068339206783312667188495
18.6342191349974633055211242047
9.96718410556127030480577083051
5.27062459062005150176927643509
2.75291922250333312838395140374
1.41885906805952018598103287333
.720817978419837584769156858941
.360516838242940466433596704374
.177276495581917378477387929044
.855744625363572714486833890166e-1
.404822722765074546797480960945e-1
.187317582718713084284342892849e-1
.845939104618861465525170045206e-2
.371936750313774534024070783424e-2
.158757747218723463063159129984e-2
.655716411187492641024982866526e-3
.261075506048544790315062130490e-3
.997616420412912274912496471523e-4
.363955179616307695451885284285e-4
.125990051111646473369172621872e-4
.410783412036792105797752264746e-5
.125020086517970958880741905634e-5
.351277902240938102379847574906e-6
.898798004128672612361315260718e-7
.205803795215465157356853586917e-7
.412330352482418253298200789100e-8
.701583654382176857449821586464e-9
.973364648473555589605848151538e-10
.103949273386025990080652158076e-10
.784631134540589695442044282059e-12
.366011179071260862371189240118e-13
.838564807086055593848698038588e-15
.604886414353280269534066465130e-17
.478045198743782340459178615392e-20
.882986569264347829287862891239e-26
.135155075226522460926254232930e-34
.111690710297940625588443734140e-22
.163248717402794240590458643974e-18
.635628886744066418733163521089e-16
.490602247374387888051128519066e-14
.150908897252007553327018913755e-12
.256426670540525752857094730877e-11
.287956529931257787610356435250e-10
.238330267097479476066301414270e-9
.156134841456665537116291913485e-8
.850472356083176839686423261028e-8
.399047547866001617606487507891e-7
.165580030660149691752649192768e-6
.619899053531730886006369973715e-6
.212696676739055726883543781303e-5
.677222465892619798879836537443e-5
.202115322235722443750771644584e-4
.570087258621947218005309151353e-4
.153011345776167573516642286680e-3
.393035491653666223172052853493e-3
.970886574433914890551430647568e-3
.231594181496960976181687840442e-2
.535366312643893113567015334080e-2
.120302014146862245525347511110e-1
.263484373823467893583266502364e-1
.563785589107998905961875240716e-1
.118098714521934776284591307468
.242627293023646790101538570106
.489665904779492283293619216343
.972191732708071679389446176471
1.90132316107763147742365445637
3.66703171809805173573850621112
6.98201532796316707758872068834
13.1359999184694335460636812748
24.4417256719742124363323706482
45.0114547610449293511279256516
82.0998794271742768615637206768
148.412068727336337654245203738
266.046844852418425521921441449
473.197802530889480041241339412
835.482430082245229123580551245
1465.00433365187931898054332599
2552.28335604203311671838455879
4419.51472182451227522051414544
7609.05252199416589240163921472
13029.8645852733837713540838654
22199.0844440046954877579927102
37639.0814099883325696578530325
63528.1174144225582053857510294
106763.358259538772301835256016
178692.652154015648830621353001
297928.233560593266066833922068
21074.7258737110572686813053836+64861.3368720018794682886419884*%i
12530.2153071268062692204082380+38564.0373680055332936803516080*%i
7416.70853105029068070887105696+22826.2817460407363530208809972*%i
4369.24218831022639427110292152+13447.1447528939621825460740278*%i
2561.06493473888285951723171406+7882.14738728267451452411621388*%i
1493.21482410383278453886193358+4595.64268161040791826871814862*%i
865.701678954450928131837610875+2664.35580542309015923330761791*%i
498.888864206058654957029568168+1535.42204424704726897415277041*%i
285.667827937193768714888134729+879.195171142914190803654379503*%i
162.464662263388164984810799571+500.014816420767398073483914687*%i
91.7273329946615370876038999748+282.307702666662248797645965514*%i
51.3884421073858338000504964138+158.157362274984966125539323533*%i
28.5511586987000506849835579497+87.8714310942671770035110030185*%i
15.7222935724244040230188221974+48.3882440944868908834579841689*%i
8.57546375070076230092748879682+26.3925636091748875478432667401*%i
4.62945154654383758022225529374+14.2479868109484853050180533858*%i
2.47146132622664608316855566401+7.60637583649306698763549921569*%i
1.30320761184004811886442214268+4.01086061248159394094732209588*%i
.677248535417548974484251670928+2.08435666803064200987908583904*%i
.344761276628641504601782474017+1.06106610533549340819146228250*%i
.168113781463648401451914215517+.517401017582948961325385905189*%i
.706601757176879964240521331565e-1+.217469659540238942517559566306*%i
.728630519995237760861088939353e-2+.224249415607278755284864193290e-1*%i
-.547361458534493171280556666102e-1-.168460534981584473793309740356*%i
-.152791329246066817270304561674-.470243358643743665848414388454*%i
-.354153997343648579280172825751-1.08997392724935565703237128009*%i
-.810106522540604187774912872523-2.49325150778151084726773269181*%i
-1.89133088750006596299020536035-5.82091793581001427412968034636*%i
-4.55008746522886161591453797768-14.0037292844423456428251774412*%i
-11.3359314178555792210163996577-34.8884095032818445644041062949*%i
-29.3798858435759969141388820836-90.4219909848621278722214452466*%i
-79.6176092779839728612721205344-245.037805344102986755470617449*%i
-226.955112082940264650059523744-698.496012135429686691168211445*%i
-685.432900625021056741029877820-2109.54555409190876467836931764*%i
-2212.43858587675481573865047135-6809.18581276418639753701636005*%i
-7714.57291468821058416085083806-23743.0140558740163555367164898*%i
-29450.2234246868929289751521064-90638.4678002918616088201895719*%i
-125187.147884456900778854119058-385286.424109916855337943025413*%i
-605686.458869942714091165414695-1864111.24315399892809918552967*%i
-3433804.94028741609947251850267-10568164.9345936345771633677062*%i
-23733959.4742515686026755092286-73045616.3458886852392084811277*%i
-211547634.497871767916833341369-651076672.022467644406170971330*%i
-2642442228.36569384754459964622-8132600944.17778736178671085186*%i
-52724137676.1938043098020373011-162268210537.783192871014795394*%i
-2102276988260.04116253946789701-6470143277350.30215622785648839*%i
-258423200450551.338363589908239-795344829650802.381837000551476*%i
-274097835409502094.486678678811-843586395615196827.861336153217*%i
-106807737941708256357654.460738-328720416706124185744049.013761*%i
-.135980954592112257844494692090e33
-326535614790404659024.211406270
-28347890559901857.9966671785134
-84299474341746.6955736465172219
-1213352866384.49684039263815792
-42786578929.8764233361655592681
-2688649236.79848119935598855968
-252795020.067018772028091678127
-31976478.5469942565424198950997
-5076039.00549971218105376946573
-963884.527214833308093125391161
-211525.148053944360733928387081
-52289.9914467729392304310749104
-14279.5396431547503689205812874
-4242.62651534640271277038928797
-1354.95390817512923489199518981
-460.616662791594849978183559994
-165.350671839145096938353446609
-62.2649940268551124306320858990
-24.4588517462696954987983258160
-9.97476683906793986805183057515
-4.20417598155031775952481072746
-1.82027088661273566100213168197
-.796968279354147512898764425710
-.330427495117827134506922006027
-.828781241668243677370324436644e-1
.107125673669013288933614298636
.346437460475640091080012600063
.751981815771058549375247682990
1.50558635721356230038686548652
2.92715737092895990763400745507
5.59446817964803652401285458797
10.5502787516744274045871611804
19.6634228392280744095664563194
36.2562302877240175088252964763
66.1883894987015310659789150697
119.717877887842792339950623999
214.677343914959711950308769386
381.865902112400649695509409120
674.154233238802172536569978249
1181.78594309052548478715468304
2057.97527532365747423095583510
3561.54732624998177816332578553
6127.68307643745303987093225870
10484.8513425183660543473395992
17847.3951049353554582374530341
30231.6571705475240752968340052
50973.2493370663937599379355586
85570.9126116438917663716206607
143059.264783184314829129270898
238235.908847174434561970413180
395265.412714221668579120932384
-74016.8986200151774376379296053+53776.4246385023345617482559947*%i
-44245.6461113853342969993753892+32146.3435789964662224413682335*%i
-26335.8858609350201916868277482+19134.1410906643696928557013695*%i
-15604.6242669788717580091706579+11337.4231635046310197886924200*%i
-9201.70741686925037944235517711+6685.43176861786431965031417584*%i
-5398.40662226174693203195564143+3922.17199453893093561401856731*%i
-3149.97332987023245679753433261+2288.58958623338324870452916315*%i
-1827.43924516362763285260892599+1327.71232895739048729761044977*%i
-1053.68776814901709490767546639+765.548974799313460743934372608*%i
-603.584532527921882997584823029+438.529832127770343266736327930*%i
-343.344657921376019343678841711+249.454495743332389866467889885*%i
-193.856449103237451372502454756+140.844954601608713208197818164*%i
-108.582693226721659345466109960+78.8899444345729309618206988334*%i
-60.3007259197297153767247041744+43.8110418502788177975955246792*%i
-33.1812546765415131410595931716+24.1075926550841741746400192055*%i
-18.0787888789308083844310650171+13.1350089753735937850163232625*%i
-9.74568794901446018343887902816+7.08065675962834653129851887411*%i
-5.19303481097250741689988294549+3.77296063958380694424600127221*%i
-2.73181837024120177845518132537+1.98478222476652767644692641785*%i
-1.41549739880378823628644978098+1.02841905851191680120853566825*%i
-.717938331153397210896426740800+.521612730068139150866134219703*%i
-.348331969859547441954915652520+.253077989966842771358017879774*%i
-.144841499757094551967144075409+.105233509393607340474362289451*%i
-.120955004573949760329337289771e-1+.878789547980574477926774314829e-2*%i
.119745942376210229954072666349-.870005196923960518638172794246e-1*%i
.332254293686802587920996842100-.241396874475845169821797159658*%i
.775754476554799948718652454227-.563618618507599816508027939292*%i
1.79501177991477312567179544873-1.30415239637868174460518975035*%i
4.25101371247775922834678919573-3.08854224924904553299106328035*%i
10.4022308848301740405214414420-7.55766312395995667091229727206*%i
26.4418875419949104861097643185-19.2111558199944403696852957381*%i
70.1808423336763549683635821763-50.9893666066548699603388189055*%i
195.638427128147752356492334993-142.139637420677043239206486621*%i
576.820092893307546123997943233-419.084328494990765542619624401*%i
1814.11264967364054289484058514-1318.02999058039042591453316348*%i
6149.73297078022152587295759600-4468.04253914858029655169858923*%i
22764.9142670060606352000711623-16539.6783613758903930250482364*%i
93553.5051181945034841001696902-67970.6001123355030231025511119*%i
436027.282258858176945994271538-316792.363931657862779314213052*%i
2370952.69607295024894299522866-1722597.96558596735315246944211*%i
15634011.5087515251100318903502-11358774.2444332393290848787875*%i
132039919.370395901332267414627-95932616.8169914574561754586834*%i
1548869819.83920801998368640680-1125319794.45718606272791218877*%i
28667315680.5253794508995609911-20828024005.6566317627084404335*%i
1041347068064.46143647966167416-756582931362.524421827917246129*%i
113264984737316.858096552465287-82291828345538.8066776150357181*%i
100553456556830227.484628036891-73056362526476664.7504926755727*%i
28178315682407923901189.0818917-20472744710829758893501.3681421*%i
-.825034064064803215788613656551e31
-39333690964103397853.5668787728
-4337730905828142.59404317909420
-14961984084148.0772408428097179
-239817460419.363035978972360038
-9200699648.30567499338144360415
-619589224.320261568977328581989
-61770267.9894052222186292763392
-8219663.06367934015411601642923
-1364295.91122126126526470015579
-269558.724022698314991162251908
-61306.4716683491171305938558081
-15654.4588890902575064768749044
-4403.40570004174800562851633339
-1344.36425779770680664423046388
-440.255772611287610434179550742
-153.186799173827654116406692598
-56.1931354120664845033390112364
-21.5915308475568247778633021460
-8.64251102416724662154514452808
-3.58565238364492109810055167402
-1.53225482325555507475837791930
-.664201204635374476524819714516
-.274343254918961295514652354558
-.711002670814297316997075180453e-1
.819676126259697487757111492196e-1
.272952451109674836276939152679
.596613827033065258229463295273
1.19962355891661856843926918400
2.34005426723448213212439035581
4.48437397106296005699723789277
8.47498102455009166069566527841
15.8221098100710350699180849076
29.2107153647028776274628026746
53.3754192435269621731245160559
96.6013580418925628081413590693
173.283294296575441323803672803
308.264693112379183806696582077
544.156206389052622997674553230
953.618823714034886185937805370
1659.88496028288648553132055315
2870.89491936721071197957571010
4935.85296838757170005302146854
8438.57174123192746458226651762
14350.9843594242909066806485661
24284.7567719692321565275932749
40902.3794149943112741129698129
68586.8038847791457128288414264
114529.130999119544541554576721
190490.585539199906949626354699
315649.507598587445694333272519
521190.378378382270734839372226
-98652.8676184386955132701869701-71675.5038344786560177966163969*%i
-59286.5778524575035511648977214-43074.2201497111142216320534109*%i
-35483.1247245007936148921473524-25779.9991388683311138326632641*%i
-21144.6509586727147428902416716-15362.4881613050517550112624190*%i
-12542.3376867033987314516031713-9112.54172999439734174167028698*%i
-7403.42716404349717527677527196-5378.90468766772206794828364596*%i
-4347.40934672856968962872711403-3158.57777704630951757572831832*%i
-2538.79550300905033976155076454-1844.54290284483723373317165949*%i
-1473.90081224741683793347894045-1070.85162215939300497765025964*%i
-850.320374874881478342381077452-617.793914776062543479545555454*%i
-487.288559760185904914549607659-354.035862076256839473625186711*%i
-277.254161394132546890935613636-201.436939319299392908496170176*%i
-156.544788302582938300908771656-113.736446239422655670430429973*%i
-87.6652961944945402900685489361-63.6925659154868066344352382278*%i
-48.6611454588545983746970055977-35.3543916373128067359246835539*%i
-26.7555801453697816866499471777-19.4390668370670022936530997529*%i
-14.5616191687952825309805189942-10.5796356027478464633499775877*%i
-7.83849567329240289887222703609-5.69500046223294576623778662719*%i
-4.17017632251921667185237424102-3.02981044759121084877637312439*%i
-2.19164825127718488050420685610-1.59232566098145430800300060824*%i
-1.13890695241605743471023646053-.827464336371243626625026417324*%i
-.589238651027134979759746073879-.428106939115723285965229971878*%i
-.312936334493641207633992524741-.227361555567741298901139856151*%i
-.190450958514835781606596058837-.138370720860412900130592509762*%i
-.169178621255121096239860306596-.122915463171157161492740492789*%i
-.247711458152582134286255014949-.179972909022071186434126875711*%i
-.487807918228937844418842353547-.354413198091084866827466928645*%i
-1.07359395845927756093552078339-.780011668630285918885129979978*%i
-2.48251083782933285527451868445-1.80364969991722998256046957241*%i
-5.95792653533266934028012461646-4.32868700665081866780470599997*%i
-14.8513167332391981824791367030-10.7901132035759248905957287459*%i
-38.6089221922096440494110487663-28.0510239330902747200586504447*%i
-105.262311984834551953218081795-76.4775462531506922814821238575*%i
-303.016612090491495753592368918-220.154455375845493569164302389*%i
-928.651529439101549544361972044-674.704829834729656740651707122*%i
-3060.83043640668211812834113971-2223.82348306266282491230754225*%i
-10988.1158105351562449250965822-7983.33343900188748612932003823*%i
-43659.5310589474555241432601870-31720.5060670962551199352135310*%i
-196035.431110247587080524623342-142428.077697460052201035170893*%i
-1022489.79064107334731648788317-742882.317352037621489649610597*%i
-6432654.99289190719745479779559-4673597.42032199301540200199653*%i
-51481305.7573098329071837953149-37403358.0299328258855574778697*%i
-567147249.074880031797367471082-412056596.094149411286998042568*%i
-9737709136.10607101214680098042-7074859812.72740365687456431132*%i
-322262902061.918786059272866695-234137703546.410502000491191868*%i
-31015749567662.2510374254644258-22534261098870.5108132963292783*%i
-23047301451475908.0442345010736-16744844660256929.5148334579575*%i
-4644770250201085859322.31601456-3374623119585189511899.07444739*%i
818802185940870784061831740054.
7750134346667812128.50661073812
1085695060389158.44278261536815
4343560971070.72208441184937865
77526825703.4662943384305197519
3235884385.91312810899860496821
233512488.221133694899125176480
24683187.1978211559922999935436
3455088.22286260928248118353178
599572.706504242235080979806118
123252.714568596683895341463593
29048.7744457504453956670671455
7661.16496889971198410957284183
2219.51665331447073447236312673
696.226236975727271489626013965
233.771391409318573995569255727
83.2458678587859865230735796388
31.2017293595678430156210853595
12.2330611381460752854740100726
4.99187246062630488186052317799
2.11360341464115634219105067224
.931237126711435241859285591325
.438492656566744866102231623549
.245764084727040349570731040089
.206809567443484421582757895736
.284163715921626434233371980831
.506933715693238188841533776229
.972243924269506231490530078596
1.87868530558328198059506598365
3.59850266051396688393361237629
6.81036990445157135221659972758
12.7342118841593355741695610468
23.5402907888834448438276100655
43.0554757498838440693721037392
77.9739038703740247990395416959
139.919189146987262952315016130
248.936886358404927365869136082
439.377567888099881224257000764
769.757591988844254368432925699
1339.21018633540740080526817636
2314.81209787404581737825846563
3976.79057996598130319592633510
6793.02421722232626950168011983
11541.3785649292144497993671326
19509.9104025516024521330920599
32823.4606329662177833715365489
54974.8218227913861603485243255
91686.1681961000087492679553250
152302.337890282783705318293331
252038.598542264569238277941458
415598.188267822029585674680516
682981.031812644762394997639019
49896.3690354560116041022133675-153565.233545244044650992897441*%i
30142.9263486387251256804071562-92770.3881854915770859994465060*%i
18138.4901297312548810259765063-55824.5324614897094944075753110*%i
10869.6261802885576770325320406-33453.2695503232268448406673250*%i
6485.09521288559288736573960575-19959.0707737120344959803351574*%i
3851.12949362634782749331360101-11852.5578420638806856087048783*%i
2275.63178213509438461897360736-7003.67447254996291029923056360*%i
1337.57886756809506088473395532-4116.64446038784464308338309786*%i
781.789825681393464158530813085-2406.10167603073579890560838426*%i
454.203498562995960801570315873-1397.89463005473653453898541319*%i
262.194128792375928216643793518-806.950553728303498592275246528*%i
150.318897502186124092620344009-462.633996168812553887569567277*%i
85.5481315543094302442856628379-263.290076120800956005111441475*%i
48.3038802949547638189441768526-148.664057165466400144326575335*%i
27.0441921100820510888020044525-83.2334648334044070422553400055*%i
15.0040292893884112381235784126-46.1776539352460292513883421273*%i
8.24288034645550842542833250196-25.3689771411915674116016745888*%i
4.48083363160314787254294698882-13.7905879008062124649918458444*%i
2.40831361137693698942240351754-7.41202715408988002868182711336*%i
1.27902909036394650271223884234-3.93644677498135768981884861295*%i
.671417536423510525124205999537-2.06641069842140441072457591089*%i
.349829798343963559973241988587-1.07666541117655537433781724605*%i
.184504169503146518038378863371-.567845445020026491759424228063*%i
.106195909056706272479839409189-.326837401019185288657070825381*%i
.816262238025333240206133675189e-1-.251219685198839623692486417300*%i
.102629194104229144708311115924-.315860181128149616214172750975*%i
.187356790594918949337075338230-.576624909991973401270462794017*%i
.399152500077824954952413922797-1.22846507831186591640788794591*%i
.904103297207239819276654928308-2.78254383372058724810920358880*%i
2.12946184106739983738890672207-6.55380965129604242021897243773*%i
5.20631578765800102908717973995-16.0233923890106421101931583458*%i
13.2588722984339976959201387556-40.8066129943993280743748704043*%i
35.3584413599987277711042814893-108.822092873844661959994221098*%i
99.3902581579206562399127894041-305.891761288230830786331090094*%i
296.852604481601800585285655459-913.618373780622710048144031019*%i
951.411173770214750121059545878-2928.14250659717420284877784891*%i
3312.61313226850984307407290785-10195.1749022133429303806120389*%i
12727.1253368719279211799635363-39170.0641248567836606915684359*%i
55058.8437383646537120989163554-169453.696949469679739167115774*%i
275488.298441413258774660916009-847865.800797560607214452045657*%i
1653680.18088042506068261809028-5089504.26844867945328746774853*%i
12541955.4183335440094226508276-38600169.7149911167346129110655*%i
129770056.065944231444127787424-399391165.172466191353003929608*%i
2067030328.71775889750652681022-6361665213.53659897671488137533*%i
62325236111.4575394931366180788-191817353130.793476067083573731*%i
5307891663056.66038356455647170-16336010788499.2608351218988747*%i
3301462589207040.70490675821464-10160857059402495.6141974602449*%i
478500442091567833138.496242757-1472672933156298997177.04847830*%i
132963223147228486218662667725.
2498595716904959793.72801753642
444618711109775.101184099712036
2063123920946.96694583150956053
41004324535.2480831603980956762
1861878310.15523999350655872158
143972082.338790806612728048553
16134553.0930007243235683988227
2375564.02802558561534292858217
430965.845949400348987212204571
92165.7459106561564674780034038
22508.0939495996192189848447981
6130.52894648118917317645928269
1829.06537500662421199913926066
589.437397440721520083559856837
202.900244861605414576944633657
73.9364122262393470192670969286
28.3123153896785066238344730240
11.3246394838653064027597286782
4.70969145759429570223773523258
2.03250964479221717398781280663
.917051404760072573396799933798
.452088513034498848414610842356
.282671665822280178842206787208
.281052477451760045662511583285
.429222321778702414946371673733
.787364585924196879078335142098
1.50764711290854422625883216542
2.88710365147794576518614449837
5.47271575593477527339325457793
10.2503461488263655910224789768
18.9750166833747135601750298124
34.7412207493550529246159639907
62.9597975814870745627437648344
113.020119988348287985600822149
201.101622965481197240115768317
354.903524441206812115636718872
621.561282086189273277875441223
1080.83460944858320083296977579
1866.98092143966299584286186144
3204.88528940137084630459242784
5469.50919287088487977920216436
9283.35496457383748076016751303
15675.7132071788605430188915946
26342.0259126538225641584365762
44065.0335254447963495210150570
73396.6785431306965876146940326
121759.249705217988129646881380
201219.002511443903159859902820
331336.069921919499515755540362
543733.349198352009577106753537
889405.349924585418903035283247
212396.391259872582394804071088
128971.869765596095814438295482
78022.8613803142283103079824850
47014.3452707466606937201271946
28210.8046715090810735739294742
16852.4702138778528646212115112
10019.6326163377755044768390209
5927.16468948502305718941408506
3487.42289546881999121505566505
2040.17542986649100835331813499
1186.21813047939881802682613872
685.186901997246179056788890290
393.003975499648990650011403302
223.719978403402657869975919444
126.324417835126842465220041662
70.7090276661569752127529971919
39.2075916955668301440901543612
21.5201210483471831436561210478
11.6824666216796370168950689789
6.26664865821634291854046335762
3.31815411569154287645072412159
1.73226576996810680912180198922
.890480313842398656669530448171
.450080213679365472103255510829
.223301876024104102806222832584
.108546408508448268392766911313
.515855575701649607896511717599e-1
.239090770944821052485268552021e-1
.107767646998524056088036978678e-1
.470843127448030175444215979195e-2
.198635471500370214685905118328e-2
.805496983230758638932449335800e-3
.312292630596522892513631318511e-3
.115013263534068242338977266709e-3
.399229732272848380865460149640e-4
.129362856138086181618390268416e-4
.386634082503828785242058211703e-5
.104975831133645231615875411544e-5
.253880715169944964594858312752e-6
.532833614620366249162831302958e-7
.936511371309643089548218099171e-8
.131073818042199848595712776043e-8
.135577292338861170008391245414e-9
.921526390850779544211659570876e-11
.336653912405942163939097086395e-12
.447960880257235518489290319941e-14
.862080733649730707380095215545e-17
.827966111404917218128837627202e-22
.160186336948705591597702014715e-29
.429102548760105107229183606805e-19
.189558213221840411429264111563e-15
.351404434692886586075426084127e-13
.158287582994917459049851906548e-11
.319178911813116498124290125805e-10
.383391815297055351607294247745e-9
.320913585822290138756299712094e-8
.205927876450822776696889684795e-7
.107826164863795976496291862218e-6
.480958095491293775579497887417e-6
.188494897906438299429262769095e-5
.664171146074714137453756738959e-5
.214121707012760350887009716306e-4
.640293124874970993054559368601e-4
.179536378311039828536273677681e-3
.476201847002274788914111037954e-3
.120340898252706684614792294482e-2
.291475926456564877290480529095e-2
.680021477158387979788325154841e-2
.153462107961904757569700584555e-1
.336198681864276405557780801897e-1
.717206764875547080153802513616e-1
.149383232490802131021499436782
.304490038904148371819489987777
.608606128675878766888278951929
1.19498679256789573085307369265
2.30852393264002081813339087979
4.39393512173221516609369914674
8.25007325688645147657092383485
15.2977051417303625563318813828
28.0406814601545726500771564173
50.8546397709840894656274462371
91.3272040166545471351320558820
162.521796600271762222059933552
286.780549586873758169349888483
502.080073002590915326731971060
872.603297811052164938170914676
1506.24617937034178366537961005
2583.48834661347295801469840107
4404.81985530170792422471265739
7468.36787112059538400011453546
12596.5208407415302576780799616
21141.8156718126891683256386052
35320.6952644223439480396230994
58753.0159623037007984188905831
97331.8049529977663792251184437
160621.873359850739253664353291
264103.468367873319927380720689
432763.371733998329380171795824
706830.309526561987861235356838
1150916.39621338459114922300478
85760.3082484153604120227595494+263943.088839223046904015732548*%i
52339.0642360075689622653113800+161083.076350318576697261455511*%i
31829.0454700036637015115775203+97959.7292470328516230092998410*%i
19283.5090268945306953158451989+59348.5382710436879267729192545*%i
11636.2389489806028061668980591+35812.6610479150746578056567178*%i
6991.88812283445230490164532585+21518.8189694187798191250377780*%i
4182.28620180296089580793270365+12871.7533910441923542715926339*%i
2489.67525429426443314539312765+7662.43254305407025902633684228*%i
1474.49256746448226216091921372+4538.02150057270872999393335513*%i
868.485341100710844375735786639+2672.92303658369223584289007835*%i
508.555074214453393594467243447+1565.17157965676242406994269046*%i
295.930424986426957552243810457+910.780197130002509614482053521*%i
171.049226527739258089805557197+526.435388530983747407591345192*%i
98.1561327780424067677114159823+302.093513923769386649335968326*%i
55.8910729921199279584368425714+172.015035222907933722480579415*%i
31.5599393554989269159524432227+97.1315057886684245473562275254*%i
17.6608409580503558978825396707+54.3544794692620104340550208260*%i
9.78698573374449186559560012223+30.1212448713144905299196093258*%i
5.36647862643404604381121638603+16.5163229211789301644410672922*%i
2.90879162715424172924038354367+8.95234010396582755982829284233*%i
1.55659075389839100225793993698+4.79069373739229438446833839475*%i
.820687956057418233166079092566+2.52581781151592387968638866994*%i
.424206780167134885333826572773+1.30557422367851282666797843850*%i
.211435876138009476121852808204+.650732715158177761328837663542*%i
.945818624455987228338522384503e-1+.291093040964193540588999381489*%i
.221502073333516675905759277273e-1+.681713284548749975778192714220e-1*%i
-.414700192481548716338329060083e-1-.127631595526387128031690411673*%i
-.133361238944786309505351873279-.410443689597664087643671422467*%i
-.316412232300332385043128733041-.973816718311604941400676787085*%i
-.730857071869101097612168034531-2.24934677811964345574721893731*%i
-1.72561530930877053974041394978-5.31089782895718589435342272110*%i
-4.22155932926240844441273280892-12.9926236488795194589444381314*%i
-10.7764856993174750586797388100-33.1666126253939409110622059102*%i
-28.8944137550816944419747061725-88.9278615303451253999818285610*%i
-81.9960487202186104560323762047-252.357889259636822977084538108*%i
-248.574222387116589342914643164-765.032792006969046184884324589*%i
-814.409631536064520684981178436-2506.49511549550985609467446687*%i
-2926.50883139534603300108366426-9006.86805178344585453973310314*%i
-11756.0253972274914977512644979-36181.3258276612194780034090149*%i
-54145.4478864122079834319093925-166642.553572991472482214443986*%i
-295975.842411228387685539304949-910919.977590614766188013743412*%i
-2016413.05290221703024495094944-6205881.25706244667329417748384*%i
-18407860.4839992007966438045991-56653569.1662232323968479781317*%i
-252391279.950005562651393393483-776780487.228722733820924750437*%i
-6318020545.98897684782110106789-19444867821.9252800262067303015*%i
-421366410082.757962223380567034-1296832463430.34088498639801480*%i
-183641695923148.083576609802327-565191024281616.706101142427644*%i
-13766707123773293375.2233027165-42369567875950348606.8258505458*%i
-1386761537898366648698285674.63
-102712636221512069.801902839049
-29490091573415.0461394680425612
-184065478753.668032346764499014
-4535430882.35026981549738666412
-243687366.276068855376778911431
-21632074.9639641460358908261133
-2724318.53122265664892340486803
-443675.906377417025939281098038
-87945.2449202779821021038040643
-20349.6475539492325228295914396
-5334.16664217809156843269743429
-1549.05575858232234386203957961
-489.985665145544750856498068281
-166.597314196028686489857438675
-60.2499172520273677243481357087
-22.9804372023541106538506038447
-9.17919852582527589579173413611
-3.81490141089028296167153476014
-1.63558487534826634161291885834
-.707340550516606438976100861127
-.279936909426339460120104239833
-.404635438728573117583362366430e-1
.164803957504581733142741204626
.446364191363115433315560443397
.935121678852587653862960490287
1.83964696727644123540781058351
3.52473444984456757941080534572
6.63946418328731054554297668969
12.3352802422113442742444585038
22.6394493398374621772901228136
41.0922321576783342019167665828
73.8278313666271332936165087308
131.397559459696771575732062621
231.827893829672423424662031574
405.723398145288658595624314879
704.740998491202542944710078537
1215.60005566003669495986968566
2083.14790366638356902454187214
3548.18599076163842674622582506
6009.27648849800611390010918438
10123.3872549676683640578675689
16969.2552550106120411819515146
28311.7534749228125842769689935
47028.4960040215264560162046511
77796.4045834411160657768285410
128193.863264043914728264130580
210465.806479651602858113884444
344344.116691714117424364618293
561544.662376387299039016292653
912923.184746306322381539265310
1479840.21095150779577034042321
-291396.859808888829646756200174+211712.211178373832478248372861*%i
-178720.903077022857214981438799+129848.336728981267763286347270*%i
-109245.134156406067157454052991+79371.2359422800621259618926966*%i
-66538.9574293131642738591092960+48343.3823415342754335907495418*%i
-40373.9039721009777793783064124+29333.3582573359257594503064362*%i
-24399.0116350952179111548329624+17726.9195941942934592192230018*%i
-14681.7446665047715486430230811+10666.9118855316008029170866818*%i
-8794.16664160673643586806909576+6389.33606349337279585667061187*%i
-5241.91979774145352831328905332+3808.47766145242567076413672115*%i
-3108.27936048029251872852188657+2258.29714431023815171927687041*%i
-1832.84613984935049007737598588+1331.64066789101432323853473950*%i
-1074.32590954438994154234822312+780.543462222039734961560912650*%i
-625.693647597995469424904212910+454.593044482743028338807854738*%i
-361.906630002358809853385694801+262.940557863814555822205703847*%i
-207.784674052780618987516633480+150.964402367077146277018844487*%i
-118.348512191662317689986627437+85.9852272334036136865797626934*%i
-66.8295544897096365679629813184+48.5545134644256549541132797653*%i
-37.3873949123831949081174021140+27.1635324151776544913143857293*%i
-20.7058090281499783663977367923+15.0436508357083099250411594108*%i
-11.3418852277170376278639157332+8.24036196569219473936464361664*%i
-6.13840290859716809546253809412+4.45981076712764671929168843436*%i
-3.27812122429977985644852041744+2.38169448141079072058256403464*%i
-1.72368146802363655379703219560+1.25232789125388452521910911824*%i
-.887860042680151251519108971625+.645068079923784702081009808709*%i
-.440463996068159351483210903107+.320015825198703832757435319892*%i
-.195375628936680068939388451717+.141948703358292875667922159551*%i
-.433255627232064754112363073069e-1+.314778638681732603093654642298e-1*%i
.918356084415377302968997245368e-1-.667224751180252829952875639351e-1*%i
.291173231398126036836818718390-.211549735627484411735383087421*%i
.696054009233646143490677876873-.505712839496880077869751590883*%i
1.62951134771919788314209746844-1.18390929398532868855079895290*%i
3.91465439972575251768001446672-2.84416290384405675645471907849*%i
9.78213547653466870492770220604-7.10713743841242379262435851185*%i
25.6228025441338727848568342328-18.6160557349972164243014614899*%i
70.8905331872252591614528369361-51.5049871934945731561026182730*%i
209.052305661330085794763234884-151.885390640532177932618799665*%i
664.531784407034678580098712510-482.810602583000435429369397405*%i
2309.79886604612133257647955212-1678.16710732106492572719596931*%i
8942.62628752960585933807965685-6497.19830994895511502034851672*%i
39522.7746958548974289403124969-28714.9766413127253846197139880*%i
206194.625040650445005206918529-149809.164138151662935509487407*%i
1331563.30063727666621314418771-967437.366644169359023217503091*%i
11419386.4813657698603727513309-8296669.92244172935494426329428*%i
145280020.544837508795520765473-105552113.395317010602551832175*%i
3313924552.34654047034715344961-2407707121.88088941677164546192*%i
195595670961.416187356325154968-142108573247.212073295657527751*%i
71359756187569.9102065796411492-51845897658363.2362486712649198*%i
3847373938524404002.36816788352-2795280787477462406.25550854592*%i
-89130117558539540593451382.0920
-13105973067480184.4031759456406
-4779552365230.87505611315379549
-34597120216.2288474977804282444
-949131159.031587345804068932796
-55468768.7640556212650336450396
-5275174.77644744298405667171158
-704180.925489257934879901836607
-120595.763419037291232637298010
-24983.2319756579226065679629576
-6012.17418099968306780014737198
-1632.43599583892277673327426052
-489.415408963922776239814551954
-159.368692195186792822914220386
-55.6465218476205630048271930656
-20.6229611023394799643900078717
-8.04496771862613367957089980565
-3.27910831491837664599963758058
-1.38399371285452557210844411298
-.591791850581860828291512643628
-.233642239438236554827468100569
-.370707030698742050666766670748e-1
.128344270700209784528682688354
.353825317709156512558128481030
.745777346772050002623231657756
1.47311962276687391709535725758
2.83127395255428287566617218042
5.34603550930544404120514642562
9.95017191058400917424319953237
18.2854801150633844279008864930
33.2174823770101819845274434281
59.7073913963277018879163939873
106.280617711854622384893965460
187.486080665023598052463116955
327.993310730748881508556195401
569.384923920478596690658854113
981.366900072834148181854097402
1680.19233042232077634957005272
2858.82176567888169598102722294
4836.11628981496677622680715780
8136.79945780671147916527441396
13621.0164354767614329765668303
22693.6218239337498528243351981
37641.3037142348464480830317582
62174.1825871413130916167318282
102293.721437902699987648825712
167680.255375272602818240150076
273906.275999691906714342917993
445959.429346622568473255662146
723839.018516102185880951031243
1171429.51828633309247157796124
1890544.59996276595991374121678
-375616.452191140171397590323993-272901.326735355756270215314080*%i
-231496.146291712404062760633324-168191.795350279579922225731335*%i
-142218.653524354087722777604691-103327.900061102746434991587583*%i
-87075.9011821673467266824643835-63264.3453732368565803389408093*%i
-53122.2102725446656713628166385-38595.5449446469524975728619987*%i
-32284.3180329302195431030696558-23455.9300385741814996286078987*%i
-19540.5450950193235782264442019-14197.0370319380941939642677490*%i
-11775.9070736263341402817372233-8555.69729482868822779033062837*%i
-7063.78683627494983409566791246-5132.14154531819231075621728722*%i
-4216.26511274577342578553998322-3063.29591375512216225991398001*%i
-2503.30857215730057292789821926-1818.76013839265552352736263431*%i
-1477.85582134482565751441778164-1073.72510446730860935796820758*%i
-867.162298301583175735505837389-630.030288398971105035188164648*%i
-505.500164253731006886972304342-367.267367244030887876350224001*%i
-292.601893660966030753790817460-212.587719519594040270698862930*%i
-168.084678436347546334320226523-122.120667190112116182207631537*%i
-95.7656244346529939085549427289-69.5777988727647455823924068230*%i
-54.0790433727544868424840265236-39.2907248841526027747384169840*%i
-30.2455961532530454661635162827-21.9747118902136862665033374495*%i
-16.7398299679978337056912934797-12.1621983833290455174245116813*%i
-9.16020143200123060958931673809-6.65527590544450098085845301603*%i
-4.95129869496223603741083604479-3.59732907074750718249123740901*%i
-2.64155279506908861486661779744-1.91920044558912264002242754460*%i
-1.39127587328768710323321545923-1.01082109013130233046186849081*%i
-.726623275982792684603078576813-.527922711840075226042961388196*%i
-.384536092391185455082580826756-.279381824675194899566526530662*%i
-.224065004583706448849496771477-.162792754867778857879756562143*%i
-.178468517513333739364684133864-.129664967883506518064032817372*%i
-.235506757757188375510041733062-.171105675143253777371226627663*%i
-.445415936037424884340727739306-.323613620182504802088139099550*%i
-.975175376640696349969701324754-.708506383393111477709599115839*%i
-2.27408665398899849953608115951-1.65222066649241937310959004734*%i
-5.55150970004186780461417802417-4.03340789171470135065569630503*%i
-14.2025682054367197904671933106-10.3187698081465560881655952573*%i
-38.3134470332152587784714188301-27.8363486641117080988918929778*%i
-109.921093153097153648271024288-79.8623489005639714791179789147*%i
-339.059582735510917490707002052-246.341206385100917100107326368*%i
-1140.10197708232677879719427088-828.332572613303718597744734884*%i
-4254.70537466490397531171092244-3091.22439882703547713262773123*%i
-18046.1157926531791581304362447-13111.2705886717077804057932353*%i
-89866.1565693514104137611097730-65291.5845760221432536119659487*%i
-550154.032648124049717824879148-399710.301672511894533543660584*%i
-4432613.86979544374459105501610-3220482.48663280727825160815417*%i
-52329589.7231857609628295811767-38019672.4069667359430005066691*%i
-1087779033.08434623141170200107-790317728.608328007472977319696*%i
-56821896772.8914925097919094831-41283524527.4362425427207407357*%i
-17354300462689.1300321575791976-12608637329926.7646362606112651*%i
-672943545348466305.835071229347-488922104642364924.324937789343*%i
9386510359348100130246305.93437
2740103913446593.42197130210259
1269228133308.55424435095821413
10654465455.6448877354139846948
325412859.545587708703892370554
20684057.5670938271056790954955
2107233.40972753531226670978654
298131.617904950498411470718346
53684.7855869930830781826705651
11622.2198105831024469898199791
2908.42438477520415613621484722
817.901903294752544411439597532
253.118974707928394805161703981
84.8395751969386705778401793470
30.4178362597585284735824825729
11.5519970731609898756626305557
4.61196994843830498854256932560
1.92675556997040647615896059410
.845776720409674182557246250037
.404911973155250230792782111219
.242740708906488501920692813043
.230309731263093123371078667611
.343361566813478076545005042061
.625607188348972504534496827797
1.19494905584008722184478316212
2.28212461148792460457980387156
4.30927870214551975146405126880
8.03054796499907584982133470940
14.7753554626336890604690739215
26.8638083687005874807768807164
48.3100337716592538616826313116
86.0051195487553657619581618139
151.695043109850889702949934069
265.270206826891420259677571339
460.209445387079470049429700455
792.548579753458393111082008761
1355.59295995338253825920734857
2303.95791254432593291698952414
3892.70710529807332473426574403
6540.85249757713960007616288289
10934.0496503106230873430640507
18190.1831100124034587778360900
30125.6030506099205706902300742
49682.0602809304535614098234175
81609.6289983126119353919378962
133556.539196003877974838224283
217804.513656809439888691607228
354026.151794690985127100760249
573657.626027292152253920812337
926819.954372777444574979866204
1493254.77949761057994684289869
2399574.01894570537628169690666
183668.881973503394708227864846-565274.694341236064619263394362*%i
113736.513519334479406714497573-350044.995234166369457255958542*%i
70218.9480575659512837265255624-216111.700434534966129664072872*%i
43213.3455060843608934902558066-132997.002050342056691448430413*%i
26503.4944866901168815522538320-81569.3686593012659357545304651*%i
16196.2826875025862583642470511-49847.0325907632790222651902077*%i
9859.43015498021407240290639773-30344.2058739118620934345609126*%i
5977.24439249770627342683620250-18396.0666644632893257668068038*%i
3607.79327452057978055765431432-11103.6459665235880054473073928*%i
2167.41244437730352879412413883-6670.60959832880169267199443082*%i
1295.55709157671599942935291001-3987.31473221631099249110986864*%i
770.245134949847811755982537517-2370.57077142447801161003598707*%i
455.287888486277400305573466051-1401.23203906949855694188536272*%i
267.447432424568285706965856395-823.118559832884879793734673196*%i
156.054947414975477694980631434-480.287742553819895482954820965*%i
90.4010993476316031401008969681-278.225975204750325181973349232*%i
51.9604881440894792564943566503-159.917938944654126509080605943*%i
29.6138762393591742790810516271-91.1421393738211346828847722129*%i
16.7235537904424512515528132107-51.4698061839095398676714586961*%i
9.35036361657246372275880092553-28.7774601693275350061382659304*%i
5.17150138371378857318833164470-15.9162446711349702254932552482*%i
2.82678076211016314858204495753-8.69993661475016544965508987930*%i
1.52576700390364592728808954359-4.69582798947946166365524401701*%i
.813028648389254882188635327113-2.50224488639945735562617878933*%i
.428790497160588893361809226320-1.31968145400833667594188856389*%i
.226922831310760184515030710679-.698396662134323749145087141033*%i
.127386568462388352563791040735-.392055544613940965950918255718*%i
.897272807997344028302288066999e-1-.276152174952843776826654761769*%i
.100503502464266312544915456088-.309317974962724941680277127281*%i
.172768290666097547449015726118-.531726123928957416615398616388*%i
.362813953506804705195390444450-1.11662653176536063850603827245*%i
.824999465046974096074321087250-2.53908727175346307052154605898*%i
1.96921333112645890205152370480-6.06061545039394356461775825177*%i
4.92180921170429533906536755295-15.1477711839798212883802920712*%i
12.9481260628751788000902094956-39.8502344209807678283969871365*%i
36.1466867762539250173157287561-111.248062814707137406606086322*%i
108.209035563402295370384147194-333.033167327094765840778439368*%i
352.049258190969371213093222029-1083.49620620910666622409285052*%i
1266.55397823899272098537145534-3898.05232776997204306483338718*%i
5156.15066887946710954429589542-15869.0000288055071092636613236*%i
24511.6153664053502835319689711-75438.9950827577134318013805105*%i
142268.996135436005927433542382-437858.947256481143412891310600*%i
1077014.97496068642010880432750-3314711.25772772235636934942936*%i
11799645.2087669962882340027137-36315573.8035310405171965397434*%i
223536397.772571536276638319013-687974291.384102401661357117202*%i
10334858415.5557155124469544240-31807423604.5929494413218514398*%i
2642464917451.75031434211615709-8132670774004.41690224134713579*%i
73697084226236650.3445919770774-226816302860906587.001733368079*%i
1620386306637659397943205.12241
939062284008568.610034641863013
552471148250.998429662242663692
5378012146.49678240027313411253
182858806.416031709002299102310
12640480.2788805164300908115608
1379402.49991454780788460195133
206819.161456295723480150776114
39154.4040983922014503079259491
8856.99521472897134421925879777
2304.53527952552384857331030540
671.126671005214308439520787172
214.360965777141813857557384120
73.9436461980108410811198088688
27.2179273125760289617374508235
10.5904837076116702575046421262
4.32542044829548705097854194317
1.84895042772833922781626898629
.836032256711196965939597895203
.424695773320474581643563783423
.290180140863821978662019881216
.323794144897110753658983815060
.523542754054954204573744748778
.968720605544702211677923678531
1.83913792765111717345612375829
3.47384351125686504546295905033
6.48292312321491985523920651862
11.9435053911599811042550734531
21.7351299593651099892820144509
39.1072204135637911355883360100
69.6321647238799431422041787871
122.796227497808868189834547174
214.640680509448444624626976654
372.124620894943651715023492051
640.298744405624262496653297950
1094.05106389947536687730619604
1857.26248607136629171351261205
3133.93213161996353354783677438
5258.57882829056448073881621922
8777.59571783802459384125806842
14580.1743527056624873850780309
24108.4102358681883042931783060
39693.5903998260429668165657523
65093.1118618073794023554424094
106345.732020759394780519807816
173130.895812520275573273540126
280924.763220464339399730769492
454413.191319387531288255426091
732884.471450994639904311941127
1178735.28024667729431684486424
1890864.81480960210883592499343
3025733.01506298765541799888738
755607.091464233334615954381578
470089.625368436453511398345533
291629.082464038218915165754549
180372.238025591517066015890408
111202.397000549946461898877960
68324.1393615351653280055637790
41826.5545959875254833776195655
25505.9672693057591168989617417
15489.1579349514985695396343862
9364.49238816432914815829924895
5634.73689317161627117625609076
3373.22761201540623336258006920
2008.33175892582000209424323415
1188.67216386558601389415328531
699.079224520685106506334560789
408.327578686294990698260683741
236.737049152841527931409655861
136.153830631525122215022105327
77.6248282561495661373069168339
43.8374723572662878123583208624
24.5014743984864286634725874298
13.5401528727292899365033160638
7.39043950638560898364639385511
3.97926215159634481488329345305
2.11066846455122958540693579229
1.10113180879545202075503769419
.563999841693488536789105095609
.283035506569190997703754815142
.138831207565746340409771362666
.663758939415506795289388461276e-1
.308316894055464705212982405853e-1
.138605429118424229084866050174e-1
.600308652122966012367777545757e-2
.249112715932323515931401192394e-2
.983892019357613695878970935046e-3
.366830877769046608962904562548e-3
.127792031478216948986660758608e-3
.410596692894984907889091177667e-4
.119643676883883130108760136060e-4
.309193194731838212643255894656e-5
.687379084433639807241895986035e-6
.125906647437800928015975397161e-6
.178244157622386885240044846624e-7
.176350291564386035923639208706e-8
.102639784715507425441603561983e-9
.251770973215016063298386973284e-11
.117930588337327457923571397153e-13
.588786703348511985686506696451e-18
.143972932477264751642926107667e-24
.125034751661516267690300162910e-15
.166998283567959747676082110124e-12
.147477275310894203366948571223e-10
.387972870794104304926566060164e-9
.513330393125480059996370864037e-8
.436368166805557312570730162805e-7
.272612036891838670028381713752e-6
.135827218410742050003007797296e-5
.569371086833534516023994842507e-5
.208343399404464452496312686178e-4
.683347839399887522420821398272e-4
.204889684592240716590392331108e-3
.570064220675088683523850956551e-3
.148910631637850858564707375278e-2
.368598178630868040170390330670e-2
.871072738084252345196798491901e-2
.197735703071851116406088637802e-1
.433353443827237478944681732199e-1
.920793968939996960305883142055e-1
.190368488518202071016305055238
.384111861869004285140646745705
.758366737794168348101504106850
1.46836198628562143109458528236
2.79359612273565669607001074195
5.23126897088928485966877599726
9.65625418501258675517655112814
17.5928640828479731851968057536
31.6732550117714506482262432967
56.4056516242521266661229537791
99.4541669194332887568091179422
173.759336083970066776342914036
301.034073285353105214476458679
517.500609816019404006156042486
883.264789041252158282675704177
1497.57334768734480218695081048
2523.55496899698163098161797299
4228.20300827535777329986550673
7046.78354947056424282241211510
11686.2812130251692870320535004
19291.0805582771028206201522982
31707.6325401472684772798473315
51906.2073787246996983123932105
84651.4199224896658751478633951
137565.954470489153767169589739
222814.613256365163536903853131
359765.294193959052544703080706
579185.958669390125972596165391
929852.794730798876071948481728
1488937.84800673371922092770701
2378312.48906537866080877941243
3790098.28330916877891140770974
294759.505295576756819595545054+907176.476874118509626507098263*%i
184215.656707001090966893429025+566957.493937065310954469829933*%i
114822.012633864555124854603961+353385.817988573898399647649547*%i
71365.9277017114252401621081287+219641.740802796621843763475913*%i
44222.6820753608803273107772139+136103.420593073350221682744004*%i
27315.0687737672924705431731506+84067.1374818334322496989941205*%i
16813.9570389182052786550106095+51748.0387734505318574441267753*%i
10312.1036383764164999116776237+31737.3916014761297211162724489*%i
6299.76917677857593489813710878+19388.6958833755218327782641777*%i
3832.50227099281152530671056932+11795.2291456213477401301780600*%i
2321.07901045245052953195448374+7143.54665895253491026370363048*%i
1398.95609983075248097194699884+4305.54415768000721355106951369*%i
838.818522183255560058308200589+2581.61795640108073440676821157*%i
500.160383324820968108345802482+1539.33537770606562602799360742*%i
296.440855571107883441748940573+912.351140937345734319270348655*%i
174.560017692624821964917310763+537.240492701612377932344622304*%i
102.069888035690525452343670069+314.138814048766093789780948686*%i
59.2297011034194310052434853144+182.290275997804923862340784906*%i
34.0866644298518727986246666275+104.907965952972404184548487279*%i
19.4407614222222508587974453071+59.8325113793251870110066999326*%i
10.9791180446902738312600985137+33.7902508588470138290439672398*%i
6.13395168566828319435020628565+18.8783621208096699344205374114*%i
3.38655283983583278771063747565+10.4227379229368452615871548660*%i
1.84512528999895639329064819604+5.67871172905550332405233645789*%i
.990042719701487830666189375517+3.04703817952548300616480498326*%i
.520947659486952074316663943733+1.60331203533297211531851461084*%i
.265422051891009577724924852466+.816885079508236013384410789573*%i
.124517693023451971993164499896+.383226053905320038496110348620*%i
.398363653730407187034674922617e-1+.122603725889505742161968574542*%i
-.278271436615500479407459667385e-1-.856431419337632840592935536134e-1*%i
-.116178085375011922827404892947-.357559380739215270830691083954*%i
-.285293562623226294945177092100-.878043300947580769359398536479*%i
-.668024025534050045237587570899-2.05596654582368694063537346415*%i
-1.60222252125912667692500282114-4.93113387657064163309501064456*%i
-4.01431861810479490929666463791-12.3548023239172404299278851826*%i
-10.6176159102555137752570339214-32.6776616910434375250420230154*%i
-29.9538349463880293794822160786-92.1884246897632271294881215564*%i
-91.2746814896386763194634868914-280.914584581575788686463222738*%i
-305.324302791573103616987075691-939.691580201136806285621132253*%i
-1145.58634254949342327953371484-3525.75222687738642098704663421*%i
-4964.97389562859340125297249729-15280.6184210810067463846903722*%i
-25912.8187019982904677476199779-79751.4555209471572224431403838*%i
-173236.356715464124975789203067-533166.683103403591715362649436*%i
-1635036.81779599254822875133403-5032125.89680614065590475441551*%i
-25732354.9568015499592434085107-79196045.2232981592479724135496*%i
-932130869.482223860850247302217-2868803831.49829519720494810505*%i
-167056568043.853823900794803127-514147249245.566439825373941049*%i
-2410322044412137.95985568447045-7418208475377836.98159401320526*%i
-19212554485994467704498.0745265
-43880263235554.4177333491464740
-41641616542.4267612804473472651
-545022583.604616883079020293124
-22961603.9655863951475152462864
-1876865.22664685583818428001963
-234926.020504003993400605470428
-39544.8968358821326854771330965
-8271.94042760434259879766666208
-2042.05562903090522995440563419
-574.150923580867211399213048661
-179.223789460927548387186059335
-60.9470812027337316724450374602
-22.2548615507541907662995633828
-8.62697458864364922287789116813
-3.51508608162759515414210405860
-1.48660915848330658924620531824
-.631723933364660627524559002266
-.232671660550740067300084385637
.651459806675881588550028827908e-2
.235706515951340015912158718997
.571658469499623520566707771677
1.16134214452810275311730665106
2.24124305820458323251551257041
4.21959258292990567193912922867
7.80877029577849166700718052121
14.2464005984610598852942473565
25.6661174555070643400954154631
45.7170635598031276037320334875
80.5935985387560754548144691076
140.737818286120554743873738820
243.640494369869999648068995521
418.427826493013093259534156081
713.340511912042040046913998205
1207.88073829236370367577663185
2032.46814025601249340273402674
3400.13817618168129374481697126
5657.49865549529097253178149869
9366.40219695374182048458178157
15434.4878776400537123872799553
25323.2933842194604165643619803
41379.2270153926636957466612679
67358.7320405574218908399697933
109259.799249088129821395381382
176635.879976783042021294222036
284668.121462241918537882908222
457427.733342120552970835677682
733003.310968186056751431647515
1171546.33232916219722688950967
1867876.54898587968939438679208
2971203.28427389041269911072175
4715937.61832678907523015054688
-967273.536151779624396945146654+702765.360228398803065261332454*%i
-607203.779377290439325442950899+441159.368883186011754275761371*%i
-380218.065145746929702964526491+276244.594244297968417271631632*%i
-237451.790901220855935593195616+172518.824440773350914465362147*%i
-147872.758284383517468807591401+107435.847627061672687530145316*%i
-91810.0526893454141200326221468+66703.9077772223990564997684132*%i
-56819.0548519030440693188556620+41281.4597509769037187676476925*%i
-35043.2318810987826938615110586+25460.3982803715677636437457983*%i
-21533.6084658744174989700900468+15645.0823318740402381323763454*%i
-13180.0975548972386802071985129+9575.90139689231557002004607552*%i
-8033.14581655569934492084398409+5836.42206939606683297093518510*%i
-4873.96193494920647667054881737+3541.14062561989677894630462766*%i
-2942.78876448649813657422534745+2138.06118833579293279480065703*%i
-1767.47259440758660899281806913+1284.14400692108185617857324178*%i
-1055.55871100983373306044541617+766.908294355164763083102878261*%i
-626.540019028286353969837333599+455.207969321338080672102666263*%i
-369.429203874513896008796212534+268.406027701997188585784305231*%i
-216.264209582004218336424853633+157.125145546790535847652500838*%i
-125.613553127035274595689858915+91.2635884406519134751648756123*%i
-72.3406641814226088784536609679+52.5585690319576429371858533016*%i
-41.2744906952679198054174893919+29.9876728118736999277401265500*%i
-23.3104230446675786224162170980+16.9360136877472040100865575301*%i
-13.0181907665983012663490391819+9.45826922962037679782398466589*%i
-7.18080157166514273309467038046+5.21715772698246142864711626974*%i
-3.90643161498326055227356899416+2.83818870103000273347788415293*%i
-2.09137273578462705664306926692+1.51947123445845061587208627168*%i
-1.09701562494183338804427697631+.797028505406620458295351295354*%i
-.556516526921643125767510585032+.404332924346414076108717463371*%i
-.259245501114678293474161281426+.188352881753874970797831930505*%i
-.807323648448451097559287845051e-1+.586554964462248908065143685299e-1*%i
.631542295304954498339297973214e-1-.458842335773169798331696383589e-1*%i
.255118706794606551795218931541-.185354590176011883183586226326*%i
.631331769106794504052542267430-.458689379536947278527204994037*%i
1.50246523676503305388582792178-1.09160489135944020166997242968*%i
3.68356167452847623917753170231-2.67626421107557948862603814281*%i
9.49013256037723267045308892997-6.89498490152246277582421426946*%i
25.9996008182382050422057441857-18.8898157056130348908607672372*%i
76.6950649496378829020020856982-55.7222263740452536201289922115*%i
247.450560372699841194825449875-179.783355689524519025814374793*%i
891.547811332358503871146301695-647.747400683058281691746318762*%i
3690.24199927471120957374263917-2681.11775110460581495841562709*%i
18267.2435360161641410772937911-13271.9292983467715521425310258*%i
114784.894477869496108486349875-83396.1074107798924785648855714*%i
1005689.24832432200095181971327-730676.008865364055764117923861*%i
14428134.8744522318123038750279-10482653.5860868347008996218722*%i
462672218.010501883327102031383-336151042.911197501828990581022*%i
69427740950.7722881843596095154-50442206424.0754160070262757250*%i
720523062918323.715286186361537-523490647618844.611551735431262*%i
-1320862223163580322850.21031018
-5988741439738.81954490894053962
-7217574145.98774868008458230032
-109528625.369644242920413409606
-5135836.24603281193687441696986
-456425.869117056948469291760178
-61175.6689873509171048595475756
-10908.9377579266451586495020238
-2398.10469298531161115933088544
-618.304330343275945591258981881
-180.667878586997749603826908900
-58.3722973927292824355280779746
-20.4757696603002876809323810756
-7.68913955655978509254784687094
-3.05508380081022136673866422052
-1.26710261190140821548380375316
-.531388153879784832138390697028
-.195727612645393335529290709601
.726645093668085727487900643759e-3
.185844182270229324998623655882
.456294455899035716051201176422
.932033761046044016442216271388
1.80543368489051435069725184006
3.40835019184122740086822381218
6.31956996069315414669574836998
11.5437910358066720525324067196
20.8111478050784843543605116853
37.0766561881591083974225870881
65.3486320792554099993735365902
114.055459036856613936358212075
197.289256402018463332997817676
338.471974947953539793485071829
576.320061969103564514889386299
974.510484062320440840623448431
1637.28766060359759953239046321
2734.57719387642684374191337743
4542.26994108395333161031601523
7506.65061563566431131463111429
12347.1599411121540001945514606
20219.8785841752003412847104435
32976.9903173068896792691364661
53577.6481676884413726835810840
86737.2197928091129150058800014
139951.184250098937509966240919
225106.864134575239775037548205
361016.019664359121250046018458
577387.838327474293224690605676
921051.769817554614809676814555
1465689.81735079730998392785454
2327036.13954415335551889816586
3686583.77379590561978390607621
5828513.23048221897626589100494
-1203767.37767206194173158244163-874588.193704243897674637766813*%i
-758935.914267440841106960857896-551399.217745926305626657151971*%i
-477367.398611667181197906137612-346827.716574663476276333737505*%i
-299516.565595718818744260384209-217611.522747397050679589457919*%i
-187430.083851171668178222089445-136175.926945487030853086529279*%i
-116958.574559268398045638561489-84975.3784321943493192971789248*%i
-72763.9896405236339779385012020-52866.1329811819317198399072981*%i
-45123.4867347413451452588413851-32784.1321246753441915474420429*%i
-27886.3984549870771101723229592-20260.6544304511010111082402376*%i
-17170.3331140530986859432245293-12474.9772273782988421302614785*%i
-10530.3870659498307805601545855-7650.77403977014497997604398820*%i
-6430.73800073538106510057936075-4672.20464399442407072709190207*%i
-3909.19282272475463270883720907-2840.19483588285581569399509139*%i
-2364.65574186277145588926484124-1718.02296055537005226221357910*%i
-1422.76151029541194206025356674-1033.69674443875388129900181044*%i
-851.119282146368315552604562275-618.374354884730455355709293180*%i
-505.979899932418214461099039009-367.615915616798659196750435623*%i
-298.763687205592767120647518201-217.064524578554262799168633287*%i
-175.111575457876938239073639015-127.226006716167421396121525351*%i
-101.813418057071356952512039380-73.9717781400512820734998873588*%i
-58.6778788007376762716277410870-42.6319744018801249960728161475*%i
-33.4934413415042976863804965473-24.3344095438557982812057507132*%i
-18.9170651149492951860718957525-13.7440523110572837438652634416*%i
-10.5609439086462558659931564868-7.67297488551066780985617442580*%i
-5.82125879422325241212998761289-4.22939208052840070805483232230*%i
-3.16467920602355453653484922781-2.29927403067035162463914632832*%i
-1.69609768511524503519263857514-1.23228709988767068536577673221*%i
-.898440534737981351870713216535-.652755257371021226195597965095*%i
-.477439917128902406122999536184-.346880404361502756927555912420*%i
-.270569990837800602498622070448-.196580605145682982546890930630*%i
-.196190611089150493080062142350-.142540822551627988094645686201*%i
-.230829144294425741548171274354-.167707190032986303276593639361*%i
-.414051673539303845448703000879-.300826149618096207009093233009*%i
-.899838334992905636520107825003-.653770818701880453861032021036*%i
-2.12388481721133596586927015373-1.54309264428892784706016549835*%i
-5.31532654980552852119747229392-3.86181078866972145929756554891*%i
-14.1376523813892436894168621104-10.2716057012355516033633754555*%i
-40.3776409772039065427087831032-29.3360733504705765570222922487*%i
-125.676610898108922006009785258-91.3094025930581445843549164743*%i
-434.892135546349125413696590015-315.967631569494561864156006637*%i
-1719.44678374746580425711548563-1249.25121303457087702951531624*%i
-8074.15039189404887132178952480-5866.21363722217757407946186186*%i
-47693.3625439515814022282990730-34651.2561917587717361419858257*%i
-387955.034245456092738226512623-281865.831333100024802195321167*%i
-5074192.52728738998219676989180-3686616.66636129146733753397951*%i
-144055912.355538365859664646929-104662746.736911546441375046838*%i
-18100409345.6257291230014921636-13150717163.9027772080318667170*%i
-135120306827428.807851097214611-98170649307260.1503432247215866*%i
149144835320537871061.592516215
1342370129851.56435494973627529
2054501788.60648922267251804829
36146232.8482527413690869041346
1886266.21020094937874965216426
182239.054454399902603720297254
26151.8756223896966462693517220
4939.52953275173390639236751368
1140.95255931935286236625861691
307.183089017483735753763590820
93.2638787932774964306028020048
31.1829379383896541891739773329
11.2825360046824307492928869243
4.36100780047883440626969423061
1.78698143780269739428416316444
.780344228473670055490232159209
.382209620604954740279404243255
.248957151127159030582795244324
.266103339190391090455566205560
.422401151647227915605722340606
.776973833543024388344029484973
1.46930565483889098607595625153
2.76159675876361805673476625757
5.12082063461022687746113028364
9.36142704235935700511968773359
16.8863840476207044740065990096
30.0894402854289219128298069585
53.0214072853459436683629558188
92.4871802775002790843249060690
159.842567750305696573622395044
273.923523641953230151427864125
465.800933424083034705983629086
786.468184238172803359782607965
1319.22517016846899890342851897
2199.56055794880925687775784961
3646.97251004073853966172244083
6015.74835969760756438924018658
9875.77973478478745285254798093
16140.8538972295185060234983284
26271.8314402674707087687501876
42597.7123936669533095632679056
68821.9418478219137802763023607
110819.277325091702110336363569
177887.675396953384837555389225
284711.634993010251411205498307
454436.331532710141822598374791
723473.624451834517534155739756
1149004.76345068785198074882787
1820676.92864587973063696437063
2878814.26197573516241554015656
4542736.92393197931486818511303
7154747.40758698448377744696287
568091.203516735502786890488502-1748404.94467753327729718979638*%i
359672.688115827068239999500516-1106958.71098565037946512363587*%i
227223.189396886756309212066521-699321.069271252966030870834396*%i
143216.466777764992618764363140-440774.962054333928544595891969*%i
90045.6174913384229634825551132-277131.914547872305302152943285*%i
56466.3987156526430837353242978-173785.705730738012335157931458*%i
35310.0065820752568097543473802-108673.025955202855976716140916*%i
22014.1077910292640020387928849-67752.4571340522493992285491083*%i
13680.6787108270556609265668815-42104.7996456963983553597269380*%i
8472.59742226867191987477637650-26075.9736036297802855136401320*%i
5227.78128559288816682397080262-16089.4563986221136535096861552*%i
3212.83922777059441262429668342-9888.10239890041264301608434906*%i
1966.06629329172075433705238833-6050.92986385910231160250040422*%i
1197.56266232285327285315800067-3685.71889056681262808994935608*%i
725.817453212849218383834246559-2233.83642674765577460369891670*%i
437.528758848171884597096584652-1346.57505814774009548124628875*%i
262.202806978449322388523541303-806.977262438714127390418795069*%i
156.134532786669733796385648274-480.532681142083280890895083537*%i
92.3305931499448099246975489064-284.164346515211364574696847178*%i
54.1879320297745999361453821149-166.773306321608899510701524677*%i
31.5400250301905667779518754008-97.0702157975129320488946500781*%i
18.1919142192079827174512387741-55.9889549021608124546632501314*%i
10.3887520011460063205518332725-31.9732910057235329227200748875*%i
5.86789989829451626300832142198-18.0595389147733765031574489206*%i
3.27462229702958249729260071016-10.0782511340349587535877593409*%i
1.80352393127176976414804879444-5.55067591217671898154514714470*%i
.979615625297708783067570284956-3.01494688273840001701181171088*%i
.525411973528174756953746277517-1.61705178116242349124750525484*%i
.280868393749325131478709644745-.864424031555154803691406502191*%i
.155784303027862534235624295248-.479454784779173503088753902227*%i
.102473026138458918157411146294-.315379545550864441466333909037*%i
.102080350349389479889975603663-.314171013739398128992668343502*%i
.162784388029456948303948706152-.500998831147408038732807813839*%i
.335127279940170122318575921325-1.03141571233018412654279848226*%i
.766292150347202562855744624520-2.35840473579020946841658485892*%i
1.86498943274035925034632184768-5.73984727415081820410192033833*%i
4.81754549912633015115634498293-14.8268804722538454301996826516*%i
13.3246452821631254568808546574-41.0090414236133603908490670384*%i
40.0181468671361414504787690608-123.163191801246345282865031122*%i
133.028651218502883606551001223-409.420089827815038428288263647*%i
502.497225266116863035878175576-1546.52743767777266179362286894*%i
2238.76769711693516850478314500-6890.21848497654538848768859081*%i
12433.3694852421074497486961188-38265.9765763467888649789184022*%i
93911.1001746814474970628580958-289028.646965633155025772547571*%i
1119932.62107940407157261097875-3446798.19064161308334342400469*%i
28151164.5548851852816361097857-86640375.7028816550410459518023*%i
2961960355.10862851144575153792-9115976622.68359344683649888016*%i
15905402546244.6549214540402035-48951795568722.5315414846669158*%i
27675086578467175350.0121408937
494458837367.269970923599659680
960996439.942867955762080051261
19600422.0601482503625793456660
1138197.20409326611592054480047
119531.016030612951397435610664
18362.4470806650481512221969843
3672.98658481663321808184955552
891.286092110851697710567773326
250.527480721743174934689762928
79.0162748126535161504341949866
27.3338001317962238275595219992
10.1984138969851457553576982398
4.05537063014044397029234352190
1.70977790714653625971009235601
.775459548208289971400395242142
.410041950227099653984217001594
.310361891344898746309826584775
.384545689850092669203989374629
.646588803749836361742671493175
1.19540956720920801735261791344
2.23797772807656077604590906720
4.15132247305659811990485610838
7.59618927186276196177475339065
13.7110269889326473147145065159
24.4360124984989500724805513471
43.0489309157954340334971155950
75.0455727458993486242833260386
129.578340315078871405975480112
221.795821160647933385233769204
376.631206483623547154912584347
634.912621902150649464272092651
1063.18274033498581713169282308
1769.42659868965267756151607970
2928.18442463639016313266978005
4820.53446865889019987015764667
7897.58083399355211462786454859
12881.0137064889032517550352152
20922.0201553905304311659449939
33851.8592964127519360030368950
54576.1746494828839951703471144
87694.3150024296183736617892468
140470.324087577634415662614575
224352.730711095762374077416667
357349.559488384902339766841076
567734.284762769371167868281978
899820.451374915834669801287649
1422947.74396265096811004253036
2245447.92999481635911037783576
3536324.60168042427875345785347
5558869.35766488654344713940948
8722730.69378087683507098262874
2254834.47890483495802486858590
1433438.09375615446872400364296
909427.924459689439498426978531
575739.429097221052952862044778
363655.754227079253162253554498
229136.826786331182729380690976
144001.329891961003370216925013
90245.5888381115450208917851152
56388.0076079047510183934354121
35119.9676234002759778916764201
21798.3840313931622254785163122
13479.7994719032408035110282211
8302.44922868275703998114916224
5091.60395087870316579469972851
3107.96470060477649796850321773
1887.56438196601194289273031599
1140.10364832443003035937875599
684.534458740756529493507054444
408.340256222313467496575321911
241.860468993228907495691303023
142.145001179424972710777248888
82.8311848006227383590193907677
47.8168364114564228087126458396
27.3194596354900116070399142559
15.4308315072620764188223934862
8.60569447319995330621991136179
4.73188788477736417321835035295
2.56100860570168594988038807611
1.36168302300011554013125791319
.709658635215394360480954666257
.361559869151782700757203281868
.179517016156414635826755646191
.865365183531757164976443043041e-1
.403183027263493430523013888445e-1
.180562660779170094948510536300e-1
.772030903120705848388667409172e-2
.312495288069214828008084265077e-2
.118461227986529567768769066873e-2
.414730632682224057368015100710e-3
.131630693989062538884084772204e-3
.369266286170447139672896111443e-4
.883320625059197723687911804425e-5
.170832315236104341891426971378e-5
.245628559119217478328880215606e-6
.227464594685878177650073548499e-7
.102753651634898080484217160202e-8
.117063865071655743797740955824e-10
.303701835991904506021509140119e-14
.938516806001227739148592123214e-20
.264304192588127953847217732666e-12
.106786943456540803153776427956e-9
.449620518243652240767813336777e-8
.691601305132644216920083112918e-7
.601288553747047872351412221266e-6
.362352525062471128432101153912e-5
.169289781577640190074673589039e-4
.656383477615289997279696289687e-4
.220820227188307226044863071843e-3
.664649553098068138328471851337e-3
.182970173373491223477722571485e-2
.468265081669780112789271689565e-2
.112804210785693023863289983275e-1
.258274379327300598619365886118e-1
.566354686914431292529923615797e-1
.119681208125896312353074100930
.244950889903710102176896167148
.487585635841124427885742700077
.947206598245264144017770959161
1.80104524794106636379916446189
3.36017815341145161760028989005
6.16414305464043559711772815831
11.1388919344569358321887462259
19.8586416558911084095441856061
34.9772430787812319237027401378
60.9347904877855991337689195043
105.109150688160295628228817490
179.683789468197572485207067817
304.664531848590619302006809627
512.732934106416793978733184267
857.026346577132145392882014543
1423.56823845306000368791870262
2351.06758766070907954138783290
3862.36665576465410485455752687
6314.25893542394286955292491364
10276.2154710969540592549849323
16654.5115502252273444385667408
26887.5201781085574908373331618
43252.3656045470517187631972008
69345.5423824516900264765329122
110834.879743541525829811874977
176634.122924555614406662746709
280734.830063524321857125639935
445059.296684611364332742884213
703897.531102858467403853451454
1110798.92817761600919559844759
1749263.66285845274410436014807
2749309.71666783972905569894794
4313116.66380414688594570412152
6754678.29007108256654270907348
10561056.9351381908604188663742
848350.161529512763295180164587+2610953.32589934842360405660147*%i
541453.086238307609671305841824+1666421.24966837208472264835444*%i
344936.670028509085110743255554+1061605.91071479505699402812585*%i
219309.746747539305240865304786+674965.997106975794334563948349*%i
139142.307642010755397544148701+428235.989554390954319700046469*%i
88080.7161927144918501134101691+271084.570168923156122016018747*%i
55623.0707552091863949472486647+171190.209150441602370151959398*%i
35035.4367519967879228337576070+107827.986909365345568309528958*%i
22006.8391789067817654199911986+67730.0866461847733430054959400*%i
13782.1453702549302677827513069+42417.0819129897362490935289488*%i
8603.75280058787240474244640610+26479.6283522947757751091194088*%i
5352.59404085611690118390363909+16473.5905607252366907586514577*%i
3317.63470026513207626551951731+10210.6296993673532959597483618*%i
2048.10012666367243617797929077+6303.40404231933590878810177040*%i
1258.89347439651197361541784235+3874.47572120750127628107356776*%i
770.164156713136968366792209679+2370.32154603848356817022191360*%i
468.767960825902210056934224128+1442.71943578909333521481833673*%i
283.737410325709311165885076571+873.253956640175301418918032219*%i
170.702638271313860281530323137+525.368699560005025333157319621*%i
102.019566352401520597948731009+313.983939832544576490077100012*%i
60.5300098499727612471916613365+186.292214820317097372734293780*%i
35.6280006996557117670685369325+109.651711215798794022915371626*%i
20.7871089544979039157155002238+63.9761430147264925562805438174*%i
12.0109849761121072157450848132+36.9660107262395366295618417821*%i
6.86570866873264529267036003125+21.1304785407998878769638499036*%i
3.87770777950998859049629389694+11.9343573949742992945606899829*%i
2.16063596583276315292888249779+6.64975374187224845571737283043*%i
1.18513951389740958218544332416+3.64748437117793991036920860416*%i
.637431627219014154124164163426+1.96181282516679301709396997913*%i
.332770753726393883948479523651+1.02416307039712306587215471631*%i
.162583632281647364327692508524+.500380968487381175190375942754*%i
.617535267834853211872369971670e-1+.190057812744043852188637975015*%i
-.129542471678387157928852346415e-1-.398690732449563673608850733959e-1*%i
-.100727364142072176746008567639-.310006950363112480734779625908*%i
-.260510726877717429223101981827-.801769575369109735349283299501*%i
-.622163951052564887001217643102-1.91482374957838912372645055444*%i
-1.52742657488986698399597672634-4.70093562378252790918999399042*%i
-3.96980445089505113354713049661-12.2178018043247455260492336662*%i
-11.1109296393225699969409498345-34.1959252336556497371256734986*%i
-34.1100860371206489167881729863-104.980050248077700693926595538*%i
-117.686811109835884749112982105-362.202761095395615348820214143*%i
-472.288792925408218975224982595-1453.55544277890116250053411019*%i
-2319.89194294811047060168977871-7139.89324083691179722520189825*%i
-15115.3135132959414553426196523-46520.1515591135597501456080218*%i
-149916.151006143706659468030697-461394.469908287787406070198863*%i
-2955106.38116036966421081700530-9094882.25989880912063138240613*%i
-218075091.358052560637779982524-671166118.540667740031915353259*%i
-606030022505.360536304248527910-1865168623298.69644033689072536*%i
-382308318341842217.725692501124
-26913944539.4775360312735908171
-84335141.7596617995213020951259
-2311050.32348421101039792790933
-166122.785175219199060100267575
-20603.8547757935283922115475201
-3625.34615628673381956055500846
-812.821349939907781381814761896
-217.542321056830481726780929408
-66.6030959309126112420402351183
-22.6517315622578935027894812462
-8.37784763290450019865736104805
-3.31278346253902574379978439288
-1.37332201803729440943048014117
-.568847313024774578360904350067
-.186566931596641869775690429610
.615220034648872845300815998297e-1
.325367844098132162035633074454
.730136863280848495817520814603
1.43956447058444158259836453631
2.71595205502839560087061748782
5.00276489933472781037709897422
9.05490179930922802933290746215
16.1510382323146465012002683738
28.4411705220478166451769477247
49.5137694957055204782897442022
85.3172488759947200307860940451
145.650435463473436403706509539
246.563313289902913499147939049
414.209048453682812567970220977
691.002678275985576869475287160
1145.43558222077882186622858722
1887.66870420011220067818229509
3094.23811993671851658841134741
5047.09715298837028825558208542
8195.16695845698049587460196271
13251.1563582392410432077485272
21343.5452056199137044714637395
34254.6998099519572462874434315
54793.2591944636076700071405932
87375.5210767884217188525096819
138931.688043749677363932388716
220316.392247384255277190053087
348501.030046972411015012750900
549976.749588032996804296413172
866030.079490451295612278209527
1360912.11719878982785460347659
2134474.32683143033440744106857
3341692.66956039342447213080870
5222805.31973590311805168730817
8149790.00113336334573931810745
12697975.9320095040263430457869
-2684101.81503928810469445287975+1950114.11812242196246727730590*%i
-1719693.78226855735902124493439+1249430.66796449832067818429053*%i
-1099923.00878194401305236394162+799140.843411696365741407976605*%i
-702236.717507933114605880764070+510204.839996400196054837486420*%i
-447467.692948232625975626914704+325104.308835335528452213675136*%i
-284537.090209187896014787311360+206728.296831872793671224286385*%i
-180531.125630048160192103686866+131163.540398908589832802840717*%i
-114270.066255190415679509100539+83022.0628123861265156228818828*%i
-72144.7622660614280117097437001+52416.2379591300383493815418442*%i
-45424.1332393187234561784620688+33002.5645961469679327812635086*%i
-28515.9309154769509057953267126+20718.0365357568488886693113677*%i
-17844.6512437846589142271797667+12964.8980260333135143226788629*%i
-11128.5505407437869399437891507+8085.36524290741685327100707186*%i
-6914.45862274461349465191950552+5023.64824755733741049278017755*%i
-4278.90778299216553373292869356+3108.80847775694208745463692318*%i
-2636.41851472349697745869308340+1915.47017256734825383332650122*%i
-1616.72953987230331824743830796+1174.62276699976715260936824935*%i
-986.320302975668415402542534737+716.603646346955603616952150532*%i
-598.343367127098488866671159981+434.721902567761883923648869721*%i
-360.748361378634587173569441990+262.099026449824668955648984076*%i
-216.033173854260336563321336249+156.957288265095937691514537839*%i
-128.412221161609937131788290406+93.2969397895395835388813662644*%i
-75.7061425260845441780236387476+55.0037321764356226604972592502*%i
-44.2301493153193365003985198799+32.1350844976066926519010977325*%i
-25.5822011493796136785195960142+18.5865570950119134149717092284*%i
-14.6316387664287032839614766093+10.6305078182223501615817853322*%i
-8.26416797609011454552581920307+6.00426949320945863925668932761*%i
-4.60187927548433890925705306033+3.34346100238587016524096670561*%i
-2.52057262751349273784657188593+1.83130320881476787011202628241*%i
-1.35239734522312656856295372057+.982574186066149149040767069718*%i
-.703390848529856460106734189170+.511043365266717794081961909547*%i
-.341611048894394942275534427054+.248194955058296644245034421886*%i
-.127625833551467895365346984106+.927255957472748903405619337387e-1*%i
.317938616131064965253466105850e-1-.230995925914389951830326671178e-1*%i
.223090146546268788949303804297-.162084479044812555710763154124*%i
.581526726151466427499352763099-.422503897720767627566570830820*%i
1.41776865893699925140115919131-1.03006922559085772485383592009*%i
3.58557177973816703541770700458-2.60507038519564889717982836197*%i
9.69761068710443699450214159948-7.04572658422066243835453392611*%i
28.6243624587622300308100425565-20.7968166633308582984741528002*%i
94.4242799164950605014995939998-68.6032550356161479466664062023*%i
359.769095405513378434843855139-261.387548074123556175056388691*%i
1662.51962527714698859033415300-1207.89121140738365172809346812*%i
10063.5665228317448458279444727-7311.60906224829525076914517160*%i
91047.1700453546788146574961702-66149.6410924859564923476060773*%i
1589586.70129584815592011000396-1154902.34044318798803293333040*%i
98254207.6169857675765528902073-71385860.3892084249108733318271*%i
196441908893.158631077911055086-142723401093.434256387028762819*%i
-28501880803524958.6566611011668
-3982716488.23216400662463341801
-15844755.9185542252083995602415
-503205.373330176633157736315981
-40235.1836670924014860114270596
-5421.74623875355012373362705898
-1020.66358294957830420068888145
-242.190454760411662067389511911
-68.0481637918387450734704074132
-21.7338621754285401464748999454
-7.67091098387275175640354912467
-2.92862482484817029982335427336
-1.18321121349662783037976097545
-.482296258514604643763062895546
-.158928624316357837037001750775
.453279503141674757122756494708e-1
.259516227296428565890129777994
.587774141701785611630672607785
1.16439424607617647915353997161
2.20364811510219550873701785350
4.06711797407413669920021528309
7.36919620657758943973826582249
13.1484278692361105974056699598
23.1470922337886665926206635546
40.2661086918224255022173018486
69.3019898819722484735941074683
118.135439491356720217382003450
199.640440351174000524376155310
334.738871077546416579576768039
557.270907574179517435343139638
921.735631444530030871030422224
1515.55693907021246729480125243
2478.46734356443914750089567324
4033.06300226695637188772063273
6532.85574735416331539767962217
10537.6779048820689785457994783
16931.7716474725043096008822388
27108.3783018611889336858972568
43257.7705010250809849673514273
68815.9600757035731480723000010
109162.641400555303007112678436
172705.248027293359097582809100
272560.454389560419264468390971
429159.077512910680108851554352
674276.646872172767180821683628
1057262.89534204745521217585407
1654659.59428606117639061315693
2585034.83051303929762374774504
4031841.28423724911019230791438
6278607.16371788799231616125909
9763067.55035903229001311253140
15160363.1328235244882482840630
-3219509.23401845200119953979712-2339110.37782036913724114718016*%i
-2070388.23006233931019813086690-1504225.09862203671508580775988*%i
-1329344.14707504169382354369535-965825.057205031060224235300189*%i
-852121.341559706562852754551080-619102.393664108794394424825529*%i
-545248.847782731762225909177529-396146.476260076146131104908648*%i
-348228.197369951223149718581698-253002.594839914124535573046561*%i
-221947.727630282252796477825335-161254.463117550553742872146381*%i
-141153.419438044582479524450626-102553.962195117957706740519039*%i
-89560.4723646397787011459865950-65069.4920011596460999820993046*%i
-56682.5332752165645012421283046-41182.2710195238311133619486686*%i
-35777.1838837278982559010014212-25993.6456237963226634309019683*%i
-22516.1830085154629442179208434-16358.9645240381766624925099995*%i
-14125.8081817932197286744399679-10263.0003865188562807744458974*%i
-8831.80062417546448614551880977-6416.67875232776615873610296450*%i
-5501.46072944486480867840153557-3997.04518609308881794438742553*%i
-3413.19612648693630414081697039-2479.83214231592421635839161721*%i
-2108.36096582920135471313181333-1531.81390606137225103856993823*%i
-1296.15631621359149473215351486-941.712686671938698655907090681*%i
-792.695247765749886112518091337-575.926809249563822845051921791*%i
-482.032021872513700443447460581-350.216763750791516302036721283*%i
-291.288620568332807827722436576-211.633570766910880002006390928*%i
-174.813528910509109837062577489-127.009463224179529809522231670*%i
-104.116592487625759756829364298-75.6451323132635853837984446976*%i
-61.4901168009653433184759358444-44.6751849079182748748623141389*%i
-35.9773211390950185375051408040-26.1390538512588047138971003145*%i
-20.8320041670120356391633691302-15.1353369709191365770170895528*%i
-11.9230952287514287352755699283-8.66263574914571966998107587898*%i
-6.73624686035653778260459667079-4.89416982319161419268312568130*%i
-3.75153926187706800793793618966-2.72565281923553058963043877046*%i
-2.05736285312371615732813799040-1.49476160833282672120079927722*%i
-1.11214362003582499893471539468-.808019637205861820338008824796*%i
-.598427826280445577317001343041-.434783265734547870003675284827*%i
-.334858746685205452456731166458-.243289120341375929159375666035*%i
-.225398109796150927185893997682-.163761312498925392854854404100*%i
-.235360307763536357355072532529-.170999272994639471046908048645*%i
-.394680135694242084709601102162-.286751903540793514441567898967*%i
-.849547293749620450253393522952-.617232238460962167072193065232*%i
-2.04357902115741407374971058895-1.48474706821042850103568771404*%i
-5.32148368117996951404621661450-3.86628420646376894050746394578*%i
-15.0980685084204719257471788454-10.9693888621059379824009657403*%i
-47.6290077611767514754915622067-34.6044997051923109477533388196*%i
-172.342368395112285770208618933-125.214060016216090719266490416*%i
-749.427814193048225698602462916-544.491178681349134923755193553*%i
-4215.50552066852902657807725039-3062.74403780706817309942960184*%i
-34796.1380220871636053732535101-25280.8740833906658077367996204*%i
-538155.918471124612644004949472-390993.161467057763546289930235*%i
-27864821.7857075605114748701572-20244978.0626068254128106196602*%i
-40083083406.7022517121026051954-29122064748.5551869386851627028*%i
3501881852480348.41596956788624
971257543.162834907982620490798
4905457.62184387898524031609518
180527.093659142703439742204724
16053.5079881374924999302166273
2349.77603091721768029072177373
473.159211576274024428181155644
118.793833114975104325916666041
35.0304625392887352330793719147
11.6703576891213833446856780984
4.27922942373571424674169720280
1.70071667834567671019150475032
.736336664080858388537641120499
.371838070453225752030173511474
.267152964159978921646952712312
.318907207367066852199405044469
.528406157568594292390043976342
.970115755705717933518198160031
1.80359890676176607084576365322
3.31685970494549606073392221163
6.00703874411520630237505750683
10.7166302126897445469252658825
18.8574422404906353024848743764
32.7749219283296681984858844599
56.3370301081842304634057496659
95.8813550090274683855163457282
161.731909363985845498649451009
270.619021681804820692469084931
449.526683097259535959256680178
741.790085568835615291668961429
1216.73145991824478283955224323
1984.84690928438063794064580660
3221.68330238396340892931983242
5205.29259795301576340046728452
8374.86081771028029947026533464
13422.3035814901867406459789538
21435.1052873025478706105887486
34118.6937627965258537385249904
54142.0907158740173722829516919
85674.3844352914524715587668952
135216.221065723610647344891780
212886.882529830637158919599716
334414.151043195662432199707431
524207.187678290964345775659495
820096.765916883050504822542367
1280640.15908621001040340359369
1996367.49398849578067458076424
3107080.61159468135875517170727
4828439.02414496772121225403190
7492785.84508475422066470633855
11611792.9358433852435339706502
17972516.7162166366435816223651
1463926.79604859419760741542621-4505503.39982847316609140719261*%i
944786.058049236076491621268079-2907752.49701083717941883618639*%i
608882.947912701886590873793809-1873949.02485765991793830334139*%i
391813.107249654861227934515185-1205876.74983174469555037386229*%i
251723.565896368325493645244142-774725.474678302854890514671898*%i
161443.094278093975130434840898-496870.753450322178591538915933*%i
103350.404810299565112234469302-318079.839445057089684205508773*%i
66030.3250548067606926168359030-203220.444375509429238642746683*%i
42096.8003819732684883330052039-129560.629503352047504886490005*%i
26776.8051826544519119799452348-82410.5324888046108274808342634*%i
16990.0663251308525783462573695-52290.0474243708812845243737127*%i
10751.5927097750239991665378913-33089.9998812880635414527589995*%i
6784.18790458914956528117331089-20879.5834270575043798520321766*%i
4267.42788843597519956959076831-13133.7925583219548079273740151*%i
2675.23771195108695787234139457-8233.53506410225299120290456046*%i
1670.92970189431708450590497154-5142.59283529729352055440188593*%i
1039.46698818260720043681499482-3199.15043696675385706053865485*%i
643.813856925020350564755596861-1981.45530846343914537112900357*%i
396.851682178532686295422164892-1221.38388894117595104533771443*%i
243.340019785330433211931740921-748.923572829211914850341339172*%i
148.350801033687926261715398289-456.576818068142895706533424153*%i
89.8672374834004051926374892229-276.582917334080276989067992360*%i
54.0577243613209423234487249354-166.372568323995103891733052919*%i
32.2647744830375300425983099427-99.3007652571168034765631424738*%i
19.0913581730230224872376368396-58.7571587514291793104624784731*%i
11.1879571591713020070659417859-34.4329915634035323099573194183*%i
6.48600972008451741241354898447-19.9618853374627927613238087688*%i
3.71502259550126543066288001909-11.4336638824083252291054698698*%i
2.09945910631408282532280861678-6.46147072847552281468917922923*%i
1.16923642812234046229561575222-3.59853970589772372515375898223*%i
.641813486329198397608511793554-1.97529880081242846802118961203*%i
.349297615403904386031145635442-1.07502752050316973001937267748*%i
.193909175140813420202982188850-.596791076038114362880407437054*%i
.121626523567329878822989013967-.374327949267029141199688422924*%i
.108445873234294537444851145745-.333762078727782749982064936946*%i
.158047855043981646658366369016-.486421281554723149215999082732*%i
.316813000871671206883590133678-.975050157145831679483811243071*%i
.731105805630070849985056804186-2.25011230192091974721816944325*%i
1.83560956153816700534418358718-5.64942532822750181095450779973*%i
5.00825327869541150700845545319-15.4138186658448542605854681037*%i
15.1143512311127107950083713058-46.5171899590801136861344090274*%i
51.9553187290450474587728101865-159.902029121075052684137853559*%i
212.662332520706302665589965110-654.507359776267296698813791111*%i
1111.88172867836369018276924219-3422.02009163936175358069728980*%i
8375.35163512451012499135385792-25776.6818454765446286539192374*%i
114766.716945106750264353128072-353215.635357607235642621402575*%i
4978517.43244594787734762520060-15322301.1413789055442645404269*%i
5152975054.54123258615924438199-15859226492.8363050297784201670*%i
709711089748874.316449112632308
390682414.811848767938474541008
2504760.55881332423814750770092
106799.127037243260432260310465
10560.3094230025370135568937523
1678.61995791526955629165300836
361.451833672812056488602549229
95.9877405495847114417934957628
29.6972528417057306454510362161
10.3159972853676024914526992730
3.92713102839128674612447724821
1.61980704703781034205077085252
.737195484825616011032353377225
.410717083537312070220549899275
.347621831668040752603048787533
.470104230873012214803336871596
.807391491753615777045727603205
1.47659579859561653221079478269
2.70707591682912780471366862361
4.90145159707055557924490703864
8.74370500704602474938527017167
15.3784853663824843997474987817
26.7027419542781396556282444773
45.8359716429557851251771177972
77.8743025351513403105113035926
131.094453586518424684382262867
218.868677704707013113127570099
362.700205205568530280482762998
597.019987853802651295350070906
976.745357798279797434580226981
1589.16007259289425867632529009
2572.54189413757012460039028878
4145.30597122110734019463366152
6651.50790829394940645619929893
10631.7563638750019370856390413
16933.5311130042761635066247477
26882.5248747405023315320303086
42548.3618668707582077273847235
67156.0941336438971721820261994
105722.609649127912476583560928
166039.664528047468329400390481
260190.569171567273033584723505
406887.682235805477646990088578
635071.233882744119626828067870
989444.763852350157245048152810
1538981.58722220757587375356505
2389985.73388317824204135988274
3706129.67967243024769749901799
5739172.19681454719266992857028
8876014.80453014367191377213944
13710737.8794953919570892101883
21154805.2327100215798328215791
5596659.76586080900130575768758
3624395.08397969079845595640585
2344170.39747200248710825617362
1514091.41564434462163551206269
976524.626844669721889673937308
628836.404121897202997642711157
404265.402852974220381206685070
259427.697933400672784632597534
166160.680795618000268301734812
106203.263032688994539324838359
67728.9250898047659544409616462
43088.2641635991350873053622633
27340.4629150119178371758937802
17298.9223787400335848618603871
10911.6971391020996721643634375
6859.73596116157236533625768511
4296.67458260736167052834458981
2680.52583704589778440532766137
1664.96296542434636062453344404
1029.20080724341131991982694841
632.843967249292637443415370925
386.862330970149300521672791956
234.968401268595821643968120339
141.692790881968310138043888904
84.7654317219410522241664286100
50.2593889769598266770117615536
29.5035904246384328766145391303
17.1257004616196279112951217211
9.81529586062059237520929197621
5.54492182389368963348021199949
3.08137490541652340418608753865
1.68036404934183747739340981475
.896633834394335048241274505216
.466506538822787101356556816714
.235650722585540211742181161813
.114958720649293614383307769795
.537998964413632828065102321693e-1
.239492639010714354573363988666e-1
.100292230899382772510267773366e-1
.389320693838606515129421560891e-2
.137293066452664304442526479649e-2
.427420826416842788691561830918e-3
.112581806334319198524070458965e-3
.234632410622264940363798652979e-4
.344969170539507679249763002679e-5
.286502342380508378460199616367e-6
.792951102459604782920605197853e-8
.106825390414193064956910834936e-10
.417135644269121365674849252567e-15
.381078488103176763124587638852e-9
.466175205919268869178715838922e-7
.937130865091103448504373477226e-6
.844433199325510054343841679054e-5
.483560358138653834966244491417e-4
.207162919376651114126100607319e-3
.726141297839798210840126496942e-3
.219888740699249560569970015800e-2
.596045659532783548382513750825e-2
.148205072614097532642624333166e-1
.343999611748295920669296856446e-1
.755075316442314743308344081746e-1
.158282012386671383291825802682
.319296916307584894084127793620
.623584520717741289951548552911
1.18475834993725862284965580116
2.19836728227370559678431769152
3.99672619015382347194591033343
7.13840408212833661338732737727
12.5533537579329940495315320572
21.7769638534210349095470841957
37.3256381130026814998218495252
63.2967952400126226755154016714
106.323545282715249555169091381
177.088200112299657772552179419
292.713857694656205363561649822
480.532181252788868443278162503
784.003072864888579242615115334
1271.99199588256716658438169040
2053.27601714083965299031490374
3299.17752257935181114251395792
5278.81058320479101904215694192
8413.86929621143006121529298878
13363.6504524135585418198694756
21156.7900055501203800345951120
33395.0841685656760111378426573
52568.4142306645488965189654135
82540.7264491037913326258022313
129299.096215018818619456604200
202107.026434899555824729822875
315278.294778117392752018277430
490902.604034196017893112753952
763029.939763276764562172599688
1184088.80438299991407792883157
1834722.97559705441734812673188
2838856.12519515656880946489465
4386746.14885174369530769088579
6770242.72735994401509856490901
10436673.0149065613945424405908
16071147.5218759798048207468374
24722203.1631853202046286817280
2027511.75431559142330979976492+6240039.54768641275963403521214*%i
1317351.05583063494440352897105+4054389.65721038328356153500121*%i
854959.368775205497764848534002+2631294.37423319635269996723804*%i
554193.049838210921723665886837+1705630.82590400648498747525046*%i
358765.850907528925382424408496+1104167.75303877321909835904654*%i
231928.926864097792175503534011+713803.840004357144924003852350*%i
149709.072727065656797804292000+460757.148497862690635755754391*%i
96481.0584700059684217278035311+296938.165302380411083745233361*%i
62070.2310664115761438150927145+191032.528301758880756754439701*%i
39857.8029121347662984058932210+122669.703850653043341273901169*%i
25542.7357910376718560238922978+78612.4574384937661764262622143*%i
16333.3096502995413177329517146+50268.7582183125935236871491583*%i
10419.6901125131838712066153993+32068.5087217495898418124778595*%i
6630.12560072407251921488265966+20405.4284107526653429770460473*%i
4207.05165951101020127563006220+12947.9736325228656848233551503*%i
2661.42836797374561559830905895+8191.03427348399930653734047864*%i
1678.07599084665849766644625977+5164.58685115781207689656325648*%i
1054.22407743061146242578228574+3244.56808760196251439256435927*%i
659.669789896943775590324991984+2030.25485233768216000123377486*%i
410.980561447346327161713276155+1264.86810806554042522691671557*%i
254.814054646979190115521315374+784.237021027883230299748146598*%i
157.149635751378163007626533139+483.656846825104205727985392040*%i
96.3477366684623295986558449437+296.527842988623007591545286928*%i
58.6843779158141886968701005762+180.611943800872337410835845826*%i
35.4837157265383183002286520712+109.207647729373618149192316462*%i
21.2806080713449683049441433784+65.4949771222572293731813804268*%i
12.6458993934256725222180665436+38.9200763759207152520432329184*%i
7.43727255971393959688918377397+22.8895713185168486486907798279*%i
4.32280065410729876328069777136+13.3042124076364503585548454972*%i
2.47883466348739280402993245223+7.62906863519450804920053718460*%i
1.39905133019194537462992642795+4.30583724659488983548845156372*%i
.774158592237818969763762625078+2.38261515449310535944693692740*%i
.416321601986375753570260536564+1.28130614060389693237078642086*%i
.211667695276372105889656800505+.651446181103918579194013107138*%i
.900338756864419213663152227868e-1+.277095776988245618556396410346*%i
.441914459838987833954148727385e-2+.136007285788614754003576779312e-1*%i
-.864861782380365494313564654695e-1-.266177086956409752400689028849*%i
-.242448460009588501844422834433-.746179633985003311835681702286*%i
-.596739143777764637872430509831-1.83657423879288277803468118108*%i
-1.52185644012732331693937192230-4.68379251172399967577636130270*%i
-4.21475999632150890232771448473-12.9716974538235395380654376756*%i
-13.0931423145512915028905875574-40.2965485513872031414965128499*%i
-47.5359616716204689642282964777-146.300646660540156470827274982*%i
-214.931738316310288902134969242-661.491872632567793198095274060*%i
-1349.34841091190004284508765752-4152.86739017714381951904601219*%i
-14524.1619450880960782612580509-44700.7741096649401150975561976*%i
-442435.433328200790745687063633-1361676.24941720300661681115875*%i
-237154100.603877253872875465371-729885271.202156845677644802398*%i
-11843927640493.0277060104391268
-25679754.0928057766147208137188
-265199.434163176185448303329991
-15170.9413763649682895974319489
-1853.40218484899863953054785632
-347.138693998777603263001679806
-85.3880092274405143496453278886
-25.3403375592807859659059788601
-8.61538625363806383069082099709
-3.23850400732503038117395644449
-1.30065308902548027236495659491
-.518425949868371717780015366852
-.138907501117709689881219593349
.129861861951330564399039095536
.441893702025343800045896818259
.931606648804166824749721152301
1.77698030610169243121539580450
3.25760893580903082610983017661
5.83236778775479894489461268708
10.2583410207750896532289807207
17.7791943989849856299976520804
30.4251761804230164405544718465
51.4901396762366633767534075564
86.2876658883120740723261502562
143.345635496376497283870614111
236.287612895447812665722907045
386.787422717555927170019605256
629.196918203816986577943869930
1017.77706595745471453603265175
1637.97193653327947056199610126
2623.95041460455881358255295561
4185.84924890980178290507883697
6652.00988861704164138478698703
10534.3569855315530162252540473
16629.4485715355626922679891031
26174.4469333873360831056245112
41087.5525645691921815837380766
64338.2001752239226845109574905
100516.417163046129283188328845
156707.584686954021275467554495
243835.114719680278748900737180
378719.460782560772845327013801
587232.940385343847997015576936
909129.688163202905204669454461
1405434.61534342440784692792993
2169739.16153610209794630960557
3345457.93250405123161878858956
5152175.19324631922462439155232
7925845.25805798522537580239481
12180097.0384035046571443112608
18699671.9866629304829993454396
28682766.4957825203242042012566
-6174828.33739112309199214054564+4486275.39024728604615599486836*%i
-4024686.51533757817070912399730+2924105.91528245070271837097818*%i
-2620605.88465516839376921000923+1903981.62434309122219940636525*%i
-1704524.21721745436890937461430+1238409.33382352818274662420188*%i
-1107396.12466943432887894786181+804570.379920670605899129102958*%i
-718562.650999735687418396545171+522066.324987581826049533304823*%i
-465637.672415965309499637923535+338305.571651627533954622070917*%i
-301307.242765561818017592345424+218912.525865216268350721369669*%i
-194670.829061414435390503016606+141436.636275179519246082885677*%i
-125565.129607021054022317192087+91228.4066940058634708716356818*%i
-80845.4649155298917847463359506+58737.6684574977973494341515491*%i
-51951.2696010187533528450790421+37744.8067490122212648402320758*%i
-33313.4084523678560399583234484+24203.6079934584990947136112343*%i
-21313.0217702233560389222641662+15484.8167163713688989604145356*%i
-13601.4672482407599843968079645+9882.04439911896122563364435397*%i
-8656.50920279902136567048778389+6289.32207990327221702951206809*%i
-5492.95464353231214760571419541+3990.86515293075202047951574162*%i
-3474.17686750547463216318410699+2524.13724405517325885907687046*%i
-2189.48334772785915624301670626+1590.75276648383941780194195829*%i
-1374.41697419523944132166200482+998.572382965288121834601331646*%i
-859.023832083089257892305697012+624.117346578500304224003770327*%i
-534.318757316477272744001395293+388.205300701396315683753498911*%i
-330.578562053099820404239885850+240.179384178436207703496573669*%i
-203.313173160002923922238727521+147.715666804460211556211050710*%i
-124.214236823862518782075928900+90.2469256362656634705821385716*%i
-75.3258903008784431484270312236+54.7274627634547182086399099635*%i
-45.2981570450875734369867187357+32.9110375335217738374876274378*%i
-26.9841540183638990553300647009+19.6051354765881246142744667354*%i
-15.9027977176802733306984101230+11.5540588561613091653997760156*%i
-9.25782340052882734646314239027+6.72620241724740089206548041544*%i
-5.31358944791754302082040640012+3.86054871027262158862125685106*%i
-2.99912850114737974327793854974+2.17899440303654616493763782560*%i
-1.65777642652647727300830891937+1.20444507579624020712880600269*%i
-.889258530039501282663769143664+.646084140465230415276889671936*%i
-.450010105578185290618950250229+.326951479734734095526518399435*%i
-.189294259195596594746959536000+.137530329612870781339862003941*%i
-.521757243328403641818255238588e-2+.379078826572926597177658533626e-2*%i
.194155571644027572567374792592-.141062279848577754540356685073*%i
.548757223188718074798450722533-.398695460196733276001187380622*%i
1.38983177594708413871080187475-1.00977189199877483393239489299*%i
3.70725310236280166976610934141-2.69347704094638685918187237239*%i
10.9636443838273418739451037890-7.96555390677769412715650636629*%i
37.5156321271366119736873158539-27.2567022053689684878477381539*%i
157.834550768786378773620643998-114.673513522144532143185601165*%i
905.071935617738071899326318256-657.573252130416647773618234000*%i
8637.78952784443238953813164159-6275.72143993832650306794659551*%i
220559.434344704244922473506381-160245.809004233839478995716660*%i
85092407.1991405726109279438289-61823252.6405251617376763354047*%i
-977501886508.285761643369770681
-4205791.55041407272505322486057
-55112.7372764097465360506565525
-3650.58297043335422444569445629
-495.505584146519744562565368896
-100.687583263592042947332183540
-26.4539773143227094533906178659
-8.29162579131132062295170323205
-2.94811896256041168924130493928
-1.14042065722293749164916753328
-.445049197761412217031071437915
-.120997236227798630152012273693
.101616408917668564770807787386
.357201088062085858205770843219
.758354053986352302065032767080
1.45170335118648085051161583784
2.66619589996622932296204431318
4.77611348078526741952829256861
8.39670069996939560562058538075
14.5348674380519885984492368621
24.8282066851266089915500898441
41.9235945283527125432038391325
70.0751040459898299430183958498
116.085289946474629924826815058
190.782600789778136478886241534
311.333902258086246670656472480
504.855067575526210445934862459
814.035336333498243780421822139
1305.88021481630124407353515760
2085.27590627864747690702128066
3315.99702402945836566206490112
5253.18896409924845058664047948
8293.51696832421108420703656540
13052.4827635959680471166730813
20483.4726403003063825877722610
32060.8417628755945448558194463
50061.1661200329972456979888374
77994.8497680498680147564619565
121267.824424294251173715389974
188195.086401905626267006017829
291551.833596770198338616373354
450945.471636238398556529859564
696440.195679697143101484691994
1074091.71627125058785308823882
1654393.21105172030148754955338
2545155.80716334314473236452043
3911140.47770135724305053214939
6003963.70062884520346973968280
9207629.68272238486731205941702
14107820.4530199416197942377164
21597291.2967793553609857216878
33036114.6872779866815886229108
-7127215.30512231670997640705431-5178225.02542206751968608663156*%i
-4659422.65961542698713014495993-3385268.71816245446424590953324*%i
-3043415.63170978539085253093260-2211170.88683345984414154193922*%i
-1986003.78185226259159060612749-1442916.20829515012547654595054*%i
-1294668.95482055107987800251826-940632.055365381540466890062170*%i
-843072.038200387024408129531154-612527.689924741372290330999480*%i
-548355.556286174799370086795632-398403.632109943401751631050201*%i
-356215.055598360900142568783016-258805.387008003309313247643803*%i
-231084.974477526653424927299296-167893.061540956514147057406518*%i
-149690.120166165178281652666290-108756.238322951900348212143128*%i
-96810.8893216435259681908222583-70337.2282661940846028549996933*%i
-62503.8851169796841739182235857-45411.7307030470716604956287991*%i
-40278.8753851007986408424452094-29264.3159475040382342738842232*%i
-25903.8202841536210654861979033-18820.2270742455176140724206149*%i
-16622.1408856148851893857872396-12076.6922598959069205522627833*%i
-10640.4002101588498083672431171-7730.70326767758399275221446676*%i
-6793.24673992680470777505393235-4935.58265979059704798168807877*%i
-4324.47667686665048298266725094-3141.91621711091838682093742589*%i
-2744.10474279128771675895013240-1993.70879693908278652070884449*%i
-1735.14847060525180093259406371-1260.65915629817526648872805867*%i
-1092.89975549750161918419662536-794.038151215595634970585138116*%i
-685.406943297061214414123713649-497.977293295473898106163680897*%i
-427.791313928751894277233055139-310.808582680530353574013474587*%i
-265.577320710437084660400242450-192.953217969851445186869647389*%i
-163.888968459254849930419835703-119.072305456577873724143667142*%i
-100.459130319205439850926381046-72.9878305033355171554430813677*%i
-61.1139145033502016234837504583-44.4018579395675446791133596278*%i
-36.8612940686743883120208201128-26.7812977782037048845306684078*%i
-22.0179345063537965125708334953-15.9969657977027550151832200380*%i
-13.0067354307071174592073490362-9.44994644092284557092198977187*%i
-7.58686926771269964242914300878-5.51218317741016591636319684088*%i
-4.36214668106930042877165676500-3.16928507719428424732774498157*%i
-2.46812102018200570210315618861-1.79319488542620475808184075271*%i
-1.37376319224468517415918119859-.998097382574168148718747702822*%i
-.756542991218666133957553696622-.549660657384747234404446085679*%i
-.424818645749050115431900911133-.308648812826328728750712471574*%i
-.271701725167819785803220444764-.197402858266845573372116442891*%i
-.252777000182480076128731267257-.183653240734190644475177523767*%i
-.390410491916904403875209992850-.283649825757124237625387636084*%i
-.831637339161299599240148398286-.604219894777902323478977611487*%i
-2.07045356621691300645167617985-1.50427256811695083738383221869*%i
-5.80242042156692872785216120949-4.21570520163516823292707964056*%i
-18.7104209387810435753739699717-13.5939165289064170694393198726*%i
-73.2764301439753855276383375805-53.2384428000121071518539644409*%i
-383.956227465230585817579676917-278.960528145990007447120266001*%i
-3250.13014812140394664942195120-2361.35777416256285117734347189*%i
-69581.6973948913699733730135986-50554.0623281884097659846311550*%i
-19324425.8469328276338416820018-14040017.2070827136772404094383*%i
133685444992.026834515767027584
1141337.58690380941998223657381
18973.9863839926952951812142191
1454.83527175825925818151212385
219.314316667421620251396595958
48.3282889517941676420039850027
13.5582053618700443599287060434
4.49346269239609689280664203305
1.68959894962660409677297823182
.719126016330797595399692548052
.377618610162015599709826633137
.302797536032657252226246845585
.396916490472050055968452635570
.672086576146952236796332549944
1.21553686442875338033838449896
2.20034567422634595276540971883
3.92543136491351943352916356818
6.88791422619702140766318439374
11.9016590969358116565146474022
20.2866209694885176544006782225
34.1684943813349377855347763361
56.9505465913055889854899091582
94.0538693285628162898470579524
154.075220382312761824946900465
250.593182466411181393673206840
404.978885899154031610760364995
650.760493012565508514980924998
1040.38690857432778330974082237
1655.69058504092798998520149695
2624.04553421639400728907917942
4143.28243533968091710959241417
6520.05273701526206817383957900
10228.8245397839382065915073563
16002.4965615712979226289691340
24971.4201683394475413196419820
38876.4691648612105048968502111
60395.2829600468716714219285407
93641.3474937389608506247366825
144926.841009671578639102346288
223927.732740952079098402405856
345461.942975882910046335727212
532201.290969016413900436930239
818804.945505796612714304828723
1258215.67788522926270293979617
1931245.15497502818107039795385
2961158.62300168623258547182531
4535855.36739573061594414958036
6941584.90359919631387073382202
10614175.5803021744710524033278
16216838.8413905472503232436315
24758288.6108836878197723471976
37771997.9337527991491440618271
3117624.45563562543869966674511-9595061.46220472557717086030602*%i
2043975.39218972471623386178981-6290709.41493364778196614646220*%i
1339049.29698164507245727512269-4121169.97678650577618431660640*%i
876521.344554130980417628630098-2697655.31211696687183160250940*%i
573254.159979029959851306423963-1764294.89078468951473803544321*%i
374560.520324778334706595368390-1152778.74707936717955618017356*%i
244486.764764623427583792116858-752452.890973320340487551168927*%i
159408.940094545935232940309183-490610.270607540207508381442744*%i
103813.987438718178341889862584-319506.600068661488398489153512*%i
67521.6331270555799875006739256-207810.218678326183764136829604*%i
43855.8404291542751691417490130-134974.398097793012779024450564*%i
28441.8564241255773510169711691-87535.0332832335111475886873645*%i
18415.2382333234201907268055016-56676.2755438597882770657253316*%i
11902.0589614586604235959247129-36630.7709241705130223624730121*%i
7677.52629948943741113934663884-23628.9962981686856329638832285*%i
4941.91975501471948760325902326-15209.6650720499636119652922975*%i
3173.62994229398898207726969362-9767.42862648465935008457749914*%i
2032.83933912363581938342350534-6256.43616774303597996002600675*%i
1298.44373205211645888031697151-3996.19889808519473359088907117*%i
826.777738874221381534153514004-2544.56023583617167154813857345*%i
524.632170866351863250062385354-1614.65179534788572981615855192*%i
331.631873123586364412891412959-1020.65795631505413431690598099*%i
208.739069914045281177209587355-642.432799039731399203428134132*%i
130.761610503082329147118172090-402.442855939859189337937073082*%i
81.4770879923034083525930839581-250.760692370891719497934163333*%i
50.4637581230641927611026800523-155.311477599348631372591432498*%i
31.0438349182467974187176980360-95.5430996586744470168147045171*%i
18.9508601096484439245399915185-58.3247501747762334400738819448*%i
11.4677561180854050914747391739-35.2941242129722424895485180181*%i
6.87039903971247962492093536359-21.1449140183477685637923666773*%i
4.06918940019340145147769504750-12.5236772266232755513316597998*%i
2.37871972932246107213206802757-7.32094655048971333234907716078*%i
1.37016849287146514986653984582-4.21694501366673683928381862593*%i
.777033330547592683663471699892-2.39146268926278293258170662542*%i
.435237009602635329436022540191-1.33952177922341843207719814127*%i
.245474467242192479432932076707-.755492726628161821364269713406*%i
.150284053278036569498412947340-.462526756673781825318252615655*%i
.121835278395872277907149646694-.374970430566139925561498512785*%i
.160295160340732260680714868833-.493337776069539261487092192379*%i
.310504485354847221890136492725-.955634542795687865533233040985*%i
.729819535506829269635642059913-2.24615356953825875108719038326*%i
1.94155915314223688503997846579-5.97550464207778912832137220283*%i
5.90370400904714806038416385630-18.1697326369999508575992012321*%i
21.5346289190148745749421635399-66.2767729032302027285653046428*%i
103.158769715821174885595105055-317.490047269635923779056621602*%i
774.821582160834541260092344557-2384.65562766448347247571565487*%i
13912.2390779897305253574757761-42817.4691755752199287481266693*%i
2781829.82891461765758418245417-8561591.86767357048628515757838*%i
30342468751.3945876032340770283
513970.063935584158270425914172
10837.3332185486926663328656864
961.548364158767110851744037041
160.914868600443028644750746276
38.4334823566869860390910183716
11.5065441694163231557147380946
4.02890117087056771682067809883
1.59600444263002195510185164828
.727461009687954515280787297090
.432781828070978086099130131873
.410374627708443005001903857870
.591614023151566980279116890915
1.01780527378651110264693338384
1.81825440875375725237869170466
3.23161644843657953609288023268
5.65973886842977083537421378814
9.76055081673986616846502530829
16.5977536417388527026731062788
27.8775434939848621136661230114
46.3202221742887328012046744579
76.2411295018060659122681284516
124.456008278747237487590499422
201.688341236499189451028566095
324.751987591619433101153973899
519.929291027190590812332761518
828.189718077220831604913626208
1313.23815554904732814823067306
2073.90792417028972137020002895
3263.21678232867379256287139128
5117.62991035997329771799692998
8001.94292327809995826313447360
12478.0460411432500101330758456
19410.1676453391325817954346810
30125.7960266154687596485818652
46661.5177462728042476303609344
72138.2733435540917845441861889
111333.721401707604682824031171
171554.621818232803337742256704
263965.614974900228110027183233
405611.904132401126358644790423
622496.410067136285331032110698
954258.562108283385685543927665
1461284.72022367473979561972957
2235508.78019791664815597004293
3416810.68100315690222221901288
5217903.58430481562098867130810
7962088.74074162678365102249416
12140509.5220923587551237426700
18498944.3588621919636758044328
28169334.2218391237373232322556
42869038.1938512761648635383134
11462548.1831178665091273879135
7535391.49751124822991165857359
4950501.14344132414931031304838
3250052.27477155379742268209066
2132094.95165794312408260447663
1397567.32937631526786618245756
915295.819503584360300986290521
598883.781816198641533045981472
391455.741817094275128447424209
255590.705363493849994185668328
166682.123679004556718592483392
108559.900019677635386043825032
70605.1043979839058767857954907
45849.3398514864979431831781982
29723.3599420784637362564013422
19233.5975380874501707589239190
12420.5920272480852588770699126
8003.03264011545403141246219742
5143.95576790750095242555505498
3297.28605436940083019778639399
2107.18933771922662633364288385
1342.11728606911225543553326940
851.624656486189384822357351531
538.123797457709432288826583668
338.428902691962064419521112166
211.710707021066659523070860232
131.644788850518749350734057227
81.3004088780829470405190135213
49.8182750661430936916793189894
30.2546193148830473821149624014
18.1846437436653396264087639824
10.7996556806253318096527829183
6.32464695323541486774326511607
3.64349882842074708095445881649
2.05845062859924102739265406011
1.13620338193266765904204656322
.609790896929628262436925526072
.316252016165720075866055412690
.157216863233476828799458613713
.741088738166268352302292785125e-1
.326334921148798128634166884777e-1
.131413572169045250371505391135e-1
.468853964871437244170085456625e-2
.140964039649492150458521568286e-2
.327751281704231637875063846505e-3
.498902901440128330123742880831e-4
.334719057985700058091954596422e-5
.233870429714974206782815380123e-7
.115363445691893953679943954121e-10
.342123592638257792127887910156e-6
.126927727464858328942106432354e-4
.122138473996126111416379660684e-3
.646964223940429449646436699070e-3
.245071654484958123053734938070e-2
.750187947857114986024203084109e-2
.198423567413143027214295444871e-1
.472282595281242627215511301124e-1
.103867010459990313704703230767
.214926923034542725769728593622
.423890764351007924264307697745
.804442940638108426154799094004
1.47954359878426649933700520017
2.65184115722426609424674321766
4.65189831744840993635683574049
8.01430201059211423832054275487
13.5972799212905998534910425369
22.7700044535871303741182056207
37.7049348282778015116050211556
61.8327837183652306886999157412
100.548744502461542085335889066
162.306197620132668491774528848
260.306948176275713892439762795
415.108413557102746626784636656
658.638298290557407441202470428
1040.36692305475216213534530977
1636.78328176363468576320564603
2565.92414733408458656581131314
4009.62405661574431726602770551
6247.55160213131931626736652412
9709.22270639920243879974460462
15053.4114253183335307299314035
23289.2848023832977787104827205
35961.0363998576592535072010392
55429.0952689830170431015707888
85298.1299601597443890899555032
131068.058261011995191519451333
201123.664326291102587003758262
308238.102266812412416676229335
471855.945502828254541411109416
721558.275890224873134991345418
1102319.40964208484348086895892
1682478.22286054137525080274769
2565821.06185824466450446106308
3909890.08411381893732982765141
5953714.71649410484321302827164
9059802.23005497985647956298447
13777699.3359717564857108229998
20940177.6595965822699585550482
31808747.2188480582189686566343
48293737.5504272183699365986746
3992464.76221080428462682522196+12287543.0714085051045444716953*%i
2631299.47247188940671212074847+8098307.06780466290805470058571*%i
1733266.16772008997790487729909+5334444.74993496254260944832900*%i
1141059.23850085805368558574364+3511819.23327582190628352950165*%i
750722.661189448760481479068128+2310486.77532716198899897864206*%i
493580.291114540147006593833250+1519083.93623738921722721139201*%i
324279.473092981126164134958322+998029.595782133563290324053263*%i
212881.779524935067589527577373+655182.748208464594721234585585*%i
139632.410057686139737338194225+429744.369690644907554386824370*%i
91502.0805086814976319455968703+281614.446798853681789750545964*%i
59901.4783978119734835005246880+184357.793917404985519857412293*%i
39171.2016845989542433260479984+120556.562556061754300093934958*%i
25584.4177739129707967082547318+78740.7413909858945594488367139*%i
16688.4083628398509837537451128+51361.6396799700322893023320804*%i
10870.0287586497892783228286510+33454.5085591180123364035681705*%i
7069.06335757639995090716501215+21756.3399188617077550348167538*%i
4589.22994650723466830484755529+14124.1974546769849533403505012*%i
2973.63074509119761835594719236+9151.89438980536137969256845338*%i
1922.71883883328539801098688052+5917.52011689392177577243827828*%i
1240.29886564352645033705675338+3817.24739996822286323450735516*%i
798.003980041575741333045635155+2456.00371197428714740620538495*%i
511.943258090073808887771222422+1575.59933739168202263198364486*%i
327.361206495029681157888607452+1007.51419593958148733376232357*%i
208.568546912753585530415479039+641.907983205946233040282472422*%i
132.338708646325210272979023727+407.296664931827464187237643557*%i
83.5812621980252019856079477122+257.236674683190498653528812105*%i
52.5101027936753796901552833812+161.609478903474997978522407780*%i
32.7920563013149611181768772771+100.923571828681086729290071337*%i
20.3379556928243116222575998996+62.5937914156051088496712500517*%i
12.5143008191400691727215001846+38.5150576103261791892686422641*%i
7.62994060248185614451616341936+23.4825425818834430491738471401*%i
4.60237425180710270305396243041+14.1646514667059942363884698544*%i
2.74120232104049736091861562603+8.43655325553293247188709570203*%i
1.60786271800984203860924300351+4.94849261725674765839532601034*%i
.924939375852349427816059275494+2.84667068994592994955022059277*%i
.517577108438542642255149122594+1.59293854586007361568749986138*%i
.275528182599812523160373767887+.847988551615260113321739031407*%i
.128120327328729797474604760723+.394313822197136408111714532278*%i
.264576106954313159544393456203e-1+.814281528703208685254778661032e-1*%i
-.728771842508859260720068777762e-1-.224292910204639266846524395727*%i
-.233084660309687229001596105460-.717360821803210586123574326130*%i
-.603340874457545102935846149259-1.85689227662290790989904335944*%i
-1.65607249367773063237023789303-5.09686705016072049018656877350*%i
-5.26106013229029343041541685561-16.1918781572388968849995605162*%i
-21.1086931195824431010437634886-64.9658773054234277393405231368*%i
-125.029214525438533064475459298-384.800355210895236184240181857*%i
-1580.97973699999877542542201062-4865.75530917255807845091439766*%i
-163986.280063452610414132243827-504697.874473898568007214234928*%i
-648829942.876650583552832722577
-43247.2406819866705754413829467
-1465.62266100601706252307697733
-173.882731256778482866276614690
-35.7967839772194508361375544185
-10.0184890156817107220828784387
-3.39338561604518588539466484584
-1.28632343369051891365333665310
-.482355186564325898246887508885
-.854553647185641696767709072297e-1
.220536234873603432787996386458
.597486831841406970668565505833
1.18648765258721493069122275559
2.17042102301621026647580417432
3.82612299695871302105245129535
6.59017846127717361083414210196
11.1557556262069347110377343520
18.6210845687384032698190957910
30.7191337204685924776554468829
50.1730857567557455669278099287
81.2457126018005637654634876602
130.586836878953766867789999130
208.538223949742625390116583646
331.139389144858825178368812617
523.206013052299921688526038474
823.047842142909641111538883896
1289.68987408909843261558806928
2013.91200393980524605808023546
3135.10804738440014508690961975
4867.00623305250445915350590847
7536.87323434086942381098411753
11645.2202024088432899279823773
17956.6622068504972738915341329
27638.0876311747664985858283637
42468.6327886529706318192398410
65158.5829494886973110572090769
99833.4314216720598030726030856
152768.243943636164747298852381
233501.213444083284335500453536
356521.428493823779842831383760
543825.862213313911728280448601
828791.697257613299285518480032
1262038.42312952008478280960926
1920299.04750855552946737635969
2919840.67057088863735913601504
4436761.23112413712848834098510
6737676.69377818080684748871431
10226105.3146557380908279613858
15512560.5812429167358794947439
23520445.9533834023331300645845
35646002.2379929626313285608992
53999847.0564681879891439062597
-11687188.3647660534269727193517+8491239.37981196826867816043819*%i
-7721011.15431580831350222557369+5609642.96281419694225123662682*%i
-5098571.74485870522732778371681+3704329.20472634756002358103438*%i
-3365256.22933188969184148762030+2445001.76824457964238211236217*%i
-2220069.43695967955122874245809+1612974.86107612375415119002357*%i
-1463779.77245000947178356566271+1063498.25631894179158977326097*%i
-964552.346901380679988548123964+700788.300511232941001181735701*%i
-635177.052277629460097699801166+461483.141292782177487337235562*%i
-417982.863171643201431169219136+303682.326071644507917538576097*%i
-274846.340049559166376858467468+199687.554712627781892807693574*%i
-180575.739779223453107021264328+131195.954475635215433710598436*%i
-118531.450464157079031172337096+86118.1396683708911693662569263*%i
-77727.6423915063652625713902884+56472.4377990216893677445121805*%i
-50914.7541808261594131135453249+36991.7342153089551760936596512*%i
-33311.3011577503171232222765884+24202.0769542998202800438294825*%i
-21765.4210993248566265365656751+15813.5040686047023656616935010*%i
-14200.7455720209347402162505924+10317.4455874570245717218970120*%i
-9250.32820407501873758567552840+6720.75683826795396925052942435*%i
-6014.91359405094622412930804910+4370.09052835558549591976104833*%i
-3903.38808540355601648881108112+2835.97744735510510654096340101*%i
-2527.52630066401141097740656882+1836.35534808446870924802288911*%i
-1632.59430942480632736917557496+1186.14919677666516680361114692*%i
-1051.62137711853861656989626755+764.047653836182024356281224481*%i
-675.287289797426642904380517859+490.624934659311099137564881011*%i
-432.106644924693746417665642518+313.943854171501838566195992825*%i
-275.399029153968349352094293807+200.089106851746248541274497582*%i
-174.728383840220027927892691894+126.947601709564506095428495343*%i
-110.283752720134927951632968674+80.1258364992049256695337937727*%i
-69.1944408128714946539788442339+50.2727039521009741668387069012*%i
-43.1163068521563583425738568555+31.3258305786205444427558417171*%i
-26.6525923740086936790759289377+19.3642418413086793061088941817*%i
-16.3221114709967479962896558745+11.8587081305232769461723238348*%i
-9.88605721945034360892997345764+7.18264100422510144081015494876*%i
-5.90947765143846890909397133484+4.29348683206728807305370863051*%i
-3.47609218262484427700958405706+2.52552880194392697017805126484*%i
-2.00311294221500842502012000511+1.45534674091714860057436379605*%i
-1.12106942473603900395141347789+.814504613917237435904368400533*%i
-.595530819961012168883427955901+.432678467439579215392373427437*%i
-.275044162985722092871421959285+.199831281488765037634234306829*%i
-.533370901516961937823456021760e-1+.387516643152631901729027225960e-1*%i
.167490849326447141940626661849-.121689225087401903095691619145*%i
.541055131985441842898384205233-.393099563382977110562101567637*%i
1.46766614394285731571279586917-1.06632187048812343243158618036*%i
4.38460699577404707502190750716-3.18560345101966685647823229732*%i
16.1333382430796691513798980797-11.7215563522926703160812860752*%i
84.9560860977961713173819105033-61.7242095629339254213474785727*%i
902.236398532436521607578081934-655.513113848208706791565666843*%i
67434.7311431930554582539993125-48994.2000401373224037341956681*%i
-61387516.5405878719260611948899
-8114.44171630389421523249973274
-348.408124568461240621910986522
-47.7536071840594107827112351519
-10.8887612868459618891596118512
-3.28767609463400159035258819341
-1.16622862150568166753362869611
-.423292845086913810679208882086
-.782301024212491079806755847757e-1
.178563681339540382788432369570
.491890294681336188125720103086
.980800295351751304192514586561
1.79596202564982264454755291965
3.16313572006820616949370595947
5.43590696314154225926031342020
9.17227987148096472922143493069
15.2513492375816493553096672077
25.0528831085797871243423895428
40.7340388387774988050664918299
65.6552515464564341046413603378
105.034638777752111759527031007
166.951888138205161240887318503
263.885919649720475451720725301
415.066854776473291484448490528
650.068973828751005926958902217
1014.29313778806488671323354411
1577.32354032203521149370969099
2445.65356967736515329353108479
3782.04811869817531010349697267
5834.97961899088015207911997549
8983.34602303860036439938034740
13804.3585821405720585958455624
21176.5402943633476358608261969
32435.9041073791574051412189516
49612.6428617499616134673730316
75789.6597643317310911028853568
115645.412225991283336673147696
176275.474374698260777735459728
268435.437198047511977122547182
408420.544416402616788628857970
620907.299528243374178537775545
943248.010937529382988855597991
1431959.26356009193394021629888
2172522.41886734063410747342859
3294182.95961603965557092403476
4992293.02229802522419374315874
7562034.27687096116252343719189
11449307.1056269460085168509733
17327509.2581133654490390767278
26213353.6055935227322543294961
39641544.5698449706700891131441
59928182.2544436081638959519951
-12962812.4467308937405839095168-9418034.52510722103239447039323*%i
-8582769.18576484338180835196185-6235746.82151210217041512270127*%i
-5680773.74496016971553751527377-4127323.71768984294428036207065*%i
-3758609.08395374990199969303769-2730789.34563967116330335012242*%i
-2485838.77991938319897484800406-1806067.59137639060363758719176*%i
-1643349.93389769339533541706115-1193963.61537147286429784569231*%i
-1085880.56961364084324149130052-788938.414158995883362527979648*%i
-717151.457709428838755438806633-521041.033046938085080028786198*%i
-473365.350090637119529393781261-343920.058124994179582227508468*%i
-312260.127048223699472469882406-226870.262100891615435050014933*%i
-205847.837985090755490247894113-149557.208594125790574581183605*%i
-135599.523785620921287315441191-98518.8208075280877762695192695*%i
-89252.6663673217214590268399244-64845.8578537329734584145839537*%i
-58694.9562703205924906580766725-42644.3819098028316018251351906*%i
-38561.8617756765581919033527017-28016.8325390933412399807341559*%i
-25307.4833033849610456022949970-18386.9628966947710855442915903*%i
-16589.1481260925738430056717049-12052.7216169866938921309943084*%i
-10859.9326203948139738530828184-7890.20289998953136226333859383*%i
-7098.94984154722397777008297710-5157.68896406097620026946837490*%i
-4632.88968509370994749029372960-3365.99138377794433511641755910*%i
-3017.98425424110311789775930928-2192.69390955670485000742198446*%i
-1961.97213972837580526711193518-1425.45619827434129966397180480*%i
-1272.53085754153939779969142217-924.547786203059791814726099715*%i
-823.217103342451902857418815739-598.102235359675428178655040444*%i
-530.983019573793634483841960896-385.781745369064049128564012925*%i
-341.342952986363543877622321149-248.000171979527619318068212663*%i
-218.593869377741231197050681867-158.817742464177757834920304265*%i
-139.372256851186279168506648435-101.259871826473357831973453020*%i
-88.4125353135508664675350629927-64.2354669140704886934582260500*%i
-55.7571544420025385734531198188-40.5099439426778615003936364362*%i
-34.9232785547162151189011563036-25.3732470873789249665057015278*%i
-21.6993323625066148161710568030-15.7654877906840959900663819540*%i
-13.3559314468182195733855614240-9.70365219723760642982069603255*%i
-8.12919082436383566652128042257-5.90620285217128482136282591362*%i
-4.88290097090657939419461952299-3.54763521540229731983476140962*%i
-2.88806136294750333407968156360-2.09829940367048717105654816715*%i
-1.67938496440611419450842234333-1.22014459753381121670357656675*%i
-.962375452470710881072093574757-.699206694128373314480519888861*%i
-.553987193838520413717935978387-.402495256294034507295953217340*%i
-.346653301022274272939310154337-.251858365666126503362755692360*%i
-.291805640023421632913363278946-.212009207388839069126582172635*%i
-.409959511178000859125690329822-.297853019631106748336537513283*%i
-.869824615025916401100000381385-.631964574722219118082078495332*%i
-2.34354033853963797885473536205-1.70268172204512785770826450984*%i
-7.87049695886364133859932252230-5.71825075715129482156834186785*%i
-36.8621979237227596113078648211-26.7819544673354989760611028279*%i
-329.026278052129113994546485277-239.051583836188674597245564145*%i
-17728.4623268715444101470117138-12880.4818366130544706489181765*%i
9722101.13511962213546632680965
2547.87022211969489307661252584
138.522080573175063211403812492
21.9177960035565130923568896278
5.53870892314888148435972381244
1.82871471020838119801619250858
.745168534970785492042464652669
.409466385681080762705393794935
.368087468385554826180837134542
.515862175887140880103163602322
.869720700918940829002088511529
1.52084941137438457537041645850
2.63924012126931116150952124801
4.50465297406654391383068031789
7.56267838178116827942320410064
12.5143082800368006514222070094
20.4550663272435978493927610839
33.0892687812650030157320509198
53.0587787414456150043502989057
84.4463200867465416087055869594
133.544746252577625994536281920
210.031135013634177498276007758
328.756520849157837495752128445
512.471040937385753296463691334
795.969232463641604209479982912
1232.38983477366696228989628169
1902.78199208318978103307810547
2930.62054349421067937727289167
4503.81570961359286100515183436
6908.06567914341708051197782578
10577.3687280771051117158443408
16170.4829305619653564791718465
24686.6064218042179575640932504
37640.3186418570619674070546947
57326.0322237645797111978248700
87217.6030796152250647986516214
132571.964901693948062664703188
201340.659091401167889339271114
305545.895168389320845241412397
463357.296297405769033362976610
702225.307721086273490426742381
1063607.77304676173363261452339
1610098.13005732166941290355659
2436173.28581997911099384635475
3684396.11041213084927666163857
5569836.41805368678377730764554
8416872.98595654027638299879914
12714644.9345391398940914853342
19200590.8262006741857059651747
28986285.5946490038079453402993
43746967.6054213821891867671077
66006957.5626960402934331343801
5447399.80646097751085728894726-16765372.7047566120693357456120*%i
3614176.65431722543788446208816-11123291.9894352614618538277081*%i
2397287.51663176765961739274384-7378092.32381333781144246870898*%i
1589687.60194908109090337796292-4892555.36177029414701670896434*%i
1053837.54257742088805392929284-3243378.45564775343017650463096*%i
698383.459333366022895140589202-2149403.27542580368100652182163*%i
462657.440843476380469307492401-1423913.18903560094075101816678*%i
306376.883717405015705032743015-942931.091188114368536963206336*%i
202799.639564336458651617946935-624153.112032233497994644259213*%i
134176.107063765166725893262676-412951.595792414282172902331944*%i
88727.8648818209875023267129014-273076.289035490764040329794681*%i
58640.7284587202917842222283042-180477.604585367813303728310915*%i
38731.8379080521462259651651418-119204.339894152496558356774663*%i
25564.5476835485287541939415524-78679.5875409890666540661333419*%i
16860.7790163663594291616799826-51892.1420026207068683595817397*%i
11110.9398875912311634705073990-34195.9567745833927584288615624*%i
7315.04367990463640284314323052-22513.3895073603834818548289530*%i
4810.93793951455436190890556733-14806.5444948157789749930070075*%i
3160.35960621902372019977067272-9726.58673161395589420691611500*%i
2073.36953782397976146144945979-6381.17529304152638196033330100*%i
1358.25370036489115641217673754-4180.27505292039498742928343318*%i
888.318799910965981150833906489-2733.96414624925795820652775323*%i
579.892693860737983619319153767-1784.72619722340243058050041898*%i
377.753979049549020339264040389-1162.60720242324259733553081849*%i
245.485887533315781495524177642-755.527874670141756804265267971*%i
159.093090593013695805485178257-489.638185796449424247916825318*%i
102.779760500289550320908993026-316.323576846556535498829969211*%i
66.1586194424983037510584161246-203.615293900419670771708641935*%i
42.4070456830507194302805761696-130.515466358964098175488939397*%i
27.0496639372871174607626680591-83.2503053859117074945669573637*%i
17.1551429569961378570611085236-52.7981010566350096300527621253*%i
10.8066945603017168810017790546-33.2595859395219577897248895596*%i
6.75331731013218165444882939259-20.7845735067144806090280921541*%i
4.18031834677062468237546924105-12.8656969560076237142513995831*%i
2.55849482110619067568113350702-7.87423739086666809418405766055*%i
1.54515560370032320794650694836-4.75549996388257479572502512161*%i
.919300739763295979337798794830-2.82931675248252789509513835621*%i
.539341595223321577352156941891-1.65992274853265610678418095669*%i
.315819751086088865955410952260-.971993248632442058446707360243*%i
.194465371837310317595882182719-.598502873454354124921673405360*%i
.147431218383494433756623594714-.453746633684570393970688476779*%i
.174230348855513452639338233206-.536225876348915006338057943957*%i
.324445702394119880197629630871-.998541196965644454182534401667*%i
.799690686155203174135094148756-2.46119485961225114967819319390*%i
2.45575593132057616070138557276-7.55803960114581950199142453982*%i
10.2411997006919695262736660421-31.5191717197438072130662600247*%i
76.9021653252513937122197021935-236.680528194655830952677216583*%i
2988.93844345135447845807788528-9199.00664104046077098964537270*%i
2585435.62958566065989383663092
1342.88279252566506592029220262
92.3751668846475360836874478436
16.8553608590213198081200561315
4.71499860671288526475838093697
1.69537872750683343490264381892
.764617577260427069096987349728
.491563516720701465599934554948
.516789994468487498075344116946
.768592547034741160704660072155
1.29065602022227527846239406427
2.20882663552802458475638619726
3.74372140152320194632501290973
6.25042223346598290426535676326
10.2866415582211971014659732711
16.7199685040954030429385747029
26.8930442230848827838570905120
42.8762469579292493370366554722
67.8531270539931884965544347592
106.707313478454321974895993940
166.915043499238463298466757383
259.900991706700676682291852270
403.095934405948113384500761988
623.056904445298179106741446590
960.194856835490607787954269947
1475.93310748228649048931495203
2263.53958874066274988235921424
3464.50909338307847773503380379
5293.32631452037504432121638385
8074.87952559307042438570979834
12300.9634592980520414821501039
18715.5776103830320820718188611
28443.6486782944381689179146681
43185.2198386898582849027644371
65508.3141045028795809568193270
99290.4888863927145080961820808
150384.404744101190710961260376
227620.822097966796654261972019
344319.767213892819930394472852
520566.878027953169702331983707
786641.748448713028036361332880
1188180.39047276857490899432200
1793947.74274362617556152924725
2707538.12121823561091608918991
4084986.29011299628959562442424
6161271.68670440538541059076705
9290202.04701332772570205954162
14004424.0171945679068050933450
21105708.8160759198982967290637
31800774.2000695016410452483185
47905592.1168373884962569317248
72152690.7001499176905176388835
19236679.3157072567925169872577
12787005.5443910440711416287063
8498337.93359040040455176711549
5647005.34808005848017391800854
3751572.49729901216831930401046
2491784.22569489467421699499892
1654624.58866331462476619663269
1098422.32706077559740372368766
728966.672566524675077932675539
483615.924180329029170434795859
320724.847386431125280177912877
212611.288118088902034621629115
140877.667612164793324542095196
93299.2235802445126860069157050
61754.5519417251441806976737480
40849.4919269042510231912784668
27002.1812395567580036255909454
17834.8206068379397273600128776
11769.3968055171407822120213859
7759.01835083532871875778140463
5109.40769921282214501162779725
3360.32098638579923404759692003
2206.79513541792218653253536194
1446.85896783958596155517344359
946.825178535578101194578510116
618.259191649456288358264434773
402.701658776989041675029002490
261.538099156612241190839640992
169.284368263232374589975142793
109.138242295644811364379714766
70.0338313890423962843860705376
44.6922271981818955974894393231
28.3322654248545878907289052832
17.8184707270084429788650004816
11.0983807183119348705075216120
6.83129835372144479406595898806
4.14359076182645558736448269244
2.46757987468271744795018728498
1.43560376894285059340215679682
.810456197666676917841644468400
.439787599334930958787201852509
.226270520751049941361568172324
.108123499780367965204783597943
.464326822784966644396049698025e-1
.169299067436584816753394882698e-1
.469199655735873676739499484569e-2
.759462663383059003060837466947e-3
.274467754255039344218764487869e-4
.170928584725171494275937317312e-6
.164805549854823537024488915730e-3
.186103588395819479643555934831e-2
.862045149528888409541013576692e-2
.270430100577950390853155509845e-1
.683832106057640732983695992112e-1
.151155380530486940997417844281
.305260265225931355373272629124
.578418340131568456067736077698
1.04611915513270264659618649774
1.82693525696153260018528046063
3.10601585907748864211808206843
5.17103811318122938334173528160
8.46710682889918588690191351532
13.6804401444518124292825927356
21.8657369541923458894535655044
34.6397630689219002149648250147
54.4752299889726413644814556450
85.1464506508534509374230547280
132.404519399906689912923156109
204.999364055322299707277280696
316.225708375207659316069180911
486.259925856692627641526276340
745.690252692586059428943926707
1140.84686595871777172258734190
1741.84553164365474183123643905
2654.72093952001957922985051718
4039.72174882236788430838169243
6138.88647829952430091200889905
9317.59466030043166702547834443
14127.1571938947171119454115033
21399.0735085411455215709053308
32386.9421162703589189850048996
48980.0688601180186056507284624
74024.9314495375067066983120844
111808.870140695696369825672211
168787.748767711419554222302962
254680.474850804871293712049123
384115.104440746584067436136134
579104.187052591031915826199017
872766.653917117770655222570646
1314923.39354563608862579419840
1980508.95815175133235444751949
2982215.58097596735734631576003
4489497.44242626488496380539442
6757132.45205638699405937451137
10168145.2952145461544757186241
15298308.8806366334293163379648
23013066.8133587496266714250105
34613165.7401136290445465904538
52053467.5763944556225250855460
78271700.9019747560716698995342
6433936.20512622017182504257950+19801619.5377527920417317979004*%i
4284101.10801215348335813828990+13185107.4517232668677828275338*%i
2852343.05460101812487923988768+8778609.26152172841199601125809*%i
1898880.93302820569316532184351+5844154.58663689356309362556787*%i
1263984.94990045774148095455902+3890145.67154592624298782933109*%i
841255.401839032155973601685748+2589117.90079974166205649758425*%i
559820.083057124974441500416676+1722949.05340499653877309543174*%i
372473.798993080662385639073076+1146356.47919012883217915637836*%i
247776.811036338409702786608726+762578.612220322361515161640918*%i
164790.886479447468775899340906+507174.198394311527076004605436*%i
109572.602524884547481070769315+337229.794916284776029154355068*%i
72837.3639502908654821033270230+224170.355921052478922290073021*%i
48403.3523487304489521908659338+148970.200667780837785700405419*%i
32155.0526554693241607591168781+98963.0761947413543657825319054*%i
21352.9020042997356764528967338+65717.4749695497684358741449227*%i
14173.5031967106029084066831857+43621.5574526170497861119914130*%i
9403.41892882638526145340945478+28940.7476304111218134653000536*%i
6235.26218933235433149919713615+19190.1637900795148621040940256*%i
4131.91963882547148630664044174+12716.7410493442725855200382145*%i
2736.15113170677600151131045363+8421.00729327738300697621106818*%i
1810.40727860173691714828391201+5571.86067693481812512538079141*%i
1196.76893605294871649986515446+3683.27605229290385321062100923*%i
790.284480513781742924715565685+2432.24553536236341601909807687*%i
521.226810674495746211176037239+1604.17117434725819597223264748*%i
343.288074929696705617138225111+1056.53205671971238647423595296*%i
225.726539129467653566391366498+694.714853382308252988157087935*%i
148.143611624976130546633292077+455.939154635873527007664814458*%i
97.0109597935049830812002412614+298.569033882040706746894918662*%i
63.3619164428901361841499894254+195.007927120156964283637361699*%i
41.2573008108690874000693597948+126.976915493899023301378417287*%i
26.7662161642250803931198070668+82.3779428411096887451186751452*%i
17.2892137776897476357575513801+53.2107286142993077345609640640*%i
11.1090036040358575409715778352+34.1899975065617161922984331169*%i
7.09234997090253046455733622460+21.8280087453321055070290455157*%i
4.49237859305340501557549334965+13.8261196385989918122964684351*%i
2.81754171927246423631430897911+8.67150176470932257071207211495*%i
1.74480489943113613053297207528+5.36995731456193132959383145455*%i
1.06213511236778649889476936769+3.26891574959012438921113288255*%i
.630345125767780466843977656649+1.94000281631416255592028565514*%i
.357598847921944286536901057667+1.10057608716220500655936774782*%i
.181880156990778799597717661484+.559769564909370488703170476282*%i
.575436204545381467454503919125e-1+.177101053342393226457833981852*%i
-.592312653919350292108123032592e-1-.182295090382816772774211637830*%i
-.239934235090835986977393053612-.738441645343802907780238011164*%i
-.689372115194124840199622489805-2.12166920992064038862998261982*%i
-2.32810631584650469745354749746-7.16517448107451827974343250517*%i
-12.4460979958698020359696866452-38.3051509039584047440524435702*%i
-252.428830295505191955263983217-776.896055308882185794866534872*%i
-79313.7684225264606016628108699
-161.548083334975090465907791098
-17.7208433436889112744236006978
-4.25957358865932150655860495457
-1.39782558608204775728260185296
-.469737125013462366819901453283
-.179288904944519393972896200271e-1
.350905741613021380085981614655
.809761404448253695329547682238
1.49586739384801879769086535892
2.57512707400595612381760536987
4.28474531933852566603130251665
6.98097303673100039902278300041
11.2055488933185367796003652301
17.7840183989224283600352883984
27.9735241834871188473539002909
43.6857857442574321105056634361
67.8237041592384402206390863494
104.789338695702485017290683515
161.250118345109427829003814248
247.293962879255263137956945305
378.169866315809562258136268893
576.909521977999359945586575541
878.274389182286716747314601420
1334.69621737396423757483067297
2025.21499585939166986108157011
3068.92295523172883147732615620
4645.18124294982315644692567816
7024.01429084586681800215852247
10611.7964347551619670672313748
16019.9123815449447878489681146
24167.9274833748163951290034966
36438.5906844433509985041756730
54910.6809254111412947218685760
82708.7503850661678247500442433
124528.397077122566860437953809
187425.089820831587916359845211
281998.685649705187603736660785
424172.000440375691275669224670
637861.190067771853357166712779
958984.889500738964241152611432
1441482.98189673466435824905727
2166351.96175709369891631273372
3255208.29693843143941287440135
4890648.30427482301311001291422
7346809.38668086504559959218305
11035242.9776477534070801505221
16573769.2829906554962382821073
24889825.7770501770097749882426
37375587.6076147471537428926106
56120792.4952624964418093635897
84262192.1447719491455191715095
-18081809.7486912769094936366764+13137203.7657261395362178063718*%i
-12058509.6742437959597366306061+8761020.10270218829933624082490*%i
-8041442.76817366619254205568458+5842450.15759932263567274524896*%i
-5362406.63692671770901877529014+3896016.47418546288515852716929*%i
-3575751.81836767289490516561883+2597935.76563661509603025421742*%i
-2384255.61774438809685327330667+1732263.10392699110801323930431*%i
-1589686.64303116026742271085612+1154974.95236421489216929003528*%i
-1059835.20792846463253782200690+770015.351237433992900323040734*%i
-706524.820941988172163876264368+513320.329505727026897426972144*%i
-470947.109761883405271876682559+342163.103683216941025711127893*%i
-313880.936615348627372596910029+228047.849181205835218573674710*%i
-209168.964930108841813051490910+151970.148560585952199869734930*%i
-139366.776703159931157292229251+101255.890265872451358849697037*%i
-92840.9875249588977174252116797+67452.9257788978105842553002854*%i
-61833.7911210636686095274433061+44924.8789172530357392044613880*%i
-41172.0830741458300190911927093+29913.2693199366416221679774106*%i
-27406.5015761087702749426663591+19911.9889388889734862715488368*%i
-18237.2118623055641639488377750+13250.1100102088401079868679959*%i
-12130.9410105675906541209502372+8813.64454890168461927649985324*%i
-8065.57084837120070981620337720+5859.98023398195545110517983617*%i
-5359.80728029227244218632573438+3894.12793104508551426212583105*%i
-3559.59145381756322278318258098+2586.19457352289019829911525279*%i
-2362.35414594635530593360251625+1716.35075323981024738031420636*%i
-1566.50846773963499607650862171+1138.13502229335872899653130676*%i
-1037.77384840832692710702148281+753.986835320438009057423571405*%i
-686.724200388439113372598883457+498.934336592676585483744669138*%i
-453.820690371619038743781322490+329.720031643734236799921025337*%i
-299.435140883869028798422383810+217.552364231407596227482036046*%i
-197.200862246801306372878058166+143.274812981627952366846095125*%i
-129.581802706607517476721651814+94.1466905219505413097805384007*%i
-84.9204441429996974979513476534+61.6983141669930425346398266390*%i
-55.4713198133326156589091004360+40.3022729289725421016664240587*%i
-36.0913818955618206060483439592+26.2219238416083989035526775600*%i
-23.3680424821918963779883212871+16.9778766595483687849251290370*%i
-15.0387891503235901596340150218+10.9263198874156944452572890652*%i
-9.60499860719494589575689367925+6.97843996955938628148572724307*%i
-6.07505062832700507074585428428+4.41378264126525832799615652148*%i
-3.79348679267566917933044954898+2.75612948430552901948392458524*%i
-2.32736365485557498291681127577+1.69092867338656565397287409258*%i
-1.39049910892574443015463772511+1.01025673778811202962716904150*%i
-.792533602064167684529033841373+.575809366772895089942619996921*%i
-.403449710710119075002590377878+.293123372742361435797079640645*%i
-.125219602188101979278606496041+.909773663295692315460885341745e-1*%i
.142909128865061606695991612429-.103829559760665750137913623592*%i
.591553305799064194986598351157-.429788634245180410033323029048*%i
1.90733084395087652909919790156-1.38575697310666832428692176717*%i
8.69518785859465352896630864708-6.31742376826488001216887698789*%i
127.743229930729898504052396074-92.8108892094425822238946629360*%i
-9245.18494142333709492352432913
-37.2362662739324119533490032900
-5.13441397128612878794317805734
-1.38525538426781734565069822115
-.432879082981646475137140771856
-.224802341267631554024051235535e-1
.296095297379463360955982614407
.686307675012002102917122360697
1.26412343776527266159737340058
2.16381657663183697423892832222
3.57426106211234996869713855098
5.77645685824047564834053315227
9.19452611322271272303688268234
14.4705128644347721631517395218
22.5762164710701559931148085722
34.9811808818310880746941264828
53.9052819817698732583117342241
82.6985063641555854267195776888
126.411809805686883239315733167
192.654916150074809127530114133
292.884888336950295836940607921
444.341259807145984440185949208
672.951434879514737255695097346
1017.69191162131636404153105541
1537.13357882543171723970838591
2319.26326294766755721744729027
3496.21937994956821198961726449
5266.39772721439041472854042124
7927.61018108879614877463416432
11926.8183146195337475000502892
17934.7215145783622334939151829
26957.6135225284231652750047135
40505.1198133031709365695320833
60841.7214079268878492340750784
91363.9037134994339997357751750
137165.658439372828528302862575
205886.386060329080469579739485
308982.203840941975745139907566
463632.069364686398442329328368
695595.691537416324122169845782
1043498.47887440305642334212366
1565256.09849966358733169924712
2347707.07250013734506169534031
3521055.43168470487175967648834
5280525.57603669067046192601363
7918831.32298043108511216366393
11874860.3747384465402262602208
17806673.6350607093961238279708
26700965.1975920313773795616453
40037197.2213993926368987393761
60033724.9588462750269530432088
90016876.8483807614396464191157
-19250557.3570396175080357169442-13986348.6076957623418565576090*%i
-12855455.1069145839653450337520-9340034.85203714874221250970442*%i
-8585121.74608450145687868419913-6237456.05663403164817977155249*%i
-5733488.17440562679305463392320-4165622.99252150556353644314586*%i
-3829157.31727756637291388325910-2782045.63742506882571836010255*%i
-2557392.63116554942950770191167-1858054.50734929975910906955586*%i
-1708044.91679479207686839379913-1240967.27179479452666560204631*%i
-1140791.39628478574686981253340-828833.464983513696975174621131*%i
-761930.263662478874293890534016-553574.739925128561279874894227*%i
-508888.590371630634815025104293-369729.202921689074567240386691*%i
-339879.203841707055720172707501-246936.695975603209728408617833*%i
-226994.883366069087175093583756-164921.436405065877687425152429*%i
-151597.331872485660552769334819-110141.908737503401459984511425*%i
-101238.231337784175376250466852-73553.8805269452633027170932159*%i
-67603.2285416820812586644933389-49116.6205659978658843486420959*%i
-45138.9367146907336203135198618-32795.3571921654050318473290025*%i
-30136.0123677257562657730116009-21895.0946096482922916943164919*%i
-20116.7849120411435747253276189-14615.6997653344738812889962760*%i
-13426.2665325037299310747634570-9754.75362819903079643520101420*%i
-8958.98542618841137828828355936-6509.08391990611390569447954163*%i
-5976.52984584292014534461085176-4342.20310289820498785521642442*%i
-3985.67665103179744580314931287-2895.76358985258268240017063665*%i
-2656.98501583514882964095230928-1930.41261027723285543943599175*%i
-1770.41831810100027072758029247-1286.28420046009990661368421654*%i
-1179.01976439501616757663528626-856.608000191840027417422016291*%i
-784.647546942574656191237208315-570.079812348863267505229371739*%i
-521.765735562587161107150360883-379.084996542218704823647613534*%i
-346.616493953023697488872291729-251.831623764984721891041430076*%i
-229.987140114849513219798870512-167.095438187765910489862524687*%i
-152.378665410870380481237797285-110.709580781696809553331549093*%i
-100.778500297117557109117978417-73.2198663744568030960520578295*%i
-66.5049587017346412666338636790-48.3186808200504097461160178051*%i
-43.7675807661155241042081712089-31.7990087744923826291241110012*%i
-28.7056949829683221942650228882-20.8559082010766097062935825727*%i
-18.7464193300880428580914825771-13.6200708911307305356673053764*%i
-12.1760314866417436162874293065-8.84640469737756495276482772103*%i
-7.85385497868393733484939240514-5.70615965080051756463532814818*%i
-5.02134064885747497671212084395-3.64821752899698901553795933998*%i
-3.17475604087159729361923613926-2.30659527973514112598513452462*%i
-1.98043483274751693286798083272-1.43887012993425502329047631485*%i
-1.21865540637636785011265366428-.885404979716086689858249858034*%i
-.747192756734092788310538039162-.542867314384882413316477878116*%i
-.479633001964911806130846767406-.348473773762387248718585384450*%i
-.378988839173625194088946584013-.275351509299022795360339114640*%i
-.483635602556085154419550565571-.351381833314494085155539123920*%i
-1.07440437102062190234978850747-.780600467821332336304016767470*%i
-3.98242746929782190560685365455-2.89340292114163125144325889512*%i
-42.3423775653608054388987678686-30.7635380380947174703643311472*%i
1849.21203055008427705254239406
14.7083644243912232435132944522
2.57511249811900915441597022841
.879765043883874945782680210338
.499778581299443361333499600124
.497685789663763460220521163572
.711434696056047608750643217811
1.14347205738207105489802422450
1.86696962455939338479640332209
3.01680540577253721354428178153
4.80653551983255000773013971592
7.56279516869914487937377984864
11.7799898258364610711979447818
18.2035194060863508530661058758
27.9550683875766886352486694717
42.7206331726972079192480066020
65.0323909440588717373724020402
98.6910403228335719091101156956
149.398448733269071984692626934
225.705159958146166299887274335
340.429276828243657285582259802
512.781009375610981496469694582
771.543596949117009353797060459
1159.83557835469047815308966649
1742.24024815910475829491299435
2615.47864529394235728934876795
3924.38702156639303309196771413
5885.83493403873698306333151262
8824.53039666479239828142760034
13226.6202967089001945587416014
19819.9315728529847524657907982
29694.0967546256806397277276485
44480.3931901690682365437295869
66620.9872366646157948900292805
99772.0433979218381727371590022
149407.276286455860303528278512
223721.649095098343616199563579
334984.537028395787264786396143
501565.989279518422834494032459
750971.041180439367772054404040
1124383.78198940544087097185794
1683472.69278920438464269321985
2520583.01940475166576837824493
3774002.65539822745400246660031
5650828.12051380338632396748873
8461216.01751251685744689207027
12669691.5906361393485957686484
18972012.5775692289389063290955
28410322.4231260601224076417563
42545675.0857274930252580216459
63716527.8987762502700831865738
95426058.9639291474513388112875
7763694.82518454479076879601393-23894195.7511231804240191818118*%i
5190722.29312297281071163427662-15975400.5475931534796930762636*%i
3470762.58485576345583471923033-10681908.8688544116600983713869*%i
2320918.86401159816603512439739-7143053.77888798638067330102353*%i
1552147.59263849350912670962030-4777019.09312969301242181473369*%i
1038111.56323540108199335673968-3194978.86792086094934750858893*%i
694372.969189597678735725045412-2137060.25593432423300166848282*%i
464492.802382008511940331673061-1429561.85102750592627948327965*%i
310743.472723911132515086173735-956370.070287048689714079827818*%i
207903.155939843449079989186390-639860.120362835681074339797449*%i
139108.958193372429020899703953-428133.350505342905558720867723*%i
93085.6265378777128058181848190-286488.100343270116402831111841*%i
62293.3682996064211305626058898-191719.274090893490645091761150*%i
41689.8482106671717223428782430-128308.159505305549947764973523*%i
27902.6323972119611852495480121-85875.4723727521289076049609690*%i
18675.9515225455611025198091510-57478.6685420215817882166942755*%i
12500.8187213223118175188413906-38473.5639798258809673844105292*%i
8367.71236841451571026359172242-25753.1706000871038576002669057*%i
5601.19537385224768312133272534-17238.7067906072515125174956903*%i
3749.31520326958438948349994298-11539.2056767836886950270790221*%i
2509.63222530790948074917874577-7723.85378419464935147322709356*%i
1679.74128109068445596724406223-5169.71208752646932914110980579*%i
1124.17328460219263168537981838-3459.84961095239904984595193603*%i
752.252112202668640720990213541-2315.19394153146482526736507371*%i
503.279292214670621194157760389-1548.93439225030544913061119787*%i
336.620592334480917389691188117-1036.01165530201422107275403737*%i
225.072018571647147322679625264-692.700446236761317366069503832*%i
150.419975970785196551736586407-462.945083707582804994010313796*%i
100.469619649328846894725021155-309.213694380998747885576574450*%i
67.0557154845522578272506681374-206.376271620314204031561875540*%i
44.7110551863156847589261112373-137.606478476658015221338567372*%i
29.7749865960209856447464740307-91.6379860661876249377870253180*%i
19.7965491451879642170445918037-60.9275133970258328381874030632*%i
13.1348302562384905690559656084-40.4248508432166176647023040933*%i
8.69136148006452242830326084305-26.7492601428337250477058730202*%i
5.73092394648331750752921172207-17.6379702828951392595592877117*%i
3.76155687419970160764833586241-11.5768816658728273293368807399*%i
2.45421943675212303682884398599-7.55331075710753212719152943166*%i
1.58902475453923444403238130392-4.89051532720934986398322945537*%i
1.01930554810594830107554843614-3.13709990475707538355767725953*%i
.647703501630715453576475458374-1.99342640393961784752128092270*%i
.410510788345812090400204653152-1.26342229512474074596968155769*%i
.268082206378866377954601101636-.825072193181855754990142733449*%i
.201015458686570624038312253468-.618661967917390695694579255067*%i
.216620811615990472961653106670-.666690305720075778886163654127*%i
.394130706402543103905356784135-1.21300958659036015317687486864*%i
1.20335308202988704675262755696-3.70353996997248562787929483650*%i
9.28066830599253860791999297497-28.5629600593373832171837072441*%i
641.062230596575801209100601754
10.0458102838780417645607293301
2.22742431805837703523110839871
.919634074391687207671867954846
.638547345170201907865281570367
.716889364008746810639043275039
1.03766302653055772450688843901
1.62163279061922830936378256241
2.56027355670592794271708465896
4.01336549412087693752069180079
6.23000251208168666120336962146
9.58769692668320670155341840045
14.6536165088419816891674465716
22.2772011301690252823566266877
33.7289906786517989654617349267
50.9081812130318075517648809305
76.6526823100648976620153535624
115.202177574154513764298962266
172.889645942393823754811283353
259.174068886570665627595840877
388.182722687177236695714208231
581.014641817330385493651015145
869.181150693783006659250034892
1299.74514661383139026896903018
1942.99850464066892556207586310
2903.93206732397480693267306094
4339.37322791195040657153713489
6483.59389479507004695548411278
9686.57888008922036034923516449
14471.2192326088008244504609653
21618.7974593501193009002652868
32296.7717417043036523851436831
48249.8069676793330142427179335
72085.3831840436724687219153893
107700.845282307614501368705407
160921.998259873069181100575899
240458.127423303895969289170359
359330.361433540683597351864226
537008.174690984897784505727992
802605.384633001852836280552486
1199661.46452281361480587911732
1793295.15085193591666836242277
2680908.28527160220883529364398
4008203.15269213245712675618516
5993152.94809773303833006294071
8961877.24245161145982777162756
13402339.3421062445368024262767
20044725.1858773887365599806258
29981770.6810092119362419098879
44848905.4209661644427968262098
67093968.1955880629004386471213
100381060.747192760936679084316
26307195.9310714711698186656631
17606422.7774055347477696416170
11784875.0481008447059146719399
7889284.63622197540407899450289
5282148.17008244033326132556967
3537084.13693547324691722585662
2368883.03917743610769246911839
1586743.87120703682279142477939
1063008.12790096990502206811157
712253.231652763879013041478189
477311.464600177701927610910878
319919.230107170117068401348267
214462.434148709099776418783409
143792.343330686281244667192496
96426.1910331463389644471813685
64674.0168485936329332453123867
43385.1189165060432649203117895
29109.0518600030356146862582435
19534.0061446880003222628929517
13110.8126902208878829507556261
8801.18502478829215493028831550
5909.12369922943867555610017060
3967.99553250953056937499373684
2664.89083569565060511558921203
1789.94429651730589664385771928
1202.37555917100608711388645633
807.729709639866824317234245808
542.621333013349761601444396627
364.506524369790010968033445717
244.824557595165302802991835012
164.398228463427788523465450040
110.348443984643932434438430857
74.0241633544304460962076982446
49.6132891463733834648583280381
33.2103260688416538871403559148
22.1904886979999639054502598048
14.7894486791986773887265984486
9.82110227030572465386323421402
6.48799364703783813244832158931
4.25395421296439925571088050233
2.75852948614479559272424129248
1.75948224019165483327558010409
1.09416887819119126078494140350
.653613299725440289620920484946
.365136995523685192120833933539
.180773532057622447116759372192
.696203525182543818688764264508e-1
.129095767891599926568771807180e-1
.101318361051847349895683282594e-2
.319061491777382538132657773525e-1
.110843151797772951401352843778
.251197441933102668235947870613
.476595256414120994781230183128
.824685241123166012997480330483
1.35314267769579607240806728090
2.14886454515562427892898382573
3.34182066842172150019943613918
5.12577011484370435252469868935
7.78915010199584779373222905343
11.7610735830078692666709865436
17.6797936451077461941471099103
26.4945982598114036300361611533
39.6174694629609141178251593593
59.1488440738525460824328626138
88.2137423396425647303043617674
131.462316689507850459519352664
195.815395653647108051714350382
291.575157359694574562559786347
434.080081080303538750248772291
646.171376750512981222369120131
961.869490702383853652731300266
1431.85540207099704224107165281
2131.64418009978032211841617103
3173.77535559700930960924094484
4725.99731995157323492112649030
7038.39767016539208844276434361
10483.8872816576148902596706856
15618.6207320774152972597357477
23272.1850206585458956264654225
34682.2438067817250982563279377
51695.5802824174811255351176919
77068.3265757379809395504496525
114914.378332926659330217238700
171375.227741195629155927506445
255620.682454492300011157125476
381344.119177958089496274987672
568996.947164815340152807561871
849128.142344603059915127979857
1267375.97975170050647292129076
1891930.25479814030979394322410
2824688.96455619469338163004088
4217940.40762453912513390638570
6299309.93221250201053342437646
9409069.78493797004159987623485
14055944.7627962883617882843995
21000591.1478242081616372222744
31380484.0787868797414408547614
46896771.3821147672484195709522
70093866.5828643593077422450856
104777847.718560394999830413333
8441586.16964715031268471745459+25980530.7819693403156351264528*%i
5654305.24060801325290743422825+17402162.1531830424913386075730*%i
3787980.90658576896767615013325+11658206.4753332125730528224423*%i
2538120.58706050013223249797039+7811531.94616169074897433813949*%i
1700965.04560419219364668548290+5235032.11816657644446558406841*%i
1140144.92278344658094806234374+3509005.25884456403544382955475*%i
764379.912841430535000666454739+2352519.47389952582968249628039*%i
512561.725676519669859532347190+1577502.78490076296183546775292*%i
343774.848410263965144223030154+1058030.19144718773925070165850*%i
230619.767707020554502083249225+709774.662419078298902298219975*%i
154745.178995344803655142859039+476256.689851210520998213438920*%i
103857.947203236942112549060241+319641.894312218988481347111862*%i
69721.7664453065113313209639172+214581.532771497837646061562503*%i
46817.4003457332642016636564102+144089.142297406284136816936293*%i
31445.6730874105412035567202387+96779.8303765183458271283954597*%i
21126.8039419502698845050121360+65021.6166852695935725101797468*%i
14198.1195526861746955869249851+43697.3188061483127498218897112*%i
9544.58332895778594679129119358+29375.2069807307538809250379077*%i
6418.26146468223576329129681247+19753.3776471388461053055918294*%i
4317.35173822344044950631431488+13287.4423689252468811618797291*%i
2905.10922453101351631770646411+8941.00683403506712153288443255*%i
1955.50059250178741907195712355+6018.41198047920491531563975314*%i
1316.76806977651449227498667837+4052.59541062921400674088814240*%i
886.996041217978626569195934890+2729.89311359619532169971358130*%i
597.723013410000607846693751608+1839.60227816274209382443240818*%i
402.947420502197125856851665027+1240.14464242684627307828109944*%i
271.750331368708404523858959280+836.361521075393703778587159938*%i
183.344009638733127061937194242+564.274840104829924225121414403*%i
123.747838451940631247749634210+380.856685164560476242008052708*%i
83.5561920219982930884255140390+257.159516615158395438019858390*%i
56.4391619118027666865683480353+173.701879467923976185562424746*%i
38.1352525326143842747208171201+117.368238905648178815917906054*%i
25.7744200177991460327401990047+79.3255081690207335250184832089*%i
17.4229843124110073715629124522+53.6224319867700594487236412379*%i
11.7776007151009688342200037002+36.2477278282897436732647198819*%i
7.95940017547171360145164323403+24.4965148858391161235366873574*%i
5.37546177974559102045957892430+16.5439702242377934992904409449*%i
3.62555632869670310176982077154+11.1583150259313948853081610039*%i
2.43933297249500603342879308915+7.50749493113665528723111899365*%i
1.63397472628689026829684821193+5.02885711525360294815835950624*%i
1.08560062217798847421368624331+3.34113516282440741373232810490*%i
.709855359101341486175189828040+2.18471015248182637363176041147*%i
.448519336500933440322557241870+1.38040057805369057425386410541*%i
.259708980659824733932338316970+.799302054233308863467658983580*%i
.108968878039252849509751175742+.335371722005866501367145790188*%i
-.454048733400051797436509917021e-1-.139741831186061503737869519255*%i
-.310157267492640178708572241936-.954565916097360063136099677802*%i
-1.49964487035761415079967411931-4.61543232910894624069164659546*%i
-38.5076043372039830321238138873
-2.20627042988632104542480235154
-.535100308933291022433599357624
.863575684100334077898869719552e-1
.558816506114175667430824710395
1.08710096003823494170672839081
1.78670724925136464109000846719
2.77578379182133380420537925378
4.20960775895558890102494342830
6.30929089316562237514354670761
9.39767839574300230687009641203
13.9501742544283149161612789284
20.6691284711834798865359902685
30.5937477577921172153471420382
45.2630017128374959327359236847
66.9573824771527623710531827910
99.0579272714028263400044709181
146.579628423621800925708296487
216.964238670493447780228407500
321.259019175728422270438457152
475.869871320583016309693987341
705.169532434964310884952356784
1045.37900721180936871124896803
1550.34539444280593388978217685
2300.14495026857375864697133659
3413.89615722609348791416937751
5068.84772149249841783958260479
7528.82126041838603904163012047
11186.6029306538329756466718515
16627.1387728582149125067367961
24721.7631746971431135566636852
36768.7284786084396889053405363
54702.8280659831600383015500471
81408.1431864439957675587710317
121184.730701894922292597009989
180445.148262060634888571405952
268754.186715269952627295248328
400381.179220803419310124349911
596617.952654087249535541694792
889240.593417836038599989353161
1325680.22819598962541616116281
1976747.65215186351050321550899
2948174.77165138245068454035375
4397861.13664273613651875421865
6561649.06963035391281612429951
9791849.81062285492303275978043
14614835.7954673701199637497484
21817145.0631603635785998391055
32574228.3410869518118693268119
48642979.2522418339553125793917
72649678.5619053679697648653011
108520684.039768644754085558638
-22758173.9755199221811197826740+16534781.2529600583497059841488*%i
-15253590.9004809283700954903934+11082382.4939949828741097054771*%i
-10225690.7106293985368894623049+7429399.17950161844521318978638*%i
-6856501.09122706039402360405891+4981539.63609162400067479696411*%i
-4598386.33766200986675273542327+3340923.23451026968261095485253*%i
-3084645.57869792712328827842792+2241126.19674775135348898909317*%i
-2069693.99604591430398253823465+1503720.70808471597583816856978*%i
-1389032.70698211831315892839639+1009191.33441291793588478595037*%i
-932457.330707017366861033503107+677469.906309007222411430537254*%i
-626124.416704135721565709638143+454906.016558104776755771350444*%i
-420545.358977832252296931700963+305544.088252676236227094829892*%i
-282547.395345607326573470867076+205282.698895727685090520237577*%i
-189890.030263278027919324396901+137963.182630496502756288690285*%i
-127659.161543948741972354043895+92749.8099511852682935618802644*%i
-85851.4908566740673820110948324+62374.7592000371026342070198636*%i
-57756.0278077766025077366311303+41962.2104510099343200750069573*%i
-38869.4672788093805060464703479+28240.3210189678229218761977070*%i
-26169.2013798176354632413799092+19013.0377263740831510185368035*%i
-17625.9475358532228761318669731+12806.0004811886618789114700842*%i
-11876.9487994131004683163870838+8629.10840571582989786852630498*%i
-8006.79727528715401282201428727+5817.27873361356432898199924287*%i
-5400.40557169852263438561912447+3923.62431631608084671086614642*%i
-3644.35429627774836280356051168+2647.77838336483325320415908339*%i
-2460.68297325460784134756782799+1787.79082800815060934582068801*%i
-1662.44386717419644064566285751+1207.83616992374907023484120605*%i
-1123.85755634625533567266822371+816.530310105735667035439328646*%i
-760.267797563506936459320589224+552.366887602858279073425930441*%i
-514.674338926882424433993548707+373.932795303425074211354443536*%i
-348.682420798374697637554468110+253.332607477880177784479662682*%i
-236.418598914025393301548745767+171.768166522481477037845703263*%i
-160.439351632318346926442471191+116.566012126485595333962069985*%i
-108.978833170945550169476385275+79.1777569510932592601327482033*%i
-74.0968019219508312344551286479+53.8344777854866401171049702090*%i
-50.4318385773384741087880661576+36.6408754919377778227731387328*%i
-34.3617036275737065451063210837+24.9652390201483804319329613476*%i
-23.4376452896870300493615493273+17.0284460592621536829315409189*%i
-16.0031046987482297762323814611+11.6269361437630081154119459202*%i
-10.9365837014872857936326501895+7.94589317022079975767424678517*%i
-7.47814393076825574961156065178+5.43318959624831499079604417235*%i
-5.11224870640794807063626812695+3.71426609894576657251709735869*%i
-3.48855674843010445614799763726+2.53458483909456987754202566584*%i
-2.36824156323862937572704672756+1.72062821228276152668921448062*%i
-1.58736948635424365182129887165+1.15329143949438339301248906280*%i
-1.03136881751455096285076995005+.749333307982921583881270470584*%i
-.615712112419033721624255969937+.447341034680445717805270438959*%i
-.265961221302917749260175502817+.193232138076815103083581964215*%i
.129037612371442205435755046337-.937513131001234508593355842452e-1*%i
1.09017298213859867801293157861-.792057034406120622864539072796*%i
-7.02604669115118710793705756991
-.612158877794540279977970835372
.770288117319499562111619461684e-1
.514963085464930340301906149681
.971080666447146845114547330980
1.54962930067733473758169983455
2.34435724180652741441688997142
3.47333690744716746701289119834
5.10171812126944420193787176722
7.46822445767367467500460631706
10.9219541456500244572353200352
15.9758504788792981295416999681
23.3853757518691052848291449950
34.2647514221328802463790063595
50.2589995988762099034503127127
73.7988134285411487559044180865
108.478381218926064808175464598
159.615777859703032565993066331
235.084533787278704160662739403
346.548142719620815432438912031
511.293499733467493271204196685
754.954893335760376066463818124
1115.56259800851165493661819213
1649.56227443396304386548341866
2440.76750744735836875838921565
3613.67894990314006909119812817
5353.30586589090124200741698083
7934.67304889495544589564890369
11766.7577868257411351759112667
17457.9310206103383887650454019
25913.4522311686481205812275293
38480.7535535828226669719199897
57165.9884877590005258350104969
84956.8740648415678552449784930
126304.104387565570709638028387
187839.370023999410610534048701
279446.483844724589312948169660
415859.569758122351630841442872
619048.103745104678920838306755
921776.840053605917541822091170
1372920.29094404960420358682286
2045397.82942871831066078586168
3048023.56863080495110598370093
4543205.10963441622670439215716
6773382.00229124823444755020466
10100525.3442210619628838869879
15065159.2585111023898911502119
22474564.5152105151093295733452
33534610.2345879977205060392325
50046818.5078043183323836405119
74702976.8734737557510024737243
111525638.080239910303226466887
-23240227.8113507248632075949090-16885013.8654792509462286045660*%i
-15583858.6086219915928801187566-11322336.0295863276560977781251*%i
-10452122.1843743309664198403130-7593911.27485624115304726143688*%i
-7011854.54068103941658359436140-5094410.52399227097150049129412*%i
-4705053.97071565824802033795344-3418421.80628541557016976676660*%i
-3157942.76097174577060869392401-2294379.71685264127955733336413*%i
-2120102.18144644003270051124171-1540344.39853777686384009662906*%i
-1423729.67304950690454556208722-1034400.15585363466790519596971*%i
-956361.705641533135490467977385-694837.451304318292033749350085*%i
-642609.038215978889750624688494-466882.795144530866283323650527*%i
-431924.726032340945567162500794-313811.682359559899521966757100*%i
-290410.940400291369229051822795-210995.898798841883250537881511*%i
-195330.111354371544279896213546-141915.632898973748071299336117*%i
-131427.126469387677417193261853-95487.3967135492035913075692748*%i
-88464.5727665321528891899579104-64273.2743367104726337871707400*%i
-59570.6108257505400066543918688-43280.5821841643160811599240916*%i
-40131.3364978358496472572376603-29157.1226713714642475436602219*%i
-27048.0317561726099980636014494-19651.5453696989290842930067971*%i
-18238.9926738266081890641908412-13251.4038455132405059208377538*%i
-12305.3241660232460217506707551-8940.34132750798831016945557607*%i
-8306.68194797447753555621207159-6035.15770181787256225524491098*%i
-5610.75473492917432857008659245-4076.45192913349083355341847429*%i
-3792.21400567628379004221496373-2755.20475042138320103831357043*%i
-2564.85596677537400692503499364-1863.47693807061413931299428762*%i
-1736.02044568916430906125821134-1261.29268327999874683427680275*%i
-1175.96465800950860909192511309-854.388335475188045236101619831*%i
-797.279040927839469903716229554-579.257129921402076007287224298*%i
-541.048076369040696883109774169-393.094437177600385849712507150*%i
-367.542830405265734383646133483-267.035497152887386346370303253*%i
-249.959093873180843468646970408-181.605911960550123595671444999*%i
-170.202996656035123246664253344-123.659715464563743744562528573*%i
-116.053530404384669962491105275-84.3178253639486501332579410811*%i
-79.2513467821156870121456342345-57.5794738389078538574220445846*%i
-54.2109045676073348044602240156-39.3865276500067984138518974121*%i
-37.1522656331586478070832265359-26.9927009942417736596373382510*%i
-25.5155180075980280282678224474-18.5381089566065802720750195122*%i
-17.5656241682431908811487878808-12.7621729891874725284249928065*%i
-12.1256297305677847406786740384-8.80978567810368131824876148751*%i
-8.39643926596952265732121717969-6.10037021054097371523651410612*%i
-5.83500775427140090712005818040-4.23938128471922722393031298254*%i
-4.07198309537759252213686596762-2.95846889211073062232980336613*%i
-2.85603243127711939301443319995-2.07502902268537545633636097827*%i
-2.01628901122660989427854572645-1.46491971540601062878041669587*%i
-1.43727452602265084565715023837-1.04424106757420359539955225346*%i
-1.04290766622491091610283069049-.757716772295217902558285795606*%i
-.788952238620115267798499289191-.573207353922547261245934167737*%i
-.672455820575393755355088893309-.488567751852765952534946975161*%i
-.862195284945563465619138677332-.626421541958652153237572712936*%i
2.62976096547706787609365007308
.872096909524043047904670526587
.870000155528805913399346675732
1.09348163902418404373830419442
1.47939624133781724794474285523
2.05807654399386782781395518068
2.90114923815055157103964751356
4.12223052554342025430412738695
5.89108451611516933667302477415
8.45797828889216434947885053190
12.1907777259382187283186668242
17.6301546638823301517092020883
25.5713185830187061487394567051
37.1848973901136218308546514841
54.1957459356945262872695781460
79.1475633537453510584921212567
115.794706707368607821806370135
169.682651794403078661506716369
249.008372421551461693881548458
365.896249847906577984037646975
538.291077017931668819810913361
792.767853042198550600375010040
1168.70411492926754463538529740
1724.47798873243771944854731870
2546.67893786381178896280917999
3763.80049452235769007744631122
5566.60285861864444397810073024
8238.40415481757284333748007466
12200.1554440600799600716442874
18077.5345821620239665157943179
26800.8432009119562385034335733
39753.7849039444038871540676085
58995.1003602256396485556516703
87588.8192394690264856136288604
130096.475831350514612387926550
193310.886586720768443785603938
287350.279080282253577610256744
427290.080935903906492366590474
635597.069703735949888021376450
945761.116696840420852989486833
1407714.75324534283871717899424
2095922.12379370781266810778026
3121454.22563927472122317780210
4650017.93224592458852144341447
6928878.72376630284207448987986
10327070.6869103352065418399383
15395460.5935135421643949080799
22956482.3439653673654036315399
34238217.2959559890536862329763
51074763.2621099410224236534866
76205704.7509945196192239514023
113723756.909631214875791424955
8989356.87938176926893849478269-27666395.6774663813969748350924*%i
6029528.10547909871783415836647-18556979.3871685169378544074474*%i
4045184.06142217418205214829988-12449796.3906827545576356810302*%i
2714550.76092153709445984793617-8354528.18771477192165515864868*%i
1822078.65796682187684644161899-5607781.48906286706714112907227*%i
1223350.31900004175374624548074-3765085.13698452311375763550525*%i
821588.923652575419866371380461-2528590.70465106753175777046650*%i
551930.230618215021311950358628-1698666.58444302135431514111491*%i
370890.706019650030927309463127-1141484.22000798355689816219952*%i
249313.994503485729885934796002-767309.576470779645829497006071*%i
167646.160686583570618928705081-515961.828815735432156723228262*%i
112770.295727490004967627990044-347071.282642880804656017408102*%i
75885.4548870692861852423326323-233551.415216988520445215037492*%i
51085.1151298710120010897541664-157223.817829906470816488288866*%i
34404.2695237975153829816646933-105885.453921931908112697784614*%i
23180.5360397889867827044864287-71342.3541525562093894164627643*%i
15625.7132653575718146325254433-48091.0004734119706095313794875*%i
10538.4008363716891012017113378-32433.8627622550689638745684356*%i
7111.19572804460102514290201390-21886.0100218338590244987636460*%i
4801.30933056547492134119897805-14776.9106835672988629722615822*%i
3243.72241324074872092843820678-9983.15107039743654586921700605*%i
2192.87766174388445460995040201-6748.98347858851716802426657693*%i
1483.52178207685563263707999967-4565.81056573883248938897107749*%i
1004.40064674958243857030577138-3091.22733522936706369880867748*%i
680.583481509860011872055830428-2094.62057671631463258098818899*%i
461.581785898069073177556783745-1420.60266351843972515052276409*%i
313.360712407330514483471934840-964.425105773550293624756576047*%i
212.965853965932261655669642396-655.441502731418871093648061604*%i
144.907897604706087870704804281-445.980650864681262477875562229*%i
98.7291466231947737506518441402-303.857069201568316395396921837*%i
67.3649129215196193900087992171-207.327883481805435822483710938*%i
46.0396879986170405071048193302-141.695589810028756311410841819*%i
31.5232376798364735338706444044-97.0185496456953461107532283365*%i
21.6290305106270920373065570809-66.5673111276182659006862078521*%i
14.8758935451473719803531022450-45.7832926646716839428083296562*%i
10.2596595311753877499089681817-31.5759852361216693795375035273*%i
7.09896613799273505581411154941-21.8483712138648288772963690058*%i
4.93107047063466148176209291769-15.1762744081233264622798276664*%i
3.44141747213395517207426470229-10.5915938985339502134452904118*%i
2.41600322613035782218582725421-7.43569335482370327126063827036*%i
1.70914701965160400368942566741-5.26021364499389094848504753236*%i
1.22169758875765378017341940753-3.75999855632613398132724831570*%i
.886335164291246854288366859814-2.72785914355869397000608305651*%i
.657763209681915158011763915304-2.02438700179758452902587058352*%i
.506438236171040566827492638124-1.55865662205968449276479367799*%i
.415414528755270564423839170455-1.27851445625351212774944268799*%i
.382410279749292092158841690256-1.17693782243097946214547398405*%i
.450476054717138017942291755445-1.38642273749459433094342078587*%i
2.32931609770501110978701811397
1.29334316324926296322081382182
1.25869283878481720325690693653
1.45146038800381079338602586988
1.82748706249709226950826866998
2.41787599866458123701413783924
3.29483646243851168794135068996
4.57448564486560966922611199711
6.43159082023005205929333545343
9.12451301706732613332631848316
13.0332038145971349655384064395
18.7157833865255414127479626184
26.9922936390776960074000989768
39.0685077718525248729106383079
56.7189484908202159097043553106
82.5575379844420555002885010222
120.438051111964308427047453267
176.046955119472766240295488226
257.781542913480444334699183220
378.051335396063462655186597715
555.207736053517528519059676521
816.406581540923202243949686355
1201.85650417447709191806430892
1771.12668379155634428717282958
2612.51605350639694937309961377
3856.97515919112314551590387355
5698.80041315062107124953372128
8426.40587756516009694657956514
12468.0951480821100825513812743
18460.1667367200925029019986254
27348.2805566618452699286235768
40538.3727056556260462047609569
60121.3994953054084801724360871
89208.1165908628996203403302655
132427.891876886895081668910830
196672.103490053211421931881353
292202.307327674818275701949460
434302.524670251959753488179307
645743.342224203541416443500389
960457.441540230662078506368990
1429023.21429720338147583948458
2126847.45748354343774289213095
3166377.88729839479239602238929
4715333.28794841761169530133572
7023921.06549456536783435609237
10465479.6278552705532745884726
15597176.8760337056649132031808
23250675.9131209953403072614682
34667582.9902402601267710351350
51701825.7766600249661341224580
77122076.7857988974096478576457
115063739.564685072410563680719
29212432.5655932658575006244852
19595776.2695114322944327802628
13147987.6135932682353431913778
8823944.00630970176210594890069
5923491.07740726564375498873192
3977493.79671455813898664871925
2671552.28818000495157668816242
1794924.87199974780065081455458
1206323.51401985092194030697161
811004.435141250077455906859090
545421.357782312659529814405479
366943.081534567471508293038040
246962.941148583064696713027448
166280.390001676256580874814520
112004.879793866369672614927207
75479.8435040640037586543611255
50890.3855227271669688183756139
34329.3038866887648217782643045
23170.4233138213828638154072092
15648.0226595336968631601012777
10574.5072937158447667924657766
7150.83502777795277232803125074
4839.18846868654205346742442262
3277.43091113965739216933103264
2221.61705310570244303649305597
1507.34568302971765179260025122
1023.77041963976193264657783521
696.116636208972110103214276999
473.916277940737164238463162892
323.087508156769492405887863851
220.600569128920989388384473682
150.883870534810147103413501035
103.401489136934825672874802568
71.0194978080001623535295951684
48.9037126676824364971054296088
33.7756021523084370917878835521
23.4096997136002577248652508645
16.2939394599822039381789606044
11.3999610686264958378393733163
8.02768454705400994593326813237
5.70007739355663830020511962715
4.09186872886220703231989166110
2.98124605377347233087596326384
2.21713407695322260093206109664
1.69706282602836209572753734106
1.35226228062617724571434295622
1.13772845825526951466941896863
1.02576430678019591521622535907
1.00202602538693935154078541445
1.06348337074132351926318441545
1.21798952435132157015794433994
1.48539639252487470204931293105
1.90038167004401750848052153907
2.51740997442691002521001529981
3.41857118798755710610235730797
4.72547430983966144920691369537
6.61699200168695394660311354436
9.35554549274894173006129532585
13.3259310971828442986318191574
19.0926234795194590022671291986
27.4843503628033552855109772730
39.7189683608281308944420195974
57.5879476966875714011294956509
83.7290867318056309927555274404
122.029900136019719195843452701
178.224650303819986548391313409
260.778483040492834999427867362
382.197441271302935456563280194
560.970492890346876774411317990
824.449884177029788217677620957
1213.12514974899713887670675364
1786.96785736167606293185524690
2634.85423153922125053193872491
3888.56423211953579797123801298
5743.58754859396494784394636529
8490.05723879778901894068508419
12558.7562796828209457683661607
18589.5634919027766362259648788
27533.3146357198486900388917339
40803.4361754065988779647660692
60501.7352709195155099361802119
89754.7017280239703524195033087
133214.539537599664578916468063
197805.799700620654485578879429
293838.267202610900019217044395
436666.138674571585610258133822
649162.187629238318963136368293
965408.006304610975708313966773
1436199.13878004882538127259042
2137259.26493723802817785798036
3181498.81931707642515586784208
4737312.68063709570331359217346
7055896.71814113702766972500135
10512035.3326401407977580431999
15665012.9096479379620039883437
23349592.1011966662543778129230
34811920.7493719340425428336762
51912584.3997892112329494142278
77430020.6073967238416058844919
115513961.922158064121005558083
8989356.87938176910476265171422+27666395.6774663808916935456786*%i
6029528.10547909846783266339469+18556979.3871685161684289221036*%i
4045184.06142217380127196446884+12449796.3906827533857147779709*%i
2714550.76092153651435194327740+8354528.18771477013626661069514*%i
1822078.65796682099284991691781+5607781.48906286434647957807933*%i
1223350.31900004040632124561936+3765085.13698451896680989585351*%i
821588.923652573365508025988962+2528590.70465106120909291139649*%i
551930.230618211888235248859435+1698666.58444301171169655620350*%i
370890.706019645251287486163286+1141484.22000796884667936440236*%i
249313.994503478436063503244596+767309.576470757197752276340733*%i
167646.160686572436441493143122+515961.828815701164682129811038*%i
112770.295727473002511708326460+347071.282642828476477341911554*%i
75885.4548870433130722882310883+233551.415216908583423067005857*%i
51085.1151298313198956623408746+157223.817829784311077058514453*%i
34404.2695237368331166735824930+105885.453921745147300682915483*%i
23180.5360396961740449013382401+71342.3541522705611542395502896*%i
15625.7132652155506386255191406+48091.0004729748743742043470989*%i
10538.4008361542633126903388975+32433.8627615859011940157691295*%i
7111.19572771156180386051304339+21886.0100208088696959242888267*%i
4801.30933005506223173944152386+14776.9106819964101310195900186*%i
3243.72241245802897522103478283+9983.15106798847287028354077046*%i
2192.87766054281335903029362128+6748.98347489200043018171163451*%i
1483.52178023256342200397667632+4565.81056006268471498291414675*%i
1004.40064391549785576039590952+3091.22732650695160022255292886*%i
680.583477151287331731424096052+2094.62056330200724933034436278*%i
461.581779189129029435382827828+1420.60264287044540062940953707*%i
313.360702070786377775575397546+964.425073960938572793471494542*%i
212.965838023775676544417784885+655.441453666506002026691720433*%i
144.907872988954731698110581422+445.980575105188558386064809962*%i
98.7291085670917796106852164356+303.856952076926642284952619733*%i
67.3648540046202544479805603066+207.327702154234198929261358057*%i
46.0395966442824380573074472506+141.695308650297100752071622160*%i
31.5230957825218426479763776456+97.0181129306661372560175133604*%i
21.6288096730615460643815956529+66.5666314594783951988636290574*%i
14.8755490810859696046105546853+45.7822325133007573253539789334*%i
10.2591208496982622579789957209+31.5743273450077390051798330952*%i
7.09812121447908125322853679155+21.8457708066766842986406180656*%i
4.92974054451397893166673082211+15.1721813163960424285703372410*%i
3.43931536070932579076137197628+10.5851242648090603480723568431*%i
2.41266366555013018973681383453+7.42541524420453724980504817029*%i
1.70380808518897936873293981047+5.24378209429221350123816154593*%i
1.21309374110510813083058542182+3.73351863604953028662752825671*%i
.872323300985076158800831018787+2.68473506253614240327149759431*%i
.634612074871805026483574998857+1.95313513532558364091582360540*%i
.467370193990555881483083102019+1.43841755181113838667578969834*%i
.347212092052380746508467233485+1.06860893961779086573060850761*%i
.255496217679057634428748554142+.786336502961380612647618304338*%i
.170407589342834687550463890647+.524460632330163476642734138560*%i
.326482735693480112272256454928
.676603360541811409269384778064
.949515447180658384655239819815
1.27958446849752544905717500254
1.72733128181209357523882190959
2.35790672419662545065923252908
3.25828759265443020554236927656
4.55193076762691580109588463577
6.41754210532432348617955493040
9.11569954725283680102204593233
13.0276430203294771575655098705
18.7122584756750842276816437195
26.9900505880809037003224121903
39.0670757548236107227679187716
56.7180316997310254665350150586
82.5569496255088144634111220259
120.437672728929217238885663889
176.046711321850314693896606764
257.781385571268513877596615139
378.051233700291924472882757409
555.207670236562286037858146975
816.406538893321666464967957593
1201.85647650979739275348889024
1771.12666582811946664878849966
2612.51604183158958406176058281
3856.97515159705224964296471461
5698.80040820710411871108353829
8426.40587434476738489186133661
12468.0951459828283162611403284
18460.1667353507827277303803084
27348.2805557681617388568921617
40538.3727050720457542162910796
60121.3994949241341477029594700
89208.1165906136805739275818207
132427.891876723920677679541163
196672.103489946590867687214501
292202.307327605037528297443673
434302.524670206272604341131351
645743.342224173618244994441096
960457.441540211057011692318314
1429023.21429719053249146580437
2126847.45748353501405612712409
3166377.88729838926828743926972
4715333.28794841398807326701241
7023921.06549456299023449271015
10465479.6278552689928431125141
15597176.8760337046405454432034
23250675.9131209946676902036471
34667582.9902402596850211741426
51701825.7766600246759473675388
77122076.7857988972189843148554
115063739.564685072285265967021
-23240227.8113507245943713305524+16885013.8654792507509076254408*%i
-15583858.6086219911834031647119+11322336.0295863273585953567735*%i
-10452122.1843743303425786112393+7593911.27485624069980007779170*%i
-7011854.54068103846592121147858+5094410.52399227028080384035483*%i
-4705053.97071565679894448256591+3418421.80628541451735453152182*%i
-3157942.76097174356121147580200+2294379.71685263967433629314176*%i
-2120102.18144643666308742059894+1540344.39853777441567288335351*%i
-1423729.67304950176392059256919+1034400.15585363093302253508860*%i
-956361.705641525290579502547079+694837.451304312592372304549374*%i
-642609.038215966913981853203840+466882.795144522165378005608411*%i
-431924.726032322657419999341190+313811.682359546612405294301052*%i
-290410.940400263431236327435428+210995.898798821585110676509734*%i
-195330.111354328848117778748673+141915.632898942727493738386465*%i
-131427.126469322400390855004322+95487.3967135017770555710991221*%i
-88464.5727664323092557550661915+64273.2743366379319879461439368*%i
-59570.6108255977550950166194554+43280.5821840533113452175412396*%i
-40131.3364976019372090624068559+29157.1226712015169133656901149*%i
-27048.0317558143050144181857966+19651.5453694386052756783470210*%i
-18238.9926732774538707800068345+13251.4038451142565392495861295*%i
-12305.3241651810854147261090987+8940.34132689612281375530126522*%i
-8306.68194668214822977530543095+6035.15770087894036141777195620*%i
-5610.75473294467885609211835534+4076.45192769167047616408235321*%i
-3792.21400262664062068690202857+2755.20474820568774326062359123*%i
-2564.85596208512261124030987284+1863.47693466294703331154190482*%i
-1736.02043846943520465879803935+1261.29267803455851180783331605*%i
-1175.96464688561617333192170757+854.388327393207113699317226233*%i
-797.279023770822120096081324443+579.257117456099317646211034319*%i
-541.048049876751876237997856016+393.094417929825893450052165815*%i
-367.542789447143811060546336983+267.035467395069941823411398184*%i
-249.959030462607729753991060362+181.605865890072031288657022436*%i
-170.202898333629038869558892759+123.659644029154267631543894585*%i
-116.053377685486154690590890344+84.3177144071740486534563625392*%i
-79.2511091100612126358247289881+57.5793011600525598162058661693*%i
-54.2105338668090527224504212282+39.3862583201116809446467110254*%i
-37.1516859788853211271026686041+26.9922798507606617831339985764*%i
-25.5146089579950914278878892902+18.5374484934099804449000624532*%i
-17.5641936415781376488665141233+12.7611336507278656748978366481*%i
-12.1233694047107930779579204011+8.80814345524142671179169587637*%i
-8.39285026074707360359610914184+6.09776264561363113714439051156*%i
-5.82927466826988192870698166110+4.23521595392241147909421589895*%i
-4.06275565480838576090392388988+2.95176476411255991581293051382*%i
-2.84103527640142992265662996361+2.06413295186910410476357633622*%i
-1.99159393659731875671963271301+1.44697769345556439537310062033*%i
-1.39585617296695663224219231884+1.01414887263930095772536748001*%i
-.971492079287408571496915909355+.705830311222658320289647570443*%i
-.659995809914983173330749314765+.479515024208577502057625179708*%i
-.417246745869046309364541568160+.303147505545707274749642877409*%i
-.203369578365793245255786189678+.147756647585267774237691107307*%i
.899352255061641096940194379580e-1
.366615340214231560667624107224
.640094319905826908448383966834
.971436436964012273350989274126
1.41019636061265084739238965290
2.01738984825873330235458109689
2.87667328482653948675091406267
4.10727335186522761071555259790
5.88183915639261607053323055000
8.45221370667993912328985841075
12.1871588857893493816290176804
17.6278703709126495299119398783
25.5698701742192012089237528558
37.1839755259097088871118883782
54.1951573210010532342100011536
79.1471864871042487593669383178
115.794464838817212208847030847
169.682496241554067622062959938
249.008272196219436716437077172
365.896185164993159571313218031
538.291035211839185637870317406
792.767825986172286939108012526
1168.70409739819935704977400695
1724.47797736073329413905832706
2546.67893048010302551426587038
3763.80048972370343956974063129
5566.60285549739376604264412320
8238.40415278580470450555438018
12200.1554427365582712977271234
18077.5345812992894506613253884
26800.8432003492359879400243955
39753.7849035771560641450190631
58995.1003599858331112121186891
87588.8192393123574342907075746
130096.475831248111665392824180
193310.886586653805188375738297
287350.279080238446489779825599
427290.080935875236622852852118
635597.069703717179589856466701
945761.116696828127450423311249
1407714.75324533478455200160068
2095922.12379370253418574466650
3121454.22563927126078663426325
4650017.93224592231928566043161
6928878.72376630135357268630928
10327070.6869103342299016131704
15395460.5935135415234359628045
22956482.3439653669446466081169
34238217.2959559887774163180347
51074763.2621099408409838127738
76205704.7509945195000381278732
113723756.909631214797483501016
-22758173.9755199224553638960923-16534781.2529600585489559956024*%i
-15253590.9004809287879828448079-11082382.4939949831777226403748*%i
-10225690.7106293991738196322278-7429399.17950161890797004560504*%i
-6856501.09122706136507053493676-4981539.63609162470618168893595*%i
-4598386.33766201134759881745856-3340923.23451027075850861088128*%i
-3084645.57869792938223930608719-2241126.19674775299471297936904*%i
-2069693.99604591775095041686876-1503720.70808471848020692506588*%i
-1389032.70698212357463979216910-1009191.33441292175857439376763*%i
-932457.330707025400761329419237-677469.906309013059381661275176*%i
-626124.416704147993146133599848-454906.016558113692580835196679*%i
-420545.358977851003915640784561-305544.088252689860075555920111*%i
-282547.395345635991481237734406-205282.698895748511365074217871*%i
-189890.030263321865439427421533-137963.182630528352578965827630*%i
-127659.161544015813173381815460-92749.8099512339983735129531765*%i
-85851.4908567767348647210376642-62374.7592001116949266390484080*%i
-57756.0278079338376672187904728-41962.2104511241723503365010967*%i
-38869.4672790503160256172711406-28240.3210191428728233514524178*%i
-26169.2013801870401220712526515-19013.0377266424713457017504039*%i
-17625.9475364199472822554154734-12806.0004816004112616188098368*%i
-11876.9488002831200419548053775-8629.10840634793611831392896562*%i
-8006.79727662373550031806082491-5817.27873458464762179254254518*%i
-5400.40557375344520573142945096-3923.62431780906948655172774866*%i
-3644.35429943970804415210831374-2647.77838566213143354215835769*%i
-2460.68297812438089860144065101-1787.79083154624783717544448433*%i
-1662.44387468155873481031241356-1207.83617537816705008935145537*%i
-1123.85756793220913613206731493-816.530318523423830574529682055*%i
-760.267815464914200023835828950-552.366900608991967197118525515*%i
-514.674366622148370124759467602-373.932815425213608174305381086*%i
-348.682463707254106403493656987-253.332638653005897306460087676*%i
-236.418665499949627770097662066-171.768214899987199922049511468*%i
-160.439455145131094103947336115-116.566087332946249613851697136*%i
-108.978994413807994654504774021-79.1778741008901624969495189382*%i
-74.0970536661473050172189492713-53.8346606883515568574918314137*%i
-50.4322326478492032125276509005-36.6411618009228553094943136726*%i
-34.3623223550571165017413366068-24.9656885519783234968143748492*%i
-23.4386201771589594833386892869-17.0291543564705300491913992131*%i
-16.0046471661585583746312115160-11.6280568119346741375951129083*%i
-10.9390363830842512352502581794-7.94767514770865125530191934644*%i
-7.48206768176930278481465844295-5.43604036821987926918080667160*%i
-5.11857334302694955654291091063-3.71886121642365119057871073637*%i
-3.49884963641852508511947625825-2.54206305995415301504035452639*%i
-2.38520472876438807424848597798-1.73295267344681963822578032357*%i
-1.61580974640700190603747891286-1.17395449793024425339255940683*%i
-1.08024124230725200101922169784-.784841203041562471593150344130*%i
-.702947009944654665937660831438-.510720897658998959788216420584*%i
-.432142339575608793989763230432-.313969787853413926097418670699*%i
-.232627285951410504468713174664-.169013616418163761418611795582*%i
-.823838963041520247528140763653e-1-.598554042877501196279386386757e-1*%i
.219862396527527599044923964980e-1
.176891878349957311447449970264
.387074399789835209741123582944
.668089202273356662335225976017
1.05419660052735557927702522780
1.59708319202875625450723086062
2.37230582883419138369336838824
3.49014483315627917136762305470
5.11197795999575522340165842057
7.47455731984512582699374473360
10.9258968627750138498583167865
15.9783219723152306871195017175
23.3869336337939008598382660766
34.2657379394546908337215400078
50.2596267199609490717490659495
73.7992133968480663990611163862
108.478637035752454694508210334
159.615941881617923139803642729
235.084639180519281569187745609
346.548210570121140190992141090
511.293543488873005611284850014
754.954921595732590387030001328
1115.56261628561748330258251198
1649.56228626934681538897314864
2440.76751512004773419842388804
3613.67895488235261166971658749
5353.30586912523015813677618784
7934.67305099769410985710208693
11766.7577881938948979511333603
17457.9310215011935874292161776
25913.4522317491168093454866327
38480.7535539612906986447231475
57165.9884880059110782084346096
84956.8740650027412204462728970
126304.104387670833475457877276
187839.370024068191891235359984
279446.483844769553530589494357
415859.569758151758821598363177
619048.103745123919543819339678
921776.840053618511262493792782
1372920.29094405785031756725366
2045397.82942872371194050061065
3048023.56863080849016979695123
4543205.10963441854632737597006
6773382.00229124975526505374143
10100525.3442210629602654991407
15065159.2585111030441723702133
22474564.5152105155386495177332
33534610.2345879980022834700022
50046818.5078043185173680871548
74702976.8734737558724709896229
111525638.080239910383005292117
8441586.16964715048696748639540-25980530.7819693408520223352352*%i
5654305.24060801351863004549737-17402162.1531830433091487137312*%i
3787980.90658576937292703908398-11658206.4753332138202868117916*%i
2538120.58706050075045765714878-7811531.94616169265167573281037*%i
1700965.04560419313706187448869-5235032.11816657934799897999260*%i
1140144.92278344802107000305631-3509005.25884456846768341801070*%i
764379.912841432734091269436015-2352519.47389953259778744183266*%i
512561.725676523029108859196765-1577502.78490077330054181826491*%i
343774.848410269098543582626984-1058030.19144720353822940043565*%i
230619.767707028402171453107027-709774.662419102451545123025828*%i
154745.178995356805806142444856-476256.689851247459820755555701*%i
103857.947203255306269502006930-319641.894312275507544875298350*%i
69721.7664453346231001037134920-214581.532771584356774045108082*%i
46817.4003457763191872317889120-144089.142297538793757093295818*%i
31445.6730874765179477358785830-96779.8303767214013665250143236*%i
21126.8039420514292059995711326-65021.6166855809299509058027212*%i
14198.1195528413724872084271636-43697.3188066259624381013424421*%i
9544.58332919604453228607646254-29375.2069814640384070930011572*%i
6418.26146504826502273046326724-19753.3776482653683312059641535*%i
4317.35173878618388793637801316-13287.4423706571930972714826015*%i
2905.10922539689477424334284079-8941.00683669997561419921491596*%i
1955.50059383527354507643469783-6018.41198458325321237122595263*%i
1316.76807183209065468497621573-4052.59541695562692119999790260*%i
886.996044389958872349446689185-2729.89312335854670438270537848*%i
597.723018310283667536587403972-1839.60229324426259413079770711*%i
402.947428081924751788292758755-1240.14466575484920367994470129*%i
271.750343109107913064929035911-836.361557208627991075874384555*%i
183.344027851365685078665114605-564.274896157549316655228131067*%i
123.747866752653041487642563678-380.856772265197151568712887433*%i
83.5562360819370015729785492742-257.159652217706407491625129437*%i
56.4392306527206205773895686304-173.702091030715185421794040481*%i
38.1353600391148161808576775199-117.368569776634697417704849691*%i
25.7745886150641153764978016038-79.3260270580475424483553003690*%i
17.4232495553767905840991905195-53.6232483206792019809897776041*%i
11.7780195459922210716393377325-36.2490168572286111232234131008*%i
7.96006440154059722955921610120-24.4985591634762819016108425797*%i
5.37652062822578704833464235096-16.5472290247736558516132774808*%i
3.62725480070795033608952392783-11.1635423852787634402098342854*%i
2.44207839706312863054335803147-7.51594447913252268436536277522*%i
1.63845530504145739509305389007-5.04264691872355139453265531977*%i
1.09300395441252320471358846973-3.36392027656287383581106949128*%i
.722290282100942996413052871825-2.22298091028374186181754818410*%i
.469883603009825008649689400227-1.44615302937193077861149113006*%i
.297641859584722896343400687811-.916047451218130063422613137836*%i
.179866270388378687200985193430-.553571459267425857613336005145*%i
.994308195014087150638538614324e-1-.306016596267329740098321213541*%i
.453446759347850269366529404450e-1-.139556562623034771783056544159*%i
.116311494334264954380356422312e-1-.357969971296820010232594004670e-1*%i
.490067874355681780392034651605e-2
.779627537844269564557096781611e-1
.214685685978105295565823057601
.423832131912139130425319774916
.731758309212250976487192421259
1.18203375769420441278066905599
1.84104150822175526492462857216
2.80775533082003120761262931055
4.22879177418381804703036024276
6.32096920055186538310735755709
9.40486643739436268617903756796
13.9546370671342165021329479293
20.6719186902898398631334975288
30.5955022615347068807137334537
45.2641102301597180457306241068
66.9580856815528847519144040938
99.0583748999572007643364707403
146.579914213873389858193625012
216.964421608830952493738147399
321.259136544677059565023076158
475.869946774047136162337216884
705.169581029454948618126948564
1045.37903855878626826942182627
1550.34541469330437072742741732
2300.14496336785462665016614480
3413.89616570967181880351886968
5068.84772699278587426663972990
7528.82126398804518844032741103
11186.6029329726591896035558511
16627.1387743657893612842916876
24721.7631756780569984185647863
36768.7284792471440864175868183
54702.8280663993233000786755726
81408.1431867153286816127034267
121184.730702071932433963320610
180445.148262176175444971427029
268754.186715345409114822380424
400381.179220852722048216104739
596617.952654119478435062675072
889240.593417857115590025082016
1325680.22819600341496302166393
1976747.65215187253577171188767
2948174.77165138835990479915757
4397861.13664274000688429409683
6561649.06963035644863364653730
9791849.81062285658499523627637
14614835.7954673712095337034896
21817145.0631603642931186182981
32574228.3410869522805652174885
48642979.2522418342628389275959
72649678.5619053681715932583356
108520684.039768644886576538194
26307195.9310714711698186656631
17606422.7774055347477696416170
11784875.0481008447059146719399
7889284.63622197540407899450289
5282148.17008244033326132556967
3537084.13693547324691722585662
2368883.03917743610769246911839
1586743.87120703682279142477939
1063008.12790096990502206811157
712253.231652763879013041478189
477311.464600177701927610910878
319919.230107170117068401348267
214462.434148709099776418783409
143792.343330686281244667192496
96426.1910331463389644471813685
64674.0168485936329332453123867
43385.1189165060432649203117895
29109.0518600030356146862582435
19534.0061446880003222628929517
13110.8126902208878829507556261
8801.18502478829215493028831550
5909.12369922943867555610017060
3967.99553250953056937499373684
2664.89083569565060511558921203
1789.94429651730589664385771928
1202.37555917100608711388645633
807.729709639866824317234245808
542.621333013349761601444396627
364.506524369790010968033445717
244.824557595165302802991835012
164.398228463427788523465450040
110.348443984643932434438430857
74.0241633544304460962076982446
49.6132891463733834648583280381
33.2103260688416538871403559148
22.1904886979999639054502598048
14.7894486791986773887265984486
9.82110227030572465386323421402
6.48799364703783813244832158931
4.25395421296439925571088050233
2.75852948614479559272424129248
1.75948224019165483327558010409
1.09416887819119126078494140350
.653613299725440289620920484946
.365136995523685192120833933539
.180773532057622447116759372192
.696203525182543818688764264508e-1
.129095767891599926568771807180e-1
.101318361051847349895683282594e-2
.319061491777382538132657773525e-1
.110843151797772951401352843778
.251197441933102668235947870613
.476595256414120994781230183128
.824685241123166012997480330483
1.35314267769579607240806728090
2.14886454515562427892898382573
3.34182066842172150019943613918
5.12577011484370435252469868935
7.78915010199584779373222905343
11.7610735830078692666709865436
17.6797936451077461941471099103
26.4945982598114036300361611533
39.6174694629609141178251593593
59.1488440738525460824328626138
88.2137423396425647303043617674
131.462316689507850459519352664
195.815395653647108051714350382
291.575157359694574562559786347
434.080081080303538750248772291
646.171376750512981222369120131
961.869490702383853652731300266
1431.85540207099704224107165281
2131.64418009978032211841617103
3173.77535559700930960924094484
4725.99731995157323492112649030
7038.39767016539208844276434361
10483.8872816576148902596706856
15618.6207320774152972597357477
23272.1850206585458956264654225
34682.2438067817250982563279377
51695.5802824174811255351176919
77068.3265757379809395504496525
114914.378332926659330217238700
171375.227741195629155927506445
255620.682454492300011157125476
381344.119177958089496274987672
568996.947164815340152807561871
849128.142344603059915127979857
1267375.97975170050647292129076
1891930.25479814030979394322410
2824688.96455619469338163004088
4217940.40762453912513390638570
6299309.93221250201053342437646
9409069.78493797004159987623485
14055944.7627962883617882843995
21000591.1478242081616372222744
31380484.0787868797414408547614
46896771.3821147672484195709522
70093866.5828643593077422450856
104777847.718560394999830413333
7763694.82518454460205185478619+23894195.7511231798432081586091*%i
5190722.29312297252250525854811+15975400.5475931525926850583750*%i
3470762.58485576301553522890054+10681908.8688544103049958785723*%i
2320918.86401159749313207400376+7143053.77888798430969066071206*%i
1552147.59263849248034095873865+4777019.09312968984614484596476*%i
1038111.56323539950846494295719+3194978.86792085610652501421305*%i
694372.969189595270986488164067+2137060.25593431682271148048682*%i
464492.802382004826023297824300+1429561.85102749458219330880947*%i
310743.472723905487189182348054+956370.070287031315187483634512*%i
207903.155939834798321784982654+639860.120362809056778230635852*%i
139108.958193359165626882431723+428133.350505302085029306840232*%i
93085.6265378573655697856682463+286488.100343207494049466816466*%i
62293.3682995751874797503502753+191719.274090797363352181001564*%i
41689.8482106191956634151652793+128308.159505157894821024601494*%i
27902.6323971382165223690063108+85875.4723725251661727029787744*%i
18675.9515224321220511603736875+57478.6685416724522873749817002*%i
12500.8187211476714522927705519+38473.5639792883931904018587076*%i
8367.71236814542204183682533857+25753.1705992589187043251117350*%i
5601.19537343722776637913401237+17238.7067893299515471601863857*%i
3749.31520262885544128244788935+11539.2056748117277593570854222*%i
2509.63222431763149251510462702+7723.85378114688708985818788892*%i
1679.74127955832917696722911208+5169.71208281036471385917149435*%i
1124.17328222792786541906045474+3459.84960364516346581284989407*%i
752.252108518661085867126332352+2315.19393019325542286436890665*%i
503.279286489404067367417683936+1548.93437462974683047795647001*%i
336.620583421433767803276137683+1036.01162787047574272382623756*%i
225.072004669091389860052487559+692.700403449094337962306868431*%i
150.419954238907079405342801807+462.945016823739291953411159742*%i
100.469585596996540628204072503+309.213589578696206468076014390*%i
67.0556619817244160735533806498+206.376106955541763144413898558*%i
44.7109708633856059514184591144+137.606218957364305295479263424*%i
29.7748532301494868912761602712+91.6375756082404921938926521335*%i
19.7963373549851235569647988574+60.9268615738052151310719323282*%i
13.1344923358203780813540689585+40.4238108311089174829849896215*%i
8.69081932237664134704338816975+26.7475915530431804445190728737*%i
5.73004838181410809098893123047+17.6352755719269811417804416642*%i
3.76013166435913823524068451268+11.5724953210095052703987167356*%i
2.45187708386079727688240475285+7.54610173617564398038613420455*%i
1.58512874949196369734012889404+4.87852465661461299196582178390*%i
1.01272640378407435645486187170+3.11685138058894389778093109472*%i
.636372413436766840222139076487+1.95855290034682132541584794949*%i
.390474025074233076196517951448+1.20175547866552424302046618173*%i
.231326853706496820209394022301+.711950849359033511719244277079*%i
.129874383637712056099343440162+.399712252422569495042598052680*%i
.668587229680788483030357590290e-1+.205769990995417266631833797890*%i
.295631234016126558744593056218e-1+.909859382006237482024077445912e-1*%i
.959478968586500980564385546402e-2+.295297262588456618225678360649e-1*%i
.128453358296285489987280864678e-2+.395338786123352108898837352394e-2*%i
.196596882788514836297142691997e-3
.122639599974659087033024204473e-1
.538392613690791940628546526847e-1
.140400540833814110048787599271
.293597123022199635320459508588
.546006022812441009866574286296
.947024454978599584052398157650
1.57133929863820611396390649891
2.53147154909430417798012719792
3.99648571099687114785378147557
6.21993530006312735350469888553
9.58161043070761566415965589563
14.6498965563910496172340662973
22.2749074504300941920066100876
33.7275661062727110299170578589
50.9072910342638390457715078462
76.6521231879352178732904485446
115.201824837325620602448484789
172.889422559744259565742707945
259.173926951468467576831855475
388.182632239790372677514012899
581.014584031524176227089413084
869.181113690392394159211388364
1299.74512286993739095213826693
1942.99848937687434462570742555
2903.93205749528238325353351117
4339.37322157347986207938696713
6483.59389070180232629057101808
9686.57887744254032860224576253
14471.2192308955019241052146206
21618.7974582398579302808035624
32296.7717409841218107033323330
48249.8069672117569998915373833
72085.3831837398450316526750997
107700.845282110035435717906907
160921.998259744489895379930436
240458.127423220163016809745836
359330.361433486120600178940743
537008.174690949321609175088950
802605.384632978643440277390203
1199661.46452279846532944508647
1793295.15085192602322507262035
2680908.28527159574483603019135
4008203.15269212823191970130866
5993152.94809773027535282096695
8961877.24245160965232174450889
13402339.3421062433539064402826
20044725.1858773879621524327227
29981770.6810092114290862862800
44848905.4209661641105548350891
67093968.1955880626827163846886
100381060.747192760793960650786
-19250557.3570396171864938303168+13986348.6076957621082427024391*%i
-12855455.1069145834737630487884+9340034.85203714838505729162705*%i
-8585121.74608450070503774277881+6237456.05663403110193535331504*%i
-5733488.17440562564268692790421+4165622.99252150472774538187909*%i
-3829157.31727756461200092235469+2782045.63742506754634020588966*%i
-2557392.63116554673276080939026+1858054.50734929779980776487276*%i
-1708044.91679478794491861647132+1240967.27179479152462836523538*%i
-1140791.39628477941262474903821+828833.464983509094876753183859*%i
-761930.263662469158614468239901+553574.739925121502425586130997*%i
-508888.590371615723886557055987+369729.202921678241143576303772*%i
-339879.203841684157303990966929+246936.695975586573055228617174*%i
-226994.883366033899302707329304+164921.436405040312201666513089*%i
-151597.331872431549419138129659+110141.908737464087420162859725*%i
-101238.231337700901748400565324+73553.8805268847614706228481351*%i
-67603.2285415538249010879789988+49116.6205659046821860822418461*%i
-45138.9367144930245102306728541+32795.3571920217609551980471521*%i
-30136.0123674207003636486632095+21895.0946094266562053819364714*%i
-20116.7849115699829580456329726+14615.6997649921556557499661231*%i
-13426.2665317752277449402164625+9754.75362766974297646357527558*%i
-8958.98542506068205754437359317+6509.08391908677059409543072598*%i
-5976.52984409494283130145972474+4342.20310162822513121428479658*%i
-3985.67664831864507757340518636+2895.76358788136210192280055392*%i
-2656.98501161743207693382345717+1930.41260721288226351703705367*%i
-1770.41831153333736960821556530+1286.28419568841349934739844650*%i
-1179.01975414913257999446360354+856.607992747769864046834581385*%i
-784.647530925640573359246676819+570.079800711879488069248615700*%i
-521.765710466803657766795539933+379.084978309064716031514145686*%i
-346.616454531795238983351500943+251.831595123785740571564545156*%i
-229.987078012997498368591471815+167.095393068129353805051814837*%i
-152.378567261825135201709815913+110.709509472241355735397390551*%i
-100.778344604420591847991088376+73.2197532570911579826539638217*%i
-66.5047106831952866373277597209+48.3185006240338348366523687091*%i
-43.7671837414481107087523562736+31.7987203191868396131646398170*%i
-28.7050558113135260499863017589+20.8554438156867047457783588080*%i
-18.7453834258482563999699483501+13.6193182626455846108390916424*%i
-12.1743391976239334119436972568+8.84517517743644941770840942466*%i
-7.85106378247755137726439675767+5.70413172805257093798345034080*%i
-5.01668269984360253843209890090+3.64483333094513005642729795354*%i
-3.16686871782580092444617506697+2.30086480411025328911404826399*%i
-1.96682975296575806327366281424+1.42898546087590131060868943619*%i
-1.19461591079368921850217580876+.867939263823473650843589248295*%i
-.703324080915397449245169487613+.510994855755319857044658605969*%i
-.395907035222467687335100719372+.287643298225639128395797847569*%i
-.208382186590450912205810136751+.151398520636711019538874623424*%i
-.986271648582881471267373860762e-1+.716568296861421611428943884407e-1*%i
-.388736976251563437570778150585e-1+.282433945454970838458076738749e-1*%i
-.106166945432812054164403105371e-1+.771348009253624728618139108149e-2*%i
-.102531690213598147529944449670e-2+.744936334084501187744272414428e-3*%i
.361133067033778725933595096566e-4
.446481667118015263932905429262e-2
.247970813941440867286637049634e-1
.745363956673567712844123082557e-1
.172155259178401966782939231294
.344920569858075606585824842430
.634023918115614602555195511438
1.10202505749253646322359221376
1.84390488618757008229838975070
3.00360246126173056699514523832
4.79881447768656070372500624123
7.55820426021441798954257717551
11.7772237763815756466390295104
18.2018349085955813308128033658
27.9540334645421586911482320647
42.7199926415606458819567619044
65.0319920375477396323797088249
98.6907905724747710065808219763
149.398291651086215675971840320
225.705060766834939603949233156
340.429213974423453731452346196
512.780969425110780362483762073
771.543571486980356852159414633
1159.83556208714515330213325068
1742.24023774325162139980800723
2615.47863861173947899991524017
3924.38701727186521926507527856
5885.83493127426865899145674541
8824.53039488263294834582188912
13226.6202955584548332954280985
19819.9315721094144658293979168
29694.0967541445398824672257294
44480.3931898574100728046140662
66620.9872364625432699762199562
99772.0433977907003196509332382
149407.276286370685021004333758
223721.649095042978128412628031
334984.537028359772352409853760
501565.989279494979305911044650
750971.041180424097650388657368
1124383.78198939548855765877052
1683472.69278919789453110558202
2520583.01940474743116533560711
3774002.65539822468965491846204
5650828.12051380158089674116393
8461216.01751251567776838204015
12669691.5906361385774553766753
18972012.5775692284346169060462
28410322.4231260597924986940517
42545675.0857274928093503957023
63716527.8987762501287338053354
95426058.9639291473587699783619
-18081809.7486912772507703601323-13137203.7657261397841698597809*%i
-12058509.6742437964821340986402-8761020.10270218867888021787400*%i
-8041442.76817366699254150972375-5842450.15759932321690637098949*%i
-5362406.63692671893471570432326-3896016.47418546377567947255742*%i
-3575751.81836767477375761195144-2597935.76563661646109646032497*%i
-2384255.61774439097843366335057-1732263.10392699320160394053748*%i
-1589686.64303116468934030396063-1154974.95236421810488047676080*%i
-1059835.20792847142217996669243-770015.351237438925864091092302*%i
-706524.820941998603867305663112-513320.329505734605973607969700*%i
-470947.109761899443370522894120-342163.103683228593386445945797*%i
-313880.936615373302455509791402-228047.849181223762715691941427*%i
-209168.964930146833889658357861-151970.148560613555059251861378*%i
-139366.776703218474661091336097-101255.890265914985704098191575*%i
-92840.9875250491878999943485270-67452.9257789634102417531465405*%i
-61833.7911212030503709096764556-44924.8789173543025164769490444*%i
-41172.0830743612100113364368897-29913.2693200931243462156121410*%i
-27406.5015764419453510908401629-19911.9889391310393483646216483*%i
-18237.2118628215585653085249686-13250.1100105837319847873479539*%i
-12130.9410113677285348245731598-8813.64454948301881787576191803*%i
-8065.57084961365144060823469175-5859.98023488464874597693034630*%i
-5359.80728222442367384215969843-3894.12793244887555459802710752*%i
-3559.59145682717650241483337252-2586.19457570950223880119992107*%i
-2362.35415064265832537207738725-1716.35075665187411540235322422*%i
-1566.50847508232511070563758824-1138.13502762813536723915177241*%i
-1037.77385991360824239806799722-753.986843679514181281824062077*%i
-686.724218459564981003289047035-498.934349722118057255216914748*%i
-453.820718831860187262729930199-329.720052321309788487073508038*%i
-299.435185840818421109525868472-217.552396894543259126264000163*%i
-197.200933503222409076110759459-143.274864752448276939397958546*%i
-129.581916080853684150859306598-94.1467728931619619473042595120*%i
-84.9206253188023273535385520507-61.6984457989186986302292339645*%i
-55.4716107920431480919570335712-40.3024843373804880757027253183*%i
-36.0918519393298281023924876330-26.2222653483958802353205086262*%i
-23.3688069358972336697771180267-16.9784320676759876061431217422*%i
-15.0400423588865686504091170334-10.9272303967331588034627657098*%i
-9.60707264609641792371034323826-6.97994684702604323028220670275*%i
-6.07852265327455442853125968766-4.41630521504794851893591147081*%i
-3.79938113410385307152889635787-2.76041197402768847386248902386*%i
-2.33754638509865559461204319736-1.69832685995937008455665173207*%i
-1.40848420995253619071073687044-1.02332367855454912714559107302*%i
-.825227605555286447006880632294-.599562950719948610003688227896*%i
-.465217274525298236844340270541-.338000134705374157676159880432*%i
-.248325745239119787269483627529-.180419214714845300722726520568*%i
-.122301276884704862741226080148-.888570788860970787001521949661e-1*%i
-.531281467476021044648916035145e-1-.385998580462426248485939410703e-1*%i
-.186393487613444953992219190860e-1-.135422795694408217881104398078e-1*%i
-.427910155390160752513145074248e-2-.310894926056334196973840876741e-2*%i
-.297927614303727857195090900766e-3-.216457082058836553135935247091e-3*%i
.632139629198693977116634304165e-5
.154947693721104595831059466272e-2
.108959916009712780579271831897e-1
.377978663376291780239472463927e-1
.965755797017138630331324972978e-1
.208835704599721289734354677177
.407631102592454776448614838680
.743731782060518079195058628767
1.29508246372801134840004063504
2.18108089016201024103701772520
3.58413797163912338559737961927
5.78222096751800784581908961083
9.19794362452902564135131048416
14.4725651916344783236150248045
22.5774620024993899560087398275
34.9819434411290379655782551243
53.9057523167530148885866796999
82.6987982959219724656784578110
126.411991990987306892261960125
192.655030382934506081564294832
292.884960258162289879182744419
444.341305253254618930537941747
672.951463688632322271064437348
1017.69192993619866406688273490
1537.13359049860723167908933404
2319.26327040481562930351426168
3496.21938472330789085288751115
5266.39773027609232806793881052
7927.61018305583022362312170804
11926.8183158852641485342709309
17934.7215153939938154282254327
26957.6135230547069396030197477
40505.1198136431672827668103847
60841.7214081467836016894601125
91363.9037136418018449946944948
137165.658439465091458674603162
205886.386060388926283812082758
308982.203840980827016765140344
463632.069364711640094564977908
695595.691537432735676773955881
1043498.47887441373421147432839
1565256.09849967053908647226994
2347707.07250014187375181469252
3521055.43168470782365251760394
5280525.57603669259561122349099
7918831.32298043234129021831474
11874860.3747384473602927182552
17806673.6350607099317316940460
26700965.1975920317273526832588
40037197.2213993928656707086626
60033724.9588462751765567991295
90016876.8483807615375155086389
6433936.20512622039746130723016-19801619.5377527927361688150054*%i
4284101.10801215382922503775363-13185107.4517232679322516900672*%i
2852343.05460101865531015156946-8778609.26152173004449449574999*%i
1898880.93302820650708315044339-5844154.58663689606807512726317*%i
1263984.94990045899109926597806-3890145.67154593008891753413820*%i
841255.401839034075674385765315-2589117.90079974757028799704836*%i
559820.083057127925409602857767-1722949.05340500562091904304398*%i
372473.798993085201667081888535-1146356.47919014280265092353663*%i
247776.811036345397167638754077-762578.612220343866720703679381*%i
164790.886479458232983688163443-507174.198394344655901106998195*%i
109572.602524901143207726167358-337229.794916335852423869134155*%i
72837.3639503164741033035546146-224170.355921131294154167770658*%i
48403.3523487700018377773969571-148970.200667902569050517848316*%i
32155.0526555304748303574502962-98963.0761949295567748925659321*%i
21352.9020043943784336179181057-65717.4749698410488915138064565*%i
14173.5031968572495742776651158-43621.5574530683818154447525926*%i
9403.41892905389244969829802069-28940.7476311113169413156249261*%i
6235.26218968578171061098110665-19190.1637911672524883834285851*%i
4131.91963937531187997496118206-12716.7410510365073131869893953*%i
2736.15113256353717314907902208-8421.00729591422276021675302922*%i
1810.40727993904640151353191431-5571.86068105063350926463150045*%i
1196.76893814428386770254175834-3683.27605872937161878301814447*%i
790.284483791073568891391592657-2432.24554544883051531576253942*%i
521.226815822014769797823616833-1604.17119018969275216129281990*%i
343.288083035150359272201231495-1056.53208166573365766543157659*%i
225.726551928424610754368246279-694.714892773447373140268101268*%i
148.143631898563862214450223270-455.939217031560728239893768602*%i
97.0109920197742622206696558695-298.569133064299131731060806232*%i
63.3619678717004977541284690089-195.008085401759950595651607764*%i
41.2573832530453506882753598430-126.977169224827677723939415341*%i
26.7663489994242812085976600095-82.3783516658154264902924789805*%i
17.2894290698916190333310727732-53.2113912155646895461550974151*%i
11.1093549196755064433021894581-34.1910787449222158127227020679*%i
7.09292782273456387926590424243-21.8297871904024813072112442890*%i
4.49333800101650083681895315698-13.8290723926924466644009451275*%i
2.81915250970158846949978486103-8.67645926789487768501829198461*%i
1.74754600982833861343092620737-5.37839358490498133098831947370*%i
1.06687727891803144341500415792-3.28351063751235641910202330317*%i
.638719259325349406960579986658-1.96577574930239932005923351564*%i
.372776680623031705958660726523-1.14728865299634196613603973454*%i
.210335171805592155141490338250-.647345095554999494954451393778*%i
.113353473642299866535483638539-.348866119710535308002530021158*%i
.572848025415611198978843335854e-1-.176304493712497773549977550299*%i
.263602156113357385562953205949e-1-.811284016233981106128193363967e-1*%i
.104962109337657020658186432500e-1-.323040155935695953434548548958e-1*%i
.327429400848214366252652066939e-2-.100772407657770630746287680394e-1*%i
.631370823574636580712354309791e-3-.194315958956844038033144628411e-2*%i
.316761358154066003843475419920e-4-.974891217204043155459729549465e-4*%i
.105988410034973328261682462110e-5
.515204661595815498961234049234e-3
.458998172214613394245299508098e-2
.183926749696674857161862551562e-1
.520484605364904732700805127431e-1
.121643078477059839065081228688
.252517613468560877964556594677
.484403049672498589653865553478
.879306587460446387729365608326
1.53356033295893447272195103623
2.59617948132974525817138114860
4.29678188208655474054659821208
6.98798408103008820052982393905
11.2096946624972486651345445942
17.7865004285151260250832458231
27.9750255662779673858464815467
43.6867018699729719228387647996
67.8242673269860704926509019083
104.789687103359029806707016414
161.250335083581354364242248435
247.294098360289165520838257126
378.169951363365079920439442366
576.909575566698038356426149054
878.274423061434529217640483165
1334.69623885652347424348291559
2025.21500951785905600561395035
3068.92296393668226936604979196
4645.18124850989695109274689075
7024.01429440429267439103408867
10611.7964370366740880881061808
16019.9123830101833903395141347
24167.9274843172603319499517123
36438.5906850503832536979749852
54910.6809258026399043954493043
82708.7503853189630960761943111
124528.397077285981236537597587
187425.089820937333009468189532
281998.685649773680915423834763
424172.000440420095704595221608
637861.190067800665087541426201
958984.889500757673402476356078
1441482.98189674682230447754336
2166351.96175710160511664468175
3255208.29693843658410603841266
4890648.30427482636291098778386
7346809.38668086722798511509346
11035242.9776477548296811583585
16573769.2829906564240528733623
24889825.7770501776151910609068
37375587.6076147475489733705724
56120792.4952624966999405564264
84262192.1447719493141801759026
19236679.3157072567925169872577
12787005.5443910440711416287063
8498337.93359040040455176711549
5647005.34808005848017391800854
3751572.49729901216831930401046
2491784.22569489467421699499892
1654624.58866331462476619663269
1098422.32706077559740372368766
728966.672566524675077932675539
483615.924180329029170434795859
320724.847386431125280177912877
212611.288118088902034621629115
140877.667612164793324542095196
93299.2235802445126860069157050
61754.5519417251441806976737480
40849.4919269042510231912784668
27002.1812395567580036255909454
17834.8206068379397273600128776
11769.3968055171407822120213859
7759.01835083532871875778140463
5109.40769921282214501162779725
3360.32098638579923404759692003
2206.79513541792218653253536194
1446.85896783958596155517344359
946.825178535578101194578510116
618.259191649456288358264434773
402.701658776989041675029002490
261.538099156612241190839640992
169.284368263232374589975142793
109.138242295644811364379714766
70.0338313890423962843860705376
44.6922271981818955974894393231
28.3322654248545878907289052832
17.8184707270084429788650004816
11.0983807183119348705075216120
6.83129835372144479406595898806
4.14359076182645558736448269244
2.46757987468271744795018728498
1.43560376894285059340215679682
.810456197666676917841644468400
.439787599334930958787201852509
.226270520751049941361568172324
.108123499780367965204783597943
.464326822784966644396049698025e-1
.169299067436584816753394882698e-1
.469199655735873676739499484569e-2
.759462663383059003060837466947e-3
.274467754255039344218764487869e-4
.170928584725171494275937317312e-6
.164805549854823537024488915730e-3
.186103588395819479643555934831e-2
.862045149528888409541013576692e-2
.270430100577950390853155509845e-1
.683832106057640732983695992112e-1
.151155380530486940997417844281
.305260265225931355373272629124
.578418340131568456067736077698
1.04611915513270264659618649774
1.82693525696153260018528046063
3.10601585907748864211808206843
5.17103811318122938334173528160
8.46710682889918588690191351532
13.6804401444518124292825927356
21.8657369541923458894535655044
34.6397630689219002149648250147
54.4752299889726413644814556450
85.1464506508534509374230547280
132.404519399906689912923156109
204.999364055322299707277280696
316.225708375207659316069180911
486.259925856692627641526276340
745.690252692586059428943926707
1140.84686595871777172258734190
1741.84553164365474183123643905
2654.72093952001957922985051718
4039.72174882236788430838169243
6138.88647829952430091200889905
9317.59466030043166702547834443
14127.1571938947171119454115033
21399.0735085411455215709053308
32386.9421162703589189850048996
48980.0688601180186056507284624
74024.9314495375067066983120844
111808.870140695696369825672211
168787.748767711419554222302962
254680.474850804871293712049123
384115.104440746584067436136134
579104.187052591031915826199017
872766.653917117770655222570646
1314923.39354563608862579419840
1980508.95815175133235444751949
2982215.58097596735734631576003
4489497.44242626488496380539442
6757132.45205638699405937451137
10168145.2952145461544757186241
15298308.8806366334293163379648
23013066.8133587496266714250105
34613165.7401136290445465904538
52053467.5763944556225250855460
78271700.9019747560716698995342
5447399.80646097724648990482217+16765372.7047566112556965997241*%i
3614176.65431722503132328541962+11123291.9894352602105871874208*%i
2397287.51663176703397950468940+7378092.32381333588592704041074*%i
1589687.60194908012748425603270+4892555.36177029118191753799988*%i
1053837.54257741940341837260606+3243378.45564774886093809311105*%i
698383.459333363733316455297353+2149403.27542579663440789503154*%i
462657.440843472846662783764847+1423913.18903559006481285652798*%i
306376.883717399556824423415060+942931.091188097567829980472474*%i
202799.639564328018267468224440+624153.112032207521163299223342*%i
134176.107063752103663084173016+412951.595792374078199549710377*%i
88727.8648818007488818513138857+273076.289035428475971277521129*%i
58640.7284586889010398269286597+180477.604585271202526483220844*%i
38731.8379080033998818998271546+119204.339894002470737729403325*%i
25564.5476834727337256009418745+78679.5875407557935423657306231*%i
16860.7790162483436099436785522+51892.1420022574915244260878494*%i
11110.9398874072015084285579106+34195.9567740170077187542127545*%i
7315.04367961720378528659829703+22513.3895064757568467538599004*%i
4810.93793906483290224756221098+14806.5444934316786422788657483*%i
3160.35960551404468452761945111+9726.58672944425352206505059615*%i
2073.36953671657173962577411065+6381.17528963327494422086173580*%i
1358.25369862139376094061169511+4180.27504755446175627851549952*%i
888.318797159200174929533846340+2733.96413778019363823744405876*%i
579.892689505764687394603091158+1784.72618382017281195184365232*%i
377.753972136557300477111407091+1162.60718114724178848694242877*%i
245.485876523147759894289824511+755.527840784328895188716511806*%i
159.093072992236648167186912476+489.638131626827663239465456549*%i
102.779732247031883043775804892+316.323489891970541349493999651*%i
66.1585738782107367731401104631+203.615153667961942764688198266*%i
42.4069718145293825865053284750+130.515239015032064292460611522*%i
27.0495434669063736537383917750+83.2499346162041750450295029942*%i
17.1549451443173218869748269760+52.7974922518099731829204948939*%i
10.8063672023849127201240538660+33.2585784354506456375496370254*%i
6.75277064189274815908264653349+20.7828910348736795606641875517*%i
4.17939573802252027260404416834+12.8628574582523289020184362898*%i
2.55691820693339143524933107364+7.86938507138256669170267092915*%i
1.54242107371463962160268946527+4.74708394596372434065911849570*%i
.914472219294938567251108603264+2.81445609452815054384254720727*%i
.530627058300693020601142266997+1.63310216171177630265799780009*%i
.299658887669024556015339910279+.922255225347205420571571004452*%i
.163448970189364124688186210275+.503044204720054727223542012183*%i
.852031141350663453723780434421e-1+.262228221689557821217079236405*%i
.418049903011793693010537618694e-1+.128662530421710883376596040740*%i
.188695367481467543001411884007e-1+.580744626038947314895663471844e-1*%i
.755532850373864257004396517011e-2+.232529101539073602163681804440e-1*%i
.252046035539188725778685859073e-2+.775717934189249984997664181271e-2*%i
.620178386147461551062897563342e-3+.190871280915795964241965888179e-2*%i
.842250684635933365705100733240e-4+.259218106627859825655919300551e-3*%i
.219202125554636860936566403948e-5+.674634773133328779271918975942e-5*%i
.266056745259516333855947773815e-7
.508902303473047745521369739560e-4
.728663374969767678637835891509e-3
.390377817218048757792221546722e-2
.135858717653451721734044503112e-1
.372026465719500695597450006890e-1
.876482167620878355652624109057e-1
.186544109616993312115731066580
.369380908618201063862820140117
.693563466611311093176377665987
1.25092786289530740335737148438
2.18713052571422000710502937016
3.73157728743146326692300336410
6.24348744594695728009923657659
10.2826157666020238168414442096
16.7175991292186088503740441179
26.8916334830407063580592449848
42.8753986653202222139087564948
67.8526126226909771795274988784
106.706999210897153163132964782
166.914850277775611132871333983
259.900872237556222677044926221
403.095860169751010034839953938
623.056858111928841313864628588
960.194827802992965705425294038
1475.93308922607878630107425956
2263.53957722418121443218423414
3464.50908609723778179305477479
5293.32630989896474052088854969
8074.87952265472387621921029522
12300.9634574257502841714095764
18715.5776091876298934336298653
28443.6486775298149199923359853
43185.2198381999512127070811245
65508.3141041884982206641306104
99290.4888861906795164532531572
150384.404743971180341098593161
227620.822097883030177229477888
344319.767213838786008485544316
520566.878027918277108961037178
786641.748448690473179289836848
1188180.39047275398141735654722
1793947.74274361672483337522346
2707538.12121822948550836700402
4084986.29011299231633490735752
6161271.68670440280622955388645
9290202.04701332605029167059890
14004424.0171945668177533956962
21105708.8160759191899461360527
31800774.2000695011800396529139
47905592.1168373881960580778028
72152690.7001499174949286370751
-12962812.4467308932721155042446+9418034.52510722069203225093616*%i
-8582769.18576484266002127889679+6235746.82151210164600611795499*%i
-5680773.74496016860265128918189+4127323.71768984213572118998351*%i
-3758609.08395374818478961748038+2730789.34563966991567720071073*%i
-2485838.77991938054713863046565+1806067.59137638867696579784523*%i
-1643349.93389768929667582545920+1193963.61537146988644734457641*%i
-1085880.56961363450261750741014+788938.414158991276629549592507*%i
-717151.457709419020319602752059+521041.033046930951568835400679*%i
-473365.350090621900035271309146+343920.058124983121972492804847*%i
-312260.127048200081874181601030+226870.262100874456245484231897*%i
-205847.837985054062617722066422+149557.208594099131642216490303*%i
-135599.523785563842565042395360+98518.8208074866176570939446523*%i
-89252.6663672328109620157533351+64845.8578536683762011499360201*%i
-58694.9562701818971343671211315+42644.3819097020635270429001183*%i
-38561.8617754598629500211334332+28016.8325389359029311368934119*%i
-25307.4833030458287133609213017+18386.9628964483770235492899898*%i
-16589.1481255608559847850577898+12052.7216166003782552337934141*%i
-10859.9326195594949921682924664+7890.20289938263659761920726261*%i
-7098.94984023212829528802877445+5157.68896310550325855002132197*%i
-4632.88968301841239500813295113+3365.99138227015240497269035883*%i
-3017.98425095775961730386516098+2192.69390717121616277596299873*%i
-1961.97213451915594942306657044+1425.45619448962153666331747851*%i
-1272.53084925121075392378670469+924.547780179783460897871062095*%i
-823.217090103511882649974501557+598.102225741022477785794917173*%i
-530.982998352223700228422881703+385.781729950690980852071622489*%i
-341.342918825425706555347986569+248.000147160153483955957377080*%i
-218.593814128674416782304558804+158.817702323381084552939872513*%i
-139.372167022728510542001166627+101.259806562278563791272960198*%i
-88.4123883898899676475804355677+64.2353601677824754624151927725*%i
-55.7569125020865605846160268199+40.5097681630396814477792959917*%i
-34.9228770617899738022445593600+25.3729553856933173304062036598*%i
-21.6986601537697106942852480278+15.7649994024490383788235098403*%i
-13.3547943558818306270739316041+9.70282605231411042176142547680*%i
-8.12724412711776841825324003001+5.90478849383286604872635103930*%i
-4.87952077480876964005138875573+3.54517935918424076495089539381*%i
-2.88209247614506496539223893120+2.09396275356366576358510672563*%i
-1.66862913423123984086943625644+1.21233002948776166095006309615*%i
-.942508523944672407153381788342+.684772525653363503477435475223*%i
-.516149874298404444379264580815+.375004834502412011966819535548*%i
-.271751157556948974899549058353+.197438772999808839138150731220*%i
-.135954694131593196532607435239+.987768671685633232785939955420e-1*%i
-.635567450451443707888011840412e-1+.461766782168913857359392575245e-1*%i
-.270750658542001869927490109667e-1+.196711867916222296144411994957e-1*%i
-.100999747918546763657077707712e-1+.733806121806451518776939981959e-2*%i
-.308076855422604995886892596587e-2+.223830937358681506926047343752e-2*%i
-.672669345905113134506779579866e-3+.488722887085613448479335239555e-3*%i
-.766193113070323859314605523348e-4+.556671881310410412378212309943e-4*%i
-.143570690461416560349027839526e-5+.104310212395312740306544280646e-5*%i
.400855322274012358043804624335e-8
.152126264474765656399231034466e-4
.276268850568382223228092105551e-3
.171263975429810913042420455250e-2
.661605485878566508345727157756e-2
.196328018465047915540661475597e-1
.493393773199723321903196259632e-1
.110765119662834157121702143310
.229413344117157630462200142117
.447629203234676646039484375260
.834621883243516305101702162125
1.50215509348166047129163294268
2.62900224272800991735889365998
4.49891800330041421557030267004
7.55940534904664159618372471641
12.5124110035291303917457429713
20.4539519861250486179841380791
33.0886069149309529202183550857
53.0583818197125307978171822200
84.4460800578526580759826318408
133.544600040058511069753336965
210.031045377557559016843914457
328.756465586164183517512157114
512.471006694943455679479882887
795.969211150888090814877691349
1232.38982145509245358385734594
1902.78198373013098938429526981
2930.62053823825057641024081819
4503.81570629659175906578253230
6908.06567704442539729397294033
10577.3687267455913989598353510
16170.4829297154001307206319031
24686.6064212648623690813241835
37640.3186415127764645294626524
57326.0322235444252778302088953
87217.6030794742169244668695086
132571.964901603496180682333113
201340.659091343064517158617559
305545.895168351948235787891400
463357.296297381701266643921033
702225.307721070756273600524930
1063607.77304675171851708754372
1610098.13005731519897975094920
2436173.28581997492672490004715
3684396.11041212814101614942674
5569836.41805368502939753462287
8416872.98595653913902132768525
12714644.9345391391561933235981
19200590.8262006737066352507025
28986285.5946490034967078087720
43746967.6054213819868576384762
66006957.5626960401618243109889
-11687188.3647660539440284018430-8491239.37981196864434110311495*%i
-7721011.15431580911176092836024-5609642.96281419752222013255163*%i
-5098571.74485870646071454702958-3704329.20472634845613151805998*%i
-3365256.22933189159916601583677-2445001.76824458102813449681920*%i
-2220069.43695968250340104201853-1612974.86107612589902991565361*%i
-1463779.77245001404555635477492-1063498.25631894511463021798468*%i
-964552.346901387773304643576423-700788.300511238094596989666847*%i
-635177.052277640472809174217237-461483.141292790178690572051459*%i
-417982.863171660318933329283416-303682.326071656944510831086425*%i
-274846.340049585805599928889227-199687.554712647136421281376531*%i
-180575.739779264965220014448834-131195.954475665375749227510895*%i
-118531.450464221859036220117492-86118.1396684179565979978713345*%i
-77727.6423916076082155924676193-56472.4377990952466787751736937*%i
-50914.7541809846471996209562115-36991.7342154241032931607278824*%i
-33311.3011579988527863739822233-24202.0769544803920090495585133*%i
-21765.4210997153415785886537990-15813.5040688884062898736697395*%i
-14200.7455726357012013833932602-10317.4455879036785505511823692*%i
-9250.32820504504117167900199989-6720.75683897271652073860840646*%i
-6014.91359558522283509043065154-4370.09052947030270350695265546*%i
-3903.38808783671687820235545086-2835.97744912289995005402423699*%i
-2527.52630453382826844950840615-1836.35535089605523179356509408*%i
-1632.59431559905038434237019693-1186.14920126251605247899141368*%i
-1051.62138700381857836993442984-764.047661018258317843218239324*%i
-675.287305685220890564623117194-490.624946202469296261668276317*%i
-432.106670568863471939209886608-313.943872803081739545160334172*%i
-275.399070742428463263775666610-200.089137067531195552786440147*%i
-174.728451644697842144726467148-126.947650972401227319933315335*%i
-110.283863926045139489048058531-80.1259172950280598971043152889*%i
-69.1946244300344915074916317153-50.2728373577787630731965924738*%i
-43.1166123493513094112507194391-31.3260525353248627387642345915*%i
-26.6531050910126923278086274533-19.3646143520169158190850880599*%i
-16.3229806060305365450295180373-11.8593395940879037031249783981*%i
-9.88754767221764343965944449307-7.18372388154652804570953499600*%i
-5.91206829081480904180980066687-4.29536904174892446458701564164*%i
-3.48066717500606443961088290937-2.52885272847418393285109834012*%i
-2.01134617966559049154608010193-1.46132853806816290770612187650*%i
-1.13622621611809758758076963417-.825516667444408146927680847293*%i
-.624215571517003014381873249875-.453519159350274513505702770840*%i
-.331219396728919206060973148399-.240644977823839520071521424620*%i
-.168187941293722078013043751249-.122195692047558065451279129727*%i
-.806902600957268951758939386745e-1-.586249055553595116959337133091e-1*%i
-.359132623472082811789416815535e-1-.260925124146604452518604559315e-1*%i
-.144289191873581210740382410232e-1-.104832234227682267158201566213e-1*%i
-.501154684860884252398107553205e-2-.364110191660556806134228926246e-2*%i
-.139698281657140306117990859704e-2-.101496742713183653805415651402e-2*%i
-.270554125379951614438966145682e-3-.196569078215829416266877492478e-3*%i
-.258386427588570953742042597391e-4-.187728728302474464794354301279e-4*%i
-.348534050467902072477916332641e-6-.253224810122897605869787831736e-6*%i
.586027331740869341110131127384e-9
.441299983149835415479024130579e-5
.101671295475930984326645236383e-3
.729566552471181441283334460079e-3
.312993393385675575195966057551e-2
.100708305349161634263175070488e-1
.270150216997815883721919513244e-1
.640178472998988401190484432843e-1
.138795865491543508630422776289
.281653982070243319068432528624
.543341026502856670402434130935
1.00749484988506050926352039163
1.81024944670412533985695878656
3.17097861698948065397429703041
5.44030314428960094514881631603
9.17478749315577216024573595655
15.2528008797121330284680774857
25.0537341018292672289092353279
40.7345431490328250943388627826
65.6555532278171263302359299844
105.034820731016710622968116418
166.951998673016255030399041985
263.885987227160046605939016803
415.066896325300783020124322727
650.068999503505588455848170700
1014.29315372546902975601683440
1577.32355025540710679222098430
2445.65357589139605820390916711
3782.04812259848511521380921581
5834.97962144639982148370172596
8983.34602458881380032997202150
13804.3585831217363868988268391
21176.5402949857969160587614272
32435.9041077748863001326540111
49612.6428620020490762313364697
75789.6597644926103070422876719
115645.412226094128962416598078
176275.474374764110893867771883
268435.437198089736498145484472
408420.544416429729154257420016
620907.299528260805307228051961
943248.010937540603261254958139
1431959.26356009916444378450198
2172522.41886734529845766386622
3294182.95961604266749404112585
4992293.02229802717090536177095
7562034.27687096242185831450604
11449307.1056269468238617717466
17327509.2581133659773411482322
26213353.6055935230748215505664
39641544.5698449708923765493334
59928182.2544436083082317086800
3992464.76221080464006504983940-12287543.0714085061984708440832*%i
2631299.47247188995665039686104-8098307.06780466460059067943988*%i
1733266.16772009082953693929742-5334444.74993496516366342527188*%i
1141059.23850085937376833189822-3511819.23327582596908046505069*%i
750722.661189450808746553115382-2310486.77532716829291067680835*%i
493580.291114543328520891943413-1519083.93623739900892138997334*%i
324279.473092986073524100302761-998029.595782148789698641873774*%i
212881.779524942770180706985671-655182.748208488300859301041823*%i
139632.410057698147402956482662-429744.369690681863349180136004*%i
91502.0805087002422526313580566-281614.446798911371800245707876*%i
59901.4783978412778695858897035-184357.793917495175146479367772*%i
39171.2016846448393925595863912-120556.562556202974268490825766*%i
25584.4177739849397975436939934-78740.7413912073923685070201879*%i
16688.4083629529367803941898268-51361.6396803180745839109773554*%i
10870.0287588278307927113246685-33454.5085596659677741707933668*%i
7069.06335785730090518949440100-21756.3399197262319976063604119*%i
4589.22994695143577115310252584-14124.1974560440953747715163879*%i
2973.63074579537991407464266770-9151.89439197261163839627344430*%i
1922.71883995263132718470127015-5917.52012033891431439451625113*%i
1240.29886742805586445214962656-3817.24740546043966266152896597*%i
798.003982895768296466786890048-2456.00372075858858626949263523*%i
511.943262671269709497296577094-1575.59935149115322651267826374*%i
327.361213876875106036800943392-1007.51421865856562545605456632*%i
208.568558858626164395367512270-641.908019971561606206234307508*%i
132.338728070383774283106269661-407.296724712932731769199324709*%i
83.5812939495460442761132542457-257.236772404323475247952429827*%i
52.5101550046722003457253415533-161.609639592400372419666767573*%i
32.7921427279716061599289290428-100.923837822579416272508688510*%i
20.3380998352499945854932204117-62.5942350403756418130534512282*%i
12.5145432744366020638406770407-38.5158038110008194125608349570*%i
7.63035240403186886066106057192-23.4838099767345004374164746613*%i
4.60308152279025156404663795781-14.1668282229671532419322648751*%i
2.74243282374356307766356023098-8.44034035344460747752770114745*%i
1.61003594426405588798529199927-4.95518111992189866479299579108*%i
.928845985346623258530914771842-2.85869399767262906071764118615*%i
.524748535918738445801356507910-1.61500993015391845086533894966*%i
.289028702161873896864637494559-.889538878414728864944674234645*%i
.154326253210886331616039368373-.474967368861084452974139030078*%i
.792864456339296558387957537167e-1-.244018588448686049766188148686*%i
.388021486397739496548977317113e-1-.119420734075659436830504137194*%i
.178398586959492921418049575846e-1-.549054394140559209494748877827e-1*%i
.755465093391139601200113226345e-2-.232508248084047568042221347431e-1*%i
.286094857523023277668057794443e-2-.880509433069108437385533548556e-2*%i
.924718122421999938438076831895e-3-.284598974190579977451874855903e-2*%i
.235460080361214330648049442168e-3-.724671612989671539016753174482e-3*%i
.404341451025233197016397322946e-4-.124443502721791419713562418452e-3*%i
.323693209819575725948556031453e-5-.996225262957123288486474246183e-5*%i
.314264023171266261039332918039e-7-.967205210440668542410492483007e-7*%i
.833066395981182386309404302439e-10
.124488839876379563640661324317e-5
.363927468462240930228725904854e-4
.302372690720924115690052262191e-3
.144118734491022849915763167823e-2
.503042812265463321238514719973e-2
.144116177922975911229040945746e-1
.360711429995944876288060379096e-1
.819181973504043235600100452448e-1
.173005229906843108083272097450
.345549638304557633603018308282
.660602780891913152828995958266
1.21946869013637622019237888003
2.18814566834196927672288373695
3.83587224356523000001512086967
6.59564613336504035020479280768
11.1588728779373160454405977026
18.6228869069943962548336917754
30.7201884684701782784178682305
50.1737095113989121208328208385
81.2460848693969779515969561371
130.587060849645218442290274909
208.538359660906306666071681566
331.139471897843914240272485435
523.206063798192607780687805516
823.047873419109652807817364504
1289.68989345349282672081521437
2013.91201597852599015021119440
3135.10805489676990224098123777
4867.00623775629358290140641764
7536.87323729523617898260715797
11645.2202042696997040452715815
17956.6622080256441595048099895
27638.0876319186624654076202804
42468.6327891249167962178172962
65158.5829497887245304317382833
99833.4314218631558771591533768
152768.243943758093773371895842
233501.213444161208756211293099
356521.428493873657154111234619
543825.862213345882392723238827
828791.697257633819389034827582
1262038.42312953327191085826838
1920299.04750856401404658967432
2919840.67057089410234677179224
4436761.23112414065218656457641
6737676.69377818308107007968386
10226105.3146557395599844899542
15512560.5812429176857883262548
23520445.9533834029478171673056
35646002.2379929630294042472670
53999847.0564681882471316027911
11462548.1831178665091273879135
7535391.49751124822991165857359
4950501.14344132414931031304838
3250052.27477155379742268209066
2132094.95165794312408260447663
1397567.32937631526786618245756
915295.819503584360300986290521
598883.781816198641533045981472
391455.741817094275128447424209
255590.705363493849994185668328
166682.123679004556718592483392
108559.900019677635386043825032
70605.1043979839058767857954907
45849.3398514864979431831781982
29723.3599420784637362564013422
19233.5975380874501707589239190
12420.5920272480852588770699126
8003.03264011545403141246219742
5143.95576790750095242555505498
3297.28605436940083019778639399
2107.18933771922662633364288385
1342.11728606911225543553326940
851.624656486189384822357351531
538.123797457709432288826583668
338.428902691962064419521112166
211.710707021066659523070860232
131.644788850518749350734057227
81.3004088780829470405190135213
49.8182750661430936916793189894
30.2546193148830473821149624014
18.1846437436653396264087639824
10.7996556806253318096527829183
6.32464695323541486774326511607
3.64349882842074708095445881649
2.05845062859924102739265406011
1.13620338193266765904204656322
.609790896929628262436925526072
.316252016165720075866055412690
.157216863233476828799458613713
.741088738166268352302292785125e-1
.326334921148798128634166884777e-1
.131413572169045250371505391135e-1
.468853964871437244170085456625e-2
.140964039649492150458521568286e-2
.327751281704231637875063846505e-3
.498902901440128330123742880831e-4
.334719057985700058091954596422e-5
.233870429714974206782815380123e-7
.115363445691893953679943954121e-10
.342123592638257792127887910156e-6
.126927727464858328942106432354e-4
.122138473996126111416379660684e-3
.646964223940429449646436699070e-3
.245071654484958123053734938070e-2
.750187947857114986024203084109e-2
.198423567413143027214295444871e-1
.472282595281242627215511301124e-1
.103867010459990313704703230767
.214926923034542725769728593622
.423890764351007924264307697745
.804442940638108426154799094004
1.47954359878426649933700520017
2.65184115722426609424674321766
4.65189831744840993635683574049
8.01430201059211423832054275487
13.5972799212905998534910425369
22.7700044535871303741182056207
37.7049348282778015116050211556
61.8327837183652306886999157412
100.548744502461542085335889066
162.306197620132668491774528848
260.306948176275713892439762795
415.108413557102746626784636656
658.638298290557407441202470428
1040.36692305475216213534530977
1636.78328176363468576320564603
2565.92414733408458656581131314
4009.62405661574431726602770551
6247.55160213131931626736652412
9709.22270639920243879974460462
15053.4114253183335307299314035
23289.2848023832977787104827205
35961.0363998576592535072010392
55429.0952689830170431015707888
85298.1299601597443890899555032
131068.058261011995191519451333
201123.664326291102587003758262
308238.102266812412416676229335
471855.945502828254541411109416
721558.275890224873134991345418
1102319.40964208484348086895892
1682478.22286054137525080274769
2565821.06185824466450446106308
3909890.08411381893732982765141
5953714.71649410484321302827164
9059802.23005497985647956298447
13777699.3359717564857108229998
20940177.6595965822699585550482
31808747.2188480582189686566343
48293737.5504272183699365986746
3117624.45563562498871111360048+9595061.46220472419224849837547*%i
2043975.39218972401666215018647+6290709.41493364562890580658710*%i
1339049.29698164398368619773697+4121169.97678650242529149598380*%i
876521.344554129283961502624602+2697655.31211696165067651196218*%i
573254.159979027313296378294998+1764294.89078468136947950291066*%i
374560.520324774200572956579854+1152778.74707935445600113959166*%i
244486.764764616960784132442566+752452.890973300437724700378829*%i
159408.940094535804642054176909+490610.270607509028755589335783*%i
103813.987438702283237961265571+319506.600068612568298806420792*%i
67521.6331270305982908529324374+207810.218678249298007633369410*%i
43855.8404291149417533294149176+134974.398097671956972717961122*%i
28441.8564240635277770940172968+87535.0332830425421954372733263*%i
18415.2382332253323342553455031+56676.2755435579048960067037533*%i
11902.0589613032574691925864676+36630.7709236922319079669223399*%i
7677.52629924263669236092606753+23628.9962974091111238165188196*%i
4941.91975462174851693007246509+15209.6650708405233249366467204*%i
3173.62994166651661689044041833+9767.42862455349798171665444232*%i
2032.83933811866655596203467263+6256.43616465005862256087701974*%i
1298.44373043719524805872898661+3996.19889311497830921016104879*%i
826.777736269742015904707977495+2544.56022782040840503774653255*%i
524.632166649301965723824037287+1614.65178236914068475306541919*%i
331.631866265841684044703564707+1020.65793520908622939656405271*%i
208.739058708635442058206447580+642.432764553026010045267385496*%i
130.761592096899788186304949680+402.442799291454200780267937706*%i
81.4770575809062850247054618884+250.760598774235450532834953123*%i
50.4637075487241540560117594531+155.311321947534890746665133552*%i
31.0437502004553897051337739369+95.5428389241225256495814476074*%i
18.9507170382040569512689677530+58.3243098461472037676229535993*%i
11.4675122728428015434578000390+35.2933737344834630440905285959*%i
6.86997909887994616170979473194+21.1436215733608926540060643102*%i
4.06845758172110558109650305710+12.5214249209588898067890456533*%i
2.37742698339299237215862713455+7.31696788762483719316122750456*%i
1.36784881683837364836081417839+4.20980578492811112676737598846*%i
.772794404720920750377860719544+2.37841661703072772183425205412*%i
.427323522968529754163250285165+1.31516657168797529488145116949*%i
.230322333791622222403029699282+.708859254954259275098069094390*%i
.120379283609195431189113994272+.370489339380971599437837982577*%i
.606060374272836807194361256045e-1+.186526203643378233054406724357*%i
.291374709943968196850947593325e-1+.896759147943765521240348557882e-1*%i
.132223570452592984191845253163e-1+.406942306008477697030752841672e-1*%i
.557369391279850520794500063528e-2+.171540659966738818998043445471e-1*%i
.213339694670405096647796521339e-2+.656592066113100914468112620323e-2*%i
.716782773692799555360413589472e-3+.220603054232514450696709869171e-2*%i
.200386589957296277237021090263e-3+.616726508982258717203241447548e-3*%i
.425301839061299965611412298554e-4+.130894446840932203239580470688e-3*%i
.573723203983486813697888674244e-5+.176573845979541713000621301679e-4*%i
.322529713544375643473744141795e-6+.992644389625375266591596802564e-6*%i
.162164202971393493374574572809e-8+.499090097804204064853682672232e-8*%i
.155876826065643637733155730176e-11
.917455197286873361964178062929e-7
.432021523911645896346803018757e-5
.481570263825593477595351242237e-4
.283568056245700734134118624912e-3
.116612635097746997619040063795e-2
.381560175060037837520398844938e-2
.106697445166140249117693621495e-1
.266292990811774328827030608152e-1
.610175199373325606991448773009e-1
.130876611715701461575907914074
.266438844587577547111158098719
.520107409812810026528612822882
.981063543317881103862787545207
1.79884032223578571064436916429
3.22111452459769314610998473226
5.65394369186091032738114281114
9.75729797083780261523303066157
16.5959007781565409033944556711
27.8764745125638033412120051465
46.3195985133955286946811458637
76.2407620538099114395440765552
124.455789895083423231650650134
201.688210438019724980023609917
324.751908708306789068657090975
519.929243157697659182223252700
828.189688865545554013177481218
1313.23813763286823885022738264
2073.90791313148260651821921340
3263.21677549887405206088786280
5117.62990611822204865492804779
8001.94292063450938189985577018
12478.0460394904098352238524320
19410.1676443026917736006672446
30125.7960259637862251944818116
46661.5177458620172454760688918
72138.2733432945505818795013452
111333.721401543268687316202186
171554.621818128540276160869279
263965.614974833954548608556698
405611.904132358926766562322246
622496.410067109370905170320383
954258.562108266193702351434152
1461284.72022366374240392689446
2235508.78019790960384472736038
3416810.68100315238430955105131
5217903.58430481271993572682800
7962088.74074162491872090858736
12140509.5220923575549852895797
18498944.3588621911905737062298
28169334.2218391232388340508108
42869038.1938512758431522082499
-7127215.30512231588131380518707+5178225.02542206691762746500743*%i
-4659422.65961542569548260569084+3385268.71816245352580904106076*%i
-3043415.63170978337513314303914+2211170.88683345837963568210968*%i
-1986003.78185225944190723923063+1442916.20829514783709763014886*%i
-1294668.95482054615168085638936+940632.055365377959922077004868*%i
-843072.038200379302403892414595+612527.689924735761925851296707*%i
-548355.556286162681329936753909+398403.632109934597480105968425*%i
-356215.055598341852630783353283+258805.387007989470485882845779*%i
-231084.974477496662167431275138+167893.061540934724223018185397*%i
-149690.120166117868265742118593+108756.238322917527609652519959*%i
-96810.8893215687486559477532335+70337.2282661397557053804741009*%i
-62503.8851168612418809537972422+45411.7307029610182975425029138*%i
-40278.8753849127665254525868609+29264.3159473674249058123408143*%i
-25903.8202838543803978847682491+18820.2270740281065429512660224*%i
-16622.1408851374047426393462524+12076.6922595489970696999744553*%i
-10640.4002093947870498315928015+7730.70326712245990461097345508*%i
-6793.24673870037316754946440462+4935.58265889954237632067981346*%i
-4324.47667489144357843899496930+3141.91621567584656906013422115*%i
-2744.10473959854000699174891125+1993.70879461941579418312022162*%i
-1735.14846542390479560353421227+1260.65915253370631476394683226*%i
-1092.89974705233389850300646379+794.038145079822129757601775557*%i
-685.406929466368685484726489658+497.977283246887584072941523759*%i
-427.791291159079466570629300066+310.808566137394986094094724320*%i
-265.577283006824403440400823599+192.953190576573372838308380028*%i
-163.888905625529009223910965058+119.072259805203857421466971591*%i
-100.459024856879976405513051356+72.9877538804709656196693977300*%i
-61.1137360781292179060532857864+44.4017283060564312538873415937*%i
-36.8609894981836713969430021012+26.7810764947894235837500213332*%i
-22.0174093585674202522480357503+15.9965842555024647877917474482*%i
-13.0058196027538655929841214505+9.44928105296647198456629092731*%i
-7.58525130373982944664232160002+5.51100765777509520718014313229*%i
-4.35924557037435563011950352856+3.16717729689595566397115285919*%i
-2.46282942072467818790575016079+1.78935031337928623013200623959*%i
-1.36391766748654705837664221852+.990944190126851112770135762595*%i
-.737793025143593186378346798124+.536038009632548980857165286646*%i
-.388114260001872872267617464477+.281981515616690637614209443367*%i
-.197446625508940271765879321385+.143453370443393240479587371090*%i
-.964523108519509287220783378125e-1+.700767057583353313185180039730e-1*%i
-.448240931913685937931994860619e-1+.325666099828048227632829592227e-1*%i
-.195729164379110902217345912236e-1+.142205561892376067006002774646e-1*%i
-.789482956767249485639345154277e-2+.573592943226824476950754464295e-2*%i
-.287110546745560450949635155298e-2+.208598022449520829690255950579e-2*%i
-.908084473356976879869396218806e-3+.659761988915194765982975214521e-3*%i
-.235982582997987720657866720580e-3+.171451382416592893180494036078e-3*%i
-.457072973966306050141262196041e-4+.332082953988408500550662407562e-4*%i
-.546302493762898226229515281696e-5+.396911994874128975224979778329e-5*%i
-.257299417701516945937100894457e-6+.186938969391167424155248484793e-6*%i
-.930845695470915869489511005203e-9+.676298984770347523853933372663e-9*%i
.205795985473047181660567447128e-12
.240408299850097091226981679184e-7
.143703098707416021388084125632e-5
.185590232321338072339187844674e-4
.121513545675380547726679964352e-3
.542642854462240500325487618534e-3
.189853504881352536043896860014e-2
.561490509038254395356523551268e-2
.147002816052057161548178806138e-1
.351101508721391834635838101929e-1
.780975467637296055408010902751e-1
.164193254655541597742183202390
.329852503682630592724237693243
.638429188036734856396531736896
1.19812412370332797597433582073
2.19110407144672304616519770895
3.92041893855836485642720620239
6.88514460656314361566289828834
11.9001039808105412338385586482
20.2857355105249865089324132451
34.1679840154825901723938057360
56.9502492409835760004585934782
94.0536944273664906125044841255
154.075116629895371380640644596
250.593120451868171209892196938
404.978848579163219084992143841
650.760470415612031791985685949
1040.38689481605103120031830896
1655.69057662191539220360425787
2624.04552904097656972810099333
4143.28243214487967652408829674
6520.05273503554390440395766476
10228.8245385528540300172194945
16002.4965608032727474279055598
24971.4201678588763888645325168
38876.4691645596761550784406791
60395.2829598571902558668423493
93641.3474936193578038061005992
144926.841009595996831255159552
223927.732740904217783382066657
345461.942975852544231564509046
532201.290968997113599016976896
818804.945505784324956614818065
1258215.67788522142722833284751
1931245.15497502317726320324373
2961158.62300168303265717170898
4535855.36739572856690997210524
6941584.90359919500017431334679
10614175.5803021736278191174898
16216838.8413905467084725110059
24758288.6108836874712223340991
37771997.9337527989247144184158
-6174828.33739112404228051003543-4486275.39024728673658090917157*%i
-4024686.51533757965602619887336-2924105.91528245178186439344816*%i
-2620605.88465517071838493340236-1903981.62434309291113159068030*%i
-1704524.21721745801212913405241-1238409.33382353082970071830312*%i
-1107396.12466944004706854799983-804570.379920674760407056801200*%i
-718562.650999744676402787736047-522066.324987588356928977081372*%i
-465637.672415979463687807627404-338305.571651637817574276751138*%i
-301307.242765584144936173861463-218912.525865232489806590154198*%i
-194670.829061449720673783420554-141436.636275205155504998815655*%i
-125565.129607076931362585851441-91228.4066940464607349286432003*%i
-80845.4649156185699717959643726-58737.6684575622258236321208380*%i
-51951.2696011598135656004146119-37744.8067491147075084164676339*%i
-33313.4084525927995024624925287-24203.6079936219300866196693446*%i
-21313.0217705830270575364962373-15484.8167166326851900746619165*%i
-13601.4672488175151871919555071-9882.04439953799840871267543459*%i
-8656.50920372677406252281406521-6289.32208057732400676439242355*%i
-5492.95464502971755884326487914-3990.86515401868073340895284345*%i
-3474.17686993117810860638944970-2524.13724581754999482551564812*%i
-2189.48335167303682905079694812-1590.75276935017877763401312062*%i
-1374.41698063963741223104778998-998.572387647417315091724621106*%i
-859.023842660055318374142988083-624.117354263115964433380642036*%i
-534.318774766730821248632317924-388.205313379747643148827487267*%i
-330.578591008518263490768538445-240.179405215779122796633917998*%i
-203.313221510659561742930093196-147.715701933268515917638919441*%i
-124.214318128123110985095474740-90.2469847072686917364039124897*%i
-75.3260280854392570539456541992-54.7275628697978520519402721316*%i
-45.2983925796190070279630808093-32.9112086593756741568134589847*%i
-26.9845605824910488210332438594-19.6054308627168602980269570587*%i
-15.9035072206683943139894362610-11.5545743402559259421344457149*%i
-9.25907698608856723800987841008-6.72711320046904532822143780381*%i
-5.31583574705111600677142972478-3.86218074212378395765996399216*%i
-3.00321901619815619783983703821-2.18196633618238126738235758788*%i
-1.66536480403946657539148195356-1.20995835477798648814521182507*%i
-.903642355747254783942395723683-.656534601557330143345073807647*%i
-.477970663938316593497271695132-.347266014490145320094609941443*%i
-.245288660259673280390099820949-.178212643316111126107779969928*%i
-.121408644669787545163303341700-.882085436200920261766585820864e-1*%i
-.575205396178497421958236943312e-1-.417911182661850666686389854370e-1*%i
-.258286895199190723208167564782e-1-.187656413788675738167267574868e-1*%i
-.108482374343791358995053099409e-1-.788170584997620766993477942757e-2*%i
-.418538647159081639251923613671e-2-.304086126774902930270739469765e-2*%i
-.144566848181087213760893607728e-2-.105033963343254312451682103806e-2*%i
-.430299686866204073712607024281e-3-.312631022295687093001200648660e-3*%i
-.103915100699518537955520842058e-3-.754987399601598439467341208599e-4*%i
-.183637759425313574990901629771e-4-.133420641970107613040985528241e-4*%i
-.194434849199378035114653135407e-5-.141265186869657236700533010513e-5*%i
-.767119078360500658083206099694e-7-.557344634473180681316762460288e-7*%i
-.199675098331323115582636279026e-9-.145072450721358513398565083041e-9*%i
.265817836122717199494940715532e-13
.616344656289808417226582425797e-8
.467711925269990596925079967052e-6
.699950824418860740432375545239e-5
.509678814423277865778873686717e-4
.247226541179227521820983492780e-3
.925152384592754748202792010508e-3
.289476154548214072875843368657e-2
.795299126955586209667711117461e-2
.198069881131728144727375936533e-1
.457086518927703812504681175325e-1
.992850842495787689630977585767e-1
.205356201104720402186120098969
.408021646659541901797431553429
.784081096236263176987384219580
1.46509217457867036051379835988
2.67332936283234800473168736391
4.77999152419394230752704879610
8.39884602625146567386458881011
14.5360723723722134697052445882
24.8288924999120502674407409143
41.9239894747892806873572842719
70.0753338602807785736475266942
116.085424913776020632372869351
190.782680712149211747642098147
311.333949937422499136164154987
504.855096210474914969444045425
814.035353635248487238964619327
1305.88022532789409977805290115
2085.27591269692556186440147255
3315.99702796633315164554376988
5253.18896652418676169456918409
8293.51696982360995740411170234
13052.4827645263652082373372556
20483.4726408795155967707178088
32060.8417632372638948979347780
50061.1661202594621789985633938
77994.8497681920407750338595308
121267.824424383721569881522176
188195.086401962057361152487147
291551.833596805865518423677157
450945.471636260986205321278730
696440.195679711473923569452989
1074091.71627125969577786409620
1654393.21105172609938511526199
2545155.80716334684116339982699
3911140.47770135960307848720118
6003963.70062884671229395558345
9207629.68272238583317230930630
14107820.4530199422388271310243
21597291.2967793557581853246155
33036114.6872779869367256029614
2027511.75431559210191202630808-6240039.54768641484815693613449*%i
1317351.05583063600814822431576-4054389.65721038655743107162111*%i
854959.368775207167618529396525-2631294.37423320149198115032012*%i
554193.049838213547001960096233-1705630.82590401456476326184225*%i
358765.850907533059361775935590-1104167.75303878594217855226391*%i
231928.926864104312974144631275-713803.840004377213878630792164*%i
149709.072727075961135463208905-460757.148497894404126130097942*%i
96481.0584700222830671677502563-296938.165302430622399430608716*%i
62070.2310664374600364268747631-191032.528301838543186923733484*%i
39857.8029121759226871143634107-122669.703850779709681251545361*%i
25542.7357911032664139465348121-78612.4574386956454674730676696*%i
16333.3096504043494376465391902-50268.7582186351597489074871744*%i
10419.6901126811028067102762536-32068.5087222663911851920880390*%i
6630.12560099389080774153070869-20405.4284115830806476043133068*%i
4207.05165994592962413657363327-12947.9736338614100325602437280*%i
2661.42836867717634288021841765-8191.03427564893647543608829825*%i
1678.07599198856495589794673939-5164.58685467223878438975340964*%i
1054.22407929172050003953536691-3244.56809332986716034449167338*%i
659.669792943411381222136932806-2030.25486171374535639197368231*%i
410.980566457770321210027360372-1264.86812348603986597729280845*%i
254.814062930147603125158894523-784.237046520854290669579794723*%i
157.149649522781196748411890003-483.656889209124606477341250138*%i
96.3477597074785559445735458889-296.527913895423960129907847823*%i
58.6844167247591417156242478347-180.612063242523314457293590273*%i
35.4837815983850459169760679721-109.207850462071855066844356471*%i
21.2807208256428271786798578073-65.4953241443034953838015046052*%i
12.6460942222374490996746017847-38.9206759973472874406155993348*%i
7.43761277151985565228421553271-22.8906183827910691548606304754*%i
4.32340181822361237151831834012-13.3060626005403692598137250275*%i
2.47991126668234145358201007924-7.63238207912367178786048171810*%i
1.40100896636305126546787838976-4.31186223121048123320411643432*%i
.777780772281892759549878901582-2.39376307838343599606231187951*%i
.423159309263354763624224795945-1.30235043972227866217449991136*%i
.224878800663671745920254876433-.692105782662297981373049940094*%i
.116261431963620248771740195437-.357815895162854834103948058177*%i
.581820059699308602150163855176e-1-.179065801933488520026599552550*%i
.280073019728506924286309974334e-1-.861976122025385720142038641101e-1*%i
.128643488402126125687942849204e-1-.395923946420019221888358823056e-1*%i
.557938841647110369733354136862e-2-.171715918768794222897510974597e-1*%i
.225321621960647540150433890168e-2-.693468646477910977101797076292e-2*%i
.831236967005063896748173218777e-3-.255828432884297445746476635812e-2*%i
.272616949453091199126750303455e-3-.839028697286716985301975334456e-3*%i
.763417403591832147340100095291e-4-.234955717502765796509682975729e-3*%i
.171285534404527073915543334515e-4-.527162669393078446376113789034e-4*%i
.276118733860226758896923806672e-5-.849806081507295102566335923515e-5*%i
.258943576401326620742290373087e-6-.796946382147645388456442289869e-6*%i
.855715222758765256252891488608e-8-.263362065359490655603677820693e-7*%i
.160245403176713950543290535989e-10-.493184639264983579498284658719e-10*%i
.336291685008655468130456958009e-14
.154773943040884619944734470480e-8
.149116925424859534076369952907e-6
.258626207099983044499394013386e-5
.209477167393718091091568635814e-4
.110392069049018718602071008538e-3
.441956587099445248135883422727e-3
.146345499892000800224695659147e-2
.422054777894103682771463790574e-2
.109644218570270300945079479079e-1
.262601970879534448828392044418e-1
.589542749746693868144571134760e-1
.125593682305073983013536698743
.256270491408697552506902121117
.504475687669279161383227429211
.963524982749396689454952079402
1.79367696251753451417271421154
3.26653509001399809976456972109
5.83723045066255619517409481194
10.2610338469773142680109038594
17.7807072297555630472585380622
30.4260369419505432335795851824
51.4906349676738599147741113493
86.2879537546688454780504622675
143.345804312969205085812731945
236.287712697147668320843852233
386.787482148950334539398232568
629.196953828371904722562655959
1017.77708743951337761951462944
1637.97194955787075646109969050
2623.95042254070695990596098839
4185.84925376751260198239627029
6652.00989160289481170366589795
10534.3569873739195698416374531
16629.4485726764042480952971537
26174.4469340960978833171100961
41087.5525650108606538982658436
64338.2001754999290830305247470
100516.417163219064314446134764
156707.584687062641367662087685
243835.114719748658889814802800
378719.460782603912626011413348
587232.940385371118617407866980
909129.688163220176592335007607
1405434.61534343536568826195051
2169739.16153610906168992439105
3345457.93250405566401482899618
5152175.19324632204998341563157
7925845.25805798702885960269861
12180097.0384035058098574770203
18699671.9866629312206826792716
28682766.4957825207968435861405
5596659.76586080900130575768758
3624395.08397969079845595640585
2344170.39747200248710825617362
1514091.41564434462163551206269
976524.626844669721889673937308
628836.404121897202997642711157
404265.402852974220381206685070
259427.697933400672784632597534
166160.680795618000268301734812
106203.263032688994539324838359
67728.9250898047659544409616462
43088.2641635991350873053622633
27340.4629150119178371758937802
17298.9223787400335848618603871
10911.6971391020996721643634375
6859.73596116157236533625768511
4296.67458260736167052834458981
2680.52583704589778440532766137
1664.96296542434636062453344404
1029.20080724341131991982694841
632.843967249292637443415370925
386.862330970149300521672791956
234.968401268595821643968120339
141.692790881968310138043888904
84.7654317219410522241664286100
50.2593889769598266770117615536
29.5035904246384328766145391303
17.1257004616196279112951217211
9.81529586062059237520929197621
5.54492182389368963348021199949
3.08137490541652340418608753865
1.68036404934183747739340981475
.896633834394335048241274505216
.466506538822787101356556816714
.235650722585540211742181161813
.114958720649293614383307769795
.537998964413632828065102321693e-1
.239492639010714354573363988666e-1
.100292230899382772510267773366e-1
.389320693838606515129421560891e-2
.137293066452664304442526479649e-2
.427420826416842788691561830918e-3
.112581806334319198524070458965e-3
.234632410622264940363798652979e-4
.344969170539507679249763002679e-5
.286502342380508378460199616367e-6
.792951102459604782920605197853e-8
.106825390414193064956910834936e-10
.417135644269121365674849252567e-15
.381078488103176763124587638852e-9
.466175205919268869178715838922e-7
.937130865091103448504373477226e-6
.844433199325510054343841679054e-5
.483560358138653834966244491417e-4
.207162919376651114126100607319e-3
.726141297839798210840126496942e-3
.219888740699249560569970015800e-2
.596045659532783548382513750825e-2
.148205072614097532642624333166e-1
.343999611748295920669296856446e-1
.755075316442314743308344081746e-1
.158282012386671383291825802682
.319296916307584894084127793620
.623584520717741289951548552911
1.18475834993725862284965580116
2.19836728227370559678431769152
3.99672619015382347194591033343
7.13840408212833661338732737727
12.5533537579329940495315320572
21.7769638534210349095470841957
37.3256381130026814998218495252
63.2967952400126226755154016714
106.323545282715249555169091381
177.088200112299657772552179419
292.713857694656205363561649822
480.532181252788868443278162503
784.003072864888579242615115334
1271.99199588256716658438169040
2053.27601714083965299031490374
3299.17752257935181114251395792
5278.81058320479101904215694192
8413.86929621143006121529298878
13363.6504524135585418198694756
21156.7900055501203800345951120
33395.0841685656760111378426573
52568.4142306645488965189654135
82540.7264491037913326258022313
129299.096215018818619456604200
202107.026434899555824729822875
315278.294778117392752018277430
490902.604034196017893112753952
763029.939763276764562172599688
1184088.80438299991407792883157
1834722.97559705441734812673188
2838856.12519515656880946489465
4386746.14885174369530769088579
6770242.72735994401509856490901
10436673.0149065613945424405908
16071147.5218759798048207468374
24722203.1631853202046286817280
1463926.79604859327112061447096+4505503.39982847031465823248247*%i
944786.058049234615134690158047+2907752.49701083268182466737209*%i
608882.947912699577719404585496+1873949.02485765281196259310533*%i
391813.107249651206853193149838+1205876.74983173344854139369309*%i
251723.565896362530628324204228+774725.474678285020128915959565*%i
161443.094278084767633154334549+496870.753450293840828740115628*%i
103350.404810284904122911731990+318079.839445011967798728217980*%i
66030.3250547833632331197750506+203220.444375437419262736917713*%i
42096.8003819358381601408924267+129560.629503236848800018557745*%i
26776.8051825944175518743098778+82410.5324886198440657188695183*%i
16990.0663250342972937691666512+52290.0474240737146747541899593*%i
10751.5927096192703220987545187+33089.9998808087030136867313187*%i
6784.18790433710264824778478342+20879.5834262817837327025953465*%i
4267.42788802670545861811895461+13133.7925570623520639370485835*%i
2675.23771128406785778467180474+8233.53506204937928788163124026*%i
1670.92970080288970638866765223+5142.59283193822544690063017070*%i
1039.46698638902642323426790049+3199.15043144667982647026341417*%i
643.813853963776584138076650499+1981.45529934966795587689784686*%i
396.851677264585926341851247637+1221.38387381760290538055572830*%i
243.340011585840233016273021027+748.923547593775912478339761157*%i
148.350787269050083390482174132+456.576775704943611522246502167*%i
89.8672142231738452350090785987+276.582845746463922440897766230*%i
54.0576847684571796807911554384+166.372446469690111983766145444*%i
32.2647065478330694766732850133+99.3005561740564405579742540499*%i
19.0912405711001522445912190936+58.7567968099272214107452714454*%i
11.1877515720812915687103105576+34.4323588314011514168349909819*%i
6.48564637149201652682331913297+19.9607670654813969860076829206*%i
3.71437252794782566819607231774+11.4316631802010518778895444358*%i
2.09827999508646233287653618175+6.45784179726177672214880437524*%i
1.16706433104603765269778264279+3.59185467848484006782432738300*%i
.637741207020910013819801697297+1.96276561382652988078134473375*%i
.341508149990064446992570657707+1.05105401103559852736928781465*%i
.178662211157433665881243876229+.549865745994562469068334857803*%i
.909763650593348610728198483354e-1+.279996461015160847624125135284*%i
.448869483977625656182153500758e-1+.138147822117828966275768552720*%i
.213389089712577047399974073546e-1+.656744088421211604670474977015e-1*%i
.970579011558022262669148918989e-2+.298713504539995511233518209129e-1*%i
.418603253800123665609564755746e-2+.128832834282863493876611710965e-1*%i
.169210234767104370579116116636e-2+.520775553864276819884745549071e-2*%i
.631204978486133140854783886082e-3+.194264917086983197059787236742e-2*%i
.212725110858035731041066449059e-3+.654700571631557313072863108105e-3*%i
.628496328559225118900671686195e-4+.193431280358181619800040428067e-3*%i
.155678089253689158247286304127e-4+.479127892394978853700411246366e-4*%i
.301321128623758961023796180006e-5+.927371076968409974456796104411e-5*%i
.403992654555933542572197002581e-6+.124336154206652579696487070507e-5*%i
.297104210609936297568204977681e-7+.914392737819650195471749157014e-7*%i
.688628601450767312628693922151e-9+.211938090991304537960653098686e-8*%i
.667366559378882598421623095761e-12+.205394307306167817891078862855e-11*%i
.507773802864238212606262837436e-16
.920819197207312902496087094019e-10
.143034934764820241392358157683e-7
.333304725918894055389494799847e-6
.334168103856077940187170411982e-5
.207972581964030615757528964957e-4
.953611306654092024598611773354e-4
.353904412954058857709951804097e-3
.112555530832650799217588043636e-2
.318433516318787280748427571390e-2
.822237380185350797557953993801e-2
.197378476269210488081381451755e-1
.446526573385396644943627020317e-1
.961918924003523762582846237110e-1
.198914033620264164072972906475
.397363530377706721581932511683
.770762681171226557847661595116
1.45768476991956328764347703340
2.69709856810796263708211568485
4.89608708821880558042733484747
8.74077234514288679204001942332
15.3768584317766582645255809255
26.7018275467712996734973897672
45.8354516947497773594185847043
77.8740037869257327149520245541
131.094280317582050275552834551
218.868576357769275679127659982
362.700145470496686128815547702
597.019952399127585948119741957
976.745336620741934306278414838
1589.16005986963090688709992663
2572.54188645277348706416987410
4145.30596655677335087481758649
6651.50790545012536643289130746
10631.7563621339115442358840239
16933.5311119342109725736443938
26882.5248740804968711227360980
42548.3618664623232412255407123
67156.0941333903630484243990044
105722.609648970079701449784180
166039.664527948948763727220674
260190.569171505622507675907926
406887.682235766807928423299546
635071.233882719810919350821123
989444.763852334844563920792874
1538981.58722219791123396528525
2389985.73388317213099023843961
3706129.67967242637693504523711
5739172.19681454473691250884428
8876014.80453014211148534434770
13710737.8794953909641203694147
21154805.2327100209470899236940
-3219509.23401845023002510127579+2339110.37782036785040759307839*%i
-2070388.23006233650726533735307+1504225.09862203467863593013122*%i
-1329344.14707503725009918094342+965825.057205027831669503027385*%i
-852121.341559699504368267791404+619102.393664103666105261928532*%i
-545248.847782720527656218813715+396146.476260067983738441019318*%i
-348228.197369933303190764834614+253002.594839901104923293038852*%i
-221947.727630253603573168149638+161254.463117529738863743344488*%i
-141153.419437998668081836474713+102553.962195084598944172453522*%i
-89560.4723645660025699410883705+65069.4920011060446031100373572*%i
-56682.5332750976893573485658373+41182.2710194374632658005187547*%i
-35777.1838835357842921363361596+25993.6456236567436985321917710*%i
-22516.1830082039958668290440862+16358.9645238118825846959541018*%i
-14125.8081812865178931172027957+10263.0003861507158482237341429*%i
-8831.80062334810930492570046710+6416.67875172665743381432266540*%i
-5501.46072808856910944905859672+3997.04518510768231190350200848*%i
-3413.19612425399898710310396807+2479.83214069360029316030361900*%i
-2108.36096213593792654880616324+1531.81390337805930335031521718*%i
-1296.15631007421047055171449128+941.712682211417288959709273198*%i
-792.695237504318561905812521098+575.926801794197567602514099785*%i
-482.032004619246828243622754065+350.216751215559386622830362828*%i
-291.288591370426528441745031468+211.633549553390239313317435320*%i
-174.813479146421041128578100846+127.009427068453180488642627132*%i
-104.116507007262691435486982313+75.6450702081445069095231614240*%i
-61.4899687041958515553875182597+44.6750773093169789021029954068*%i
-35.9770621122068862396178406949+26.1388656572086797123780210990*%i
-20.8315463285860744246218040953+15.1350043318317207209545503931*%i
-11.9222764554630445477810835498+8.66204087553091376001343247578*%i
-6.73476333052367304632307363043+4.89309197567647327666893810315*%i
-3.74881150712559649116697546619+2.72367098940261783893369711336*%i
-2.05226361472981062408051724709+1.49105679477921659884670134165*%i
-1.10243053358427505726905617529+.800962666820618105453828681419*%i
-.579526006148105601619292374583+.421050289551694959003857136100*%i
-.297161091038043896343734493825+.215900170307611603326174178699*%i
-.148050346181950657452327375149+.107564872787103259649341760614*%i
-.713265762392693675241088136101e-1+.518217910148458727904601518979e-1*%i
-.330335314234452067380037398377e-1+.240002654293344079655972761441e-1*%i
-.145985205608105971605332839908e-1+.106064460333895699931726049676e-1*%i
-.609848570756307046919143995596e-2+.443080922297743522414187537469e-2*%i
-.237892636501592026256322103718e-2+.172839117517727062060567422224e-2*%i
-.852552456809508991153948077115e-3+.619415617227561913312574701818e-3*%i
-.274522036662118997594765506803e-3+.199451934509676299663663612709e-3*%i
-.769568981387897613013073464778e-4+.559124593212073651861595192065e-4*%i
-.179227210515843589079328557889e-4+.130216190615530001887226800203e-4*%i
-.322120792913010362951247047368e-5+.234034455206109886004160496053e-5*%i
-.393782632997977023217963977918e-6+.286099829662957469097812861106e-6*%i
-.256409629637712230178827119014e-7+.186292500521901750617629613691e-7*%i
-.497664762739471830682768659438e-9+.361574614819923993256287552715e-9*%i
-.346936202566857354039182307679e-12+.252063905669504516413985988326e-12*%i
.607101969816668169508404740001e-17
.218545956947313811401533695342e-10
.431089646349875083721320673908e-8
.116453577730982310599919860410e-6
.129922834125668760882400340554e-5
.878911780247189005603039214707e-5
.431408893886524792423771688860e-4
.169548610734538893237826024119e-3
.566459297015787912730844231841e-3
.167301203721279228171814009788e-2
.448727568426940114828154962156e-2
.111431902057096388159693875637e-1
.259892576678066267180890708906e-1
.575520187567853920518182611959e-1
.122033767530517702688641954599
.249433865074564955418090314898
.494104073475290603833586237708
.952722645498970801184105337260
1.79457352862188432612986034891
3.31208087675308192358318878234
6.00446309079519562838788815957
10.7152200459143429844648475401
18.8566593312375065192506495413
32.7744818191724395993283176320
56.3367799251937793053923099231
95.8812113546378414057108777686
161.731826125936397798125977459
270.618973052532505252405247325
449.526654473784039642874068811
741.790068605560197491672928288
1216.73144980229710951712709072
1984.84690321718678714126523681
3221.68329872588611066074800426
5205.29259573674911752567207615
8374.86081636152206196666007837
13422.3035806659648576024544290
21435.1052867969313913529359957
34118.6937624852489243191439790
54142.0907156817463283925468517
85674.3844351723215670636969469
135216.221065649583733307496056
212886.882529784513018589671726
334414.151043166850920102506815
524207.187678272924416451230845
820096.765916871729836404450545
1280640.15908620289138337186589
1996367.49398849129501587656716
3107080.61159467852709492410098
4828439.02414496593052518272931
7492785.84508475308638549896284
11611792.9358433845239141926245
17972516.7162166361863534736161
-2684101.81503929021274848887992-1950114.11812242349405818579337*%i
-1719693.78226856070654513443772-1249430.66796450075279665352861*%i
-1099923.00878194933912707682941-799140.843411700235361194223523*%i
-702236.717507941606073082766589-510204.839996406365466884903939*%i
-447467.692948246193623013531901-325104.308835345385925045033323*%i
-284537.090209209624610775912182-206728.296831888580420283851570*%i
-180531.125630083044339301702168-131163.540398933934649295397882*%i
-114270.066255246567456814791167-83022.0628124269231698585524039*%i
-72144.7622661520667189582953004-52416.2379591958912248810423520*%i
-45424.1332394654678377133010087-33002.5645962535839667121685920*%i
-28515.9309157152911494699453975-20718.0365359300132118340825514*%i
-17844.6512441730959250197515936-12964.8980263155295221147596481*%i
-11128.5505413791765474818700184-8085.36524336905442500005845296*%i
-6914.45862378807350540759371701-5023.64824831545548457970877957*%i
-4278.90778471308288707612286433-3108.80847900726173184089610918*%i
-2636.41851757477157734515049217-1915.47017463892050967230713774*%i
-1616.72954461991470510149949322-1174.62277044910873160135523288*%i
-986.320310923502427862503980986-716.603652121395019196603469729*%i
-598.343380510334094009597723317-434.721912291251713375546535357*%i
-360.748384058330773179276330563-262.099042927588470329776752724*%i
-216.033212555929347812376875573-156.957316383504379151139018525*%i
-128.412287707762256996841388692-93.2969881381493190434479925165*%i
-75.7062579082016165278758023869-55.0038160064506470160681146493*%i
-44.2303512175829477948405479365-32.1352311881877068065493584028*%i
-25.5825580495503782774028325817-18.5868163981642262716383334426*%i
-14.6322767817939976366545809291-10.6309713635187573843791298504*%i
-8.26532286930465850104239020932-6.00510857224512964231556299133*%i
-4.60399915899818198878241847814-3.34500118791309460368826013026*%i
-2.52452518429677312158048099497-1.83417490941217713744878120507*%i
-1.35989805305475850416005952968-.988023769295972624333842126439*%i
-.717911979888647940645687745451-.521593584753632077505883594082*%i
-.370370428359303407964662491244-.269089867318596703947150591855*%i
-.186089354136188306389512255620-.135201829788991112202159997284*%i
-.906860773907001395860063527436e-1-.658872919223290808179689401339e-1*%i
-.426495940173546296784001597337e-1-.309867438557711481260636988851e-1*%i
-.192377631065979578120521830302e-1-.139770530406359452013042336700e-1*%i
-.825831837057614275915700658900e-2-.600001950603150347919992237470e-2*%i
-.334070929898409978173009045927e-2-.242716737941492484858420663535e-2*%i
-.125727531770753621266785594295e-2-.913463987725976634120666498410e-3*%i
-.432783643289463043553019248683e-3-.314435722274896819154683905806e-3*%i
-.133120802627980872384154463966e-3-.967179244714359119908305281136e-4*%i
-.354015275662499027059184208733e-4-.257207153332346753415198967724e-4*%i
-.775065594724569363242459394062e-5-.563118116561167127096347223073e-5*%i
-.129331494862522416072479854026e-5-.939648312281293800166154722002e-6*%i
-.144140142308901115877806857649e-6-.104723943380161492487757092667e-6*%i
-.830931764723578477784669386530e-8-.603707264942224458833667469786e-8*%i
-.135041180402812584682350842075e-9-.981131605946874539446578776691e-10*%i
-.677168032995939833112065442617e-13-.491991374577287760642087035669e-13*%i
.713487612767216708947879439936e-18
.509863076048132800260798014273e-11
.127719338055988510524026198836e-8
.400000957952604260313444537840e-7
.496646777354367378414641180740e-6
.365243041770855378196516008674e-5
.191942166699597198049914190346e-4
.798990738726744253390398589861e-4
.280474991824270063544267719817e-3
.864957921998547528161722428823e-3
.241036471222543028904880401218e-2
.619353310785922175449587293882e-2
.148959843686083068496450944549e-1
.339175923818519745369020286022e-1
.737655690983707145609073227809e-1
.154312442724597509775746685531
.312258959506963303848514789139
.614029952342543742108362304177
1.17778937640953944837825031382
2.21063033053528788178089962568
4.07082688538375345481944251328
7.37119958077658251352306556499
13.1495262079692747649711063853
23.1477024453557145994028168200
40.2664517761447624690936321607
69.3021848588421699495110366512
118.135551378156668070899414529
199.640505124438350396672917965
334.738908877296442713328876492
557.270929794675742246965493527
921.735644594367784184165884828
1515.55694689997954154339586633
2478.46734825284201933953869423
4033.06300508895571339993231322
6532.85574906092406452490436695
10537.6779059189218374411383012
16931.7716481049895644146337983
27108.3783022484874166232735098
43257.7705012630872336433700298
68815.9600758503216110631025344
109162.641400646065438899221016
172705.248027349657882417039080
272560.454389595435754285431518
429159.077512932515141902101714
674276.646872186415389812842363
1057262.89534205600541263126838
1654659.59428606654422160869162
2585034.83051304267431008724590
4031841.28423725123834780061565
6278607.16371788933598339261152
9763067.55035903313980792973701
15160363.1328235250265572738531
848350.161529514325284092325982-2610953.32589935323091161681088*%i
541453.086238310098904695738877-1666421.24966837974579527262755*%i
344936.670028513060276357557096-1061605.91071480729129579680686*%i
219309.746747545667342223509483-674965.997106995374869175935265*%i
139142.307642020961499408310218-428235.989554422365471386110035*%i
88080.7161927309051627505598633-271084.570168973671104109884904*%i
55623.0707552356517705765935232-171190.209150523054421031553230*%i
35035.4367520395816163710097143-107827.986909497051014404052806*%i
22006.8391789761854313279656730-67730.0866463983758629900803656*%i
13782.1453703678511852347390800-42417.0819133372710977382374811*%i
8603.75280077222633296573696934-26479.6283528621588250155290884*%i
5352.59404115819712130197635281-16473.5905616549440111223206313*%i
3317.63470076206790622402090993-10210.6297008967645188555491861*%i
2048.10012748461796476561086902-6303.40404484594644703989183781*%i
1258.89347575891437349202242342-3874.47572540054471338935597464*%i
770.164158985247097423039493705-2370.32155303131950701577455778*%i
468.767964635323926484445779905-1442.71944751328783802166722345*%i
283.737416749426932280896770519-873.253976410345271387171476497*%i
170.702649171290106465722081858-525.368733106682473815561290166*%i
102.019584973943086542505785544-313.983997143756490822328722048*%i
60.5300418997494429435832924912-186.292313459387160773040464374*%i
35.6280563100097754970700854631-109.651882366869992451693718330*%i
20.7872063073501095901977526099-63.9764426359970230161911519517*%i
12.0111570800658619866199613236-36.9665404077446904590221476285*%i
6.86601622359275197686601824741-21.1314250973296164570121960085*%i
3.87826400092851832316779500238-11.9360692684771325192449597735*%i
2.16165536730972790707525363016-6.65289113701567501786033500568*%i
1.18703571485668789766978296006-3.65332027765348670500652345666*%i
.641017894358114516755658136225-1.97285022050071479767430233705*%i
.339681572226216571554635612961-1.04543238272243353339335488929*%i
.176186040545800398108602245218-.542244876467901582837929763321*%i
.891801486521387591676860870608e-1-.274468275349529323423006922997*%i
.438943507044875029534734561226e-1-.135092920538198174176719198982*%i
.209179792653185252365649466283e-1-.643789204158441272228368252752e-1*%i
.960105141499959295479926423376e-2-.295489978795174190274178623079e-1*%i
.421686498190346983687301224402e-2-.129781759332951319763782352271e-1*%i
.175795845915654285355584774239e-2-.541043980878406704776824383480e-2*%i
.688481815892240997214021934884e-3-.211892915041607386400494576609e-2*%i
.249933711374855815474361077810e-3-.769216868883505112369615353922e-3*%i
.826189035485082392700609743993e-4-.254274839310713932873826280948e-3*%i
.242713521238086964566364029595e-4-.746995408564296478666992144185e-4*%i
.612214630111249527425629809190e-5-.188420288831122984608719920782e-4*%i
.125984281627478712925395013910e-5-.387739749507741975614026733195e-5*%i
.195154367430204416823533535949e-6-.600623383847790597121071015978e-6*%i
.198269703537886019033990765483e-7-.610211402499169896734999326501e-7*%i
.101182187553621542758916447442e-8-.311406752889159849525936191064e-8*%i
.137682383354842957141815778012e-10-.423742804610252304572686361402e-10*%i
.496606078363611409104560730780e-14-.152839635184085063863678973168e-13*%i
.824806697042800575482849521884e-19
.117007368409079689243308233365e-11
.372231755480619784099458510651e-9
.135165679050039521308169697256e-7
.186787061407901159854342127890e-6
.149350032938906507532202290825e-5
.840421866196919355568395449578e-5
.370597482042056083818569430408e-4
.136712502159264072757091673429e-3
.440313606386723835009738167961e-3
.127509589929405721806384174638e-2
.339095347824656260089870074588e-2
.841197645627887467846656664197e-2
.196990798167869140725854457512e-1
.439531442905525429448487525201e-1
.941277288517637418510073960340e-1
.194622377157534346121783243653
.390396072943917691857532875246
.762744044419254723213842947438
1.45629113708414592292324254722
2.72470618012511984924692595821
5.00742856558303229263551195766
9.05742589159906466087474561867
16.1524237708779917050704780744
28.4419407868878615178389337325
49.5142026326358662619050785316
85.3174949690682019871204191561
145.650576602399141129775801242
246.563394929647042037330480412
414.209096046420922179279233614
691.002706219265911652156955061
1145.43559873494607872429512158
1887.66871401874079936913059149
3094.23812580695861551553911170
5047.09715651604489685316732972
8195.16696058700058520999470079
13251.1563595310320998468866949
21343.5452064065594331980783212
34254.6998104328207877828871574
54793.2591947585986367805403011
87375.5210769699892059323818346
138931.688043861780307827997660
220316.392247453671414014642543
348501.030047015512309020812338
549976.749588059827683616330318
866030.079490468038416991133432
1360912.11719880029936551422327
2134474.32683143689770500590790
3341692.66956039754653335184688
5222805.31973590571186190925090
8149790.00113336498085571912779
12697975.9320095050588770030684
2254834.47890483495802486858590
1433438.09375615446872400364296
909427.924459689439498426978531
575739.429097221052952862044778
363655.754227079253162253554498
229136.826786331182729380690976
144001.329891961003370216925013
90245.5888381115450208917851152
56388.0076079047510183934354121
35119.9676234002759778916764201
21798.3840313931622254785163122
13479.7994719032408035110282211
8302.44922868275703998114916224
5091.60395087870316579469972851
3107.96470060477649796850321773
1887.56438196601194289273031599
1140.10364832443003035937875599
684.534458740756529493507054444
408.340256222313467496575321911
241.860468993228907495691303023
142.145001179424972710777248888
82.8311848006227383590193907677
47.8168364114564228087126458396
27.3194596354900116070399142559
15.4308315072620764188223934862
8.60569447319995330621991136179
4.73188788477736417321835035295
2.56100860570168594988038807611
1.36168302300011554013125791319
.709658635215394360480954666257
.361559869151782700757203281868
.179517016156414635826755646191
.865365183531757164976443043041e-1
.403183027263493430523013888445e-1
.180562660779170094948510536300e-1
.772030903120705848388667409172e-2
.312495288069214828008084265077e-2
.118461227986529567768769066873e-2
.414730632682224057368015100710e-3
.131630693989062538884084772204e-3
.369266286170447139672896111443e-4
.883320625059197723687911804425e-5
.170832315236104341891426971378e-5
.245628559119217478328880215606e-6
.227464594685878177650073548499e-7
.102753651634898080484217160202e-8
.117063865071655743797740955824e-10
.303701835991904506021509140119e-14
.938516806001227739148592123214e-20
.264304192588127953847217732666e-12
.106786943456540803153776427956e-9
.449620518243652240767813336777e-8
.691601305132644216920083112918e-7
.601288553747047872351412221266e-6
.362352525062471128432101153912e-5
.169289781577640190074673589039e-4
.656383477615289997279696289687e-4
.220820227188307226044863071843e-3
.664649553098068138328471851337e-3
.182970173373491223477722571485e-2
.468265081669780112789271689565e-2
.112804210785693023863289983275e-1
.258274379327300598619365886118e-1
.566354686914431292529923615797e-1
.119681208125896312353074100930
.244950889903710102176896167148
.487585635841124427885742700077
.947206598245264144017770959161
1.80104524794106636379916446189
3.36017815341145161760028989005
6.16414305464043559711772815831
11.1388919344569358321887462259
19.8586416558911084095441856061
34.9772430787812319237027401378
60.9347904877855991337689195043
105.109150688160295628228817490
179.683789468197572485207067817
304.664531848590619302006809627
512.732934106416793978733184267
857.026346577132145392882014543
1423.56823845306000368791870262
2351.06758766070907954138783290
3862.36665576465410485455752687
6314.25893542394286955292491364
10276.2154710969540592549849323
16654.5115502252273444385667408
26887.5201781085574908373331618
43252.3656045470517187631972008
69345.5423824516900264765329122
110834.879743541525829811874977
176634.122924555614406662746709
280734.830063524321857125639935
445059.296684611364332742884213
703897.531102858467403853451454
1110798.92817761600919559844759
1749263.66285845274410436014807
2749309.71666783972905569894794
4313116.66380414688594570412152
6754678.29007108256654270907348
10561056.9351381908604188663742
568091.203516733208522661696479+1748404.94467752621627794291309*%i
359672.688115823384549441385815+1106958.71098563904223133687833*%i
227223.189396880827733018036310+699321.069271234719749519578494*%i
143216.466777755427149528438159+440774.962054304489057403129304*%i
90045.6174913229484583629432537+277131.914547824679672500379690*%i
56466.3987156275384810679763397+173785.705730660748312821308692*%i
35310.0065820344066693920202843+108673.025955077132172231708472*%i
22014.1077909625800092200052183+67752.4571338470171723370534858*%i
13680.6787107178288777478940475+42104.7996453602328829521146618*%i
8472.59742208910921663393743904+26075.9736030771431098586246134*%i
5227.78128529654716738090857045+16089.4563977100698381337125859*%i
3212.83922727948816967591048141+9888.10239738894304408984575430*%i
1966.06629247420084559614167101+6050.92986134303474715758394546*%i
1197.56266095542531690708842968+3685.71888635830211980152337553*%i
725.817450913777461755774230515+2233.83641967184047844492782497*%i
437.528754961142333202840616015+1346.57504618469323664143414294*%i
262.202800367033382932852430232+806.977242090868133109637936042*%i
156.134521467934639687314698595+480.532646306598620103614901310*%i
92.3305736349719446771463649003+284.164286454300648780523742896*%i
54.1878981240924963697829452987+166.773201970649272666892710796*%i
31.5399656267605816751595455467+97.0700329725544151552222145211*%i
18.1918091870527511866512184649+55.9886316464257823366541355699*%i
10.3885644217474726231704194896+31.9727136956967525264217125588*%i
5.86756118608518414297366414860+18.0584964657828747790942988063*%i
3.27400321356407285563185706908+10.0763457910450223256499137258*%i
1.80237709976212845237662898953+5.54714632771958207340692464114*%i
.977459251143513175521359079022+3.00831024550404198428138710300*%i
.521289447401712881651721533665+1.60436395037143691084146943425*%i
.272839107239608096581836243512+.839712428648935335079805099594*%i
.139815653342525927905014407073+.430308334531694239289777630020*%i
.699555492775073731028515592206e-1+.215301042345436634634319651279*%i
.340628872384660485275902022728e-1+.104834787282483987576716759668*%i
.160781098874471346134158304188e-1+.494833341094907126222069026007e-1*%i
.732213270527444963342468154315e-2+.225352072840356753741973812351e-1*%i
.319889646503302912019906959206e-2+.984519098756026737444538354960e-2*%i
.133123811667239575383629287499e-2+.409712963574282164350876600221e-2*%i
.523083111067128380670058850016e-3+.160988427950571561409527661933e-2*%i
.191898921159531432680553222602e-3+.590604150454381779877738247847e-3*%i
.647805486932545803476805069239e-4+.199374028242409496464763288384e-3*%i
.197379449408385553193750928497e-4+.607471482020904026919315099339e-4*%i
.528673870206151254246452999195e-5+.162709086686819840592984191088e-4*%i
.119916042771730376241691950941e-5+.369063630681758122480381497409e-5*%i
.217929739690682030620201387784e-6+.670718772106900486343573441158e-6*%i
.290822581203329788392168814628e-7+.895059870408301386216429837008e-7*%i
.245461595188474523643955132312e-8+.755453110520344433320029386259e-8*%i
.981464277520768060666245125736e-10+.302063644925127199004462643156e-9*%i
.936120015862481327330536075861e-12+.288108116164019585508915327792e-11*%i
.174677021669972027982473388159e-15+.537600593916477900170668649735e-15*%i
.105176257282362851943460833525e-20
.588013083970970248546727770613e-13
.301738002842216315962118377383e-10
.147318234035832497742243795175e-8
.252247795066209410118045765710e-7
.238486031205757888307582211736e-6
.153927081296048328119264307025e-5
.762014634932814914662597608778e-5
.310579228708202114957950401230e-4
.109156109347100080750148858560e-3
.341544708518978601608925778551e-3
.973466717884914035093148719707e-3
.257068839573070108846225866821e-2
.637167850854882905084761247369e-2
.149730461661437518363566282804e-1
.336269639205257691128163245055e-1
.726407196870816393946090362074e-1
.151728718103567999397236498451
.307775020622902504544857181121
.608481513318358517580691993003
1.17606601707663239762854459242
2.22796201584353659452063680216
4.14604399994510191445495476937
7.59336301866835606230286705055
13.7094920365090701676267978896
24.4351680835981489274265368335
43.0484609496556732642286060195
75.0453084050542011479742558588
129.578190194116094172462554777
221.795735152985901655537722836
376.631156809356950894315233657
634.912592999413183050786968105
1063.18272340312824749283477896
1769.42658870806544334617231050
2928.18441871780019550404797846
4820.53446513051294394501935052
7897.58083187956602076985759243
12881.0137052164333380294252790
20922.0201546212706321619864220
33851.8592959458207815537284244
54576.1746491983906254067904704
87694.3150022556677710152995197
140470.324087470921245670767524
224352.730711030093419902140297
357349.559488344372864894674720
567734.284762744288376959622343
899820.451374900271224831187023
1422947.74396264128763132331785
2245447.92999481032393164333019
3536324.60168042050797572024435
5558869.35766488418259682741923
8722730.69378087535406949368175
-1203767.37767205739430910938091+874588.193704240593778818280883*%i
-758935.914267433511023692301421+551399.217745920980009428725151*%i
-477367.398611655335920991934999+346827.716574654870178899569199*%i
-299516.565595699625915303338720+217611.522747383106273119431595*%i
-187430.083851140482138273462212+136175.926945464372868783777475*%i
-116958.574559217572189087366710+84975.3784321574221729904360367*%i
-72763.9896404405352111378050879+52866.1329811215569317344015882*%i
-45123.4867346050190241775218713+32784.1321245762974669038552410*%i
-27886.3984547626190118189393912+20260.6544302880226568992970085*%i
-17170.3331136821028923951306579+12474.9772271087546204064744014*%i
-10530.3870653340931053520607002+7650.77403932278537284221163124*%i
-6430.73799970892135404172957735+4672.20464324865743735874289028*%i
-3909.19282100547662537866660691+2840.19483463372722590431355820*%i
-2364.65573896835785064338207125+1718.02295845245547441375922872*%i
-1422.76150539589760734147972846+1033.69674087904835055391995963*%i
-851.119273803631922656624774451+618.374348823377665978738439239*%i
-505.979885635847380184933153648+367.615905229731943454033538186*%i
-298.763662536659275106441893845+217.064506655524960315052529442*%i
-175.111532571745340888478660733+127.225975557568954286434489535*%i
-101.813342892431636540195099887+73.9717235297439229929728788870*%i
-58.6777458911170057440148505050+42.6318778373883267973725419941*%i
-33.4932040401266046111621143864+24.3342371343129499993828845363*%i
-18.9166369164404326302731300969+13.7437412066301666166473405617*%i
-10.5601622020082007087114429068+7.67240694239369664424119029059*%i
-5.81981331909158223732524671659+4.22834188137206817736274834653*%i
-3.16196818576896789419461672972+2.29730435916111050844799683482*%i
-1.69093252747122067608777748338+1.22853439319543501358738942502*%i
-.888425801592812456102162090479+.645479127834431137835281527700*%i
-.457638318902409348692471240955+.332493701127480020298890594239*%i
-.230546376549488221903194130744+.167501747240741022666066754450*%i
-.113258784569447651277014466687+.822873236599010555432005788659e-1*%i
-.540726376262534217692139453740e-1+.392860708368959574612361995034e-1*%i
-.249864541028603543798032104107e-1+.181537215297820834314558482016e-1*%i
-.111204549904063322459659390229e-1+.807948348129964786750125336201e-2*%i
-.473848793901534812391908038419e-2+.344271300613512334991033265441e-2*%i
-.191895416539768858234562229975e-2+.139420181045445408229345224739e-2*%i
-.731828562885963275999291496064e-3+.531704574145697983680362037235e-3*%i
-.259781137641501354058565028093e-3+.188742044470165008529823528528e-3*%i
-.845460823038989870534124881764e-4+.614263243700240762105655238860e-4*%i
-.247259729154216559257104917870e-4+.179644708693625332016658579151e-4*%i
-.632243438186051345426918620292e-5+.459351745894494863774547705035e-5*%i
-.135966483752012637465620949491e-5+.987854328291870875172221323328e-6*%i
-.232173270384099288069835998167e-6+.168683754800135682167765394370e-6*%i
-.287532448803099818208842764496e-7+.208904552236976144807070609441e-7*%i
-.221171935099556247235364803882e-8+.160690816851069205051923255776e-8*%i
-.782713870300074192314583612941e-10+.568674914032676062019273614123e-10*%i
-.624990860811966013227108616823e-12+.454082439994572424590627428605e-12*%i
-.838778957330135828038180303144e-16+.609408584096337613367998236338e-16*%i
.116150645753544041775979715711e-21
.128915120108634067451235957996e-13
.840212808420421125304048787596e-11
.475702583293763477135371555100e-9
.906768137621491462188065487005e-8
.932343894131104486478726967601e-7
.644576828478387421699700347209e-6
.338159033421636740783837446444e-5
.144899708382853622070445392129e-4
.532106239826914327823925589284e-4
.173104887574846975346447168197e-3
.510903861056586297016919991616e-3
.139238301528855597162724672516e-2
.355150021490596962969244301168e-2
.856740404472249720500957235299e-2
.197097148461419855568442683543e-1
.435324502702202736461603846504e-1
.928158581940562771633721021725e-1
.191897547812474640430808609877
.386182293005309723418675000447
.758874863261002542565463516161
1.46007044634699044962164216332
2.75679574816772249959360769287
5.11828276743348314968063457613
9.36006520086021370332923396684
16.8856432969909596862855359379
30.0890323874302368797339950170
53.0211801529387191773260838818
92.4870525083396029661967484064
159.842495204381656868633610427
273.923482098465115603018549279
465.800909447055754844923362504
786.468170299503065027689766671
1319.22516201129503764644432583
2199.56055314557824661025488275
3646.97250719623336397585817213
6015.74835800411884569951734792
9875.77973377157729905799307558
16140.8538966205254415354829884
26271.8314398998603963171954152
42597.7123934441590111099863453
68821.9418476863791178516871086
110819.277325008960351586944324
177887.675396902705182300596646
284711.634992979113386798236614
454436.331532690954354113464058
723473.624451822661474976023506
1149004.76345068050698656739407
1820676.92864587516912984495636
2878814.26197573232297349297730
4542736.92393197754348908553816
7154747.40758698337640484985373
-967273.536151785234466512696926-702765.360228402879019387226370*%i
-607203.779377299518911640961212-441159.368883192608459785306368*%i
-380218.065145761663788064801311-276244.594244308673356708231421*%i
-237451.790901244833668647939085-172518.824440790771757254793171*%i
-147872.758284422655136115366102-107435.847627090107867276168714*%i
-91810.0526894095002061376909027-66703.9077772689603235085142990*%i
-56819.0548520083375313259124833-41281.4597510534038968366911755*%i
-35043.2318812724036714549827511-25460.3982804977107876192688403*%i
-21533.6084661618055256105406179-15645.0823320828398615262013048*%i
-13180.0975553748917210935844871-9575.90139723935081785508894543*%i
-8033.14581735306178591064388263-5836.42206997538455658418979466*%i
-4873.96193628651533770933004393-3541.14062659150853956939060625*%i
-2942.78876674066751859854306009-2138.06118997354285416303055029*%i
-1767.47259822773966191417213884-1284.14400969658551261545101739*%i
-1055.55871752148379160532881524-766.908299086155458104558677441*%i
-626.540030197236499292431927136-455.207977436055354420623385072*%i
-369.429223161318184255492468801-268.406041714680733313174047985*%i
-216.264243130567630730197217629-157.125169921248608436380426043*%i
-125.613611946250448824325482153-91.2636311753132014505213523208*%i
-72.3407681956509016718419205254-52.5586446027180153100267504688*%i
-41.2746763586867257582124170171-29.9878077042433573227456051134*%i
-23.3107578501209204662861057768-16.9362569381476649742338002995*%i
-13.0188013021785285708148693704-9.45871280968427236343679534186*%i
-7.18192865581671153513832023546-5.21797660155121700341937235104*%i
-3.90854057137346361449913192190-2.83972094753719392661515234276*%i
-2.09537826143827159974190091920-1.52238141919283984779449692747*%i
-1.10475020396980366834579001590-.802648006006659232650099600223*%i
-.571729385447568905695599145219-.415385713038028100196743950818*%i
-.289789259373596561500435867166-.210544221094094069397867819679*%i
-.143490233310426068572506787709-.104251756853435999385661530247*%i
-.691992266585845222889127061277e-1-.502761810725439608836301968843e-1*%i
-.323871236584599165337945242203e-1-.235306226976397000195474465558e-1*%i
-.146485113468563116204066954456e-1-.106427664654601984953150036530e-1*%i
-.637014073091421019716634009037e-2-.462817815038832762536910745651e-2*%i
-.264694770158321136082950843239e-2-.192312007460624596905484682306e-2*%i
-.104295734151648530440861297288e-2-.757752863507137762041592446412e-3*%i
-.385985748777912202996185259770e-3-.280435061691146468083372297742e-3*%i
-.132556078076780183547716356333e-3-.963076280683798706643820513113e-4*%i
-.415850261938544688829849992884e-4-.302132900580521764667265076490e-4*%i
-.116719005760796467604256336165e-4-.848013215117213461383824590337e-5*%i
-.284881688574715263764217524829e-5-.206978662199509562841598340802e-5*%i
-.580794437438462152755971489408e-6-.421971858827991709603475094844e-6*%i
-.931755406865789478273158730825e-7-.676959928786934278679073519618e-7*%i
-.107078831133332297202060888722e-7-.777973246674703896687583927237e-8*%i
-.750593699241590460532180764421e-9-.545338243751880663111225297656e-9*%i
-.235091565211165051335809324515e-10-.170804020101257009278852421726e-10*%i
-.157146674502228295413861371856e-12-.114173742160484532773976148550e-12*%i
-.151683933109714873612908827827e-16-.110204828219328305891500066767e-16*%i
.126467559092238003332135499517e-22
.278663079217454506465712921657e-14
.230685058916759038557229631001e-11
.151462291124521480459746732132e-9
.321426014007113098116264904032e-8
.359449296710805120142000492898e-7
.266208139891881679216624548258e-6
.148016533386612754438004432799e-5
.666874732224423486168043335769e-5
.255908971598289985944622867501e-4
.865700858143088581532927717579e-4
.264617242569754769890306308219e-3
.744383578786294684390111540633e-3
.195420381001564259419288819002e-2
.484019055487987992496395946541e-2
.114083723885471796970261776693e-1
.257676789663409815071439786840e-1
.560900661462461790624448748731e-1
.118221438184612848134539599059
.242220191199119641617981703907
.484021282426443629380788592573
.945972946876219073323670986770
1.81257999378971964649214295003
3.41207884771175854537715867906
6.32154641442846783345498153099
11.5448537625304720238374404412
20.8117266699719863033918551505
37.0769752273448543572028049115
65.3488098141061732424281875146
114.055559028752527085460532795
197.289313165199569625922287929
338.472007438919002235997796880
576.320080709116026399257121556
974.510494947479981557956853024
1637.28766696757996987058478573
2734.57719761965388853414242508
4542.26994329806622400187677017
7506.65061695216289328128858913
12347.1599418987542327222045561
20219.8785846473290650173737067
32976.9903175914741888685986111
53577.6481678606636198133160364
86737.2197929137261986925590930
139951.184250162705861522655600
225106.864134614238767781181355
361016.019664383046011700455405
577387.838327489013315827942784
921051.769817563696579199863377
1465689.81735080292771948814193
2327036.13954415683906449017177
3686583.77379590778496403355068
5828513.23048222032499840990074
294759.505295581064342701077750-907176.476874131766819454998263*%i
184215.656707008091461571879066-566957.493937086856261693778592*%i
114822.012633875964375917043566-353385.817988609012463814019189*%i
71365.9277017300755119014334182-219641.740802854021478059442235*%i
44222.6820753914640917907235092-136103.420593167477370127519992*%i
27315.0687738176145978372808239-84067.1374819883078324277067879*%i
16813.9570390013014291670022296-51748.0387737062755118775203889*%i
10312.1036385141552320732542192-31737.3916019000459495213483420*%i
6299.76917700781708771124473837-19388.6958840810535548342420591*%i
3832.50227137599617583360021186-11795.2291468006688307550391024*%i
2321.07901109592460380213214862-7143.54666093294447524411574073*%i
1398.95610091668243985561784948-4305.54416102215597053274310908*%i
838.818524025614153601023456722-2581.61796207127744732653707392*%i
500.160386468345930145369851357-1539.33538738084065038880595278*%i
296.440860967652701242062199768-912.351157546202877691721861364*%i
174.560027018199572120482586893-537.240521402780261183354767467*%i
102.069904265850635325767303240-314.138864000062669665718801838*%i
59.2297295682341006277397995362-182.290363603496421304147320414*%i
34.0867147696235442867227476949-104.908120882858942684656512861*%i
19.4408512565709767285396949655-59.8327878610213334810137100342*%i
10.9792799457354726340401010692-33.7907491390284736509611417144*%i
6.13424661847407128470969533758-18.8792698306506168464083492438*%i
3.38709646807240560548130717504-10.4244110386108890368398387144*%i
1.84614032946849828568178836556-5.68183569932049550831715448173*%i
.991965055815893403015076852198-3.05295452173770648066897171844*%i
.524645800703422322967615185860-1.61469374367305186467321555271*%i
.272661093877315139800597270141-.839164559854409087975688582247*%i
.138964409289195897270408534788-.427688474722642070561181660645*%i
.692960700443771933023401815707e-1-.213271373966522919304905330194*%i
.337191027196729235589310681302e-1-.103776727328658670345221416396*%i
.159604165282005829513245092485e-1-.491211111953027476861005706949e-1*%i
.732159933726418041981770413605e-2-.225335657460912138939826286555e-1*%i
.324076597472470801504833176352e-2-.997405208824794722905072831553e-2*%i
.137679464044764711437495817569e-2-.423733819897684577967635479067e-2*%i
.557795655672955353239122133413e-3-.171671850657253093339567744517e-2*%i
.213808879539023663921876171806e-3-.658036068659140013144734426055e-3*%i
.767761684690614958432934243599e-4-.236292749744624344358010988249e-3*%i
.255049378535143206342892679914e-4-.784961273484389693510636658401e-4*%i
.771180683931054258682329509513e-5-.237345009512215817385574591299e-4*%i
.207707728998405975778849942998e-5-.639258658082453057144105682610e-5*%i
.483859597413566623471894743593e-6-.148916671726397981832514675480e-5*%i
.935070309751278700389811519658e-7-.287785049842287527431484554826e-6*%i
.140923915997420565498546879900e-7-.433719216259529604682185688250e-7*%i
.150272957736776419410175652135e-8-.462492608109109412626176394500e-8*%i
.959872273300939160810392927727e-10-.295418309332928598379361136156e-9*%i
.266062653323632101575050598987e-11-.818856647991309237354091155067e-11*%i
.148879536869082329971098809552e-13-.458204099644250856659048195745e-13*%i
.103352669604849467364294473757e-17-.318086809765958408083280801840e-17*%i
.135831401762910084414035908770e-23
.594187036238871389345129788561e-15
.624782451340781887251070793208e-12
.475740402492691669737928773112e-10
.112405031930344159564675333203e-8
.136725179753086525614035355166e-7
.108480685316124703203498131769e-6
.639328999473305241427375312483e-6
.302894595667270987044508333119e-5
.121476838091711670076098592860e-4
.427367824089013335028652266448e-4
.135310394507396191020715528389e-3
.392944388258997596602233006063e-3
.106191423724771561991526943916e-2
.270088038862624573121811954150e-2
.652329767125192279587175864857e-2
.150698915714803967753342713127e-1
.334962718272112822045351236589e-1
.719855309020143996473071009130e-1
.150185106712360101187491571092
.305235004142285485374861865425
.606089351167080784063033649693
1.17874642199415696373560504265
2.25020428380430728229577086389
4.22428381293831535350208069630
7.81126328992776315573394162358
14.2477435642012224861787154503
25.6668499173457249779657466882
45.7174675875316316193994401635
80.5938237171042355982845147435
140.737944981447762385046339270
243.640566278681795783352770517
418.427867635902768921473795602
713.340535627548925240099024524
1207.88075205669636749351229449
2032.46814829583441563523495333
3400.13818090568327182927967454
5657.49865828634365296757472003
9366.40219861126009057210900579
15434.4878786291378430050671148
25323.2933848123281310318293900
41379.2270157495323998757719797
67358.7320407730830251460596697
109259.799249218940715911312557
176635.879976862663214759018406
284668.121462290541094241045883
457427.733342150337421294016597
733003.310968204354960241858431
1171546.33232917346984520078668
1867876.54898588665202527205340
2971203.28427389472385785349717
4715937.61832679175088853884857
755607.091464233334615954381578
470089.625368436453511398345533
291629.082464038218915165754549
180372.238025591517066015890408
111202.397000549946461898877960
68324.1393615351653280055637790
41826.5545959875254833776195655
25505.9672693057591168989617417
15489.1579349514985695396343862
9364.49238816432914815829924895
5634.73689317161627117625609076
3373.22761201540623336258006920
2008.33175892582000209424323415
1188.67216386558601389415328531
699.079224520685106506334560789
408.327578686294990698260683741
236.737049152841527931409655861
136.153830631525122215022105327
77.6248282561495661373069168339
43.8374723572662878123583208624
24.5014743984864286634725874298
13.5401528727292899365033160638
7.39043950638560898364639385511
3.97926215159634481488329345305
2.11066846455122958540693579229
1.10113180879545202075503769419
.563999841693488536789105095609
.283035506569190997703754815142
.138831207565746340409771362666
.663758939415506795289388461276e-1
.308316894055464705212982405853e-1
.138605429118424229084866050174e-1
.600308652122966012367777545757e-2
.249112715932323515931401192394e-2
.983892019357613695878970935046e-3
.366830877769046608962904562548e-3
.127792031478216948986660758608e-3
.410596692894984907889091177667e-4
.119643676883883130108760136060e-4
.309193194731838212643255894656e-5
.687379084433639807241895986035e-6
.125906647437800928015975397161e-6
.178244157622386885240044846624e-7
.176350291564386035923639208706e-8
.102639784715507425441603561983e-9
.251770973215016063298386973284e-11
.117930588337327457923571397153e-13
.588786703348511985686506696451e-18
.143972932477264751642926107667e-24
.125034751661516267690300162910e-15
.166998283567959747676082110124e-12
.147477275310894203366948571223e-10
.387972870794104304926566060164e-9
.513330393125480059996370864037e-8
.436368166805557312570730162805e-7
.272612036891838670028381713752e-6
.135827218410742050003007797296e-5
.569371086833534516023994842507e-5
.208343399404464452496312686178e-4
.683347839399887522420821398272e-4
.204889684592240716590392331108e-3
.570064220675088683523850956551e-3
.148910631637850858564707375278e-2
.368598178630868040170390330670e-2
.871072738084252345196798491901e-2
.197735703071851116406088637802e-1
.433353443827237478944681732199e-1
.920793968939996960305883142055e-1
.190368488518202071016305055238
.384111861869004285140646745705
.758366737794168348101504106850
1.46836198628562143109458528236
2.79359612273565669607001074195
5.23126897088928485966877599726
9.65625418501258675517655112814
17.5928640828479731851968057536
31.6732550117714506482262432967
56.4056516242521266661229537791
99.4541669194332887568091179422
173.759336083970066776342914036
301.034073285353105214476458679
517.500609816019404006156042486
883.264789041252158282675704177
1497.57334768734480218695081048
2523.55496899698163098161797299
4228.20300827535777329986550673
7046.78354947056424282241211510
11686.2812130251692870320535004
19291.0805582771028206201522982
31707.6325401472684772798473315
51906.2073787246996983123932105
84651.4199224896658751478633951
137565.954470489153767169589739
222814.613256365163536903853131
359765.294193959052544703080706
579185.958669390125972596165391
929852.794730798876071948481728
1488937.84800673371922092770701
2378312.48906537866080877941243
3790098.28330916877891140770974
183668.881973496606521622864858+565274.694341215172729101912324*%i
113736.513519323351742985581021+350044.995234132122029790249880*%i
70218.9480575476525377138194259+216111.700434478648380309815885*%i
43213.3455060541693137207089166+132997.002050249136563430382518*%i
26503.4944866401267882558642371+81569.3686591474122485943772134*%i
16196.2826874195038456720444665+49847.0325905075776484935979893*%i
9859.43015484158239482811097684+30344.2058734851976616316252864*%i
5977.24439226540380569515554624+18396.0666637483358451838277167*%i
3607.79327412955673624869062415+11103.6459653201428193214601830*%i
2167.41244371594370480845007662+6670.60959629334545024216208623*%i
1295.55709045236568636154517087+3987.31472875591654394447580717*%i
770.245133027869978985779104598+2370.57076550923847687740862257*%i
455.287885181462695430712438547+1401.23202889832474633383191131*%i
267.447426706052091924375127470+823.118542233101733118964008961*%i
156.054937452643875182117318601+480.287711892915930548355061455*%i
90.4010818650856844024507441053+278.225921399006563172691993851*%i
51.9604572224489221189778821391+159.917843777630041356315586580*%i
29.6138210812596044516465937066+91.1419696146461467515631812012*%i
16.7234544902582434174219005641+51.4695005693673649464851638615*%i
9.35018305532838037804829347388+28.7769044589591678134944431846*%i
5.17116947989923442579490457804+15.9152231762289912577926066301*%i
2.82616340211222729772767261851+8.69803657604800773305825170161*%i
1.52460373098951183902087628060+4.69224780358238929804841704419*%i
.810805432302012018152419198592+2.49540253084816681107724871890*%i
.424474801155735819928006252585+1.30639910746274735932151158194*%i
.218399955912993288587054167134+.672165948833220584070820128008*%i
.110231795818686974704370144233+.339258583264436836292633856684*%i
.544606191268415893634523621406e-1+.167612550911052083198875280348*%i
.262725736444713203320698657345e-1+.808586673848138315801369374422e-1*%i
.123400006635363724368594986860e-1+.379786168908975967536274437951e-1*%i
.562412804783870760657322349602e-2+.173092863037987864089818224182e-1*%i
.247739271206554212781015123114e-2+.762463076504207177403357872726e-2*%i
.104973311777243993255718687387e-2+.323074633499588979343298401718e-2*%i
.425440457167097696807577784426e-3+.130937109107149012724489344120e-2*%i
.163785995858551346314518205813e-3+.504081463073717712288952950276e-3*%i
.593890355844228754350048289629e-4+.182780657106893587934054250055e-3*%i
.200690702266772521674943547806e-4+.617662470430586100519422434672e-4*%i
.623593600943544817958932908415e-5+.191922375951178245304028594750e-4*%i
.175093719148541652917523447244e-5+.538883056886254072792498698359e-5*%i
.434120391248947495504075343288e-6+.133608518129896565118179804595e-5*%i
.920949738395509149741854015930e-7+.283439184842571488014340386151e-6*%i
.159874630253193143999925109135e-7+.492043517542233253906379052446e-7*%i
.212588939796397484766082267701e-8+.654281480196913605820909006776e-8*%i
.195136811758278670178262420678e-9+.600569353045320676893247730781e-9*%i
.103481678004524963009346040398e-10+.318483856793797006333374482590e-10*%i
.224623731352682786590650989711e-12+.691320760043028626290923426469e-12*%i
.880712397421714280619877924233e-15+.271055404653095913211558987916e-14*%i
.316230445286550567038894535774e-19+.973257235412016389226406645952e-19*%i
.150662333446205499982606297385e-25
.259767787583610262314489278908e-16
.440708371591193587725782047922e-13
.451388624866359782239298084417e-11
.132222946265896467821347624715e-9
.190309166088256971628113459151e-8
.173339328492867418645716133648e-7
.114800233017029858316176791319e-6
.601585321145361983317101847347e-6
.263605551518131139373558450022e-5
.100336908960204786154432687882e-4
.340961105680112394288953813307e-4
.105563531425797667400085172907e-3
.302425391826471016707870681786e-3
.811454253929024413346768037209e-3
.205881459778956513288133295585e-2
.497781550362680325623942400004e-2
.115419036145010067372631659959e-1
.257993063749778429807509023835e-1
.558383912884478109603414554238e-1
.117451225328032072646221373101
.240850794076215391001385230590
.482809023591868252056806254375
.948308461911350771836575074474
1.82872139932789803597426809086
3.46843962585382683130447243093
6.48007748312105858216964537390
11.9419863643793290939374111430
21.7343089450648449840951371782
39.1067715836951696850517543128
69.6319167795781699276592621746
122.796089202798270313625596256
214.640602685196735212149112402
372.124576739099979302908244471
640.298719161310221494357051478
1094.05104936485607483301262233
1857.26247764785388341613461623
3133.93212670820842416332480302
5258.57882541014294594080032107
8777.59571613982493903566283764
14580.1743516994581119688020380
24108.4102352692083982722733849
39693.5903994679119640629492555
65093.1118615923686091252103315
106345.732020629807789612543146
173130.895812441887920423079409
280924.763220416758927462008734
454413.191319358556443827768966
732884.471450976940962237791637
1178735.28024666645166656527042
1890864.81480959544815346651579
3025733.01506298355304665076736
-375616.452191126240794712392199+272901.326735345635094783742758*%i
-231496.146291689465640006813130+168191.795350262914182569715119*%i
-142218.653524316191492825213844+103327.900061075213212280105059*%i
-87075.9011821045190142108091964+63264.3453731912095752909905091*%i
-53122.2102724401166672468774785+38595.5449445709931998220246810*%i
-32284.3180327555569448918958541+23455.9300384472816939762770607*%i
-19540.5450947263035371430538841+14197.0370317252026725593066417*%i
-11775.9070731325614309974668480+8555.69729446994135532688070010*%i
-7063.78683543893490601538766281+5132.14154471079191145855050706*%i
-4216.26511132313679886614740826+3063.29591272151615090487905375*%i
-2503.30856972333205220748976778+1818.76013662427388139768846927*%i
-1477.85581715651811849846727191+1073.72510142432506189740785310*%i
-867.162291049853168081782528600+630.030283130280852862116986152*%i
-505.500151614577059704787859277+367.267358061148027241670398596*%i
-292.601871474879710325441656773+212.587703400458798481530943627*%i
-168.084639193158861483545635028+122.120638678266602099352300361*%i
-95.7655544459827990238001105895+69.5777480230193704573686875300*%i
-54.0789174344946271853492699402+39.2906333846509117433778767179*%i
-30.2453673447079926859985823174+21.9745456510749343910923761336*%i
-16.7394098943177516636102756078+12.1618931819355701953564999672*%i
-9.15942139948856886123615038377+6.65470917865082534053574856229*%i
-4.94983221286652027443157672982+3.59626360913841125244365465758*%i
-2.63875822219885203189007167741+1.91717006955128575568228205649*%i
-1.38587093903330003688086799628+1.00689417553441718094791995758*%i
-.715998052364317733529629409543+.520203035011686166973948853898*%i
-.363270248605241599806246488393+.263931284770788156325985176090*%i
-.180648775766939621251932742934+.131249018226785888721784063528*%i
-.878538950056227604712218123631e-1+.638295909725027093136974272680e-1*%i
-.416765765502055945744528441230e-1+.302798052853953149732653913711e-1*%i
-.192278957968132295930767890774e-1+.139698840204403367277750622271e-1*%i
-.859733238207585877149190773302e-2+.624632760297574563751641506720e-2*%i
-.371022456777079614664085848565e-2+.269563593693579164750748473998e-2*%i
-.153785533140398389004454357865e-2+.111731730018477251169962869750e-2*%i
-.608635466477344953872894386004e-3+.442199550448172282802575306941e-3*%i
-.228363642898989787290467170951e-3+.165915898416345520136452890383e-3*%i
-.805220994456086399807675106241e-4+.585027296915115695774600335191e-4*%i
-.263918155144826755520966971528e-4+.191747763625433472193714809707e-4*%i
-.792974674054572628825679405875e-5+.576129824331836254452216294589e-5*%i
-.214525474828424375724158938009e-5+.155861880803393858787678274646e-5*%i
-.510243308037684681220770080219e-6+.370713462919517503714327944006e-6*%i
-.103282185265788031616359031333e-6+.750388999809236724129377643980e-7*%i
-.169913223228494058298877012109e-7+.123449182745969280151304412366e-7*%i
-.212204065037531136757764218127e-8+.154175277865381888757920149817e-8*%i
-.180702898055409833110340868662e-9+.131288340371072471841500371592e-9*%i
-.873079431263238171154779970659e-11+.634329337139475773545571751066e-11*%i
-.167699766302662596128204229772e-12+.121841012155444715033873528531e-12*%i
-.550373595284059970598552792175e-15+.399869823265080299186473865376e-15*%i
-.142121241924795639014283036421e-19+.103257126391302505214093481134e-19*%i
.155719814637824880008422223624e-26
.533038646702548344016351736128e-17
.114872945583805623477340760722e-13
.136463456945744398594223227475e-11
.445113036874304785904534560965e-10
.696951805765250181513148012574e-9
.680218055680605322435441099876e-8
.477615472558093342865092316022e-7
.263257282760134350253869522114e-6
.120593819847750608117030032569e-5
.477523962114337289505122433477e-5
.168138320062113315824199681804e-4
.537594626275002165732093835917e-4
.158602839313451532790342435310e-3
.437173758250781538630237942167e-3
.113707371943779242737861358708e-2
.281311832687704988476651430614e-2
.666336711958400049170568138884e-2
.151935141660811145863940957057e-1
.335003509140958868025159018791e-1
.717015521771678710451584433675e-1
.149454887037758873990276972491
.304233324248856096135354666981
.606268954487786267336160330162
1.18520834369689455747420857632
2.27713310333268576567073488332
4.30668060023927254019304141276
8.02917625667818556591790813082
14.7746217666619327072144249168
26.8634112259723732315499365825
48.3098164354509125500840077163
86.0049994064272803679737279317
151.694976074976564588801992638
265.270169100733881698350279456
460.209423985426535535836496274
792.548567522312616242737156826
1355.59295291492870059405075211
2303.95790846795805398580626455
3892.70710292304212805486290218
6540.85249618560126551478096293
10934.0496494910352981655559754
18190.1831095273074107279407699
30125.6030503214768474292381759
49682.0602807581972387250301240
81609.6289982093217523887423974
133556.539195941703756470080485
217804.513656771879127405832471
354026.151794668216147102815680
573657.626027278305223092616219
926819.954372768997658378893466
1493254.77949760541223735808984
2399574.01894570220604978646052
-291396.859808906618225689906408-211712.211178386756637356490695*%i
-178720.903077052282634055344996-129848.336729002646581647920244*%i
-109245.134156454911657960196163-79371.2359423155497328387850861*%i
-66538.9574293945424997442381036-48343.3823415934001755499223226*%i
-40373.9039722370893805729912993-29333.3582574348166262731502929*%i
-24399.0116353238193367457862772-17726.9195943603821168737036232*%i
-14681.7446668904012654261071516-10666.9118858117771922226599269*%i
-8794.16664226030328942888651122-6389.33606396821690986325639598*%i
-5241.91979885464019954781961524-3808.47766226120312902474510322*%i
-3108.27936238639538791970778955-2258.29714569510294893971279166*%i
-1832.84614313166071109800397780-1331.64067027575228891669663146*%i
-1074.32591523077945589200379595-780.543466353443547940336033804*%i
-625.693657513203104539095908182-454.593051686563049252728554459*%i
-361.906647411505494481538927834-262.940570512299998488091342660*%i
-207.784704848172365900806175185-150.964424741238916994827006175*%i
-118.348567104143217811577335225-85.9852671296563059070153272533*%i
-66.8296532547600414602257660033-48.5545852214350547014296166712*%i
-37.3875742126352170807987848580-27.1636626844360306789745622060*%i
-20.7061378305822775566415724041-15.0438897246586868902455903805*%i
-11.3424948123925600125616711228-8.24080485488338210037742843395*%i
-6.13954654786472043243485116498-4.46064166969222039348747956212*%i
-3.28029472784743875082545207726-2.38327362417293543408937733917*%i
-1.72787099581715633498913536864-1.25537176136813710864488355738*%i
-.896061414034123257957002559584-.651026725000410273095644284733*%i
-.456793952974963963133267260661-.331880233371992258743380786053*%i
-.228504909241845399998729553719-.166018534422205909045247687272*%i
-.111941646967235544806189061161-.813303671766589522912878427024e-1*%i
-.535807198795546334063361488977e-1-.389286716736387189946239765729e-1*%i
-.249914640925771575329763648681e-1-.181573615003762104564238523064e-1*%i
-.113240181414958179675734682863e-1-.822738076770094005672340428937e-2*%i
-.496669450372342694605926016867e-2-.360851478056554990872531770706e-2*%i
-.209964066935763085553707254678e-2-.152547823981796119192261519081e-2*%i
-.851210921348217775188762900035e-3-.618440934662106555302502398704e-3*%i
-.328933585834142566766498059217e-3-.238984238997806304591783844558e-3*%i
-.120270455812016659398614360266e-3-.873816010100196326877882350205e-4*%i
-.412341629404027910045791083938e-4-.299583729829052087572411483904e-4*%i
-.131068538164806125322446130833e-4-.952268670602253663992419826022e-5*%i
-.380768245743610008329970651961e-5-.276644323846728910416206474749e-5*%i
-.992408295357888277578368719546e-6-.721026831722811001566482038855e-6*%i
-.226417645908834962339730467723e-6-.164502048843627610237530028794e-6*%i
-.437267003202327379648396281484e-7-.317693073919947168403381959821e-7*%i
-.681673099483081311534764528291e-8-.495264496971687761016361338682e-8*%i
-.799542233628340303608257378988e-9-.580901435667387231310918994329e-9*%i
-.631601246204976696616496504528e-10-.458885166109100117553177903361e-10*%i
-.278020851126615632910443143442e-11-.201993972015733408078523695954e-11*%i
-.472528698200763080307006674225e-13-.343312194945864632328707384185e-13*%i
-.129804546154801026211974519450e-15-.943085231098976842816909677835e-16*%i
-.241055729074384823153696633981e-20-.175137238791878921716936010566e-20*%i
.159023112458717383206265433653e-27
.108071823702741393962482742835e-17
.295850436980478462960580618513e-14
.407644996925026919053953310759e-12
.148064199298241806497926944435e-10
.252221729779144651983784548175e-9
.263791254920418124274511393658e-8
.196382846845260642471092222418e-7
.113863661551433519559718087504e-6
.545321557084080258479678479999e-6
.224659884484759721155963835316e-5
.819721473713598634018901580929e-5
.270693800005837433252842468372e-4
.822494947912623379030353304833e-4
.232928811610818653224003122717e-3
.621141663411638555016742639081e-3
.157261081468885687692967773006e-2
.380582731741212851598201851243e-2
.885327230938685705653225359437e-2
.198892623248511407448703392923e-1
.433222323494371379092236243583e-1
.917999727384051564944070458303e-1
.189787780394471899447339495635
.383770086952636081154346882746
.760662781966053239559878301609
1.48065297946662247417747763388
2.83514913723364567044539128227
5.34805875251271673219809036525
9.95124269639561274464763567904
18.2860539207014891582860476998
33.2177934031437523022382432815
59.7075617718507456154646927722
106.280711953826396438657063908
187.486133265792792677564361198
327.993340335740679144895700480
569.384940712562693045113974691
981.366909666326183461551239971
1680.19233594014934143041299647
2858.82176887251344385347348833
4836.11629167426578749039855913
8136.79945889513788675333274525
13621.0164361172117976333556363
22693.6218243124292831956423550
37641.3037144597684515482678842
62174.1825872754814667403796724
102293.721437983056163674517660
167680.255375320913170471766980
273906.275999721055553432201814
445959.429346640215736698281514
723839.018516112904270026668457
1171429.51828633962233712655927
1890544.59996276994954834887634
85760.3082484294936615029224526-263943.088839266544573267620623*%i
52339.0642360310574127169744957-161083.076350390866714530295728*%i
31829.0454700428425946227921866-97959.7292471534318573424341639*%i
19283.5090269601342376462544130-59348.5382712455948689835995512*%i
11636.2389490909036541889732946-35812.6610482545457618996672814*%i
6991.88812302070985571918020763-21518.8189699920216169507480441*%i
4182.28620211893260136087085596-12871.7533920166532706650569837*%i
2489.67525483291513528928818593-7662.43254471186665730249363655*%i
1474.49256838753634729909169473-4538.02150341357709174605153937*%i
868.485342691292466978016123334-2672.92304147899911025943021068*%i
508.555076971568221736098921993-1565.17158814228934074322056675*%i
295.930429795924395668099743118-910.780211932113596990208946818*%i
171.049234974355304173343527424-526.435414526994897279227685157*%i
98.1561477202455341044921079035-302.093559911141960782332498393*%i
55.8910996316506223336035664455-172.015117210952989875778104177*%i
31.5599872486025271120476418492-97.1316531884849190997377576089*%i
17.6609278409901595456232334664-54.3547468674555055092499272650*%i
9.78714488918315724312441528463-30.1217347013879228681240971688*%i
5.36677325714953575973727379918-16.5172297012815390290748921939*%i
2.90934330656386633561211540182-8.95403799860262777390234196572*%i
1.55763661637116144489775163832-4.79391257110688937751806328668*%i
.822697599934137791811634245204-2.53200285939088871982306943365*%i
.428125613445787710773796873737-1.31763515234515714992929941087*%i
.219201786101704955139778120272-.674633728404628606928827478848*%i
.110246136373954811318056828924-.339302718955298608895288630707*%i
.543674751064152316268828918928e-1-.167325883092799566465654043069*%i
.262343329874499228666453798868e-1-.807409747442483113388069472532e-1*%i
.123572538971874225503977442364e-1-.380317168840684717787287697151e-1*%i
.566633395420720493825930765124e-2-.174391827270006708308401543284e-1*%i
.252130802008641513192789772853e-2-.775978818556789297833008069912e-2*%i
.108461226054292183571422557481e-2-.333809329849138720478509225785e-2*%i
.449097972845403552047844275203e-3-.138218143760507750608754989632e-2*%i
.178057254217792623816817794825e-3-.548003879980729310455045611192e-3*%i
.671755218773165996217901750023e-4-.206744997782973371171238775855e-3*%i
.239329241295219745720674686951e-4-.736579665898941632073400042218e-4*%i
.797735858270393883320782432189e-5-.245517851801316247271608858758e-4*%i
.245892230985464518294304079872e-5-.756778471223258884397817478926e-5*%i
.690619971299223586130195996146e-6-.212550971611206643176819111060e-5*%i
.173396958542611770061042566034e-6-.533660964702856164679232516577e-6*%i
.379444541219802706489552513879e-7-.116781021778320363508643213453e-6*%i
.699103899980842565346890904652e-8-.215162056374605411597877559161e-7*%i
.103269204356026604572321795578e-8-.317829930143730047070364051809e-8*%i
.113749703913405851710402079826e-9-.350085591092848686060755245818e-9*%i
.833529735836833803312075103418e-11-.256534074573106123700759021323e-10*%i
.334259777898313884484751017021e-12-.102874581557749726575630705223e-11*%i
.502682576276360021720081177507e-14-.154709788943059683303808798429e-13*%i
.115580048412339936229561429749e-16-.355718812224577406134852550061e-16*%i
.154358788195184325746894364439e-21-.475067501246640644879494869652e-21*%i
.160511515600488670916378908841e-28
.216570237432076000454860260343e-18
.753123462824542275728581475221e-15
.120364489475819216265399346992e-12
.486850111270475030986896818075e-11
.902290755540065016401098371084e-10
.101129859218024077561996648008e-8
.798291638599516355866541948224e-8
.486914014913675849360776202471e-7
.243823417307605024749311013105e-6
.104516974998080202906711903475e-5
.395216904070024066267541327184e-5
.134807042312624998025564381780e-4
.421900571523675428352176772419e-4
.122770166383461672421804809462e-3
.335692087192933126314318658273e-3
.869866454633149088282326380489e-3
.215106581107982477013275790041e-2
.510565243827114066333240775602e-2
.116880895610642903078937182438e-1
.259121398400965054735463751860e-1
.558265224862998226020171373353e-1
.117233384689412399840573497269
.240577459129530664361041559818
.483531043411774236847519289803
.953695469109585680539781367501
1.84908793469137280319617805348
3.52960811581960295028094187495
6.64201597290202793331443892434
12.3366337920311072220988323667
22.6401759298864096070747394491
41.0926265094371118562741902512
73.8280475847830045396274283484
131.397679129847351707328041195
231.827960643751297189892262805
405.723435752391002080127188948
704.741019819078258039775097126
1215.60006784093438122750465482
2083.14791066903735828643795572
3548.18599481217765915656368282
6009.27649085446915319784004201
10123.3872563459906990324835250
16969.2552558209024065427543265
28311.7534754014415225189029359
47028.4960043055174254052600229
77796.4045836103336773591255334
128193.863264145146907025253449
210465.806479712392243621620589
344344.116691750751408329755388
561544.662376409450642753488138
912923.184746319759742512938418
1479840.21095151597173518635895
212396.391259872582394804071088
128971.869765596095814438295482
78022.8613803142283103079824850
47014.3452707466606937201271946
28210.8046715090810735739294742
16852.4702138778528646212115112
10019.6326163377755044768390209
5927.16468948502305718941408506
3487.42289546881999121505566505
2040.17542986649100835331813499
1186.21813047939881802682613872
685.186901997246179056788890290
393.003975499648990650011403302
223.719978403402657869975919444
126.324417835126842465220041662
70.7090276661569752127529971919
39.2075916955668301440901543612
21.5201210483471831436561210478
11.6824666216796370168950689789
6.26664865821634291854046335762
3.31815411569154287645072412159
1.73226576996810680912180198922
.890480313842398656669530448171
.450080213679365472103255510829
.223301876024104102806222832584
.108546408508448268392766911313
.515855575701649607896511717599e-1
.239090770944821052485268552021e-1
.107767646998524056088036978678e-1
.470843127448030175444215979195e-2
.198635471500370214685905118328e-2
.805496983230758638932449335800e-3
.312292630596522892513631318511e-3
.115013263534068242338977266709e-3
.399229732272848380865460149640e-4
.129362856138086181618390268416e-4
.386634082503828785242058211703e-5
.104975831133645231615875411544e-5
.253880715169944964594858312752e-6
.532833614620366249162831302958e-7
.936511371309643089548218099171e-8
.131073818042199848595712776043e-8
.135577292338861170008391245414e-9
.921526390850779544211659570876e-11
.336653912405942163939097086395e-12
.447960880257235518489290319941e-14
.862080733649730707380095215545e-17
.827966111404917218128837627202e-22
.160186336948705591597702014715e-29
.429102548760105107229183606805e-19
.189558213221840411429264111563e-15
.351404434692886586075426084127e-13
.158287582994917459049851906548e-11
.319178911813116498124290125805e-10
.383391815297055351607294247745e-9
.320913585822290138756299712094e-8
.205927876450822776696889684795e-7
.107826164863795976496291862218e-6
.480958095491293775579497887417e-6
.188494897906438299429262769095e-5
.664171146074714137453756738959e-5
.214121707012760350887009716306e-4
.640293124874970993054559368601e-4
.179536378311039828536273677681e-3
.476201847002274788914111037954e-3
.120340898252706684614792294482e-2
.291475926456564877290480529095e-2
.680021477158387979788325154841e-2
.153462107961904757569700584555e-1
.336198681864276405557780801897e-1
.717206764875547080153802513616e-1
.149383232490802131021499436782
.304490038904148371819489987777
.608606128675878766888278951929
1.19498679256789573085307369265
2.30852393264002081813339087979
4.39393512173221516609369914674
8.25007325688645147657092383485
15.2977051417303625563318813828
28.0406814601545726500771564173
50.8546397709840894656274462371
91.3272040166545471351320558820
162.521796600271762222059933552
286.780549586873758169349888483
502.080073002590915326731971060
872.603297811052164938170914676
1506.24617937034178366537961005
2583.48834661347295801469840107
4404.81985530170792422471265739
7468.36787112059538400011453546
12596.5208407415302576780799616
21141.8156718126891683256386052
35320.6952644223439480396230994
58753.0159623037007984188905831
97331.8049529977663792251184437
160621.873359850739253664353291
264103.468367873319927380720689
432763.371733998329380171795824
706830.309526561987861235356838
1150916.39621338459114922300478
49896.3690354321847683230215012+153565.233545170713190772300333*%i
30142.9263485987430292413117918+92770.3881853685248460070893816*%i
18138.4901296638950865792047812+55824.5324612823973639712369168*%i
10869.6261801745925939927833335+33453.2695499724783849564220439*%i
6485.09521269191216912573089500+19959.0707731159465379847815287*%i
3851.12949329562765483379580866+11852.5578410460286548027496269*%i
2275.63178156752320313358844558+7003.67447080315842886655266433*%i
1337.57886658882751781089267751+4116.64445737396904727496345285*%i
781.789823982166943868623585674+2406.10167080105431147776921378*%i
454.203495596591661907730163682+1397.89462092508285922751381930*%i
262.194123580273387506330330306+806.950537687101314978832509887*%i
150.318888280947777988172378708+462.633967788759103712748585931*%i
85.5481151194141668408492277201+263.290025539394368628805220089*%i
48.3038507710771946985273326966+148.663966300314452084680082441*%i
27.0441386218764794244095340313+83.2333002136346860850909208698*%i
15.0039314992489467257685912370+46.1773529681437012496629860178*%i
8.24269980092716051456141690284+25.3684214791912604383000632292*%i
4.48049675800127938731147215458+13.7895511104676328973108445514*%i
2.40767783298036899857529412987+7.41007042938547104362323264292*%i
1.27781426412361725900999376909+3.93270792426096786858463864753*%i
.669064924457467900854249140908+2.05917010330415351971667649257*%i
.345206771328399453136200693866+1.06243719703883727874269412609*%i
.175273837215757004943483824840+.539437403296470587460600423848*%i
.874429243258989977664882434531e-1+.269121648640280838169530868931*%i
.427917200216574387621774914787e-1+.131699372238067777267570018278*%i
.205012295277045334437127631893e-1+.630962966092674382115854181583e-1*%i
.959454998837830051728847375850e-2+.295289885458369143616913586347e-1*%i
.437514890714725267926384227919e-2+.134653237642174009384787129995e-1*%i
.193827480182768649325046290408e-2+.596539644810669748521076902651e-2*%i
.831418513394770210630507689241e-3+.255884307117780718258790209648e-2*%i
.343942363575180178653517951494e-3+.105854575011247756715526932417e-2*%i
.136580266694591521911257216334e-3+.420350838308949890388236007867e-3*%i
.517751098551541399008946432382e-4+.159347403236648115140944602541e-3*%i
.186122805559172822640589581323e-4+.572827094562336930548937053881e-4*%i
.629396105632580120065611861386e-5+.193708203266760861543601668133e-4*%i
.198241834025427203968430991677e-5+.610125628959486300990312052523e-5*%i
.574452247638831836746989965127e-6+.176798222545135457688053909988e-5*%i
.150766018117927356720553925979e-6+.464010091927011008007915973279e-6*%i
.351196195888733859026491603590e-7+.108087075040533160999955495836e-6*%i
.706866253343708404987123362553e-8+.217551063090068327661799620599e-7*%i
.118511342893122292386894575983e-8+.364740408990693945892039977205e-8*%i
.157149385216724591360127080166e-9+.483656075758725416363175858208e-9*%i
.152635075636280755636328385929e-10+.469762459481280897888679694760e-10*%i
.962293127038796836938373468831e-12+.296163371502419973011645954197e-11*%i
.320244431908384121725420496002e-13+.985611015956475230052664746148e-13*%i
.377027896939909575066845432022e-15+.116037255146776779925453585979e-14*%i
.607284631331556499619591239854e-18+.186902991222867452543406249030e-17*%i
.419438817219421871770634443489e-23+.129089994260847489129396853496e-22*%i
.158108021185534268037392013103e-30
.840882015133629531092548724837e-20
.471885485590890448426140753430e-16
.101471254330995268126257793890e-13
.509023759393408226103590252880e-12
.111680534881338300163269145794e-10
.143774230946611242242613433199e-9
.127617917125435728524098858747e-8
.861589167198851215212938400507e-8
.471762197116974913921828920189e-7
.218982069980496501398599887326e-6
.889565188025009576205145891340e-6
.323815059580327275414257806079e-5
.107547070463056995694869312868e-4
.330515492735942479441608854500e-4
.950456633314177053505811136262e-4
.258072185656311343549496553722e-3
.666544332345269031645021119849e-3
.164761705080084290115648001947e-2
.391787792320366171046931253059e-2
.900111286115379317303474877327e-2
.200538337142143732677451505088e-1
.434643201334757374749256023000e-1
.918954906786924426502535607183e-1
.189984261387246012039703670461
.384865846979451385184048579969
.765360224283124680516199383478
1.49654696409785258841712486956
2.88141770252212329586047155732
5.46976192901483411704067343053
10.2487916602955071245552058091
18.9741887913058929021753843349
34.7407749378252055605509029162
62.9595550508153133753675585912
113.019986789546502158622828816
201.101549164399073239179707157
354.903483213333152604650520916
621.561258877772220286041693798
1080.83459629003364868364733979
1866.98091392899299728908705968
3204.88528508742706135194854783
5469.50919037842934322947389076
9283.35496312578935847594164942
15675.7132063331945250560430423
26342.0259121575231742732399232
44065.0335251521816071448116420
73396.6785429574183928388561278
121759.249705114953613963875048
201219.002511382397371734348153
331336.069921882648130521231858
543733.349198329852493862191652
889405.349924572052505728639492
-98652.8676183881435622662337989+71675.5038344419278755186011187*%i
-59286.5778523722542596672807491+43074.2201496491769858767088582*%i
-35483.1247243564305056907812681+25779.9991387634451755227887739*%i
-21144.6509584271657539599244313+15362.4881611266499718446693553*%i
-12542.3376862837861576741757530+9112.54172968953096160658216600*%i
-7403.42716332287426956763752470+5378.90468714415888029579789720*%i
-4347.40934548449224231645294179+3158.57777614243434397101247856*%i
-2538.79550084927848795545820272+1844.54290127567113260715351336*%i
-1473.90080847566898478222593899+1070.85161941905778475034622772*%i
-850.320368246337756412193982812+617.793909960143630754323517655*%i
-487.288548032419632469338272957+354.035853555535884035273385306*%i
-277.254140494846097646797792224+201.436924135078982566477898277*%i
-156.544750772284286339666090439+113.736418972064596278321365644*%i
-87.6652282424211304217379666130+63.6925165454156082228348778964*%i
-48.6610213359224201001986358174+35.3543014567238784944150836234*%i
-26.7553512620953444018834601380+19.4389005436341744839842827303*%i
-14.5611927839167109714489163376+10.5793258160002658236583029232*%i
-7.83769258937945381429512900543+5.69441698761663130115263420810*%i
-4.16864567816336241916539869094+3.02869836937143136281988884070*%i
-2.18869318587395391969619594557+1.59017868029296970460123907601*%i
-1.13312182370816847723265172099+.823261194334977596501083915588*%i
-.577740142281615760968812649478+.419752783503462001878927343094*%i
-.289701134568115998059467011671+.210480194675140240153575187135*%i
-.142643430767079057558753321382+.103636518792871292810674369684*%i
-.688448943569279083354306479640e-1+.500187435863444064589090087292e-1*%i
-.325043597757420888853644660496e-1+.236157997226634224986363541456e-1*%i
-.149786084762743153763436574566e-1+.108825960683548677259121700823e-1*%i
-.671934549341465923539426270078e-2+.488189026132691551762430946618e-2*%i
-.292550522356054327119022560507e-2+.212550396081856556899403611955e-2*%i
-.123190460545105238457353543631e-2+.895031086305854279772407725324e-3*%i
-.499671813832906487882977053290e-3+.363032822795183932873238636298e-3*%i
-.194285267037395459475803254140e-3+.141156509067545908811029416951e-3*%i
-.720057349009942277305336212857e-4+.523152286658521904573730583902e-4*%i
-.252637839540655549253750875504e-4+.183552134609680604162703368786e-4*%i
-.832212812046300104482729813764e-5+.604638000302569128883672389106e-5*%i
-.254773365681706689398242670075e-5+.185103685170821432412533684099e-5*%i
-.715725573953571324693201422496e-6+.520005067858315588005339936078e-6*%i
-.181561737927993243009373377030e-6+.131912324063251024502963071844e-6*%i
-.407330383777229741409561412194e-7+.295942846762902336869675444033e-7*%i
-.786198845231165308334910546126e-8+.571206896529146309803977385145e-8*%i
-.125727842833609370711140322816e-8+.913466247729912481802752056202e-9*%i
-.157947205457723733795205705946e-9+.114755361944636735623134489101e-9*%i
-.144047227168613258565181713901e-10+.104656436579246779880674089922e-10*%i
-.842313388973314057862697210162e-12+.611976498997434466104012151909e-12*%i
-.255348178093566394585310609987e-13+.185521310833662841304232015992e-13*%i
-.265980469072761372202100342515e-15+.193246122400175754245584708303e-15*%i
-.358568592953975690406578258768e-18+.260515331988106731071065045191e-18*%i
-.178096831584724408718421378189e-23+.129394922249310674886056975887e-23*%i
.154390309245110691397118131176e-31
.163023058022414490574864747007e-20
.116218728718229229972062915243e-16
.289889808966683775820140929691e-14
.161955288331452930872784207707e-12
.386635241704878017911341561503e-11
.533479414508025281727752977690e-10
.502173970328203965277467790113e-9
.356720169042149649683585582406e-8
.204263344948448550022581466775e-7
.986748941867569910387990047604e-7
.415512008055684211795105245918e-6
.156269683361068235854075234771e-5
.534727115927267423105090315055e-5
.168903060232441266622109472408e-4
.498176894622280016444663717015e-4
.138485099335064851788433618533e-3
.365593332171187572703589260430e-3
.922372350209264625488727538159e-3
.223573162195351109381935212475e-2
.522970034485881056221597156168e-2
.118503242548082952871170279441e-1
.260975284952444067134730848121e-1
.560159406578327855367650472645e-1
.117472113326292405168809266397
.241214215711231147206211223836
.485889149329175482322899968806
.961751801714209766119035811575
1.87337042058696839780116438839
3.59577074582281189809937895530
6.80894666114014213961252056457
12.7334611635370500241905180181
23.5398902369694560378941473867
43.0552597494569650075369376798
77.9737862358187433473979287718
139.919124492323049519309460775
248.936850517664953027250693205
439.377547860999877022325604495
769.757580714361477103934089393
1339.21017994386843634426680228
2314.81209422688771090852300837
3976.79057787201503173838500846
6793.02421601314814153646357351
11541.3785642271636285132101016
19509.9104021419005082418975549
32823.4606327259682568023986954
54974.8218226498604681055048618
91686.1681960162793541875909532
152302.337890233045516625067379
252038.598542234908782936421657
415598.188267804277293266756964
682981.031812634100394360278845
-74016.8986200818941909185867687-53776.4246385508071203370946045*%i
-44245.6461114984128189359550370-32146.3435790786225776322804675*%i
-26335.8858611275133649862356132-19134.1410908042241696084271946*%i
-15604.6242673080631259109603682-11337.4231637438025484216015292*%i
-9201.70741743496277262814448320-6685.43176902887843191948023155*%i
-5398.40662323894479649381525523-3922.17199524890674242157805695*%i
-3149.97333156747686180158329496-2288.58958746650348935912548009*%i
-1827.43924812864977756895331541-1327.71233111160517191170029077*%i
-1053.68777336086918146594203466-765.548978585945651301992328751*%i
-603.584541749586390012230803265-438.529838827701786610467242624*%i
-343.344674352499490098105232839-249.454507681242374276608285347*%i
-193.856478599725375313245752693-140.844976032061616747704482124*%i
-108.582746602177693548820980356-78.8899832141116914909203418705*%i
-60.3008233345872910529917967392-43.8111126263157061116118637008*%i
-33.1814341038980248946790823340-24.1077230166893675432660207964*%i
-18.0791226324989578581793051619-13.1352514615347279131700353471*%i
-9.74631537238367569537867604955-7.08111260938914601026516369950*%i
-5.19422783827892856673556757185-3.77382742465899359276354626510*%i
-2.73411499828893084221950318763-1.98645082271421276705423822396*%i
-1.41997784029095192919595680000-1.03167428979658080934039857302*%i
-.726806419513936033616527722895-.528055773404179943377151989146*%i
-.366162523539413231549669941891-.266032645513147752394637512113*%i
-.181311693210953634202787509807-.131730655942418681983298299208*%i
-.881000179208631704257898399883e-1-.640084097375415259267105106808e-1*%i
-.419310510301303183587574757848e-1-.304646918173526732498659898711e-1*%i
-.195079053001550392980226690705e-1-.141733228328638206978984377400e-1*%i
-.885077807588717550353734603663e-2-.643046667806949234447062629751e-2*%i
-.390553619996962327009254762876e-2-.283753814394238074778931833922e-2*%i
-.167094886387309055852420888195e-2-.121401541172604085175949412442e-2*%i
-.690667933118843329830019556116e-3-.501799626140401949271748203580e-3*%i
-.274648951280155151257079766182e-3-.199544143377105121515663631616e-3*%i
-.104555271013372754286974991054e-3-.759638509183414715836539417830e-4*%i
-.378816447732700221296447255177e-4-.275226259585726678798501278952e-4*%i
-.129710715283297489115118439519e-4-.942403509913105582618037679529e-5*%i
-.416186447689323973682764612251e-5-.302377153825772326507783381784e-5*%i
-.123828952040340893266958064219e-5-.899669998556438634583973839033e-6*%i
-.337222639142706806326957438173e-6-.245006588743381767921406264678e-6*%i
-.826785621467334667273758890715e-7-.600694915539360701959814604517e-7*%i
-.178633866643037151339434455754e-7-.129785101058204721308210643132e-7*%i
-.330614642381168651916100163343e-8-.240205598071202599330651449674e-8*%i
-.504283164114446067196066259789e-9-.366383164886251931482110334070e-9*%i
-.600153166958043810427325615561e-10-.436036799112120572610486996109e-10*%i
-.513911575249490448957143692411e-11-.373378615052982042812450238469e-11*%i
-.278713311204020308098191469106e-12-.202497073710913788667911371653e-12*%i
-.769642699479642510686099834976e-14-.559178152540809720942335364426e-14*%i
-.709286346625519108518074681203e-16-.515326695356991325586500203518e-16*%i
-.800278352915027700937244404258e-19-.581436257634850595963563058867e-19*%i
-.285843844677086532009244201514e-24-.207677709526462168875984585309e-24*%i
.149192055897898284848091733912e-32
.312769694174433004792432972980e-21
.283258114915326138626997283930e-17
.819591808199615870235974418086e-15
.509962024591597845807362800954e-13
.132472189763259545333535173591e-11
.195916067468718128523276605063e-10
.195583238256222098818728758627e-9
.146187980555355867404129540361e-8
.875464300872349616683714100000e-8
.440161398920507130008599439018e-7
.192143295199877822163116849166e-6
.746653389195325834270300045489e-6
.263248045753403844673392495419e-5
.854706582550341705068304165908e-5
.258585910062752965530804045773e-4
.735991124273589825150583153048e-4
.198615999415333372132178262752e-3
.511497240646273653686140447470e-3
.126391199608862789125880805330e-2
.301042720583191310920425974713e-2
.693868129601937827192234261223e-2
.155282889679450001626067751034e-1
.338400681614456296778605377191e-1
.719944459092060347594783990052e-1
.149861033635618534111176277260
.305806215501618625712327419806
.612800502780655630250699692257
1.20773113039475643581322735452
2.34417715935567055802610334389
4.48650000822374658803726890598
8.47609155633329079122804076669
15.8226968436969518231900262637
29.2110291181821521387172100261
53.3755886638924752474508434368
96.6014504019033395291540613830
173.283345096336018051216181454
308.264721285942663965891989357
544.156222135759255197098082927
953.618832579282610448210321865
1659.88496530802910363876774499
2870.89492223390579000163470393
4935.85297003279115808903171423
8438.57174218148665785610426672
14350.9843599752692337783424057
24284.7567722905466431519100372
40902.3794151825843119697359294
68586.8038848899599331754946881
114529.130999185045539803287536
190490.585539238779964782914805
315649.507598610603954636737488
521190.378378396117127944896213
21074.7258737658258188700151711-64861.3368721704397335593907194*%i
12530.2153072201115985398648175-38564.0373682926975696575586128*%i
7416.70853120997041288488092942-22826.2817465321800359595401844*%i
4369.24218858480912722089393583-13447.1447537390409393382348384*%i
2561.06493521344959682396319475-7882.14738874324074922401684675*%i
1493.21482492844931699988070866-4595.64268414831664470653858006*%i
865.701680395497086278758854703-2664.35580985817419647173379975*%i
498.888866739592895913827329349-1535.42205204446389323669086449*%i
285.667832420137589299877672646-879.195184939996585499609547755*%i
162.464670250064451890650465428-500.014841001229523031567517966*%i
91.7273473274054758099379796003-282.307746778312311551772520022*%i
51.3884680291525759315347310200-158.157442053979722880610463947*%i
28.5512059705583993110591544431-87.8715765820873882505444566812*%i
15.7223805477320140219931966964-48.3885117769592629308366016993*%i
8.57562530594931130740907362481-26.3930608251036910813363579613*%i
4.62975471340807751770438471951-14.2489198626155736056492169656*%i
2.47203651759846962650251087890-7.60814609350885355686846042278*%i
1.30431189906393561169371811721-4.01425925909086544086165305137*%i
.679395867599935990923970252283-2.09096547693722113900956808221*%i
.348994948781106155389256023287-1.07409600842093118334461022698*%i
.176586848669757490303066390887-.543478437032570423766724562190*%i
.878960422689334416795394339719e-1-.270516202273956660485960814820*%i
.429746442045636423547288527423e-1-.132262354984349434965002301030*%i
.206047852973371427526898928665e-1-.634150084966452329211611764262e-1*%i
.966996679131077642130197056139e-2-.297610975986485858254477794412e-1*%i
.443264204747873367512064389440e-2-.136422694557161065907230997885e-1*%i
.197985208398820666118031507473e-2-.609335816493262075757320662467e-2*%i
.859279848751206633554433433069e-3-.264459144432803038222940518437e-2*%i
.361231333431455416527815961759e-3-.111175572801385507369600260885e-2*%i
.146548731766434554242680315377e-3-.451030619151467720665059195086e-3*%i
.571285469323957477739775833418e-4-.175823588396578217126574096004e-3*%i
.212910382445588437365550306296e-4-.655270778946474600923641066823e-4*%i
.754048651644690633849298312703e-5-.232072312139606192916035212473e-4*%i
.251957590575008038915989414600e-5-.775445728579045030066078281845e-5*%i
.787376511361019815847478654216e-6-.242329572657429456348450053418e-5*%i
.227666873119189502795837440892e-6-.700686587359096765704640948025e-6*%i
.600989160336644995484182740348e-7-.184965444478887107567196751903e-6*%i
.142401111293704232236617475689e-7-.438265555904094566585874593164e-7*%i
.296283070357098398209368535805e-8-.911865527981779067462098113812e-8*%i
.525792162869550118472976061001e-9-.161822188363938394380835905825e-8*%i
.764888892775743665929367911193e-10-.235408595306411389461001465289e-9*%i
.862331039301403144365821942858e-11-.265398204325315488719427036857e-10*%i
.693293251144255591629653218267e-12-.213373722548138384772082850363e-11*%i
.348716603316013339535645512683e-13-.107323934916536763482513303046e-12*%i
.877131834091321297580836176621e-15-.269953420571519525056924108248e-14*%i
.715161041666126316359882131647e-17-.220103936436494242036096499134e-16*%i
.675326898963606887135999418787e-20-.207844247915190861556889743863e-19*%i
.173461116629611210299058083738e-25-.533858422990990999551037289593e-25*%i
.142707405879149446321839744336e-33
.593987661214188408912760040274e-22
.683392868991845622066107204064e-18
.229377882217214005060644477280e-15
.158957092181155552946588137108e-13
.449324486797039213967687444623e-12
.712278474354556600720451453169e-11
.754143874268655163983094508482e-10
.593145130040527612574609828229e-9
.371513160328104472778289405099e-8
.194414945969794969387712379063e-7
.879844725624885908655968416275e-7
.353289874712496674281284219179e-6
.128350179668371650756926797511e-5
.428378044790904889766705362168e-5
.132950688393589884334148778714e-4
.387473360991434393248344199394e-4
.106897253146825600271223613384e-3
.281031156444173154560510361809e-3
.707989846621153682205508622200e-3
.171724514432502413651236951160e-2
.402640192808217175971068180842e-2
.915762066984934329582627259147e-2
.202641123055184152642611163800e-1
.437403635024480540706652688565e-1
.923074045973245841249213267880e-1
.190836088175617071073990742015
.387189529815161633388940081014
.772162422279223188909714954772
1.51573791193163091486638401508
2.93233830440538849795665076715
5.59714783754208848262838844081
10.5516819326626512466368913160
19.6641660645460468550665537281
36.2566281625286866788967538324
66.1886046138659927234293356975
119.717995270201086180752801504
214.677408521462048619835263720
381.865937959052434901694662680
674.154253278808015345426908005
1181.78595437341353960101834600
2057.97528171848351048583589313
3561.54732989710900755905734415
6127.68307852977224458759204167
10484.8513437253821898526165618
17847.3951056353111870946891650
30231.6571709554437663354167155
50973.2493373052346548456297056
85570.9126117843555069701607886
143059.264783267269423467868413
238235.908847223620776139528204
395265.412714250942809089514364
50512.6747055968132988389936236
29868.8836166476327167150907693
17579.7020253361881833051070219
10295.7968202069352882548513147
5998.42607346122747677372598094
3475.41398342232030160351648265
2001.79547175502658197396816362
1145.82095985178525438982777445
651.514956632264236673730875712
367.836257770978388464491592349
206.111792160707296811787106485
114.563646427489731737353328343
63.1311729476954662537035043803
34.4690068339206783312667188495
18.6342191349974633055211242047
9.96718410556127030480577083051
5.27062459062005150176927643509
2.75291922250333312838395140374
1.41885906805952018598103287333
.720817978419837584769156858941
.360516838242940466433596704374
.177276495581917378477387929044
.855744625363572714486833890166e-1
.404822722765074546797480960945e-1
.187317582718713084284342892849e-1
.845939104618861465525170045206e-2
.371936750313774534024070783424e-2
.158757747218723463063159129984e-2
.655716411187492641024982866526e-3
.261075506048544790315062130490e-3
.997616420412912274912496471523e-4
.363955179616307695451885284285e-4
.125990051111646473369172621872e-4
.410783412036792105797752264746e-5
.125020086517970958880741905634e-5
.351277902240938102379847574906e-6
.898798004128672612361315260718e-7
.205803795215465157356853586917e-7
.412330352482418253298200789100e-8
.701583654382176857449821586464e-9
.973364648473555589605848151538e-10
.103949273386025990080652158076e-10
.784631134540589695442044282059e-12
.366011179071260862371189240118e-13
.838564807086055593848698038588e-15
.604886414353280269534066465130e-17
.478045198743782340459178615392e-20
.882986569264347829287862891239e-26
.135155075226522460926254232930e-34
.111690710297940625588443734140e-22
.163248717402794240590458643974e-18
.635628886744066418733163521089e-16
.490602247374387888051128519066e-14
.150908897252007553327018913755e-12
.256426670540525752857094730877e-11
.287956529931257787610356435250e-10
.238330267097479476066301414270e-9
.156134841456665537116291913485e-8
.850472356083176839686423261028e-8
.399047547866001617606487507891e-7
.165580030660149691752649192768e-6
.619899053531730886006369973715e-6
.212696676739055726883543781303e-5
.677222465892619798879836537443e-5
.202115322235722443750771644584e-4
.570087258621947218005309151353e-4
.153011345776167573516642286680e-3
.393035491653666223172052853493e-3
.970886574433914890551430647568e-3
.231594181496960976181687840442e-2
.535366312643893113567015334080e-2
.120302014146862245525347511110e-1
.263484373823467893583266502364e-1
.563785589107998905961875240716e-1
.118098714521934776284591307468
.242627293023646790101538570106
.489665904779492283293619216343
.972191732708071679389446176471
1.90132316107763147742365445637
3.66703171809805173573850621112
6.98201532796316707758872068834
13.1359999184694335460636812748
24.4417256719742124363323706482
45.0114547610449293511279256516
82.0998794271742768615637206768
148.412068727336337654245203738
266.046844852418425521921441449
473.197802530889480041241339412
835.482430082245229123580551245
1465.00433365187931898054332599
2552.28335604203311671838455879
4419.51472182451227522051414544
7609.05252199416589240163921472
13029.8645852733837713540838654
22199.0844440046954877579927102
37639.0814099883325696578530325
63528.1174144225582053857510294
106763.358259538772301835256016
178692.652154015648830621353001
297928.233560593266066833922068
11488.0705275573013634141494357+35356.6455365713346792492720036*%i
6755.44445357478521811452997082+20791.1201810689918904656215514*%i
3953.22907824124483712288919911+12166.7880527855809967009541566*%i
2301.54354577126811275579743498+7083.42268091219117580168351204*%i
1332.67472628401057578618514161+4101.55106549383631573173635131*%i
767.229349066486874338454336847+2361.28913685961252555373969489*%i
439.004925911005331298453689146+1351.11823321514294226750375827*%i
249.569418931891179802301262017+768.095692029075498198353732063*%i
140.900356539512722065958950249+433.646707703781861611375186759*%i
78.9655010302005082543240910887+243.030822525443616804576289089*%i
43.9092827946748741197686095712+135.138876786343462560147105278*%i
24.2124863047559266171532408626+74.5183704942286007623876688903*%i
13.2323280545122978494444825901+40.7249182118747481707553823005*%i
7.16264721501980287247278642188+22.0443614162606247254376414081*%i
3.83753205014948905941750447931+11.8107092141274814163921092752*%i
2.03349586390082054251508653887+6.25845674324152505375132173306*%i
1.06484489930985087201337969572+3.27725561625096838253434256170*%i
.550532811226640708590229823782+1.69436576978704363303622105895*%i
.280733321628296934757212569879+.864008322311934979280055003312*%i
.141036350042513623330196507991+.434065252669130528852609966048*%i
.697192088381770897217201946096e-1+.214573661266141054700509364492*%i
.338651936598448281582405269447e-1+.104226349010156196014800538391*%i
.161382979962352089831059609192e-1+.496685740610414823025932498747e-1*%i
.753190306991094372107522309892e-2+.231808140818646631873182441347e-1*%i
.343587167412439152435176227191e-2+.105745256872994168863249335632e-1*%i
.152856043234356023052855646802e-2+.470442527820126306626818642265e-2*%i
.661508327766690636084736668682e-3+.203591329007187533291974774373e-2*%i
.277669745266456146750353042712e-3+.854579603778218328834789883671e-3*%i
.112668946755102847056067705325e-3+.346759362579055219409131165988e-3*%i
.440223067020747925249480587529e-4+.135486728605455411735254816700e-3*%i
.164877964888030765594628226489e-4+.507442198178851759975585598622e-4*%i
.588782188804499881636891858801e-5+.181208524946562107919308253646e-4*%i
.199203550877127863651339664029e-5+.613085489081389435899009441848e-5*%i
.633711819617023387620140886583e-6+.195036443454868667765937078070e-5*%i
.187819852414523762607589537538e-6+.578050067730865552078569606367e-6*%i
.512788844109063022906944821682e-7+.157820178356159068782635755975e-6*%i
.127165204328963016628010977667e-7+.391374255864776743305083652445e-7*%i
.281371297114636509742215581120e-8+.865971808963363664977713239355e-8*%i
.542809773726110444969450950404e-9+.167059670441467452332013402823e-8*%i
.885498968974783591947928246352e-10+.272528559899935193636117951885e-9*%i
.117159460028162006017985763615e-10+.360579741353016356303683053888e-10*%i
.118515967005841055573536202003e-11+.364754640546282526054056399732e-11*%i
.839861335406940946708847123810e-13+.258482740549196590393430758528e-12*%i
.363326667568125067474543588108e-14+.111820450339116458085925572708e-13*%i
.758192627796236581408546512519e-16+.233347696857612175498324420682e-15*%i
.483846098318656860594538313501e-18+.148912517132180927485461856459e-17*%i
.320023523207187852438335684448e-21+.984931128883584704860443065093e-21*%i
.425070577870427653266355528602e-27+.130823271964938677271171879251e-26*%i
.126767462739560383898483788447e-35
.207992648519284928463475703318e-23
.386210872705095780397753897814e-19
.174444598436295814611754516122e-16
.149964933856828568525049643373e-14
.501985527473453721809857855844e-13
.914347783030258453418984138729e-12
.108905528868783762523210518699e-10
.948560916098922396995738663489e-10
.649999152048391308304972756463e-9
.368552680827894655960983473537e-8
.179297983310200058912549688689e-7
.768850588501832456500132554698e-7
.296639799325734977296165193375e-6
.104642096908088104574532177709e-5
.341833066651658557002159203242e-5
.104479149517178647845026994856e-4
.301315454527149595367587768588e-4
.825717492553601579697399512851e-4
.216276639015403720109461620279e-3
.544143095313425682744730049121e-3
.132063476283790088633558057637e-2
.310313617306290710925302179172e-2
.708169258417472346671415293520e-2
.157392549150869152104636192171e-1
.341496795860233524791876738636e-1
.724876159077476168395841837068e-1
.150809498979810212893246086695
.308037273269679219649862686236
.618630406190120776293813282032
1.22317532537197547140476551356
2.38392635117704980208816201201
4.58468487509675676939104029285
8.70882402486559112262918262488
16.3540045430873300824590873142
30.3843171446276195819840062745
55.8921440485861718496047222875
101.862781877493277984915913851
184.037656747436959568770193753
329.811011924272607621311671101
586.559450810552698785968498430
1035.73990512634649433337790213
1816.63847460220616695681331166
3166.19963885396520397620384684
5485.54553590849583961592731747
9450.63426856394191855424740520
16195.6632871828861891829493865
27615.9743767850797339591084924
46866.6667004990464852215414405
79180.7891174521449034789050559
133207.946040712965710814513147
223198.141812078433444421906932
-21996.7840185923726106788544822+15981.5990688560236472714751632*%i
-12862.3843755475566761452218485+9345.06926038697698669077167056*%i
-7483.27792030719270921928653453+5436.91965798668732659418198457*%i
-4330.56153653030990356151250133+3146.33712643351135221765368381*%i
-2491.96955724728171843329415505+1810.52186183483994529008922780*%i
-1425.41429805533100747001726101+1035.62410756410715744969469773*%i
-810.179858345808026370172028848+588.630122421588543457072747425*%i
-457.396740756206158709135318181+332.318184330426705973856801346*%i
-256.384198878205616913847656589+186.274023993600719451973151182*%i
-142.618460362105493820652785638+103.618376731716482175733849655*%i
-78.6917213044650836716542089105+57.1728821296393769173662787008*%i
-43.0441924510460378459915719207+31.2734363993322595852029607111*%i
-23.3278350785965516481073915910+16.9486642708956751885431336137*%i
-12.5177727353298091203861879883+9.09469424812310078338232526324*%i
-6.64606048805136752085350619771+4.82864558826538312438881260118*%i
-3.48857579562554304884629089680+2.53459867769209524485964736687*%i
-1.80886927032062216334818704281+1.31422045248995733884982582704*%i
-.925618331617903060509039854998+.672501082621775753899730671430*%i
-.466949713655060783000536194534+.339258825410327245408694648651*%i
-.231963929036818238359854066346+.168531659408466060129905477803*%i
-.113325047882041241683967333283+.823354667745468121841225332234e-1*%i
-.543707512478539008507562193072e-1+.395026630611664030922603258681e-1*%i
-.255766521347037859406186312580e-1+.185825254998613986821501114979e-1*%i
-.117755270368724338152122847193e-1+.855542118196477453442067508729e-2*%i
-.529535270144312546512256135605e-2+.384729893838650540526000980040e-2*%i
-.232054475740028551425620364142e-2+.168597445439119032110922875242e-2*%i
-.988394194755031304152766057003e-3+.718110416923143452936111019930e-3*%i
-.407958811815462564137212801972e-3+.296399426458469461477805618449e-3*%i
-.162612062087765522237985553023e-3+.118144578673409865108105308157e-3*%i
-.623457507772269193006494086014e-4+.452968393800786392343297347914e-4*%i
-.228853222596423683236867466426e-4+.166271598887379242591134193813e-4*%i
-.799881815167700348562723850626e-5+.581148156097457830332215425679e-5*%i
-.264479759474981743687001326315e-5+.192155793055203034624407854502e-5*%i
-.820874235431792785521267491631e-6+.596400042185082515075461837502e-6*%i
-.236909125773020656544525927468e-6+.172124555146670424792943558420e-6*%i
-.628461977047988981168025120124e-7+.456604353559693004642555080738e-7*%i
-.151043766692653034709514209457e-7+.109739720092332063263183014653e-7*%i
-.322932496394316774111248865166e-8+.234624192305408998160699866046e-8*%i
-.599838688865112901957690897485e-9+.435808317403480245560449150211e-9*%i
-.938127385808861825627839108551e-10+.681589442476630989465079241606e-10*%i
-.118365970203117557837587581131e-10+.859979112211802504126722260193e-11*%i
-.113413423664556912889850818855e-11+.823996755389901999141479184037e-12*%i
-.754515744166637960815232239058e-13+.548187776186675270122274305714e-13*%i
-.302696500229944605092411034967e-14+.219921880495439256082491847106e-14*%i
-.575334368274954293244442423290e-16+.418004886374852593198332999740e-16*%i
-.324811408114607320985805598274e-18+.235989301576567793612782946572e-18*%i
-.179796164683099213122002216056e-21+.130629560014527087899778907397e-21*%i
-.171731805627888770530844972827e-27+.124770460199811569258885596167e-27*%i
.117780241906832961653124789741e-36
.383680491117224117101784923591e-24
.905094278292187137003293570278e-20
.474255122398435264609311960126e-17
.454107500223311751940632185045e-15
.165419463574505419225947894645e-13
.322991487765224492795509519826e-12
.408055062222935008491023928945e-11
.374036058296046092627456605656e-10
.268105821975011272291697238215e-9
.158248475155081859677556903375e-8
.798267754122142252279728101316e-8
.353770698212619165158751586726e-7
.140672380307909958199597157866e-6
.510210819658716885533572335568e-6
.171010269409196665656004209710e-5
.535321404030874199785350933847e-5
.157865210812999327227659512428e-4
.441728821835704683317726359722e-4
.117987578866252888137638090446e-3
.302370841065762981941081311381e-3
.746713636202999016086858118869e-3
.178361750508062347972569252760e-2
.413416471879663053516227100712e-2
.932472373133353359632593388598e-2
.205172053265117801376367156955e-1
.441344935510321854098427448055e-1
.929930505619722044731421755157e-1
.192254589708072421797915154727
.390587268141129516626182781593
.780847991310713900880367240629
1.53799022948680577836765040446
2.98784658700221446772369522357
5.73077645798009648513764931578
10.8620370261122549588018432690
20.3614172449054880451892701127
37.7770536901281299869188966441
69.4172876529786840765816545154
126.414685503712074672329649109
228.279015539791794380744397677
408.978976407353672007141034294
727.297698560458336827920583878
1284.37821653622746215681234630
2253.31296993700413401435237394
3928.82675228735014726152530548
6810.35421325591900019492013481
11740.4177310954829591747400156
20134.2688467727060219329591759
34359.6582156665382312864893425
58362.8118166721788647285531383
98697.0069795193518838733667471
166207.672106214404875827187245
-15988.1093531627293090522183068-11616.0413874730045775050421915*%i
-9295.72241587055618994585287578-6753.73766366269452219672276829*%i
-5376.42695514645567115249316853-3906.20283162827092499092097953*%i
-3092.42153768559561224062462590-2246.77576164831802430722749135*%i
-1768.30774097436048274945676239-1284.75077641896074434752484031*%i
-1004.89404179462233283240895817-730.098257502989688796411177962*%i
-567.313477963433236267653505227-412.177368451066377859444622687*%i
-318.046327697746578718627404577-231.074182948342229277842403171*%i
-176.983072692974340078759342666-128.585729048510130938089665902*%i
-97.7104004018966233566283206149-70.9907613204100030355435226156*%i
-53.4925821643245563171998240294-38.8646358752028421884135541805*%i
-29.0232754732673435981947465706-21.0866439333436427058019125925*%i
-15.5967441249518093697321644998-11.3316979051952478232539516480*%i
-8.29595458330580914092176645990-6.02736381517266283624588536756*%i
-4.36442150796083704398361498290-3.17093783567483583663580182817*%i
-2.26917177201370886104085119046-1.64864979571724445750360033567*%i
-1.16494788992391288012792219370-.846384184939830544291948419324*%i
-.589961017728998977382462994986-.428631769245442449635688091512*%i
-.294410343739328045809013610297-.213901635411298671682612237120*%i
-.144604202803306339362728858740-.105061103064914081190256393515*%i
-.698127657614415131865950628224e-1-.507219433233638201860281490289e-1*%i
-.330808905421738079567678036456e-1-.240346738431795919278136139925e-1*%i
-.153601211726673744523954627664e-1-.111597812672584225947132280127e-1*%i
-.697567433949783061751664496913e-2-.506812406916087990154432762767e-2*%i
-.309206566292714438300637761905e-2-.224651720350165957105069703298e-2*%i
-.133462507933561207139738949531e-2-.969661879079850927543922341484e-3*%i
-.559440312821517963763158288569e-3-.406457179145455569872257802497e-3*%i
-.227038825763878056998579548929e-3-.164953362425856623854236986434e-3*%i
-.888925625079264976133275286477e-4-.645842270853834804987335894110e-4*%i
-.334405935223300894881252883333e-4-.242960133557133988733186693579e-4*%i
-.120296866462915998653911796145e-4-.874007894710903056883475678400e-5*%i
-.411500779065240783751160859652e-5-.298972816298235524677734165575e-5*%i
-.132963788405798379410563467902e-5-.966038469615186481331264027851e-6*%i
-.402605854018682343098378462934e-6-.292510274968490752827900343695e-6*%i
-.113139710102487793692718376600e-6-.822008109956551497947556891507e-7*%i
-.291600394354059935862603813967e-7-.211860087681358869306339259873e-7*%i
-.679177208913892205526839699061e-8-.493451126327924368842754650844e-8*%i
-.140303379451678339161705862519e-8-.101936371994517784785376001041e-8*%i
-.250914613926038460346657316500e-9-.182300137915313112620250749508e-9*%i
-.376202914310543491136503760834e-10-.273327416406166426001421917254e-10*%i
-.452633420644611256278425624232e-11-.328857429694849767834333793216e-11*%i
-.410778582630767319817129136094e-12-.298448109875016716229506606735e-12*%i
-.256550055146322837322326023191e-13-.186394525625924139704410640647e-13*%i
-.954442763639236270561904656431e-15-.693443258330873858752962083470e-15*%i
-.165228398255308408132110920149e-16-.120045458166688330853697072946e-16*%i
-.825224618869638099690220939598e-19-.599560780765807302413939311830e-19*%i
-.382288389466057395590913289787e-22-.277748772909767314820807485029e-22*%i
-.262572924234029476857677337144e-28-.190770396158751863228752058915e-28*%i
.108422969905678438387120431240e-37
.701256908719551857174373979167e-25
.210161133028921041026453937627e-20
.127750143557369940284096656553e-17
.136247995394008952406608198877e-15
.540124818263031979731874099541e-14
.113056210400132687990137842166e-12
.151504235396719496768852958454e-11
.146155176866670717005867223703e-10
.109589587976002312417916575186e-9
.673391939188399134790194895853e-9
.352233499345278715617032027917e-8
.161336522224209214073040975330e-7
.661215001393629062611836678883e-7
.246588181793164437812413697013e-6
.848078215433704850826672701567e-6
.271914671749087834097366259665e-5
.819998591295429666454528830644e-5
.234299451840323840276430599015e-4
.638241213865637743550680997870e-4
.166617277447205875778055766206e-3
.418707773743747049338662519834e-3
.101676629825599365985602693682e-2
.239381487209446015451575912910e-2
.547991652951232889015544274006e-2
.122284239031009370018640186754e-1
.266592614447993736924863171946e-1
.568935672681819723326084516909e-1
.119062916964183851160677176407
.244718567763850528828920212782
.494700201270887318445726759433
.984799846386790363814174709707
1.93275414918029588907512313884
3.74345624775931357944794363247
7.16208592485714745960977112713
13.5470030555210378464107347978
25.3523110916903723134150690636
46.9750406325961947307768898231
86.2324659890410726200166382477
156.922074715582232761405107914
283.231546632418156390092527699
507.293832836020255916464752468
902.063396274423725970804297745
1593.15464778256041768347620550
2795.71086114144864392158537027
4876.37964379220463061393834261
8457.06708608800970069282360869
14587.9651545238724645324248748
25035.0520672943709493660394594
42756.1504596796655472650243115
72686.6289752840750620683263892
123032.120322221614189071413373
4411.53011818510318772953080293-13577.2936184910920632746528126*%i
2550.16520465134237266210623974-7848.60146743259737452419239601*%i
1466.18254616238443999132730796-4512.44588481766659963040248484*%i
838.135306653292663835282371965-2579.51523521217146263400727661*%i
476.213974143272215229850085112-1465.63590839355069544255911069*%i
268.841597051710796119487796150-827.409357353953459537854391269*%i
150.740287164527713548413290202-463.930900195337102598209616449*%i
83.9111208127443898235729278052-258.251875111307177785040915122*%i
46.3522669854198431997724084646-142.657609011778662955102316637*%i
25.3963504785106720888483057058-78.1619297720451646008804542817*%i
13.7939932745927177805024347772-42.4535460131201721495436014280*%i
7.42294882000147152295462872498-22.8454873806130022597821597127*%i
3.95510225028529635274196330353-12.1725530835478552648759964653*%i
2.08514305622500852630228249900-6.41741045679900252453441378906*%i
1.08688874786833209535004108905-3.34509960605539048478682356991*%i
.559691021168047761352766779620-1.72255184175370686139285606578*%i
.284467920525615361782198041576-.875502235856164756745578986789*%i
.142563354504305887038979917832-.438764889162381737110764338301*%i
.703712136714705578888218185859e-1-.216580325807727057233558552982*%i
.341716794470890269722269859876e-1-.105169615271935863980415568731*%i
.163017722177909965054732431139e-1-.501716959814762695008132348568e-1*%i
.762862771405639266364489657468e-2-.234785019267902461543378771295e-1*%i
.349598512221249775680178254532e-2-.107595358568430206497611292799e-1*%i
.156596843932539964288852178607e-2-.481955528544780716417314654301e-2*%i
.684165055577537939724154752606e-3-.210564352826158079799158488571e-2*%i
.290840493721614100410811362387e-3-.895114999470934364031355171559e-3*%i
.119969832583454392552808822393e-3-.369229178699768883916153611925e-3*%i
.478682747572125777539484006325e-4-.147323401173254900589030483648e-3*%i
.184082181329073577053822516955e-4-.566546698963799556190731882469e-4*%i
.679431035324461282228313362364e-5-.209107371206403254246045784066e-4*%i
.239512063972464140717434364663e-5-.737142336242919011376706560916e-5*%i
.801795784405682990557580421152e-6-.246767368584188930866360278472e-5*%i
.253160593736119037967940176237e-6-.779148191603166140875177266718e-6*%i
.747790555181441343843499361175e-7-.230146268093706491108376851760e-6*%i
.204607059705394166843121444271e-7-.629715779245125780792179054155e-7*%i
.512326272532688943009635248426e-8-.157677813463621897673019337501e-7*%i
.115635538327750557588395537327e-8-.355889592623715922882360901463e-8*%i
.230798183772852686444232794079e-9-.710323770607657427608873996649e-9*%i
.397380702192769363285271750896e-10-.122301204512982838999610726258e-9*%i
.571156171510245470383947356971e-11-.175783794621312797348568682822e-10*%i
.655274758668030887175375396830e-12-.201672833707908584074215571182e-11*%i
.563241420934938491668207405220e-13-.173347884866665731940222686307e-12*%i
.330223164818188250758171924961e-14-.101632239795484831076717086297e-13*%i
.113923667599253154565173034593e-15-.350620996264847257680605324140e-15*%i
.179623210594471748930117297205e-17-.552823398141169263731100409718e-17*%i
.793633796278286786590928312093e-20-.244255366935158213684807899260e-19*%i
.307683682942163842017722682909e-23-.946953005648547992085586650759e-23*%i
.151967017071113317649816203501e-29-.467706386633396152812460903140e-29*%i
.989111125363225658230006296521e-39
.127016725617654915556660465077e-25
.483604833707112882305824123578e-21
.341032412481042330425989911505e-18
.405129251456915050725760257759e-16
.174784412536532071624183997550e-14
.392201860134765364933502291317e-13
.557513360878123072125612098733e-12
.566048698286146132595067298366e-11
.444004371492686215950312009420e-10
.284033035538653006503330519112e-9
.154065182769955660860080843026e-8
.729383599141295607952002940105e-8
.308113788522220528476877143634e-7
.118155206141719857318071537989e-6
.416996415906899271234960634321e-6
.136949116112117320708778920956e-5
.422352713835462860592876257912e-5
.123239599626831044682609118135e-4
.342393694530914227250531385635e-4
.910588686024208911359133828571e-4
.232873759507847274680619872414e-3
.574942394074196552030218036650e-3
.137501968107509382564778296766e-2
.319491871537011917309756199647e-2
.723108490919693070422599829579e-2
.159783512822007213188644751362e-1
.345400719647893259452610096173e-1
.731741194264332955774249923216e-1
.152170663425258911529181840082
.311076342520419451394639488097
.625930198366738986885634353151
1.24111705773923010747505914623
2.42763916969763056770116673871
4.68871764114325024820003076689
8.94950252332948676651081358868
16.8951277145431093734931075355
31.5685759475026982428308349750
58.4206043960934025665483612486
107.141443633020149115018950437
194.836741849643404260855193301
351.502540434911449609320013006
629.412459661391193012520525686
1119.13072214971911745569533112
1976.69691426182354437083352141
3469.56814217931449298409543383
6053.93000591032588901777803121
10504.2702913697242742856090685
18129.7170341532168068605040348
31133.9346295263342154469468689
53211.7894022297717810742568167
90535.3345250252104440377585308
10250.1904440162205299419041874
5890.80017855371388391427792432
3366.45695743226231564723309434
1912.44915628913913883760502583
1079.63265624679495810527149171
605.440159228294949651932078192
337.134210691495713555864218636
186.330662624450060300181507300
102.167806796041956686266265768
55.5486644968294300532738760016
29.9313287886105668326685960864
15.9739979698860637094420554254
8.43832083835647052776689509355
4.40907228575611547262704962088
2.27694540555625175854822718529
1.16119627973675995140056682396
.584256613617081006256650766136
.289736555705926688483495312196
.141453978221951020421479681466
.679043148552668378426298796435e-1
.320072323787846437879999331489e-1
.147909786846292854100695919880e-1
.668950546856595923346096534481e-2
.295527518232993204744552090889e-2
.127250713146160834543114459895e-2
.532730007787106502443488049678e-3
.216230597425211052170941428932e-3
.848189632546470140744669530732e-4
.320351725697221111610711935946e-4
.116000003835424639971765102864e-4
.400695785735180778474068259273e-5
.131263866597976058928147651085e-5
.404969362365623466089924360017e-6
.116686148157616058975050466631e-6
.310844265857065989894817098037e-7
.756136710486742572154360010490e-8
.165376770226978505581928342004e-8
.318898698709146369906491345603e-9
.528598925111382463683545534167e-10
.728300075408178162129132019332e-11
.796725382116146304971045776081e-12
.648600093514446145126692874711e-13
.356966513104921460134840506433e-14
.114196589301805234215161608373e-15
.163986329546763741289334396739e-17
.640958108699032191594506491419e-20
.207957798257386711790592383785e-23
.738590644894258642186279689572e-30
.894397371506044641080355315535e-40
.228038207543690877232297756357e-26
.110304930915879627127801968190e-21
.902403754228933205883198325840e-19
.119408364338345381915965091360e-16
.560657164243404647794223724617e-15
.134871798004628760587303731237e-13
.203373283272752074541439720789e-12
.217327647656837717155332752671e-11
.178337160417713812870741364643e-10
.118774451602617213859222683054e-9
.668112568927192054864719670804e-9
.326941498422933147001950079675e-8
.142361029553494686403145394576e-7
.561393114263992343202616773952e-7
.203322580589536704243851935214e-6
.684017298785212903681518892459e-6
.215746700221017827317221137932e-5
.642928056478861127725194693265e-5
.182191060997951791676580534256e-4
.493642999463624064612410727135e-4
.128483533697613768808342170528e-3
.322533224390738440783852339949e-3
.783617912009660436744735333322e-3
.184821911303767370901641012016e-2
.424302280485880169127559875048e-2
.950355961834429849412350117474e-2
.208106525443521226497050027278e-1
.446347452017322456129478692619e-1
.939208296401627411469312057490e-1
.194174158708099996131122745467
.394944513428869507126553785698
.791250304949817394626389524071
1.56312360348817363062436977864
3.04788953175146371268402932431
5.87107833008446494624729323201
11.1815329878441502243948174364
21.0703268528268928680813475275
39.3117241151995713869366790153
72.6647725540744466078602461752
133.145048807898397910528287048
241.965809389001166989691375621
436.336682725108919914930504272
781.129438274233410660509794402
1388.79490920112305605378479456
2453.20659085592610084502976581
4306.91272781131491323459826852
7517.57983187508245799751750599
13049.8082595662991653279844189
22535.6057055756779643571586994
38724.8628054800104380919297164
66233.0735153786837641972864036
2260.60577458140604144428904396+6957.42917647250529393086679734*%i
1291.52161492637813811923931726+3974.89481216491102023521934368*%i
733.584911709440590451097370846+2257.74220588830708456220744270*%i
414.122243115502747696240320937+1274.53721001467072824901646059*%i
232.264639851134783611033927688+714.837058337776822718411010435*%i
129.374663070453639217881940634+398.174270659530386452094721782*%i
71.5400680971838850734765428751+220.177689831099399506480560486*%i
39.2547058246694985155334751604+120.813561873242844809972449211*%i
21.3633371654035076357243714836+65.7495910930866189410160024587*%i
11.5254267294744874104059856334+35.4716161042232528149352443098*%i
6.16044449453587515830655331021+18.9598986025149882896201738940*%i
3.26039102350179949143262649955+10.0344517777854630052354897112*%i
1.70742638147165055327413707090+5.25491806519401302301993881163*%i
.884127435526025053561665706380+2.72106445308342258377796285349*%i
.452319209727580613853485109455+1.39209538532669559064988862992*%i
.228431723401012791106952694875+.703040554479868153097311276265*%i
.113772181449738746292355951126+.350154769836376694331914909921*%i
.558250968258263754459549012695e-1+.171811981462060330297938433266*%i
.269547250736590455172771688459e-1+.829581136082854640241630656271e-1*%i
.127907794119439684216129183235e-1+.393659712237801203911151545689e-1*%i
.595661047922689011050238671538e-2+.183325620092821964350716680363e-1*%i
.271803238821682427800188747612e-2+.836524353472405729115957176489e-2*%i
.121309677074214794589702566404e-2+.373352796031357134182523573196e-2*%i
.528518252889549984515674714159e-3+.162661192601479528882189593014e-2*%i
.224273151363822749513948643713e-3+.690241785782851006446826233878e-3*%i
.924587997155803100560127477642e-4+.284558925751625521908466445547e-3*%i
.369251856080390224872220115841e-4+.113644035853002298780844340527e-3*%i
.142387168511895081328899388309e-4+.438222644434058116241288680549e-4*%i
.528138772726950026813661719396e-5+.162544400616567681069581061468e-4*%i
.187607421215381294635592747489e-5+.577396271726482380593143504109e-5*%i
.634974218623995446342489186051e-6+.195424969918979097072951260522e-5*%i
.203542919711103198522619714437e-6+.626440693103446699449571718879e-6*%i
.613555745469583126990402829589e-7+.188833041697102605625143873567e-6*%i
.172441534299592287320754472080e-7+.530720471239096974129704894633e-7*%i
.447225858124193134257428321513e-8+.137641966094790476406620074261e-7*%i
.105680666491994594444998214487e-8+.325251647460120202004980803332e-8*%i
.223965007200908408600602223525e-9+.689293415565572890163581500695e-9*%i
.417232228163472850534119413374e-10+.128410875979766950448295341227e-9*%i
.665785193466145949238597781923e-11+.204907612922579847534673134932e-10*%i
.879304342470505093193741589239e-12+.270622049898818451130981732285e-11*%i
.917178241378676311639555296118e-13+.282278437414650287474998911434e-12*%i
.707143108382369626630980066663e-14+.217636270309535493677914616985e-13*%i
.365329607596235254714306249197e-15+.112436891894162864340413128467e-14*%i
.108372956999676981224152429418e-16+.333537665632907488892229218734e-16*%i
.141734065440945382377877242954e-18+.436212599864517626289208613827e-18*%i
.490066478954040125273244731509e-21+.150826953439829209111322016491e-20*%i
.133063193720234021000314605724e-24+.409526400716725807676321267670e-24*%i
.339834975552265719318646535370e-31+.104590450961356292317438737911e-30*%i
.801789830679054697503568582311e-41
.405882336474907010473683730294e-27
.249429589347285385378893130197e-22
.236733375769839007971947847117e-19
.348927773261594252554535730440e-17
.178303398327205998461631732257e-15
.459843185235365490475419210984e-14
.735564484367860977397363251190e-13
.827326729815483689165298330601e-12
.710250417843370463218522531825e-11
.492501844555395881149066229678e-10
.287304493357874207690930661466e-9
.145328256024585359735023985721e-8
.652313933539359659916079456189e-8
.264537745290751367562982929781e-7
.983257324452336207307611663710e-7
.338864626743034187855660820909e-6
.109317163374573651560126053419e-5
.332716817092283916708456257320e-5
.961732895275290040863554223513e-5
.265495055453887946857887387918e-4
.703322427554377853170191982479e-4
.179528199849957558491188342289e-3
.443135457559166907091640572101e-3
.106099406492474544097933466046e-2
.247082929228067520572203729045e-2
.561004234151461758221525111733e-2
.124452616780779225259181786401e-1
.270255885969471314662276684886e-1
.575453672521130070335760624916e-1
.120327375256682648081811140024
.247415026979559302429255226914
.500871344061030577735254935500
.999413125356725155769499624119
1.96751618310241046031807968474
3.82509462176266734710395480367
7.34983969283972975369924006634
13.9686818403768617000155523591
26.2770803530138415660322674643
48.9576161962428174865342695491
90.3940560312241579478792036758
165.489634180968808601084766904
300.558987132179627966197603118
541.772427050495338595406734370
969.656014789971957844074770832
1723.86772697784418347163115769
3045.33546167227217914420889301
5347.60813989375491015121379837
9337.16994664990198045854121117
16215.5180610745875577587973899
28017.3003903904916819668141692
48174.1156783306189121168471023
-4198.78556525693180051239115623+3050.59627913418941018273966828*%i
-2384.55388962122381427241746359+1732.47981113042023378913547867*%i
-1346.10091858834568455976255240+977.999564341515158426275560269*%i
-755.072558988027198039848643990+548.592325834638260028161184787*%i
-420.710123070864709841655775346+305.663796373352548399193749031*%i
-232.750750001874001811807870819+169.103318301505292226671826429*%i
-127.799917102817354326488775358+92.8520748507564773076772065990*%i
-69.6152630789466976762805571910+50.5784492251361967889257347267*%i
-37.6010456572358730634227169399+27.3187587674531476231049224641*%i
-20.1273458374745983705319250891+14.6233727267969722403242446850*%i
-10.6712271558293706658121606104+7.75310035471572813133521785835*%i
-5.60030999880804058982079301748+4.06886338414769341973786150408*%i
-2.90726234609071993005631136512+2.11224973450354807702867497688*%i
-1.49179351122264719006828846666+1.08385142890569579511757311451*%i
-.756020446299165803717453807985+.549281006277937106671280368483*%i
-.378070857664681451111709575086+.274684556692852632533751495917*%i
-.186382230201168868216375263251+.135414616705634351937875219257*%i
-.904818988389261317432969167258e-1+.657389475211587196973166380123e-1*%i
-.432046876992350006656684063909e-1+.313900430226843164506212818175e-1*%i
-.202648430328248678166966830058e-1+.147232702867004039559971673032e-1*%i
-.932325318937975605655937917277e-2+.677373994144601161387877372251e-2*%i
-.420049450695842724816149428016e-2+.305183789795820769553967443079e-2*%i
-.184993370098832060276546241212e-2+.134405550775836783269287975786e-2*%i
-.794790975783035182659452575995e-3+.577449444781253944854259972184e-3*%i
-.332351195600504841362147283212e-3+.241467277837194962356329710519e-3*%i
-.134916405766774373319914327414e-3+.980225065151893030542084788221e-4*%i
-.530123092906943072916687625761e-4+.385156972074631218360604605593e-4*%i
-.200942099978391818366917996804e-4+.145992981301006764760397064699e-4*%i
-.731923334584887837558955760981e-5+.531773429815417997577476189203e-5*%i
-.255043165152711679716433116693e-5+.185299705960539907143106010615e-5*%i
-.845755803260568951485850851954e-6+.614477559376138409087548176159e-6*%i
-.265271847132064416334425480316e-6+.192731278423981723006212679847e-6*%i
-.781246256011374989370348816297e-7+.567608629837227753567843948909e-7*%i
-.214163382257233110017763103247e-7+.155598805151348595492875986540e-7*%i
-.540718804078135782781811962203e-8+.392855206854964212959752666582e-8*%i
-.124117253809671018564211217231e-8+.901764633519613911113092811274e-9*%i
-.254864457222820205359514622965e-9+.185169867049381950565362510625e-9*%i
-.458679860067925901863044267883e-10+.333250425078896066848628902128e-10*%i
-.704584818444237927667496453638e-11+.511910835186674849816381738042e-11*%i
-.891959793670114199264115538651e-12+.648046723372224863059255797536e-12*%i
-.887081090984977628271049095606e-13+.644502138389979196576288909093e-13*%i
-.647725252173285218550052545912e-14+.470599942166888517918901084671e-14*%i
-.314112820585758131364520080617e-15+.228216322747271076547597979791e-15*%i
-.864020020781841978067839373060e-17+.627747290146083919984738844941e-17*%i
-.102912745064350582200303669867e-18+.747704859630244981535596738697e-19*%i
-.314777333933624356000188943166e-21+.228699119954923109180446639597e-21*%i
-.715253747169030668420941054485e-25+.519662265633494778868958484593e-25*%i
-.131355954672704474637330174915e-31+.954356873764643058846082205875e-32*%i
.712712912869369631221675394002e-42
.716337835166124598501151237604e-28
.559279586912450193320819263598e-23
.615815155309065322173228163799e-20
.101105437808531502917106739269e-17
.562299245079779479325123040143e-16
.155472280329151851152664375367e-14
.263823009278720498645123220888e-13
.312331733034791619076206086709e-12
.280524921434209285730969890623e-11
.202533877646746397210285915853e-10
.122533880402718229699009286880e-9
.640720079333720773350747950573e-9
.296468751248417464129365898468e-8
.123647281319874168845692501833e-7
.471678237827705074224615558726e-7
.166534493965873582884662783723e-6
.549508061449099215872144656021e-6
.170825326741358297235398224847e-5
.503699429449237221963353023026e-5
.141682006370445655970513556830e-4
.382034164838014715361665199851e-4
.991649558878850565803274970608e-4
.248692765638269336067075743195e-3
.604497707579585432435049241578e-3
.142810617088175411936687316670e-2
.328719100145233565243016572541e-2
.738805765107827510082440183714e-2
.162448019416605520484542831633e-1
.350046285931204573822855191021e-1
.740344453863280979007120364869e-1
.153901306056999364450212417860
.314843485652052980987779823793
.634575164281621006556307741948
1.26140282164000842525018689866
2.47521532227641096053118513311
4.79878114275414590360181954318
9.19911689889621524846287491216
17.4489215438740509305526436818
32.7704837424681558024140563891
60.9748307388487204533229814640
112.463844905043907877764782333
205.727485548983407179068172628
373.417316916170068969086227448
672.836843609023572791239425069
1203.96767098519552457743662469
2140.29480876309428246755945927
3781.27741404255550313627170394
6641.27704974934396794138138009
11599.6555143019572806859228102
20153.1307264106514023516510702
34838.4870303430466553955188022
-2961.33535605203412151244237896-2151.53607585770035112791544750*%i
-1671.67031115502742425585370889-1214.53957385808185852111798476*%i
-937.811632363669613885612777391-681.360034170334637781780062653*%i
-522.675424441760942106001166924-379.745924200191986960152668936*%i
-289.293291865007024878703754971-210.183879606594906921144583711*%i
-158.950004666122676609477366997-115.483938216588678260075147322*%i
-86.6585186811016541487880843835-62.9610992357673880607617433369*%i
-46.8584984330652510438768073155-34.0446919100944693457054651682*%i
-25.1173283439169403720509092808-18.2488072317301184111858399092*%i
-13.3392096234019165248560855788-9.69150308137986637274068502467*%i
-7.01458633638947206956868161851-5.09639528975226982696310596943*%i
-3.65015272971457688796061802736-2.65199119185249746291430654475*%i
-1.87825346383689041396643775106-1.36463101985088004352453695806*%i
-.954995708798698613759059224296-.693844996504877956976132693906*%i
-.479393382699646540221764884815-.348299680175642635262869372641*%i
-.237372901031175596035494749040-.172461507595156653392639188483*%i
-.115820466370406760088266166489-.841484944315152121673898992524e-1*%i
-.556259784954531026008917898811e-1-.404146390388583381926331077756e-1*%i
-.262652823084533132820256959163e-1-.190828446071581511833667659954e-1*%i
-.121763301838016997253979921795e-1-.884662171356726748592845172692e-2*%i
-.553394235184280266517425753262e-2-.402064446614380214046116284533e-2*%i
-.246159904145765228923434024887e-2-.178845639051621585074694956699e-2*%i
-.106969641565554459266286288467e-2-.777179938028652665997125806933e-3*%i
-.453171373498555407257819451103e-3-.329248275321302049961583395386e-3*%i
-.186727031066908818462739400837e-3-.135665129198287492418560732614e-3*%i
-.746354465723647432504482286041e-4-.542258260314949276120832460450e-4*%i
-.288515428128723712252871113769e-4-.209618728521191933603025382184e-4*%i
-.107494025368654843314527631260e-4-.780989809368148850256265719064e-5*%i
-.384478559736910067959282608556e-5-.279340024755114801371791961825e-5*%i
-.131414340852597148293942240567e-5-.954781074192041047734104315003e-6*%i
-.426949449297069244914273168998e-6-.310196932222789339471881129515e-6*%i
-.131022812395592296878712100596e-6-.951936453442657617785419167333e-7*%i
-.376982661958892545554729055553e-7-.273893936233804183163018949971e-7*%i
-.100792432275042398349259220682e-7-.732299885489184321324068842972e-8*%i
-.247728676802034617747384427158e-8-.179985419103173231891069017398e-8*%i
-.552345670174909903686388522592e-9-.401302619541694305709208044553e-9*%i
-.109891377881794152610577194832e-9-.798407594922311239510264725448e-10*%i
-.191051725096378203864859254147e-10-.138807203331307870378447979123e-10*%i
-.282505786144841865864988328749e-11-.205252468041815264670117157934e-11*%i
-.342793811224826757093324351115e-12-.249054282191878086968274273995e-12*%i
-.325044305163590367120268979820e-13-.236158511187300924314961588766e-13*%i
-.224767431478726422480651610765e-14-.163303097879825625762663247723e-14*%i
-.102314281080090448963715593122e-15-.743356764269799804450999855093e-16*%i
-.260956832488663224691320589508e-17-.189596236776584870410478236742e-17*%i
-.283073810520807558627561768779e-19-.205665161907898046644973964628e-19*%i
-.765918592431872750675772001992e-22-.556472430391760498229532877289e-22*%i
-.145643002123036145311758031254e-25-.105815834948760823566034847638e-25*%i
-.192334331651151905910274710141e-32-.139739071540049402237831814881e-32*%i
.628302699776975283111389767215e-43
.125382500270193411880999949687e-28
.124369487894862084731518504055e-23
.158872676092835156369618194434e-20
.290554093732283556187635714782e-18
.175871675338226239735178179230e-16
.521344921035379071307181434083e-15
.938519718161355591987062482578e-14
.116951339314271694444375597829e-12
.109899062598307783176701530532e-11
.826159547994626746799141170834e-11
.518395807625311380091784432499e-10
.280216964125748609500430392244e-9
.133667692192803968828938104901e-8
.573357224101236103567239765237e-8
.224485274548136137440891761732e-7
.812018825885829326730060457051e-7
.274072335951973547364324148678e-6
.870277075446877580422647852488e-6
.261781764312149027145083252876e-5
.750322244009367451619651146167e-5
.205944128212259717613819984226e-4
.543636354543386313861245934178e-4
.138528888569980654902317140091e-3
.341863911542316467128946411014e-3
.819373589700644711316865458438e-3
.191211796415083114336859769235e-2
.435426698398569644849053458454e-2
.969482832914249504434214502322e-2
.211424444499416657054106970080e-1
.452320447134808642131847028791e-1
.950670715508774169567111062852e-1
.196545688327689176293736716158
.400175204250101406933139233939
.803243505754538930767811579287
1.59100156614775144613246241571
3.11243085046813638982419641704
6.01840445954199225316298647104
11.5115380086158409707437795767
21.7945238913981063322956556631
40.8687938507616996931936430077
75.9475808085599949035947629244
139.940054214010432072879385840
255.792130693313362233266854613
464.028709043397620411802168361
835.788435895550995360707615193
1495.23722214145270221864308933
2657.92486584122175040570894619
4696.12902841768411630473091061
8249.69838381535039883949806154
14413.3131628482411719458587956
25051.6278484435943358217506730
793.128362396362199502471232364-2440.99810381405225428283028121*%i
444.999940998827175318165798596-1369.56899245604948758855462855*%i
248.080748117889746797049516223-763.514034372550004118221164188*%i
137.368871028763772229752671034-422.777912885576877308557840749*%i
75.5231022947545412579432090605-232.436208608968653735378938629*%i
41.2087151458543143199868164021-126.827384192540344527907611577*%i
22.3061115750221168874539701046-68.6511523728399315070419350653*%i
11.9722805057350029888484788400-36.8468906149448356785807764437*%i
6.36830927175633198696882604380-19.5996406053249899002956809059*%i
3.35523795501923013802764740873-10.3263606174682479822720317239*%i
1.74989413644107275199625867962-5.38562037552419628098726753124*%i
.902826558424769297049135771045-2.77861443578850454484595390106*%i
.460458791857311692774827410352-1.41714644324685481994708725124*%i
.231970625229862701819569086709-.713932174378198919528318854572*%i
.115335151671382675678213907135-.354965097556625372728219601595*%i
.565421851102842619113296355279e-1-.174018952269837612604031910448*%i
.273037359927913075238654400308e-1-.840322587683932304785224868328e-1*%i
.129724545299787806994832261148e-1-.399251097436702331142000302930e-1*%i
.605667895987315825997920959378e-2-.186405411247573563809272387355e-1*%i
.277500529592370986034671190429e-2-.854058811483854416541485059411e-2*%i
.124580253592630562555205695423e-2-.383418595539157300234383395254e-2*%i
.547085404486954233358228250999e-3-.168375574281836355391195775607e-2*%i
.234563088839099913975345668049e-3-.721910956949074226576487196033e-3*%i
.979808007824107932982619683452e-4-.301553897527273886428850071295e-3*%i
.397796329713381237317963723943e-4-.122429121510761252301043023232e-3*%i
.156546832737744596868184585603e-4-.481801609913884549390805356015e-4*%i
.595327327788472531239017446462e-5-.183222911596511766760905071921e-4*%i
.218006000267454041516489760426e-5-.670953478028567193807026047817e-5*%i
.765642983725217545042867155140e-6-.235640680636484250817390218884e-5*%i
.256682992402560437138835854456e-6-.789989019990240901830191254319e-6*%i
.816980246024881403980166168374e-7-.251440665338816575735577726874e-6*%i
.245293178985497949076768815171e-7-.754934778745049863865327544190e-7*%i
.689473588999329837327798369031e-8-.212198151418037433683113573277e-7*%i
.179785395268145609802313095015e-8-.553322551241317446060591974027e-8*%i
.430136977117782234598228692114e-9-.132382549320572706218523081084e-8*%i
.931533253358668149898468947986e-10-.286696455819327729344724525784e-9*%i
.179560402240915772642103378512e-10-.552630093905432952723847079078e-10*%i
.301557384822101291998407303871e-11-.928098198780603777890199740254e-11*%i
.429225377697577635780955198477e-12-.132101987867766486233344654821e-11*%i
.499197166821602539720003470624e-13-.153637090213137475449257808312e-12*%i
.451296487921974160616532265421e-14-.138894777126247045974524313958e-13*%i
.295533062294776943894575232681e-15-.909557240515623616050684163813e-15*%i
.126272355764308253111945097725e-16-.388626350536148222794123711358e-16*%i
.298625989945049651324846205776e-18-.919076293026542067363860738851e-18*%i
.295011046896763792609444165180e-20-.907950642319006552856249995214e-20*%i
.706098369746878853876462190454e-23-.217314732819625404755649195941e-22*%i
.112361962918208945193828563166e-26-.345814563478067964470074376804e-26*%i
.106699469755407879525716259564e-33-.328387201491547692663457341047e-33*%i
.549409934703338869125024098605e-44
.217685882735934188392042192776e-29
.274331362634915146736440030697e-24
.406563723127153287288235543009e-21
.828257333940845150937094325849e-19
.545653208614114721690473766287e-17
.173419406792596875909908667868e-15
.331195012885951780288722000746e-14
.434424714081289676359945163460e-13
.427118717780965199837669928688e-12
.334329976797829614522543090272e-11
.217583603963190430308430703226e-10
.121589281535215396914042185375e-9
.597950503639045982822512837353e-9
.263800000227927220098326464911e-8
.106012525899402541538376575271e-7
.392893426250584698041040140016e-7
.135651142252420638799335167655e-6
.439998439602447560518796156950e-6
.135026062055635509503465304924e-5
.394379129733239269195838451068e-5
.110192738781277225772531654504e-4
.295827883169286889035396044027e-4
.765988861292209024832825164397e-4
.191929547533722239608963917082e-3
.466722728405544001954196000786e-3
.110429702529994510462616656419e-2
.254804816422927767613027633132e-2
.574513536963534317903884385986e-2
.126807890557550284708296748191e-1
.274439813768669647525591218077e-1
.583221822125673227431816641604e-1
.121864063494411066837030601183
.250661828838206806813291049972
.508088363049203424458137529235
1.01590839559610129327817716579
2.00549937077739537259603312685
3.91199568493646289503307164210
7.54583915762924918483890029886
14.4028668098800619136048754608
27.2205916476356216607832922232
50.9690881315730745185903285949
94.6043048014497891110382948114
174.151061788076212214357984368
318.092231606744977242326871822
576.736886609749052664490031659
1038.41976279142844395370475107
1857.37454047230863628962620800
3301.46825395907044801208635665
5833.58515180325494343807482152
10249.7948668664835270545498299
17912.9850941739960165569222071
1789.31253446832828065275346761
997.770776283957001810177232347
552.721651092865880416334515926
304.056867698721672579715444846
166.037282034255596417223167571
89.9654741808975153854625858599
48.3468896667979082735797768477
25.7555674101329766418102122551
13.5942147738141647778981306465
7.10508535721769186720952024713
3.67491786049339406970908046662
1.87973717420858806370483606701
.950167576944256257424436963565
.474253776072263911439923831471
.233534467983661798124523344363
.113346252159276560807139071260
.541658498603135374274156671526e-1
.254569931587124746062997573541e-1
.117517192113669712577521477965e-1
.532107917848354181091898083100e-2
.235953643295380041332549546505e-2
.102289376581107069013962769611e-2
.432684588628180314617942975627e-3
.178199937096080669815184374063e-3
.712817333736126847914455778942e-4
.276174560219173669897164109572e-4
.103314123590919013922888578806e-4
.371832296619605784541945321294e-5
.128219210081059332715517173258e-5
.421602114795400310189907253121e-6
.131455112173452487550740718737e-6
.386131383646161453983179483890e-7
.106024453701051418236532821003e-7
.269621794529913720363162546312e-8
.627905448335332535501065951048e-9
.132076817094411335662795836017e-9
.246651184340566344908678498338e-10
.400129507402635824475981148891e-11
.548203828518743753707222135962e-12
.611079960197895766909645718791e-13
.526692912546232651175087592240e-14
.326622004608837067969063619126e-15
.130990188858605124854821173924e-16
.287235452017259741467819574158e-18
.258417970616181380446615512899e-20
.547128442433001191503438253307e-23
.728597136427375694059273118889e-27
.497513015918646688592474054161e-34
.476614814111514743479014940246e-45
.374945384807901952776486932884e-30
.600321333842566632685011221387e-25
.103218694198535665997722649568e-21
.234238801362297110373745145017e-19
.167957349632268541241438245645e-17
.572320419652691707048219336255e-16
.115958325022699064833828421220e-14
.160107469720114479256525173982e-13
.164703242327108081074320037610e-12
.134244957431535301766459953150e-11
.906182328485270042379004056799e-11
.523522615383475796409844507964e-10
.265435434079958953914218323572e-9
.120446935937379536585049943792e-8
.496838800942591409740642785994e-8
.188664793426424825628024795363e-7
.666359264203071320640938857436e-7
.220796181609100591851180247901e-6
.691295128536971343434758374899e-6
.205763940465331759313789524393e-5
.585285810260599709345208051688e-5
.159810015245299368540139246474e-4
.420496325945723846000137589000e-4
.106982304653058674553487974047e-3
.263962241924138064786324597762e-3
.633268294875428746166061230423e-3
.148066208320194603796694014735e-2
.338097218572800651923513138760e-2
.755343111946130468393371526056e-2
.165379202422799573229815365485e-1
.355382848467563075039921107348e-1
.750538837151839105823109477462e-1
.155968922428946162325713750927
.319278492799393635868262635033
.644471172939425814927605273182
1.28391714222273596106951035327
2.52658351509497098504225539572
4.91503541529856856633788477601
9.45849392468006821043212213351
18.0177801357824742434736409726
33.9957139628892926526635787878
63.5668113893444543537056126520
117.853338732704915204952666883
216.752486420228681214054449879
395.628655482760001608327540462
716.951991123011371306475916950
1290.43463133451514551709119686
2307.69921898044384567575944946
4101.69161866552381275108168960
7248.05213115407440558725128802
12737.3567826580867929260742345];
besselI_ref=matrix(besselI_ref,100,100);


