//filters.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011-2019
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROARDSP_FILTERS_H_
#define _LIBROARDSP_FILTERS_H_

#include "libroardsp.h"

#ifdef ROAR_HAVE_LIBM
struct roardsp_lowp {
 uint32_t freq; // in mHz (0Hz..4MHz)
 uint16_t a, b;
 int32_t  old[ROAR_MAX_CHANNELS];
};

struct roardsp_highp {
 uint32_t freq; // in mHz (0Hz..4MHz)
 int32_t  a, b, c;
 int32_t  oldout[ROAR_MAX_CHANNELS];
 int32_t  oldin[ROAR_MAX_CHANNELS];
};
#endif

struct roardsp_amp {
 int32_t  mul;
 int32_t  div;
};

struct roardsp_dcblock {
 int cur;
 int32_t dc[ROARDSP_DCBLOCK_NUMBLOCKS];
};

enum roardsp_clip_mode {
 ROARDSP_CLIP_MODE_LIMIT = 0,
 ROARDSP_CLIP_MODE_ZERO  = 1,
 ROARDSP_CLIP_MODE_WARP  = 2,
 ROARDSP_CLIP_MODE_NOISE = 3
};

struct roardsp_clip {
 enum roardsp_clip_mode mode;
 int32_t limit;
};

struct roardsp_swap {
 int map[ROAR_MAX_CHANNELS];
};

struct roardsp_agc {
 struct roardsp_filter * amp;
 uint32_t target_amp;
};

struct roardsp_speex_prep {
#ifdef _SPEEX_TYPES_H
 SpeexPreprocessState *preprocess;
 int frame_size;
#else
 char dummy[8];
#endif
};

enum roardsp_responsecurve_mode {
 ROARDSP_RESPONSECURVE_MODE_PASS = 0, /* pass:           o = i                   */
 ROARDSP_RESPONSECURVE_MODE_LIN  = 1, /* linear:         o = -(1-i)^(N+1) + 1    */
 ROARDSP_RESPONSECURVE_MODE_ILIN = 2, /* inverse linear: o = i**(N+1)            */
 ROARDSP_RESPONSECURVE_MODE_SIN  = 3, /* sin:            o = sin(pi/2 * i)^N     */
 ROARDSP_RESPONSECURVE_MODE_ISIN = 4, /* inverse sin:    o = 1-sin((1-i)*pi/2)^N */
 ROARDSP_RESPONSECURVE_MODE_COS  = 5, /* cos:            o = 0.5-cos(i*pi)/2     */
 ROARDSP_RESPONSECURVE_MODE_ICOS = 6, /* inverse cos:    o = 2*i-0.5+cos(i*pi)/2 */
};

struct roardsp_responsecurve {
 enum roardsp_responsecurve_mode mode_pos, mode_neg;
 int32_t N;
};

// filter:

#ifdef ROAR_HAVE_LIBM
int roardsp_lowp_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_lowp_uninit(struct roardsp_filter * filter);
int roardsp_lowp_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_lowp_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_lowp_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_lowp_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_lowp_reset (struct roardsp_filter * filter, int what);

int roardsp_highp_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_highp_uninit(struct roardsp_filter * filter);
int roardsp_highp_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_highp_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_highp_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_highp_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_highp_reset (struct roardsp_filter * filter, int what);
#endif

int roardsp_amp_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_amp_uninit(struct roardsp_filter * filter);
int roardsp_amp_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_amp_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_amp_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_amp_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_amp_reset (struct roardsp_filter * filter, int what);

int roardsp_add_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_add_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_add_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_add_reset (struct roardsp_filter * filter, int what);

int roardsp_quantify_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_quantify_uninit(struct roardsp_filter * filter);
int roardsp_quantify_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_quantify_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_quantify_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_quantify_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_quantify_reset (struct roardsp_filter * filter, int what);

int roardsp_clip_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_clip_uninit(struct roardsp_filter * filter);
int roardsp_clip_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_clip_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_clip_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_clip_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_clip_reset (struct roardsp_filter * filter, int what);

int roardsp_downmix_init   (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_downmix_calc162(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_downmix_ctl    (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_downmix_reset  (struct roardsp_filter * filter, int what);

int roardsp_dcblock_init   (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_dcblock_uninit (struct roardsp_filter * filter);
int roardsp_dcblock_calc16 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_dcblock_reset  (struct roardsp_filter * filter, int what);

int roardsp_swap_init   (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_swap_uninit (struct roardsp_filter * filter);
int roardsp_swap_calc322(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_swap_calc162(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_swap_calc82 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_swap_ctl    (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_swap_reset  (struct roardsp_filter * filter, int what);

int roardsp_agc_init   (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_agc_uninit (struct roardsp_filter * filter);
int roardsp_agc_ctl    (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_agc_reset  (struct roardsp_filter * filter, int what);

#ifdef _SPEEX_TYPES_H
#define ROAR_HAVE_SPEEX_FILTER
int roardsp_speex_prep_init   (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_speex_prep_uninit (struct roardsp_filter * filter);
int roardsp_speex_prep_calc161(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_speex_prep_ctl    (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_speex_prep_reset  (struct roardsp_filter * filter, int what);
#endif

#ifdef ROAR_HAVE_LIBM
int roardsp_responsecurve_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_responsecurve_uninit(struct roardsp_filter * filter);
int roardsp_responsecurve_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_responsecurve_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_responsecurve_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_responsecurve_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_responsecurve_reset (struct roardsp_filter * filter, int what);

int roardsp_goertzel_init  (struct roardsp_filter * filter, struct roar_stream * stream, int id);
int roardsp_goertzel_uninit(struct roardsp_filter * filter);
int roardsp_goertzel_calc32(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_goertzel_calc16(struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_goertzel_calc8 (struct roardsp_filter * filter, void * data, size_t samples);
int roardsp_goertzel_ctl   (struct roardsp_filter * filter, int cmd, void * data);
int roardsp_goertzel_reset (struct roardsp_filter * filter, int what);
#endif

#endif

//ll
