% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_comparisons.R
\name{get_comparisons}
\alias{get_comparisons}
\title{Create a List of Possible Comparisons Between Groups}
\usage{
get_comparisons(data, variable, ref.group = NULL)
}
\arguments{
\item{data}{a data frame}

\item{variable}{the grouping variable name. Can be unquoted.}

\item{ref.group}{a character string specifying the reference group. Can be
 unquoted. If numeric, then it should be quoted. If specified, for a
 given grouping variable, each of the group levels will be compared to the
 reference group (i.e. control group).

 If \code{ref.group = "all"}, pairwise comparisons are performed between each
 grouping variable levels against all (i.e. basemean).}
}
\value{
a list of all possible pairwise comparisons.
}
\description{
Create a list of possible pairwise comparisons between groups. If
 a reference group is specified, only comparisons against reference will be
 kept.
}
\examples{
# All possible pairwise comparisons
ToothGrowth \%>\%
  get_comparisons("dose")

# Comparisons against reference groups
ToothGrowth \%>\%
  get_comparisons("dose", ref.group = "0.5")

# Comparisons against  all (basemean)
ToothGrowth \%>\%
  get_comparisons("dose", ref.group = "all")
}
