% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wait-geojob.R
\name{wait}
\alias{wait}
\alias{wait,geojob-method}
\alias{wait,character-method}
\title{hold up R while GDP is processing}
\usage{
wait(.Object, ...)

\S4method{wait}{geojob}(
  .Object,
  sleep.time = gconfig("sleep.time"),
  show.progress = gconfig("show.progress")
)

\S4method{wait}{character}(
  .Object,
  sleep.time = gconfig("sleep.time"),
  show.progress = gconfig("show.progress")
)
}
\arguments{
\item{.Object}{a geojob}

\item{...}{other arguments passed to methods}

\item{sleep.time}{numeric (optional) a number of seconds to wait in 
between checking the process}

\item{show.progress}{logical (optional) show progress bar or not}
}
\value{
invisible return of .Object, unaltered
}
\description{
keeps R in a loop while GDP works on the request. Checks \code{\link{running}}. 
Will drop out of loop whenever !running(geojob)
}
\examples{
\dontrun{
job <- geoknife(stencil = c(-89,42), fabric = 'prism')
2+2
wait(job, show.progress = TRUE)
check(job) # should be complete
}
}
