% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchtoolsFuture-class.R
\name{delete.BatchtoolsFuture}
\alias{delete.BatchtoolsFuture}
\title{Removes a batchtools future}
\usage{
\method{delete}{BatchtoolsFuture}(
  future,
  onRunning = c("warning", "error", "skip"),
  onFailure = c("error", "warning", "ignore"),
  onMissing = c("ignore", "warning", "error"),
  times = 10L,
  delta = getOption("future.wait.interval", 1),
  alpha = getOption("future.wait.alpha", 1.01),
  ...
)
}
\arguments{
\item{future}{The future.}

\item{onRunning}{Action if future is running or appears to run.}

\item{onFailure}{Action if failing to delete future.}

\item{onMissing}{Action if future does not exist.}

\item{times}{The number of tries before giving up.}

\item{delta}{The delay interval (in seconds) between retries.}

\item{alpha}{A multiplicative penalty increasing the delay
for each failed try.}

\item{\ldots}{Not used.}
}
\value{
(invisibly) TRUE if deleted and FALSE otherwise.
}
\description{
Removes a batchtools future
}
\keyword{internal}
