% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable_tabulator.R
\name{tabulator_colnames}
\alias{tabulator_colnames}
\title{column keys of tabulator objects}
\usage{
tabulator_colnames(x, columns, ..., type = NULL)
}
\arguments{
\item{x}{a \code{\link[=tabulator]{tabulator()}} object}

\item{columns}{column names to look for}

\item{...}{any filter conditions that use variables
names, the same than the argument \code{columns} of function \code{\link[=tabulator]{tabulator()}}
(\code{tabulator(columns = c("col1", "col2"))}).}

\item{type}{the type of column to look for, it can be:
\itemize{
\item 'columns': visible columns, corresponding to names provided
in the '...' arguments of your call to 'tabulator()'.
\item 'hidden': unvisible columns, corresponding to names of
the original dataset columns.
\item 'rows': visible columns used as 'row' content
\item 'rows_supp': visible columns used as 'rows_supp' content
\item NULL: any type of column
}}
}
\description{
The function provides a way to get column keys
associated with the flextable corresponding to a \code{\link[=tabulator]{tabulator()}}
object. It helps in customizing or programing with \code{tabulator}.

The function is using column names from the original
dataset, eventually filters and returns the names
corresponding to the selection.
}
\examples{
library(flextable)

cancer_dat <- data.frame(
  count = c(
    9L, 5L, 1L, 2L, 2L, 1L, 9L, 3L, 1L, 10L, 2L, 1L, 1L, 2L, 0L, 3L,
    2L, 1L, 1L, 2L, 0L, 12L, 4L, 1L, 7L, 3L, 1L, 5L, 5L, 3L, 10L,
    4L, 1L, 4L, 2L, 0L, 3L, 1L, 0L, 4L, 4L, 2L, 42L, 28L, 19L, 26L,
    19L, 11L, 12L, 10L, 7L, 10L, 5L, 6L, 5L, 0L, 3L, 4L, 3L, 3L,
    1L, 2L, 3L
  ),
  risktime = c(
    157L, 77L, 21L, 139L, 68L, 17L, 126L, 63L, 14L, 102L, 55L,
    12L, 88L, 50L, 10L, 82L, 45L, 8L, 76L, 42L, 6L, 134L, 71L,
    22L, 110L, 63L, 18L, 96L, 58L, 14L, 86L, 42L, 10L, 66L,
    35L, 8L, 59L, 32L, 8L, 51L, 28L, 6L, 212L, 130L, 101L,
    136L, 72L, 63L, 90L, 42L, 43L, 64L, 21L, 32L, 47L, 14L,
    21L, 39L, 13L, 14L, 29L, 7L, 10L
  ),
  time = rep(as.character(1:7), 3),
  histology = rep(as.character(1:3), 21),
  stage = rep(as.character(1:3), each = 21)
)

datasup_first <- data.frame(
  time = factor(1:7, levels = 1:7),
  zzz = runif(7)
)

z <- tabulator(cancer_dat,
  rows = "time",
  columns = c("histology", "stage"),
  datasup_first = datasup_first,
  n = as_paragraph(as_chunk(count))
)

j <- tabulator_colnames(
  x = z, type = "columns",
  columns = c("n"),
  stage \%in\% 1
)

src <- tabulator_colnames(
  x = z, type = "hidden",
  columns = c("count"),
  stage \%in\% 1
)

if (require("scales")) {
  colourer <- col_numeric(
    palette = c("wheat", "red"),
    domain = c(0, 45)
  )
  ft_1 <- as_flextable(z)
  ft_1 <- bg(
    ft_1,
    bg = colourer, part = "body",
    j = j, source = src
  )
  ft_1
}
}
\seealso{
\code{\link[=tabulator]{tabulator()}}, \code{\link[=as_flextable.tabulator]{as_flextable.tabulator()}}
}
