% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_strand.R
\name{plot_strand}
\alias{plot_strand}
\title{Plot strand per base substitution type}
\usage{
plot_strand(strand_bias_df, mode = c("relative", "absolute"), colors = NA)
}
\arguments{
\item{strand_bias_df}{data.frame, result from strand_bias function}

\item{mode}{Either "absolute" for absolute number of mutations, or
"relative" for relative contribution, default = "relative"}

\item{colors}{Optional color vector for plotting with 6 values}
}
\value{
Barplot
}
\description{
For each base substitution type and transcriptional strand the total number
of mutations and the relative contribution within a group is returned.
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## following mutation matrix.
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
  package = "MutationalPatterns"
))

## Load a reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

tissue <- c(
  "colon", "colon", "colon",
  "intestine", "intestine", "intestine",
  "liver", "liver", "liver"
)

strand_counts <- strand_occurrences(mut_mat_s, by = tissue)

## Plot the strand in relative mode.
strand_plot <- plot_strand(strand_counts)

## Or absolute mode.
strand_plot <- plot_strand(strand_counts, mode = "absolute")
}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{strand_occurrences}},
\code{\link{plot_strand_bias}}
}
