/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2020 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone-soundfonts.com                 **
**             Date: 01.01.2013                                           **
***************************************************************************/

#ifndef WAITINGTOOLDIALOG_H
#define WAITINGTOOLDIALOG_H

#include <QDialog>

namespace Ui {
class WaitingToolDialog;
}

class WaitingToolDialog : public QDialog
{
    Q_OBJECT

public:
    explicit WaitingToolDialog(QString title, quint32 stepNumber, QWidget *parent = nullptr);
    ~WaitingToolDialog();

    void setValue(int value);

signals:
    void canceled();

protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void on_pushCancel_clicked();

private:
    void cancel();

    Ui::WaitingToolDialog *ui;
    quint32 _stepNumber;
    bool _isCanceled;
};

#endif // WAITINGTOOLDIALOG_H
