/*
* SpeedFan Information Tool 2.0
*
* Retrieves temperature information from SpeedFan and outputs it to the console.
*
* (c) 2008, Christopher Vagnetoft
* (c) 2016, Mieczyslaw Nalewaj
*
* Free to use and reuse under the GNU Public License (GPL) v2.
*
*/
#include <stdio.h>
#include <windows.h>

// pragma pack is included here because the struct is a pascal Packed Record,
// meaning that fields aren't aligned on a 4-byte boundary. 4 bytes fit 2
// 2-byte records.
#pragma pack(1)
// This is the struct we're using to access the shared memory.
struct SFMemory {
    WORD version;
    WORD flags;
    int MemSize;
    int handle;
    WORD NumTemps;
    WORD NumFans;
    WORD NumVolts;
    signed int temps[32];
    signed int fans[32];
    signed int volts[32];
};

// Name of filename and memory map name to open.
const char* SPEEDFAN_MEMORY = "SFSharedMemory_ALM";

UINT nSize = sizeof(SFMemory);

int main() {

    // Open SpeedFan's shared memory area
    HANDLE hSFMapFile = OpenFileMapping(FILE_MAP_READ, FALSE, SPEEDFAN_MEMORY);

    if (hSFMapFile) {
        SFMemory* sfmemory = (SFMemory*)MapViewOfFile(hSFMapFile, FILE_MAP_READ, 0, 0, nSize);
        if (sfmemory) {
            printf("Version: %u", (WORD)sfmemory->version);
            printf("\nFlags: %u", (WORD)sfmemory->flags);
            WORD NumTemps = sfmemory->NumTemps;
            if (NumTemps>0) {
                printf("\nTemperatures:");
                for (int n = 0; (n < NumTemps)&&(n < 32); n++) {
                    printf(" %.2f" ,(float)sfmemory->temps[n]/100.0);
                }
            }
            WORD NumFans = sfmemory->NumFans;
            if (NumFans>0) {
                printf("\nFans:");
                for (int n = 0; (n < NumFans)&&(n < 32); n++) {
                    printf(" %i" ,(int)sfmemory->fans[n]);
                }
            }
            WORD NumVolts = sfmemory->NumVolts;
            if (NumVolts>0) {
                printf("\nVoltages:");
                for (int n = 0; (n < NumVolts)&&(n < 32); n++) {
                    printf(" %.2f" ,(float)sfmemory->volts[n]/100.0);
                }
            }
            printf("\n");
            CloseHandle(hSFMapFile);
        } else {
            CloseHandle(hSFMapFile);
            fprintf(stderr, "SpeedFan MapViewOfFile Error.\n");
            return 2;
        }
    } else {
        fprintf(stderr, "SpeedFan OpenFileMapping Error.\n");
        return 1;
    }
}

