/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Yee ole includes (I put this all in one file for my sanity) */
#include "includes.h"


/* 
 * this function will setup the pre-message section of an event.pmsg 
 * (what we print to the screen) for a module.  Some modules may not call this
 * if they don't do the standard "Time Host Prog" line format.
 */

short int mod_premsg_setup() { 

	char msg_tmp[LSIZE];
	
	/* Always set the color to default white before we start */
	strcpy(event.pmsg, "\033w");
	
	/* Do the timefmt stuff as a switch statement to give us more flex later */
	switch(cf.timefmt) {
		case DATE_SHORT:
                	sprintf(msg_tmp, "%s", event.time);
			break;
                        
		case DATE_LONG:
			sprintf(msg_tmp, "%s %s %s", event.month, event.day, event.time);
			break;
                        
		default:
			sprintf(msg_tmp, "%s %s %s", event.month, event.day, event.time);
                        
	}
	
	strcat(event.pmsg, msg_tmp); 	/* put that formatted time string in there	*/
	strcat(event.pmsg, "\033e"); 	 /* the "end of color" color (white usually) 	*/
		
	/* if we're supposed to print the source hostname of the event */
	if(cf.showsrc == TRUE) {
		sprintf(msg_tmp, "%s %s%s", "\033C", event.source, "\033e");
		strcat(event.pmsg, msg_tmp);
	}

	/* If user didn't ask us not to display the program, then display it */
	if(cf.showprog == TRUE) {
		sprintf(msg_tmp, "%s %s%s", "\033w", event.program, "\033e");
		strcat(event.pmsg, msg_tmp);
	}
        
	return 0;
}


/* check an enviornment variable (set by config file) and return true/false value       */
short int mod_varcheck(char *var) {
        char *ptr;
        if((ptr = getenv(var)) == NULL) return FALSE;   /* we found no such value               */
        if(strstr(ptr, "true") != NULL) return TRUE;    /* we found value, and it was true      */
	return FALSE;      /* had something, but not true, return false	 */
}

