; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i8 @avg_lsb(i8 %a, i8 %b) {
; CHECK-LABEL: define i8 @avg_lsb(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[REM:%.*]] = and i8 [[A]], 1
; CHECK-NEXT:    [[DIV2:%.*]] = and i8 [[REM]], [[B]]
; CHECK-NEXT:    ret i8 [[DIV2]]
;
  %rem = and i8 %a, 1
  %rem1 = and i8 %b, 1
  %add = add nuw nsw i8 %rem1, %rem
  %div2 = lshr i8 %add, 1
  ret i8 %div2
}

define i8 @avg_lsb_mismatch(i8 %a, i8 %b) {
; CHECK-LABEL: define i8 @avg_lsb_mismatch(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[REM:%.*]] = and i8 [[A]], 1
; CHECK-NEXT:    [[REM1:%.*]] = and i8 [[B]], 3
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i8 [[REM1]], [[REM]]
; CHECK-NEXT:    [[DIV2:%.*]] = lshr i8 [[ADD]], 1
; CHECK-NEXT:    ret i8 [[DIV2]]
;
  %rem = and i8 %a, 1
  %rem1 = and i8 %b, 3
  %add = add nuw nsw i8 %rem1, %rem
  %div2 = lshr i8 %add, 1
  ret i8 %div2
}

define <2 x i8> @avg_lsb_vector(<2 x i8> %a, <2 x i8> %b) {
; CHECK-LABEL: define <2 x i8> @avg_lsb_vector(
; CHECK-SAME: <2 x i8> [[A:%.*]], <2 x i8> [[B:%.*]]) {
; CHECK-NEXT:    [[REM:%.*]] = and <2 x i8> [[A]], <i8 1, i8 1>
; CHECK-NEXT:    [[DIV2:%.*]] = and <2 x i8> [[REM]], [[B]]
; CHECK-NEXT:    ret <2 x i8> [[DIV2]]
;
  %rem = and <2 x i8> %a, <i8 1, i8 1>
  %rem1 = and <2 x i8> %b, <i8 1, i8 1>
  %add = add nuw nsw <2 x i8> %rem1, %rem
  %div2 = lshr <2 x i8> %add, <i8 1, i8 1>
  ret <2 x i8> %div2
}
