#!/usr/bin/env python

"""
A PostgreSQL database store of calendar data.

Copyright (C) 2016, 2017 Paul Boddie <paul@boddie.org.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from imiptools.config import settings
from imiptools.stores.database.common import DatabaseStore, DatabaseJournal
import psycopg2

STORE_DIR = settings["STORE_DIR"]
JOURNAL_DIR = settings["JOURNAL_DIR"]

class Store(DatabaseStore):

    "A PostgreSQL database store of calendar objects and free/busy data."

    def __init__(self, store_dir=None):

        "Interpret 'store_dir' as a connection string."

        connection = psycopg2.connect(store_dir or STORE_DIR)
        connection.autocommit = True
        DatabaseStore.__init__(self, connection, psycopg2.paramstyle)

    def acquire_lock(self, user, timeout=None):
        query = "select pg_advisory_lock(20160311)"
        self.cursor.execute(query)

    def release_lock(self, user):
        query = "select pg_advisory_unlock(20160311)"
        self.cursor.execute(query)

class Journal(DatabaseJournal):

    "A PostgreSQL journal system supporting quotas."

    def __init__(self, store_dir=None):

        "Interpret 'store_dir' as a connection string."

        connection = psycopg2.connect(store_dir or JOURNAL_DIR)
        connection.autocommit = True
        DatabaseJournal.__init__(self, connection, psycopg2.paramstyle)

    def acquire_lock(self, user, timeout=None):
        query = "select pg_advisory_lock(20160312)"
        self.cursor.execute(query)

    def release_lock(self, user):
        query = "select pg_advisory_unlock(20160312)"
        self.cursor.execute(query)

# vim: tabstop=4 expandtab shiftwidth=4
