module Data.Monoid.HT (cycle, (<>), when, ) where

import Data.Monoid (Monoid, mappend, mempty, )
import Data.Function (fix, )

import Prelude (Bool)


{- |
Generalization of 'Data.List.cycle' to any monoid.
-}
cycle :: Monoid m => m -> m
cycle x =
   fix (mappend x)


infixr 6 <>

{- |
Infix synonym for 'mappend'.
-}
(<>) :: Monoid m => m -> m -> m
(<>) = mappend


when :: Monoid m => Bool -> m -> m
when b m = if b then m else mempty
