// Code generated by smithy-go-codegen DO NOT EDIT.

package wellarchitected

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create a lens share. The owner of a lens can share it with other Amazon Web
// Services accounts and IAM users in the same Amazon Web Services Region. Shared
// access to a lens is not removed until the lens invitation is deleted. Disclaimer
// By sharing your custom lenses with other Amazon Web Services accounts, you
// acknowledge that Amazon Web Services will make your custom lenses available to
// those other accounts. Those other accounts may continue to access and use your
// shared custom lenses even if you delete the custom lenses from your own Amazon
// Web Services account or terminate your Amazon Web Services account.
func (c *Client) CreateLensShare(ctx context.Context, params *CreateLensShareInput, optFns ...func(*Options)) (*CreateLensShareOutput, error) {
	if params == nil {
		params = &CreateLensShareInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLensShare", params, optFns, c.addOperationCreateLensShareMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLensShareOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLensShareInput struct {

	// A unique case-sensitive string used to ensure that this request is idempotent
	// (executes only once). You should not reuse the same token for other requests. If
	// you retry a request with the same client request token and the same parameters
	// after it has completed successfully, the result of the original request is
	// returned. This token is listed as required, however, if you do not specify it,
	// the Amazon Web Services SDKs automatically generate one for you. If you are not
	// using the Amazon Web Services SDK or the CLI, you must provide this token or the
	// request will fail.
	//
	// This member is required.
	ClientRequestToken *string

	// The alias of the lens. For Amazon Web Services official lenses, this is either
	// the lens alias, such as serverless, or the lens ARN, such as
	// arn:aws:wellarchitected:us-west-2::lens/serverless. For custom lenses, this is
	// the lens ARN, such as
	// arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens. Each lens is
	// identified by its LensSummary$LensAlias.
	//
	// This member is required.
	LensAlias *string

	// The Amazon Web Services account ID or IAM role with which the workload is
	// shared.
	//
	// This member is required.
	SharedWith *string

	noSmithyDocumentSerde
}

type CreateLensShareOutput struct {

	// The ID associated with the workload share.
	ShareId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLensShareMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLensShare{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLensShare{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateLensShareMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLensShareValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLensShare(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateLensShare struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateLensShare) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateLensShare) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateLensShareInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateLensShareInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateLensShareMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateLensShare{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateLensShare(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "wellarchitected",
		OperationName: "CreateLensShare",
	}
}
