//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armworkloadmonitor

import "time"

// ErrorDetails - Error details
type ErrorDetails struct {
	// Error code identifying the specific error.
	Code *string `json:"code,omitempty"`

	// A human-readable error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse - Error response
type ErrorResponse struct {
	// Error info.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError - Error info.
type ErrorResponseError struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`

	// Error details.
	Details []*ErrorDetails `json:"details,omitempty"`

	// Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// HealthMonitor - Information about the monitor’s current health status.
type HealthMonitor struct {
	// Properties of the monitor's health status.
	Properties *HealthMonitorProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HealthMonitorList - Information about the current health statuses of the monitors.
type HealthMonitorList struct {
	// Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of health monitors of the virtual machine.
	Value []*HealthMonitor `json:"value,omitempty"`
}

// HealthMonitorProperties - Properties of the monitor.
type HealthMonitorProperties struct {
	// Timestamp of the monitor's last health state change.
	CurrentStateFirstObservedTimestamp *string `json:"currentStateFirstObservedTimestamp,omitempty"`

	// Timestamp of the monitor's last health evaluation.
	EvaluationTimestamp *string `json:"evaluationTimestamp,omitempty"`

	// Evidence validating the monitor's current health state.
	Evidence interface{} `json:"evidence,omitempty"`

	// Timestamp of the monitor's last reported health state.
	LastReportedTimestamp *string `json:"lastReportedTimestamp,omitempty"`

	// The configuration settings at the time of the monitor's health evaluation.
	MonitorConfiguration interface{} `json:"monitorConfiguration,omitempty"`

	// Human-readable name of the monitor.
	MonitorName *string `json:"monitorName,omitempty"`

	// Type of the monitor.
	MonitorType *string `json:"monitorType,omitempty"`

	// Dynamic monitored object of the monitor.
	MonitoredObject *string `json:"monitoredObject,omitempty"`

	// Name of the parent monitor.
	ParentMonitorName *string `json:"parentMonitorName,omitempty"`

	// READ-ONLY; Current health state of the monitor.
	CurrentMonitorState *HealthState `json:"currentMonitorState,omitempty" azure:"ro"`

	// READ-ONLY; Previous health state of the monitor.
	PreviousMonitorState *HealthState `json:"previousMonitorState,omitempty" azure:"ro"`
}

// HealthMonitorStateChange - Information about the monitor’s health state change at the provided timestamp.
type HealthMonitorStateChange struct {
	// Properties of the monitor's state change.
	Properties *HealthMonitorStateChangeProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HealthMonitorStateChangeList - Information about the health state changes of the monitor within the provided time window.
type HealthMonitorStateChangeList struct {
	// Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of health state changes within the specified time window.
	Value []*HealthMonitorStateChange `json:"value,omitempty"`
}

// HealthMonitorStateChangeProperties - Properties of the monitor.
type HealthMonitorStateChangeProperties struct {
	// Timestamp of the monitor's last health state change.
	CurrentStateFirstObservedTimestamp *string `json:"currentStateFirstObservedTimestamp,omitempty"`

	// Timestamp of the monitor's last health evaluation.
	EvaluationTimestamp *string `json:"evaluationTimestamp,omitempty"`

	// Evidence validating the monitor's current health state.
	Evidence interface{} `json:"evidence,omitempty"`

	// The configuration settings at the time of the monitor's health evaluation.
	MonitorConfiguration interface{} `json:"monitorConfiguration,omitempty"`

	// Human-readable name of the monitor.
	MonitorName *string `json:"monitorName,omitempty"`

	// Type of the monitor.
	MonitorType *string `json:"monitorType,omitempty"`

	// Dynamic monitored object of the monitor.
	MonitoredObject *string `json:"monitoredObject,omitempty"`

	// READ-ONLY; Current health state of the monitor.
	CurrentMonitorState *HealthState `json:"currentMonitorState,omitempty" azure:"ro"`

	// READ-ONLY; Previous health state of the monitor.
	PreviousMonitorState *HealthState `json:"previousMonitorState,omitempty" azure:"ro"`
}

// HealthMonitorsClientGetOptions contains the optional parameters for the HealthMonitorsClient.Get method.
type HealthMonitorsClientGetOptions struct {
	// Optionally expand the monitor’s evidence and/or configuration. Example: $expand=evidence,configuration.
	Expand *string
}

// HealthMonitorsClientGetStateChangeOptions contains the optional parameters for the HealthMonitorsClient.GetStateChange
// method.
type HealthMonitorsClientGetStateChangeOptions struct {
	// Optionally expand the monitor’s evidence and/or configuration. Example: $expand=evidence,configuration.
	Expand *string
}

// HealthMonitorsClientListOptions contains the optional parameters for the HealthMonitorsClient.List method.
type HealthMonitorsClientListOptions struct {
	// Optionally expand the monitor’s evidence and/or configuration. Example: $expand=evidence,configuration.
	Expand *string
	// Optionally filter by monitor name. Example: $filter=monitorName eq 'logical-disks|C:|disk-free-space-mb.'
	Filter *string
}

// HealthMonitorsClientListStateChangesOptions contains the optional parameters for the HealthMonitorsClient.ListStateChanges
// method.
type HealthMonitorsClientListStateChangesOptions struct {
	// The end of the time window.
	EndTimestampUTC *time.Time
	// Optionally expand the monitor’s evidence and/or configuration. Example: $expand=evidence,configuration.
	Expand *string
	// Optionally filter by heartbeat condition. Example: $filter=isHeartbeat eq false.
	Filter *string
	// The start of the time window.
	StartTimestampUTC *time.Time
}

// Operation supported by the resource provider.
type Operation struct {
	// REQUIRED; The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty"`

	// REQUIRED; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - The localized display information for this particular operation or action.
type OperationDisplay struct {
	// REQUIRED; Operation description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; Human-readable, friendly name for the operation.
	Operation *string `json:"operation,omitempty"`

	// REQUIRED; Operation resource provider name.
	Provider *string `json:"provider,omitempty"`

	// REQUIRED; Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationList - List of available REST API operations
type OperationList struct {
	// Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`

	// Array of available REST API operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - The resource model definition for the ARM proxy resource, 'microsoft.workloadmonitor/monitors'.
type Resource struct {
	// READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}
