//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// TestResultsClient contains the methods for the TestResults group.
// Don't use this type directly, use NewTestResultsClient() instead.
type TestResultsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewTestResultsClient creates a new instance of TestResultsClient with the specified values.
// subscriptionID - The Azure subscription ID. This is a GUID-formatted string.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewTestResultsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*TestResultsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &TestResultsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Get - Get the Test Result by Id with specified OS Update type for a Test Base Package.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// testResultName - The Test Result Name. It equals to {osName}-{TestResultId} string.
// options - TestResultsClientGetOptions contains the optional parameters for the TestResultsClient.Get method.
func (client *TestResultsClient) Get(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetOptions) (TestResultsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, testResultName, options)
	if err != nil {
		return TestResultsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TestResultsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TestResultsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *TestResultsClient) getCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if testResultName == "" {
		return nil, errors.New("parameter testResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testResultName}", url.PathEscape(testResultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *TestResultsClient) getHandleResponse(resp *http.Response) (TestResultsClientGetResponse, error) {
	result := TestResultsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TestResultResource); err != nil {
		return TestResultsClientGetResponse{}, err
	}
	return result, nil
}

// GetDownloadURL - Gets the download URL of the test result.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// testResultName - The Test Result Name. It equals to {osName}-{TestResultId} string.
// options - TestResultsClientGetDownloadURLOptions contains the optional parameters for the TestResultsClient.GetDownloadURL
// method.
func (client *TestResultsClient) GetDownloadURL(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetDownloadURLOptions) (TestResultsClientGetDownloadURLResponse, error) {
	req, err := client.getDownloadURLCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, testResultName, options)
	if err != nil {
		return TestResultsClientGetDownloadURLResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TestResultsClientGetDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TestResultsClientGetDownloadURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDownloadURLHandleResponse(resp)
}

// getDownloadURLCreateRequest creates the GetDownloadURL request.
func (client *TestResultsClient) getDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if testResultName == "" {
		return nil, errors.New("parameter testResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testResultName}", url.PathEscape(testResultName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDownloadURLHandleResponse handles the GetDownloadURL response.
func (client *TestResultsClient) getDownloadURLHandleResponse(resp *http.Response) (TestResultsClientGetDownloadURLResponse, error) {
	result := TestResultsClientGetDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DownloadURLResponse); err != nil {
		return TestResultsClientGetDownloadURLResponse{}, err
	}
	return result, nil
}

// GetVideoDownloadURL - Gets the download URL of the test execution screen recording.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// testResultName - The Test Result Name. It equals to {osName}-{TestResultId} string.
// options - TestResultsClientGetVideoDownloadURLOptions contains the optional parameters for the TestResultsClient.GetVideoDownloadURL
// method.
func (client *TestResultsClient) GetVideoDownloadURL(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetVideoDownloadURLOptions) (TestResultsClientGetVideoDownloadURLResponse, error) {
	req, err := client.getVideoDownloadURLCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, testResultName, options)
	if err != nil {
		return TestResultsClientGetVideoDownloadURLResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return TestResultsClientGetVideoDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return TestResultsClientGetVideoDownloadURLResponse{}, runtime.NewResponseError(resp)
	}
	return client.getVideoDownloadURLHandleResponse(resp)
}

// getVideoDownloadURLCreateRequest creates the GetVideoDownloadURL request.
func (client *TestResultsClient) getVideoDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, testResultName string, options *TestResultsClientGetVideoDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults/{testResultName}/getVideoDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	if testResultName == "" {
		return nil, errors.New("parameter testResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testResultName}", url.PathEscape(testResultName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVideoDownloadURLHandleResponse handles the GetVideoDownloadURL response.
func (client *TestResultsClient) getVideoDownloadURLHandleResponse(resp *http.Response) (TestResultsClientGetVideoDownloadURLResponse, error) {
	result := TestResultsClientGetVideoDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DownloadURLResponse); err != nil {
		return TestResultsClientGetVideoDownloadURLResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all the Test Results with specified OS Update type for a Test Base Package. Can be filtered by osName,
// releaseName, flightingRing, buildVersion, buildRevision.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-12-16-preview
// resourceGroupName - The name of the resource group that contains the resource.
// testBaseAccountName - The resource name of the Test Base Account.
// packageName - The resource name of the Test Base Package.
// osUpdateType - The type of the OS Update.
// options - TestResultsClientListOptions contains the optional parameters for the TestResultsClient.List method.
func (client *TestResultsClient) NewListPager(resourceGroupName string, testBaseAccountName string, packageName string, osUpdateType OsUpdateType, options *TestResultsClientListOptions) *runtime.Pager[TestResultsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[TestResultsClientListResponse]{
		More: func(page TestResultsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TestResultsClientListResponse) (TestResultsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, testBaseAccountName, packageName, osUpdateType, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return TestResultsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return TestResultsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return TestResultsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *TestResultsClient) listCreateRequest(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, osUpdateType OsUpdateType, options *TestResultsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.TestBase/testBaseAccounts/{testBaseAccountName}/packages/{packageName}/testResults"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if testBaseAccountName == "" {
		return nil, errors.New("parameter testBaseAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{testBaseAccountName}", url.PathEscape(testBaseAccountName))
	if packageName == "" {
		return nil, errors.New("parameter packageName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{packageName}", url.PathEscape(packageName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("osUpdateType", string(osUpdateType))
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-12-16-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *TestResultsClient) listHandleResponse(resp *http.Response) (TestResultsClientListResponse, error) {
	result := TestResultsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.TestResultListResult); err != nil {
		return TestResultsClientListResponse{}, err
	}
	return result, nil
}
