// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 5>, 500> hypergeometric_2F1 = {{
      { SC_(-9.9895538330078125000000000000000000000000e+01), SC_(-9.3285552978515625000000000000000000000000e+01), SC_(7.3087707519531250000000000000000000000000e+01), SC_(-1.8142122030258178710937500000000000000000e-01), SC_(6.5891986527929449267593715511756563448513e-15) }, 
      { SC_(-9.9073181152343750000000000000000000000000e+01), SC_(-9.3136535644531250000000000000000000000000e+01), SC_(5.4982086181640625000000000000000000000000e+01), SC_(9.5400404930114746093750000000000000000000e-01), SC_(1.1007633109021571039219928777818293629102e+28) }, 
      { SC_(-9.7619598388671875000000000000000000000000e+01), SC_(4.5390945434570312500000000000000000000000e+01), SC_(-3.2575469970703125000000000000000000000000e+01), SC_(-2.2286039590835571289062500000000000000000e-01), SC_(-6.4789723389675742353349389221567944679928e+38) }, 
      { SC_(-9.6902587890625000000000000000000000000000e+01), SC_(6.3223403930664062500000000000000000000000e+01), SC_(9.6812744140625000000000000000000000000000e+01), SC_(-4.1322350502014160156250000000000000000000e-01), SC_(3.2079560298672561791430457929878905585658e+10) }, 
      { SC_(-9.6603424072265625000000000000000000000000e+01), SC_(-2.0321739196777343750000000000000000000000e+01), SC_(-7.5828094482421875000000000000000000000000e+01), SC_(-9.2019414901733398437500000000000000000000e-01), SC_(8.4156847340696781722447707160754173280841e+06) }, 
      { SC_(-9.5892852783203125000000000000000000000000e+01), SC_(-9.6531707763671875000000000000000000000000e+01), SC_(8.4735107421875000000000000000000000000000e+01), SC_(-7.3016166687011718750000000000000000000000e-01), SC_(-4.4717807146118951718858040781837872825985e-16) }, 
      { SC_(-9.4954376220703125000000000000000000000000e+01), SC_(-5.9686599731445312500000000000000000000000e+01), SC_(6.8441314697265625000000000000000000000000e+01), SC_(-9.4900083541870117187500000000000000000000e-01), SC_(-1.7276145800358599599760958115736468880647e-11) }, 
      { SC_(-9.3891815185546875000000000000000000000000e+01), SC_(-1.5204330444335937500000000000000000000000e+01), SC_(4.8814849853515625000000000000000000000000e+01), SC_(3.7960255146026611328125000000000000000000e-01), SC_(2.4552032940427998541423531520934032344423e+03) }, 
      { SC_(-9.3601806640625000000000000000000000000000e+01), SC_(-9.5872192382812500000000000000000000000000e+00), SC_(2.2942687988281250000000000000000000000000e+01), SC_(-2.9971241950988769531250000000000000000000e-02), SC_(2.7383928273420403328458561650200080754586e-01) }, 
      { SC_(-9.3479858398437500000000000000000000000000e+01), SC_(-8.7491363525390625000000000000000000000000e+01), SC_(1.2239959716796875000000000000000000000000e+01), SC_(-7.3687696456909179687500000000000000000000e-01), SC_(1.5973694221369750316833507490060101743881e+08) }, 
      { SC_(-9.2452239990234375000000000000000000000000e+01), SC_(7.6793701171875000000000000000000000000000e+01), SC_(7.7033599853515625000000000000000000000000e+01), SC_(9.1844320297241210937500000000000000000000e-01), SC_(4.2508459032690447851029931141763191686420e-49) }, 
      { SC_(-9.1513793945312500000000000000000000000000e+01), SC_(7.4361022949218750000000000000000000000000e+01), SC_(-8.5710906982421875000000000000000000000000e+01), SC_(8.6920523643493652343750000000000000000000e-01), SC_(1.5597155522468405412722593998443708684739e+62) }, 
      { SC_(-9.1469543457031250000000000000000000000000e+01), SC_(3.7243209838867187500000000000000000000000e+01), SC_(2.7039588928222656250000000000000000000000e+01), SC_(-5.3746747970581054687500000000000000000000e-01), SC_(1.9880343033721299184057983616668235260257e+20) }, 
      { SC_(-9.1395263671875000000000000000000000000000e+01), SC_(8.1686706542968750000000000000000000000000e+01), SC_(-6.6201995849609375000000000000000000000000e+01), SC_(6.1827445030212402343750000000000000000000e-01), SC_(1.5177192508688742444864029168560550139867e+38) }, 
      { SC_(-9.1109191894531250000000000000000000000000e+01), SC_(-4.6822494506835937500000000000000000000000e+01), SC_(5.0986648559570312500000000000000000000000e+01), SC_(8.3877134323120117187500000000000000000000e-01), SC_(8.7682696840405655306109200648215293456224e+14) }, 
      { SC_(-9.0310546875000000000000000000000000000000e+01), SC_(6.0442535400390625000000000000000000000000e+01), SC_(3.3583221435546875000000000000000000000000e+01), SC_(-3.3563292026519775390625000000000000000000e-01), SC_(4.0487268295423261389483401128099493869350e+16) }, 
      { SC_(-8.9464599609375000000000000000000000000000e+01), SC_(8.9315429687500000000000000000000000000000e+01), SC_(4.7571624755859375000000000000000000000000e+01), SC_(-6.6660356521606445312500000000000000000000e-01), SC_(2.5114952432008773418647344036287653320834e+28) }, 
      { SC_(-8.9152099609375000000000000000000000000000e+01), SC_(-2.6084045410156250000000000000000000000000e+01), SC_(-6.4578491210937500000000000000000000000000e+01), SC_(5.9371495246887207031250000000000000000000e-01), SC_(5.6850960900809898605288885711913335983141e-16) }, 
      { SC_(-8.8659057617187500000000000000000000000000e+01), SC_(6.7384948730468750000000000000000000000000e+00), SC_(4.3771362304687500000000000000000000000000e+00), SC_(-2.1086728572845458984375000000000000000000e-01), SC_(6.7662108559263781602895004977849861149020e+08) }, 
      { SC_(-8.8119354248046875000000000000000000000000e+01), SC_(8.0055007934570312500000000000000000000000e+00), SC_(-3.6837722778320312500000000000000000000000e+01), SC_(4.6050941944122314453125000000000000000000e-01), SC_(5.0186785654573089743217395843157810410248e+05) }, 
      { SC_(-8.8076232910156250000000000000000000000000e+01), SC_(9.0494384765625000000000000000000000000000e+01), SC_(3.6394378662109375000000000000000000000000e+01), SC_(6.9442033767700195312500000000000000000000e-02), SC_(-5.2328192081300292121812430756925613031667e-10) }, 
      { SC_(-8.7996246337890625000000000000000000000000e+01), SC_(2.5608551025390625000000000000000000000000e+01), SC_(7.3349975585937500000000000000000000000000e+01), SC_(8.3896517753601074218750000000000000000000e-01), SC_(1.3188033760477549843227638060915778305114e-09) }, 
      { SC_(-8.7905761718750000000000000000000000000000e+01), SC_(-4.4467193603515625000000000000000000000000e+01), SC_(-2.0148445129394531250000000000000000000000e+01), SC_(7.1619844436645507812500000000000000000000e-01), SC_(-1.0348822096490564753185858979352513187093e+41) }, 
      { SC_(-8.7162597656250000000000000000000000000000e+01), SC_(-9.2664398193359375000000000000000000000000e+01), SC_(5.3465896606445312500000000000000000000000e+01), SC_(1.2756669521331787109375000000000000000000e-01), SC_(2.6591753592818062169469179816351461441245e+06) }, 
      { SC_(-8.6238800048828125000000000000000000000000e+01), SC_(-4.0766479492187500000000000000000000000000e+01), SC_(-3.6080062866210937500000000000000000000000e+01), SC_(-3.4934425354003906250000000000000000000000e-01), SC_(1.0671369459274192093853910745059462925711e+14) }, 
      { SC_(-8.5422943115234375000000000000000000000000e+01), SC_(-5.0067001342773437500000000000000000000000e+01), SC_(-8.2294525146484375000000000000000000000000e+01), SC_(6.3052177429199218750000000000000000000000e-03), SC_(7.1983223779405884950872578701896279406090e-01) }, 
      { SC_(-8.5201049804687500000000000000000000000000e+01), SC_(7.1300018310546875000000000000000000000000e+01), SC_(3.6819213867187500000000000000000000000000e+01), SC_(6.8275332450866699218750000000000000000000e-01), SC_(-7.2248129929416231256882613616030281700130e-37) }, 
      { SC_(-8.4829162597656250000000000000000000000000e+01), SC_(-1.9158294677734375000000000000000000000000e+01), SC_(-8.9209991455078125000000000000000000000000e+01), SC_(-2.9447519779205322265625000000000000000000e-01), SC_(1.1268786151580868445024368602273685802566e+02) }, 
      { SC_(-8.4364898681640625000000000000000000000000e+01), SC_(7.0890197753906250000000000000000000000000e+01), SC_(-1.1464347839355468750000000000000000000000e+01), SC_(2.0846295356750488281250000000000000000000e-01), SC_(2.6453935829128062119673960313487378329101e+10) }, 
      { SC_(-8.3827514648437500000000000000000000000000e+01), SC_(4.2625076293945312500000000000000000000000e+01), SC_(5.5448104858398437500000000000000000000000e+01), SC_(8.5020017623901367187500000000000000000000e-01), SC_(1.3161738887316434241273665736139333526306e-22) }, 
      { SC_(-8.3306060791015625000000000000000000000000e+01), SC_(8.1388824462890625000000000000000000000000e+01), SC_(-7.3365814208984375000000000000000000000000e+01), SC_(-8.4699201583862304687500000000000000000000e-01), SC_(5.6570252047451213319405014209227305375497e+57) }, 
      { SC_(-8.3303436279296875000000000000000000000000e+01), SC_(1.3758300781250000000000000000000000000000e+01), SC_(2.5191963195800781250000000000000000000000e+01), SC_(-6.2980413436889648437500000000000000000000e-01), SC_(8.6156199039723504965337011474285940518069e+12) }, 
      { SC_(-8.3112854003906250000000000000000000000000e+01), SC_(-3.0753318786621093750000000000000000000000e+01), SC_(-2.0043472290039062500000000000000000000000e+01), SC_(7.1175026893615722656250000000000000000000e-01), SC_(-5.3713434030169115266219900887397728056581e+30) }, 
      { SC_(-8.2896850585937500000000000000000000000000e+01), SC_(9.8706939697265625000000000000000000000000e+01), SC_(-4.7503555297851562500000000000000000000000e+01), SC_(-6.3685417175292968750000000000000000000000e-01), SC_(1.0144646333952797341792886342453593175189e+70) }, 
      { SC_(-8.1835357666015625000000000000000000000000e+01), SC_(-8.6423034667968750000000000000000000000000e+01), SC_(-4.6705703735351562500000000000000000000000e+01), SC_(-8.6172008514404296875000000000000000000000e-01), SC_(-9.2644883958739925244893131980802470963977e+39) }, 
      { SC_(-8.1777313232421875000000000000000000000000e+01), SC_(-8.2756561279296875000000000000000000000000e+01), SC_(1.5241874694824218750000000000000000000000e+01), SC_(8.4975171089172363281250000000000000000000e-01), SC_(1.3713580229773706015146348821590270945603e+33) }, 
      { SC_(-8.1529541015625000000000000000000000000000e+01), SC_(-8.4324462890625000000000000000000000000000e+01), SC_(-9.8435943603515625000000000000000000000000e+01), SC_(-9.2966175079345703125000000000000000000000e-01), SC_(1.3120594648610534876798728731725395046710e+20) }, 
      { SC_(-8.1325897216796875000000000000000000000000e+01), SC_(2.4210906982421875000000000000000000000000e+01), SC_(-3.8526626586914062500000000000000000000000e+01), SC_(8.5018944740295410156250000000000000000000e-01), SC_(7.7715640800017229927030489671152186152877e+11) }, 
      { SC_(-8.0709106445312500000000000000000000000000e+01), SC_(-5.5316009521484375000000000000000000000000e+01), SC_(-7.3605346679687500000000000000000000000000e+01), SC_(-1.9397020339965820312500000000000000000000e-02), SC_(3.2058620420448713327004853706919774974865e+00) }, 
      { SC_(-8.0573669433593750000000000000000000000000e+01), SC_(9.8813690185546875000000000000000000000000e+01), SC_(6.4691558837890625000000000000000000000000e+01), SC_(6.4380645751953125000000000000000000000000e-01), SC_(-3.2962812155510894868194907135716075810041e-40) }, 
      { SC_(-8.0281188964843750000000000000000000000000e+01), SC_(-7.6421722412109375000000000000000000000000e+01), SC_(-7.1594573974609375000000000000000000000000e+01), SC_(1.9725000858306884765625000000000000000000e-01), SC_(6.7583079124337896122948982158539893260999e-09) }, 
      { SC_(-8.0257568359375000000000000000000000000000e+01), SC_(5.3370819091796875000000000000000000000000e+01), SC_(-4.7625762939453125000000000000000000000000e+01), SC_(-3.4440445899963378906250000000000000000000e-01), SC_(2.2570326689175870359602841610380118178025e+38) }, 
      { SC_(-7.9037353515625000000000000000000000000000e+01), SC_(-5.9600524902343750000000000000000000000000e+01), SC_(-7.4422332763671875000000000000000000000000e+01), SC_(5.4414939880371093750000000000000000000000e-01), SC_(2.0728774469622207016460143688427952185377e-22) }, 
      { SC_(-7.8874176025390625000000000000000000000000e+01), SC_(3.6254272460937500000000000000000000000000e+01), SC_(2.2191726684570312500000000000000000000000e+01), SC_(-8.4231543540954589843750000000000000000000e-01), SC_(1.3354325685115981696126746433920534126616e+26) }, 
      { SC_(-7.8858123779296875000000000000000000000000e+01), SC_(-8.7203704833984375000000000000000000000000e+01), SC_(-7.1591796875000000000000000000000000000000e+01), SC_(3.2905137538909912109375000000000000000000e-01), SC_(2.4799832776563752275850883048170961869478e-08) }, 
      { SC_(-7.8669464111328125000000000000000000000000e+01), SC_(-2.9116058349609375000000000000000000000000e-01), SC_(9.2379608154296875000000000000000000000000e+01), SC_(9.5985126495361328125000000000000000000000e-01), SC_(1.1905709345733837548047120546943198879911e+00) }, 
      { SC_(-7.8647644042968750000000000000000000000000e+01), SC_(3.9488220214843750000000000000000000000000e-01), SC_(3.0751464843750000000000000000000000000000e+01), SC_(-9.9680423736572265625000000000000000000000e-01), SC_(6.5749032228567207569573282088313810297875e+04) }, 
      { SC_(-7.8236419677734375000000000000000000000000e+01), SC_(-1.1869522094726562500000000000000000000000e+01), SC_(2.6353279113769531250000000000000000000000e+01), SC_(-4.3641376495361328125000000000000000000000e-01), SC_(1.0995992136918398602604389691838441221370e-04) }, 
      { SC_(-7.8169158935546875000000000000000000000000e+01), SC_(-3.1606193542480468750000000000000000000000e+01), SC_(6.5161773681640625000000000000000000000000e+01), SC_(3.2730674743652343750000000000000000000000e-01), SC_(1.4074109176730292632548715186074367540561e+04) }, 
      { SC_(-7.8060516357421875000000000000000000000000e+01), SC_(-8.8672485351562500000000000000000000000000e+00), SC_(-8.7281738281250000000000000000000000000000e+01), SC_(-3.3463239669799804687500000000000000000000e-01), SC_(1.0165155490714843703709129769467427487481e+01) }, 
      { SC_(-7.8049011230468750000000000000000000000000e+01), SC_(8.9145507812500000000000000000000000000000e+00), SC_(8.6751953125000000000000000000000000000000e+01), SC_(-3.0419242382049560546875000000000000000000e-01), SC_(1.5122769019944220022000086743995787755655e+01) }, 
      { SC_(-7.7658874511718750000000000000000000000000e+01), SC_(-6.1967819213867187500000000000000000000000e+01), SC_(-7.2741516113281250000000000000000000000000e+01), SC_(-4.7634553909301757812500000000000000000000e-01), SC_(1.4734635663861257489928548223680105002821e+11) }, 
      { SC_(-7.7543212890625000000000000000000000000000e+01), SC_(-4.1716033935546875000000000000000000000000e+01), SC_(5.6885574340820312500000000000000000000000e+01), SC_(-4.4903957843780517578125000000000000000000e-01), SC_(-1.9907090167026174447898722895519880098283e-11) }, 
      { SC_(-7.6501434326171875000000000000000000000000e+01), SC_(3.4411788940429687500000000000000000000000e+01), SC_(2.8143585205078125000000000000000000000000e+01), SC_(8.1873106956481933593750000000000000000000e-01), SC_(-2.6946635733379921065342352032695171744703e-33) }, 
      { SC_(-7.6200469970703125000000000000000000000000e+01), SC_(-8.7934341430664062500000000000000000000000e+00), SC_(-3.2718658447265625000000000000000000000000e-01), SC_(5.4783415794372558593750000000000000000000e-01), SC_(-1.5250039023027426500208360994305571126220e+11) }, 
      { SC_(-7.5962615966796875000000000000000000000000e+01), SC_(-2.1357803344726562500000000000000000000000e+00), SC_(5.0090332031250000000000000000000000000000e+00), SC_(-7.7635407447814941406250000000000000000000e-01), SC_(-1.2786988477501312062158021873132874912026e+09) }, 
      { SC_(-7.5383270263671875000000000000000000000000e+01), SC_(8.9868469238281250000000000000000000000000e+01), SC_(-5.8901168823242187500000000000000000000000e+01), SC_(4.7294497489929199218750000000000000000000e-01), SC_(-1.9198185127604932082698093835334158176736e+31) }, 
      { SC_(-7.5213562011718750000000000000000000000000e+01), SC_(4.5015655517578125000000000000000000000000e+01), SC_(-1.9285430908203125000000000000000000000000e+00), SC_(6.7501330375671386718750000000000000000000e-01), SC_(-1.6617357942466770869480597419285677992661e-03) }, 
      { SC_(-7.5025451660156250000000000000000000000000e+01), SC_(9.2893096923828125000000000000000000000000e+01), SC_(-9.5113220214843750000000000000000000000000e+01), SC_(-7.5960659980773925781250000000000000000000e-01), SC_(-8.9174289026702534707968446122544080006209e+14) }, 
      { SC_(-7.4933563232421875000000000000000000000000e+01), SC_(1.8751731872558593750000000000000000000000e+01), SC_(-7.3969726562500000000000000000000000000000e+01), SC_(9.3434619903564453125000000000000000000000e-01), SC_(-1.5106226795236614215236297637043920649073e+22) }, 
      { SC_(-7.4700042724609375000000000000000000000000e+01), SC_(3.3610000610351562500000000000000000000000e+00), SC_(-7.3139343261718750000000000000000000000000e+01), SC_(-2.6427888870239257812500000000000000000000e-01), SC_(4.4797196571893315711010115784059167271233e-01) }, 
      { SC_(-7.4602661132812500000000000000000000000000e+01), SC_(9.3773559570312500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.7768456765828349904347503808336804179253e+15) }, 
      { SC_(-7.3213775634765625000000000000000000000000e+01), SC_(-5.6839355468750000000000000000000000000000e+01), SC_(-9.3822113037109375000000000000000000000000e+01), SC_(-8.9701485633850097656250000000000000000000e-01), SC_(4.8449654037151723649016499194346976345329e+12) }, 
      { SC_(-7.3175415039062500000000000000000000000000e+01), SC_(-3.6607528686523437500000000000000000000000e+01), SC_(-5.7479705810546875000000000000000000000000e+01), SC_(5.5348014831542968750000000000000000000000e-01), SC_(6.5458820447751760887624222456082537652206e-18) }, 
      { SC_(-7.2689392089843750000000000000000000000000e+01), SC_(6.9421936035156250000000000000000000000000e+01), SC_(4.4245498657226562500000000000000000000000e+01), SC_(-5.3847122192382812500000000000000000000000e-01), SC_(1.1074949260049818348017024133489027016905e+18) }, 
      { SC_(-7.0892211914062500000000000000000000000000e+01), SC_(-4.3465347290039062500000000000000000000000e+01), SC_(-7.2786285400390625000000000000000000000000e+01), SC_(6.0422277450561523437500000000000000000000e-01), SC_(1.0846547724702744197343131541581530756688e-17) }, 
      { SC_(-7.0697021484375000000000000000000000000000e+01), SC_(-1.5829277038574218750000000000000000000000e+01), SC_(-6.2185577392578125000000000000000000000000e+01), SC_(3.7146770954132080078125000000000000000000e-01), SC_(1.8834046039061374900232645939389151450431e-04) }, 
      { SC_(-7.0478363037109375000000000000000000000000e+01), SC_(-6.2433837890625000000000000000000000000000e+01), SC_(-8.9005187988281250000000000000000000000000e+01), SC_(-8.0702638626098632812500000000000000000000e-01), SC_(8.9051601643321376967879812392832179011689e+12) }, 
      { SC_(-7.0141204833984375000000000000000000000000e+01), SC_(-5.3968795776367187500000000000000000000000e+01), SC_(-4.8498352050781250000000000000000000000000e+01), SC_(6.1946892738342285156250000000000000000000e-01), SC_(-6.0740730151294769477712549301139291683441e+15) }, 
      { SC_(-6.9524414062500000000000000000000000000000e+01), SC_(6.3800811767578125000000000000000000000000e-01), SC_(6.5163391113281250000000000000000000000000e+01), SC_(-7.5051605701446533203125000000000000000000e-02), SC_(1.0545716156248884528774966192710496999131e+00) }, 
      { SC_(-6.9268676757812500000000000000000000000000e+01), SC_(5.4085617065429687500000000000000000000000e+00), SC_(-4.3798950195312500000000000000000000000000e+01), SC_(-4.7590243816375732421875000000000000000000e-01), SC_(4.3637842866902011105563625889794681265094e+16) }, 
      { SC_(-6.9126037597656250000000000000000000000000e+01), SC_(1.2645980834960937500000000000000000000000e+01), SC_(-2.3730957031250000000000000000000000000000e+01), SC_(8.4846496582031250000000000000000000000000e-01), SC_(-1.7847757439081321082038914267055395236548e+01) }, 
      { SC_(-6.8719024658203125000000000000000000000000e+01), SC_(-3.2840423583984375000000000000000000000000e+01), SC_(7.1104553222656250000000000000000000000000e+01), SC_(-4.9435329437255859375000000000000000000000e-01), SC_(-3.9629807045196630734921412963646749308091e-10) }, 
      { SC_(-6.8477386474609375000000000000000000000000e+01), SC_(4.5167785644531250000000000000000000000000e+01), SC_(9.4118560791015625000000000000000000000000e+01), SC_(9.6221923828125000000000000000000000000000e-01), SC_(8.7969255136773827970071180494258356224427e-14) }, 
      { SC_(-6.7773223876953125000000000000000000000000e+01), SC_(2.1047439575195312500000000000000000000000e+01), SC_(5.1622482299804687500000000000000000000000e+01), SC_(-7.9735589027404785156250000000000000000000e-01), SC_(6.3526235125992715103494564841236767858443e+09) }, 
      { SC_(-6.7703063964843750000000000000000000000000e+01), SC_(-2.3631973266601562500000000000000000000000e+00), SC_(-6.4246765136718750000000000000000000000000e+01), SC_(-1.4174687862396240234375000000000000000000e-01), SC_(1.3896016472866112520264300116761366187137e+00) }, 
      { SC_(-6.7563537597656250000000000000000000000000e+01), SC_(8.5498565673828125000000000000000000000000e+01), SC_(5.8856903076171875000000000000000000000000e+01), SC_(-1.2776488065719604492187500000000000000000e-01), SC_(7.6853309613078182660673469405060291873242e+04) }, 
      { SC_(-6.7297546386718750000000000000000000000000e+01), SC_(2.0732643127441406250000000000000000000000e+01), SC_(8.4219451904296875000000000000000000000000e+01), SC_(9.0577077865600585937500000000000000000000e-01), SC_(3.6784472383700761148790768718812977618927e-06) }, 
      { SC_(-6.7286041259765625000000000000000000000000e+01), SC_(3.2101364135742187500000000000000000000000e+01), SC_(3.3197433471679687500000000000000000000000e+01), SC_(-8.7251281738281250000000000000000000000000e-01), SC_(1.0196751271859094042242292521415219793170e+18) }, 
      { SC_(-6.6870269775390625000000000000000000000000e+01), SC_(-7.6090576171875000000000000000000000000000e+01), SC_(2.0396385192871093750000000000000000000000e+01), SC_(-5.6086421012878417968750000000000000000000e-02), SC_(3.5387920687944564414242496747495842134161e-07) }, 
      { SC_(-6.6759307861328125000000000000000000000000e+01), SC_(1.9646347045898437500000000000000000000000e+01), SC_(2.4499450683593750000000000000000000000000e+01), SC_(6.5354895591735839843750000000000000000000e-01), SC_(5.1775000983332194614276699577185260609589e-13) }, 
      { SC_(-6.6707916259765625000000000000000000000000e+01), SC_(-6.4737701416015625000000000000000000000000e+01), SC_(2.4191726684570312500000000000000000000000e+01), SC_(-2.5808393955230712890625000000000000000000e-01), SC_(-2.7634536781579350888840808620590088963738e-09) }, 
      { SC_(-6.6566314697265625000000000000000000000000e+01), SC_(-6.5576446533203125000000000000000000000000e+01), SC_(-7.8756744384765625000000000000000000000000e+01), SC_(-1.4420807361602783203125000000000000000000e-02), SC_(2.2116319919123790315751016733203359203854e+00) }, 
      { SC_(-6.6349761962890625000000000000000000000000e+01), SC_(-9.6683471679687500000000000000000000000000e+01), SC_(-6.0750228881835937500000000000000000000000e+01), SC_(-6.4445614814758300781250000000000000000000e-02), SC_(7.4021608233332690169674116354027930209125e+02) }, 
      { SC_(-6.5322296142578125000000000000000000000000e+01), SC_(4.2780776977539062500000000000000000000000e+01), SC_(-2.1812438964843750000000000000000000000000e+01), SC_(2.3440980911254882812500000000000000000000e-01), SC_(1.8749588917628545070665589271816006531710e+11) }, 
      { SC_(-6.4825134277343750000000000000000000000000e+01), SC_(-2.7257766723632812500000000000000000000000e+00), SC_(4.4351608276367187500000000000000000000000e+01), SC_(-1.8499618768692016601562500000000000000000e-01), SC_(4.1832370208523043684043256699651596562344e-01) }, 
      { SC_(-6.4479522705078125000000000000000000000000e+01), SC_(4.7261398315429687500000000000000000000000e+01), SC_(-2.0282104492187500000000000000000000000000e+01), SC_(3.1309652328491210937500000000000000000000e-01), SC_(-6.5104590298349292203032994554535828510869e+11) }, 
      { SC_(-6.4376617431640625000000000000000000000000e+01), SC_(7.3792510986328125000000000000000000000000e+01), SC_(-2.8073020935058593750000000000000000000000e+01), SC_(9.9408268928527832031250000000000000000000e-01), SC_(4.5930535441453192439974950529256168283126e+81) }, 
      { SC_(-6.4373504638671875000000000000000000000000e+01), SC_(-3.7464614868164062500000000000000000000000e+01), SC_(-7.4397125244140625000000000000000000000000e+01), SC_(7.6345086097717285156250000000000000000000e-01), SC_(4.3664561994587762580306333108844835383804e-20) }, 
      { SC_(-6.3852447509765625000000000000000000000000e+01), SC_(9.0414428710937500000000000000000000000000e+00), SC_(-4.8922653198242187500000000000000000000000e+01), SC_(-8.6073660850524902343750000000000000000000e-01), SC_(-4.5767712847172740359407725311662054417895e+26) }, 
      { SC_(-6.3630599975585937500000000000000000000000e+01), SC_(9.6472106933593750000000000000000000000000e+01), SC_(-4.7239425659179687500000000000000000000000e+01), SC_(-8.0928969383239746093750000000000000000000e-01), SC_(6.2639434072786183858111511155985724525952e+58) }, 
      { SC_(-6.3415512084960937500000000000000000000000e+01), SC_(-5.0996154785156250000000000000000000000000e+01), SC_(-5.2013595581054687500000000000000000000000e+01), SC_(-3.3398950099945068359375000000000000000000e-01), SC_(5.9658911501147955944436588777194643663610e+07) }, 
      { SC_(-6.3218444824218750000000000000000000000000e+01), SC_(9.5420074462890625000000000000000000000000e-01), SC_(-5.2009506225585937500000000000000000000000e+01), SC_(6.4520978927612304687500000000000000000000e-01), SC_(6.3913394369645789475272270662944212160363e+00) }, 
      { SC_(-6.2625488281250000000000000000000000000000e+01), SC_(-1.8253768920898437500000000000000000000000e+01), SC_(-2.0471191406250000000000000000000000000000e+00), SC_(-8.4021687507629394531250000000000000000000e-02), SC_(3.7293606003355180066787745283883349916656e+04) }, 
      { SC_(-6.2507843017578125000000000000000000000000e+01), SC_(5.3933105468750000000000000000000000000000e+00), SC_(-4.6764236450195312500000000000000000000000e+01), SC_(9.9972248077392578125000000000000000000000e-01), SC_(1.2731818825448633291760587912077373874772e+03) }, 
      { SC_(-6.2267608642578125000000000000000000000000e+01), SC_(7.6988525390625000000000000000000000000000e+01), SC_(-4.2500366210937500000000000000000000000000e+01), SC_(1.8617391586303710937500000000000000000000e-01), SC_(1.2057331067351839484689697821624899214895e+12) }, 
      { SC_(-6.2057922363281250000000000000000000000000e+01), SC_(3.4727432250976562500000000000000000000000e+01), SC_(-9.9884033203125000000000000000000000000000e-01), SC_(-6.4609384536743164062500000000000000000000e-01), SC_(-2.8381574783959222602260432582371543993437e+37) }, 
      { SC_(-6.1913345336914062500000000000000000000000e+01), SC_(-8.6979141235351562500000000000000000000000e+00), SC_(-2.6216690063476562500000000000000000000000e+01), SC_(2.6860666275024414062500000000000000000000e-01), SC_(5.6871889230703938075720169849359144097334e-04) }, 
      { SC_(-6.1815261840820312500000000000000000000000e+01), SC_(1.9196197509765625000000000000000000000000e+01), SC_(-1.4349403381347656250000000000000000000000e+01), SC_(4.5378625392913818359375000000000000000000e-01), SC_(-4.8423199032777639255933373341071195538133e+04) }, 
      { SC_(-6.1650955200195312500000000000000000000000e+01), SC_(8.5724258422851562500000000000000000000000e+00), SC_(4.7685379028320312500000000000000000000000e+01), SC_(5.1184940338134765625000000000000000000000e-01), SC_(9.8712674487346525801317903031872594596145e-03) }, 
      { SC_(-6.1594329833984375000000000000000000000000e+01), SC_(5.4357208251953125000000000000000000000000e+01), SC_(-7.2225158691406250000000000000000000000000e+01), SC_(9.6308064460754394531250000000000000000000e-01), SC_(-2.1231270443957752279275283022178295800877e+92) }, 
      { SC_(-6.0680953979492187500000000000000000000000e+01), SC_(6.9693542480468750000000000000000000000000e+01), SC_(-4.9783233642578125000000000000000000000000e+01), SC_(9.1003513336181640625000000000000000000000e-01), SC_(-9.4047084123911725222470596829262988956831e+61) }, 
      { SC_(-6.0027435302734375000000000000000000000000e+01), SC_(9.9118713378906250000000000000000000000000e+01), SC_(-1.8609031677246093750000000000000000000000e+01), SC_(2.7878820896148681640625000000000000000000e-01), SC_(-1.3091704000032772309698966291820433073607e+18) }, 
      { SC_(-5.8794433593750000000000000000000000000000e+01), SC_(-5.8501922607421875000000000000000000000000e+01), SC_(-8.2666687011718750000000000000000000000000e+01), SC_(-8.2993483543395996093750000000000000000000e-01), SC_(1.6208014797676874861339351529571069872551e+11) }, 
      { SC_(-5.8451553344726562500000000000000000000000e+01), SC_(8.0276031494140625000000000000000000000000e+00), SC_(-3.9750732421875000000000000000000000000000e+01), SC_(-9.6309828758239746093750000000000000000000e-01), SC_(6.7223541066589672483778374832502332111801e+29) }, 
      { SC_(-5.8213027954101562500000000000000000000000e+01), SC_(1.7575408935546875000000000000000000000000e+01), SC_(4.1856338500976562500000000000000000000000e+01), SC_(2.9956150054931640625000000000000000000000e-01), SC_(1.0948313508625980070821644662700971088036e-03) }, 
      { SC_(-5.8210678100585937500000000000000000000000e+01), SC_(7.1303070068359375000000000000000000000000e+01), SC_(8.1030700683593750000000000000000000000000e+01), SC_(-6.3861393928527832031250000000000000000000e-01), SC_(2.5618369233505033870136570400756548023576e+11) }, 
      { SC_(-5.7593841552734375000000000000000000000000e+01), SC_(9.0122772216796875000000000000000000000000e+01), SC_(-8.4530639648437500000000000000000000000000e+01), SC_(7.0587086677551269531250000000000000000000e-01), SC_(-7.9254313083176945165652191025826353362881e+59) }, 
      { SC_(-5.7567367553710937500000000000000000000000e+01), SC_(-2.5097007751464843750000000000000000000000e+01), SC_(-8.0296264648437500000000000000000000000000e+01), SC_(-7.2414827346801757812500000000000000000000e-01), SC_(2.9999575670519952026512132340406360039580e+04) }, 
      { SC_(-5.6487335205078125000000000000000000000000e+01), SC_(-8.2621612548828125000000000000000000000000e+01), SC_(-4.9791641235351562500000000000000000000000e+01), SC_(-5.8968424797058105468750000000000000000000e-01), SC_(1.9827126170877481076005086775535907803207e+19) }, 
      { SC_(-5.6264678955078125000000000000000000000000e+01), SC_(5.3474014282226562500000000000000000000000e+01), SC_(-7.8840362548828125000000000000000000000000e+01), SC_(7.2393751144409179687500000000000000000000e-01), SC_(1.0238827467350312226844353214132577661043e+36) }, 
      { SC_(-5.5650665283203125000000000000000000000000e+01), SC_(6.6242858886718750000000000000000000000000e+01), SC_(-7.6516479492187500000000000000000000000000e+01), SC_(-3.5007297992706298828125000000000000000000e-01), SC_(1.9673673969369153684259651657363724036034e-07) }, 
      { SC_(-5.4815643310546875000000000000000000000000e+01), SC_(-7.0434204101562500000000000000000000000000e+01), SC_(-6.5858398437500000000000000000000000000000e+01), SC_(-5.2099514007568359375000000000000000000000e-01), SC_(4.4423596011872687409979089273536408966491e+10) }, 
      { SC_(-5.4467147827148437500000000000000000000000e+01), SC_(5.9930633544921875000000000000000000000000e+01), SC_(-1.2860260009765625000000000000000000000000e+01), SC_(-5.3969860076904296875000000000000000000000e-02), SC_(-1.1305845224403924977706627424909708448554e+15) }, 
      { SC_(-5.4209350585937500000000000000000000000000e+01), SC_(-3.9049621582031250000000000000000000000000e+01), SC_(2.8388122558593750000000000000000000000000e+01), SC_(1.6177880764007568359375000000000000000000e-01), SC_(7.4998603012268182561544893124236336270894e+03) }, 
      { SC_(-5.4204605102539062500000000000000000000000e+01), SC_(1.0997085571289062500000000000000000000000e+00), SC_(8.2667449951171875000000000000000000000000e+01), SC_(1.1653757095336914062500000000000000000000e-01), SC_(9.2205274652680315191199270884052719823372e-01) }, 
      { SC_(-5.3044021606445312500000000000000000000000e+01), SC_(1.0576232910156250000000000000000000000000e+01), SC_(-2.9368286132812500000000000000000000000000e+01), SC_(-8.9369487762451171875000000000000000000000e-01), SC_(2.8451271031902901481116109219433829229750e+31) }, 
      { SC_(-5.2753890991210937500000000000000000000000e+01), SC_(-3.4352706909179687500000000000000000000000e+01), SC_(-7.6120758056640625000000000000000000000000e+01), SC_(-7.7784132957458496093750000000000000000000e-01), SC_(1.7290314915471703617174577654077393937218e+06) }, 
      { SC_(-5.2543289184570312500000000000000000000000e+01), SC_(9.3728057861328125000000000000000000000000e+01), SC_(-8.2302322387695312500000000000000000000000e+00), SC_(-5.7245469093322753906250000000000000000000e-01), SC_(-1.8730183534535028697608872626026591797880e+47) }, 
      { SC_(-5.2016769409179687500000000000000000000000e+01), SC_(-9.1905792236328125000000000000000000000000e+01), SC_(-7.5336212158203125000000000000000000000000e+01), SC_(-4.9408805370330810546875000000000000000000e-01), SC_(7.9758806017921736081133701121993198816024e+10) }, 
      { SC_(-5.1904327392578125000000000000000000000000e+01), SC_(-8.8823059082031250000000000000000000000000e+01), SC_(5.2779586791992187500000000000000000000000e+01), SC_(1.2003421783447265625000000000000000000000e-02), SC_(2.7819385627399676194556885245520989897049e+00) }, 
      { SC_(-5.1858596801757812500000000000000000000000e+01), SC_(-1.6847496032714843750000000000000000000000e+01), SC_(3.5224456787109375000000000000000000000000e+01), SC_(-5.0563216209411621093750000000000000000000e-02), SC_(2.6027885346893623175471232391765498835311e-01) }, 
      { SC_(-5.1661743164062500000000000000000000000000e+01), SC_(-4.5449401855468750000000000000000000000000e+01), SC_(-1.9217575073242187500000000000000000000000e+01), SC_(-1.5116035938262939453125000000000000000000e-02), SC_(6.4883342134136796374567903425412577457082e+00) }, 
      { SC_(-5.1502685546875000000000000000000000000000e+01), SC_(-9.7795104980468750000000000000000000000000e+01), SC_(-8.9249145507812500000000000000000000000000e+01), SC_(-2.1545106172561645507812500000000000000000e-01), SC_(5.7915658703672671911267333518469080042328e+04) }, 
      { SC_(-5.1442932128906250000000000000000000000000e+01), SC_(-7.6320709228515625000000000000000000000000e+01), SC_(-1.1519538879394531250000000000000000000000e+01), SC_(-3.7386858463287353515625000000000000000000e-01), SC_(3.7295783455115214339064818174118721936177e+18) }, 
      { SC_(-5.1430084228515625000000000000000000000000e+01), SC_(-3.3604553222656250000000000000000000000000e+01), SC_(8.3484863281250000000000000000000000000000e+01), SC_(6.0352587699890136718750000000000000000000e-01), SC_(1.4054824981413232380252179755821005050872e+04) }, 
      { SC_(-5.0653106689453125000000000000000000000000e+01), SC_(-6.0109710693359375000000000000000000000000e-01), SC_(3.3283248901367187500000000000000000000000e+01), SC_(1.8194651603698730468750000000000000000000e-01), SC_(1.1585924895129757057390930871387866205928e+00) }, 
      { SC_(-4.9638778686523437500000000000000000000000e+01), SC_(3.0944717407226562500000000000000000000000e+01), SC_(-4.1911865234375000000000000000000000000000e+01), SC_(-8.4386610984802246093750000000000000000000e-01), SC_(1.8017970526718607445695480859023615390781e+30) }, 
      { SC_(-4.9041976928710937500000000000000000000000e+01), SC_(8.7042846679687500000000000000000000000000e+01), SC_(-5.5192001342773437500000000000000000000000e+01), SC_(8.3655309677124023437500000000000000000000e-01), SC_(2.1035013486140349123890504926766766313281e+73) }, 
      { SC_(-4.8711807250976562500000000000000000000000e+01), SC_(-3.1387641906738281250000000000000000000000e+01), SC_(2.2692146301269531250000000000000000000000e+01), SC_(-3.7553989887237548828125000000000000000000e-01), SC_(2.6826621341264302004283107561516315310757e-06) }, 
      { SC_(-4.8441558837890625000000000000000000000000e+01), SC_(-6.6443542480468750000000000000000000000000e+01), SC_(-2.0640136718750000000000000000000000000000e+01), SC_(-9.6222281455993652343750000000000000000000e-01), SC_(-5.9314598668212577075116347923314164294798e+29) }, 
      { SC_(-4.8387069702148437500000000000000000000000e+01), SC_(-6.7534301757812500000000000000000000000000e+01), SC_(-1.8256034851074218750000000000000000000000e+01), SC_(-7.3252725601196289062500000000000000000000e-01), SC_(-3.5327681898701434503480136447551259073113e+25) }, 
      { SC_(-4.8025924682617187500000000000000000000000e+01), SC_(-9.0988098144531250000000000000000000000000e+01), SC_(6.0013702392578125000000000000000000000000e+01), SC_(3.2023894786834716796875000000000000000000e-01), SC_(1.3823078560235207950721553555947057832598e+07) }, 
      { SC_(-4.7405746459960937500000000000000000000000e+01), SC_(-3.1956062316894531250000000000000000000000e+01), SC_(3.0815811157226562500000000000000000000000e+01), SC_(5.9683918952941894531250000000000000000000e-02), SC_(1.4085975459031608271498938044647689509894e+01) }, 
      { SC_(-4.6187683105468750000000000000000000000000e+01), SC_(7.1414489746093750000000000000000000000000e+01), SC_(5.3100006103515625000000000000000000000000e+01), SC_(-9.7021675109863281250000000000000000000000e-01), SC_(1.6588965793641544246714074557818378871347e+16) }, 
      { SC_(-4.6176116943359375000000000000000000000000e+01), SC_(9.4375457763671875000000000000000000000000e+01), SC_(-1.5432876586914062500000000000000000000000e+01), SC_(1.2792980670928955078125000000000000000000e-01), SC_(-4.6212866061587932010487602834140747384486e+10) }, 
      { SC_(-4.5945922851562500000000000000000000000000e+01), SC_(-6.4270050048828125000000000000000000000000e+01), SC_(-6.0589248657226562500000000000000000000000e+01), SC_(-8.5171437263488769531250000000000000000000e-01), SC_(9.4140385230763293510701392377503670650787e+12) }, 
      { SC_(-4.5941131591796875000000000000000000000000e+01), SC_(-6.5679412841796875000000000000000000000000e+01), SC_(-5.8307739257812500000000000000000000000000e+01), SC_(8.9478850364685058593750000000000000000000e-01), SC_(5.0846574990545698167040104333279429112059e-08) }, 
      { SC_(-4.5412246704101562500000000000000000000000e+01), SC_(6.6068298339843750000000000000000000000000e+01), SC_(-9.2553070068359375000000000000000000000000e+01), SC_(9.7566151618957519531250000000000000000000e-01), SC_(-1.6739471855768413264423394937256879557360e+187) }, 
      { SC_(-4.4794982910156250000000000000000000000000e+01), SC_(4.1154846191406250000000000000000000000000e+01), SC_(3.5940536499023437500000000000000000000000e+01), SC_(-9.9436330795288085937500000000000000000000e-01), SC_(3.0984375564230629950525407620019014660496e+14) }, 
      { SC_(-4.4615417480468750000000000000000000000000e+01), SC_(7.4485748291015625000000000000000000000000e+01), SC_(-9.0765747070312500000000000000000000000000e+01), SC_(-7.0177221298217773437500000000000000000000e-01), SC_(1.2960526651157001199295605840258690523850e-10) }, 
      { SC_(-4.4300354003906250000000000000000000000000e+01), SC_(-6.2323608398437500000000000000000000000000e+01), SC_(9.3762969970703125000000000000000000000000e+00), SC_(9.8576259613037109375000000000000000000000e-01), SC_(6.7674060667721556181168652250665771097290e+22) }, 
      { SC_(-4.3626632690429687500000000000000000000000e+01), SC_(9.8954956054687500000000000000000000000000e+01), SC_(7.7193374633789062500000000000000000000000e+00), SC_(-1.2881386280059814453125000000000000000000e-01), SC_(1.0464951291773916668427198977054403551314e+12) }, 
      { SC_(-4.2430145263671875000000000000000000000000e+01), SC_(-8.6524749755859375000000000000000000000000e+01), SC_(-1.7095497131347656250000000000000000000000e+01), SC_(-2.4995070695877075195312500000000000000000e-01), SC_(-1.8405654743103419523657970068377738824936e+16) }, 
      { SC_(-4.2187088012695312500000000000000000000000e+01), SC_(-8.8911712646484375000000000000000000000000e+01), SC_(3.4361633300781250000000000000000000000000e+01), SC_(2.2748827934265136718750000000000000000000e-01), SC_(1.0767357651210876230858909041783272554366e+07) }, 
      { SC_(-4.1962951660156250000000000000000000000000e+01), SC_(9.6984771728515625000000000000000000000000e+01), SC_(-3.6495895385742187500000000000000000000000e+01), SC_(-5.4006052017211914062500000000000000000000e-01), SC_(-7.0537320748054794202010857012245955086889e+32) }, 
      { SC_(-4.1685943603515625000000000000000000000000e+01), SC_(2.4341201782226562500000000000000000000000e+01), SC_(2.0706687927246093750000000000000000000000e+01), SC_(8.4234237670898437500000000000000000000000e-01), SC_(3.2386471041278234739833530588377672634899e-21) }, 
      { SC_(-4.1603195190429687500000000000000000000000e+01), SC_(6.4926330566406250000000000000000000000000e+01), SC_(-1.3669761657714843750000000000000000000000e+01), SC_(-2.8135120868682861328125000000000000000000e-01), SC_(5.2397974856113020264727392806528102476498e+28) }, 
      { SC_(-4.1186737060546875000000000000000000000000e+01), SC_(-6.0325439453125000000000000000000000000000e+01), SC_(-5.2525405883789062500000000000000000000000e+01), SC_(-2.1323585510253906250000000000000000000000e-01), SC_(9.0718142108755993207994142235954872793781e+03) }, 
      { SC_(-4.0893234252929687500000000000000000000000e+01), SC_(6.2082092285156250000000000000000000000000e+01), SC_(-3.3412750244140625000000000000000000000000e+01), SC_(-3.6636173725128173828125000000000000000000e-01), SC_(9.6805729181260951702175327423373273939075e+21) }, 
      { SC_(-4.0664840698242187500000000000000000000000e+01), SC_(3.1155975341796875000000000000000000000000e+01), SC_(-3.6244338989257812500000000000000000000000e+01), SC_(-1.5962010622024536132812500000000000000000e-01), SC_(5.7959827414765517990726154877060918679093e-03) }, 
      { SC_(-4.0530639648437500000000000000000000000000e+01), SC_(-8.8697784423828125000000000000000000000000e+01), SC_(-8.7590972900390625000000000000000000000000e+01), SC_(2.7755653858184814453125000000000000000000e-01), SC_(1.5791481963438470016070113444767725745065e-06) }, 
      { SC_(-4.0351211547851562500000000000000000000000e+01), SC_(-4.0705703735351562500000000000000000000000e+01), SC_(-9.0729766845703125000000000000000000000000e+01), SC_(-7.0880055427551269531250000000000000000000e-02), SC_(3.5004228794409959837363168918938613693521e+00) }, 
      { SC_(-4.0154998779296875000000000000000000000000e+01), SC_(5.8503311157226562500000000000000000000000e+01), SC_(-9.4814910888671875000000000000000000000000e+00), SC_(2.7836048603057861328125000000000000000000e-01), SC_(1.4439434339201965565942813545442105714281e+10) }, 
      { SC_(-3.9709014892578125000000000000000000000000e+01), SC_(-3.7902008056640625000000000000000000000000e+01), SC_(4.0219741821289062500000000000000000000000e+01), SC_(-7.5870227813720703125000000000000000000000e-01), SC_(1.2701347976062114506603559350924682043801e-09) }, 
      { SC_(-3.7779541015625000000000000000000000000000e+01), SC_(-8.2035369873046875000000000000000000000000e+01), SC_(8.4675933837890625000000000000000000000000e+01), SC_(2.8910112380981445312500000000000000000000e-01), SC_(5.6253023569797234854020839685772800234533e+03) }, 
      { SC_(-3.7757003784179687500000000000000000000000e+01), SC_(7.2535614013671875000000000000000000000000e+01), SC_(5.7066345214843750000000000000000000000000e+00), SC_(2.4072003364562988281250000000000000000000e-01), SC_(-7.4635402002448906204463216256424711685345e-05) }, 
      { SC_(-3.6514434814453125000000000000000000000000e+01), SC_(3.2756393432617187500000000000000000000000e+01), SC_(6.2907958984375000000000000000000000000000e+01), SC_(3.6872279644012451171875000000000000000000e-01), SC_(6.9500249594402063414904735006818460990520e-04) }, 
      { SC_(-3.6504043579101562500000000000000000000000e+01), SC_(-7.8698394775390625000000000000000000000000e+01), SC_(-3.6714202880859375000000000000000000000000e+01), SC_(-3.2254183292388916015625000000000000000000e-01), SC_(3.0654680344066183186599699894587827233706e+09) }, 
      { SC_(-3.6385192871093750000000000000000000000000e+01), SC_(4.9353652954101562500000000000000000000000e+01), SC_(-7.6157104492187500000000000000000000000000e+01), SC_(6.8971252441406250000000000000000000000000e-01), SC_(2.9904497414981152810896742366292034553914e+39) }, 
      { SC_(-3.5505645751953125000000000000000000000000e+01), SC_(-3.9067306518554687500000000000000000000000e+01), SC_(5.6947860717773437500000000000000000000000e+01), SC_(-5.6978201866149902343750000000000000000000e-01), SC_(2.0950186965180580331583393813258046647743e-08) }, 
      { SC_(-3.4833282470703125000000000000000000000000e+01), SC_(-2.8280242919921875000000000000000000000000e+01), SC_(9.2898864746093750000000000000000000000000e+00), SC_(-4.1867518424987792968750000000000000000000e-01), SC_(-1.3071731647134536835764090450076225542519e-02) }, 
      { SC_(-3.4486923217773437500000000000000000000000e+01), SC_(-3.3418441772460937500000000000000000000000e+01), SC_(3.4252868652343750000000000000000000000000e+01), SC_(3.7876570224761962890625000000000000000000e-01), SC_(8.3692377162925236656137945862019371697176e+03) }, 
      { SC_(-3.4237167358398437500000000000000000000000e+01), SC_(6.7752410888671875000000000000000000000000e+01), SC_(3.0762405395507812500000000000000000000000e+01), SC_(-5.7622122764587402343750000000000000000000e-01), SC_(1.6349560226427508445830486521941201075274e+11) }, 
      { SC_(-3.3828430175781250000000000000000000000000e+01), SC_(9.4645751953125000000000000000000000000000e+01), SC_(-1.5138099670410156250000000000000000000000e+01), SC_(2.6753377914428710937500000000000000000000e-01), SC_(5.3248995957569219017192374501100377803341e+15) }, 
      { SC_(-3.2928634643554687500000000000000000000000e+01), SC_(-7.4186767578125000000000000000000000000000e+01), SC_(3.5945587158203125000000000000000000000000e+01), SC_(-4.1607844829559326171875000000000000000000e-01), SC_(-1.2062906449109198735913390939095596490575e-08) }, 
      { SC_(-3.2830200195312500000000000000000000000000e+01), SC_(-3.3546737670898437500000000000000000000000e+01), SC_(-6.4866210937500000000000000000000000000000e+01), SC_(-9.1393661499023437500000000000000000000000e-01), SC_(1.4503002128434965380148449544924654047127e+05) }, 
      { SC_(-3.2456115722656250000000000000000000000000e+01), SC_(7.7545227050781250000000000000000000000000e+01), SC_(8.0010772705078125000000000000000000000000e+01), SC_(-3.1232094764709472656250000000000000000000e-01), SC_(5.3928209735796899834395877297251533836695e+03) }, 
      { SC_(-3.2380462646484375000000000000000000000000e+01), SC_(3.1922073364257812500000000000000000000000e+01), SC_(-4.1205398559570312500000000000000000000000e+01), SC_(-4.5912361145019531250000000000000000000000e-01), SC_(2.3812894682870491581422303005453515774886e-05) }, 
      { SC_(-3.1775077819824218750000000000000000000000e+01), SC_(4.4604843139648437500000000000000000000000e+01), SC_(2.1477844238281250000000000000000000000000e+01), SC_(-4.3261218070983886718750000000000000000000e-01), SC_(1.1898452205001496311360340068515809335667e+08) }, 
      { SC_(-3.1107513427734375000000000000000000000000e+01), SC_(-5.4754531860351562500000000000000000000000e+01), SC_(5.6103927612304687500000000000000000000000e+01), SC_(-1.0209625959396362304687500000000000000000e-01), SC_(3.0225742564889624595326314790619117963736e-02) }, 
      { SC_(-3.0457466125488281250000000000000000000000e+01), SC_(4.7136062622070312500000000000000000000000e+01), SC_(-7.0000549316406250000000000000000000000000e+01), SC_(2.3105561733245849609375000000000000000000e-01), SC_(1.1393459111301255415757951804789655292687e+02) }, 
      { SC_(-3.0424156188964843750000000000000000000000e+01), SC_(-8.3784912109375000000000000000000000000000e+01), SC_(-1.0794670104980468750000000000000000000000e+01), SC_(-3.4117698669433593750000000000000000000000e-01), SC_(2.1724051800697012153116943760181566171733e+15) }, 
      { SC_(-2.9854576110839843750000000000000000000000e+01), SC_(9.8022003173828125000000000000000000000000e+01), SC_(8.7800292968750000000000000000000000000000e+01), SC_(-5.1984810829162597656250000000000000000000e-01), SC_(8.0608923582170768888979963043411115379777e+05) }, 
      { SC_(-2.9809524536132812500000000000000000000000e+01), SC_(-6.0089767456054687500000000000000000000000e+01), SC_(2.6499023437500000000000000000000000000000e+00), SC_(-7.2399735450744628906250000000000000000000e-01), SC_(1.7853099723945183043980091693399854650117e+07) }, 
      { SC_(-2.9668098449707031250000000000000000000000e+01), SC_(-8.6480926513671875000000000000000000000000e+01), SC_(6.6165710449218750000000000000000000000000e+01), SC_(5.8719515800476074218750000000000000000000e-01), SC_(3.6649038703074576917913774580969844582608e+06) }, 
      { SC_(-2.7517707824707031250000000000000000000000e+01), SC_(-8.6510650634765625000000000000000000000000e+01), SC_(-9.0093505859375000000000000000000000000000e+01), SC_(-5.5798840522766113281250000000000000000000e-01), SC_(1.3118586391937181103811738997693537276331e+05) }, 
      { SC_(-2.6836761474609375000000000000000000000000e+01), SC_(-7.5826904296875000000000000000000000000000e+01), SC_(5.2700927734375000000000000000000000000000e+01), SC_(-5.7563257217407226562500000000000000000000e-01), SC_(8.0679032139518742720013588060911968821669e-09) }, 
      { SC_(-2.6712677001953125000000000000000000000000e+01), SC_(-8.0325897216796875000000000000000000000000e+01), SC_(-2.6160240173339843750000000000000000000000e+01), SC_(3.9498317241668701171875000000000000000000e-01), SC_(-4.1828533326866054294931171750806973794207e+11) }, 
      { SC_(-2.6512672424316406250000000000000000000000e+01), SC_(-6.9685180664062500000000000000000000000000e+01), SC_(9.7596374511718750000000000000000000000000e+01), SC_(5.3848624229431152343750000000000000000000e-01), SC_(3.1381187213185573295249550884600337581656e+03) }, 
      { SC_(-2.6303085327148437500000000000000000000000e+01), SC_(-3.1214050292968750000000000000000000000000e+01), SC_(2.5123718261718750000000000000000000000000e+01), SC_(6.3153815269470214843750000000000000000000e-01), SC_(1.7166901579246434608542945241000682959454e+05) }, 
      { SC_(-2.6150642395019531250000000000000000000000e+01), SC_(-9.3346282958984375000000000000000000000000e+01), SC_(-7.7759460449218750000000000000000000000000e+01), SC_(-6.7425584793090820312500000000000000000000e-01), SC_(6.3678892678036553215425991677954738450400e+06) }, 
      { SC_(-2.5518051147460937500000000000000000000000e+01), SC_(-6.0935058593750000000000000000000000000000e+01), SC_(-6.0376327514648437500000000000000000000000e+01), SC_(7.2861480712890625000000000000000000000000e-01), SC_(2.2960891603753466740116306708924962783494e-15) }, 
      { SC_(-2.4520889282226562500000000000000000000000e+01), SC_(1.7017921447753906250000000000000000000000e+01), SC_(-5.6796218872070312500000000000000000000000e+01), SC_(-7.8927755355834960937500000000000000000000e-01), SC_(5.4047617113999468984132259751210710043989e-03) }, 
      { SC_(-2.3910835266113281250000000000000000000000e+01), SC_(-5.8386398315429687500000000000000000000000e+01), SC_(1.3564323425292968750000000000000000000000e+01), SC_(5.4742932319641113281250000000000000000000e-02), SC_(8.2821462286017177218755911161905108679307e+01) }, 
      { SC_(-2.3076179504394531250000000000000000000000e+01), SC_(-9.6357666015625000000000000000000000000000e+01), SC_(1.6597274780273437500000000000000000000000e+01), SC_(4.9466240406036376953125000000000000000000e-01), SC_(5.6366182844855784766315023935903315350531e+10) }, 
      { SC_(-2.2345672607421875000000000000000000000000e+01), SC_(-6.6781982421875000000000000000000000000000e+01), SC_(1.0355712890625000000000000000000000000000e+01), SC_(8.3694887161254882812500000000000000000000e-01), SC_(1.5847515823221112961708800780592823179321e+13) }, 
      { SC_(-2.1847579956054687500000000000000000000000e+01), SC_(7.2398712158203125000000000000000000000000e+01), SC_(6.3228027343750000000000000000000000000000e+01), SC_(-3.2477581501007080078125000000000000000000e-01), SC_(9.6938742131080613297963432300938725712131e+02) }, 
      { SC_(-2.1308723449707031250000000000000000000000e+01), SC_(7.3892059326171875000000000000000000000000e+01), SC_(3.4286224365234375000000000000000000000000e+01), SC_(-8.4900331497192382812500000000000000000000e-01), SC_(1.3726137234052828840341759248187704148570e+09) }, 
      { SC_(-2.0695838928222656250000000000000000000000e+01), SC_(7.7012115478515625000000000000000000000000e+01), SC_(-8.7681884765625000000000000000000000000000e+01), SC_(-2.0402479171752929687500000000000000000000e-01), SC_(2.0808487499398913445599278035664133443415e-02) }, 
      { SC_(-2.0223846435546875000000000000000000000000e+01), SC_(-3.4439300537109375000000000000000000000000e+01), SC_(-1.6981323242187500000000000000000000000000e+01), SC_(-4.8194253444671630859375000000000000000000e-01), SC_(-4.8123287266138668821896655673983400325625e+08) }, 
      { SC_(-1.9638397216796875000000000000000000000000e+01), SC_(-2.3533409118652343750000000000000000000000e+01), SC_(-8.4806671142578125000000000000000000000000e+01), SC_(5.2484250068664550781250000000000000000000e-01), SC_(3.8163124156970429487829386915151709109479e-02) }, 
      { SC_(-1.9563201904296875000000000000000000000000e+01), SC_(4.6909500122070312500000000000000000000000e+01), SC_(2.4134384155273437500000000000000000000000e+01), SC_(1.7292678356170654296875000000000000000000e-01), SC_(4.0145807896456985772245244051743077132067e-05) }, 
      { SC_(-1.9522331237792968750000000000000000000000e+01), SC_(5.7637390136718750000000000000000000000000e+01), SC_(9.6567016601562500000000000000000000000000e+01), SC_(4.5903706550598144531250000000000000000000e-01), SC_(2.3036181744367235438587010801729037039971e-03) }, 
      { SC_(-1.9083999633789062500000000000000000000000e+01), SC_(6.7651977539062500000000000000000000000000e+01), SC_(-1.0325416564941406250000000000000000000000e+01), SC_(1.0861754417419433593750000000000000000000e-01), SC_(8.6795817410985007235025154797315396443436e+05) }, 
      { SC_(-1.8936912536621093750000000000000000000000e+01), SC_(5.5947799682617187500000000000000000000000e+01), SC_(-7.9030761718750000000000000000000000000000e+01), SC_(-8.4559321403503417968750000000000000000000e-01), SC_(4.4269171809818970373734526765789152576597e-06) }, 
      { SC_(-1.8476158142089843750000000000000000000000e+01), SC_(3.2095642089843750000000000000000000000000e+00), SC_(6.3996246337890625000000000000000000000000e+01), SC_(4.4890785217285156250000000000000000000000e-01), SC_(6.7204665862734583986490115032394834323976e-01) }, 
      { SC_(-1.6594207763671875000000000000000000000000e+01), SC_(-2.0053993225097656250000000000000000000000e+01), SC_(-5.8804901123046875000000000000000000000000e+01), SC_(4.3673288822174072265625000000000000000000e-01), SC_(5.9939525375990366862037372512491340348182e-02) }, 
      { SC_(-1.6546592712402343750000000000000000000000e+01), SC_(9.6344604492187500000000000000000000000000e+01), SC_(-9.0069122314453125000000000000000000000000e+01), SC_(6.4691066741943359375000000000000000000000e-01), SC_(1.6975638709736619096327478512023729615565e+93) }, 
      { SC_(-1.6451179504394531250000000000000000000000e+01), SC_(1.3355484008789062500000000000000000000000e+01), SC_(9.6610504150390625000000000000000000000000e+01), SC_(1.0876059532165527343750000000000000000000e-01), SC_(7.8086927504491624415850251076023695432937e-01) }, 
      { SC_(-1.5647743225097656250000000000000000000000e+01), SC_(-7.7507110595703125000000000000000000000000e+01), SC_(8.3147094726562500000000000000000000000000e+01), SC_(2.7952671051025390625000000000000000000000e-01), SC_(3.3408480713946137623146934396682625809981e+01) }, 
      { SC_(-1.5470870971679687500000000000000000000000e+01), SC_(-3.5134735107421875000000000000000000000000e+01), SC_(-2.8078735351562500000000000000000000000000e+01), SC_(9.4535803794860839843750000000000000000000e-01), SC_(1.7031886725956986949664492950087485946139e-03) }, 
      { SC_(-1.5422859191894531250000000000000000000000e+01), SC_(-2.1054458618164062500000000000000000000000e+01), SC_(-8.1154144287109375000000000000000000000000e+01), SC_(5.5290746688842773437500000000000000000000e-01), SC_(8.1693701015567103589080878448567261032030e-02) }, 
      { SC_(-1.5378120422363281250000000000000000000000e+01), SC_(-2.5557731628417968750000000000000000000000e+01), SC_(3.1114639282226562500000000000000000000000e+01), SC_(-8.4417319297790527343750000000000000000000e-01), SC_(9.4202659019492176433662725408399006500618e-05) }, 
      { SC_(-1.5166648864746093750000000000000000000000e+01), SC_(5.6381835937500000000000000000000000000000e+01), SC_(1.5716552734375000000000000000000000000000e+00), SC_(-7.7361512184143066406250000000000000000000e-01), SC_(1.3656432868379144490224154441075917258934e+14) }, 
      { SC_(-1.5133041381835937500000000000000000000000e+01), SC_(1.3922355651855468750000000000000000000000e+01), SC_(-1.4128837585449218750000000000000000000000e+01), SC_(-1.0730677843093872070312500000000000000000e-01), SC_(2.2099414252176895968533060510551888673303e-01) }, 
      { SC_(-1.4948135375976562500000000000000000000000e+01), SC_(5.3993133544921875000000000000000000000000e+01), SC_(-3.7456222534179687500000000000000000000000e+01), SC_(-1.6495645046234130859375000000000000000000e-02), SC_(6.9983522153380675320158382503925511547669e-01) }, 
      { SC_(-1.4854232788085937500000000000000000000000e+01), SC_(8.0004425048828125000000000000000000000000e+01), SC_(2.8888565063476562500000000000000000000000e+01), SC_(8.9942908287048339843750000000000000000000e-01), SC_(-1.5447129680168585078056956534325282699441e+03) }, 
      { SC_(-1.3958518981933593750000000000000000000000e+01), SC_(2.6612731933593750000000000000000000000000e+01), SC_(-6.3036743164062500000000000000000000000000e+01), SC_(1.6876447200775146484375000000000000000000e-01), SC_(2.6730262076354146416346725246406481569055e+00) }, 
      { SC_(-1.3717231750488281250000000000000000000000e+01), SC_(4.9988204956054687500000000000000000000000e+01), SC_(8.2129516601562500000000000000000000000000e+01), SC_(-7.3400807380676269531250000000000000000000e-01), SC_(1.6887838077342462299297895363649823563128e+02) }, 
      { SC_(-1.3521697998046875000000000000000000000000e+01), SC_(-5.1136077880859375000000000000000000000000e+01), SC_(6.5062744140625000000000000000000000000000e+01), SC_(1.1838793754577636718750000000000000000000e-02), SC_(1.1331337306088766637667529328591011892825e+00) }, 
      { SC_(-1.3471534729003906250000000000000000000000e+01), SC_(-8.9580230712890625000000000000000000000000e+01), SC_(3.1099609375000000000000000000000000000000e+01), SC_(2.2176873683929443359375000000000000000000e-01), SC_(4.8393011180347228715546379427778736167332e+02) }, 
      { SC_(-1.2271003723144531250000000000000000000000e+01), SC_(9.2284149169921875000000000000000000000000e+01), SC_(6.6700103759765625000000000000000000000000e+01), SC_(-5.4680180549621582031250000000000000000000e-01), SC_(9.5585467700965533423725877203848989362657e+02) }, 
      { SC_(-1.2251129150390625000000000000000000000000e+01), SC_(-7.4820678710937500000000000000000000000000e+01), SC_(-2.3688308715820312500000000000000000000000e+01), SC_(-5.7958197593688964843750000000000000000000e-01), SC_(-4.2994334389153014851505221418295363794845e+13) }, 
      { SC_(-1.2226005554199218750000000000000000000000e+01), SC_(3.6081329345703125000000000000000000000000e+01), SC_(-7.7776153564453125000000000000000000000000e+01), SC_(4.1464304924011230468750000000000000000000e-01), SC_(-1.5111374492448970627036471924999991290617e+08) }, 
      { SC_(-1.1992881774902343750000000000000000000000e+01), SC_(8.0413513183593750000000000000000000000000e+01), SC_(-4.8477249145507812500000000000000000000000e+01), SC_(-1.1373281478881835937500000000000000000000e-01), SC_(9.0883687238132195143252067317596578287037e-02) }, 
      { SC_(-1.1982971191406250000000000000000000000000e+01), SC_(-3.3249664306640625000000000000000000000000e+00), SC_(5.4285507202148437500000000000000000000000e+00), SC_(-7.3838925361633300781250000000000000000000e-01), SC_(2.8959087150881532848022246692264939664204e-01) }, 
      { SC_(-1.1655586242675781250000000000000000000000e+01), SC_(8.1334655761718750000000000000000000000000e+01), SC_(-9.7343383789062500000000000000000000000000e+01), SC_(9.7456622123718261718750000000000000000000e-01), SC_(2.8203372220650294989105488686567744139814e+299) }, 
      { SC_(-1.1538917541503906250000000000000000000000e+01), SC_(3.3283370971679687500000000000000000000000e+01), SC_(-9.6084472656250000000000000000000000000000e+01), SC_(-6.9406867027282714843750000000000000000000e-01), SC_(5.2095758708891902364987033026014643043677e-02) }, 
      { SC_(-1.0882759094238281250000000000000000000000e+01), SC_(-2.4862136840820312500000000000000000000000e+00), SC_(2.9262603759765625000000000000000000000000e+01), SC_(5.8794999122619628906250000000000000000000e-01), SC_(1.6232600272484698910490904567892560342905e+00) }, 
      { SC_(-1.0643249511718750000000000000000000000000e+01), SC_(5.1157974243164062500000000000000000000000e+01), SC_(-3.8730102539062500000000000000000000000000e+01), SC_(-7.8387618064880371093750000000000000000000e-01), SC_(4.4071450087733015219023513956577746901457e-03) }, 
      { SC_(-9.8916854858398437500000000000000000000000e+00), SC_(4.4098693847656250000000000000000000000000e+01), SC_(-8.3235748291015625000000000000000000000000e+01), SC_(8.2515501976013183593750000000000000000000e-01), SC_(6.6990781247627810619281647548615682385854e+101) }, 
      { SC_(-9.6521530151367187500000000000000000000000e+00), SC_(5.1474380493164062500000000000000000000000e+01), SC_(2.1971427917480468750000000000000000000000e+01), SC_(3.3328831195831298828125000000000000000000e-01), SC_(1.3348419597609026650535834012487394395544e-05) }, 
      { SC_(-8.7884674072265625000000000000000000000000e+00), SC_(7.6149566650390625000000000000000000000000e+01), SC_(-7.9666137695312500000000000000000000000000e+01), SC_(-9.6109533309936523437500000000000000000000e-01), SC_(1.7409270713567031537159097656653548508327e-06) }, 
      { SC_(-8.5151290893554687500000000000000000000000e+00), SC_(-8.1111846923828125000000000000000000000000e+01), SC_(7.5074310302734375000000000000000000000000e+01), SC_(-7.5923681259155273437500000000000000000000e-01), SC_(-2.4686420264646304384764061076462515177563e-06) }, 
      { SC_(-8.2549057006835937500000000000000000000000e+00), SC_(6.6458969116210937500000000000000000000000e+00), SC_(3.2388946533203125000000000000000000000000e+01), SC_(3.2460057735443115234375000000000000000000e-01), SC_(5.7591546156290935160185776472870151665795e-01) }, 
      { SC_(-7.8548126220703125000000000000000000000000e+00), SC_(5.9525985717773437500000000000000000000000e+00), SC_(9.6327575683593750000000000000000000000000e+01), SC_(-4.2611360549926757812500000000000000000000e-03), SC_(1.0020704767425015998659139516096800507460e+00) }, 
      { SC_(-7.8167266845703125000000000000000000000000e+00), SC_(-1.0715209960937500000000000000000000000000e+01), SC_(5.4031951904296875000000000000000000000000e+01), SC_(9.4188833236694335937500000000000000000000e-01), SC_(3.5617945484060047286925199738717910915513e+00) }, 
      { SC_(-7.5101699829101562500000000000000000000000e+00), SC_(-6.1968841552734375000000000000000000000000e+00), SC_(-1.5130195617675781250000000000000000000000e+01), SC_(-9.9399757385253906250000000000000000000000e-01), SC_(1.0536840767744369684411442124450334954028e+01) }, 
      { SC_(-7.0320129394531250000000000000000000000000e+00), SC_(6.9715698242187500000000000000000000000000e+01), SC_(5.2791412353515625000000000000000000000000e+01), SC_(-2.7058386802673339843750000000000000000000e-01), SC_(8.5156178523843408873768810903198120200415e+00) }, 
      { SC_(-6.5863647460937500000000000000000000000000e+00), SC_(7.6818328857421875000000000000000000000000e+01), SC_(2.9639678955078125000000000000000000000000e+01), SC_(-1.8178373575210571289062500000000000000000e-01), SC_(1.2258114565096646631114651237423474137155e+01) }, 
      { SC_(-5.8153305053710937500000000000000000000000e+00), SC_(8.0036621093750000000000000000000000000000e+01), SC_(-5.3902374267578125000000000000000000000000e+01), SC_(-6.1100935935974121093750000000000000000000e-01), SC_(1.3122155308829003008304057490358411082831e-04) }, 
      { SC_(-5.7285690307617187500000000000000000000000e+00), SC_(-5.0482986450195312500000000000000000000000e+01), SC_(-9.2847473144531250000000000000000000000000e+01), SC_(6.1290192604064941406250000000000000000000e-01), SC_(9.5070857556238225666432318606510357923184e-02) }, 
      { SC_(-5.3027954101562500000000000000000000000000e+00), SC_(-5.6874145507812500000000000000000000000000e+01), SC_(-6.9455780029296875000000000000000000000000e+01), SC_(8.0504179000854492187500000000000000000000e-02), SC_(6.9641850777047129302958859629949418198088e-01) }, 
      { SC_(-4.1073532104492187500000000000000000000000e+00), SC_(4.2438537597656250000000000000000000000000e+01), SC_(2.7863395690917968750000000000000000000000e+01), SC_(9.6533560752868652343750000000000000000000e-01), SC_(-1.5278343712826421763753637278384855254189e+00) }, 
      { SC_(-3.5955886840820312500000000000000000000000e+00), SC_(7.5514617919921875000000000000000000000000e+01), SC_(-7.5877685546875000000000000000000000000000e+01), SC_(4.1431939601898193359375000000000000000000e-01), SC_(2.6053292603279411907832442939636614680310e+43) }, 
      { SC_(-3.1039276123046875000000000000000000000000e+00), SC_(6.8775512695312500000000000000000000000000e+01), SC_(-6.9630889892578125000000000000000000000000e+01), SC_(-2.2385549545288085937500000000000000000000e-01), SC_(4.6394303847360351620341797222406710724840e-01) }, 
      { SC_(-2.6416702270507812500000000000000000000000e+00), SC_(8.2112976074218750000000000000000000000000e+01), SC_(-1.2828285217285156250000000000000000000000e+01), SC_(-2.2764563560485839843750000000000000000000e-02), SC_(6.6366388953585649795868675273210020042839e-01) }, 
      { SC_(-2.2782058715820312500000000000000000000000e+00), SC_(-3.1134414672851562500000000000000000000000e+01), SC_(1.5705017089843750000000000000000000000000e+01), SC_(-4.3674540519714355468750000000000000000000e-01), SC_(-5.5548366441725922812416868352850719726614e-02) }, 
      { SC_(-2.2204513549804687500000000000000000000000e+00), SC_(-1.7341873168945312500000000000000000000000e+01), SC_(2.4812019348144531250000000000000000000000e+01), SC_(-6.5969562530517578125000000000000000000000e-01), SC_(2.2934904835309131518373690118450246384183e-01) }, 
      { SC_(-2.0859985351562500000000000000000000000000e+00), SC_(2.8872940063476562500000000000000000000000e+01), SC_(-6.1497924804687500000000000000000000000000e+01), SC_(9.5166349411010742187500000000000000000000e-01), SC_(-3.7832925583430069414911845252456572193451e+133) }, 
      { SC_(-2.0624694824218750000000000000000000000000e+00), SC_(-5.9160568237304687500000000000000000000000e+01), SC_(-3.2101318359375000000000000000000000000000e+01), SC_(2.3254454135894775390625000000000000000000e-01), SC_(3.1817412845117495192559345255545563227697e-01) }, 
      { SC_(-2.0197219848632812500000000000000000000000e+00), SC_(-3.7968811035156250000000000000000000000000e+01), SC_(-6.6414581298828125000000000000000000000000e+01), SC_(9.2599487304687500000000000000000000000000e-01), SC_(1.1745266096797947586536116916142021163135e+02) }, 
      { SC_(-1.8271789550781250000000000000000000000000e+00), SC_(-5.0430480957031250000000000000000000000000e+01), SC_(-2.1494750976562500000000000000000000000000e+00), SC_(8.8112235069274902343750000000000000000000e-02), SC_(6.2622767188879640072354187094147644885569e+00) }, 
      { SC_(-1.1652145385742187500000000000000000000000e+00), SC_(-9.7492248535156250000000000000000000000000e+01), SC_(5.5810348510742187500000000000000000000000e+01), SC_(-4.2682683467864990234375000000000000000000e-01), SC_(1.9878074470604875457483079434898644469853e-01) }, 
      { SC_(-3.8114166259765625000000000000000000000000e-01), SC_(-8.1170043945312500000000000000000000000000e+01), SC_(8.0170501708984375000000000000000000000000e+01), SC_(-4.5217657089233398437500000000000000000000e-01), SC_(7.9345924897945462948980413828192423019918e-01) }, 
      { SC_(4.4860839843750000000000000000000000000000e-03), SC_(-4.9211380004882812500000000000000000000000e+01), SC_(-4.0155715942382812500000000000000000000000e+00), SC_(-1.9696086645126342773437500000000000000000e-01), SC_(-2.0444417367483377530161713788862269489973e+05) }, 
      { SC_(9.4329833984375000000000000000000000000000e-02), SC_(-3.5493408203125000000000000000000000000000e+01), SC_(-5.7823257446289062500000000000000000000000e+00), SC_(-3.6353576183319091796875000000000000000000e-01), SC_(1.2970118979577502893523159349050596800441e+07) }, 
      { SC_(1.0856246948242187500000000000000000000000e+00), SC_(8.9586639404296875000000000000000000000000e+01), SC_(5.2285186767578125000000000000000000000000e+01), SC_(1.0386490821838378906250000000000000000000e-01), SC_(1.2365709904098941448449077079123941507814e+00) }, 
      { SC_(1.1273269653320312500000000000000000000000e+00), SC_(-9.9182800292968750000000000000000000000000e+01), SC_(2.7132270812988281250000000000000000000000e+01), SC_(-2.1940296888351440429687500000000000000000e-01), SC_(4.3415402237275988922890454918003980095883e+00) }, 
      { SC_(1.1914138793945312500000000000000000000000e+00), SC_(8.8014801025390625000000000000000000000000e+01), SC_(3.9815338134765625000000000000000000000000e+01), SC_(-1.7466694116592407226562500000000000000000e-01), SC_(6.7679424031165042311377675495986335128299e-01) }, 
      { SC_(1.7017364501953125000000000000000000000000e+00), SC_(-2.1282028198242187500000000000000000000000e+01), SC_(2.1543121337890625000000000000000000000000e+00), SC_(7.4037337303161621093750000000000000000000e-01), SC_(4.8086202959648534172456881874874255390106e-03) }, 
      { SC_(2.8846893310546875000000000000000000000000e+00), SC_(1.2420501708984375000000000000000000000000e+01), SC_(7.6856201171875000000000000000000000000000e+01), SC_(6.7523074150085449218750000000000000000000e-01), SC_(1.4036398242385974427485496747642536064309e+00) }, 
      { SC_(3.6104202270507812500000000000000000000000e+00), SC_(9.3967437744140625000000000000000000000000e+01), SC_(8.8724517822265625000000000000000000000000e+01), SC_(5.1256322860717773437500000000000000000000e-01), SC_(1.6762248446480170339103050091034929514154e+01) }, 
      { SC_(4.2271575927734375000000000000000000000000e+00), SC_(-6.2018905639648437500000000000000000000000e+01), SC_(-5.3681121826171875000000000000000000000000e+01), SC_(-1.9685703516006469726562500000000000000000e-01), SC_(4.2092621505902552871337489205276924122470e-01) }, 
      { SC_(4.3299713134765625000000000000000000000000e+00), SC_(3.3422821044921875000000000000000000000000e+01), SC_(-8.0653991699218750000000000000000000000000e+01), SC_(-4.2062127590179443359375000000000000000000e-01), SC_(2.3463174442636469946290388238994455086008e+00) }, 
      { SC_(4.4990692138671875000000000000000000000000e+00), SC_(6.6413574218750000000000000000000000000000e+01), SC_(9.8740905761718750000000000000000000000000e+01), SC_(9.0518951416015625000000000000000000000000e-01), SC_(7.9397069166073830101014300210578167072956e+01) }, 
      { SC_(5.0808792114257812500000000000000000000000e+00), SC_(-2.6561103820800781250000000000000000000000e+01), SC_(6.0688476562500000000000000000000000000000e+00), SC_(-8.9874815940856933593750000000000000000000e-01), SC_(7.4341112645120921187521147087832216682136e+06) }, 
      { SC_(5.3751678466796875000000000000000000000000e+00), SC_(8.1787292480468750000000000000000000000000e+01), SC_(-1.6640106201171875000000000000000000000000e+01), SC_(2.3455822467803955078125000000000000000000e-01), SC_(-1.6515086596027554416654081546749541217648e+27) }, 
      { SC_(5.5360183715820312500000000000000000000000e+00), SC_(-9.6502380371093750000000000000000000000000e+01), SC_(-4.0953216552734375000000000000000000000000e+00), SC_(-4.2843127250671386718750000000000000000000e-01), SC_(-1.7951816290574335513523025474635158051726e+27) }, 
      { SC_(6.1258544921875000000000000000000000000000e+00), SC_(1.4778564453125000000000000000000000000000e+01), SC_(6.6484680175781250000000000000000000000000e+01), SC_(2.8252744674682617187500000000000000000000e-01), SC_(1.4955342566925189377182274373419140633027e+00) }, 
      { SC_(6.1595077514648437500000000000000000000000e+00), SC_(1.8564773559570312500000000000000000000000e+01), SC_(5.5833450317382812500000000000000000000000e+01), SC_(-2.8730976581573486328125000000000000000000e-01), SC_(5.7343816109318057790872172185720631179638e-01) }, 
      { SC_(6.1728591918945312500000000000000000000000e+00), SC_(2.6223983764648437500000000000000000000000e+01), SC_(3.0889144897460937500000000000000000000000e+01), SC_(9.8901081085205078125000000000000000000000e-01), SC_(1.0622408961619778171952750018463395355454e+07) }, 
      { SC_(6.1744537353515625000000000000000000000000e+00), SC_(-6.0695892333984375000000000000000000000000e+01), SC_(-8.1700256347656250000000000000000000000000e+01), SC_(6.7051649093627929687500000000000000000000e-01), SC_(6.4220460722020085565587114241156178127003e+01) }, 
      { SC_(6.2667846679687500000000000000000000000000e+00), SC_(4.9721832275390625000000000000000000000000e+01), SC_(-3.4970870971679687500000000000000000000000e+01), SC_(3.6593294143676757812500000000000000000000e-01), SC_(-2.4265136916962172673200136214508668212023e+36) }, 
      { SC_(6.8128204345703125000000000000000000000000e+00), SC_(5.6400299072265625000000000000000000000000e+01), SC_(-8.2009887695312500000000000000000000000000e+01), SC_(4.7329044342041015625000000000000000000000e-01), SC_(-8.2761239927782759216928249190546468482991e+65) }, 
      { SC_(7.1602096557617187500000000000000000000000e+00), SC_(-2.7416847229003906250000000000000000000000e+01), SC_(-1.0963371276855468750000000000000000000000e+01), SC_(9.7976636886596679687500000000000000000000e-01), SC_(2.3043711937379500519098716267498266380243e+01) }, 
      { SC_(7.6684799194335937500000000000000000000000e+00), SC_(9.3183898925781250000000000000000000000000e+00), SC_(9.9226928710937500000000000000000000000000e+01), SC_(-1.0483121871948242187500000000000000000000e-01), SC_(9.2790852549098825312709915593678288282447e-01) }, 
      { SC_(8.7771911621093750000000000000000000000000e+00), SC_(-2.9482093811035156250000000000000000000000e+01), SC_(4.4209320068359375000000000000000000000000e+01), SC_(-6.0739946365356445312500000000000000000000e-01), SC_(4.6228874877215614418425754749038524767642e+01) }, 
      { SC_(8.9432220458984375000000000000000000000000e+00), SC_(5.1979797363281250000000000000000000000000e+01), SC_(2.9462295532226562500000000000000000000000e+01), SC_(-6.1347937583923339843750000000000000000000e-01), SC_(1.1606493179366056747050880198859339127702e-03) }, 
      { SC_(9.4017715454101562500000000000000000000000e+00), SC_(4.3694000244140625000000000000000000000000e+01), SC_(-4.0735839843750000000000000000000000000000e+01), SC_(-4.2439007759094238281250000000000000000000e-01), SC_(-1.4847246255622944271213962656121905842295e+03) }, 
      { SC_(9.4431076049804687500000000000000000000000e+00), SC_(-6.8388488769531250000000000000000000000000e+01), SC_(-7.2275115966796875000000000000000000000000e+01), SC_(5.2346229553222656250000000000000000000000e-01), SC_(6.1131470853074211441678670711892511164290e+02) }, 
      { SC_(9.5741729736328125000000000000000000000000e+00), SC_(1.9673774719238281250000000000000000000000e+01), SC_(8.8547393798828125000000000000000000000000e+01), SC_(-7.3755645751953125000000000000000000000000e-01), SC_(2.4304068452861181332911894786861220847930e-01) }, 
      { SC_(9.9080200195312500000000000000000000000000e+00), SC_(2.1691345214843750000000000000000000000000e+01), SC_(-2.9541168212890625000000000000000000000000e+00), SC_(5.5811381340026855468750000000000000000000e-01), SC_(-3.8542326987984248392759985745519869440574e+23) }, 
      { SC_(9.9720382690429687500000000000000000000000e+00), SC_(-9.8381225585937500000000000000000000000000e+01), SC_(-7.1009063720703125000000000000000000000000e+01), SC_(3.6057412624359130859375000000000000000000e-01), SC_(1.3301408196439070767382597313946493807170e+03) }, 
      { SC_(1.0458267211914062500000000000000000000000e+01), SC_(-8.8918731689453125000000000000000000000000e+01), SC_(2.5976684570312500000000000000000000000000e+01), SC_(6.9659137725830078125000000000000000000000e-01), SC_(4.6300061887002836182546541357875305549497e-07) }, 
      { SC_(1.1147598266601562500000000000000000000000e+01), SC_(-9.2961975097656250000000000000000000000000e+01), SC_(-6.3113265991210937500000000000000000000000e+01), SC_(7.0627808570861816406250000000000000000000e-01), SC_(-2.5737045895826535260235500919060220328726e+09) }, 
      { SC_(1.1557792663574218750000000000000000000000e+01), SC_(6.4261383056640625000000000000000000000000e+01), SC_(-3.7314208984375000000000000000000000000000e+01), SC_(8.3724832534790039062500000000000000000000e-01), SC_(2.5724063803410137135913072491261516205037e+130) }, 
      { SC_(1.1663841247558593750000000000000000000000e+01), SC_(1.0469894409179687500000000000000000000000e+00), SC_(4.8509078979492187500000000000000000000000e+01), SC_(8.4288668632507324218750000000000000000000e-01), SC_(1.2734060996312075315334397734956790042966e+00) }, 
      { SC_(1.1806510925292968750000000000000000000000e+01), SC_(-8.6711914062500000000000000000000000000000e+01), SC_(7.0819976806640625000000000000000000000000e+01), SC_(3.5279357433319091796875000000000000000000e-01), SC_(1.1936955943192563835270753970333260083391e-02) }, 
      { SC_(1.2372276306152343750000000000000000000000e+01), SC_(9.0428619384765625000000000000000000000000e+01), SC_(-6.3161178588867187500000000000000000000000e+01), SC_(-4.4091117382049560546875000000000000000000e-01), SC_(3.9126663225089822096868272207965452216440e+05) }, 
      { SC_(1.2995910644531250000000000000000000000000e+01), SC_(-2.9820671081542968750000000000000000000000e+01), SC_(2.8062362670898437500000000000000000000000e+01), SC_(-2.3024272918701171875000000000000000000000e-01), SC_(2.4037781551904686694031051452805890720720e+01) }, 
      { SC_(1.3764724731445312500000000000000000000000e+01), SC_(-2.1018356323242187500000000000000000000000e+01), SC_(-6.1218719482421875000000000000000000000000e+00), SC_(-2.2540819644927978515625000000000000000000e-01), SC_(-4.6676995118223747984476329807093964794517e+09) }, 
      { SC_(1.4741958618164062500000000000000000000000e+01), SC_(-6.6320037841796875000000000000000000000000e+01), SC_(-8.9584442138671875000000000000000000000000e+01), SC_(-7.7359461784362792968750000000000000000000e-01), SC_(1.1901298151159827626927301501649114871072e-03) }, 
      { SC_(1.4932235717773437500000000000000000000000e+01), SC_(-5.9727218627929687500000000000000000000000e+01), SC_(6.9035644531250000000000000000000000000000e+01), SC_(5.0623273849487304687500000000000000000000e-01), SC_(3.0100518656963267122919935622264030473278e-03) }, 
      { SC_(1.5041717529296875000000000000000000000000e+01), SC_(5.1500732421875000000000000000000000000000e+01), SC_(-8.8044097900390625000000000000000000000000e+01), SC_(-1.2950861454010009765625000000000000000000e-01), SC_(3.3580692915042382982045120171741843278087e+00) }, 
      { SC_(1.6449829101562500000000000000000000000000e+01), SC_(9.8548522949218750000000000000000000000000e+01), SC_(8.1478729248046875000000000000000000000000e+00), SC_(-4.6187138557434082031250000000000000000000e-01), SC_(2.4907207765470941152590072735118436893925e-16) }, 
      { SC_(1.6558197021484375000000000000000000000000e+01), SC_(-5.1034332275390625000000000000000000000000e+01), SC_(6.3079437255859375000000000000000000000000e+01), SC_(-7.1592998504638671875000000000000000000000e-01), SC_(2.9326867677767818889917225998669030348505e+04) }, 
      { SC_(1.6813865661621093750000000000000000000000e+01), SC_(8.1421722412109375000000000000000000000000e+01), SC_(-7.8446197509765625000000000000000000000000e+01), SC_(-2.5037491321563720703125000000000000000000e-01), SC_(3.0194776513234127717658108496905243247313e+02) }, 
      { SC_(1.7052818298339843750000000000000000000000e+01), SC_(1.8900718688964843750000000000000000000000e+01), SC_(9.9447250366210937500000000000000000000000e+00), SC_(4.6559739112854003906250000000000000000000e-01), SC_(1.0562815864019404301573399697506619318833e+08) }, 
      { SC_(1.7053543090820312500000000000000000000000e+01), SC_(6.1635101318359375000000000000000000000000e+01), SC_(-5.5237625122070312500000000000000000000000e+01), SC_(-9.6445226669311523437500000000000000000000e-01), SC_(-7.0992359144332002781882133606515432991965e+05) }, 
      { SC_(1.7218414306640625000000000000000000000000e+01), SC_(3.2526016235351562500000000000000000000000e+01), SC_(-4.7570938110351562500000000000000000000000e+01), SC_(9.0252876281738281250000000000000000000000e-01), SC_(2.9628585371680099840488410675798599138615e+138) }, 
      { SC_(1.7605209350585937500000000000000000000000e+01), SC_(-7.0338226318359375000000000000000000000000e+01), SC_(-6.9049530029296875000000000000000000000000e+01), SC_(2.7855634689331054687500000000000000000000e-01), SC_(3.5887486494045088098242441834887991762536e+02) }, 
      { SC_(1.7901489257812500000000000000000000000000e+01), SC_(-5.3046890258789062500000000000000000000000e+01), SC_(-5.4762466430664062500000000000000000000000e+01), SC_(-4.4008493423461914062500000000000000000000e-02), SC_(4.7355491508307557917053892508990893140073e-01) }, 
      { SC_(1.8871246337890625000000000000000000000000e+01), SC_(1.7352996826171875000000000000000000000000e+01), SC_(-9.5497497558593750000000000000000000000000e+01), SC_(-9.0203356742858886718750000000000000000000e-01), SC_(6.2201742812464742295369842528014391161050e+01) }, 
      { SC_(1.8979217529296875000000000000000000000000e+01), SC_(-1.0088783264160156250000000000000000000000e+01), SC_(-4.7557662963867187500000000000000000000000e+01), SC_(-9.1589188575744628906250000000000000000000e-01), SC_(2.2280692102655412926328282763551684774366e-02) }, 
      { SC_(1.9442276000976562500000000000000000000000e+01), SC_(1.5631782531738281250000000000000000000000e+01), SC_(-4.0012603759765625000000000000000000000000e+01), SC_(-2.9398000240325927734375000000000000000000e-01), SC_(1.9146073179321675726168853440535593014548e+01) }, 
      { SC_(1.9498039245605468750000000000000000000000e+01), SC_(-8.8915679931640625000000000000000000000000e+01), SC_(-3.2937744140625000000000000000000000000000e+01), SC_(9.5982956886291503906250000000000000000000e-01), SC_(1.3472083412134198754834167478576370902836e+01) }, 
      { SC_(1.9704734802246093750000000000000000000000e+01), SC_(9.4950866699218750000000000000000000000000e+01), SC_(-5.8151473999023437500000000000000000000000e+00), SC_(4.9701035022735595703125000000000000000000e-01), SC_(7.1739230123643034973869617997367655485216e+62) }, 
      { SC_(2.0434097290039062500000000000000000000000e+01), SC_(4.2376159667968750000000000000000000000000e+01), SC_(-2.2645759582519531250000000000000000000000e+01), SC_(9.6890521049499511718750000000000000000000e-01), SC_(-3.8879272017687731531682700432857675657427e+166) }, 
      { SC_(2.0568618774414062500000000000000000000000e+01), SC_(5.9472824096679687500000000000000000000000e+01), SC_(4.2243164062500000000000000000000000000000e+01), SC_(-6.6488838195800781250000000000000000000000e-01), SC_(8.1706390941889372303536547801733746401468e-07) }, 
      { SC_(2.0693603515625000000000000000000000000000e+01), SC_(4.2101318359375000000000000000000000000000e+01), SC_(5.2204971313476562500000000000000000000000e+00), SC_(3.0855584144592285156250000000000000000000e-01), SC_(3.9077036737207614193189293934905694169157e+14) }, 
      { SC_(2.1460784912109375000000000000000000000000e+01), SC_(-7.5145477294921875000000000000000000000000e+01), SC_(-9.9724578857421875000000000000000000000000e+00), SC_(9.4782996177673339843750000000000000000000e-01), SC_(7.7641251630567133978743180871818268816381e-08) }, 
      { SC_(2.1573188781738281250000000000000000000000e+01), SC_(-9.9701751708984375000000000000000000000000e+01), SC_(4.8250808715820312500000000000000000000000e+01), SC_(-2.1002554893493652343750000000000000000000e-01), SC_(1.8977385342773487430547735336999818052189e+04) }, 
      { SC_(2.2513290405273437500000000000000000000000e+01), SC_(5.6624740600585937500000000000000000000000e+01), SC_(9.7990020751953125000000000000000000000000e+01), SC_(-1.1325615644454956054687500000000000000000e-01), SC_(2.4175957816991953172654988636463941397676e-01) }, 
      { SC_(2.3208938598632812500000000000000000000000e+01), SC_(5.5779541015625000000000000000000000000000e+01), SC_(-5.3422317504882812500000000000000000000000e+00), SC_(9.7491908073425292968750000000000000000000e-01), SC_(1.4074509096392873359121057441742263684675e+164) }, 
      { SC_(2.3418174743652343750000000000000000000000e+01), SC_(-5.4461746215820312500000000000000000000000e+00), SC_(-4.6943832397460937500000000000000000000000e+01), SC_(9.9294996261596679687500000000000000000000e-01), SC_(-5.3404372285739219022836751751035318329082e+150) }, 
      { SC_(2.3533271789550781250000000000000000000000e+01), SC_(-5.4949493408203125000000000000000000000000e+00), SC_(7.1888458251953125000000000000000000000000e+01), SC_(2.2183239459991455078125000000000000000000e-01), SC_(6.6223236641031533491060903945188153766307e-01) }, 
      { SC_(2.4495018005371093750000000000000000000000e+01), SC_(5.5937881469726562500000000000000000000000e+01), SC_(1.7408943176269531250000000000000000000000e+01), SC_(-4.6723842620849609375000000000000000000000e-02), SC_(2.5338584554651339276283802314413346179026e-02) }, 
      { SC_(2.5579277038574218750000000000000000000000e+01), SC_(-1.7521514892578125000000000000000000000000e+00), SC_(5.4396087646484375000000000000000000000000e+01), SC_(-1.8069040775299072265625000000000000000000e-01), SC_(1.1536964550291538507222185298673398547686e+00) }, 
      { SC_(2.6214004516601562500000000000000000000000e+01), SC_(6.8206787109375000000000000000000000000000e-01), SC_(-8.2021667480468750000000000000000000000000e+01), SC_(-7.3332715034484863281250000000000000000000e-01), SC_(1.2032505019562117872138984656331326179962e+00) }, 
      { SC_(2.6237747192382812500000000000000000000000e+01), SC_(7.0556488037109375000000000000000000000000e+01), SC_(-2.8985267639160156250000000000000000000000e+01), SC_(6.5568399429321289062500000000000000000000e-01), SC_(-1.9729434998333409026312299814840975287275e+105) }, 
      { SC_(2.6471855163574218750000000000000000000000e+01), SC_(-3.8366592407226562500000000000000000000000e+01), SC_(-8.0491943359375000000000000000000000000000e+01), SC_(9.4441175460815429687500000000000000000000e-02), SC_(3.3473295406752582995600096318915267032696e+00) }, 
      { SC_(2.7157341003417968750000000000000000000000e+01), SC_(5.5558807373046875000000000000000000000000e+01), SC_(8.9034820556640625000000000000000000000000e+01), SC_(-9.4808244705200195312500000000000000000000e-01), SC_(4.7978466805610092016712062552215229067307e-06) }, 
      { SC_(2.7541816711425781250000000000000000000000e+01), SC_(-4.6364730834960937500000000000000000000000e+01), SC_(9.1538787841796875000000000000000000000000e+01), SC_(4.4981193542480468750000000000000000000000e-01), SC_(2.1291697144211667012984081899685574136488e-03) }, 
      { SC_(2.7706146240234375000000000000000000000000e+01), SC_(2.6672660827636718750000000000000000000000e+01), SC_(-9.3279235839843750000000000000000000000000e+01), SC_(5.7841300964355468750000000000000000000000e-02), SC_(6.3797303075191219598847364064939022177844e-01) }, 
      { SC_(2.8412170410156250000000000000000000000000e+01), SC_(2.6037895202636718750000000000000000000000e+01), SC_(-1.6190345764160156250000000000000000000000e+01), SC_(7.8521728515625000000000000000000000000000e-01), SC_(-1.3466341055879904859424636687357733609713e+77) }, 
      { SC_(2.8863616943359375000000000000000000000000e+01), SC_(8.7610931396484375000000000000000000000000e+00), SC_(-2.4278121948242187500000000000000000000000e+01), SC_(-7.1971249580383300781250000000000000000000e-01), SC_(1.0736756372106048254193519067431834322431e+02) }, 
      { SC_(2.8952911376953125000000000000000000000000e+01), SC_(-5.3264923095703125000000000000000000000000e+01), SC_(-2.4745559692382812500000000000000000000000e+01), SC_(-6.5367412567138671875000000000000000000000e-01), SC_(-9.3110767675422961347905427381919768652230e+36) }, 
      { SC_(2.9523529052734375000000000000000000000000e+01), SC_(8.6904388427734375000000000000000000000000e+01), SC_(3.5803359985351562500000000000000000000000e+01), SC_(-9.8335146903991699218750000000000000000000e-01), SC_(2.8348662609816490681664149565436487642150e-19) }, 
      { SC_(2.9549194335937500000000000000000000000000e+01), SC_(-1.3346328735351562500000000000000000000000e+00), SC_(-9.8152542114257812500000000000000000000000e+00), SC_(-2.4299913644790649414062500000000000000000e-01), SC_(1.7788935945259635356673710301299401465781e-01) }, 
      { SC_(2.9823104858398437500000000000000000000000e+01), SC_(-4.8340820312500000000000000000000000000000e+01), SC_(4.6344482421875000000000000000000000000000e+01), SC_(-7.4030709266662597656250000000000000000000e-01), SC_(5.0102445763642218554421909484926558241394e+08) }, 
      { SC_(3.0738037109375000000000000000000000000000e+01), SC_(1.9399192810058593750000000000000000000000e+01), SC_(9.1387176513671875000000000000000000000000e+01), SC_(1.4069545269012451171875000000000000000000e-01), SC_(2.5882252073546824874661224784251488512389e+00) }, 
      { SC_(3.0739974975585937500000000000000000000000e+01), SC_(7.9307952880859375000000000000000000000000e+01), SC_(8.6522705078125000000000000000000000000000e+01), SC_(4.8464512825012207031250000000000000000000e-01), SC_(9.1894552899279177534950648292887567260503e+07) }, 
      { SC_(3.1019607543945312500000000000000000000000e+01), SC_(4.2140777587890625000000000000000000000000e+01), SC_(-6.7477661132812500000000000000000000000000e+01), SC_(2.8792190551757812500000000000000000000000e-01), SC_(3.9811903494291886162690581642553509812259e+43) }, 
      { SC_(3.1095581054687500000000000000000000000000e+01), SC_(-6.5226989746093750000000000000000000000000e+01), SC_(-6.5762664794921875000000000000000000000000e+01), SC_(-3.9617383480072021484375000000000000000000e-01), SC_(-9.6365138158457216574144104522857859598475e-04) }, 
      { SC_(3.1148132324218750000000000000000000000000e+01), SC_(5.9585723876953125000000000000000000000000e+01), SC_(-9.2857666015625000000000000000000000000000e+01), SC_(-2.7741205692291259765625000000000000000000e-01), SC_(1.1011615695549273426505930378869088416083e+03) }, 
      { SC_(3.1371978759765625000000000000000000000000e+01), SC_(-6.3836257934570312500000000000000000000000e+01), SC_(2.5594673156738281250000000000000000000000e+01), SC_(3.0047416687011718750000000000000000000000e-02), SC_(8.9163346026569584756509935280748030474044e-02) }, 
      { SC_(3.1921051025390625000000000000000000000000e+01), SC_(-1.5556320190429687500000000000000000000000e+01), SC_(3.7189865112304687500000000000000000000000e+00), SC_(8.7211012840270996093750000000000000000000e-01), SC_(-1.0445357892654718044118845274587251694819e+02) }, 
      { SC_(3.2188919067382812500000000000000000000000e+01), SC_(8.0331329345703125000000000000000000000000e+01), SC_(4.5950378417968750000000000000000000000000e+01), SC_(-9.5107579231262207031250000000000000000000e-01), SC_(1.1053764995243537862391020446878433415262e-15) }, 
      { SC_(3.2401916503906250000000000000000000000000e+01), SC_(-5.8808883666992187500000000000000000000000e+01), SC_(-1.6768280029296875000000000000000000000000e+01), SC_(-1.3314062356948852539062500000000000000000e-01), SC_(-9.5569783861108851178231346420530963489985e+18) }, 
      { SC_(3.2561614990234375000000000000000000000000e+01), SC_(-6.4702972412109375000000000000000000000000e+01), SC_(-3.3834197998046875000000000000000000000000e+01), SC_(-8.1457924842834472656250000000000000000000e-01), SC_(8.8945504547282516000449466630312871517888e+47) }, 
      { SC_(3.3267776489257812500000000000000000000000e+01), SC_(4.7558166503906250000000000000000000000000e+01), SC_(7.8252944946289062500000000000000000000000e+00), SC_(-5.1455283164978027343750000000000000000000e-01), SC_(-9.1324131284793727400319465316618914057750e-15) }, 
      { SC_(3.3566543579101562500000000000000000000000e+01), SC_(-3.9234954833984375000000000000000000000000e+01), SC_(6.8878417968750000000000000000000000000000e+01), SC_(5.8020353317260742187500000000000000000000e-01), SC_(1.0579086170029444490536943306248360753530e-05) }, 
      { SC_(3.4240432739257812500000000000000000000000e+01), SC_(-3.0562187194824218750000000000000000000000e+01), SC_(4.3042510986328125000000000000000000000000e+01), SC_(5.4344367980957031250000000000000000000000e-01), SC_(1.6595093768088835740787419872896889440513e-07) }, 
      { SC_(3.4658981323242187500000000000000000000000e+01), SC_(2.9123718261718750000000000000000000000000e+01), SC_(-1.4087112426757812500000000000000000000000e+01), SC_(5.0066447257995605468750000000000000000000e-01), SC_(-1.0910577297770047865040358364195491842426e+51) }, 
      { SC_(3.5066406250000000000000000000000000000000e+01), SC_(2.0217742919921875000000000000000000000000e+00), SC_(-9.8656951904296875000000000000000000000000e+01), SC_(-5.3873610496520996093750000000000000000000e-01), SC_(1.5476211758944799383589991549888119160842e+00) }, 
      { SC_(3.5078247070312500000000000000000000000000e+01), SC_(-3.3336776733398437500000000000000000000000e+01), SC_(-6.3063659667968750000000000000000000000000e+00), SC_(-1.3727128505706787109375000000000000000000e-01), SC_(-2.3365541957742969783390305499873294396123e+14) }, 
      { SC_(3.5730453491210937500000000000000000000000e+01), SC_(-9.5510482788085937500000000000000000000000e+00), SC_(-9.6459197998046875000000000000000000000000e-01), SC_(-7.9946219921112060546875000000000000000000e-02), SC_(-6.6232805598199658725948292855211350228777e+05) }, 
      { SC_(3.5747024536132812500000000000000000000000e+01), SC_(-2.0252296447753906250000000000000000000000e+01), SC_(5.1548034667968750000000000000000000000000e+01), SC_(4.8129451274871826171875000000000000000000e-01), SC_(4.0724227297580107119107976832833155763788e-04) }, 
      { SC_(3.5827117919921875000000000000000000000000e+01), SC_(-4.0189636230468750000000000000000000000000e+01), SC_(-2.0896957397460937500000000000000000000000e+01), SC_(2.7293717861175537109375000000000000000000e-01), SC_(2.1780414455937654078589426331465059953989e+09) }, 
      { SC_(3.5946777343750000000000000000000000000000e+01), SC_(-7.5215682983398437500000000000000000000000e+00), SC_(-9.2687408447265625000000000000000000000000e+01), SC_(-5.7742738723754882812500000000000000000000e-01), SC_(1.6000041255982568328343977859527184055638e-01) }, 
      { SC_(3.6312088012695312500000000000000000000000e+01), SC_(-5.5144500732421875000000000000000000000000e+00), SC_(-7.3478851318359375000000000000000000000000e+00), SC_(-3.3837115764617919921875000000000000000000e-01), SC_(4.7914567201634687178659221466285962185151e+01) }, 
      { SC_(3.6672653198242187500000000000000000000000e+01), SC_(8.2743896484375000000000000000000000000000e+01), SC_(9.3186264038085937500000000000000000000000e+00), SC_(9.6151351928710937500000000000000000000000e-01), SC_(2.8824819527827028974062989442131539437704e+173) }, 
      { SC_(3.6683181762695312500000000000000000000000e+01), SC_(8.8718444824218750000000000000000000000000e+01), SC_(4.0809494018554687500000000000000000000000e+01), SC_(7.4069499969482421875000000000000000000000e-03), SC_(1.8096646244194250691641409230605424983706e+00) }, 
      { SC_(3.6743118286132812500000000000000000000000e+01), SC_(4.5373870849609375000000000000000000000000e+01), SC_(-7.3583404541015625000000000000000000000000e+01), SC_(-5.5320191383361816406250000000000000000000e-01), SC_(-6.2107557527916257785714111067477673980683e+07) }, 
      { SC_(3.7005691528320312500000000000000000000000e+01), SC_(-5.6809738159179687500000000000000000000000e+01), SC_(1.9588325500488281250000000000000000000000e+01), SC_(5.5566000938415527343750000000000000000000e-01), SC_(-8.3688166381546927851045679739075409787661e-20) }, 
      { SC_(3.7107147216796875000000000000000000000000e+01), SC_(-4.1807174682617187500000000000000000000000e+01), SC_(-4.1170288085937500000000000000000000000000e+01), SC_(-3.6275029182434082031250000000000000000000e-01), SC_(2.7468035772214098550826719045840873832117e+05) }, 
      { SC_(3.7355087280273437500000000000000000000000e+01), SC_(-3.7498413085937500000000000000000000000000e+01), SC_(-6.3297775268554687500000000000000000000000e+01), SC_(-2.2857898473739624023437500000000000000000e-01), SC_(7.7980598499455065083904860144059782762429e-03) }, 
      { SC_(3.7559204101562500000000000000000000000000e+01), SC_(7.4423065185546875000000000000000000000000e+01), SC_(-2.8154357910156250000000000000000000000000e+01), SC_(-5.3271269798278808593750000000000000000000e-01), SC_(1.0266325559816808898398004064974632431198e+06) }, 
      { SC_(3.7842910766601562500000000000000000000000e+01), SC_(4.3220138549804687500000000000000000000000e+01), SC_(4.9630325317382812500000000000000000000000e+01), SC_(9.7675871849060058593750000000000000000000e-01), SC_(1.4307751843533140662750322801120423256639e+52) }, 
      { SC_(3.8506393432617187500000000000000000000000e+01), SC_(5.6025100708007812500000000000000000000000e+01), SC_(1.1333969116210937500000000000000000000000e+01), SC_(-9.9905133247375488281250000000000000000000e-03), SC_(1.3688202040216178578595313820894530754552e-01) }, 
      { SC_(3.8950439453125000000000000000000000000000e+01), SC_(-8.3073272705078125000000000000000000000000e+01), SC_(5.1619857788085937500000000000000000000000e+01), SC_(-3.4440588951110839843750000000000000000000e-01), SC_(4.6495314627758934915516982584874123955566e+08) }, 
      { SC_(3.8965728759765625000000000000000000000000e+01), SC_(-7.4963470458984375000000000000000000000000e+01), SC_(-3.6580108642578125000000000000000000000000e+01), SC_(5.2749991416931152343750000000000000000000e-01), SC_(-4.1974146172943959350093179662943882003665e+17) }, 
      { SC_(3.9028091430664062500000000000000000000000e+01), SC_(-1.8761596679687500000000000000000000000000e+00), SC_(-8.6401458740234375000000000000000000000000e+01), SC_(8.0894970893859863281250000000000000000000e-01), SC_(-8.3777848026654268667439968582683696307009e+108) }, 
      { SC_(3.9032608032226562500000000000000000000000e+01), SC_(4.8758529663085937500000000000000000000000e+01), SC_(-1.7679595947265625000000000000000000000000e-01), SC_(-3.2389891147613525390625000000000000000000e-01), SC_(9.3371860863828930224797020973424541051045e-05) }, 
      { SC_(3.9189865112304687500000000000000000000000e+01), SC_(2.6900398254394531250000000000000000000000e+01), SC_(3.9977569580078125000000000000000000000000e+01), SC_(-8.5563945770263671875000000000000000000000e-01), SC_(8.0393095989621820857602356136147973510643e-08) }, 
      { SC_(3.9253265380859375000000000000000000000000e+01), SC_(6.9232330322265625000000000000000000000000e+01), SC_(-8.1235992431640625000000000000000000000000e+01), SC_(6.6924309730529785156250000000000000000000e-01), SC_(1.6999119120114548442839436244158314016346e+161) }, 
      { SC_(3.9621109008789062500000000000000000000000e+01), SC_(6.4571838378906250000000000000000000000000e+01), SC_(3.3305587768554687500000000000000000000000e+01), SC_(-6.2904810905456542968750000000000000000000e-01), SC_(-3.1127530724380149713053195209965361916383e-18) }, 
      { SC_(3.9749176025390625000000000000000000000000e+01), SC_(-8.6911010742187500000000000000000000000000e+01), SC_(-6.0438034057617187500000000000000000000000e+01), SC_(2.7718424797058105468750000000000000000000e-02), SC_(5.0742314442245560898804011293327975061700e+00) }, 
      { SC_(4.0540451049804687500000000000000000000000e+01), SC_(-8.0149719238281250000000000000000000000000e+01), SC_(-6.9281921386718750000000000000000000000000e+01), SC_(-2.1495956182479858398437500000000000000000e-01), SC_(8.7484620232729983026604470239806851826691e-02) }, 
      { SC_(4.1209228515625000000000000000000000000000e+01), SC_(5.9455978393554687500000000000000000000000e+01), SC_(-9.3633453369140625000000000000000000000000e+01), SC_(-3.6689913272857666015625000000000000000000e-01), SC_(-3.4883632610096800791717142719311527569221e+06) }, 
      { SC_(4.1383483886718750000000000000000000000000e+01), SC_(8.1024902343750000000000000000000000000000e+01), SC_(9.9898315429687500000000000000000000000000e+01), SC_(-1.9089388847351074218750000000000000000000e-01), SC_(2.6860028306129379595476388420648117393065e-03) }, 
      { SC_(4.1872970581054687500000000000000000000000e+01), SC_(8.4174957275390625000000000000000000000000e+01), SC_(5.0937332153320312500000000000000000000000e+01), SC_(6.1506199836730957031250000000000000000000e-01), SC_(5.3074986539677284026755331652986491552374e+29) }, 
      { SC_(4.3007415771484375000000000000000000000000e+01), SC_(-8.0260192871093750000000000000000000000000e+01), SC_(8.0744110107421875000000000000000000000000e+01), SC_(-2.3048961162567138671875000000000000000000e-01), SC_(1.6202917288168983163150887977742328560225e+04) }, 
      { SC_(4.3671783447265625000000000000000000000000e+01), SC_(-5.0885055541992187500000000000000000000000e+01), SC_(9.3729858398437500000000000000000000000000e+01), SC_(-3.3532178401947021484375000000000000000000e-01), SC_(2.1335649667641728379099722239892392736651e+03) }, 
      { SC_(4.4487915039062500000000000000000000000000e+01), SC_(4.0944747924804687500000000000000000000000e+01), SC_(-7.0026916503906250000000000000000000000000e+01), SC_(-6.0978531837463378906250000000000000000000e-01), SC_(3.1969209533606853262495729122334455678648e+09) }, 
      { SC_(4.4544906616210937500000000000000000000000e+01), SC_(3.6515396118164062500000000000000000000000e+01), SC_(-7.7929321289062500000000000000000000000000e+01), SC_(-1.0258394479751586914062500000000000000000e-01), SC_(1.0080739270826423217718347531166243215488e+01) }, 
      { SC_(4.4584503173828125000000000000000000000000e+01), SC_(5.6837493896484375000000000000000000000000e+01), SC_(6.2418594360351562500000000000000000000000e+00), SC_(-4.5760154724121093750000000000000000000000e-02), SC_(1.1225797847991231984467049360617598373426e-05) }, 
      { SC_(4.5941894531250000000000000000000000000000e+01), SC_(-5.1868957519531250000000000000000000000000e+01), SC_(4.1450683593750000000000000000000000000000e+01), SC_(8.3823442459106445312500000000000000000000e-01), SC_(-3.5344744958282019707812429076976145296003e-31) }, 
      { SC_(4.6049758911132812500000000000000000000000e+01), SC_(5.4580184936523437500000000000000000000000e+01), SC_(-3.1224594116210937500000000000000000000000e+01), SC_(-5.9248065948486328125000000000000000000000e-01), SC_(-6.4962383021789570412638678048183382659666e+06) }, 
      { SC_(4.6868209838867187500000000000000000000000e+01), SC_(6.6146179199218750000000000000000000000000e+01), SC_(-8.9733642578125000000000000000000000000000e+01), SC_(-7.4408578872680664062500000000000000000000e-01), SC_(-7.7747682420266671520835069524008731135275e+11) }, 
      { SC_(4.6991500854492187500000000000000000000000e+01), SC_(-1.5418121337890625000000000000000000000000e+01), SC_(9.4119689941406250000000000000000000000000e+01), SC_(6.7455267906188964843750000000000000000000e-01), SC_(2.3796334198899784969591437240527477610503e-03) }, 
      { SC_(4.7268005371093750000000000000000000000000e+01), SC_(6.1611694335937500000000000000000000000000e+01), SC_(-2.1058502197265625000000000000000000000000e+01), SC_(1.1306357383728027343750000000000000000000e-01), SC_(1.8042990071777437924998018276934482734023e+30) }, 
      { SC_(4.7568328857421875000000000000000000000000e+01), SC_(-2.0704971313476562500000000000000000000000e+01), SC_(-8.7319122314453125000000000000000000000000e+01), SC_(-9.4407105445861816406250000000000000000000e-01), SC_(1.4227858445755884803155054716069117541802e-05) }, 
      { SC_(4.7728057861328125000000000000000000000000e+01), SC_(6.0175888061523437500000000000000000000000e+01), SC_(1.7197402954101562500000000000000000000000e+01), SC_(1.7216837406158447265625000000000000000000e-01), SC_(1.8398300583538202680319859100122682859503e+11) }, 
      { SC_(4.8006469726562500000000000000000000000000e+01), SC_(4.1814071655273437500000000000000000000000e+01), SC_(-5.3034622192382812500000000000000000000000e+01), SC_(9.4142675399780273437500000000000000000000e-01), SC_(3.2871931196058057420013293666238264093166e+242) }, 
      { SC_(4.8251586914062500000000000000000000000000e+01), SC_(-9.3524810791015625000000000000000000000000e+01), SC_(4.0104980468750000000000000000000000000000e+00), SC_(2.2786366939544677734375000000000000000000e-01), SC_(-2.8152901539210604659903068467881109156271e-08) }, 
      { SC_(4.8626495361328125000000000000000000000000e+01), SC_(-5.0482635498046875000000000000000000000000e+00), SC_(-2.1554595947265625000000000000000000000000e+01), SC_(-1.5582466125488281250000000000000000000000e-01), SC_(1.3380423359684780549951856925064695158309e-01) }, 
      { SC_(4.8737670898437500000000000000000000000000e+01), SC_(6.9034118652343750000000000000000000000000e+00), SC_(-7.8815917968750000000000000000000000000000e+01), SC_(3.6536991596221923828125000000000000000000e-01), SC_(-7.1546201318410414239712575529327160194137e+38) }, 
      { SC_(4.8938568115234375000000000000000000000000e+01), SC_(2.4687110900878906250000000000000000000000e+01), SC_(-6.2208999633789062500000000000000000000000e+01), SC_(6.2374782562255859375000000000000000000000e-01), SC_(-5.7264979720290370654692080318841189735723e+103) }, 
      { SC_(4.9109222412109375000000000000000000000000e+01), SC_(-7.3687011718750000000000000000000000000000e+01), SC_(4.7253494262695312500000000000000000000000e+01), SC_(-8.1895661354064941406250000000000000000000e-01), SC_(3.7339683473399694206292879415140591940488e+19) }, 
      { SC_(4.9262695312500000000000000000000000000000e+01), SC_(2.8456024169921875000000000000000000000000e+01), SC_(-9.7932678222656250000000000000000000000000e+01), SC_(-1.4149242639541625976562500000000000000000e-01), SC_(8.8711784115437610994426049356241381889678e+00) }, 
      { SC_(4.9741149902343750000000000000000000000000e+01), SC_(-1.2096336364746093750000000000000000000000e+01), SC_(6.5116760253906250000000000000000000000000e+01), SC_(-9.4322347640991210937500000000000000000000e-01), SC_(7.4748055927675707454433159298785745115382e+02) }, 
      { SC_(4.9826293945312500000000000000000000000000e+01), SC_(9.0214019775390625000000000000000000000000e+01), SC_(1.6637145996093750000000000000000000000000e+01), SC_(7.5578308105468750000000000000000000000000e-01), SC_(6.5552011843057324120999148798114959538019e+90) }, 
      { SC_(5.0253417968750000000000000000000000000000e+01), SC_(6.4249176025390625000000000000000000000000e+01), SC_(-4.8980987548828125000000000000000000000000e+01), SC_(6.4168143272399902343750000000000000000000e-01), SC_(-1.1440736655800625327640554509960152039166e+138) }, 
      { SC_(5.0389282226562500000000000000000000000000e+01), SC_(1.2536453247070312500000000000000000000000e+01), SC_(-5.4266113281250000000000000000000000000000e+01), SC_(-2.9772591590881347656250000000000000000000e-01), SC_(1.3822492178853287617030221658714239000942e+02) }, 
      { SC_(5.1440048217773437500000000000000000000000e+01), SC_(-2.1535911560058593750000000000000000000000e+01), SC_(5.0745819091796875000000000000000000000000e+01), SC_(1.2311494350433349609375000000000000000000e-01), SC_(5.6585899433950496786477861383800067544646e-02) }, 
      { SC_(5.1865478515625000000000000000000000000000e+01), SC_(-6.5591766357421875000000000000000000000000e+01), SC_(4.8129623413085937500000000000000000000000e+01), SC_(5.8051943778991699218750000000000000000000e-02), SC_(1.4235880849251407052855198509378822782932e-02) }, 
      { SC_(5.3103363037109375000000000000000000000000e+01), SC_(-8.9756713867187500000000000000000000000000e+01), SC_(5.9039993286132812500000000000000000000000e+01), SC_(-9.2711758613586425781250000000000000000000e-01), SC_(1.2887002406631727517670981485828731498872e+24) }, 
      { SC_(5.3770858764648437500000000000000000000000e+01), SC_(8.4848266601562500000000000000000000000000e+01), SC_(-6.6549316406250000000000000000000000000000e+01), SC_(7.5249242782592773437500000000000000000000e-01), SC_(-2.3779976963735412517345055576516280437475e+209) }, 
      { SC_(5.3791656494140625000000000000000000000000e+01), SC_(-7.4238922119140625000000000000000000000000e+01), SC_(-2.0798652648925781250000000000000000000000e+01), SC_(2.3163616657257080078125000000000000000000e-01), SC_(-4.6106121104589500093740044423158384398160e+12) }, 
      { SC_(5.3805816650390625000000000000000000000000e+01), SC_(1.9940422058105468750000000000000000000000e+01), SC_(1.6289291381835937500000000000000000000000e+01), SC_(1.1243093013763427734375000000000000000000e-01), SC_(2.1581042679340963807760853173117233554229e+03) }, 
      { SC_(5.3822875976562500000000000000000000000000e+01), SC_(2.9473785400390625000000000000000000000000e+01), SC_(-2.0641693115234375000000000000000000000000e+01), SC_(8.0648183822631835937500000000000000000000e-01), SC_(-3.0472671888316855128532589332579950650021e+116) }, 
      { SC_(5.4057098388671875000000000000000000000000e+01), SC_(4.1651519775390625000000000000000000000000e+01), SC_(-2.9956398010253906250000000000000000000000e+01), SC_(-8.6252284049987792968750000000000000000000e-01), SC_(1.2731459526130989574934317916604505718394e+05) }, 
      { SC_(5.4386779785156250000000000000000000000000e+01), SC_(3.8365097045898437500000000000000000000000e+00), SC_(-5.8865097045898437500000000000000000000000e+01), SC_(9.5697450637817382812500000000000000000000e-01), SC_(-3.2340924565730157812704567316926355206008e+199) }, 
      { SC_(5.4544418334960937500000000000000000000000e+01), SC_(5.5948348999023437500000000000000000000000e+01), SC_(3.9286605834960937500000000000000000000000e+01), SC_(-2.2705912590026855468750000000000000000000e-02), SC_(1.7425690298559141951127404495229782527267e-01) }, 
      { SC_(5.5760437011718750000000000000000000000000e+01), SC_(-8.2127456665039062500000000000000000000000e+00), SC_(-1.5309417724609375000000000000000000000000e+01), SC_(3.9629375934600830078125000000000000000000e-01), SC_(-9.2294393865761686454969658811972824743548e+14) }, 
      { SC_(5.6035095214843750000000000000000000000000e+01), SC_(-4.4412445068359375000000000000000000000000e+01), SC_(-3.2483230590820312500000000000000000000000e+01), SC_(-5.1494741439819335937500000000000000000000e-01), SC_(-4.1351446880603016586784200779038873860303e+30) }, 
      { SC_(5.6045486450195312500000000000000000000000e+01), SC_(3.3857025146484375000000000000000000000000e+01), SC_(-8.3774871826171875000000000000000000000000e+01), SC_(-2.4116230010986328125000000000000000000000e-01), SC_(9.6484332064412606087119877916816069887930e+02) }, 
      { SC_(5.6050415039062500000000000000000000000000e+01), SC_(7.5472778320312500000000000000000000000000e+01), SC_(-2.2052230834960937500000000000000000000000e+01), SC_(-5.7939624786376953125000000000000000000000e-01), SC_(-1.1856077853586782344481562495042983774954e+03) }, 
      { SC_(5.6275421142578125000000000000000000000000e+01), SC_(2.0767463684082031250000000000000000000000e+01), SC_(-4.2404602050781250000000000000000000000000e+01), SC_(-2.3350906372070312500000000000000000000000e-01), SC_(-1.9736838276142044349387508436349706654927e+04) }, 
      { SC_(5.6386398315429687500000000000000000000000e+01), SC_(-9.8797302246093750000000000000000000000000e+01), SC_(-7.9878753662109375000000000000000000000000e+01), SC_(-9.8016047477722167968750000000000000000000e-01), SC_(5.3725162308345904871796473548144512123658e+67) }, 
      { SC_(5.7111801147460937500000000000000000000000e+01), SC_(4.9825759887695312500000000000000000000000e+01), SC_(2.6754837036132812500000000000000000000000e+00), SC_(4.5865857601165771484375000000000000000000e-01), SC_(2.4477390274289183706114088241746425832649e+47) }, 
      { SC_(5.7814712524414062500000000000000000000000e+01), SC_(-1.9983795166015625000000000000000000000000e+01), SC_(7.0452758789062500000000000000000000000000e+01), SC_(-9.6321582794189453125000000000000000000000e-01), SC_(1.2618957429394653860150056552470903537620e+05) }, 
      { SC_(5.7872787475585937500000000000000000000000e+01), SC_(-8.3852691650390625000000000000000000000000e+01), SC_(-2.6469413757324218750000000000000000000000e+01), SC_(-1.8939769268035888671875000000000000000000e-01), SC_(-6.9006045336457422653526382334838315237819e+35) }, 
      { SC_(5.7992599487304687500000000000000000000000e+01), SC_(-8.3369842529296875000000000000000000000000e+01), SC_(-3.6295150756835937500000000000000000000000e+01), SC_(6.0734391212463378906250000000000000000000e-02), SC_(2.3207795957116428086475829086935973036214e+04) }, 
      { SC_(5.8081451416015625000000000000000000000000e+01), SC_(9.8063964843750000000000000000000000000000e+01), SC_(8.9860778808593750000000000000000000000000e+01), SC_(-5.4001593589782714843750000000000000000000e-01), SC_(1.5821989138817119159015462478807714699235e-12) }, 
      { SC_(5.8441467285156250000000000000000000000000e+01), SC_(7.5686126708984375000000000000000000000000e+01), SC_(9.1898468017578125000000000000000000000000e+01), SC_(7.3254108428955078125000000000000000000000e-03), SC_(1.4244672950706379209725569408802417414172e+00) }, 
      { SC_(5.8931579589843750000000000000000000000000e+01), SC_(8.2832580566406250000000000000000000000000e+01), SC_(1.5478836059570312500000000000000000000000e+01), SC_(-5.1529717445373535156250000000000000000000e-01), SC_(-5.2458011924622319778554908037741652305347e-26) }, 
      { SC_(5.9566055297851562500000000000000000000000e+01), SC_(7.1049865722656250000000000000000000000000e+01), SC_(-2.4792404174804687500000000000000000000000e+00), SC_(8.0592679977416992187500000000000000000000e-01), SC_(-2.0346138551806878019548640977378891377551e+136) }, 
      { SC_(5.9670181274414062500000000000000000000000e+01), SC_(-7.4357727050781250000000000000000000000000e+01), SC_(8.8601623535156250000000000000000000000000e+01), SC_(9.5737314224243164062500000000000000000000e-01), SC_(3.0617180724033823870761996438450759955250e-22) }, 
      { SC_(6.0056091308593750000000000000000000000000e+01), SC_(-4.0594116210937500000000000000000000000000e+01), SC_(-7.1622741699218750000000000000000000000000e+01), SC_(-9.9043321609497070312500000000000000000000e-01), SC_(4.3960094988093157922693191419566533066328e+01) }, 
      { SC_(6.0066116333007812500000000000000000000000e+01), SC_(-5.4535751342773437500000000000000000000000e+00), SC_(-9.2404632568359375000000000000000000000000e+00), SC_(-1.2613415718078613281250000000000000000000e-01), SC_(1.1665135087284653673577510925530737500614e-01) }, 
      { SC_(6.0202926635742187500000000000000000000000e+01), SC_(5.2586288452148437500000000000000000000000e+01), SC_(-9.4155944824218750000000000000000000000000e+01), SC_(-4.6815872192382812500000000000000000000000e-01), SC_(-3.2787346602726700259624193770786421409695e+10) }, 
      { SC_(6.0269515991210937500000000000000000000000e+01), SC_(9.0279327392578125000000000000000000000000e+01), SC_(-5.4431411743164062500000000000000000000000e+01), SC_(-6.5737009048461914062500000000000000000000e-01), SC_(-1.1980171769514145565405835366368875470310e+10) }, 
      { SC_(6.1097885131835937500000000000000000000000e+01), SC_(-2.3196258544921875000000000000000000000000e+00), SC_(1.5344299316406250000000000000000000000000e+01), SC_(2.9039144515991210937500000000000000000000e-02), SC_(7.5108788647529512249293510964445696481889e-01) }, 
      { SC_(6.1702819824218750000000000000000000000000e+01), SC_(-9.8805297851562500000000000000000000000000e+01), SC_(5.1015426635742187500000000000000000000000e+01), SC_(3.8712358474731445312500000000000000000000e-01), SC_(9.2452578623984546160453482751599232700662e-27) }, 
      { SC_(6.1840774536132812500000000000000000000000e+01), SC_(-1.8099441528320312500000000000000000000000e+01), SC_(4.9723785400390625000000000000000000000000e+01), SC_(-7.8455114364624023437500000000000000000000e-01), SC_(1.9736399420027332576172289003711661929620e+05) }, 
      { SC_(6.2316101074218750000000000000000000000000e+01), SC_(-6.0025436401367187500000000000000000000000e+01), SC_(6.5651168823242187500000000000000000000000e+00), SC_(8.9785003662109375000000000000000000000000e-01), SC_(-1.3523606241129721478683796695682518567356e-11) }, 
      { SC_(6.2856964111328125000000000000000000000000e+01), SC_(-4.0033660888671875000000000000000000000000e+01), SC_(-5.1295013427734375000000000000000000000000e+01), SC_(-9.7292184829711914062500000000000000000000e-01), SC_(2.1823341844623966732454715856310385415305e+15) }, 
      { SC_(6.2944732666015625000000000000000000000000e+01), SC_(-7.2904602050781250000000000000000000000000e+01), SC_(8.1158386230468750000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.8139223929372928340607153090973945176504e-19) }, 
      { SC_(6.3460647583007812500000000000000000000000e+01), SC_(-2.7362709045410156250000000000000000000000e+01), SC_(7.3738922119140625000000000000000000000000e+01), SC_(3.5903942584991455078125000000000000000000e-01), SC_(4.7949685379703846070652763981866113176819e-05) }, 
      { SC_(6.3525543212890625000000000000000000000000e+01), SC_(-2.7827857971191406250000000000000000000000e+01), SC_(5.8966278076171875000000000000000000000000e+01), SC_(8.3423566818237304687500000000000000000000e-01), SC_(7.0091697707526152979788053415099924817080e-23) }, 
      { SC_(6.3552124023437500000000000000000000000000e+01), SC_(-3.4652679443359375000000000000000000000000e+01), SC_(-4.7854400634765625000000000000000000000000e+01), SC_(3.1842124462127685546875000000000000000000e-01), SC_(3.3314801230371592157120126648180949893958e+06) }, 
      { SC_(6.3629714965820312500000000000000000000000e+01), SC_(-8.6895111083984375000000000000000000000000e+01), SC_(6.3509414672851562500000000000000000000000e+01), SC_(-5.3622293472290039062500000000000000000000e-01), SC_(1.6688783943742210473674576198860976959399e+16) }, 
      { SC_(6.3640808105468750000000000000000000000000e+01), SC_(-7.1477783203125000000000000000000000000000e+01), SC_(-7.9955688476562500000000000000000000000000e+01), SC_(-1.5660089254379272460937500000000000000000e-01), SC_(2.2886063312601734557039080869543781170398e-04) }, 
      { SC_(6.4238800048828125000000000000000000000000e+01), SC_(-3.5497848510742187500000000000000000000000e+01), SC_(-9.6919311523437500000000000000000000000000e+01), SC_(-1.9003725051879882812500000000000000000000e-01), SC_(1.1276504168156549455073052435994695877549e-02) }, 
      { SC_(6.4344238281250000000000000000000000000000e+01), SC_(-1.0050430297851562500000000000000000000000e+00), SC_(-1.4015716552734375000000000000000000000000e+01), SC_(5.7195973396301269531250000000000000000000e-01), SC_(-6.5898326155478007250314306126954987765937e+37) }, 
      { SC_(6.4714874267578125000000000000000000000000e+01), SC_(4.5877944946289062500000000000000000000000e+01), SC_(-6.4998046875000000000000000000000000000000e+01), SC_(-3.4140121936798095703125000000000000000000e-01), SC_(9.8165716891363180292238518664713196570257e+09) }, 
      { SC_(6.4875244140625000000000000000000000000000e+01), SC_(6.4195022583007812500000000000000000000000e+00), SC_(9.6532684326171875000000000000000000000000e+01), SC_(7.9887199401855468750000000000000000000000e-01), SC_(1.6476206167229647256723629841820480665549e+02) }, 
      { SC_(6.6275939941406250000000000000000000000000e+01), SC_(-6.2183166503906250000000000000000000000000e+01), SC_(6.0672882080078125000000000000000000000000e+01), SC_(-2.0603638887405395507812500000000000000000e-01), SC_(2.8050015864759295828798709285514897477695e+05) }, 
      { SC_(6.8143432617187500000000000000000000000000e+01), SC_(9.7704315185546875000000000000000000000000e+01), SC_(-4.9143569946289062500000000000000000000000e+01), SC_(-3.3510351181030273437500000000000000000000e-01), SC_(3.1989626230207124939129984016393480558691e+12) }, 
      { SC_(6.8385833740234375000000000000000000000000e+01), SC_(-9.7761505126953125000000000000000000000000e+01), SC_(6.6583343505859375000000000000000000000000e+01), SC_(-8.6147499084472656250000000000000000000000e-01), SC_(6.1128952341304806852579093381592022162832e+26) }, 
      { SC_(6.8861755371093750000000000000000000000000e+01), SC_(7.7199615478515625000000000000000000000000e+01), SC_(-6.1047149658203125000000000000000000000000e+01), SC_(-1.1755305528640747070312500000000000000000e-01), SC_(2.2605930608538108438329880481551107933150e+07) }, 
      { SC_(6.8971130371093750000000000000000000000000e+01), SC_(-7.4093322753906250000000000000000000000000e+01), SC_(-5.8118988037109375000000000000000000000000e+01), SC_(2.1787798404693603515625000000000000000000e-01), SC_(2.5048240372231430563240050527989748029438e+11) }, 
      { SC_(6.9825866699218750000000000000000000000000e+01), SC_(-5.7615142822265625000000000000000000000000e+01), SC_(8.6798645019531250000000000000000000000000e+01), SC_(3.6271905899047851562500000000000000000000e-01), SC_(5.4213827080794517713135275651811759267277e-09) }, 
      { SC_(7.0142517089843750000000000000000000000000e+01), SC_(-3.5225082397460937500000000000000000000000e+01), SC_(1.2111900329589843750000000000000000000000e+01), SC_(-6.5934705734252929687500000000000000000000e-01), SC_(4.4544455323761459244038330024827373782753e+18) }, 
      { SC_(7.0599609375000000000000000000000000000000e+01), SC_(-2.0392913818359375000000000000000000000000e+01), SC_(7.4785461425781250000000000000000000000000e+01), SC_(7.0339131355285644531250000000000000000000e-01), SC_(4.7383222165576492459645438304959797443371e-10) }, 
      { SC_(7.0606201171875000000000000000000000000000e+01), SC_(6.7866210937500000000000000000000000000000e+00), SC_(2.4411026000976562500000000000000000000000e+01), SC_(-1.2266635894775390625000000000000000000000e-01), SC_(1.2102216307230377514809572466730544470080e-01) }, 
      { SC_(7.2088104248046875000000000000000000000000e+01), SC_(-9.9935455322265625000000000000000000000000e+00), SC_(8.6881011962890625000000000000000000000000e+01), SC_(-8.0291247367858886718750000000000000000000e-01), SC_(1.6709982733480437044989052194989818569930e+02) }, 
      { SC_(7.2227966308593750000000000000000000000000e+01), SC_(9.5112304687500000000000000000000000000000e+01), SC_(-3.0293350219726562500000000000000000000000e+00), SC_(6.8517851829528808593750000000000000000000e-01), SC_(1.8002214492672245435072774462851145063557e+136) }, 
      { SC_(7.2396087646484375000000000000000000000000e+01), SC_(-1.3651100158691406250000000000000000000000e+01), SC_(9.7974426269531250000000000000000000000000e+01), SC_(-5.8225154876708984375000000000000000000000e-02), SC_(1.7781397796296051667736196855965702893467e+00) }, 
      { SC_(7.2542144775390625000000000000000000000000e+01), SC_(1.7023361206054687500000000000000000000000e+01), SC_(-3.1407012939453125000000000000000000000000e+00), SC_(-1.7357015609741210937500000000000000000000e-01), SC_(-7.3299536531587684149350315264661422296421e+00) }, 
      { SC_(7.3386047363281250000000000000000000000000e+01), SC_(-8.1336151123046875000000000000000000000000e+01), SC_(-8.2753112792968750000000000000000000000000e+01), SC_(3.4685325622558593750000000000000000000000e-01), SC_(1.5365165830784267193335734488698818418812e+13) }, 
      { SC_(7.3858428955078125000000000000000000000000e+01), SC_(-8.4488616943359375000000000000000000000000e+01), SC_(1.5940917968750000000000000000000000000000e+01), SC_(2.5476872920989990234375000000000000000000e-01), SC_(-3.1523953677908894646580703683130152875449e-15) }, 
      { SC_(7.3988189697265625000000000000000000000000e+01), SC_(7.1413238525390625000000000000000000000000e+01), SC_(-4.7044204711914062500000000000000000000000e+01), SC_(-2.8877818584442138671875000000000000000000e-01), SC_(9.5192611584514590358376100253896413393881e+11) }, 
      { SC_(7.4222198486328125000000000000000000000000e+01), SC_(2.3802909851074218750000000000000000000000e+01), SC_(-2.9844650268554687500000000000000000000000e+01), SC_(4.6764028072357177734375000000000000000000e-01), SC_(4.9928449205014909680136336570784619308959e+74) }, 
      { SC_(7.5188568115234375000000000000000000000000e+01), SC_(-9.6695892333984375000000000000000000000000e+01), SC_(1.0031272888183593750000000000000000000000e+01), SC_(-2.2276967763900756835937500000000000000000e-01), SC_(2.4792747972677580028663331064359210652973e+24) }, 
      { SC_(7.5802764892578125000000000000000000000000e+01), SC_(-6.8911621093750000000000000000000000000000e+01), SC_(9.7782318115234375000000000000000000000000e+01), SC_(-3.9397859573364257812500000000000000000000e-01), SC_(1.3389401436678122513279960839828801902035e+08) }, 
      { SC_(7.6373291015625000000000000000000000000000e+01), SC_(-8.2009429931640625000000000000000000000000e+01), SC_(3.3835067749023437500000000000000000000000e+01), SC_(-9.8337125778198242187500000000000000000000e-01), SC_(6.6463838164484273495537645302587667144891e+35) }, 
      { SC_(7.7302368164062500000000000000000000000000e+01), SC_(4.7247314453125000000000000000000000000000e-01), SC_(-9.4265167236328125000000000000000000000000e+01), SC_(1.9211590290069580078125000000000000000000e-01), SC_(8.4963861201251387463595293637463085394057e-01) }, 
      { SC_(7.7554168701171875000000000000000000000000e+01), SC_(-7.0640487670898437500000000000000000000000e+00), SC_(-2.1763404846191406250000000000000000000000e+01), SC_(7.6606321334838867187500000000000000000000e-01), SC_(1.3716157987221177264587341791641944561135e+67) }, 
      { SC_(7.8095123291015625000000000000000000000000e+01), SC_(-1.2155914306640625000000000000000000000000e-01), SC_(5.9792053222656250000000000000000000000000e+01), SC_(-2.3097759485244750976562500000000000000000e-01), SC_(1.0325806239844956845403224257929953768719e+00) }, 
      { SC_(7.8150421142578125000000000000000000000000e+01), SC_(-4.7124710083007812500000000000000000000000e+01), SC_(9.6460632324218750000000000000000000000000e+01), SC_(5.6503057479858398437500000000000000000000e-01), SC_(2.3130301523159989623860310039340614638875e-12) }, 
      { SC_(7.8180633544921875000000000000000000000000e+01), SC_(-1.5366973876953125000000000000000000000000e+01), SC_(9.1858276367187500000000000000000000000000e+01), SC_(1.6191339492797851562500000000000000000000e-01), SC_(1.0298868923306734288660793504306571703273e-01) }, 
      { SC_(7.8184478759765625000000000000000000000000e+01), SC_(-2.8930259704589843750000000000000000000000e+01), SC_(-3.3167388916015625000000000000000000000000e+01), SC_(4.3994188308715820312500000000000000000000e-01), SC_(-3.2751436284353498593282915127305208560766e+19) }, 
      { SC_(7.8584472656250000000000000000000000000000e+01), SC_(3.5558090209960937500000000000000000000000e+00), SC_(4.0644653320312500000000000000000000000000e+01), SC_(-4.6441614627838134765625000000000000000000e-02), SC_(7.3609290564974132890545321293619315211720e-01) }, 
      { SC_(7.8877868652343750000000000000000000000000e+01), SC_(8.1477111816406250000000000000000000000000e+01), SC_(3.3116455078125000000000000000000000000000e+00), SC_(-7.9068374633789062500000000000000000000000e-01), SC_(-1.3239695663812858766412914886533646155571e-25) }, 
      { SC_(7.8988342285156250000000000000000000000000e+01), SC_(-2.5964096069335937500000000000000000000000e+01), SC_(-8.5709442138671875000000000000000000000000e+01), SC_(-6.1702704429626464843750000000000000000000e-01), SC_(1.4206315959463477516192040130153162158738e-07) }, 
      { SC_(7.9438262939453125000000000000000000000000e+01), SC_(4.1784698486328125000000000000000000000000e+01), SC_(-6.0668365478515625000000000000000000000000e+01), SC_(2.7590560913085937500000000000000000000000e-01), SC_(-2.8931952079694192122091390194679960154465e+67) }, 
      { SC_(7.9697235107421875000000000000000000000000e+01), SC_(-8.8077117919921875000000000000000000000000e+01), SC_(-7.6368957519531250000000000000000000000000e+01), SC_(-4.2618680000305175781250000000000000000000e-01), SC_(-4.5396536246987491659856021779022501911553e+35) }, 
      { SC_(8.0543212890625000000000000000000000000000e+01), SC_(-3.9634536743164062500000000000000000000000e+01), SC_(8.8957427978515625000000000000000000000000e+01), SC_(-9.0411162376403808593750000000000000000000e-01), SC_(2.3140701478162494320762947808793554834212e+10) }, 
      { SC_(8.0944427490234375000000000000000000000000e+01), SC_(-4.7104690551757812500000000000000000000000e+01), SC_(2.1973327636718750000000000000000000000000e+01), SC_(8.6850118637084960937500000000000000000000e-01), SC_(6.5992193138696262325834584991307270931299e-14) }, 
      { SC_(8.0976165771484375000000000000000000000000e+01), SC_(4.5330886840820312500000000000000000000000e+01), SC_(9.5949676513671875000000000000000000000000e+01), SC_(-2.9072380065917968750000000000000000000000e-01), SC_(5.2000105536568128166413493353356034162937e-05) }, 
      { SC_(8.1026947021484375000000000000000000000000e+01), SC_(8.0709747314453125000000000000000000000000e+01), SC_(6.7543869018554687500000000000000000000000e+00), SC_(2.7258467674255371093750000000000000000000e-01), SC_(4.6542450541689046725412119355612364608385e+41) }, 
      { SC_(8.1261627197265625000000000000000000000000e+01), SC_(6.9617767333984375000000000000000000000000e+01), SC_(7.5930755615234375000000000000000000000000e+01), SC_(-3.4660148620605468750000000000000000000000e-01), SC_(2.3990930027584519008789783547609503632771e-10) }, 
      { SC_(8.2426483154296875000000000000000000000000e+01), SC_(-3.4507858276367187500000000000000000000000e+01), SC_(-7.9197692871093750000000000000000000000000e+01), SC_(-4.9481940269470214843750000000000000000000e-01), SC_(1.7982060523169828775445249265950907115624e-08) }, 
      { SC_(8.2657348632812500000000000000000000000000e+01), SC_(-9.6386749267578125000000000000000000000000e+01), SC_(5.9236770629882812500000000000000000000000e+01), SC_(1.6569280624389648437500000000000000000000e-01), SC_(-1.4695631760259868323668318337993756578291e-14) }, 
      { SC_(8.2760070800781250000000000000000000000000e+01), SC_(9.6060058593750000000000000000000000000000e+01), SC_(4.1343048095703125000000000000000000000000e+01), SC_(7.2461485862731933593750000000000000000000e-01), SC_(3.3402036989043102425324617638466750221727e+86) }, 
      { SC_(8.3198242187500000000000000000000000000000e+01), SC_(3.1042648315429687500000000000000000000000e+01), SC_(-9.9769805908203125000000000000000000000000e+01), SC_(-4.5466601848602294921875000000000000000000e-01), SC_(2.2300793046717877979385859727023672753790e+08) }, 
      { SC_(8.3438720703125000000000000000000000000000e+01), SC_(3.9046569824218750000000000000000000000000e+01), SC_(-4.2832199096679687500000000000000000000000e+01), SC_(3.5963952541351318359375000000000000000000e-01), SC_(-7.8160791464543783690291697711408715358923e+79) }, 
      { SC_(8.5662597656250000000000000000000000000000e+01), SC_(-8.0693450927734375000000000000000000000000e+01), SC_(1.6018066406250000000000000000000000000000e+01), SC_(8.5357403755187988281250000000000000000000e-01), SC_(3.8006492977198565501890193425299287622447e-23) }, 
      { SC_(8.5770812988281250000000000000000000000000e+01), SC_(-5.1172348022460937500000000000000000000000e+01), SC_(4.6066177368164062500000000000000000000000e+01), SC_(-7.9852318763732910156250000000000000000000e-01), SC_(6.9457730878247821630441619422574973297158e+18) }, 
      { SC_(8.5852722167968750000000000000000000000000e+01), SC_(-5.6552429199218750000000000000000000000000e+01), SC_(-3.0003250122070312500000000000000000000000e+01), SC_(8.1472945213317871093750000000000000000000e-01), SC_(4.9879733795092638111730473159326510012528e+45) }, 
      { SC_(8.5877197265625000000000000000000000000000e+01), SC_(-8.3006210327148437500000000000000000000000e+00), SC_(5.5142532348632812500000000000000000000000e+01), SC_(-3.9277207851409912109375000000000000000000e-01), SC_(5.1150950087512553716163127525446478668651e+01) }, 
      { SC_(8.5921783447265625000000000000000000000000e+01), SC_(-9.5053192138671875000000000000000000000000e+01), SC_(3.9333435058593750000000000000000000000000e+01), SC_(6.6128587722778320312500000000000000000000e-01), SC_(-8.7986856342462016200416610636082337922597e-39) }, 
      { SC_(8.6240264892578125000000000000000000000000e+01), SC_(-6.9485321044921875000000000000000000000000e+01), SC_(4.5732330322265625000000000000000000000000e+01), SC_(-2.0896643400192260742187500000000000000000e-01), SC_(2.4751783719869337936623602883878363721292e+09) }, 
      { SC_(8.6570709228515625000000000000000000000000e+01), SC_(5.1902297973632812500000000000000000000000e+01), SC_(9.4548156738281250000000000000000000000000e+01), SC_(-2.8587162494659423828125000000000000000000e-01), SC_(6.1081415762488011236813510404231414779819e-06) }, 
      { SC_(8.6802124023437500000000000000000000000000e+01), SC_(9.2993255615234375000000000000000000000000e+01), SC_(-7.4018768310546875000000000000000000000000e+01), SC_(-6.9112324714660644531250000000000000000000e-01), SC_(-9.2183798012997141026454326490113581951846e+14) }, 
      { SC_(8.7146179199218750000000000000000000000000e+01), SC_(5.2928741455078125000000000000000000000000e+01), SC_(-8.4227294921875000000000000000000000000000e+00), SC_(-1.7563480138778686523437500000000000000000e-01), SC_(1.7517228741465218826611446054644016854078e+03) }, 
      { SC_(8.7828338623046875000000000000000000000000e+01), SC_(-8.8260314941406250000000000000000000000000e+01), SC_(-3.9738784790039062500000000000000000000000e+01), SC_(-1.5718632936477661132812500000000000000000e-01), SC_(9.7994331612602516686966240369378499064496e+35) }, 
      { SC_(8.7965881347656250000000000000000000000000e+01), SC_(-5.6572280883789062500000000000000000000000e+01), SC_(2.9110366821289062500000000000000000000000e+01), SC_(9.2990422248840332031250000000000000000000e-01), SC_(2.0303059944848684966786324944507674434562e-22) }, 
      { SC_(8.8410095214843750000000000000000000000000e+01), SC_(9.0988677978515625000000000000000000000000e+01), SC_(9.1226898193359375000000000000000000000000e+01), SC_(3.0393731594085693359375000000000000000000e-01), SC_(7.4983777557141289456621410128966683723973e+13) }, 
      //{ SC_(8.9586608886718750000000000000000000000000e+01), SC_(6.7183502197265625000000000000000000000000e+01), SC_(-8.3585784912109375000000000000000000000000e+01), SC_(9.0174841880798339843750000000000000000000e-01), SC_(5.1110361935787779755649743658291218070866e+350) }, 
      { SC_(9.0044403076171875000000000000000000000000e+01), SC_(-1.8821868896484375000000000000000000000000e+00), SC_(-9.3110809326171875000000000000000000000000e+01), SC_(3.2721102237701416015625000000000000000000e-01), SC_(4.5371906132046220195252707384957406962365e+35) }, 
      { SC_(9.0178863525390625000000000000000000000000e+01), SC_(9.9988311767578125000000000000000000000000e+01), SC_(-1.1207168579101562500000000000000000000000e+01), SC_(-5.9987092018127441406250000000000000000000e-01), SC_(1.4332663094452325753241597827007446643821e-06) }, 
      { SC_(9.0326080322265625000000000000000000000000e+01), SC_(7.5610107421875000000000000000000000000000e+01), SC_(8.4066406250000000000000000000000000000000e+01), SC_(-2.1506184339523315429687500000000000000000e-01), SC_(1.3566609825826061340135877160335552994047e-07) }, 
      { SC_(9.0691406250000000000000000000000000000000e+01), SC_(3.3133880615234375000000000000000000000000e+01), SC_(8.1768188476562500000000000000000000000000e+00), SC_(-8.8031888008117675781250000000000000000000e-03), SC_(2.0520303039422782817672520764475530800339e-02) }, 
      { SC_(9.1433380126953125000000000000000000000000e+01), SC_(-7.8027648925781250000000000000000000000000e+01), SC_(-2.9248733520507812500000000000000000000000e+00), SC_(5.9621167182922363281250000000000000000000e-01), SC_(4.6730186451327777177680697918962959070677e+09) }, 
      { SC_(9.1501373291015625000000000000000000000000e+01), SC_(9.9292266845703125000000000000000000000000e+01), SC_(9.2977691650390625000000000000000000000000e+01), SC_(9.3538975715637207031250000000000000000000e-01), SC_(2.1454839500458033720680018486938200761167e+116) }, 
      { SC_(9.1948791503906250000000000000000000000000e+01), SC_(1.4750930786132812500000000000000000000000e+01), SC_(-3.1922851562500000000000000000000000000000e+01), SC_(7.5351476669311523437500000000000000000000e-01), SC_(2.2935885921742708893534318418115404057980e+130) }, 
      { SC_(9.2617706298828125000000000000000000000000e+01), SC_(2.1185638427734375000000000000000000000000e+01), SC_(9.3611450195312500000000000000000000000000e+00), SC_(-5.4689741134643554687500000000000000000000e-01), SC_(1.1255862572841655501354684265291378622762e-18) }, 
      { SC_(9.2884521484375000000000000000000000000000e+01), SC_(-5.4916336059570312500000000000000000000000e+01), SC_(-1.3503005981445312500000000000000000000000e+01), SC_(-4.3040895462036132812500000000000000000000e-01), SC_(3.0151790012067127864829767717561251297802e+45) }, 
      { SC_(9.4594909667968750000000000000000000000000e+01), SC_(-7.1556579589843750000000000000000000000000e+01), SC_(2.9798294067382812500000000000000000000000e+01), SC_(2.8636205196380615234375000000000000000000e-01), SC_(7.2039293881713135366452260203106085749338e-20) }, 
      { SC_(9.5736114501953125000000000000000000000000e+01), SC_(-5.3519927978515625000000000000000000000000e+01), SC_(4.2538894653320312500000000000000000000000e+01), SC_(4.9380838871002197265625000000000000000000e-01), SC_(1.3274237894747251485456216220236304092055e-22) }, 
      { SC_(9.6879638671875000000000000000000000000000e+01), SC_(8.3203552246093750000000000000000000000000e+01), SC_(7.1787750244140625000000000000000000000000e+01), SC_(-6.7365944385528564453125000000000000000000e-02), SC_(6.5291192310861813016026415306261568839384e-04) }, 
      { SC_(9.7586944580078125000000000000000000000000e+01), SC_(7.5212249755859375000000000000000000000000e+00), SC_(-6.5913604736328125000000000000000000000000e+01), SC_(8.2627701759338378906250000000000000000000e-01), SC_(1.2841453106427416732041190220022515999761e+185) }, 
      { SC_(9.7683563232421875000000000000000000000000e+01), SC_(4.3197174072265625000000000000000000000000e+01), SC_(7.9964141845703125000000000000000000000000e+00), SC_(-1.2916326522827148437500000000000000000000e-02), SC_(-5.6394291658700497271627531058640783271757e-04) }, 
      { SC_(9.9077941894531250000000000000000000000000e+01), SC_(4.4081039428710937500000000000000000000000e+01), SC_(-3.3581436157226562500000000000000000000000e+01), SC_(1.8215370178222656250000000000000000000000e-01), SC_(2.6061694718239368533142282610016493548641e+52) }, 
      { SC_(9.9816070556640625000000000000000000000000e+01), SC_(3.4842590332031250000000000000000000000000e+01), SC_(-6.5775787353515625000000000000000000000000e+01), SC_(4.7859513759613037109375000000000000000000e-01), SC_(7.8419089341931209199194984266724459574651e+118) }
   }};
//#undef SC_

