/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * Common routines for any specific type of missile.
 * @file
 */

#ifndef _missile_h
#define _missile_h

#include "pm.h"

#ifdef missile_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Fires a missile.
 * @param c Shooting craft.
 * @param ind Station index of the missile.
 * @return 0=missile fired. -1=projectiles table full, sorry!
 */
EXTERN int   missile_fire(craft * c, int ind);

EXTERN int   missile_getIRTarget(craft * c, VPoint * t, double scanSlope);

#undef EXTERN
#endif
