--
-- gh-4627: binary session disconnect trigger yield could lead to
-- use after free of the session object. That happened because
-- iproto thread sent two requests to TX thread at disconnect:
--
--     - Close the session and run its on disconnect triggers;
--
--     - If all requests are handled, destroy the session.
--
-- When a connection is idle, all requests are handled, so both
-- these requests are sent. If the first one yielded in TX thread,
-- the second one arrived and destroyed the session right under
-- the feet of the first one.
--
net_box = require('net.box')
fiber = require('fiber')

box.schema.user.grant('guest', 'execute', 'universe')

-- This is a workaround for flakiness of the test
-- appearing when test-run does reconnects to the
-- instance and therefore creates multiple
-- sessions. By setting a flag for only one
-- session, others won't interfere in
-- session.on_disconnect().
function enable_on_disconnect()                 \
    box.session.storage.is_enabled = true       \
end

sid_before_yield = nil
sid_after_yield = nil
func = box.session.on_disconnect(function()     \
    if not box.session.storage.is_enabled then  \
        return                                  \
    end                                         \
    sid_before_yield = box.session.id()         \
    fiber.yield()                               \
    sid_after_yield = box.session.id()          \
end)

connection = net_box.connect(box.cfg.listen)
-- Connections, not related to this one, won't
-- call this function, and therefore won't do
-- anything in session.on_disconnect() trigger.
connection:call('enable_on_disconnect')
connection:close()

while not sid_after_yield do fiber.yield() end

sid_after_yield == sid_before_yield and sid_after_yield ~= 0 or \
    {sid_after_yield, sid_before_yield}

box.session.on_disconnect(nil, func)

box.schema.user.revoke('guest', 'execute', 'universe')
