/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.FunctionOfUnit;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.SimpleBinaryUnit;
import uk.me.nxg.unity.SimpleDecimalUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitRepresentation;
import uk.me.nxg.unity.UnwritableExpression;

public abstract class SimpleUnit
extends OneUnit {
    private final UnitDefinitionMap.Resolver unitResolver;
    private final int prefixPower;
    private final UnitDefinition baseUnitDefinition;
    private final String baseUnitString;
    static UnitGuesser[] allGuesses = new UnitGuesser[]{new PatternUnitGuesser(Pattern.compile("deg(ree)?s?"), "http://qudt.org/vocab/unit#DegreeAngle"), new PatternUnitGuesser(Pattern.compile("sec(ond)?s?"), "http://qudt.org/vocab/unit#SecondTime"), new PluralUnitGuesser(), new AnythingGuesser()};

    SimpleUnit(UnitDefinitionMap.Resolver resolver, int n, String string, UnitDefinition unitDefinition, float f, boolean bl) {
        super(f, bl);
        if (resolver == null) {
            throw new IllegalArgumentException("SimpleUnit constructor: resolver 'r' must be non-null");
        }
        if (string == null) {
            throw new IllegalArgumentException("SimpleUnit constructor: unit string 'us' must be non-null");
        }
        this.prefixPower = n;
        this.baseUnitString = string;
        this.baseUnitDefinition = unitDefinition;
        this.unitResolver = resolver;
        assert (this.baseUnitString != null);
        assert (this.unitResolver != null);
    }

    static SimpleUnit makeSimpleUnit(UnitDefinitionMap.Resolver resolver, String string, float f, boolean bl) {
        UnitRepresentation unitRepresentation;
        String string2;
        PrefixSplit prefixSplit;
        SimpleUnit simpleUnit = null;
        UnitDefinition unitDefinition = resolver.lookupSymbol(string);
        if (unitDefinition != null) {
            simpleUnit = new SimpleDecimalUnit(resolver, 0, string, unitDefinition, f);
        }
        if (simpleUnit == null && (prefixSplit = SimpleBinaryUnit.splitUnitString(string)) != null && (unitDefinition = resolver.lookupSymbol(string2 = prefixSplit.getUnit())) != null && (unitRepresentation = unitDefinition.getRepresentation(resolver.getSyntax())) != null && unitRepresentation.mayHaveBinaryPrefixes()) {
            simpleUnit = new SimpleBinaryUnit(resolver, prefixSplit.getPower(), string2, unitDefinition, f);
        }
        if (simpleUnit == null) {
            prefixSplit = SimpleDecimalUnit.splitUnitString(string);
            if (prefixSplit == null) {
                if (bl) {
                    simpleUnit = SimpleUnit.guessUnit(resolver, string, 0, string, f);
                }
                if (simpleUnit == null) {
                    simpleUnit = new SimpleDecimalUnit(resolver, 0, string, null, f);
                }
            } else {
                string2 = prefixSplit.getUnit();
                unitDefinition = resolver.lookupSymbol(string2);
                if (unitDefinition == null) {
                    if (bl) {
                        simpleUnit = SimpleUnit.guessUnit(resolver, string, prefixSplit.getPower(), string2, f);
                    }
                    if (simpleUnit == null) {
                        simpleUnit = new SimpleDecimalUnit(resolver, prefixSplit.getPower(), string2, null, f);
                    }
                } else {
                    simpleUnit = new SimpleDecimalUnit(resolver, prefixSplit.getPower(), string2, unitDefinition, f);
                }
            }
        }
        assert (simpleUnit != null);
        return simpleUnit;
    }

    static SimpleUnit makeQuotedSimpleUnit(UnitDefinitionMap.Resolver resolver, String string, String string2, float f) throws UnitParserException {
        SimpleDecimalUnit simpleDecimalUnit;
        if (string == null) {
            simpleDecimalUnit = new SimpleDecimalUnit(resolver, 0, string2, null, f, true, false);
        } else {
            String string3 = string + "X";
            PrefixSplit prefixSplit = SimpleDecimalUnit.splitUnitString(string3);
            if (prefixSplit != null) {
                simpleDecimalUnit = new SimpleDecimalUnit(resolver, prefixSplit.getPower(), string2, null, f, true, false);
            } else {
                throw new UnitParserException("Unrecognised prefix: " + string);
            }
        }
        assert (simpleDecimalUnit != null);
        return simpleDecimalUnit;
    }

    @Override
    abstract SimpleUnit reciprocate();

    @Override
    public int getPrefix() {
        return this.prefixPower;
    }

    abstract String prefixPowerToString();

    abstract String prefixPowerToStringLaTeX();

    @Override
    public String toString() {
        try {
            return this.toString(null);
        }
        catch (UnitParserException unitParserException) {
            throw new AssertionError((Object)("SimpleUnit.toString() really should work: " + unitParserException));
        }
    }

    @Override
    public String toString(Syntax syntax) throws UnwritableExpression {
        if (syntax == Syntax.DEBUG) {
            return this.toDebugString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unitString(syntax));
        if (this.getExponent() != 1.0f) {
            stringBuilder.append('^').append(this.getExponent());
        }
        return stringBuilder.toString();
    }

    @Override
    public String unitString(Syntax syntax) throws UnwritableExpression {
        String string = syntax == Syntax.DEBUG ? this.toDebugString() : (syntax == Syntax.LATEX ? this.unitStringLaTeX() : this.unitStringText(syntax));
        assert (string != null) : syntax;
        return string;
    }

    @Override
    public UnitDefinition getBaseUnitDefinition() {
        return this.baseUnitDefinition;
    }

    @Override
    public String getBaseUnitName() {
        assert (this.baseUnitString != null);
        return this.baseUnitDefinition != null ? this.baseUnitDefinition.name() : this.baseUnitString;
    }

    @Override
    public String getBaseUnitString() {
        return this.baseUnitString;
    }

    @Override
    public Dimensions getDimensions() {
        if (this.baseUnitDefinition == null) {
            return null;
        }
        return this.baseUnitDefinition.dimensions();
    }

    @Override
    public String getOriginalUnitString() {
        return this.baseUnitString;
    }

    private String unitStringText(Syntax syntax) throws UnwritableExpression {
        if (syntax == Syntax.ALL) {
            throw new UnwritableExpression("You can't write in the ALL syntax");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefixPower != 0) {
            stringBuilder.append(this.prefixPowerToString());
        }
        if (this.baseUnitDefinition == null) {
            assert (this.baseUnitString != null);
            if (this.isQuoted()) {
                stringBuilder.append('\'').append(this.baseUnitString).append('\'');
            } else {
                stringBuilder.append(this.baseUnitString);
            }
        } else {
            UnitDefinitionMap.Resolver resolver;
            if (syntax == null) {
                resolver = this.unitResolver;
            } else {
                resolver = UnitDefinitionMap.getInstance().getResolver(syntax);
                if (resolver == null) {
                    throw new AssertionError((Object)("unitString: Unknown syntax: " + (Object)((Object)syntax)));
                }
            }
            UnitRepresentation unitRepresentation = resolver.lookupUnit(this.baseUnitDefinition);
            if (unitRepresentation == null) {
                unitRepresentation = this.unitResolver.lookupUnit(this.baseUnitDefinition);
            }
            if (unitRepresentation == null) {
                unitRepresentation = UnitDefinitionMap.getInstance().lookupUnitRepresentation(Syntax.ALL, this.baseUnitDefinition);
            }
            assert (unitRepresentation != null) : String.format("unitStringText: no representation for syntax [%s]", new Object[]{syntax});
            stringBuilder.append(unitRepresentation.getAbbreviation());
        }
        return stringBuilder.toString();
    }

    private String unitStringLaTeX() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.prefixPower != 0) {
            stringBuilder.append(this.prefixPowerToStringLaTeX()).append(' ');
        }
        if (this.baseUnitDefinition == null) {
            assert (this.baseUnitString != null);
            stringBuilder.append(this.baseUnitString);
        } else if (this.baseUnitDefinition.latexForm() != null) {
            stringBuilder.append(this.baseUnitDefinition.latexForm());
        } else {
            UnitRepresentation unitRepresentation = this.unitResolver.lookupUnit(this.baseUnitDefinition);
            assert (unitRepresentation != null) : "unit's own representation has disappeared";
            stringBuilder.append(unitRepresentation.getAbbreviation());
        }
        return stringBuilder.toString();
    }

    public String unitString() {
        try {
            return this.unitString(null);
        }
        catch (UnitParserException unitParserException) {
            throw new AssertionError((Object)"Odd: SimpleUnit.unitString() should not have failed");
        }
    }

    private static SimpleUnit guessUnit(UnitDefinitionMap.Resolver resolver, String string, int n, String string2, float f) {
        for (int i = 0; i < allGuesses.length; ++i) {
            UnitDefinition unitDefinition = null;
            int n2 = n;
            String string3 = string2;
            if (n != 0) {
                unitDefinition = allGuesses[i].guess(string2);
            }
            if (unitDefinition == null) {
                n2 = 0;
                string3 = string;
                unitDefinition = allGuesses[i].guess(string);
            }
            if (unitDefinition == null) continue;
            return new SimpleDecimalUnit(resolver, n2, string3, unitDefinition, f, false, true);
        }
        return null;
    }

    @Override
    UnitDefinitionMap.Resolver getUnitResolver() {
        return this.unitResolver;
    }

    @Override
    public boolean isRecognisedUnit(Syntax syntax) {
        if (syntax == Syntax.ALL) {
            return this.baseUnitDefinition != null;
        }
        return this.baseUnitDefinition != null && this.baseUnitDefinition.getRepresentation(syntax) != null;
    }

    @Override
    public boolean isRecognisedUnit() {
        return this.baseUnitDefinition != null;
    }

    @Override
    public boolean isRecommendedUnit(Syntax syntax) {
        if (this.baseUnitDefinition == null) {
            return false;
        }
        UnitRepresentation unitRepresentation = this.baseUnitDefinition.getRepresentation(syntax);
        return unitRepresentation != null && !unitRepresentation.isDeprecated();
    }

    abstract boolean hasPermittedPrefix(UnitRepresentation var1);

    @Override
    public boolean satisfiesUsageConstraints(Syntax syntax) {
        UnitRepresentation unitRepresentation;
        boolean bl = this.baseUnitDefinition == null ? true : ((unitRepresentation = this.baseUnitDefinition.getRepresentation(syntax)) == null ? true : this.hasPermittedPrefix(unitRepresentation));
        return bl;
    }

    @Override
    public String toDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.prefixPower);
        if (this instanceof SimpleBinaryUnit) {
            stringBuilder.append('b');
        }
        stringBuilder.append('/');
        stringBuilder.append(this.baseUnitDefinition != null ? this.baseUnitDefinition.label() : this.baseUnitString);
        stringBuilder.append('/');
        float f = this.getExponent();
        if ((double)f == Math.floor(f)) {
            stringBuilder.append(Math.round(f));
        } else {
            stringBuilder.append(f);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleUnit) {
            return this.compareTo((SimpleUnit)object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(OneUnit oneUnit) {
        int n;
        if (oneUnit == this) {
            n = 0;
        } else if (oneUnit instanceof FunctionOfUnit) {
            n = -1;
        } else {
            double d;
            assert (oneUnit instanceof SimpleUnit) : String.format("What sort of unit is [%s]?!", oneUnit);
            SimpleUnit simpleUnit = (SimpleUnit)oneUnit;
            double d2 = this.getExponent();
            if (d2 == (d = (double)simpleUnit.getExponent())) {
                if (this.baseUnitDefinition != null) {
                    n = simpleUnit.baseUnitDefinition == null ? -1 : this.baseUnitDefinition.compareTo(simpleUnit.baseUnitDefinition);
                } else if (simpleUnit.baseUnitDefinition != null) {
                    n = 1;
                } else {
                    assert (this.baseUnitString != null && simpleUnit.baseUnitString != null);
                    n = this.baseUnitString.compareTo(simpleUnit.baseUnitString);
                }
                if (n == 0) {
                    n = this.prefixPower == simpleUnit.prefixPower ? 0 : (this.prefixPower < simpleUnit.prefixPower ? -1 : 1);
                }
            } else {
                n = d2 * d < 0.0 ? (d2 > 0.0 ? -1 : 1) : (Math.abs(d2) < Math.abs(d) ? -1 : 1);
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.prefixPower;
        if (this.baseUnitDefinition == null) {
            assert (this.baseUnitString != null);
            n = 37 * n + this.baseUnitString.hashCode();
        } else {
            n = 37 * n + this.baseUnitDefinition.hashCode();
        }
        long l = Double.doubleToLongBits(this.getExponent());
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    static interface PrefixSplit {
        public int getPower();

        public boolean isBinaryPrefix();

        public String getUnit();
    }

    private static class AnythingGuesser
    extends UnitGuesser {
        private AnythingGuesser() {
        }

        @Override
        public UnitDefinition guess(String string) {
            return udm.lookupUnitDefinition(Syntax.ALL, string);
        }
    }

    private static class PluralUnitGuesser
    extends UnitGuesser {
        private final Pattern p = Pattern.compile("(.*)s");

        PluralUnitGuesser() {
        }

        @Override
        public UnitDefinition guess(String string) {
            Matcher matcher = this.p.matcher(string);
            UnitDefinition unitDefinition = null;
            if (matcher.matches()) {
                unitDefinition = udm.lookupUnitDefinition(Syntax.ALL, matcher.group(1));
            }
            return unitDefinition;
        }
    }

    private static class PatternUnitGuesser
    extends UnitGuesser {
        private final Pattern p;
        private final UnitDefinition response;

        PatternUnitGuesser(Pattern pattern, String string) {
            this.p = pattern;
            this.response = udm.lookupUnitDefinition(string);
            assert (this.response != null) : String.format("unitUri [%s] is inexplicably unknown", string);
        }

        @Override
        public UnitDefinition guess(String string) {
            Matcher matcher = this.p.matcher(string);
            if (matcher.matches()) {
                return this.response;
            }
            return null;
        }
    }

    private static class UnitGuesser {
        protected static UnitDefinitionMap udm = UnitDefinitionMap.getInstance();

        private UnitGuesser() {
        }

        public UnitDefinition guess(String string) {
            return null;
        }
    }
}

