% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controller.R
\docType{class}
\name{MWController-class}
\alias{MWController-class}
\alias{MWController}
\title{Controller object of a manipulateWidget application}
\description{
\code{MWController} is a reference class that is used to manage interaction
with data and update of the view created by manipulateWidget. Only users who
desire to create automatic tests for applications created with
\code{\link{manipulateWidget}} should care about this object.
}
\section{Fields}{

\describe{
\item{\code{ncharts}}{Number of charts in the application}

\item{\code{nrow}}{Number of rows.}

\item{\code{ncol}}{Number of columns.}

\item{\code{autoUpdate}}{Boolean indicating if charts should be automatically
updated when a value changes. list with \code{value} and \code{initBtn} (not autoUpdate, if want first charts on init)}
}}

\section{Methods}{

\describe{
\item{\code{getParams(name, chartId = 1)}}{Get parameters of an input for a given chart}

\item{\code{getValue(name, chartId = 1)}}{Get the value of a variable for a given chart.}

\item{\code{getValues(chartId = 1)}}{Get all values for a given chart.}

\item{\code{isVisible(name, chartId = 1)}}{Indicates if a given input is visible}

\item{\code{returnCharts()}}{Return all charts.}

\item{\code{setValue(name, value, chartId = 1, reactive = FALSE)}}{Update the value of a variable for a given chart.}

\item{\code{updateCharts()}}{Update all charts.}
}}

\section{Testing a manipulateWidget application}{

When \code{\link{manipulateWidget}} is used in a test script, it returns a
\code{MWController} object instead of starting a shiny gadget. This object has
methods to modify inputs values and check the state of the application. This
can be useful to automatically checks if your application behaves like desired.
Here is some sample code that uses package \code{testthat}:

\preformatted{
library("testthat")

controller <- manipulateWidget(
  x + y,
  x = mwSlider(0, 10, 5),
  y = mwSlider(0, x, 0),
  .compare = "y"
)

test_that("Two charts are created", {
  expect_equal(controller$ncharts, 2)
})

test_that("Parameter 'max' of 'y' is updated when 'x' changes", {
  expect_equal(controller$getParams("y", 1)$max, 5)
  expect_equal(controller$getParams("y", 2)$max, 5)
  controller$setValue("x", 3)
  expect_equal(controller$getParams("y", 1)$max, 3)
  expect_equal(controller$getParams("y", 2)$max, 3)
})

}
}

