.\"
.\"     $Id: ncarlogo2ps.m,v 1.2 2008-07-27 03:34:10 haley Exp $
.\"
.TH ncarlogo2ps 1NCARG "April 2002" UNIX "NCAR GRAPHICS"
.na
.nh
.SH NAME
ncarlogo2ps - adds NCAR logos to pre-existing PostScript files generated by NCAR Graphics.
.SH SYNOPSIS
usage: ncarlogo2ps [-s size] [-position x:y] [-angle ang]
.br
                   [-input input_file] [-output output_file]
.SH DESCRIPTION 
"ncarlogo2ps" takes as input a PostScript file created
from NCAR Graphics 3.2 or later, or created from a
"ctrans -d ps.color" command, and adds an NCAR logo
to each frame.
.sp
The options are:
.IP "-s size" 12
Specifies the height of the logo in inches.
The default is 0.517 inches.
.IP "-p position"
x:y specifies the X-Y position of the center
of the logo in inches.  Only the "-p" is
significant.  The default is 7.35:2.3
.IP "-angle ang"
Specifies the angle in degrees to rotate
the logo from the defualt upright position.
.IP "-input input_file"
Specifies the PostScript input file.  This
must have been generated by NCAR Graphics.
If no input option is specified, the input
defaults to standard in.
.IP "-output output_file"
Specifies the PostScript output file.  If
no output option is specified, the output
defaults to standard out.
.RE
.sp
The options may appear in any order and only the first
character is significant.
.SH EXAMPLE
ncarglogo2ps -s 0.75 -p 7.0:0.75 < input_file > ouptut_file
.sp
would place in the output file a logo 7 inches from the left
edge and 3/4" from the bottom with a height of 3/4".

.SH COPYRIGHT
Copyright (C) 2002
.br
University Corporation for Atmospheric Research
.br

The use of this Software is governed by a License Agreement.
