# Here are defined filters controlled by the lists in ../lists/, plus
# related functions:
#
#     does_need_extra_zzz          LIST3 FILE2
#     is_ctrl_wanted               LIST3 FILE2
#     filepaths_from_sources_ctrl  CTRL AREA  -> [FILE0...]
#     filepaths_from_packages_ctrl CTRL       -> [FILE0...]
#     filepaths_from_sha_ctrl      CTRL BASE6 -> [FILE0...]
#
# See 10function-definitions.bash for general notes that are relevant here.

function does_need_extra_zzz {
    local DNEZ_PATTERN
    for DNEZ_PATTERN in $(<"$LIST_DIR/$1"); do
        [[ "$2" = *([^/.])/$(eval echo $DNEZ_PATTERN) ]] && return 0
    done
    return 1;
}
readonly -f does_need_extra_zzz

# (Here is a utility function for is_ctrl_wanted.)
readonly F11_EL_PAT='\$\{LANGS\[\*\]\}'
function expand_languages {
    local EL_LANG
    local EL_RECORD
    for EL_RECORD; do
        if grep -qhE <<<"$EL_RECORD" -- "${F11_EL_PAT}"; then
            for EL_LANG in "${LANGS[@]}"; do
                sed -r <<<"$EL_RECORD" -- "s;${F11_EL_PAT};${EL_LANG};"
            done
        else
            printf '%s\n' "$EL_RECORD"
        fi
    done
    return 0
}
readonly -f expand_languages

# (Here is a utility function for is_ctrl_wanted.)
# example: icw_stem "i18n/Translation-@"  -> "i18n/Translation-+([^/.-])"
# example: icw_stem "i18n/Translation-en" -> "i18n/Translation-en"
function icw_stem {
    if [[ "$1" = *-@ ]]; then
        printf '%s' "${1%@}"'+([^/.-])'
    else
        printf '%s' "$1"
    fi
    return 0
}
readonly -f icw_stem

function is_ctrl_wanted {
    local ICW_STEM
    local ICW_PATTERN
    local ICW_EXT
    for ICW_PATTERN in $(expand_languages $(<"$LIST_DIR/$1")); do
        if [[ "$ICW_PATTERN" = *.@*([[:alnum:]]) ]]; then
            ICW_STEM="$(icw_stem "$(\
                eval echo ${ICW_PATTERN%.@*([[:alnum:]])}\
            )")"
            ICW_EXT="$COMPRESS_EXT";\
             [[ "$ICW_PATTERN" = *.@+([[:alnum:]]) ]]\
             && ICW_EXT="${ICW_PATTERN##*.@}"
            if (($OPT_SUMS)); then
                [[ "$2" = *([^/.])/${ICW_STEM}?(.@($ICW_EXT)) ]]\
                 && return 0
            else
                [[ "$2" = *([^/.])/${ICW_STEM}.@($ICW_EXT) ]]\
                 && return 0
            fi
        else
            ICW_STEM="$(icw_stem "$(eval echo $ICW_PATTERN)")"
            [[ "$2" = *([^/.])/${ICW_STEM} ]] && return 0
        fi
    done
    return 1;
}
readonly -f is_ctrl_wanted

# (Some programming constructs are easier to write than to read,
# unfortunately. To read the following by eye is probably too hard, but if
# you are familiar with Sed, then you can read the following with the help
# of a pencil or a text editor -- or even a shell -- by working backward
# from F11_SC_PAT.)
readonly F11_SC_P1='^Checksums-Sha256:'
declare F11_SC_P2a='(\s+\S+){2}\s+';\
 (($OPT_SUMS)) && F11_SC_P2a='\s+(\S+)\s+\S+\s+'
readonly F11_SC_P2a
readonly F11_SC_P2b='((lib)?[[:alnum:]])([[:alnum:].+-]*)(_\S+)\s*'
readonly F11_SC_P2='^'"${F11_SC_P2a}${F11_SC_P2b}"'$'
readonly F11_SC_G1=':a;/'
readonly F11_SC_G2='/bb;d;:b;n;s%'
readonly F11_SC_G3s='%\1  '
readonly F11_SC_G3='%'
readonly F11_SC_G4='%p;tb;ba'
function filepaths_from_sources_ctrl {
    local F11_SC_R2 F11_SC_LEFT F11_SC_RIGHT
    readonly F11_SC_R2='pool/'"$2"'/\2/\2\4/\2\4\5'
    readonly F11_SC_LEFT="${F11_SC_G1}${F11_SC_P1}${F11_SC_G2}${F11_SC_P2}"
    readonly F11_SC_RIGHT="${F11_SC_R2}${F11_SC_G4}"
    declare F11_SC_PAT="${F11_SC_LEFT}${F11_SC_G3}${F11_SC_RIGHT}";\
     (($OPT_SUMS)) && F11_SC_PAT="${F11_SC_LEFT}${F11_SC_G3s}${F11_SC_RIGHT}"
    readonly F11_SC_PAT
    sed -rn -- "$F11_SC_PAT" "$1"
    return 0
}
readonly -f filepaths_from_sources_ctrl

function filepaths_from_packages_ctrl {
    if (($OPT_SUMS)); then
        sed -rn -- 's/^(Filename|SHA256):\s*(\S+).*$/\2/p' "$1"\
        | sed -rn -- 'h;n;G;s/\n/  /;p'
    else
        sed -rn -- 's/^Filename:\s*(\S+).*$/\1/p' "$1"
    fi
    return 0
}
readonly -f filepaths_from_packages_ctrl

function filepaths_from_sha_ctrl {
    if (($OPT_SUMS)); then
        sed -r -- 's%^(\S+)\s+\./%\1  '"$2"'/%' "$1"
    else
        sed -r -- 's%^\S+\s+\./%'"$2"'/%' "$1"
    fi
    return 0
}
readonly -f filepaths_from_sha_ctrl
true

