/*
 * Copyright (C) 2018-2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once
#include "CL/cl_ext.h"

namespace NEO {

enum PerformanceHints {
    CL_BUFFER_DOESNT_MEET_ALIGNMENT_RESTRICTIONS,
    CL_BUFFER_MEETS_ALIGNMENT_RESTRICTIONS,
    CL_BUFFER_NEEDS_ALLOCATE_MEMORY,
    CL_IMAGE_MEETS_ALIGNMENT_RESTRICTIONS,
    DRIVER_CALLS_INTERNAL_CL_FLUSH,
    PROFILING_ENABLED,
    SUBBUFFER_SHARES_MEMORY,
    CL_SVM_ALLOC_MEETS_ALIGNMENT_RESTRICTIONS,
    CL_ENQUEUE_READ_BUFFER_REQUIRES_COPY_DATA,
    CL_ENQUEUE_READ_BUFFER_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_READ_BUFFER_DOESNT_MEET_ALIGNMENT_RESTRICTIONS,
    CL_ENQUEUE_READ_BUFFER_RECT_REQUIRES_COPY_DATA,
    CL_ENQUEUE_READ_BUFFER_RECT_DOESNT_REQUIRES_COPY_DATA,
    CL_ENQUEUE_READ_BUFFER_RECT_DOESNT_MEET_ALIGNMENT_RESTRICTIONS,
    CL_ENQUEUE_WRITE_BUFFER_REQUIRES_COPY_DATA,
    CL_ENQUEUE_WRITE_BUFFER_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_WRITE_BUFFER_RECT_REQUIRES_COPY_DATA,
    CL_ENQUEUE_WRITE_BUFFER_RECT_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_READ_IMAGE_DOESNT_MEET_ALIGNMENT_RESTRICTIONS,
    CL_ENQUEUE_READ_IMAGE_DOESNT_REQUIRES_COPY_DATA,
    CL_ENQUEUE_WRITE_IMAGE_REQUIRES_COPY_DATA,
    CL_ENQUEUE_WRITE_IMAGE_DOESNT_REQUIRES_COPY_DATA,
    CL_ENQUEUE_MAP_BUFFER_REQUIRES_COPY_DATA,
    CL_ENQUEUE_MAP_BUFFER_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_MAP_IMAGE_REQUIRES_COPY_DATA,
    CL_ENQUEUE_MAP_IMAGE_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_UNMAP_MEM_OBJ_DOESNT_REQUIRE_COPY_DATA,
    CL_ENQUEUE_UNMAP_MEM_OBJ_REQUIRES_COPY_DATA,
    CL_ENQUEUE_SVM_MAP_DOESNT_REQUIRE_COPY_DATA,
    PRINTF_DETECTED_IN_KERNEL,
    NULL_LOCAL_WORKGROUP_SIZE,
    BAD_LOCAL_WORKGROUP_SIZE,
    REGISTER_PRESSURE_TOO_HIGH,
    PRIVATE_MEMORY_USAGE_TOO_HIGH,
    KERNEL_REQUIRES_COHERENCY,
    KERNEL_ARGUMENT_AUX_TRANSLATION,
    KERNEL_ALLOCATION_AUX_TRANSLATION,
    BUFFER_IS_COMPRESSED,
    BUFFER_IS_NOT_COMPRESSED,
    IMAGE_IS_COMPRESSED,
    IMAGE_IS_NOT_COMPRESSED
};

class DriverDiagnostics {
  public:
    DriverDiagnostics(cl_diagnostic_verbose_level_intel level);
    bool validFlags(cl_diagnostic_verbose_level_intel flags) const;
    ~DriverDiagnostics() = default;
    static const char *const hintFormat[];
    static const cl_int maxHintStringSize = 1024;
    PerformanceHints obtainHintForTransferOperation(cl_command_type commandType, bool transferRequired);

  protected:
    cl_diagnostic_verbose_level_intel verboseLevel;
};
} // namespace NEO
