//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VulnerabilityAssessmentBaselineClient contains the methods for the SQLVulnerabilityAssessmentBaseline group.
// Don't use this type directly, use NewVulnerabilityAssessmentBaselineClient() instead.
type VulnerabilityAssessmentBaselineClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVulnerabilityAssessmentBaselineClient creates a new instance of VulnerabilityAssessmentBaselineClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVulnerabilityAssessmentBaselineClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VulnerabilityAssessmentBaselineClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VulnerabilityAssessmentBaselineClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets a list of database's sql vulnerability assessment rule baselines.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentBaselineClientGetOptions contains the optional parameters for the VulnerabilityAssessmentBaselineClient.Get
//     method.
func (client *VulnerabilityAssessmentBaselineClient) Get(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *VulnerabilityAssessmentBaselineClientGetOptions) (VulnerabilityAssessmentBaselineClientGetResponse, error) {
	var err error
	const operationName = "VulnerabilityAssessmentBaselineClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, baselineName, options)
	if err != nil {
		return VulnerabilityAssessmentBaselineClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VulnerabilityAssessmentBaselineClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VulnerabilityAssessmentBaselineClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VulnerabilityAssessmentBaselineClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *VulnerabilityAssessmentBaselineClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VulnerabilityAssessmentBaselineClient) getHandleResponse(resp *http.Response) (VulnerabilityAssessmentBaselineClientGetResponse, error) {
	result := VulnerabilityAssessmentBaselineClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentBaselineSet); err != nil {
		return VulnerabilityAssessmentBaselineClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySQLVulnerabilityAssessmentPager - Gets a list of database's sql vulnerability assessment rule baselines.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentOptions contains the optional parameters
//     for the VulnerabilityAssessmentBaselineClient.NewListBySQLVulnerabilityAssessmentPager method.
func (client *VulnerabilityAssessmentBaselineClient) NewListBySQLVulnerabilityAssessmentPager(resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentOptions) *runtime.Pager[VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse]{
		More: func(page VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse) (VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VulnerabilityAssessmentBaselineClient.NewListBySQLVulnerabilityAssessmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySQLVulnerabilityAssessmentCreateRequest(ctx, resourceGroupName, serverName, vulnerabilityAssessmentName, options)
			}, nil)
			if err != nil {
				return VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse{}, err
			}
			return client.listBySQLVulnerabilityAssessmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySQLVulnerabilityAssessmentCreateRequest creates the ListBySQLVulnerabilityAssessment request.
func (client *VulnerabilityAssessmentBaselineClient) listBySQLVulnerabilityAssessmentCreateRequest(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("systemDatabaseName", "master")
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySQLVulnerabilityAssessmentHandleResponse handles the ListBySQLVulnerabilityAssessment response.
func (client *VulnerabilityAssessmentBaselineClient) listBySQLVulnerabilityAssessmentHandleResponse(resp *http.Response) (VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse, error) {
	result := VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentBaselineSetListResult); err != nil {
		return VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse{}, err
	}
	return result, nil
}
