// $Id: DRAWxtlViewUI.h 1090 2010-11-30 22:43:30Z martin $
//
// DRAWxtl V5.5 main window header
// initial version generated by Fast Light User Interface Designer (fluid) version 1.0104
// Coded using the FLTK 1.1.6 widget set
//
//     Larry W. Finger, Martin Kroeker and Brian Toby
//

#ifndef DRAWxtlViewUI_h
#define DRAWxtlViewUI_h
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Menu_.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Progress.H>
#include <FL/Fl_Browser.H>
#include <FL/x.H>
#include "drawxtl.h"
#include "CrystalView.h"
#include "Draw_Fl_Input.h"

#include "DRAWxtl_proto.h"

enum
{
    LIST1 = 1 << 0,
    LIST2 = 1 << 1,
    LIST3 = 1 << 2,
    HELP = 1 << 3,
    HELP1 = 1 << 4,
    TEXTWIN = 1 << 5,
    SPHERE = 1 << 6,
    ELLIPSOID = 1 << 7,
    LONEPAIR = 1 << 8,
    TEXT1 = 1 << 9
};

class DRAWxtl_Window:public Fl_Double_Window
{
  public:
    void resize (int X, int Y, int W, int H);
    DRAWxtl_Window (int x, int y, int w, int h, const char *l = 0):
    Fl_Double_Window (x, y, w, h, l) {
    };

    void draw (void)
    {
	Fl_Window::draw ();
    };
};

class DRAWxtlViewUI
{
  public:
    void show (int, char **);
    void draw (void);
      DRAWxtlViewUI ();		// constructor

// pointers to widgets

    DRAWxtl_Window *mainWindow;
    Fl_Text_Display *mainLabel;
    Fl_Multiline_Output *Cursor_pos;
    Fl_Browser *Cursor_posW;
    Fl_Choice *Cursor_reset;
    Fl_Output *CurDirBuf;
    Fl_Output *CurStrBuf;
    Fl_Text_Buffer *CutoutColorBuf;
    Fl_Check_Button *Use_Clipping;
    Flu_Spinner *X_Min;
    Flu_Spinner *Y_Min;
    Flu_Spinner *Z_Min;
    Flu_Spinner *X_Max;
    Flu_Spinner *Y_Max;
    Flu_Spinner *Z_Max;
    Flu_Spinner *X_Min_clip;
    Flu_Spinner *Y_Min_clip;
    Flu_Spinner *Z_Min_clip;
    Flu_Spinner *X_Max_clip;
    Flu_Spinner *Y_Max_clip;
    Flu_Spinner *Z_Max_clip;
    Draw_Fl_Input *Origin_X;
    Draw_Fl_Input *Origin_Y;
    Draw_Fl_Input *Origin_Z;
    Draw_Fl_Input *X_Rot;
    Draw_Fl_Input *Y_Rot;
    Draw_Fl_Input *Z_Rot;
    Fl_Output *CurFile;
    Fl_Output *CurDir;
    Fl_Check_Button *Generate_VRML1;
    Fl_Output *Origin1_Msg;
    Fl_Check_Button *Orthographic_View;
    Fl_Check_Button *Show_Vector_Triple;
    static Fl_Menu_Item drawxtl_menu[];
    Flu_Combo_List *Frame_No;
    CrystalView *crystal;

// variables used in drawing

    GLuint crystalDL;
    int destroy;		// window destructor flag variable
    char col_cell[40];		/* color and properties of framebars */
    int Str_File_Changed;	// set true (==1) if contents of str file changed
    float X_Boxlim;		// X box limit read from command line
    float Y_Boxlim;		// Y box limit read from command line
    float Z_Boxlim;		// Z box limit read from command line
    float X_Origin;		// X origin read from command line
    float Y_Origin;		// Y origin read from command line
    float Z_Origin;		// Z origin read from command line
    float lookat_v1[3], lookat_v2[3];	// "lookat" vectors "
    float label_scale;		// relative scaling of text labels
    int noshadow;		// if true, no shadows in POV
    float ambient;		// POV lighting options
    float diffuse;		//
    float specular;		//
    float roughness;		//
    int automation;		// TRUE if automation in progress
    char *automate_name;	// pointer to current name
    int Stereo;			// TRUE for stereo views
    int cross_eyed;		// TRUE for "cross-eyed" viewing
    float stereo_base;		// separation wanted
    float Trans[3];		// translation of virtual trackball
#if !defined (WIN32) && !defined (__APPLE__)
    Pixmap icon;		// icon used only for Linux/Unix 
#endif

// symmetry variables

#define MXSYM 192
    char spg[3][4];		// space group code
    int ss[MXSYM][3][3];	// rotation operators for symmetry
    float rss[MXSYM][3][3];	// unitary rotation operators for symmetry
    float rssC[MXSYM][3][3];	// crystallographic rotation operators for symmetry
    float lat_pos[4][3];	// coordinates of lattice points
    float ts[MXSYM][3];		// translation operators
    int sym_op_no[MXSYM];	// saved symmetry operation number
    int sym_op_signed[MXSYM];	// saved symmetry operation number, signed
    float cell_xyz[MXSYM][3];	// storage for generated equiv. positions
    int sys;			// crystal system indicator
    int nbr;			// Bravais lattice indicator
    int acentric;		// true if non-centric space group
    int ng;			// number of rotation operations to specify group
    int nlat;			// number of lattice positions
    float xyzoff[3];		// offset between origin and center of symmetry
    int xyzoff_read;		// true if xyzoff line read
    int origin1_flag;		// true if space group has alternate origin setting
    float origin_offset[3];	// offset vector between settings

// lattice constant variables

    float lat_con[6];		// lattice constants
    float rec_lat_con[6];	// reciprocal lengths and cosines of angles
    double b_mat[3][3];		// metric tensor
    float ginv[3][3];		// direct space metric tensor

// lattice parameters of cutout box 

    float slab_con[6];		// lattice constants
    float slab_off[3];		// offset
    float slab_rot[3];		// rotation angles

// variables for atom lists

    int verts_alloc;		// number of vertices allocated
    struct atom_struct *atoms;	// pointer where atom data is stored
    int atom_alloc;		// number of atoms allocated
    int *atom_no;		// master list atom and symmetry number
    int *atom_so;		// atom symmetry number including inversion flag
    int *orig_atom_no;		// saved atom number

// atom list variables for modulated structures
    struct mod_gbl_struct *modulate_gbl;	// pointer to gloabal modulation parameters
    struct mod_x_struct *modulate_x;	// pointer to X modulation parameters
    struct mod_3x_struct *modulate_3x;	// pointer to 3X modulation parameters
    struct mod_3t_struct *modulate_3t;	// pointer to TF modulation
    int mod_gbl_alloc;		// number of global modulations allocated
    int mod_x_alloc;		// number of X modulations allocated
    int mod_3x_alloc;		// number of 3X modulations allocated
    int mod_3t_alloc;		// number of 3T modulations allocated
    int modulated;		// flag for modulated or conventional/average structure
    int no_mod_vectors;		// number of atom_site_fourier_wave_vectors
    int no_site_displace;	// number of atom_site_displace_fourier terms
    int no_site_U_terms;	// number of atom_site_U_fourier_terms
    int no_site_occ;		// number of atom_site_occ_fourier terms
    int no_cell_vec;		// number of cell_wave_vectors
    float cell_vec[3][3];	// cell_wave_vectors
    int no_subsys;		// number of subsystems
    float subsys_ref_volume;	// reference reciprocal volume
    float subsys_vol[10];	// reciprocal volume for each of the subsystems
    float subsys_fact[10][3][3];	// place to save relationship between main and subsystem cells
    float phaseshift[3];	// modulation phase offset t for each modulation
    float *vert_occ;		// occupancy at individual sites (for radius scaling)
    float ts_m[MXSYM][3];	// translational component of superspace symmetry
    int ss_m[MXSYM][3][3];	// rotational component of superspace symmetry


// cone parameters

    int ncone;			// number of different types of lonepair cones
    int ncone_alloc;		// number of lonepairs currently allocated
    struct cone_struct *cones;	// place to allocate cone space

// magnetic arrow parameters

    int nmag;			// number of magnetic moments
    int nmag_alloc;		// number of moments currently allocated
    float mag_matrix[3][3];	// transformation between magnetic and nuclear cell
    struct arrow_struct *arrows;	// place to allocate arrow space

// polyhedra parameters

    int npoly;			// number of different types of polyhedra
    int npoly_alloc;		// number of polyhedra that have been allocated
    float polylimit;		// should be close to zero to allow only regular polygonal faces
    struct poly_struct *polyhedra;	// place to allocate polyhedra space
    char col_edge[40];		// default color for edge
    float rad_edge;		// default radius for edge
    int nedges;			// number of different edge settings
    int nedge_alloc;		// number of edge parameter sets currently allocated
    struct edge_struct *polyedges;
    
// plane parameters

    int nplane;			// number of different types of planes
    int nplane_alloc;		// number of planes allocated
    struct plane_struct *planes;	// place to allocate space for planes

// bond parameters

    int nbond;			// number of different types of bonds
    int nbond_alloc;		// number of bond types allocated
    struct bond_struct *bonds;	// pointer to bond storage
    float Bond_Mult;		// Multiplier for Bond Size
    float BndMult;		// Bond multiplier initialization
    float mol_d;		// intramolecular distance for molecular and polyhedral completion

// sphere parameters

    int nsphere;		// number of different types of spheres
    int nsphere_alloc;		// number allocated
    struct sphere_struct *spheres;	// pointer to sphere allocation
    float Sphere_Mult;		// Multiplier for Sphere Size
    float SpMult;		// initialization for Sphere_Mult


// background parameters

    char col_bg[40];		// Background color in POV file
    float glback[3];		// Background RGB values for openGL

// ellipsoid parameters

    int auto_ellipse;		// true if ellipsoids should be automatically generated
    struct ellips_struct *ellips;	// pointer to where ellipsoid data are stored
    int ellips_alloc;		// number of ellipsoids allocated
    float Phong_Value;		// reflectivity value for Phong highlighting
    float Phong_Size;		// Phong highlighting size
    char Cutout_color[40];	// color of cutout section
    char Ellipaxis_color[40];	/* color of principal axes */
    int n_ellips;		// no. of aniso. atoms in asymmetric unit
    int do_ellipsoids;		// non-zero if ellipsoids to be drawn
    int El_Cutout;		// True if ellipsoids to have an octant removed
    float Ellipsoid_Prob;	/* Fraction of electron dens enclosed by ellipsoid */
    float Ellipsoid_Scale;	/* Scaling needed to get probability */
    float Ellipaxis_width;	/* linewidth of principal axes */

// text label parameters

    int nlabel;			// number of textual labels
    int nlabel_alloc;		// amount of space allocated
    struct label_struct *labels;	// pointer to label storage
    float saved_x_label[2][4][3];	// place to save coordinates of each type of label
    int labels_inited;		// set to true when labels initialized
    int triple[4];		// label numbers of the parts of the triple vector
    int autolabel;		// set to true when import adds atom labels

// least squares plane parameters

    int nbplane;		// number of least squares planes
    int nbplane_alloc;		// number of least-squares planes allocated
    struct bplane_struct *bplanes;	// pointer to allocated storage

// miscellaneous variables

    double Old_Xrot;		// Used to determine if str file changed
    double Old_Yrot;		// Used to determine if str file changed
    double Old_Zrot;		// Used to determine if str file changed
    float cur_step;		// Graphics cursor step size
    int cur_reset;		//
    char *table;		// used to store miscellaneous character data
    char *msgbuffer	;	// used to accumulate warning messages
    
// Fourier Map parameters

    int numOfFourierContours;
    int num_Fourier_alloc;	// number allocated
    struct map_struct *fourier;	// pointer to dynamic Fourier storage
    bool Fourier2d;		// true if 2d Fourier
    int Slice;			// >0 if 2d slice through 3d set
    float mapslice[3];		// coordinates of a point in the slice plane
    float mapnorm[3];		// normal of the 2d slice plane
    float mapplane[4];		// parameters of plane equation
    
// Bader Surface parameters

#define MAX_SURF 5
    int nsurf;
    char surfatom[MAX_SURF][5];
    char surfcolor[MAX_SURF][40];
    char surffile[MAX_SURF][255];
    int surfnum[MAX_SURF];
    int surftype[MAX_SURF];
    int ntet[MAX_SURF];
    int nphi[MAX_SURF];
    float *surfx[MAX_SURF];
    float *surfy[MAX_SURF];
    float *surfz[MAX_SURF];

// atomic property parameters

    int natprop;		// number of different types of property definitions
    int natprop_alloc;		// number allocated
    struct atprop_struct *atprops;	// pointer to allocation

// void or solvent accessible surface parameters
    char ***voidmap;
    int voidgrid[3];
    float probesize;
    char voidcolor[40];
    signed char voidflag;
    char *voiddata1;
    char *voiddata2;

// frame variables

    int frame_no;		// number of frame being processed
    int max_frame;		// maximum number of frames used
    int frame_alloc;		// number of frames allocated
    struct frame_struct *frames;	// pointer to frame data

// file variables

    FILE *fpin, *flout;
    FILE *fpoutv;
    FILE *fpoutp;
    FILE *fpouta;
    FILE *fcns;
    char Cur_Console[1024];	// file strings
    char Cur_Dir[1024];
    char Cur_File[1024];
    char Cur_Temp[1024];
    char Cur_Listing[1024];
    char Cur_Root[1024];
    char DRAWxtl_Path[1024];
    char EditName[1024];
    char FileViewName[1024];
    char POV_Include[1024];
    char POV_Options[1024];
    char POV_Path[1024];
    char MSMS_Path[1024];
    char Mencoder_Path[1024];
    char FFmpeg_Path[1024];
    char DefaultFinish[1024];
    char VRML_Path[1024];
    char LoadOnStartup[128];
    char ProgramPath[1024];
};

#endif
