/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
// string tokenizer
// based on code by Song Ho Ahn (song.ahn@gmail.com)

#ifndef TOKENIZER_H
#define TOKENIZER_H

#include <string>
#include <vector>

const std::string DEFAULT_DELIMITER = " ";

struct tokenizer {

  tokenizer();
  tokenizer(const std::string& s, const std::string& d=DEFAULT_DELIMITER);
  tokenizer (const std::vector<std::string>& tokens);

  tokenizer& operator>> (std::string& s);
  tokenizer& operator>> (float& f);
  tokenizer& operator>> (int& i);
  tokenizer& operator>> (char& c);

  std::vector<std::string> tokens;
  int tokens_available;
  unsigned int tokid;

  std::string delimiter;
  std::string buffer;
  int blen, dlen;
  void str (const std::string& s);
  void del (const std::string& d);
  void vec (const std::vector<std::string>& v);
  void set (const std::string& s, const std::string& d=DEFAULT_DELIMITER);
  bool isdelim (char c);

  void skip_ws ();

  int cur;
  void init_cur ();

  std::string cur2end ();

  std::string token;

};

#endif
