# CamiTK Changelog (from git log analysis)

This changelog summarizes the major and minor changes since the last published version (5.2.0).

## Summary of Major Changes

*   **New Extension Generator**: A new tool to simplify the creation of CamiTK extensions from a single configuration file.
*   **Transformation Framework Overhaul**: A complete redesign of the transformation and coordinate system management.
*   **Action Creation GUI**: A new graphical user interface to create and manage actions within extensions.
*   **C++20/C++23 Support**: CamiTK now supports modern C++ standards.
*   **New `.camitk` File Format**: A new file format for defining extensions and actions.
*   **New Actions**: Added "Crop Volume" and "Threshold Segmentation" actions.
*   **TransformationExplorer Viewer**: A new viewer for transformations.
*   **API Simplifications**: The Property/Action API has been simplified.
*   **GUI Improvements**: Improved user interface for the extension generator and action management.
*   **Build System Improvements**: CMake improvements to avoid unnecessary rebuilds and better dependency management.

## Detailed Major Changes

### 1. New Extension Generator

A new command-line tool, `extensiongenerator`, has been introduced to streamline the creation of CamiTK extensions. This tool uses a `.camitk` configuration file to automatically generate the necessary C++ source code for actions and extensions. This new workflow simplifies the development process and reduces boilerplate code.

### 2. Transformation Framework Overhaul

The transformation and coordinate system management has been completely redesigned. This includes the introduction of new classes like `FrameOfReference`, `Transformation`, and `TransformationManager`. This new framework provides a more robust and flexible way to handle geometric transformations and coordinate systems, which is crucial for medical imaging and 3D visualization applications.

### 3. Action Creation GUI

A new graphical user interface has been added to the `extensiongenerator` to simplify the creation and management of actions within extensions. This GUI allows developers to add, remove, and configure actions without manually editing configuration files.

### 4. C++20/C++23 Support

CamiTK has been updated to support the C++20 and C++23 standards. This allows developers to use modern C++ features, which can lead to cleaner, more efficient, and more maintainable code.

### 5. New `.camitk` File Format

A new JSON-based file format, `.camitk`, has been introduced to define the structure and properties of CamiTK extensions and actions. This file format is used by the new `extensiongenerator` to automatically generate the corresponding C++ code.

## Detailed Minor Changes

*   **New Actions**:
    *   The "Crop Volume" action (formerly "Box Volume Of Interest") has been reimplemented using the new extension generator.
    *   A new "Threshold Segmentation" action has been added, implemented using only VTK and the new `.camitk` description file.
*   **TransformationExplorer Viewer**: A new viewer has been added to visualize and debug transformations and coordinate systems.
*   **API Simplifications**: The Property/Action API has been simplified to make it easier to use and more consistent.
*   **GUI Improvements**: The user interface for the extension generator and action management has been improved for a better user experience.
*   **Build System Improvements**: The CMake build system has been improved to avoid unnecessary rebuilds and to better manage dependencies, especially for the new `extensiongenerator`.
*   **Bug Fixes and Refactoring**: Numerous bug fixes, code cleanups, and refactoring have been done to improve the stability and maintainability of the codebase.
*   **Documentation**: The documentation has been updated to reflect the latest changes, including new man pages for the `extensiongenerator` and design documents for the new transformation framework.
