#ifndef AVIFILE_AUDIOCLEANER_H
#define AVIFILE_AUDIOCLEANER_H

#include "avm_default.h"
#include "formats.h"
#include <string.h>

AVM_BEGIN_NAMESPACE;

class IAudioCleaner
{
protected:
    static const size_t CLEARED_SAMPLES = 32;
    size_t m_uiClearSize;
    size_t m_uiRemains;
public:
    IAudioCleaner(size_t clear) : m_uiClearSize(clear), m_uiRemains(0) {}
    virtual ~IAudioCleaner() {}
    virtual size_t soundOff(void* out, const void* in) = 0;
    virtual size_t soundOn(void* out, size_t n) = 0;
};

template <class T> class AudioCleanerStereo : public IAudioCleaner
{
public:
    AudioCleanerStereo(size_t clear) : IAudioCleaner(clear) {}
    virtual size_t soundOff(void* out, const void* in);
    virtual size_t soundOn(void* out, size_t n);
};

template <class T> class AudioCleanerMono : public IAudioCleaner
{
public:
    AudioCleanerMono(size_t clear) : IAudioCleaner(clear) {}
    virtual size_t soundOff(void* out, const void* in);
    virtual size_t soundOn(void* out, size_t n);
};

IAudioCleaner* CreateAudioCleaner(uint_t channels,
				  uint_t bitsPerSample,
				  size_t clearsz);

AVM_END_NAMESPACE;

#endif // AVIFILE_AUDIOCLEANER_H
