/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:43:39 GMT 2018
 */

package uk.ac.sanger.artemis.chado;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JPasswordField;
import javax.swing.text.DefaultStyledDocument;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import org.postgresql.util.PSQLException;
import uk.ac.sanger.artemis.chado.JdbcDAO;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class JdbcDAO_ESTest extends JdbcDAO_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField("C");
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("db_id", jPasswordField0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument();
      JPasswordField jPasswordField0 = new JPasswordField(defaultStyledDocument0, "Rgg*%4\"?,2n7F;M", 1004);
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO((String) null, jPasswordField0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.DatabaseLocationParser", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField();
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("comm+:n_nme", jPasswordField0);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // No suitable driver found for comm+:n_nme
         //
         verifyException("java.sql.DriverManager", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          DefaultStyledDocument defaultStyledDocument0 = new DefaultStyledDocument();
          JPasswordField jPasswordField0 = new JPasswordField(defaultStyledDocument0, "GlaeS_YN]", 2);
          JdbcDAO jdbcDAO0 = null;
          try {
            jdbcDAO0 = new JdbcDAO("GlaeS_YN]", jPasswordField0);
            fail("Expecting exception: PSQLException");
          
          } catch(Throwable e) {
             //
             // Something unusual has occurred to cause the driver to fail. Please report this exception.
             //
             verifyException("org.postgresql.Driver", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      JdbcDAO jdbcDAO0 = null;
      try {
        jdbcDAO0 = new JdbcDAO("", (JPasswordField) null);
        fail("Expecting exception: SQLException");
      
      } catch(Throwable e) {
         //
         // No suitable driver found for 
         //
         verifyException("java.sql.DriverManager", e);
      }
  }
}
