/*
 * Copyright (c) 2019-2020 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifdef __ARM_FEATURE_SVE

#include "../../bfloat.hpp"
#include "../../asmlib.hpp"

namespace arm_gemm {

void sve_interleaved_bf16fp32_dot_3VLx8(const bfloat16 *Apanel, const bfloat16 *Bpanel, float *Cpanel, int ablocks, int bblocks, int K) {
    const bfloat16 *a_ptr = Apanel;
    float *c_ptr = Cpanel;

    K /= 2;
    const long loops_count = (K / 2) - 1;
    const long tails_count = K % 2;

    for (int yb=0; yb<ablocks; yb++) {
        const bfloat16 *a_ptr0 = a_ptr;
        const bfloat16 *b_ptr = Bpanel;

        for (int xb=0; xb<bblocks; xb++) {
            a_ptr = a_ptr0;
            long loops = loops_count;
            long tails = tails_count;

            __asm __volatile (
                "mov z8.s, #0\n"
                "ptrue p0.h\n"
                "mov z9.s, #0\n"
                "mov z10.s, #0\n"
                "mov z11.s, #0\n"
                "ld1rqh z0.h, p0/z, [%[a_ptr]]\n"
                "mov z12.s, #0\n"
                "ld1h z4.h, p0/z, [%[b_ptr]]\n"
                "mov z13.s, #0\n"
                "ld1rqh z1.h, p0/z, [%[a_ptr], #0x10]\n"
                "mov z14.s, #0\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #1, MUL VL]\n"
                "mov z15.s, #0\n"
                "ld1rqh z2.h, p0/z, [%[a_ptr], #0x20]\n"
                "mov z16.s, #0\n"
                "add %[a_ptr], %[a_ptr], #0x40\n"
                "mov z17.s, #0\n"
                "addvl %[b_ptr], %[b_ptr], #3\n"
                "mov z18.s, #0\n"
                "mov z19.s, #0\n"
                "mov z20.s, #0\n"
                "mov z21.s, #0\n"
                "mov z22.s, #0\n"
                "mov z23.s, #0\n"
                "mov z24.s, #0\n"
                "mov z25.s, #0\n"
                "mov z26.s, #0\n"
                "mov z27.s, #0\n"
                "mov z28.s, #0\n"
                "mov z29.s, #0\n"
                "mov z30.s, #0\n"
                "mov z31.s, #0\n"
                "cbz %[loops], 1f\n"
                "2:\n"
                ".inst 0x64604088 // bfdot z8.s, z4.h, z0.h[0]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                ".inst 0x64684089 // bfdot z9.s, z4.h, z0.h[1]\n"
                "ld1rqh z3.h, p0/z, [%[a_ptr], #-0x10]\n"
                ".inst 0x6470408a // bfdot z10.s, z4.h, z0.h[2]\n"
                "subs %[loops], %[loops], #0x1\n"
                ".inst 0x6478408b // bfdot z11.s, z4.h, z0.h[3]\n"
                ".inst 0x64614094 // bfdot z20.s, z4.h, z1.h[0]\n"
                ".inst 0x64694095 // bfdot z21.s, z4.h, z1.h[1]\n"
                ".inst 0x64714096 // bfdot z22.s, z4.h, z1.h[2]\n"
                ".inst 0x64794097 // bfdot z23.s, z4.h, z1.h[3]\n"
                "ld1h z4.h, p0/z, [%[b_ptr]]\n"
                ".inst 0x646040ac // bfdot z12.s, z5.h, z0.h[0]\n"
                ".inst 0x646840ad // bfdot z13.s, z5.h, z0.h[1]\n"
                ".inst 0x647040ae // bfdot z14.s, z5.h, z0.h[2]\n"
                ".inst 0x647840af // bfdot z15.s, z5.h, z0.h[3]\n"
                ".inst 0x646140b8 // bfdot z24.s, z5.h, z1.h[0]\n"
                ".inst 0x646940b9 // bfdot z25.s, z5.h, z1.h[1]\n"
                ".inst 0x647140ba // bfdot z26.s, z5.h, z1.h[2]\n"
                ".inst 0x647940bb // bfdot z27.s, z5.h, z1.h[3]\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #1, MUL VL]\n"
                ".inst 0x646040d0 // bfdot z16.s, z6.h, z0.h[0]\n"
                ".inst 0x646840d1 // bfdot z17.s, z6.h, z0.h[1]\n"
                ".inst 0x647040d2 // bfdot z18.s, z6.h, z0.h[2]\n"
                ".inst 0x647840d3 // bfdot z19.s, z6.h, z0.h[3]\n"
                "ld1rqh z0.h, p0/z, [%[a_ptr]]\n"
                ".inst 0x646140dc // bfdot z28.s, z6.h, z1.h[0]\n"
                ".inst 0x646940dd // bfdot z29.s, z6.h, z1.h[1]\n"
                ".inst 0x647140de // bfdot z30.s, z6.h, z1.h[2]\n"
                ".inst 0x647940df // bfdot z31.s, z6.h, z1.h[3]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #2, MUL VL]\n"
                ".inst 0x64624088 // bfdot z8.s, z4.h, z2.h[0]\n"
                "ld1rqh z1.h, p0/z, [%[a_ptr], #0x10]\n"
                ".inst 0x646a4089 // bfdot z9.s, z4.h, z2.h[1]\n"
                "add %[a_ptr], %[a_ptr], #0x40\n"
                ".inst 0x6472408a // bfdot z10.s, z4.h, z2.h[2]\n"
                "addvl %[b_ptr], %[b_ptr], #6\n"
                ".inst 0x647a408b // bfdot z11.s, z4.h, z2.h[3]\n"
                ".inst 0x64634094 // bfdot z20.s, z4.h, z3.h[0]\n"
                ".inst 0x646b4095 // bfdot z21.s, z4.h, z3.h[1]\n"
                ".inst 0x64734096 // bfdot z22.s, z4.h, z3.h[2]\n"
                ".inst 0x647b4097 // bfdot z23.s, z4.h, z3.h[3]\n"
                "ld1h z4.h, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                ".inst 0x646240ac // bfdot z12.s, z5.h, z2.h[0]\n"
                ".inst 0x646a40ad // bfdot z13.s, z5.h, z2.h[1]\n"
                ".inst 0x647240ae // bfdot z14.s, z5.h, z2.h[2]\n"
                ".inst 0x647a40af // bfdot z15.s, z5.h, z2.h[3]\n"
                ".inst 0x646340b8 // bfdot z24.s, z5.h, z3.h[0]\n"
                ".inst 0x646b40b9 // bfdot z25.s, z5.h, z3.h[1]\n"
                ".inst 0x647340ba // bfdot z26.s, z5.h, z3.h[2]\n"
                ".inst 0x647b40bb // bfdot z27.s, z5.h, z3.h[3]\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                ".inst 0x646240d0 // bfdot z16.s, z6.h, z2.h[0]\n"
                ".inst 0x646a40d1 // bfdot z17.s, z6.h, z2.h[1]\n"
                ".inst 0x647240d2 // bfdot z18.s, z6.h, z2.h[2]\n"
                ".inst 0x647a40d3 // bfdot z19.s, z6.h, z2.h[3]\n"
                "ld1rqh z2.h, p0/z, [%[a_ptr], #-0x20]\n"
                ".inst 0x646340dc // bfdot z28.s, z6.h, z3.h[0]\n"
                ".inst 0x646b40dd // bfdot z29.s, z6.h, z3.h[1]\n"
                ".inst 0x647340de // bfdot z30.s, z6.h, z3.h[2]\n"
                ".inst 0x647b40df // bfdot z31.s, z6.h, z3.h[3]\n"
                "b.ne 2b\n"
                "1:\n"
                "cbz %[tails], 3f\n"
                ".inst 0x64604088 // bfdot z8.s, z4.h, z0.h[0]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                ".inst 0x64684089 // bfdot z9.s, z4.h, z0.h[1]\n"
                "ld1rqh z3.h, p0/z, [%[a_ptr], #-0x10]\n"
                ".inst 0x6470408a // bfdot z10.s, z4.h, z0.h[2]\n"
                ".inst 0x6478408b // bfdot z11.s, z4.h, z0.h[3]\n"
                ".inst 0x64614094 // bfdot z20.s, z4.h, z1.h[0]\n"
                ".inst 0x64694095 // bfdot z21.s, z4.h, z1.h[1]\n"
                ".inst 0x64714096 // bfdot z22.s, z4.h, z1.h[2]\n"
                ".inst 0x64794097 // bfdot z23.s, z4.h, z1.h[3]\n"
                "ld1h z4.h, p0/z, [%[b_ptr]]\n"
                ".inst 0x646040ac // bfdot z12.s, z5.h, z0.h[0]\n"
                ".inst 0x646840ad // bfdot z13.s, z5.h, z0.h[1]\n"
                ".inst 0x647040ae // bfdot z14.s, z5.h, z0.h[2]\n"
                ".inst 0x647840af // bfdot z15.s, z5.h, z0.h[3]\n"
                ".inst 0x646140b8 // bfdot z24.s, z5.h, z1.h[0]\n"
                ".inst 0x646940b9 // bfdot z25.s, z5.h, z1.h[1]\n"
                ".inst 0x647140ba // bfdot z26.s, z5.h, z1.h[2]\n"
                ".inst 0x647940bb // bfdot z27.s, z5.h, z1.h[3]\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #1, MUL VL]\n"
                ".inst 0x646040d0 // bfdot z16.s, z6.h, z0.h[0]\n"
                ".inst 0x646840d1 // bfdot z17.s, z6.h, z0.h[1]\n"
                ".inst 0x647040d2 // bfdot z18.s, z6.h, z0.h[2]\n"
                ".inst 0x647840d3 // bfdot z19.s, z6.h, z0.h[3]\n"
                "ld1rqh z0.h, p0/z, [%[a_ptr]]\n"
                ".inst 0x646140dc // bfdot z28.s, z6.h, z1.h[0]\n"
                ".inst 0x646940dd // bfdot z29.s, z6.h, z1.h[1]\n"
                ".inst 0x647140de // bfdot z30.s, z6.h, z1.h[2]\n"
                ".inst 0x647940df // bfdot z31.s, z6.h, z1.h[3]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #2, MUL VL]\n"
                ".inst 0x64624088 // bfdot z8.s, z4.h, z2.h[0]\n"
                "ld1rqh z1.h, p0/z, [%[a_ptr], #0x10]\n"
                ".inst 0x646a4089 // bfdot z9.s, z4.h, z2.h[1]\n"
                "add %[a_ptr], %[a_ptr], #0x20\n"
                ".inst 0x6472408a // bfdot z10.s, z4.h, z2.h[2]\n"
                "addvl %[b_ptr], %[b_ptr], #6\n"
                ".inst 0x647a408b // bfdot z11.s, z4.h, z2.h[3]\n"
                ".inst 0x64634094 // bfdot z20.s, z4.h, z3.h[0]\n"
                ".inst 0x646b4095 // bfdot z21.s, z4.h, z3.h[1]\n"
                ".inst 0x64734096 // bfdot z22.s, z4.h, z3.h[2]\n"
                ".inst 0x647b4097 // bfdot z23.s, z4.h, z3.h[3]\n"
                "ld1h z4.h, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                ".inst 0x646240ac // bfdot z12.s, z5.h, z2.h[0]\n"
                ".inst 0x646a40ad // bfdot z13.s, z5.h, z2.h[1]\n"
                ".inst 0x647240ae // bfdot z14.s, z5.h, z2.h[2]\n"
                ".inst 0x647a40af // bfdot z15.s, z5.h, z2.h[3]\n"
                ".inst 0x646340b8 // bfdot z24.s, z5.h, z3.h[0]\n"
                ".inst 0x646b40b9 // bfdot z25.s, z5.h, z3.h[1]\n"
                ".inst 0x647340ba // bfdot z26.s, z5.h, z3.h[2]\n"
                ".inst 0x647b40bb // bfdot z27.s, z5.h, z3.h[3]\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                ".inst 0x646240d0 // bfdot z16.s, z6.h, z2.h[0]\n"
                ".inst 0x646a40d1 // bfdot z17.s, z6.h, z2.h[1]\n"
                ".inst 0x647240d2 // bfdot z18.s, z6.h, z2.h[2]\n"
                ".inst 0x647a40d3 // bfdot z19.s, z6.h, z2.h[3]\n"
                ".inst 0x646340dc // bfdot z28.s, z6.h, z3.h[0]\n"
                ".inst 0x646b40dd // bfdot z29.s, z6.h, z3.h[1]\n"
                ".inst 0x647340de // bfdot z30.s, z6.h, z3.h[2]\n"
                ".inst 0x647b40df // bfdot z31.s, z6.h, z3.h[3]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                ".inst 0x64604088 // bfdot z8.s, z4.h, z0.h[0]\n"
                ".inst 0x64684089 // bfdot z9.s, z4.h, z0.h[1]\n"
                ".inst 0x6470408a // bfdot z10.s, z4.h, z0.h[2]\n"
                ".inst 0x6478408b // bfdot z11.s, z4.h, z0.h[3]\n"
                "st1w z8.s, p0, [%[c_ptr]]\n"
                ".inst 0x64614094 // bfdot z20.s, z4.h, z1.h[0]\n"
                ".inst 0x64694095 // bfdot z21.s, z4.h, z1.h[1]\n"
                ".inst 0x64714096 // bfdot z22.s, z4.h, z1.h[2]\n"
                ".inst 0x64794097 // bfdot z23.s, z4.h, z1.h[3]\n"
                ".inst 0x646040ac // bfdot z12.s, z5.h, z0.h[0]\n"
                ".inst 0x646840ad // bfdot z13.s, z5.h, z0.h[1]\n"
                ".inst 0x647040ae // bfdot z14.s, z5.h, z0.h[2]\n"
                ".inst 0x647840af // bfdot z15.s, z5.h, z0.h[3]\n"
                "st1w z12.s, p0, [%[c_ptr], #1, MUL VL]\n"
                ".inst 0x646140b8 // bfdot z24.s, z5.h, z1.h[0]\n"
                ".inst 0x646940b9 // bfdot z25.s, z5.h, z1.h[1]\n"
                ".inst 0x647140ba // bfdot z26.s, z5.h, z1.h[2]\n"
                ".inst 0x647940bb // bfdot z27.s, z5.h, z1.h[3]\n"
                ".inst 0x646040d0 // bfdot z16.s, z6.h, z0.h[0]\n"
                ".inst 0x646840d1 // bfdot z17.s, z6.h, z0.h[1]\n"
                ".inst 0x647040d2 // bfdot z18.s, z6.h, z0.h[2]\n"
                ".inst 0x647840d3 // bfdot z19.s, z6.h, z0.h[3]\n"
                "st1w z16.s, p0, [%[c_ptr], #2, MUL VL]\n"
                ".inst 0x646140dc // bfdot z28.s, z6.h, z1.h[0]\n"
                ".inst 0x646940dd // bfdot z29.s, z6.h, z1.h[1]\n"
                ".inst 0x647140de // bfdot z30.s, z6.h, z1.h[2]\n"
                "st1w z9.s, p0, [%[c_ptr], #3, MUL VL]\n"
                ".inst 0x647940df // bfdot z31.s, z6.h, z1.h[3]\n"
                "b 4f\n"
                "3:\n"
                ".inst 0x64604088 // bfdot z8.s, z4.h, z0.h[0]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                ".inst 0x64684089 // bfdot z9.s, z4.h, z0.h[1]\n"
                "ld1rqh z3.h, p0/z, [%[a_ptr], #-0x10]\n"
                ".inst 0x6470408a // bfdot z10.s, z4.h, z0.h[2]\n"
                "addvl %[b_ptr], %[b_ptr], #3\n"
                ".inst 0x6478408b // bfdot z11.s, z4.h, z0.h[3]\n"
                ".inst 0x64614094 // bfdot z20.s, z4.h, z1.h[0]\n"
                ".inst 0x64694095 // bfdot z21.s, z4.h, z1.h[1]\n"
                ".inst 0x64714096 // bfdot z22.s, z4.h, z1.h[2]\n"
                ".inst 0x64794097 // bfdot z23.s, z4.h, z1.h[3]\n"
                "ld1h z4.h, p0/z, [%[b_ptr], #-3, MUL VL]\n"
                ".inst 0x646040ac // bfdot z12.s, z5.h, z0.h[0]\n"
                ".inst 0x646840ad // bfdot z13.s, z5.h, z0.h[1]\n"
                ".inst 0x647040ae // bfdot z14.s, z5.h, z0.h[2]\n"
                ".inst 0x647840af // bfdot z15.s, z5.h, z0.h[3]\n"
                ".inst 0x646140b8 // bfdot z24.s, z5.h, z1.h[0]\n"
                ".inst 0x646940b9 // bfdot z25.s, z5.h, z1.h[1]\n"
                ".inst 0x647140ba // bfdot z26.s, z5.h, z1.h[2]\n"
                ".inst 0x647940bb // bfdot z27.s, z5.h, z1.h[3]\n"
                "ld1h z5.h, p0/z, [%[b_ptr], #-2, MUL VL]\n"
                ".inst 0x646040d0 // bfdot z16.s, z6.h, z0.h[0]\n"
                ".inst 0x646840d1 // bfdot z17.s, z6.h, z0.h[1]\n"
                ".inst 0x647040d2 // bfdot z18.s, z6.h, z0.h[2]\n"
                ".inst 0x647840d3 // bfdot z19.s, z6.h, z0.h[3]\n"
                ".inst 0x646140dc // bfdot z28.s, z6.h, z1.h[0]\n"
                ".inst 0x646940dd // bfdot z29.s, z6.h, z1.h[1]\n"
                ".inst 0x647140de // bfdot z30.s, z6.h, z1.h[2]\n"
                ".inst 0x647940df // bfdot z31.s, z6.h, z1.h[3]\n"
                "ld1h z6.h, p0/z, [%[b_ptr], #-1, MUL VL]\n"
                ".inst 0x64624088 // bfdot z8.s, z4.h, z2.h[0]\n"
                ".inst 0x646a4089 // bfdot z9.s, z4.h, z2.h[1]\n"
                ".inst 0x6472408a // bfdot z10.s, z4.h, z2.h[2]\n"
                ".inst 0x647a408b // bfdot z11.s, z4.h, z2.h[3]\n"
                "st1w z8.s, p0, [%[c_ptr]]\n"
                ".inst 0x64634094 // bfdot z20.s, z4.h, z3.h[0]\n"
                ".inst 0x646b4095 // bfdot z21.s, z4.h, z3.h[1]\n"
                ".inst 0x64734096 // bfdot z22.s, z4.h, z3.h[2]\n"
                ".inst 0x647b4097 // bfdot z23.s, z4.h, z3.h[3]\n"
                ".inst 0x646240ac // bfdot z12.s, z5.h, z2.h[0]\n"
                ".inst 0x646a40ad // bfdot z13.s, z5.h, z2.h[1]\n"
                ".inst 0x647240ae // bfdot z14.s, z5.h, z2.h[2]\n"
                ".inst 0x647a40af // bfdot z15.s, z5.h, z2.h[3]\n"
                "st1w z12.s, p0, [%[c_ptr], #1, MUL VL]\n"
                ".inst 0x646340b8 // bfdot z24.s, z5.h, z3.h[0]\n"
                ".inst 0x646b40b9 // bfdot z25.s, z5.h, z3.h[1]\n"
                ".inst 0x647340ba // bfdot z26.s, z5.h, z3.h[2]\n"
                ".inst 0x647b40bb // bfdot z27.s, z5.h, z3.h[3]\n"
                ".inst 0x646240d0 // bfdot z16.s, z6.h, z2.h[0]\n"
                ".inst 0x646a40d1 // bfdot z17.s, z6.h, z2.h[1]\n"
                ".inst 0x647240d2 // bfdot z18.s, z6.h, z2.h[2]\n"
                ".inst 0x647a40d3 // bfdot z19.s, z6.h, z2.h[3]\n"
                "st1w z16.s, p0, [%[c_ptr], #2, MUL VL]\n"
                ".inst 0x646340dc // bfdot z28.s, z6.h, z3.h[0]\n"
                ".inst 0x646b40dd // bfdot z29.s, z6.h, z3.h[1]\n"
                ".inst 0x647340de // bfdot z30.s, z6.h, z3.h[2]\n"
                "st1w z9.s, p0, [%[c_ptr], #3, MUL VL]\n"
                ".inst 0x647b40df // bfdot z31.s, z6.h, z3.h[3]\n"
                "4:\n"
                "st1w z13.s, p0, [%[c_ptr], #4, MUL VL]\n"
                "st1w z17.s, p0, [%[c_ptr], #5, MUL VL]\n"
                "st1w z10.s, p0, [%[c_ptr], #6, MUL VL]\n"
                "st1w z14.s, p0, [%[c_ptr], #7, MUL VL]\n"
                "addvl %[c_ptr], %[c_ptr], #16\n"
                "st1w z18.s, p0, [%[c_ptr], #-8, MUL VL]\n"
                "st1w z11.s, p0, [%[c_ptr], #-7, MUL VL]\n"
                "st1w z15.s, p0, [%[c_ptr], #-6, MUL VL]\n"
                "st1w z19.s, p0, [%[c_ptr], #-5, MUL VL]\n"
                "st1w z20.s, p0, [%[c_ptr], #-4, MUL VL]\n"
                "st1w z24.s, p0, [%[c_ptr], #-3, MUL VL]\n"
                "st1w z28.s, p0, [%[c_ptr], #-2, MUL VL]\n"
                "st1w z21.s, p0, [%[c_ptr], #-1, MUL VL]\n"
                "st1w z25.s, p0, [%[c_ptr]]\n"
                "st1w z29.s, p0, [%[c_ptr], #1, MUL VL]\n"
                "st1w z22.s, p0, [%[c_ptr], #2, MUL VL]\n"
                "st1w z26.s, p0, [%[c_ptr], #3, MUL VL]\n"
                "st1w z30.s, p0, [%[c_ptr], #4, MUL VL]\n"
                "st1w z23.s, p0, [%[c_ptr], #5, MUL VL]\n"
                "st1w z27.s, p0, [%[c_ptr], #6, MUL VL]\n"
                "st1w z31.s, p0, [%[c_ptr], #7, MUL VL]\n"
                "addvl %[c_ptr], %[c_ptr], #8\n"
            : [a_ptr] "+r" (a_ptr), [b_ptr] "+r" (b_ptr), [c_ptr] "+r" (c_ptr),
              [loops] "+r" (loops), [tails] "+r" (tails)
            :
            : "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31", "cc", "memory"
            );
        }
    }
}

} // namespace arm_gemm

#endif // __ARM_FEATURE_SVE
