#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Celeste
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250630.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='celeste'
GAME_NAME='Celeste'

ARCHIVE_BASE_1_NAME='celeste-linux.zip'
ARCHIVE_BASE_1_MD5='518ea69d60079109a2575d428eff8a53'
ARCHIVE_BASE_1_SIZE='1176905'
ARCHIVE_BASE_1_VERSION='1.4.0.0-itch.2021.03.29'
ARCHIVE_BASE_1_URL='https://maddymakesgamesinc.itch.io/celeste'

ARCHIVE_BASE_0_NAME='celeste-linux.zip'
ARCHIVE_BASE_0_MD5='b27c983b95b2a2a35a272b7ecd94cbc2'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='1.3.1.2-itch'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_FILES='
libfmod*.so*
libmojoshader.so
libFNA3D.so.0'
CONTENT_LIBS_LIBS64_RELATIVE_PATH='lib64'
CONTENT_LIBS_LIBS64_FILES="$CONTENT_LIBS_FILES"
CONTENT_LIBS_LIBS32_RELATIVE_PATH='lib'
CONTENT_LIBS_LIBS32_FILES="$CONTENT_LIBS_FILES"
CONTENT_GAME_MAIN_FILES='
Content
Celeste.exe
Celeste.exe.config
Celeste.png
gamecontrollerdb.txt
Celeste.Content.dll
FNA.dll
FNA.dll.config
FNA3D.dll'

APP_MAIN_EXE='Celeste.exe'
APP_MAIN_ICON='Celeste.png'

PACKAGES_LIST='
PKG_MAIN
PKG_LIBS64
PKG_LIBS32'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_LIBS'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libGL.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll
System.Xml.Linq.dll'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS64_ID="$PKG_LIBS_ID"
PKG_LIBS32_ID="$PKG_LIBS_ID"
PKG_LIBS64_ARCH='64'
PKG_LIBS32_ARCH='32'
PKG_LIBS_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'
PKG_LIBS64_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"
PKG_LIBS32_DEPENDENCIES_LIBRARIES="$PKG_LIBS_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

## This game expects an executable stack through dynamically loaded libraries.
game_exec_line() {
	cat <<- 'EOF'
	GLIBC_TUNABLES=glibc.rtld.execstack=2 mono Celeste.exe "$@"
	EOF
}

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
